#!/bin/bash
# Version: 1.1 - 2025
# Konfiguration: Anfang
DICTIONARY_PATH='./de-en.txt'
MIN_CHAR_COUNT=1
MAX_CHAR_COUNT=128
HEAD_LINE_A='WOERTERBUCH DE <-> EN'
FEED_LINE_A="Geben Sie ein Suchwort ein (${MIN_CHAR_COUNT} bis ${MAX_CHAR_COUNT} Zeichen):"
FEED_LINE_B="Geben Sie ein Suchwort ein (QQ .. Suche beenden):"
RESULT_A=' Das Suchwort wurde NICHT gefunden!!'
RESULT_B=' Die Suchworte (2 bis 4) wurden in einer gemeinsamen Zeile NICHT gefunden!!'
PROGRAM_TEST_INFO=' HINWEIS: Bei FALSE ist das entsprechende Programm noch zu installieren.'
PROGRAM_STOP=' Das Programm wurde abgebrochen!!'
if [ "${1}" = "more" ]
then
  MAX_SEARCH_RESULTS=1000
  READER=$1
else
  MAX_SEARCH_RESULTS=100
  READER=''
fi
# Konfiguration: Ende
#
# Test: notwendige Programme
declare -a PROGRAM_ARRAY
PROGRAM_ARRAY=(which grep more wc tr cut)
PROGRAM_ARRAY_COUNT=${#PROGRAM_ARRAY[@]}
TEST_FALSE=${TEST_FALSE:-0}
TEST_MESSAGE="\n\t\tPROGRAMM-TESTER\n\n"
START=0
STOP=0
STEP=0
Q=0
START=${START:+0}
STOP=${STOP:+$PROGRAM_ARRAY_COUNT}
STEP=${STEP:+1}
Q=${Q:+$START}
while [ $Q -lt $STOP ]
do
RESULT=$(which ${PROGRAM_ARRAY[$Q]} | grep -c "^.*/${PROGRAM_ARRAY[$Q]}$")
  if [ ${RESULT} -eq 1 ]
  then
    TEST_MESSAGE="${TEST_MESSAGE}\t${PROGRAM_ARRAY[$Q]} ... OK\n"
  else
    TEST_MESSAGE="${TEST_MESSAGE}\t${PROGRAM_ARRAY[$Q]} ... FALSE\n"
    TEST_FALSE=${TEST_FALSE:+1}
  fi
Q=$[$Q+$STEP]
done
if [ $TEST_FALSE -ge 1 ]
then
# Info: fehlende Programme anzeigen
  echo -e "${TEST_MESSAGE}"
  echo -e "${PROGRAM_TEST_INFO}\n"
  exit 1
fi
#
# Benutzermenue: Anfang
echo -e "\n\t\t ${HEAD_LINE_A}\n\n"
echo ""
echo -n "${FEED_LINE_A} "
# Benutzermenue: Ende
#
START=0
STOP=3
STEP=1
Q=0
while [ $Q -lt $STOP ]
do
  Q=$[$Q+$STEP]
  read SEARCH_WORD
  if [ $(echo "${SEARCH_WORD}" | grep -c "^[qQ]\{2\}$") -eq 1 ]
  then
    Q=$[$Q+$STOP]
  elif [ ${#SEARCH_WORD} -lt ${MIN_CHAR_COUNT} ] || [ ${#SEARCH_WORD} -gt ${MAX_CHAR_COUNT} ]
  then
    if [ $Q -lt $STOP ]
    then
    echo -n "${FEED_LINE_A} "
    fi
    if [ ${Q} -ge ${STOP} ]
    then
    echo -e "\n${PROGRAM_STOP}\n"
    exit 1
    fi
  elif [ "${SEARCH_WORD}" != '' ]
  then
    echo ""
    if [ "${READER}" = "more" ]
    then
    # bis 1000 Suchergebnisse durch more anzeigen
      if [ $(echo "${SEARCH_WORD}" | grep -c "^[$]\{2\}") -eq 1 ]
      then
      # englische Wortsuche
        SEARCH_WORD=${SEARCH_WORD#\$\$}
        # Suche wird nur fuer eine Benutzer-Information verwendet
        RESULT_TMP=$(grep -i --max-count=1 --color=never "^.*[:]\{2\}.*${SEARCH_WORD}.*" ${DICTIONARY_PATH})
        if [ $? -ge 1 ]
        then
        echo "${RESULT_A}"
        else
        # Suchergebnis wird an more uebergeben
        grep -i --max-count=${MAX_SEARCH_RESULTS} --color=never "^.*[:]\{2\}.*${SEARCH_WORD}.*" ${DICTIONARY_PATH} | more
        fi
        RESULT_TMP=''
      elif [ $(echo "${SEARCH_WORD}" | grep -c "^[$]\{1\}") -eq 1 ]
      then
      # deutsche Wortsuche
        SEARCH_WORD=${SEARCH_WORD#\$}
        # Suche wird nur fuer eine Benutzer-Information verwendet
        RESULT_TMP=$(grep -i --max-count=1 --color=never "^.*${SEARCH_WORD}.*[:]\{2\}" ${DICTIONARY_PATH})
        if [ $? -ge 1 ]
        then
        echo "${RESULT_A}"
        else
        # Suchergebnis wird an more uebergeben
        grep -i --max-count=${MAX_SEARCH_RESULTS} --color=never "^.*${SEARCH_WORD}.*[:]\{2\}" ${DICTIONARY_PATH} | more
        fi
        RESULT_TMP=''
      elif [ $(echo "${SEARCH_WORD}" | wc -w) -ge 2 ]
      then
      # UND-Verknuepfung von 2 bis 4 Worten, Suche in der gesamten Zeile
        SEARCH_WORD=$(echo "${SEARCH_WORD}" | tr -s [:blank:])
        if [ $(echo "${SEARCH_WORD}" | wc -w) -eq 2 ]
        then
          SEARCH_WORD_1=$(echo "${SEARCH_WORD}" | cut -d " " -f 1)
          SEARCH_WORD_2=$(echo "${SEARCH_WORD}" | cut -d " " -f 2)
          # Suche wird nur fuer eine Benutzer-Information verwendet
          RESULT_TMP_A=$(grep -i --max-count=1 --color=never "\(${SEARCH_WORD_1} ${SEARCH_WORD_2}\|${SEARCH_WORD_2} ${SEARCH_WORD_1}\)" ${DICTIONARY_PATH})
          if [ $? -ge 1 ]
          then
            # Suche wird nur fuer eine Benutzer-Information verwendet
            RESULT_TMP_B=$(grep -i --max-count=1 --color=never "\(${SEARCH_WORD_1}.*${SEARCH_WORD_2}\|${SEARCH_WORD_2}.*${SEARCH_WORD_1}\)" ${DICTIONARY_PATH})
            if [ $? -ge 1 ]
            then
            echo "${RESULT_B}"
            else
            # Suchergebnis wird an more uebergeben
            grep -i --max-count=${MAX_SEARCH_RESULTS} --color=never "\(${SEARCH_WORD_1}.*${SEARCH_WORD_2}\|${SEARCH_WORD_2}.*${SEARCH_WORD_1}\)" ${DICTIONARY_PATH} | more
            fi
            RESULT_TMP_B=''
          else
          # Suchergebnis wird an more uebergeben
          grep -i --max-count=${MAX_SEARCH_RESULTS} --color=always "\(${SEARCH_WORD_1} ${SEARCH_WORD_2}\|${SEARCH_WORD_2} ${SEARCH_WORD_1}\)" ${DICTIONARY_PATH} | more
          fi
          RESULT_TMP_A=''
        elif [ $(echo "${SEARCH_WORD}" | wc -w) -eq 3 ]
        then
          SEARCH_WORD_1=$(echo "${SEARCH_WORD}" | cut -d " " -f 1)
          SEARCH_WORD_2=$(echo "${SEARCH_WORD}" | cut -d " " -f 2)
          SEARCH_WORD_3=$(echo "${SEARCH_WORD}" | cut -d " " -f 3)
          # Suche wird nur fuer eine Benutzer-Information verwendet
          RESULT_TMP_A=$(grep -i --max-count=1 --color=never "\(${SEARCH_WORD_1} ${SEARCH_WORD_2} ${SEARCH_WORD_3}\)" ${DICTIONARY_PATH})
          if [ $? -ge 1 ]
          then
            # Suche wird nur fuer eine Benutzer-Information verwendet
            RESULT_TMP_B=$(grep -i --max-count=1 --color=never "\(${SEARCH_WORD_1}.*${SEARCH_WORD_2}\|${SEARCH_WORD_1}.*${SEARCH_WORD_3}\|${SEARCH_WORD_2}.*${SEARCH_WORD_1}\|${SEARCH_WORD_2}.*${SEARCH_WORD_3}\|${SEARCH_WORD_3}.*${SEARCH_WORD_1}\|${SEARCH_WORD_3}.*${SEARCH_WORD_2}\)" ${DICTIONARY_PATH})
            if [ $? -ge 1 ]
            then
            echo "${RESULT_B}"
            else
            # Suchergebnis wird an more uebergeben
            grep -i --max-count=${MAX_SEARCH_RESULTS} --color=never "\(${SEARCH_WORD_1}.*${SEARCH_WORD_2}\|${SEARCH_WORD_1}.*${SEARCH_WORD_3}\|${SEARCH_WORD_2}.*${SEARCH_WORD_1}\|${SEARCH_WORD_2}.*${SEARCH_WORD_3}\|${SEARCH_WORD_3}.*${SEARCH_WORD_1}\|${SEARCH_WORD_3}.*${SEARCH_WORD_1}\|${SEARCH_WORD_3}.*${SEARCH_WORD_2}\)" ${DICTIONARY_PATH} | more
            fi
            RESULT_TMP_B=''
          else
          # Suchergebnis wird an more uebergeben
          grep -i --max-count=${MAX_SEARCH_RESULTS} --color=always "\(${SEARCH_WORD_1} ${SEARCH_WORD_2} ${SEARCH_WORD_3}\)" ${DICTIONARY_PATH} | more
          fi
          RESULT_TMP_A=''
        elif [ $(echo "${SEARCH_WORD}" | wc -w) -ge 4 ]
        then
          SEARCH_WORD_1=$(echo "${SEARCH_WORD}" | cut -d " " -f 1)
          SEARCH_WORD_2=$(echo "${SEARCH_WORD}" | cut -d " " -f 2)
          SEARCH_WORD_3=$(echo "${SEARCH_WORD}" | cut -d " " -f 3)
          SEARCH_WORD_4=$(echo "${SEARCH_WORD}" | cut -d " " -f 4)
          # Suche wird nur fuer eine Benutzer-Information verwendet
          RESULT_TMP_A=$(grep -i --max-count=1 --color=never "\(${SEARCH_WORD_1} ${SEARCH_WORD_2} ${SEARCH_WORD_3} ${SEARCH_WORD_4}\)" ${DICTIONARY_PATH})
          if [ $? -ge 1 ]
          then
            # Suche wird nur fuer eine Benutzer-Information verwendet
            RESULT_TMP_B=$(grep -i --max-count=1 --color=never "\(${SEARCH_WORD_1}.*${SEARCH_WORD_2}\|${SEARCH_WORD_1}.*${SEARCH_WORD_3}\|${SEARCH_WORD_1}.*${SEARCH_WORD_4}\|${SEARCH_WORD_2}.*${SEARCH_WORD_1}\|${SEARCH_WORD_2}.*${SEARCH_WORD_3}\|${SEARCH_WORD_2}.*${SEARCH_WORD_4}\|${SEARCH_WORD_3}.*${SEARCH_WORD_1}\|${SEARCH_WORD_3}.*${SEARCH_WORD_2}\|${SEARCH_WORD_3}.*${SEARCH_WORD_4}\|${SEARCH_WORD_4}.*${SEARCH_WORD_1}\|${SEARCH_WORD_4}.*${SEARCH_WORD_2}\|${SEARCH_WORD_4}.*${SEARCH_WORD_3}\)" ${DICTIONARY_PATH})
            if [ $? -ge 1 ]
            then
            echo "${RESULT_B}"
            else
            # Suchergebnis wird an more uebergeben
            grep -i --max-count=${MAX_SEARCH_RESULTS} --color=never "\(${SEARCH_WORD_1}.*${SEARCH_WORD_2}\|${SEARCH_WORD_1}.*${SEARCH_WORD_3}\|${SEARCH_WORD_1}.*${SEARCH_WORD_4}\|${SEARCH_WORD_2}.*${SEARCH_WORD_1}\|${SEARCH_WORD_2}.*${SEARCH_WORD_3}\|${SEARCH_WORD_2}.*${SEARCH_WORD_4}\|${SEARCH_WORD_3}.*${SEARCH_WORD_1}\|${SEARCH_WORD_3}.*${SEARCH_WORD_2}\|${SEARCH_WORD_3}.*${SEARCH_WORD_4}\|${SEARCH_WORD_4}.*${SEARCH_WORD_1}\|${SEARCH_WORD_4}.*${SEARCH_WORD_2}\|${SEARCH_WORD_4}.*${SEARCH_WORD_3}\)" ${DICTIONARY_PATH} | more
            fi
            RESULT_TMP_B=''
          else
          # Suchergebnis wird an more uebergeben
          grep -i --max-count=${MAX_SEARCH_RESULTS} --color=always "\(${SEARCH_WORD_1} ${SEARCH_WORD_2} ${SEARCH_WORD_3} ${SEARCH_WORD_4}\)" ${DICTIONARY_PATH} | more
          fi
          RESULT_TMP_A=''
        fi
      else
      # Suche in der gesamten Zeile
        # Suche wird nur fuer eine Benutzer-Information verwendet
        RESULT_TMP=$(grep -i --max-count=1 --color=never "${SEARCH_WORD}" ${DICTIONARY_PATH})
        if [ $? -ge 1 ]
        then
        echo "${RESULT_A}"
        else
        # Suchergebnis wird an more uebergeben
        grep -i --max-count=${MAX_SEARCH_RESULTS} --color=always "${SEARCH_WORD}" ${DICTIONARY_PATH} | more
        fi
        RESULT_TMP=''
      fi
    else
    # bis 100 Suchergebnisse durch grep anzeigen
      if [ $(echo "${SEARCH_WORD}" | grep -c "^[$]\{2\}") -eq 1 ]
      then
      # englische Wortsuche
        SEARCH_WORD=${SEARCH_WORD#\$\$}
        # Suche wird nur fuer eine Benutzer-Information verwendet
        RESULT_TMP=$(grep -i --max-count=1 --color=never "^.*[:]\{2\}.*${SEARCH_WORD}.*" ${DICTIONARY_PATH})
        if [ $? -ge 1 ]
        then
        echo "${RESULT_A}"
        else
        # Suchergebnis wird an grep uebergeben
        grep -i --max-count=${MAX_SEARCH_RESULTS} --color=never "^.*[:]\{2\}.*${SEARCH_WORD}.*" ${DICTIONARY_PATH}
        fi
        RESULT_TMP=''
      elif [ $(echo "${SEARCH_WORD}" | grep -c "^[$]\{1\}") -eq 1 ]
      then
      # deutsche Wortsuche
        SEARCH_WORD=${SEARCH_WORD#\$}
        # Suche wird nur fuer eine Benutzer-Information verwendet
        RESULT_TMP=$(grep -i --max-count=1 --color=never "^.*${SEARCH_WORD}.*[:]\{2\}" ${DICTIONARY_PATH})
        if [ $? -ge 1 ]
        then
        echo "${RESULT_A}"
        else
        # Suchergebnis wird an grep uebergeben
        grep -i --max-count=${MAX_SEARCH_RESULTS} --color=never "^.*${SEARCH_WORD}.*[:]\{2\}" ${DICTIONARY_PATH}
        fi
        RESULT_TMP=''
      elif [ $(echo "${SEARCH_WORD}" | wc -w) -ge 2 ]
      then
      # UND-Verknuepfung von 2 bis 4 Worten, Suche in der gesamten Zeile
        SEARCH_WORD=$(echo "${SEARCH_WORD}" | tr -s [:blank:])
        if [ $(echo "${SEARCH_WORD}" | wc -w) -eq 2 ]
        then
          SEARCH_WORD_1=$(echo "${SEARCH_WORD}" | cut -d " " -f 1)
          SEARCH_WORD_2=$(echo "${SEARCH_WORD}" | cut -d " " -f 2)
          # Suche wird nur fuer eine Benutzer-Information verwendet
          RESULT_TMP_A=$(grep -i --max-count=1 --color=never "\(${SEARCH_WORD_1} ${SEARCH_WORD_2}\)" ${DICTIONARY_PATH})
          if [ $? -ge 1 ]
          then
            # Suche wird nur fuer eine Benutzer-Information verwendet
            RESULT_TMP_B=$(grep -i --max-count=1 --color=never "\(${SEARCH_WORD_1}.*${SEARCH_WORD_2}\|${SEARCH_WORD_2}.*${SEARCH_WORD_1}\)" ${DICTIONARY_PATH})
            if [ $? -ge 1 ]
            then
            echo "${RESULT_B}"
            else
            # Suchergebnis wird an grep uebergeben
            grep -i --max-count=${MAX_SEARCH_RESULTS} --color=never "\(${SEARCH_WORD_1}.*${SEARCH_WORD_2}\|${SEARCH_WORD_2}.*${SEARCH_WORD_1}\)" ${DICTIONARY_PATH}
            fi
            RESULT_TMP_B=''
          else
          # Suchergebnis wird an grep uebergeben
          grep -i --max-count=${MAX_SEARCH_RESULTS} --color=always "\(${SEARCH_WORD_1} ${SEARCH_WORD_2}\)" ${DICTIONARY_PATH}
          fi
          RESULT_TMP_A=''
        elif [ $(echo "${SEARCH_WORD}" | wc -w) -eq 3 ]
        then
          SEARCH_WORD_1=$(echo "${SEARCH_WORD}" | cut -d " " -f 1)
          SEARCH_WORD_2=$(echo "${SEARCH_WORD}" | cut -d " " -f 2)
          SEARCH_WORD_3=$(echo "${SEARCH_WORD}" | cut -d " " -f 3)
          # Suche wird nur fuer eine Benutzer-Information verwendet
          RESULT_TMP_A=$(grep -i --max-count=1 --color=never "\(${SEARCH_WORD_1} ${SEARCH_WORD_2} ${SEARCH_WORD_3}\)" ${DICTIONARY_PATH})
          if [ $? -ge 1 ]
          then
            # Suche wird nur fuer eine Benutzer-Information verwendet
            RESULT_TMP_B=$(grep -i --max-count=1 --color=never "\(${SEARCH_WORD_1}.*${SEARCH_WORD_2}\|${SEARCH_WORD_1}.*${SEARCH_WORD_3}\|${SEARCH_WORD_2}.*${SEARCH_WORD_1}\|${SEARCH_WORD_2}.*${SEARCH_WORD_3}\|${SEARCH_WORD_3}.*${SEARCH_WORD_1}\|${SEARCH_WORD_3}.*${SEARCH_WORD_2}\)" ${DICTIONARY_PATH})
            if [ $? -ge 1 ]
            then
            echo "${RESULT_B}"
            else
            # Suchergebnis wird an grep uebergeben
            grep -i --max-count=${MAX_SEARCH_RESULTS} --color=never "\(${SEARCH_WORD_1}.*${SEARCH_WORD_2}\|${SEARCH_WORD_1}.*${SEARCH_WORD_3}\|${SEARCH_WORD_2}.*${SEARCH_WORD_1}\|${SEARCH_WORD_2}.*${SEARCH_WORD_3}\|${SEARCH_WORD_3}.*${SEARCH_WORD_1}\|${SEARCH_WORD_3}.*${SEARCH_WORD_2}\)" ${DICTIONARY_PATH}
            fi
            RESULT_TMP_B=''
          else
          # Suchergebnis wird an grep uebergeben
          grep -i --max-count=${MAX_SEARCH_RESULTS} --color=always "\(${SEARCH_WORD_1} ${SEARCH_WORD_2} ${SEARCH_WORD_3}\)" ${DICTIONARY_PATH}
          fi
          RESULT_TMP_A=''
        elif [ $(echo "${SEARCH_WORD}" | wc -w) -ge 4 ]
        then
          SEARCH_WORD_1=$(echo "${SEARCH_WORD}" | cut -d " " -f 1)
          SEARCH_WORD_2=$(echo "${SEARCH_WORD}" | cut -d " " -f 2)
          SEARCH_WORD_3=$(echo "${SEARCH_WORD}" | cut -d " " -f 3)
          SEARCH_WORD_4=$(echo "${SEARCH_WORD}" | cut -d " " -f 4)
          RESULT_TMP_A=$(grep -i --max-count=1 --color=never "\(${SEARCH_WORD_1} ${SEARCH_WORD_2} ${SEARCH_WORD_3} ${SEARCH_WORD_4}\)" ${DICTIONARY_PATH})
          if [ $? -ge 1 ]
          then
            # Suche wird nur fuer eine Benutzer-Information verwendet
            RESULT_TMP_B=$(grep -i --max-count=1 --color=never "\(${SEARCH_WORD_1}.*${SEARCH_WORD_2}\|${SEARCH_WORD_1}.*${SEARCH_WORD_3}\|${SEARCH_WORD_1}.*${SEARCH_WORD_4}\|${SEARCH_WORD_2}.*${SEARCH_WORD_1}\|${SEARCH_WORD_2}.*${SEARCH_WORD_3}\|${SEARCH_WORD_2}.*${SEARCH_WORD_4}\|${SEARCH_WORD_3}.*${SEARCH_WORD_1}\|${SEARCH_WORD_3}.*${SEARCH_WORD_2}\|${SEARCH_WORD_3}.*${SEARCH_WORD_4}\|${SEARCH_WORD_4}.*${SEARCH_WORD_1}\|${SEARCH_WORD_4}.*${SEARCH_WORD_2}\|${SEARCH_WORD_4}.*${SEARCH_WORD_3}\)" ${DICTIONARY_PATH})
            if [ $? -ge 1 ]
            then
            echo "${RESULT_B}"
            else
            # Suchergebnis wird an grep uebergeben
            grep -i --max-count=${MAX_SEARCH_RESULTS} --color=never "\(${SEARCH_WORD_1}.*${SEARCH_WORD_2}\|${SEARCH_WORD_1}.*${SEARCH_WORD_3}\|${SEARCH_WORD_1}.*${SEARCH_WORD_4}\|${SEARCH_WORD_2}.*${SEARCH_WORD_1}\|${SEARCH_WORD_2}.*${SEARCH_WORD_3}\|${SEARCH_WORD_2}.*${SEARCH_WORD_4}\|${SEARCH_WORD_3}.*${SEARCH_WORD_1}\|${SEARCH_WORD_3}.*${SEARCH_WORD_2}\|${SEARCH_WORD_3}.*${SEARCH_WORD_4}\|${SEARCH_WORD_4}.*${SEARCH_WORD_1}\|${SEARCH_WORD_4}.*${SEARCH_WORD_2}\|${SEARCH_WORD_4}.*${SEARCH_WORD_3}\)" ${DICTIONARY_PATH}
            fi
            RESULT_TMP_B=''
          else
          # Suchergebnis wird an grep uebergeben
          grep -i --max-count=${MAX_SEARCH_RESULTS} --color=always "\(${SEARCH_WORD_1} ${SEARCH_WORD_2} ${SEARCH_WORD_3} ${SEARCH_WORD_4}\)" ${DICTIONARY_PATH}
          fi
          RESULT_TMP_A=''
        fi
      else
      # Suche in der gesamten Zeile
        RESULT_TMP=$(grep -i --max-count=1 --color=never "${SEARCH_WORD}" ${DICTIONARY_PATH})
        if [ $? -ge 1 ]
        then
        echo "${RESULT_A}"
        else
        # Suchergebnis wird an grep uebergeben
        grep -i --max-count=${MAX_SEARCH_RESULTS} --color=always "${SEARCH_WORD}" ${DICTIONARY_PATH}
        fi
        RESULT_TMP=''
      fi
    fi
    echo ""
    echo -n "${FEED_LINE_B} "
    Q=${Q:+$START}
  else
    if [ $Q -lt $STOP ]
    then
    echo -n "${FEED_LINE_A} "
    fi
    if [ ${Q} -ge ${STOP} ]
    then
    echo -e "\n${PROGRAM_STOP}\n"
    exit 1
    fi
  fi
done
exit 0
