#!/bin/bash
# Skript zur Erzeugung von HTML-Bildergalerien
# Version: 2.3
# Date: 2015-05-08
### Anfangswerte von Variablen setzen
SHELLSCRIPT_NAME=${0##*/}
DIR_PROGRAMS='./scripts/'
FILE_GLOBAL_VARIABLES='inc_gallery_global_variables.txt'
# Variablen für for- bzw. while-Schleifen
START=0
STOP=0
STEP=0
START_2=0
STOP_2=0
STEP_2=0
N=0
P=0
Q=0

### Datei mit den globalen Variablen einbinden
if [ -f ${DIR_PROGRAMS}${FILE_GLOBAL_VARIABLES} ]
then
source ${DIR_PROGRAMS}${FILE_GLOBAL_VARIABLES}
  if [ $? -ge 1 ]
  then
  echo -e "\nERROR-CODE: CREATE-GALLERY 1-1 \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
  exit 1
  fi
else
echo -e "\nERROR-CODE: CREATE-GALLERY 1-2 \nFILE: »${DIR_PROGRAMS}${FILE_GLOBAL_VARIABLES}« NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
exit 1
fi

### BEGINN -> Test: Vorhandensein der notwendigen Programm- und Bildverzeichnisse
PROGRAM_DIRECTORY_LIST=${PROGRAM_DIRECTORY_LIST:='EMPTY'}
PICTURE_DIRECTORY_LIST=${PICTURE_DIRECTORY_LIST:='EMPTY'}
# Variablen überprüfen
if [ "${PROGRAM_DIRECTORY_LIST}" = 'EMPTY' ] || [ "${PICTURE_DIRECTORY_LIST}" = 'EMPTY' ]
then
echo -e "\nERROR-CODE: CREATE-GALLERY 2-1 \nVARIABLE: NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
exit 1
fi
# Programmverzeichnisse überprüfen
for i in ${PROGRAM_DIRECTORY_LIST}
do
  DIRECTORY_PATH="./${i}"
  if [ ! -d ${DIRECTORY_PATH} ]
  then
  echo -e "\nERROR-CODE: CREATE-GALLERY 2-2 \nDIRECTORY: »${DIRECTORY_PATH}« NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
  exit 1
  fi
done
# Bilderverzeichnisse überprüfen
for i in ${PICTURE_DIRECTORY_LIST}
do
  DIRECTORY_PATH="../${i}"
  if [ ! -d ${DIRECTORY_PATH} ]
  then
  echo -e "\nERROR-CODE: CREATE-GALLERY 2-3 \nDIRECTORY: »${DIRECTORY_PATH}« NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
  exit 1
  fi
done
### ENDE -> Test: Vorhandensein der notwendigen Programm- und Bildverzeichnisse

### BEGINN -> Sprachendateien einbinden
LANGUAGE_SELECTION=${LANGUAGE_SELECTION:='EMPTY'}
LANGUAGE_SELECTION_FILE_PATH="./${DIR_PROGRAMS}/${LANGUAGE_SELECTION}"
if [ "${LANGUAGE_SELECTION}" != 'EMPTY' ]
then
  if [ -f ${LANGUAGE_SELECTION_FILE_PATH} ]
  then
  source ${LANGUAGE_SELECTION_FILE_PATH}
    if [ $? -ge 1 ]
  then
  echo -e "\nERROR-CODE: CREATE-GALLERY 3-1 \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
  exit 1
  fi
  else
  echo -e "\nERROR-CODE: CREATE-GALLERY 3-2 \nFILE: »${LANGUAGE_SELECTION_FILE_PATH}« NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
  exit 1
  fi
else
echo -e "\nERROR-CODE: CREATE-GALLERY 3-3 \nVARIABLE: NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
exit 1
fi
### ENDE -> Sprachendateien einbinden

### BEGINN -> Test: Vorhandensein der notwendigen Programme
PROGRAM_TEST=${PROGRAM_TEST:='EMPTY'}
PROGRAM_TEST_USER_INFO_LINE_1=${PROGRAM_TEST_USER_INFO_LINE_1:='EMPTY'}
PROGRAM_TEST_USER_INFO_LINE_2=${PROGRAM_TEST_USER_INFO_LINE_2:='EMPTY'}
# Array mit den notwendigen externen Programmen definieren
declare -a PROGRAM_ARRAY
PROGRAM_ARRAY=(which grep ls wc rm mv rmdir bc cat tail head find recode clear convert locale identify cut basename tr sort date)
if [ "${PROGRAM_TEST}" != 'EMPTY' ] || [ "${PROGRAM_TEST_USER_INFO_LINE_1}" != 'EMPTY' ] || [ "${PROGRAM_TEST_USER_INFO_LINE_2}" != 'EMPTY' ]
then
  if [ -f ${DIR_PROGRAMS}${PROGRAM_TEST} ]
  then
  # Datei mit dem Programmtester einbinden
  source ${DIR_PROGRAMS}${PROGRAM_TEST}
    if [ $? -ge 1 ]
    then
    echo -e "\nERROR-CODE: CREATE-GALLERY 4-1 \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
    exit 1
    fi
  else
  echo -e "\nERROR-CODE: CREATE-GALLERY 4-2 \nFILE: »${DIR_PROGRAMS}${PROGRAM_TEST}« NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
  exit 1
  fi
  if [ $TEST_FALSE -ge 1 ]
  then
  # Info über fehlende Programme anzeigen
  clear 2> /dev/null
  echo -e "${TEST_MESSAGE}"
  echo -e "\n${PROGRAM_TEST_USER_INFO_LINE_1}\n"
  echo -e "${PROGRAM_TEST_USER_INFO_LINE_2}\n"
  exit 1
  fi
else
echo -e "\nERROR-CODE: CREATE-GALLERY 4-3 \nVARIABLE: NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
exit 1
fi
### ENDE -> Test: Vorhandensein der notwendigen Programme

# Konfigurations-Datei einbinden
CONFIG_DIRECTORY=${CONFIG_DIRECTORY:='EMPTY'}
CONFIGURATION_FILE_A=${CONFIGURATION_FILE_A:='EMPTY'}
# LANGUAGE_NAME_PART_B -> inc_language_selection.txt
LANGUAGE_NAME_PART_B=${LANGUAGE_NAME_PART_B:='EMPTY'}
if [ "${LANGUAGE_NAME_PART_B}" = 'EMPTY' ]
then
echo -e "\nERROR-CODE: CREATE-GALLERY 5-1 \nVARIABLE: NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
exit 1
fi
CONFIGURATION_FILE_B=${LANGUAGE_NAME_PART_B}
CONFIGURATION_FILE_C=${CONFIGURATION_FILE_C:='EMPTY'}
if [ "${CONFIGURATION_FILE_A}" = 'EMPTY' ] || [ "${CONFIGURATION_FILE_B}" = 'EMPTY' ] || [ "${CONFIGURATION_FILE_C}" = 'EMPTY' ]
then
echo -e "\nERROR-CODE: CREATE-GALLERY 5-2 \nVARIABLE: NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
exit 1
fi
if [ ${CONFIG_DIRECTORY} != 'EMPTY' ]
then
CONFIGURATION_FILE_PATH="./${CONFIG_DIRECTORY}/${CONFIGURATION_FILE_A}${CONFIGURATION_FILE_B}${CONFIGURATION_FILE_C}"
  if [ -f ${CONFIGURATION_FILE_PATH} ]
  then
  source ${CONFIGURATION_FILE_PATH}
    if [ $? -ge 1 ]
    then
    echo -e "\nERROR-CODE: CREATE-GALLERY 5-3 \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
    exit 1
    fi
  else
  echo -e "\nERROR-CODE: CREATE-GALLERY 5-4 \nFILE: »${CONFIGURATION_FILE_PATH}« NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
  exit 1
  fi
else
echo -e "\nERROR-CODE: CREATE-GALLERY 5-5 \nVARIABLE: NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
exit 1
fi

# Datei mit den Funktionen einbinden
FUNCTION_FILE=${FUNCTION_FILE:='EMPTY'}
if [ ${FUNCTION_FILE} != 'EMPTY' ]
then
  if [ -f ${DIR_PROGRAMS}${FUNCTION_FILE} ]
  then
  source ${DIR_PROGRAMS}${FUNCTION_FILE}
    if [ $? -ge 1 ]
    then
    echo -e "\nERROR-CODE: CREATE-GALLERY 6-1 \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
    exit 1
    fi
  else
  echo -e "\nERROR-CODE: CREATE-GALLERY 6-2 \nFILE: »${DIR_PROGRAMS}${FUNCTION_FILE}« NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
  exit 1
  fi
else
echo -e "\nERROR-CODE: CREATE-GALLERY 6-3 \nVARIABLE: NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
exit 1
fi

# Bilddateien die nicht vom Typ JPEG oder PNG sind löschen; Leerzeichen in den Bildnamen ersetzen
PICTURE_DIRECTORY=${PICTURE_DIRECTORY:='EMPTY'}
THUMBNAILS_DIRECTORY=${THUMBNAILS_DIRECTORY:='EMPTY'}
if [ ${PICTURE_DIRECTORY} = 'EMPTY' ]  || [ ${THUMBNAILS_DIRECTORY} = 'EMPTY' ]
then
echo -e "\nERROR-CODE: CREATE-GALLERY 7-1 \nVARIABLE: NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
exit 1
fi
PICTURE_DIRECTORY_PATH="../${PICTURE_DIRECTORY}"
if [ -d ${PICTURE_DIRECTORY_PATH} ]
then
delete_not_supported_picture ${PICTURE_DIRECTORY_PATH}
# Leerzeichen in den Bildnamen ersetzen
rename_picture_file_name ${PICTURE_DIRECTORY_PATH}
else
echo -e "\nERROR-CODE: CREATE-GALLERY 7-2 \nDIRECTORY: »${PICTURE_DIRECTORY_PATH}« NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
exit 1
fi
THUMBNAILS_DIRECTORY_PATH="../${THUMBNAILS_DIRECTORY}"
if [ ! -d ${THUMBNAILS_DIRECTORY_PATH} ]
then
echo -e "\nERROR-CODE: CREATE-GALLERY 7-3 \nDIRECTORY: »${THUMBNAILS_DIRECTORY_PATH}« NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
exit 1
fi

# Gesamtzahl der Bild-Dateien ermitteln
CREATE_GALLERY_USER_INFO_A=${CREATE_GALLERY_USER_INFO_A:='EMPTY'}
CREATE_GALLERY_USER_INFO_B=${CREATE_GALLERY_USER_INFO_B:='EMPTY'}
PICTURE_NUMBERS=$(find ${PICTURE_DIRECTORY_PATH} -maxdepth 1 -type f -iregex "^.*\(\.jpg\|\.jpeg\|\.png\)$" | wc -l 2> /dev/null)
  if [ $? -ge 1 ]
  then
  echo -e "\nERROR-CODE: CREATE-GALLERY 8 \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
  exit 1
  fi
# Anzahl der Bild-Dateien prüfen
if [ ${PICTURE_NUMBERS} -eq 0 ]
then
# keine Bild-Dateien gefunden
echo -e "\n  ${CREATE_GALLERY_USER_INFO_A}\n"
exit 1
elif [ ${PICTURE_NUMBERS} -gt 99999 ]
then
# zu viele Bild-Dateien gefunden
echo -e "\n  ${CREATE_GALLERY_USER_INFO_B}\n"
exit 1
fi 

# Datei für die Erstellung des Galerietitels einbinden
TOOLS_CHANGE_GALLERY_TITLE=${TOOLS_CHANGE_GALLERY_TITLE:='EMPTY'}
if [ ${TOOLS_CHANGE_GALLERY_TITLE} != 'EMPTY' ]
then
  if [ -f ${DIR_PROGRAMS}${TOOLS_CHANGE_GALLERY_TITLE} ]
  then
  # Datei inc_index_html_file_gallery.txt (Variable: CREATE_HTML_FILE_INDEX) wird erst später eingebunden
  NO_SCRIPT_CREATE_HTML_FILE_INDEX=1
  source ${DIR_PROGRAMS}${TOOLS_CHANGE_GALLERY_TITLE}
    if [ $? -ge 1 ]
    then
    echo -e "\nERROR-CODE: CREATE-GALLERY 9-1 \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
    exit 1
    fi
  else
  echo -e "\nERROR-CODE: CREATE-GALLERY 9-2 \nFILE: »${DIR_PROGRAMS}${TOOLS_CHANGE_GALLERY_TITLE}« NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
  exit 1
  fi
else
echo -e "\nERROR-CODE: CREATE-GALLERY 9-3 \nVARIABLE: NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
exit 1
fi

# Hinweis für den Benutzer: BITTE WARTEN .....
CREATE_GALLERY_USER_INFO_C=${CREATE_GALLERY_USER_INFO_C:='EMPTY'}
GALLERY_MESSAGE_PLEASE_WAIT=${GALLERY_MESSAGE_PLEASE_WAIT:='EMPTY'}
clear 2> /dev/null
echo -e "\n${CREATE_GALLERY_USER_INFO_C}"
echo -e "${GALLERY_MESSAGE_PLEASE_WAIT}\n"

# Datei für die Bildbearbeitung (Galeriebilder, Thumbnails) einbinden
PICTURE_EDITNG_FILE=${PICTURE_EDITNG_FILE:='EMPTY'}
if [ ${PICTURE_EDITNG_FILE} != 'EMPTY' ]
then
  if [ -f ${DIR_PROGRAMS}${PICTURE_EDITNG_FILE} ]
  then
  source ${DIR_PROGRAMS}${PICTURE_EDITNG_FILE}
    if [ $? -ge 1 ]
    then
    echo -e "\nERROR-CODE: CREATE-GALLERY 10-1 \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
    exit 1
    fi
  else
  echo -e "\nERROR-CODE: CREATE-GALLERY 10-2 \nFILE: »${DIR_PROGRAMS}${PICTURE_EDITNG_FILE}« NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
  exit 1
  fi
else
echo -e "\nERROR-CODE: CREATE-GALLERY 10-3 \nVARIABLE: NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
exit 1
fi

# Datei für die Erstellung der 2. HTML-Start-Datei einbinden
CREATE_HTML_FILE_INDEX=${CREATE_HTML_FILE_INDEX:='EMPTY'}
if [ ${CREATE_HTML_FILE_INDEX} != 'EMPTY' ]
then
  if [ -f ${DIR_PROGRAMS}${CREATE_HTML_FILE_INDEX} ]
  then
  source ${DIR_PROGRAMS}${CREATE_HTML_FILE_INDEX}
    if [ $? -ge 1 ]
    then
    echo -e "\nERROR-CODE: CREATE-GALLERY 11-1 \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
    exit 1
    fi
  else
  echo -e "\nERROR-CODE: CREATE-GALLERY 11-2 \nFILE: »${DIR_PROGRAMS}${CREATE_HTML_FILE_INDEX}« NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
  exit 1
  fi
else
echo -e "\nERROR-CODE: CREATE-GALLERY 11-3 \nVARIABLE: NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
exit 1
fi

# Datei für die Erstellung der HTML-Datei der Thumbnail-Bilder einbinden
CREATE_HTML_FILE_A=${CREATE_HTML_FILE_A:='EMPTY'}
if [ ${CREATE_HTML_FILE_A} != 'EMPTY' ]
then
  if [ -f ${DIR_PROGRAMS}${CREATE_HTML_FILE_A} ]
  then
  source ${DIR_PROGRAMS}${CREATE_HTML_FILE_A}
    if [ $? -ge 1 ]
    then
    echo -e "\nERROR-CODE: CREATE-GALLERY 12-1 \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
    exit 1
    fi
  else
  echo -e "\nERROR-CODE: CREATE-GALLERY 12-2 \nFILE: »${DIR_PROGRAMS}${CREATE_HTML_FILE_A}« NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
  exit 1
  fi
else
echo -e "\nERROR-CODE: CREATE-GALLERY 12-3 \nVARIABLE: NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
exit 1
fi

# Datei für die Erstellung der HTML-Dateien der Galeriebilder (Hauptbilder) einbinden
CREATE_HTML_FILES_B=${CREATE_HTML_FILES_B:='EMPTY'}
if [ ${CREATE_HTML_FILES_B} != 'EMPTY' ]
then
  if [ -f ${DIR_PROGRAMS}${CREATE_HTML_FILES_B} ]
  then
  source ${DIR_PROGRAMS}${CREATE_HTML_FILES_B}
    if [ $? -ge 1 ]
    then
    echo -e "\nERROR-CODE: CREATE-GALLERY 13-1 \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
    exit 1
    fi
  else
  echo -e "\nERROR-CODE: CREATE-GALLERY 13-2 \nFILE: »${DIR_PROGRAMS}${CREATE_HTML_FILES_B}« NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
  exit 1
  fi
else
echo -e "\nERROR-CODE: CREATE-GALLERY 13-3 \nVARIABLE: NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
exit 1
fi

# Datei für die Erstellung der 1. HTML-Start-Datei einbinden
CREATE_HTML_FILE_START_INDEX=${CREATE_HTML_FILE_START_INDEX:='EMPTY'}
if [ ${CREATE_HTML_FILE_START_INDEX} != 'EMPTY' ]
then
  if [ -f ${DIR_PROGRAMS}${CREATE_HTML_FILE_START_INDEX} ]
  then
  source ${DIR_PROGRAMS}${CREATE_HTML_FILE_START_INDEX}
    if [ $? -ge 1 ]
    then
    echo -e "\nERROR-CODE: CREATE-GALLERY 14-1 \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
    exit 1
    fi
  else
  echo -e "\nERROR-CODE: CREATE-GALLERY 14-2 \nFILE: »${DIR_PROGRAMS}${CREATE_HTML_FILE_START_INDEX}« NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
  exit 1
  fi
else
echo -e "\nERROR-CODE: CREATE-GALLERY 14-3 \nVARIABLE: NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
exit 1
fi

# evtl. vorhandene Sicherungsdateien (Endung: ~) löschen
DIRECTORY_GALLERY_ROOT_PATH='../'
delete_backup_copies ${DIRECTORY_GALLERY_ROOT_PATH}
# Zugriffsrechte der Include-Dateien und der beiden Shellskripte create-gallery.sh und gallery-tools.sh ändern
change_access_rights ${DIR_PROGRAMS}

clear 2> /dev/null
CREATE_GALLERY_USER_INFO_D=${CREATE_GALLERY_USER_INFO_D:='EMPTY'}
CREATE_GALLERY_USER_INFO_E=${CREATE_GALLERY_USER_INFO_E:='EMPTY'}
echo -e "\n*************************************************************************\n"
echo -e "\t${CREATE_GALLERY_USER_INFO_D}\n"
echo -e "${CREATE_GALLERY_USER_INFO_E}\n\n"

exit 0
