#!/bin/bash
# Skript zur Bearbeitung einer bestehenden HTML-Bildergalerien
# Version: 2.3
# Date: 2015-05-08
### Anfangswerte von Variablen setzen
SHELLSCRIPT_NAME=${0##*/}
DIR_PROGRAMS='./scripts/'
FILE_GLOBAL_VARIABLES='inc_gallery_global_variables.txt'
# Variablen für for- bzw. while-Schleifen
START=0
STOP=0
STEP=0
START_2=0
STOP_2=0
STEP_2=0
N=0
P=0
Q=0

### Datei mit den globalen Variablen einbinden
if [ -f ${DIR_PROGRAMS}${FILE_GLOBAL_VARIABLES} ]
then
source ${DIR_PROGRAMS}${FILE_GLOBAL_VARIABLES}
  if [ $? -ge 1 ]
  then
  echo -e "\nERROR-CODE: GALLERY TOOLS 1-1 \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
  exit 1
  fi
else
echo -e "\nERROR-CODE: GALLERY TOOLS 1-2 \nFILE: »${DIR_PROGRAMS}${FILE_GLOBAL_VARIABLES}« NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
exit 1
fi

# Variablen überprüfen
PICTURE_DIRECTORY=${PICTURE_DIRECTORY:='EMPTY'}
if [ "${PICTURE_DIRECTORY}" = 'EMPTY' ]
then
echo -e "\nERROR-CODE: GALLERY TOOLS 2-1 \nVARIABLE: NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
exit 1
fi
THUMBNAILS_DIRECTORY=${THUMBNAILS_DIRECTORY:='EMPTY'}
if [ "${THUMBNAILS_DIRECTORY}" = 'EMPTY' ]
then
echo -e "\nERROR-CODE: GALLERY TOOLS 2-2 \nVARIABLE: NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
exit 1
fi

### BEGINN -> Sprachendateien einbinden
LANGUAGE_SELECTION=${LANGUAGE_SELECTION:='EMPTY'}
LANGUAGE_SELECTION_FILE_PATH="${DIR_PROGRAMS}${LANGUAGE_SELECTION}"
if [ "${LANGUAGE_SELECTION}" != 'EMPTY' ]
then
  if [ -f ${LANGUAGE_SELECTION_FILE_PATH} ]
  then
  source ${LANGUAGE_SELECTION_FILE_PATH}
    if [ $? -ge 1 ]
    then
    echo -e "\nERROR-CODE: GALLERY TOOLS 3-1 \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
    exit 1
    fi
  else
  echo -e "\nERROR-CODE: GALLERY TOOLS 3-2 \nFILE: »${LANGUAGE_SELECTION_FILE_PATH}« NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
  exit 1
  fi
else
echo -e "\nERROR-CODE: GALLERY TOOLS 3-3 \nVARIABLE: NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
exit 1
fi
### ENDE -> Sprachendateien einbinden

### BEGINN -> Test: Vorhandensein der notwendigen Programme
PROGRAM_TEST=${PROGRAM_TEST:='EMPTY'}
PROGRAM_TEST_USER_INFO_LINE_1=${PROGRAM_TEST_USER_INFO_LINE_1:='EMPTY'}
# Array mit den notwendigen externen Programmen definieren
declare -a PROGRAM_ARRAY
PROGRAM_ARRAY=(which grep clear mkdir rmdir cp find wc rm head tail cut locale mv tr todos fromdos exiv2 sed identify cat sort)
if [ "${PROGRAM_TEST}" != 'EMPTY' ] || [ "${PROGRAM_TEST_USER_INFO_LINE_1}" != 'EMPTY' ]
then
  if [ -f ${DIR_PROGRAMS}${PROGRAM_TEST} ]
  then
  # Datei mit dem Programmtester einbinden
  source ${DIR_PROGRAMS}${PROGRAM_TEST}
    if [ $? -ge 1 ]
    then
    echo -e "\nERROR-CODE: GALLERY TOOLS 4-1 \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
    exit 1
    fi
  else
  echo -e "\nERROR-CODE: GALLERY TOOLS 4-2 \nFILE: »${DIR_PROGRAMS}${PROGRAM_TEST}« NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
  exit 1
  fi
  if [ $TEST_FALSE -ge 1 ]
  then
  # Info über fehlende Programme anzeigen
  clear 2> /dev/null
  echo -e "${TEST_MESSAGE}"
  echo -e "\n${PROGRAM_TEST_USER_INFO_LINE_1}\n"
  echo -e "${PROGRAM_TEST_USER_TOOLS_INFO_LINE_2}"
  echo -e "${PROGRAM_TEST_USER_TOOLS_INFO_LINE_3}\n"
  exit 1
  fi
else
echo -e "\nERROR-CODE: GALLERY TOOLS 4-3 \nVARIABLE: NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
exit 1
fi
### ENDE -> Test: Vorhandensein der notwendigen Programme

# Konfigurations-Datei einbinden
CONFIG_DIRECTORY=${CONFIG_DIRECTORY:='EMPTY'}
CONFIGURATION_FILE_A=${CONFIGURATION_FILE_A:='EMPTY'}
# LANGUAGE_NAME_PART_B -> inc_language_selection.txt
LANGUAGE_NAME_PART_B=${LANGUAGE_NAME_PART_B:='EMPTY'}
LANGUAGE_NAME_PART_B=$(echo ${LANGUAGE_NAME_PART_B} | tr [:upper:] [:lower:])
  if [ $? -ge 1 ]
  then
  echo -e "\nERROR-CODE: GALLERY TOOLS 5-1 \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
  exit 1
  fi
if [ "${LANGUAGE_NAME_PART_B}" = 'EMPTY' ]
then
echo -e "\nERROR-CODE: GALLERY TOOLS 5-2 \nVARIABLE: NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
exit 1
fi
CONFIGURATION_FILE_B=${LANGUAGE_NAME_PART_B}
CONFIGURATION_FILE_C=${CONFIGURATION_FILE_C:='EMPTY'}
if [ "${CONFIGURATION_FILE_A}" = 'EMPTY' ] || [ "${CONFIGURATION_FILE_B}" = 'EMPTY' ] || [ "${CONFIGURATION_FILE_C}" = 'EMPTY' ]
then
echo -e "\nERROR-CODE: GALLERY TOOLS 5-3 \nVARIABLE: NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
exit 1
fi
if [ ${CONFIG_DIRECTORY} != 'EMPTY' ]
then
CONFIGURATION_FILE_PATH="./${CONFIG_DIRECTORY}/${CONFIGURATION_FILE_A}${CONFIGURATION_FILE_B}${CONFIGURATION_FILE_C}"
  if [ -f ${CONFIGURATION_FILE_PATH} ]
  then
  source ${CONFIGURATION_FILE_PATH}
    if [ $? -ge 1 ]
    then
    echo -e "\nERROR-CODE: GALLERY TOOLS 5-4 \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
    exit 1
    fi
  else
  echo -e "\nERROR-CODE: GALLERY TOOLS 5-5 \nFILE: »${CONFIGURATION_FILE_PATH}« NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
  exit 1
  fi
else
echo -e "\nERROR-CODE: GALLERY TOOLS 5-6 \nVARIABLE: NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
exit 1
fi

# Datei mit den Funktionen einbinden
FUNCTION_FILE=${FUNCTION_FILE:='EMPTY'}
if [ ${FUNCTION_FILE} != 'EMPTY' ]
then
  if [ -f ${DIR_PROGRAMS}${FUNCTION_FILE} ]
  then
  source ${DIR_PROGRAMS}${FUNCTION_FILE}
    if [ $? -ge 1 ]
    then
    echo -e "\nERROR-CODE: GALLERY TOOLS 6-1 \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
    exit 1
    fi
  else
  echo -e "\nERROR-CODE: GALLERY TOOLS 6-2 \nFILE: »${DIR_PROGRAMS}${FUNCTION_FILE}« NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
  exit 1
  fi
else
echo -e "\nERROR-CODE: GALLERY TOOLS 6-3 \nVARIABLE: NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
exit 1
fi

### BEGINN -> Hauptmenü erstellen
#
# Array mit den Namen der Include-Dateien
declare -a TOOLS_INC_FILE_ARRAY
TOOLS_PICTURE_TITLE=${TOOLS_PICTURE_TITLE:='EMPTY'}
TOOLS_CONVERT_FILES=${TOOLS_CONVERT_FILES:='EMPTY'}
TOOLS_EXIF_DELETE=${TOOLS_EXIF_DELETE:='EMPTY'}
TOOLS_CHANGE_GALLERY_TITLE=${TOOLS_CHANGE_GALLERY_TITLE:='EMPTY'}
TOOLS_ADD_DEL_CAPITEL=${TOOLS_ADD_DEL_CAPITEL:='EMPTY'}
TOOLS_ADD_DEL_HTML_PAGES=${TOOLS_ADD_DEL_HTML_PAGES:='EMPTY'}
TOOLS_INC_FILE_ARRAY[0]=${TOOLS_PICTURE_TITLE}
TOOLS_INC_FILE_ARRAY[1]=${TOOLS_CONVERT_FILES}
TOOLS_INC_FILE_ARRAY[2]=${TOOLS_EXIF_DELETE}
TOOLS_INC_FILE_ARRAY[3]=${TOOLS_CHANGE_GALLERY_TITLE}
TOOLS_INC_FILE_ARRAY[4]=${TOOLS_ADD_DEL_CAPITEL}
TOOLS_INC_FILE_ARRAY[5]=${TOOLS_ADD_DEL_HTML_PAGES}

# Einträge des Hauptmenü's
TOOLS_MENUE_HEAD_LINE=${TOOLS_MENUE_HEAD_LINE:='EMPTY'}
TOOLS_FEED_LINE_A=${TOOLS_FEED_LINE_A:='EMPTY'}
TOOLS_FEED_LINE_B=${TOOLS_FEED_LINE_B:='EMPTY'}
TOOLS_MENUE_VALUE_BREAK=${TOOLS_MENUE_VALUE_BREAK:='EMPTY'}
TOOLS_MENUE_VALUE_1=${TOOLS_MENUE_VALUE_1:='EMPTY'}
TOOLS_MENUE_VALUE_2=${TOOLS_MENUE_VALUE_2:='EMPTY'}
TOOLS_MENUE_VALUE_3=${TOOLS_MENUE_VALUE_3:='EMPTY'}
TOOLS_MENUE_VALUE_4=${TOOLS_MENUE_VALUE_4:='EMPTY'}
TOOLS_MENUE_VALUE_5=${TOOLS_MENUE_VALUE_5:='EMPTY'}
TOOLS_MENUE_VALUE_6=${TOOLS_MENUE_VALUE_6:='EMPTY'}
TOOLS_MENUE_FEED_LINE=${TOOLS_MENUE_FEED_LINE:='EMPTY'}

# Gesamtzahl der Bilder ermitteln
PICTURE_DIRECTORY_PATH="../${PICTURE_DIRECTORY}"
if [ ! -d ${PICTURE_DIRECTORY_PATH} ]
then
echo -e "\nERROR-CODE: GALLERY TOOLS 7-1 \nDIRECTORY: »${PICTURE_DIRECTORY_PATH}« NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
exit 1
fi
TOOLS_FEED_LINE_A=${TOOLS_FEED_LINE_A:='EMPTY'}
TOOLS_FEED_LINE_B=${TOOLS_FEED_LINE_B:='EMPTY'}
PICTURE_NUMBERS=$(find ${PICTURE_DIRECTORY_PATH} -maxdepth 1 -type f -iregex "^.*\(\.jpg\|\.jpeg\|\.png\)$" | wc -l 2> /dev/null)
  if [ $? -ge 1 ]
  then
  echo -e "\nERROR-CODE: GALLERY TOOLS 7-2 \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
  exit 1
  fi
# Bilderanzahl prüfen
if [ ${PICTURE_NUMBERS} -eq 0 ]
then
  # keine Bilder gefunden
  echo -e "\n  ${TOOLS_FEED_LINE_A}\n"
  exit 1
elif [ ${PICTURE_NUMBERS} -gt 99999 ]
then
  # zu viele Bilder gefunden
  echo -e "\n  ${TOOLS_FEED_LINE_B}\n"
  exit 1
fi
# THUMBNAILS_DIRECTORY_PATH -> inc_create_html_file_a.txt; inc_tools_exif_data.txt
THUMBNAILS_DIRECTORY_PATH="../${THUMBNAILS_DIRECTORY}"
if [ ! -d ${THUMBNAILS_DIRECTORY_PATH} ]
then
echo -e "\nERROR-CODE: GALLERY TOOLS 7-3 \nDIRECTORY: »${THUMBNAILS_DIRECTORY_PATH}« NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
exit 1
fi
TOOLS_FEED_LINE_C=${TOOLS_FEED_LINE_C:='EMPTY'}
TOOLS_FEED_LINE_D=${TOOLS_FEED_LINE_D:='EMPTY'}
TOOLS_FEED_LINE_E=${TOOLS_FEED_LINE_E:='EMPTY'}
THUMBNAILS_NUMBERS=$(find ${THUMBNAILS_DIRECTORY_PATH} -maxdepth 1 -type f -iregex "^.*\(\.jpg\|\.jpeg\)$" | wc -l 2> /dev/null)
  if [ $? -ge 1 ]
  then
  echo -e "\nERROR-CODE: GALLERY TOOLS 7-4 \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
  exit 1
  fi
# Bilderanzahl prüfen
if [ ${THUMBNAILS_NUMBERS} -eq 0 ]
then
  # keine Thumbnails gefunden
  echo -e "\n  ${TOOLS_FEED_LINE_C}"
  echo -e "\n  ${TOOLS_FEED_LINE_E}\n"
  exit 1
elif [ ${THUMBNAILS_NUMBERS} -gt 99999 ]
then
  # zu viele Thumbnails gefunden
  echo -e "\n  ${TOOLS_FEED_LINE_D}"
  echo -e "\n  ${TOOLS_FEED_LINE_E}\n"
  exit 1
fi
if [ ${PICTURE_NUMBERS} -ne ${THUMBNAILS_NUMBERS} ]
then
echo -e "\nERROR-CODE: GALLERY TOOLS 7-5 \nFILE: FILE-COUNT IN PICTURE- AND THUMBNAIL-DIRECTORY UNEQUAL \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}"
echo -e "\n  ${TOOLS_FEED_LINE_E}\n"
exit 1
fi

clear 2> /dev/null
echo -e "\n\t\t ${TOOLS_MENUE_HEAD_LINE} \n\n"
echo -e "  ${TOOLS_MENUE_VALUE_BREAK} ... (0)"
echo -e "  ${TOOLS_MENUE_VALUE_1} ... (1)"
echo -e "  ${TOOLS_MENUE_VALUE_2} ... (2)"
echo -e "  ${TOOLS_MENUE_VALUE_3} ... (3)"
echo -e "  ${TOOLS_MENUE_VALUE_4} ... (4)"
echo -e "  ${TOOLS_MENUE_VALUE_5} ... (5)"
echo -e "  ${TOOLS_MENUE_VALUE_6} ... (6)"
echo ""
echo -n "${TOOLS_MENUE_FEED_LINE} "

# Benutzereingaben entgegennehmen und überprüfen
TOOLS_MENUE_PROGRAM_STOP=${TOOLS_MENUE_PROGRAM_STOP:='EMPTY'}
TOOLS_MENUE_USER_INFO=${TOOLS_MENUE_USER_INFO:='EMPTY'}
START=${START:+0}
STOP=${STOP:+3}
STEP=${STEP:+1}
Q=${Q:+$START}
N=${N:+$START}
while [ $Q -lt $STOP ]
do
Q=$[$Q+$STEP]
read MAIN_MENUE_VALUE
  if [ $(echo "${MAIN_MENUE_VALUE}" | grep -c "^[1-6]$") -eq 1 ]
  then
  N=$[$MAIN_MENUE_VALUE-$STEP]
  TOOLS_INC_FILE_PATH=${DIR_PROGRAMS}${TOOLS_INC_FILE_ARRAY[$N]}
    if [ "${TOOLS_INC_FILE_ARRAY[$N]}" != 'EMPTY' ]
    then
      if [ -f ${TOOLS_INC_FILE_PATH} ]
      then
      source ${TOOLS_INC_FILE_PATH}
	if [ $? -ge 1 ]
	then
	echo -e "\nERROR-CODE: GALLERY TOOLS 8-1 \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
	exit 1
	fi
      else
      echo -e "\nERROR-CODE: GALLERY TOOLS 8-2 \nFILE: »${TOOLS_INC_FILE_PATH}« NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
      exit 1
      fi
    else
    echo -e "\nERROR-CODE: GALLERY TOOLS 8-3 \nVARIABLE: NOT FOUND \nSCRIPT-NAME: ${SHELLSCRIPT_NAME}\n"
    exit 1
    fi
  Q=${Q:+$STOP}
  elif [ $(echo "${MAIN_MENUE_VALUE}" | grep -c "^[0]$") -eq 1 ] || [ "${MAIN_MENUE_VALUE}" = '' ]
  then
  echo -e "\n${TOOLS_MENUE_PROGRAM_STOP}\n"
  exit 1
  else
  echo "${TOOLS_MENUE_USER_INFO}"
    if [ $Q -lt $STOP ]
    then
    echo -n "${TOOLS_MENUE_FEED_LINE} "
    fi
    if [ ${Q} -ge ${STOP} ]
    then
    echo -e "\n${TOOLS_MENUE_PROGRAM_STOP}\n"
    exit 1
    fi
  fi
done
### ENDE -> Hauptmenü erstellen

# Funktions-Aufruf: evtl. vorhandene Sicherungsdateien (Endung: ~) löschen
DIRECTORY_GALLERY_ROOT_PATH='../'
delete_backup_copies ${DIRECTORY_GALLERY_ROOT_PATH}
# Zugriffsrechte der Include-Dateien und der beiden Shellskripte create-gallery.sh und gallery-tools.sh ändern
change_access_rights ${DIR_PROGRAMS}
exit 0
