<?php
// +++ ANFANG KONFIGURATION +++
$counter_mode=2; // Modus: 0 .. kein Counter, 1 .. Benutzer der Webseite zaehlen, 2 .. Zugriffe auf die Webseite zaehlen
$counter_leading_zeros=1; // aktuellen Counterstand mit Nullen aufuellen; 0 .. keine fuehrenden Nullen, 1 .. auffuellen mit Nullen (default))
$counter_numbers_directory = "./numbers"; // Name des Verzeichnisses fuer die Zahlenbilder, Grafikcounter u.a.
$counter_text_directory = $counter_numbers_directory . "/txt"; // Name des Verzeichnisses fuer die Textdateien u.a.
$counter_data_filename = "counter.txt"; // Name der Datei mit dem aktuellen Counterstand
$counter_data_file_path = $counter_text_directory ."/" . $counter_data_filename; // Dateipfad der Datei mit dem Counterstand
$counter_user_filename = "counter_user.txt"; // Name der Datei mit dem MD5-Key der User
$counter_user_file_path = $counter_text_directory ."/" . $counter_user_filename; // Dateipfad der Datei mit dem MD5-Key der User
$counter_user_file_max_data_records=1000; // maximale Anzahl der Eintraege; moegliche Werte 100 .. 99999, 1000 (default)
$counter_filetype = "png"; // Dateitypen - ohne fuehrenden Punkt - fuer den Counter; moegliche Werte: jpg oder jpeg, png (default), gif
$counter_filename_part_a = "counter"; // erster Teil des Namens fuer den Counter (counter000xxx.png)
$counter_numbers_spacing=2; // Abstand der einzelnen Zahlen zueinander; moegliche Werte: 0 .. 9, 2 (default)
$counter_max_value=1000000; // maximaler Counterstand; 10 .. 9999999; 1000000 (default)
$counter_directory_access=0755; // Zugriffsberechtigung fuer das Verzeichnis mit den Textdateien; moegliche Werte: 0777, 0775, 0755 (default), 0700
$counter_file_access=0644; // Zugriffsberechtigung fuer die Datei mit dem aktuellen Counterstand; moegliche Werte: 0666, 0664, 0644 (default), 0600
$counter_color_workspace_red=255; // RGB-Code fuer den Rotanteil, Farbe Bildgrundflaeche, rot -> RGB 255, 0, 0 -> white RGB 255, 255, 255
$counter_color_workspace_green=255; // RGB-Code fuer den Gruenanteil, Farbe Bildgrundflaeche, gruen -> RGB 0, 255, 0 -> white RGB 255, 255, 255
$counter_color_workspace_blue=255; // RGB-Code fuer den Blauanteil, Farbe Bildgrundflaeche, blau -> RGB 0, 0, 255 -> white RGB 255, 255, 255
$directory_numbers_access_denied = "<b>Zugriffsverweigerung: " . $counter_numbers_directory . "</b><br>Die Zugriffsberechtigung des Arbeitsverzeichnisses sollte die Erstellung des Grafikcounters erlauben!!";
$directory_text_access_denied = "<b>Zugriffsverweigerung: " . $counter_numbers_directory . "</b><br>Die Zugriffsberechtigung des Arbeitsverzeichnisses sollte die Erstellung des Verzeichnisses " . $counter_text_directory . " erlauben!!";
$directory_text_data_access_denied = "<b>Zugriffsverweigerung: " . $counter_numbers_directory . $counter_text_directory . "</b><br>Die Zugriffsberechtigung des Arbeitsverzeichnisses sollte die Erstellung der Textdateien erlauben!!";
$counter_images_not_completely = "Hinweis: Die Zahlenbilder (0 bis 9) im Verzeichnis " . $counter_numbers_directory .  " sind nicht vollst&auml;ndig!!";
$error_directory_not_found = "ERROR: DIRECTORY  " . $counter_numbers_directory . " NOT FOUND!!";
$error_file_not_found = "ERROR: COUNTER-FILE NOT FOUND!!";
$error_old_text_file_delete_false = "ERROR: OLD USER-TEXT-FILE CAN NOT DELETE!!";
$error_old_images_delete_false = "ERROR: OLD COUNTER-FILE CAN NOT DELETE!!";
// +++ ENDE KONFIGURATION +++
if(empty($include_key)) exit; // verhindert die Ausfuehrung der include-Datei bei einem direkten Aufruf
$data_transfer_read_array = array();
$data_transfer_write_array = array();
$data_transfer_user_read_write_array = array();
$data_transfer_format_array = array();
$data_transfer_create_array = array();
// Verzeichnis fuer die Textdateien anlegen
if(is_dir($counter_numbers_directory)) {
   if(!is_dir($counter_text_directory)) {
      @mkdir($counter_text_directory, $counter_directory_access) or die($directory_text_access_denied);
   }
}
else
{
print $error_directory_not_found;
exit;
}

function create_graphic_counter($DataTransferCreateArray) {
   $NumbersImageArray = array();
   $CounterOldImagesArray = array();
   if(preg_match("/^jp[e]?g$/i",$DataTransferCreateArray[4])) {
      $CounterFiletype = "jp[e]?g";
   }
   else
   {
   $CounterFiletype = $DataTransferCreateArray[4];
   }
   $Handle = opendir($DataTransferCreateArray[0]);
   while($Filename = readdir($Handle)) {
      if(!is_dir($Filename) && preg_match("/^[0-9]\." . $CounterFiletype . "$/i",$Filename)) {
         array_push($NumbersImageArray, $Filename);
      } elseif(!is_dir($Filename) && preg_match("/^" . $DataTransferCreateArray[2] . "[0-9]{1,7}\.(jp[e]?g|gif|png)$/i",$Filename)) {
         array_push($CounterOldImagesArray, $Filename);
      }
   }
   closedir($Handle);
   $NumbersImageCount = count($NumbersImageArray);
   if($NumbersImageCount != 10) {
      print $DataTransferCreateArray[10];
      exit;
   }
   sort($NumbersImageArray, SORT_NUMERIC);
   $CounterValueLength = strlen($DataTransferCreateArray[3]);
   $CountNumbersSpacing = $CounterValueLength - 1;
   if(!preg_match("/^[0-9]$/",$DataTransferCreateArray[5])) $DataTransferCreateArray[5]=2;
   $CounterImageWidth=0;
   $a=0;
   for($x=0; $x<$CounterValueLength; $x++) {
      $ImageNumberX = substr($DataTransferCreateArray[3],$x,1);
      $ImageNumberPath = $DataTransferCreateArray[0] . "/" . $NumbersImageArray[$ImageNumberX];
      $ImageNumberSizeX = getimagesize($ImageNumberPath);
      if(empty($ImageNumberHeigth)) $ImageNumberHeigth = $ImageNumberSizeX[1] ;
      if($a < $CountNumbersSpacing) {
         $CounterImageWidth += $ImageNumberSizeX[0] + $DataTransferCreateArray[5];
         $a++;
      }
      else
      {
      $CounterImageWidth += $ImageNumberSizeX[0];
      }
   }  
   $CounterImage = imagecreate($CounterImageWidth,$ImageNumberHeigth);
   $CounterWorkSpaceColor = imagecolorallocate($CounterImage,$DataTransferCreateArray[6],$DataTransferCreateArray[7],$DataTransferCreateArray[8]);
   if(preg_match("/^(gif|png)$/i",$DataTransferCreateArray[4])) {
      imagecolortransparent($CounterImage,$CounterWorkSpaceColor);
   }
   $CounterImageWidth=0;
   $a=0;
   for($y=0; $y<$CounterValueLength; $y++) {
      $CounterImageCurrentNumber = substr($DataTransferCreateArray[3],$y,1);
      $CounterImageCurrentNumberPath = $DataTransferCreateArray[0] . "/" . $NumbersImageArray[$CounterImageCurrentNumber];
      $ImageNumberSizeX = getimagesize($CounterImageCurrentNumberPath);
      if(preg_match("/^jp[e]?g$/i",$DataTransferCreateArray[4])) {
         $CurrentNumber =  imagecreatefromjpeg($CounterImageCurrentNumberPath);
      } elseif(preg_match("/^gif$/i",$DataTransferCreateArray[4])) {
         $CurrentNumber = imagecreatefromgif($CounterImageCurrentNumberPath);
      }
      else
      {
      $CurrentNumber = imagecreatefrompng($CounterImageCurrentNumberPath);
      }
      imagecopy($CounterImage,$CurrentNumber,$CounterImageWidth,0,0,0,$ImageNumberSizeX[0],$ImageNumberHeigth);
      if($a < $CountNumbersSpacing) {
         $CounterImageWidth += $ImageNumberSizeX[0] + $DataTransferCreateArray[5];
         $a++;
      }
      else
      {
      $CounterImageWidth += $ImageNumberSizeX[0];
      }
   }
   if(preg_match("/^jp[e]?g$/i",$DataTransferCreateArray[4])) {
      @imagejpeg($CounterImage,$DataTransferCreateArray[1]) or die($DataTransferCreateArray[9]);
   } elseif(preg_match("/^gif$/i",$DataTransferCreateArray[4])) {
      @imagegif($CounterImage,$DataTransferCreateArray[1]) or die($DataTransferCreateArray[9]);
   }
   else
   {
   @imagepng($CounterImage,$DataTransferCreateArray[1]) or die($DataTransferCreateArray[9]);
   }
   imagedestroy($CurrentNumber);
   imagedestroy($CounterImage);
   $CounterOldImagesCount = count($CounterOldImagesArray);
   for($z=0; $z<$CounterOldImagesCount; $z++) {
      $CounterOldImagesPath = $DataTransferCreateArray[0] ."/" . $CounterOldImagesArray[$z];
      if(!preg_match("@^" . $DataTransferCreateArray[1] . "$@",$CounterOldImagesPath)) {
         if(file_exists($CounterOldImagesPath)) {
            @unlink($CounterOldImagesPath) or die($DataTransferCreateArray[11]);
         }
      }
   }
   return $DataTransferCreateArray[1];
}

function counter_write($DataTransferWriteArray) {
   if(!file_exists($DataTransferWriteArray[0])) {
      @touch($DataTransferWriteArray[0]) or die($DataTransferWriteArray[3]);
      @chmod($DataTransferWriteArray[0], $DataTransferWriteArray[2]);
      $CounterValue=0;
   }
   else
   {
   $FileRead = @fopen($DataTransferWriteArray[0],"r");
   $CounterNumber = @fgets($FileRead,10);
   @fclose($FileRead);
   $CounterValue = trim($CounterNumber);
   }
   if(empty($CounterValue)) $CounterValue=0;
   if(!preg_match("/^[0-9]{1,7}$/",$CounterValue)) $CounterValue=0;
   $CounterValue++;
   // $DataTransferWriteArray[1] - ungueltiger Wert wird durch den default-Wert ersetzt
   if(!preg_match("/^[1-9][0-9]{1,6}$/",$DataTransferWriteArray[1])) $DataTransferWriteArray[1]=1000000;
   if($CounterValue > $DataTransferWriteArray[1]) $CounterValue=1;
   if($FileWrite = @fopen($DataTransferWriteArray[0],'w')) {
      @flock($FileWrite,2);
      @fwrite($FileWrite,$CounterValue,10);
      @flock($FileWrite,3);
      @fclose($FileWrite);
   }
   return $CounterValue;
}

function counter_read($DataTransferReadArray) {
   if(file_exists($DataTransferReadArray[0]) && is_readable($DataTransferReadArray[0])) {
      $FileRead = @fopen($DataTransferReadArray[0],"r");
      $CounterNumber = @fgets($FileRead,10);
      @fclose($FileRead);
      $CounterValue = trim($CounterNumber);
   }
   if(empty($CounterValue)) $CounterValue=0;
   if(!preg_match("/^[0-9]{1,7}$/",$CounterValue)) $CounterValue=0;
   // $DataTransferReadArray[1] - ungueltiger Wert wird durch den default-Wert ersetzt
   if(!preg_match("/^[1-9][0-9]{1,6}$/",$DataTransferReadArray[1])) $DataTransferReadArray[1]=1000000;
   if($CounterValue > $DataTransferReadArray[1]) $CounterValue=0;
   return $CounterValue;
}

function counter_user_read_write($DataTransferUserReadWriteArray) {
   if(!file_exists($DataTransferUserReadWriteArray[0])) {
      @touch($DataTransferUserReadWriteArray[0]) or die($DataTransferUserReadWriteArray[3]);
      @chmod($DataTransferUserReadWriteArray[0], $DataTransferUserReadWriteArray[1]);
   }
   // $DataTransferUserReadWriteArray[2] - ungueltiger Wert wird durch den default-Wert ersetzt
   if(!preg_match("/^[1-9][0-9]{2,4}$/",$DataTransferUserReadWriteArray[2])) $DataTransferUserReadWriteArray[2]=1000;
   $UserMd5KeyRaw = $_SERVER['REMOTE_ADDR'] . $_SERVER['HTTP_USER_AGENT'] . date("YD");
   $UserMd5Key = md5($UserMd5KeyRaw);
   $CounterUserFileContentArray = @file($DataTransferUserReadWriteArray[0]);
   $CounterUserFileContentArrayCheck = end($CounterUserFileContentArray);
   if(empty($CounterUserFileContentArrayCheck)) array_pop($CounterUserFileContentArray);
   $CounterUserFileContentArrayCount = count($CounterUserFileContentArray);
   if($CounterUserFileContentArrayCount >= $DataTransferUserReadWriteArray[2]) {
      @unlink($DataTransferUserReadWriteArray[0]) or die($DataTransferUserReadWriteArray[4]);
      @touch($DataTransferUserReadWriteArray[0]) or die($DataTransferUserReadWriteArray[3]);
      @chmod($DataTransferUserReadWriteArray[0], $DataTransferUserReadWriteArray[1]);
   }
   $WebsiteUserExisted=0;
   for($x=0; $x<$CounterUserFileContentArrayCount; $x++) {
      $CurrentMd5Key = trim($CounterUserFileContentArray[$x]);
      $Md5KeyCompare = strcmp($CurrentMd5Key, $UserMd5Key);
      if($Md5KeyCompare == 0) {
         $WebsiteUserExisted=1;
         break;
      }
   }
   if($WebsiteUserExisted == 0) {
      $AddUserMd5Key =  $UserMd5Key . "\n";
      if($FileWriteKey = @fopen($DataTransferUserReadWriteArray[0],'a')) {
         @flock($FileWriteKey,2);
         @fwrite($FileWriteKey,$AddUserMd5Key);
         @flock($FileWriteKey,3);
         @fclose($FileWriteKey);
      }
   } 
   return $WebsiteUserExisted;
}

function counter_format($DataTransferFormatArray) {
   $CounterFormatArray = array();
   if(!empty($DataTransferFormatArray[2]) && $DataTransferFormatArray[2] == 1) {
      $LenghtCounterValue = strlen($DataTransferFormatArray[0]);
      // $DataTransferFormatArray[1] - ungueltiger Wert wird durch den default-Wert ersetzt
      if(!preg_match("/^[1-9][0-9]{1,6}$/",$DataTransferFormatArray[1])) $DataTransferFormatArray[1]=1000000;
      $LenghtCounterMaxValue = strlen($DataTransferFormatArray[1]);
      for($x=$LenghtCounterValue; $x<$LenghtCounterMaxValue; $x++) {
         $DataTransferFormatArray[0] = "0" . $DataTransferFormatArray[0];
      }
   }
   $CounterImageName = $DataTransferFormatArray[4] . $DataTransferFormatArray[0] . "." . $DataTransferFormatArray[5];
   $CounterImagePath = $DataTransferFormatArray[3] . "/" . $CounterImageName;
   array_push($CounterFormatArray, $CounterImagePath, $DataTransferFormatArray[0]);
   return $CounterFormatArray;
}

$counter_value_dummy=0;
array_push($data_transfer_read_array, $counter_data_file_path, $counter_max_value);
array_push($data_transfer_write_array, $counter_data_file_path, $counter_max_value, $counter_file_access, $directory_numbers_access_denied);
array_push($data_transfer_user_read_write_array, $counter_user_file_path, $counter_file_access, $counter_user_file_max_data_records, $directory_text_data_access_denied, $error_old_text_file_delete_false);
array_push($data_transfer_format_array, $counter_value_dummy, $counter_max_value, $counter_leading_zeros, $counter_numbers_directory, $counter_filename_part_a, $counter_filetype);
array_push($data_transfer_create_array, $counter_numbers_directory, $counter_value_dummy, $counter_filename_part_a, $counter_value_dummy, $counter_filetype, $counter_numbers_spacing, $counter_color_workspace_red, $counter_color_workspace_green, $counter_color_workspace_blue, $directory_numbers_access_denied, $counter_images_not_completely, $error_old_images_delete_false);
if(empty($counter_mode)) {
   $counter_image_file_path="";
} elseif($counter_mode == 1) {
   $website_user_existed = counter_user_read_write($data_transfer_user_read_write_array);
   if(empty($website_user_existed)) {
      $counter_value = counter_write($data_transfer_write_array);
      $data_transfer_format_array[0] = $counter_value;
      $counter_format_array = counter_format($data_transfer_format_array);
      $data_transfer_create_array[1] = $counter_format_array[0];
      $data_transfer_create_array[3] = $counter_format_array[1];
      $counter_image_file_path = create_graphic_counter($data_transfer_create_array);
   }
   else
   {
      $counter_value = counter_read($data_transfer_read_array);
      if(empty($counter_value)) {
         $counter_value = counter_write($data_transfer_write_array);
      }
      $data_transfer_format_array[0] = $counter_value;
      $counter_format_array = counter_format($data_transfer_format_array);
      if(!file_exists($counter_format_array[0])) {
         // nur in Nutzung bei gleichzeitiger Aenderung von $counter_mode und $counter_filetype (KONFIGURATION)
        $data_transfer_create_array[1] = $counter_format_array[0];
        $data_transfer_create_array[3] = $counter_format_array[1];
        $counter_image_file_path = create_graphic_counter($data_transfer_create_array); 
      }
      else
      {
      $counter_image_file_path = $counter_format_array[0];
      }
   }
}
else
{
$counter_value = counter_write($data_transfer_write_array);
$data_transfer_format_array[0] = $counter_value;
$counter_format_array = counter_format($data_transfer_format_array);
$data_transfer_create_array[1] = $counter_format_array[0];
$data_transfer_create_array[3] = $counter_format_array[1];
$counter_image_file_path = create_graphic_counter($data_transfer_create_array);
}

if(empty($counter_image_file_path)) {
   $counter_html_code="";
} elseif(!empty($counter_image_file_path) && file_exists($counter_image_file_path) && filesize($counter_image_file_path) > 100 ) {
   $counter_image_size = getimagesize($counter_image_file_path);
   $counter_html_code = "<img src=\"" . $counter_image_file_path . "\" " . $counter_image_size[3] . " border=\"0\">";
}
else
{
$counter_html_code = "<div style=\"color:#FF0000;\">" . $error_file_not_found . "</div>";
}
?>