<?php
// +++ ANFANG KONFIGURATION +++
$cookie_name = "TEXT_COUNTER"; // Name des Cookies
$counter_mode=2; // Modus: 0 .. kein Counter, 1 .. Benutzer der Webseite zaehlen, 2 .. Aufrufe, Zugriffe auf die Webseite zaehlen
$counter_leading_zeros=1; // aktuellen Counterstand mit Nullen aufuellen; 0 .. keine fuehrenden Nullen, 1 .. auffuellen mit Nullen (default)
$counter_filename = "./counter.txt"; // Name der Datei mit dem aktuellen Counterstand
$counter_max_value=1000000; // maximaler Counterstand; 10 .. 9999999; 1000000 (default)
$counter_file_access=0644; // Zugriffsberechtigung fuer die Datei mit dem aktuellen Counterstand; mögliche Werte: 0666, 0664, 0644 (default), 0600
$work_direcktory = strrchr(getcwd(),"/"); // Ermittlung des aktuellen Arbeitsverzeichnisses
$directory_access_denied="<b>Zugriffsverweigerung: " . $work_direcktory . ". </b><br>Die Zugriffsberechtigung des Arbeitsverzeichnisses sollte die Erstellung der Datei <b>" . $counter_filename . "</b> erlauben!!";
// +++ ENDE KONFIGURATION +++
if(empty($include_key)) exit; // verhindert die Ausfuehrung der include-Datei bei einem direkten Aufruf

function counter_write($CounterFilename, $CounterMaxValue, $CounterFileAccess, $DirectoryAccessDenied) {
   if(!file_exists($CounterFilename)) {
      @touch($CounterFilename) or die($DirectoryAccessDenied);
      @chmod($CounterFilename, $CounterFileAccess);
      $CounterValue=0;
   }
   else
   {
   $FileRead = @fopen($CounterFilename,"r");
   $CounterNumber = @fgets($FileRead,10);
   @fclose($FileRead);
   $CounterValue = trim($CounterNumber);
   }
   if(empty($CounterValue)) $CounterValue=0;
   if(!preg_match("/^[0-9]{1,7}$/",$CounterValue)) $CounterValue=0;
   $CounterValue++;
   // $CounterMaxValue - ungueltiger Wert wird durch den default-Wert ersetzt
   if(!preg_match("/^[1-9][0-9]{1,6}$/",$CounterMaxValue)) $CounterMaxValue=1000000;
   if($CounterValue > $CounterMaxValue) $CounterValue=1;
   if($FileWrite = @fopen($CounterFilename,'w')) {
      @flock($FileWrite,2);
      @fwrite($FileWrite,$CounterValue,10);
      @flock($FileWrite,3);
      @fclose($FileWrite);
   }
   return $CounterValue;
}

function counter_read($CounterFilename, $CounterMaxValue) {
   if(file_exists($CounterFilename) && is_readable($CounterFilename)) {
      $FileRead = @fopen($CounterFilename,"r");
      $CounterNumber = @fgets($FileRead,10);
      @fclose($FileRead);
      $CounterValue = trim($CounterNumber);
   }
   if(empty($CounterValue)) $CounterValue=0;
   if(!preg_match("/^[0-9]{1,7}$/",$CounterValue)) $CounterValue=0;
   // $CounterMaxValue - ungueltiger Wert wird durch den default-Wert ersetzt
   if(!preg_match("/^[1-9][0-9]{1,6}$/",$CounterMaxValue)) $CounterMaxValue=1000000;
   if($CounterValue > $CounterMaxValue) $CounterValue=0;
   return $CounterValue;
}

function counter_format($CounterValue, $CounterMaxValue, $CounterLeadingZeros) {
   if(!empty($CounterLeadingZeros) && $CounterLeadingZeros == 1) {
      $LenghtCounterValue = strlen($CounterValue);
      // $CounterMaxValue - ungueltiger Wert wird durch den default-Wert ersetzt
      if(!preg_match("/^[1-9][0-9]{1,6}$/",$CounterMaxValue)) $CounterMaxValue=1000000;
      $LenghtCounterMaxValue = strlen($CounterMaxValue);
      for($x=$LenghtCounterValue; $x<$LenghtCounterMaxValue; $x++) {
         $CounterValue = "0" . $CounterValue;
      }
   }
   return $CounterValue;
}

if(empty($counter_mode)) {
   $counter_value = "";
} elseif($counter_mode==1) {
   if(!isset($_COOKIE["$cookie_name"])) {
      $counter_value = counter_write($counter_filename, $counter_max_value, $counter_file_access, $directory_access_denied);
      setcookie("$cookie_name","$counter_value",0,"/");
   }
   else
   {
      $counter_value = counter_read($counter_filename, $counter_max_value);
      if(empty($counter_value)) {
   	   $counter_value = counter_write($counter_filename, $counter_max_value, $counter_file_access, $directory_access_denied);
      }
      setcookie("$cookie_name","$counter_value",0,"/");
   }
   if(!empty($counter_leading_zeros)) {
      $counter_value = counter_format($counter_value, $counter_max_value, $counter_leading_zeros);
   }
}
else
{
   $counter_value = counter_write($counter_filename, $counter_max_value, $counter_file_access, $directory_access_denied);
   setcookie("$cookie_name","$counter_value",0,"/");
   if(!empty($counter_leading_zeros)) {
      $counter_value = counter_format($counter_value, $counter_max_value, $counter_leading_zeros);
   }
}
?>