<?php
function file_info($NextDirectory) {
   $FileInfoArray=array();
   $DirectoryArray=array();
   $FileNameArray=array();
   $FileCtimeArray=array();
   $FileMtimeArray=array();
   $FileAtimeArray=array();
   $FileAccessRightArray=array();
   array_push($DirectoryArray, $NextDirectory);
   $DirectoryArrayCount=count($DirectoryArray);
   for($x=0; $x<$DirectoryArrayCount; $x++) {
      $Handle=opendir($DirectoryArray[$x]);
      while($FileName = readdir($Handle)) {
         if($FileName != "." && $FileName != "..") {
            $NextDirectory=$DirectoryArray[$x] . "/" . $FileName;
            if(is_dir($NextDirectory)) {
               array_push($DirectoryArray, $NextDirectory);
               $DirectoryArrayCount=count($DirectoryArray);
            }
            else
            {
            array_push($FileNameArray, $NextDirectory);
            }
         }
      }
      clearstatcache();
      closedir($Handle);
   }
   // Flags: SORT_REGULAR (Default-Wert), SORT_NUMERIC, SORT_STRING, SORT_LOCALE_STRING
   sort($FileNameArray, SORT_REGULAR);
   $FileNameArrayCount=count($FileNameArray);
   for($y=0; $y<$FileNameArrayCount; $y++) {
      array_push($FileCtimeArray, date("d.m.Y - H:i:s", filectime($FileNameArray[$y])));
      array_push($FileMtimeArray, date("d.m.Y - H:i:s", filemtime($FileNameArray[$y])));
      array_push($FileAtimeArray, date("d.m.Y - H:i:s", fileatime($FileNameArray[$y])));
      $FileAccessRight=substr(decoct(fileperms($FileNameArray[$y])), -4);
      array_push($FileAccessRightArray, $FileAccessRight);
   }
   array_push($FileInfoArray, $FileNameArray);
   array_push($FileInfoArray, $FileCtimeArray);
   array_push($FileInfoArray, $FileMtimeArray);
   array_push($FileInfoArray, $FileAtimeArray);
   array_push($FileInfoArray, $FileAccessRightArray);
   return $FileInfoArray;
}

$start_directory=".";
$file_info_array=file_info($start_directory);
$consecutive_number=0;
$file_info_array_count=count($file_info_array[0]);
$table_content="          <tbody>\n";
for($z=0; $z < $file_info_array_count; $z++) {
   $consecutive_number++;
   $table_content .= "             <tr>\n";
   $table_content .=  "              <td>" . $consecutive_number . "</td>\n";
   $table_content .=  "              <td>" . $file_info_array[0][$z] . "</td>\n";
   $table_content .=  "              <td>" . $file_info_array[1][$z] . "</td>\n";
   $table_content .=  "              <td>" . $file_info_array[2][$z] . "</td>\n";
   $table_content .=  "              <td>" . $file_info_array[3][$z] . "</td>\n";
   $table_content .=  "              <td class=\"center\">" . $file_info_array[4][$z] . "</td>\n";
   $table_content .=  "             </tr>\n";
}
$table_content .= "           </tbody>\n";
$table_content .= "           <tfoot>\n";
$table_content .= "             <tr>\n";
$table_content .= "               <td colspan=\"6\">&nbsp;</td>\n";
$table_content .= "             </tr>\n";
$table_content .= "           </tfoot>\n";
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>PHP-Editor script3x.php</title>
<style type="text/css">
body {
  margin: 10px 15px 15px 10px;
  font-family: "Nimbus Sans L",Arial;
}

#wrapper {
  display: block;
  justify-content: center;
}

h1 {
  font-size: 14px;
  font-weight: bold;
}

header, main, footer {
  display: flex;
  justify-content: center;
}

.center { text-align: center; }

table {
  border-collapse: seperate;
  border-spacing: 2px;
  background-color: #00AEAE;
}

th {
  padding: 2px 5px 2px 5px;
  font-size: 12px;
  text-align: center;
  font-weight: bold;
  background-color: #00AEAE;
}

td {
  padding: 2px 5px 2px 5px;
  font-size: 12px;
  background-color: #FFFFFF;
}

.th_width { width: 350px; }

p { font-size: 12px; }

</style>
</head>
<body>
<div id="wrapper">
  <header>
    <h1>Informationen &uuml;ber Dateien des aktuelle Verzeichnis und seiner evtl. Unterverzeichnisse</h1>
  </header>
  <main>
    <article>
        <table>
          <thead>
            <tr>
              <th>Lfd.-Nr.:</th>
              <th class="th_width">Dateiname</th>
              <th>letzte &Auml;nderung<br>der Datei</th>
              <th >letzte &Auml;nderung<br>des Inhaltes</th>
              <th>letzter Zugriff<br>auf die Datei</th>
              <th>Zugriffsrechte<br>der Datei</th>
            </tr>
          </thead>
<?php echo $table_content; ?>
        </table>
    </article>
  </main>
  <footer>
    <p>&nbsp;</p>
  </footer>
</div>
</body>
</html>