<?php
if(isset($_POST["year_search"]) &&
   isset($_POST["month_search"]) &&
   !empty($_POST["create_calendar"])) {
   $current_year=trim($_POST["year_search"]);
   if(!preg_match("(^[1-9]{1,1}[0-9]{0,3}$)",$current_year)) $current_year=date("Y");
   $current_month=trim($_POST["month_search"]);
   if(!preg_match("(^[1-9]{1}[0-9]{0,1}$)",$current_month))  $current_month=1;
   if($current_month > 12) $current_month=12;
   $month_days_count=date("t",mktime(0,0,0,$current_month,1,$current_year));
}
else
{
$current_year=date("Y");
$current_month=date("n");
$month_days_count=date("t");
}
$current_month_name=date("F",mktime(0,0,0,$current_month,1,$current_year));
$first_weekday_name=date("w",mktime(0,0,0,$current_month,1,$current_year));

$calendar_array=array();
for($x=0; $x<$first_weekday_name; $x++) {
   $calendar_array[] = "";
}

for($y=1; $y<=$month_days_count; $y++) {
   $calendar_array[] = $y;
}

$calendar_array_count=count($calendar_array);
for($z=$calendar_array_count; $z<42; $z++) {
   $calendar_array[] = "";
}

$table_content = "          <tbody>\n";
$z=0;
for($x=0; $x < 6; $x++) {
   $table_content .= "             <tr>\n";
   for($y=0; $y < 7; $y++) {
      if(!empty($calendar_array[$z])) {
         if($y == 0) {
            $table_content .="               <td class=\"center_red\">". $calendar_array[$z] ."</td>\n";
         }
         else
         {
         $table_content .="               <td class=\"center\">". $calendar_array[$z] ."</td>\n";
         }
      } 
      else
      {
      $table_content .="               <td class=\"center\">&nbsp;</td>\n";
      }
      $z++;
   }
   $table_content .="             </tr>\n";
}
$table_content .="          </tbody>\n";
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>PHP-Editor script4x.php</title>
<style type="text/css">
/* CSS-Kommentar
 generische Schriftarten oder Schriftklassen
 serif, sans-serif, monospace, cursive und fantasy
 Hinweis: Die generischen Schriftarten sollten von jeden Internet-Browser unterstuetzt werden.
*/
body {
  margin: 10px 15px 15px 10px;
  font-family: Arial, sans-serif;
}

#wrapper {
  display: block;
  justify-content: center;
}

h1 {
  font-family: monospace;
  font-size: 14px;
  font-weight: bold;
}

header, main, footer {
  display: flex;
  justify-content: center;
}

table {
  border-collapse: seperate;
  border-spacing: 2px;
  background-color: #ADADAD;
}

th {
  padding: 2px 5px 2px 5px;
  font-family: monospace;
  font-size: 12px;
  text-align: center;
  font-weight: bold;
  background-color: #00C3FF;
}

td {
  padding: 2px 5px 2px 5px;
  font-size: 12px;
  background-color: #00C3FF;
}

input[type="number"], input[type="submit"] {
  font-size: 12px;
  text-align: center;
}

.center {
  font-family: cursive;
  font-size: 12px;
  text-align: center;
  background-color: #FFFFFF;
}

.td_right { text-align: right; }

.red { color: #FF0000; }

.center_red {
  font-family: cursive;
  font-size: 12px;
  text-align: center;
  color: #FF0000;
  background-color: #FFFFFF;
}

.grey {
  font-size: 12px;
  background-color: #DFDFDF;
}

.center_grey {
  font-size: 12px;
  text-align: center;
  background-color: #DFDFDF;
}

.small {
  font-size: 10px;
  background-color: #DFDFDF;
}

p { font-size: 12px; }

</style>
</head>
<body>
<div id="wrapper">
  <header>
    <h1>Monatskalender</h1>
  </header>
  <main>
    <article>
      <form id="form_a" action="./script4a.php" target="_self" method="post">
        <table>
          <thead>
            <tr>
              <td class="small">Jahr</td>
              <td class="grey"><?php echo $current_year; ?></td>
              <td  class="center_grey" colspan="3">Monat: <?php echo $current_month_name; ?></td>
              <td class="small">Jahr</td>
              <td class="grey"><?php echo $current_year; ?></td>
            </tr>
            <tr>
              <th class="red">Sonntag</th>
              <th>Montag</th>
              <th>Dienstag</th>
              <th>Mittwoch</th>
              <th>Donnerstag</th>
              <th>Freitag</th>
              <th>Sonnabend</th>
            </tr>
          </thead>
<?php echo $table_content; ?>
          <tfoot>
            <tr>
              <td class="td_right"><label>Jahr:</label></td>
              <td><input type="number" name="year_search" value="<?php echo $current_year; ?>" size="4" maxlength="4"></td>
              <td class="td_right"><label>Monat:</label></td>
              <td><input type="number" name="month_search" value="<?php echo $current_month; ?>" size="2" maxlength="2"></td>
              <td colspan="3"><input form="form_a" type="submit" name="create_calendar" value="&laquo; Go &raquo;"></td>
            </tr>
          </tfoot>
        </table>
      </form>
    </article>
  </main>
  <footer>
    <p>&nbsp;</p>
  </footer>
</div>
</body>
</html>