<?php
// +++ ANFANG KONFIGURATION +++
$logbook_enable=1; // Logbook freigeben; 1 .. aktiviert, 0 .. deaktiviert; 1 (default)
$logbook_email_address = "webmaster@domain.de"; // Email-Adresse des Empfaengers
$logbook_email_send_enable=1; // Logbook und Fehlermeldungen per Email versenden; moegliche Werte: 1 .. aktiviert, 0 .. deaktiviert; 1 (default)
$logbook_email_subject = "Webseite.de - Logbook"; // Email-Betreff
$logbook_email_first_line = "Logbook von Webseite.de,"; // Email - 1.Zeile; Name der Webseite
$logbook_email_second_line = "hier wieder das aktuelle Logbuch von der Website: Webseite.de."; // Email - 2.Zeile
$logbook_email_end_line = "Ciao >>Logbook-Webmaster<<"; // Email - Abspann, letzte Zeile
$logbook_maximal_line=1000; // max. Anzahl der Logbook-Eintraege; bei Erreichung wird das Logbook per Email gesendet; moegliche Werte 10 .. 99999, 1000 (default)
$logbook_send_date=14; // Email senden nach X Tagen, auch wenn die maximale Zahl der Eintraege noch nicht erreicht wurde; moegliche Werte 1 .. 99, 14 (default)
$server_standard_charset = 'ISO-8859-1'; // Textkodierung, Charset des PHP-Servers, siehe: PHP-Funktion -> phpinfo()
$client_standard_charset = 'UTF-8'; // Textkodierung, Charset des Clients, Rechner der die Email empfaengt
$logbook_text_directory = "./txt"; // Name des Verzeichnisses fuer die Textdateien
$logbook_directory_access=0755; // Zugriffsberechtigung fuer das Verzeichnis mit den Textdateien; moegliche Werte: 0777, 0775, 0755 (default), 0700
$logbook_data_name = "logbook.txt"; // Dateiname des Logbooks
$error_send_data_name = "error_send_messages.txt"; // Datei mit den Fehlermeldungen anlegen, wenn Email-Versand deaktiviert wurde
$error_send_maximal_line=100; // max. Anzahl der Error-Eintraege; bei Erreichung werden die alten Eintraege ueberschrieben; moegliche Werte 10 .. 999, 100 (default)
$logbook_file_access=0644; // Zugriffsrechte des Logbooks; moegliche Werte: 0666, 0664, 0644 (default), 0600 
$logbook_error_email_subject = "Webseite.de - Logbook-Fehlermeldung"; // Email-Betreff
$logbook_error_email_first_line = "Logbook-Fehlermeldung von Webseite.de,"; // Email - 1.Zeile; Name der Webseite
$logbook_error_email_second_line = "auf der Website Webseite.de wurde vom Logbook-Skript ein schwerwiegender Fehler festgestellt (siehe: Return-Code)."; // Email - 2.Zeile
$logbook_error_email_end_line = "Ciao <<LOGBOOK-WEBMASTER>>"; // Email - Abspann, letzte Zeile
$directory_text_access_denied = "<b>Zugriffsverweigerung:</b><br>Die Zugriffsberechtigung des Arbeitsverzeichnisses sollte die Erstellung des Verzeichnisses " . $logbook_text_directory . " erlauben!!";
// +++ ENDE KONFIGURATION +++
if(empty($include_key)) exit; // verhindert die Ausfuehrung der include-Datei bei einem direkten Aufruf

// Verzeichnis fuer die Logbook-Textdateien anlegen
if(!is_dir($logbook_text_directory)) {
   @mkdir($logbook_text_directory, $logbook_directory_access) or die($directory_text_access_denied);
}

// +++ Bereich: Logbook-Funktionen +++

function logbook_check($LogbookCheckArray='') {
   $ReturnCode=6;
   if(!empty($LogbookCheckArray) && is_array($LogbookCheckArray)) {
      $LogbookCheckArrayCount = count($LogbookCheckArray);
      if($LogbookCheckArrayCount == 3) {
         $LogbookFilePath = $LogbookCheckArray[0] . "/" . $LogbookCheckArray[1];
         if(file_exists($LogbookFilePath) && is_readable($LogbookFilePath)) {
            $LogbookContentArray = @file($LogbookFilePath);
            $LogbookContentArrayCount = count($LogbookContentArray);
            $LogbookEmailTime = trim($LogbookContentArray[0]);
            $LogbookDataRecordsCount = $LogbookContentArrayCount - 1;
            $LogbookCurrentTime = time();
            if($LogbookEmailTime < $LogbookCurrentTime || $LogbookDataRecordsCount >= $LogbookCheckArray[2]) {
               $ReturnCode=2;
            }
            else
            {
            $ReturnCode=0;
            }             
         } elseif(file_exists($LogbookFilePath) && !is_readable($LogbookFilePath)) {
            $ReturnCode=6;
         }
         else
         {
         $ReturnCode=1;
         }
      }
      else
      {
      print '<b>SYSTEM-ARRAY FUNCTION: logbook_check() IS DAMAGED!</b>';
      exit;
      }
   }
   else
   {
   print '<b>SYSTEM-ARRAY FUNCTION: logbook_check() IS DAMAGED!</b>';
   exit;
   }
   return $ReturnCode;
}

function logbook_create($LogbookCreateArray='') {
   $ReturnCode=7;
   if(!empty($LogbookCreateArray) && is_array($LogbookCreateArray)) {
      $LogbookCreateArrayCount = count($LogbookCreateArray);
      if($LogbookCreateArrayCount == 4) {
         // Unix-Timestamp des Sende- und Loeschdatums
         $LogbookEmailTime = time() + (3600 * 24 * $LogbookCreateArray[3]);
         $LogbookContent = $LogbookEmailTime . "\n";
         $LogbookFilePath = $LogbookCreateArray[0] . "/" . $LogbookCreateArray[1];
         if(file_exists($LogbookFilePath)) {
            @unlink($LogbookFilePath);
         }
         if(!file_exists($LogbookFilePath)) {
            @touch($LogbookFilePath);
            @chmod($LogbookFilePath, $LogbookCreateArray[2]);
            if($FileWrite = @fopen($LogbookFilePath,'w')) {
               $CreateReturnCode=0;
               @flock($FileWrite,2) or $CreateReturnCode++;
               @fwrite($FileWrite,$LogbookContent) or $CreateReturnCode++;
               @flock($FileWrite,3) or $CreateReturnCode++;
               @fclose($FileWrite) or $CreateReturnCode++;
               if($CreateReturnCode == 0) $ReturnCode=0;
            }
         }
         else
         {
         $ReturnCode=4;
         }
         if(!file_exists($LogbookFilePath)) $ReturnCode=3;
      }
      else
      {
      print '<b>SYSTEM-ARRAY FUNCTION: logbook_create() IS DAMAGED!</b>';
      exit;
      }
   }
   return $ReturnCode;
}

function logbook_write($LogbookWriteArray='') {
   $ReturnCode=8;
   if(!empty($LogbookWriteArray) && is_array($LogbookWriteArray)) {
      $LogbookWriteArrayCount = count($LogbookWriteArray);
      if($LogbookWriteArrayCount == 8) {
         $LogbookFilePath = $LogbookWriteArray[4] . "/" . $LogbookWriteArray[5];
         if(file_exists($LogbookFilePath) && is_writable($LogbookFilePath)) {
            $LogbookContentArray = @file($LogbookFilePath);
            $logbookLineNumber = count($LogbookContentArray);
            $LineNumberLength = strlen($logbookLineNumber);
            if($LineNumberLength < 5) {
               $y = 5 - $LineNumberLength;
               for($x=0; $x<$y; $x++) {
                  $logbookLineNumber = "0" . $logbookLineNumber ;
               }
            }
            if(empty($LogbookWriteArray[0])) $LogbookWriteArray[0] = "EMPTY";
            if(empty($LogbookWriteArray[1])) $LogbookWriteArray[1] = "EMPTY";
            if(empty($LogbookWriteArray[2])) $LogbookWriteArray[2] = "EMPTY";
            $RemoteAddrLength = strlen($LogbookWriteArray[0]);
            $RemotePortLength = strlen($LogbookWriteArray[1]);
            // Lesbarkeit der Logbook-Tabelle verbessern
            $RemoteAddrBlankAddition=0;
            if($RemoteAddrLength < $LogbookWriteArray[6]) $RemoteAddrBlankAddition = $LogbookWriteArray[6] - $RemoteAddrLength;
            $RemotePortBlankAddition=0;
            if($RemotePortLength < $LogbookWriteArray[7]) $RemotePortBlankAddition = $LogbookWriteArray[7] - $RemotePortLength;
            $RemoteAddrSpace="";
            for($i=0; $i<$RemoteAddrBlankAddition; $i++) {
               $RemoteAddrSpace = $RemoteAddrSpace . " ";
            }
            $RemotePortSpace="";
            for($i=0; $i<$RemotePortBlankAddition; $i++) {
               $RemotePortSpace = $RemotePortSpace . " ";
            }
            $LogbookNewLine = "  " . $logbookLineNumber . "  |";
            $LogbookNewLine .= " " . $LogbookWriteArray[3] . " |";
            $LogbookNewLine .= " " . $LogbookWriteArray[0] . $RemoteAddrSpace . " |";
            $LogbookNewLine .= " " . $RemotePortSpace . $LogbookWriteArray[1] . " |";
            $LogbookNewLine .= " " . $LogbookWriteArray[2] . "\n";
            if($FileWrite = @fopen($LogbookFilePath,'a')) {
               $WriteReturnCode=0;
               @flock($FileWrite,2) or $WriteReturnCode++;
               @fwrite($FileWrite,$LogbookNewLine) or $WriteReturnCode++;
               @flock($FileWrite,3) or $WriteReturnCode++;
               @fclose($FileWrite) or $WriteReturnCode++;
               if($WriteReturnCode == 0) $ReturnCode=0;
            }
         } elseif(file_exists($LogbookFilePath) && !is_writable($LogbookFilePath)) {
            $ReturnCode=8;
         }
         else
         {
         $ReturnCode=5;
         } 
      }
      else
      {
      print '<b>SYSTEM-ARRAY FUNCTION: logbook_write() IS DAMAGED!</b>';
      exit;
      }
   }
   return $ReturnCode;
}

function logbook_send($LogbookSendArray='') {
   $ReturnCode=9;
   if(!empty($LogbookSendArray) && is_array($LogbookSendArray)) {
      $LogbookSendArrayCount = count($LogbookSendArray);
      if($LogbookSendArrayCount == 12) {
         $LogbookFilePath = $LogbookSendArray[2] . "/" . $LogbookSendArray[3];
         if(!empty($LogbookSendArray[0]) &&
            file_exists($LogbookFilePath) &&
            is_readable($LogbookFilePath)) {
           $EmailTo = $LogbookSendArray[1];
           $EmailSubject = $LogbookSendArray[4];
           $EmailBody = $LogbookSendArray[5] . "\n";
           $EmailBody .= $LogbookSendArray[6] . "\n";
           $EmailBody .= $LogbookSendArray[7] . "\n\n";
           $EmailBody .= $LogbookSendArray[8];
           $LogbookFileArray=@file($LogbookFilePath);
           $LogbookFileArrayCount=count($LogbookFileArray);
           for($x=1; $x<$LogbookFileArrayCount; $x++) {
              $EmailBody .= $LogbookFileArray[$x];
           }
           $EmailBody .= "\n\n";
           $Header = "MIME-Version: 1.0\n";
           $Header .= "Content-type: text/plain; charset=utf-8\n"; // Content-type: text/html; charset=utf-8; oder Content-type: text/plain; charset=iso-8859-1;
           $Header .= "To: " . $LogbookSendArray[1] . "\n";
           $Header .= "From: Webmaster <" . $LogbookSendArray[1] . ">\n"; // $Header .= "From: Webmaster <" . $LogbookSendArray[1] . ">\n";
           $Header .= "Reply-To: " . $LogbookSendArray[1] . "\n";
           // $Header .= "Cc: \n"; // Kopie an ...
           // $Header .= "Bcc: \n"; // Blind-Copy an ...
           $Header .= "Date: " . date("r") . "\n"; // formatiertes Datum nach Standard - RFC 2822
           $Header .= "X-Mailer: PHP/" . phpversion() . "\n"; 
           $Header .= "X-Sender-IP: " . $_SERVER['REMOTE_ADDR'] . "\n";
           $EmailArray = array($EmailTo, $EmailSubject, $EmailBody, $Header);
           if(!empty($LogbookSendArray[9]) && !empty($LogbookSendArray[10])) {
              $CharsetServerClientCompare = strcasecmp($LogbookSendArray[9], $LogbookSendArray[10]);
              if($CharsetServerClientCompare != 0) {
                 if(extension_loaded("iconv")) {
                    $EmailArrayCount = count($EmailArray);
                    for($i=0; $i<$EmailArrayCount; $i++) {
                       $EmailArray[$i] = iconv($LogbookSendArray[9], $LogbookSendArray[10], $EmailArray[$i]);
                    }
                 }
              }
           }
           $SendReturnCode=0;
           @mail($EmailArray[0], $EmailArray[1], $EmailArray[2], $EmailArray[3]) or $SendReturnCode++;
           if($SendReturnCode == 0) $ReturnCode=0;
         } elseif(empty($LogbookSendArray[0]) &&
              file_exists($LogbookFilePath) &&
              is_readable($LogbookFilePath)) {
              $LogbookNewFilename = date("d-m-Y_H-i-s") . "_" . $LogbookSendArray[3]; 
              $LogbookNewFilePath = $LogbookSendArray[2] . "/" . $LogbookNewFilename;
              @touch($LogbookNewFilePath);
              @chmod($LogbookNewFilePath, $LogbookSendArray[11]);
              $LogbookContentArray = @file($LogbookFilePath);
              $LogbookContentArrayCount = count($LogbookContentArray);
              $LogbookNewContent = $LogbookSendArray[8];
              for($x=1; $x<$LogbookContentArrayCount; $x++) {
                 $LogbookNewContent .= $LogbookContentArray[$x];
              }
              if(!empty($LogbookSendArray[9]) && !empty($LogbookSendArray[10])) {
                 $CharsetServerClientCompare = strcasecmp($LogbookSendArray[9], $LogbookSendArray[10]);
                 if($CharsetServerClientCompare != 0) {
                    if(extension_loaded("iconv")) {
                       $LogbookNewContent = iconv($LogbookSendArray[9], $LogbookSendArray[10], $LogbookNewContent);
                    }
                 }
              }
              if($FileWrite = @fopen($LogbookNewFilePath,'w')) {
                 $SendReturnCode=0;
                 @flock($FileWrite,2) or $SendReturnCode++;
                 @fwrite($FileWrite,$LogbookNewContent) or $SendReturnCode++;
                 @flock($FileWrite,3) or $SendReturnCode++;
                 @fclose($FileWrite) or $SendReturnCode++;
                 if($SendReturnCode == 0) $ReturnCode=0;
              }
         } elseif((file_exists($LogbookFilePath) && !is_readable($LogbookFilePath))) {
            $ReturnCode=8;
         }
         else
         {
         $ReturnCode=5;
         }
      }
      else
      {
      print '<b>SYSTEM-ARRAY FUNCTION: logbook_send() IS DAMAGED!</b>';
      exit;
      }
   }
   return $ReturnCode;
}

function logbook_error_send($LogbookErrorSendArray='', $LogbookReturnCodeArray='') {
   if(!empty($LogbookErrorSendArray) &&
      is_array($LogbookErrorSendArray) &&
      !empty($LogbookReturnCodeArray) &&
      is_array($LogbookReturnCodeArray)) {
      $LogbookErrorSendArrayCount = count($LogbookErrorSendArray);
      $LogbookReturnCodeArrayCount = count($LogbookReturnCodeArray);
      if($LogbookErrorSendArrayCount == 13 &&
         $LogbookReturnCodeArrayCount == 10 &&
         preg_match("/^[0-9]$/",$LogbookErrorSendArray[0])) {
         $ReturnCodeSend = $LogbookErrorSendArray[0]; 
         if(!empty($LogbookErrorSendArray[1])) {           
            $EmailTo = $LogbookErrorSendArray[2];
            $EmailSubject = $LogbookErrorSendArray[3];
            $EmailBody = $LogbookErrorSendArray[4] . "\n";
            $EmailBody .= $LogbookErrorSendArray[5] . "\n\n";
            $EmailBody .= "   " . $LogbookReturnCodeArray[$ReturnCodeSend] . "\n\n";
            $EmailBody .= $LogbookErrorSendArray[6] . "\n\n";
            $EmailBody .= "\n\n";
            $Header = "MIME-Version: 1.0\n";
            $Header .= "Content-type: text/plain; charset=utf-8\n"; // Content-type: text/html; charset=utf-8; oder Content-type: text/plain; charset=iso-8859-1;
            $Header .= "To: " . $LogbookErrorSendArray[2] . "\n";
            $Header .= "From: Webmaster <" . $LogbookErrorSendArray[2] . ">\n"; // $Header .= "From: Webmaster <" . $LogbookErrorSendArray[2] . ">\n";
            $Header .= "Reply-To: " . $LogbookErrorSendArray[2] . "\n";
            // $Header .= "Cc: \n"; // Kopie an ...
            // $Header .= "Bcc: \n"; // Blind-Copy an ...
            $Header .= "Date: " . date("r") . "\n"; // formatiertes Datum nach Standard - RFC 2822
            $Header .= "X-Mailer: PHP/" . phpversion() . "\n"; 
            $Header .= "X-Sender-IP: " . $_SERVER['REMOTE_ADDR'] . "\n";
            $EmailArray = array($EmailTo, $EmailSubject, $EmailBody, $Header);
            if(!empty($LogbookErrorSendArray[7]) && !empty($LogbookErrorSendArray[8])) {
               $CharsetServerClientCompare = strcasecmp($LogbookErrorSendArray[7], $LogbookErrorSendArray[8]);
               if($CharsetServerClientCompare != 0) {
                  if(extension_loaded("iconv")) {
                     $EmailArrayCount = count($EmailArray);
                     for($i=0; $i<$EmailArrayCount; $i++) {
                        $EmailArray[$i] = iconv($LogbookErrorSendArray[7], $LogbookErrorSendArray[8], $EmailArray[$i]);
                     }
                  }
               }
            }
            @mail($EmailArray[0], $EmailArray[1], $EmailArray[2], $EmailArray[3]);
         }
         else
         {
            $ErrorSendFilePath = $LogbookErrorSendArray[9] . "/" . $LogbookErrorSendArray[10];
            if(!file_exists($ErrorSendFilePath)) {
               @touch($ErrorSendFilePath);
               @chmod($ErrorSendFilePath, $LogbookErrorSendArray[11]);
            }
            if(file_exists($ErrorSendFilePath) && is_writable($ErrorSendFilePath)) {
               $ErrorSendContentArray = @file($ErrorSendFilePath);
               $ErrorSendContentArrayCount = count($ErrorSendContentArray);
               $ErrorSendContent = date("d-m-Y - H:i:s") . " | " . $LogbookReturnCodeArray[$ReturnCodeSend] . "\n";
               if(!empty($LogbookErrorSendArray[7]) && !empty($LogbookErrorSendArray[8])) {
                  $CharsetServerClientCompare = strcasecmp($LogbookErrorSendArray[7], $LogbookErrorSendArray[8]);
                  if($CharsetServerClientCompare != 0) {
                     if(extension_loaded("iconv")) {
                        $ErrorSendContent = iconv($LogbookErrorSendArray[7], $LogbookErrorSendArray[8], $ErrorSendContent);
                     }
                  }
               }
               if($ErrorSendContentArrayCount < $LogbookErrorSendArray[12]) {
                  $FileWrite = @fopen($ErrorSendFilePath,'a');
               }
               else
               {
               $FileWrite = @fopen($ErrorSendFilePath,'w');
               }
               @flock($FileWrite,2);
               @fwrite($FileWrite,$ErrorSendContent);
               @flock($FileWrite,3);
               @fclose($FileWrite);
            }
            else
            {
            print '<b>SYSTEM-FILE ' . $ErrorSendFilePath . ' - FUNCTION: logbook__error_send() - CAN NOT CREATE THIS FILE!</b>';
            exit;
            }
         }
      }
      else
      {
      print '<b>SYSTEM-ARRAY FUNCTION: logbook__error_send() IS DAMAGED!</b>';
      exit;
      }
   }
   else
   {
   print '<b>SYSTEM-ARRAY FUNCTION: logbook__error_send() IS DAMAGED!</b>';
   exit;
   }
   // Funktion logbook_error_send() uebergibt keinen ReturnCode
}

// +++ Bereich: Pruefung einiger Konfigurationsvariablen +++

if(!preg_match("/^[0-1]$/",$logbook_enable)) $logbook_enable=1;
if(!preg_match("/^[0-1]$/",$logbook_email_send_enable)) $logbook_email_send_enable=1;
if(!preg_match("/^[1-9][0-9]{1,4}$/",$logbook_maximal_line)) $logbook_maximal_line=1000;
if(!preg_match("/^[1-9][0-9]{0,1}$/",$logbook_send_date)) $logbook_send_date=14;
if(!preg_match("/^[1-9][0-9]{1,2}$/",$error_send_maximal_line)) $error_send_maximal_line=100;
if(empty($logbook_directory_access)) $logbook_directory_access=0755;
if(empty($logbook_file_access)) $logbook_file_access=0644;

// +++ Bereich: Arrays fuer die Uebergabe an die Logbook-Funktionen +++

$logbook_check_array = array($logbook_text_directory,
                             $logbook_data_name,
                             $logbook_maximal_line);

$logbook_create_array = array($logbook_text_directory,
                              $logbook_data_name,
                              $logbook_file_access,
                              $logbook_send_date);
                              
// die laufende Nummer wird von der Funktion zu einer 5-stelligen Zahl ergaenzt; fuehrende Nullen
$logbook_data_records_date = date("D d.m.Y - H:i:s"); // immer die gleiche Zeichenanzahl
$logbook_ip_number_max_char_count=39; // IP v.6 -> 32 Zeichen + 7 Doppelpunkte (:)
$logbook_port_max_char_count=5; // der Port kann maximal 5-stellig sein
$logbook_write_array = array($_SERVER['REMOTE_ADDR'],
                             $_SERVER['REMOTE_PORT'],
                             $_SERVER['HTTP_USER_AGENT'],
                             $logbook_data_records_date,
                             $logbook_text_directory,
                             $logbook_data_name,
                             $logbook_ip_number_max_char_count,
                             $logbook_port_max_char_count);

// bei gleichbleibender Feldanzahl (5) der Tabelle, brauchen die Funktionen nicht geaendert werden
$logbook_table_head = "  LFD-NR |"; // 9 Zeichen + |
$logbook_table_head .= "      DATUM - UHRZEIT      |"; // 27 Zeichen + |
$logbook_table_head .= "        IP-NUMMER - IPv4 und IPv6        |"; // 41 Zeichen -> 39 + 2 Leerzeichen + |
$logbook_table_head .= " PORT  |"; // 7 Zeichen -> 5 + 2 Leerzeichen + |
$logbook_table_head .= "                 INTERNET-BROWSER                 \n"; // 50 Zeichen + \n 
$logbook_table_head .= "------------------------------------------------------------"; // 60 Zeichen
$logbook_table_head .= "------------------------------------------------------------"; // 60 Zeichen
$logbook_table_head .= "------------------------------------------------------------\n"; // 60 Zeichen + \n 
$logbook_send_array = array($logbook_email_send_enable,
                            $logbook_email_address,
                            $logbook_text_directory,
                            $logbook_data_name,
                            $logbook_email_subject,
                            $logbook_email_first_line,
                            $logbook_email_second_line,
                            $logbook_email_end_line,
                            $logbook_table_head,
                            $server_standard_charset,
                            $client_standard_charset,
                            $logbook_file_access);

$logbook_default_return_code=0;
$logbook_error_send_array = array($logbook_default_return_code,
                                  $logbook_email_send_enable,
                                  $logbook_email_address,
                                  $logbook_error_email_subject,
                                  $logbook_error_email_first_line,
                                  $logbook_error_email_second_line,
                                  $logbook_error_email_end_line,
                                  $server_standard_charset,
                                  $client_standard_charset,
                                  $logbook_text_directory,
                                  $error_send_data_name,
                                  $logbook_file_access,
                                  $error_send_maximal_line);
                             
$logbook_return_code_array = array('0 ... Aktion erfolgreich durchgefuehrt',
                                   '1 ... Anforderung: Erstellung eines Logbooks',
                                   '2 ... Logbook per Email senden',
                                   '3 ... Logbook - konnte NICHT erstellt werden',
                                   '4 ... altes Logbook konnte NICHT geloescht werden',
                                   '5 ... Logbook nicht gefunden',
                                   '6 ... Funktion logbook_check: Aktion fehlgeschlagen',
                                   '7 ... Funktion logbook_create: Aktion fehlgeschlagen',
                                   '8 ... Funktion logbook_write: Aktion fehlgeschlagen',
                                   '9 ... Funktion logbook_send: Aktion fehlgeschlagen');                                   
                                   
// +++ Bereich: Aufruf der Logbook-Funktionen +++

if(!empty($logbook_enable)) {
   $function_check_return_code = logbook_check($logbook_check_array);
   if(isset($function_check_return_code) && $function_check_return_code == 0) {
      // Function logbook_write() erstellt einen neuen Logbook-Eintrag
      $function_write_return_code = logbook_write($logbook_write_array);
      if(!empty($function_write_return_code)) {
         if($function_write_return_code == 5 || $function_write_return_code == 8) {
            $logbook_error_send_array[0] = $function_write_return_code;
            logbook_error_send($logbook_error_send_array, $logbook_return_code_array);
         }
         else 
         {
         print '<b>FUNCTION: logbook_write() IS DAMAGED - UNKNOWN RETURN-CODE!</b>';
         exit;
         }
      }
  } elseif(!empty($function_check_return_code) && $function_check_return_code == 1) {
      // Function logbook_create() erstellt einen neues Logbook
      $function_create_return_code = logbook_create($logbook_create_array);
      if(isset($function_create_return_code) && $function_create_return_code == 0) {
         // Function logbook_write() erstellt einen neuen Logbook-Eintrag
         $function_write_return_code = logbook_write($logbook_write_array);
         if(!empty($function_write_return_code)) {
            if($function_write_return_code == 5 || $function_write_return_code == 8) {
               $logbook_error_send_array[0] = $function_write_return_code;
               logbook_error_send($logbook_error_send_array, $logbook_return_code_array);
            }
            else 
            {
            print '<b>FUNCTION: logbook_write() IS DAMAGED - UNKNOWN RETURN-CODE!</b>';
            exit;
            }
         }
      } elseif(!empty($function_create_return_code)) {
          if($function_create_return_code == 3 || $function_create_return_code == 4 || $function_create_return_code == 7) {
             $logbook_error_send_array[0] = $function_create_return_code;
             logbook_error_send($logbook_error_send_array, $logbook_return_code_array);
          }
          else
          {
          print '<b>FUNCTION: logbook_create() IS DAMAGED - UNKNOWN RETURN-CODE!</b>';
          exit;
          }
      }
      else
      {
      print '<b>FUNCTION: logbook_create() IS DAMAGED - UNKNOWN RETURN-CODE!</b>';
      exit;
      }
   } elseif(!empty($function_check_return_code) && $function_check_return_code == 2) {
       // Function logbook_send() versendet das Logbook
       $function_send_return_code = logbook_send($logbook_send_array);
       if(isset($function_send_return_code) && $function_send_return_code == 0) {
          // Function logbook_create() erstellt einen neues Logbook
          $function_create_return_code = logbook_create($logbook_create_array);
          if(isset($function_create_return_code) && $function_create_return_code == 0) {
             // Function logbook_write() erstellt einen neuen Logbook-Eintrag
             $function_write_return_code = logbook_write($logbook_write_array);
             if(!empty($function_write_return_code)) {
                if($function_write_return_code == 5 || $function_write_return_code == 8) {
                   $logbook_error_send_array[0] = $function_write_return_code;
                   logbook_error_send($logbook_error_send_array, $logbook_return_code_array);
                }
                else 
                {
                print '<b>FUNCTION: logbook_write() IS DAMAGED - UNKNOWN RETURN-CODE!</b>';
                exit;
                }
             }
          } elseif(!empty($function_create_return_code)) {
              if($function_create_return_code == 3 || $function_create_return_code == 4 || $function_create_return_code == 7) {
                 $logbook_error_send_array[0] = $function_create_return_code;
                 logbook_error_send($logbook_error_send_array, $logbook_return_code_array);
              }
              else
              {
              print '<b>FUNCTION: logbook_create() IS DAMAGED - UNKNOWN RETURN-CODE!</b>';
              exit;
              }
          }
          else
          {
          print '<b>FUNCTION: logbook_create() IS DAMAGED - UNKNOWN RETURN-CODE!</b>';
          exit;
          }
     } elseif(!empty($function_send_return_code)) {
         if($function_send_return_code == 5 || $function_send_return_code == 9) {
            $logbook_error_send_array[0] = $function_send_return_code;
            logbook_error_send($logbook_error_send_array, $logbook_return_code_array);
         }
         else
         {
         print '<b>FUNCTION: logbook_send() IS DAMAGED - UNKNOWN RETURN-CODE!</b>';
         exit;
         }
     } 
     else
     {
     print '<b>FUNCTION: logbook_send() IS DAMAGED - UNKNOWN RETURN-CODE!</b>';
     exit;
     }
   } elseif(!empty($function_check_return_code) && $function_check_return_code == 6) {
       $logbook_error_send_array[0] = $function_check_return_code;
       logbook_error_send($logbook_error_send_array, $logbook_return_code_array);
   }
   else
   {
   print '<b>FUNCTION: logbook_check() IS DAMAGED - UNKNOWN RETURN-CODE!</b>';
   exit;
   }
}
?>