<?php
// +++ ANFANG KONFIGURATION +++
// Bereich: globale Variablen und Arrays
$start_time = gettimeofday(true); // Start der Zeitmessung fuer die Abarbeitung von Programmroutinen
$work_time_messages="Berechnungszeit (PHP-Server):"; // Meldung, Information an den Benutzer
$time_second_messages="Sekunden"; // Meldung, Information an den Benutzer
$obelix_version="v. 3.2.0"; // Programm-Version
$footer_date_time_current="Welcome to Obelix " . $obelix_version . " - " . date("l, d.m.Y - H:i:s");
$access_limitations_enable=1; // Zugangsbeschraenkung Ein/Aus, moegliche Werte: 0 ... ausgeschaltet, 1 ... eingeschaltet (default)
$access_limitations_time=60*60*6; // maximale Aufenthaltsdauer 60*60*6 = 3600*6 = 21600 Sekunden oder 6 Stunden, moegliche Werte 60 .. 99999, 60*60*6 (default)
$file_size_gigabyte_title="GB"; // Meldung, Information an den Benutzer
$file_size_megabyte_title="MB"; // Meldung, Information an den Benutzer
$file_size_kilobyte_title="kB"; // Meldung, Information an den Benutzer
$file_size_byte_title="Byte"; // Meldung, Information an den Benutzer
$ini_max_execution_time=150; // Ausfuehrungszeit des PHP-Skriptes neu festlegen, 10 .. 999, 150 (default)
$ini_memory_limit='1024M'; // verfuegbarer Speicher fuer die Ausfuehrung des PHP-Skriptes temporaer erhoehen, moegliche Werte: 512M oder 1024M (default)
$mysql_inc_db_config_file_access=0644; // Zugriffsrechte der erstellten Dateien (Seite: MySQLi-TABLES, MySQLi-COMMAND); moegliche Werte: 0666, 0664, 0644 (default), 0640, 0600
$image_editing_color_palette_directory_access=0755; // Zugriffsrechte der erstellten Verzeichnisse (Seite: IMAGE-EDITING, COLORPALETTE, IMAGE-EDITOR); moegliche Werte: 0777, 0775, 0755 (default), 0750, 0700
$image_editing_color_palette_file_access=0644; // Zugriffsrechte der erstellten Bild-Dateien; moegliche Werte (Seite IMAGE-EDITING, COLORPALETTE, IMAGE-EDITOR): 0666, 0664, 0644 (default), 0640, 0600
$access_limitations_file_access=0600; // Zugriffsrecht fuer die Datei mit der Zugangsbeschraenkung auf eine Person pro Sitzung; moegliche Werte: 0666, 0664, 0644, 0640, 0600 (default)
/*
 Arrays und Variablen mit regulaeren Ausdruecken:
  - Aenderungen an den Array-Eintraegen (Positionsverschiebungen, Entfernung, Hinzufuegung) haben auch Aenderungen
    an anderer Stelle des PHP-Skriptes zur Folge
  - Datei- und Verzeichnisnamen in den Arrays sollten KEINE Leerzeichen enthalten
  - Aenderungen an den regulaeren Ausdruecken in Arrays und Variablen (Namensbestandteil: regex) haben
    moeglicherweise auch Aenderungen an den Funktionen zur Folge
 Schriftgroesze des PHP-Skriptes aendern:
  - Suchfunktion eines Programmeditors aufrufen und folgendes eingeben:
  - CSS .="body
  - font-size: 0.95em; -> den Wert 0.95em vergroeszern (0.99em oder 1.05em) oder verkleinern (0.9em) und
  - ziemlich am Ende des PHP-Skriptes den body-Eintrag im Cascading Style Sheets - Bereich (CSS) ebenfalls
    entsprechend aendern
*/
$obelix_file_name_array=array("./upload.zip",
                              "./.htaccess",
                              "./.htpasswd",
                              "./hyperlink_listing.csv",
                              "./obelix5.php",
                              "./upload.tar.gz",
                              "./upload.gz",
                              "./inc_db_config_5.php",
                              "./upload.7z",
                              "./various_task.php",
                              "./access_limitations.csv",
                              "./thumbnails_1",
                              "./images_1",
                              "./host_intrusion_detection_system",
                              "./download_depot"); // Array mit den Obelix-Dateien und Verzeichnissen

// Bereich: Navigationsvariablen
$navigation_head_line="Navigation"; // Ueberschrift fuer Navigations-Seitenleiste
$obelix_hyperlink_array=array('LOGOUT',
                              'HOME',
                              'UPLOAD',
                              'UNPACK',
                              'DELETE',
                              'HYPERLINK-LISTING',
                              'HTACCESS',
                              'GETCWD',
                              'PHPINFO',
                              'FILELIST',
                              'SITEMAP',
                              'SPLITFILES',
                              'DIRDELETE',
                              'EXEC',
                              'MySQLi-TABLES',
                              'MySQLi-COMMAND',
                              'IMAGE-EDITING',
                              'ACCESS-AUTHORITY',
                              'CREATE-FILE',
                              'HOST-INTRUSION-DETECTION',
                              'MOVE-OBELIX',
                              'COLORPALETTE',
                              'DOWNLOAD-DEPOT',
                              'ROUTINE-CHECK'); // Navigation: Array mit den Hyperlink-Namen

// Bereich: Breite der einzelnen CSS-Boxen
$wrapper_box_width=1500; // Breite der Webseite in Pixel, 1000 ... 9999, 1400 (default)
$navigation_box_width=200; // Breite des Navigationsmenues in Pixel, 100 ... 999, 200 (default)
$main_box_width=1225; // Breite des Hauptbereiches in Pixel, 1000 ... 9999, 1125 (default), 1400 - 200 - Abstaende = 1125
$wrapper_text_editor_box_width=1200; // Breite der Editor-Webseite (Text) in Pixel, 1000 ... 9999, 1200 (default)
$wrapper_image_editor_box_width=1400; // Breite der Editor-Webseite (Bildbearbeitung) in Pixel, 1000 ... 9999, 1400 (default)

// Bereich: Variablen der Login-Seite
$start_first_head_line="Obelix"; // Kopfzeile auf der Login-Webseite
$start_left_head_line="Hinweis"; // Ueberschrift - linke Seite
$start_main_head_line="Zugangskontrolle"; // Ueberschrift des Input-Feldes
$start_left_text="Geben Sie hier bitte den 16-stelligen Zahlencode ein. F&uuml;hrende bzw. nachfolgende Nullen (0) sind ebenfalls einzutragen."; // Text fuer die Zugangskontrolle
$start_main_form_text="Zahlencode"; // Beschriftung des Input-Feldes fuer die Zugangskontrolle
$start_additional_info_1="<strong>Hinweis:</strong> Die regul&auml;re Zeit ist abgelaufen (siehe: Konfigurationseinstellungen)."; // Meldung, Information an den Benutzer
$start_additional_info_2="<strong>Hinweis:</strong> Die Datei f&uuml;r die Zugangsbeschr&auml;nkung ist besch&auml;digt."; // Meldung, Information an den Benutzer

// Bereich: Variablen der Home-Seite
$home_main_head_line="&raquo;OBELIX&laquo; ist ein PHP-Skript f&uuml;r die Wartung und Reparatur von Webseiten."; // Ueberschrift des Hauptinhaltes
$home_main_content="Das PHP-Skript dient vorwiegend dem Upload von ZIP- bzw. GZIP-Dateien (siehe auch: " . $obelix_hyperlink_array[2] . ") von fremden Rechnern aus und dem anschlie&szlig;enden Entpacken vorgenannter ZIP- bzw. GZIP-Dateien (siehe auch: " . $obelix_hyperlink_array[3] . ") auf dem Server. Voraussetzung ist, da&szlig; das PHP-Skript &raquo;OBELIX&laquo; sich bereits auf dem Server befindet. Weiterhin sollte die &raquo;PHP-Maschine&laquo; das Entpacken von ZIP-Dateien unterst&uuml;tzen, d.h. das ZIP-Modul sollte geladen sein (siehe auch: " . $obelix_hyperlink_array[8] . "). F&uuml;r das Entpacken der GZIP-Dateien (.tar.gz, tgz) sollte der Zugriff auf die Linux/Unix-Kommadozeile &uuml;ber das PHP-Kommando &raquo;exec&laquo; m&ouml;glich sein (siehe auch: " . $obelix_hyperlink_array[8] . " =&gt; disable_functions; &raquo;exec&laquo; sollte dort nicht aufgelistet sein).<br><br>Beim Entpacken werden vorhandene gleichnamige Dateien <strong>ohne</strong> Abfrage &uuml;berschrieben! Anschlie&szlig;end sollten alle nicht mehr ben&ouml;tigte Dateien gel&ouml;scht werden, m&ouml;glicherweise auch das PHP-Skript &raquo;OBELIX&laquo; (siehe auch: " . $obelix_hyperlink_array[4] . ", " . $obelix_hyperlink_array[9] . "). Falls das PHP-Skript &raquo;OBELIX&laquo; f&uuml;r l&auml;ngere Zeit (&gt; 15 Minuten) im Internet erreichbar ist, so kann das PHP-Skript das Verzeichnis in dem &raquo;OBELIX&laquo; abgelegt wurde auch sch&uuml;tzen (siehe auch: " . $obelix_hyperlink_array[6] . ").<br><br>Bei aktivierter Zugangsbeschr&auml;nkung wird nur einen autorisierten Benutzer zur selben Zeit f&uuml;r die eingestellte Zeit der Zugang gew&auml;hrt. Die Zugangsbeschr&auml;nkung und die erlaubte Arbeitszeit kann im Konfigurationsbereich dieses PHP-Skriptes deaktiviert oder aktiviert bzw. eingetragen werden. Stellt das laufende Skript einen Fehler an der Textdatenbank (" . basename($obelix_file_name_array[10]) . ") fest, so erfolgt automatisch ein Logout. Nach Ablauf der eingetragenen Arbeitszeit, erfolgt bei Bet&auml;tigung eines Links ebenfalls automatisch ein Logout.<br><br>Das PHP-Skript sollte immer &uuml;ber ein ordentliches Logout verlassen werden. Wird das PHP-Skript ohne ein Logout verlassen (Tab oder Browser schlie&szlig;en), kann das PHP-Skript erst nach Ablauf der eingetragenen Arbeitszeit wieder aufgerufen werden. Alternativ kann man &uuml;ber ein FTP-, SFTP- oder SSH-Zugang die Textdatenbank (" . basename($obelix_file_name_array[10]) . ") l&ouml;schen. Danach ist der Zugang auch vor dem Ablauf der eingetragenen Zeit wieder m&ouml;glich.<br><br>Beim Aufruf dieser Seite erfolgt im Hintergrund eine &Uuml;berpr&uuml;fung der Systemdateien des PHP-Skriptes. Stellt das PHP-Skript eine nicht erlaubte Ver&auml;nderung an den Systemdateien fest, so wird auf dieser Seite ein Link zur Seite &raquo;" . $obelix_hyperlink_array[23] . "&laquo; eingef&uuml;gt.<br><br>Weiterhin finden Sie hier noch einige mehr oder weniger hilfreiche zus&auml;tzliche Funktionen. Den Quellcode des PHP-Skriptes kann man auch als eine Bibliothek funktionst&uuml;chtiger Algorithmen, Funktionen ansehen."; // Hauptinhalt der Homeseite
$home_working_time_note="<strong>Hinweis:</strong> Die verbleibende Zeit bis zum automatischen Logout betr&auml;gt:"; // Meldung, Information an den Benutzer
$remaining_working_time_hours="Stunde(n)"; // Meldung, Information an den Benutzer
$remaining_working_time_minutes="Minute(n)"; // Meldung, Information an den Benutzer
$remaining_working_time_seconds="Sekunde(n)"; // Meldung, Information an den Benutzer
$home_main_note="Warnung: Ab hier sollten Sie wissen was Sie tun!"; // Meldung, Information an den Benutzer
$home_routine_check_part_one_messages="<strong>Achtung:</strong> Das PHP-Skript hat nicht erlaubte Ver&auml;nderungen an den Systemdateien des PHP-Skriptes entdeckt. Durch den Aufruf der Seite <strong>"; // Meldung, Information an den Benutzer
$home_routine_check_part_two_messages="</strong> wird eine detaillierte &Uuml;berpr&uuml;fung der Systemdateien des PHP-Skriptes durchgef&uuml;hrt."; // Meldung, Information an den Benutzer
// HINWEIS: Fuer die Pruefung auf der Home-Seite werden 2 Arrays des ROUTINE-CHECK's verwendet (siehe weiter unten: $routine_check_directory_array, $routine_check_file_array)

// Bereich: Variablen der Upload-Seite
$upload_main_head_line="Hinweise zum Upload"; // Ueberschrift des Hauptinhaltes
$upload_main_content="Auf dieser Seite k&ouml;nnen gepackte Archive (ZIP, GZIP, 7ZIP) hochgeladen werden (siehe auch: " . $obelix_hyperlink_array[22] . "). Beim " . $obelix_hyperlink_array[2] . " einer beliebigen ZIP-Datei, GZIP-Datei bzw. 7ZIP-Datei wird diese Datei immer umbenannt in <strong>&raquo;" . basename($obelix_file_name_array[0]) . "&laquo;</strong>, <strong>&raquo;" . basename($obelix_file_name_array[5]) . "&laquo;</strong>, <strong>&raquo;" . basename($obelix_file_name_array[6]) . "&laquo;</strong> bzw. <strong>&raquo;" . basename($obelix_file_name_array[8]) . "&laquo;</strong>, d.h. befindet sich eine gleichnamige Datei schon auf dem Server so wird diese OHNE Abfrage &uuml;berschrieben! Falls Sie sich nicht sicher sind, so rufen Sie die OBELIX-Seite &raquo;" . $obelix_hyperlink_array[4] . "&laquo; bzw. &raquo;" . $obelix_hyperlink_array[9] . "&laquo; auf. Falls sich bereits eine Datei mit dem Namen &raquo;" . basename($obelix_file_name_array[0]) . "&laquo;, &raquo;" . basename($obelix_file_name_array[5]) . "&laquo;, &raquo;" . basename($obelix_file_name_array[6]) . "&laquo; bzw. &raquo;" . basename($obelix_file_name_array[8]) . "&laquo; auf dem Server befindet, so wird sie dort aufgelistet.<br><br>Bei deaktivierter Checkbox &raquo;Dateityp pr&uuml;fen&laquo; wird beim Datei-Upload der Dateityp (z.B. ZIP, GZIP, 7ZIP) nicht gepr&uuml;ft, d.h. jede Datei wird hochgeladen und beh&auml;lt au&szlig;erdem ihren urspr&uuml;nglichen Namen. Die Funktionserweiterung wurde geschaffen, um gro&szlig;e Dateien die in kleinere Dateien gest&uuml;ckelt wurden (Linux/Unix-Befehlszeile: z.B. <strong>&raquo;split -b 8m " . basename($obelix_file_name_array[5]) . " upload_part_&laquo;</strong>) ebenfalls hochladen zu k&ouml;nnen. Diese gest&uuml;ckelten Dateien k&ouml;nnen dann &uuml;ber einen seperaten SSH- oder FTP-Zugang oder &uuml;ber die OBELIX-Seite &raquo;" . $obelix_hyperlink_array[11] . "&laquo; wieder zur urspr&uuml;nglichen Datei zusammengef&uuml;gt werden (Linux/Unix-Befehlszeile: z.B. <strong>&raquo;cat upload_part_* &gt; " . basename($obelix_file_name_array[5]) . "&laquo;</strong>). Anschlie&szlig;end kann diese Datei &uuml;ber den normalen TAR-Befehl entpackt werden (Linux/Unix-Befehlszeile: z.B. <strong>&raquo;tar -xzf " . basename($obelix_file_name_array[5]) . "&laquo;</strong>). Vorgenanntes gilt nur f&uuml;r ein auf Linux/Unix basiertes System.<br><br>Die max. Dateigr&ouml;&szlig;e betr&auml;gt entsprechend den Eintr&auml;gen in der PHP-Konfigurationsdatei &raquo;.../etc/php.ini&laquo; des PHP-Servers zur Zeit  <strong>Upload-Max-Filesize: " . @ini_get('upload_max_filesize') . "Byte</strong> bzw. <strong>Post-Max-Size: " . @ini_get('post_max_size') . "Byte</strong>. Der ma&szlig;gebliche Wert f&uuml;r die maximale Dateigr&ouml;&szlig;e der Upload-Datei ist immer der <strong>kleinere</strong> Wert. Dieser Wert kann im Konfigurationsbereich Upload dieses PHP-Skriptes noch weiter eingeschr&auml;nkt werden. &Uuml;bergeordnete Einstellungen des Webhosters k&ouml;nnen die maximale Dateigr&ouml;&szlig;e der Upload-Datei noch zus&auml;tzlich einschr&auml;nken.<br><br><strong>Hinweis: </strong>Es erfolgt keine R&uuml;ckmeldung bei &Uuml;berschreitung der maximalen Dateigr&ouml;&szlig;e beim Upload."; // Text des Hauptinhaltes
$upload_file_type_array=array("application/x-zip",
                              "application/zip",
                              "application/gzip",
                              "application/x-tgz",
                              "application/tgz",
                              "application/x-gunzip",
                              "application/x-gzip",
                              "application/x-7z-compressed"); // Array mit einigen Internet Media Types (MIME-Typen) von ZIP-Dateien
$upload_file_access=0644; // Zugriffsrecht der erstellten ZIP- Datei; moegliche Werte: 0666, 0664, 0644 (default), 0640, 0600
$upload_file_max_mega_byte=40; // maximale Dateigroesze in Megabyte (Default: 40 MByte)
$upload_file_max_size=$upload_file_max_mega_byte * 1024 * 1024; // maximale Dateigroesze in Byte (Default: 100 * 1024 * 1024 Byte)
$upload_input_field_name="Upload-Datei (max. " . $upload_file_max_mega_byte . "MByte):"; // Beschriftung des input-Feldes
$upload_checkbox_name="Dateityp pr&uuml;fen"; // Beschriftung der Checkbox
$upload_button_name="UPLOAD BEGINNEN"; // Beschriftung des Submit-Button
$upload_messages_successful_rename="Uploaddatei wurde &uuml;bertragen und umbenannt. Neuer Dateinname:"; // Meldung, Information an den Benutzer
$upload_messages_successful="Uploaddatei wurde &uuml;bertragen. Dateinname:"; // Meldung, Information an den Benutzer
$upload_messages_not_successful="Die Uploaddatei wurde nicht gefunden! Dateiname:"; // Meldung, Information an den Benutzer
$upload_messages_chmod_not_successful="Die Zugriffsrechte der Uploaddatei konnte nicht ge&auml;ndert werden! Dateiname:"; // Meldung, Information an den Benutzer
$upload_messages_file_not_found="Der Upload konnte nicht durchgef&uuml;hrt werden! Grund: M&ouml;glicherweise besitzen Sie unzureichende Zugriffsrechte. Dateiname:"; // Meldung, Information an den Benutzer
$upload_messages_bad_file_typ="Hinweis: Unzul&auml;ssiger Dateityp oder unzul&auml;ssige Dateigr&ouml;&szlig;e! Dateiname:"; // Meldung, Information an den Benutzer
$upload_messages_bad_file_size="Hinweis: Unzul&auml;ssige Dateigr&ouml;&szlig;e! Dateiname:"; // Meldung, Information an den Benutzer

// Bereich: Variablen der Unpack-Seite
$unpack_main_head_line="" . $obelix_hyperlink_array[3] . " - Entpacken von ZIP- bzw. GZIP-Dateien"; // Ueberschrift des Hauptinhaltes
$unpack_main_content="Auf dieser Seite k&ouml;nnen vorhandene ZIP- bzw. GZIP-Archive (unterst&uuml;tzte Archive: " . basename($obelix_file_name_array[0]) . ", " . basename($obelix_file_name_array[5]) . " bzw. " . basename($obelix_file_name_array[6]) . ", siehe auch: " . $obelix_hyperlink_array[2] . ", " . $obelix_hyperlink_array[13] . ", " . $obelix_hyperlink_array[22] . ") im aktuellen Verzeichnis entpackt werden. Die GZIP-Dateien werden &uuml;ber ein Linux/Unix-Befehl entpackt, daher wird vorausgesetzt das PHP auf ein Linux/Unix-Server l&auml;uft. Das setzt weiterhin voraus, dass Sie Zugriff auf die Linux/Unix-Befehlszeile &uuml;ber die PHP-Funktion &raquo;exec&laquo; haben (siehe auch: " . $obelix_hyperlink_array[8] . " =&gt; disable_functions; &raquo;exec&laquo; sollte dort <strong>nicht</strong> aufgelistet sein). Falls die PHP-Bibliothek &raquo;zlib&laquo; nicht eingebunden ist, so wird die ZIP-Datei ebenfalls &uuml;ber die Linux/Unix-Befehlszeile entpackt.<br><br><strong>Hinweis:</strong> Der Dateityp der ZIP- bzw. GZIP-Dateien, wird &uuml;ber den vollst&auml;ndigen Dateinamen und den MIME-Typ (application/zip, application/gzip, ...) ermittelt. MIME steht f&uuml;r Internet Media Type. Urspr&uuml;nglich stand die Abk&uuml;rzung f&uuml;r Multipurpose Internet Mail Extension und wurde  f&uuml;r Dateianh&auml;nge von E-Mails verwendet.";
$unpack_file_type_array=array("application/x-zip",
                              "application/zip",
                              "application/gzip",
                              "application/x-tgz",
                              "application/tgz",
                              "application/x-gunzip",
                              "application/x-gzip"); // Array mit einigen Internet Media Types (MIME-Typen) von ZIP-Dateien
$unpack_checkbox_field_name="Archiv nach dem Entpacken l&ouml;schen"; // Text des Hauptinhaltes
$unpack_button_name="ARCHIV ENTPACKEN"; // Beschriftung des Submit-Button
$unpack_directory_access=0755; // Zugriffsrechte des Verzeichnisses mit den entpackten Dateien; moegliche Werte: 0777, 0775, 0755 (default), 0750, 0700
$unpack_messages_current_directory_not_writable="<strong>Hinweis:</strong> Das PHP-Skript besitzt im aktuellen Verzeichnis keine Schreibberechtigung!"; // Meldung, Information an den Benutzer
$unpack_messages_file_overwrite="<strong>Hinweis:</strong> Beim Entpacken werden vorhandene gleichnamige Dateien OHNE Abfrage &uuml;berschrieben!"; // Meldung, Information an den Benutzer
$unpack_messages_no_archive_file_found_a="<strong>Hinweis:</strong> Es wurden keine weiteren Archive (" . basename($obelix_file_name_array[0]) . ", " . basename($obelix_file_name_array[5]) . " bzw. " . basename($obelix_file_name_array[6]) . ") gefunden!"; // Meldung, Information an den Benutzer
$unpack_messages_no_archive_file_found_b="<strong>Hinweis:</strong> Es wurden keine Archive (" . basename($obelix_file_name_array[0]) . ", " . basename($obelix_file_name_array[5]) . " bzw. " . basename($obelix_file_name_array[6]) . ") gefunden!"; // Meldung, Information an den Benutzer
$unpack_zip_messages_successful="<strong>Hinweis:</strong> Das ZIP-Archiv wurde entpackt. Dateiname:"; // Meldung, Information an den Benutzer
$unpack_zip_messages_not_successful="<strong>Hinweis:</strong> Das ZIP-Archiv konnte nicht entpackt werden!<br>Grund: M&ouml;glicherweise besitzen Sie unzureichende Zugriffsrechte. Dateiname:"; // Meldung, Information an den Benutzer
$unpack_zip_messages_successful_delete="Das ZIP-Archiv wurde nach dem Entpacken gel&ouml;scht!"; // Meldung, Information an den Benutzer
$unpack_zip_messages_not_successful_delete="Das ZIP-Archiv konnte nach dem Entpacken nicht gel&ouml;scht werden!<br>Grund: M&ouml;glicherweise besitzen Sie unzureichende Zugriffsrechte."; // Meldung, Information an den Benutzer
$unpack_zip_messages_not_successful_open_file="<strong>Hinweis:</strong> Das ZIP-Archiv konnte nicht ge&ouml;ffnet werden!<br>Grund: M&ouml;glicherweise besitzen Sie unzureichende Zugriffsrechte."; // Meldung, Information an den Benutzer
$unpack_zip_messages_no_zlib_library="<strong>Hinweis:</strong> Die Bibliothek zlib f&uuml;r das Entpacken von ZIP-Dateien ist NICHT geladen bzw. der Zugriff auf die Linux/Unix-Kommadozeile &uuml;ber die PHP-Funktion &raquo;exec&laquo; ist nicht m&ouml;glich!"; // Meldung, Information an den Benutzer
$unpack_gzip_messages_successful="<strong>Hinweis:</strong> Das GZIP-Archiv wurde entpackt. Dateiname:"; // Meldung, Information an den Benutzer
$unpack_gzip_messages_not_successful="<strong>Hinweis:</strong> Das GZIP-Archiv konnte nicht entpackt werden!<br>Grund: M&ouml;glicherweise besitzen Sie unzureichende Zugriffsrechte. Dateiname:"; // Meldung, Information an den Benutzer
$unpack_gzip_messages_successful_delete="Das GZIP-Archiv wurde nach dem Entpacken gel&ouml;scht!"; // Meldung, Information an den Benutzer
$unpack_gzip_messages_not_successful_delete="Das GZIP-Archiv konnte nach dem Entpacken nicht gel&ouml;scht werden!<br>Grund: M&ouml;glicherweise besitzen Sie unzureichende Zugriffsrechte."; // Meldung, Information an den Benutzer
$unpack_gzip_messages_no_exec_function="<strong>Hinweis:</strong> Der Zugriff auf die Linux/Unix-Kommadozeile &uuml;ber das PHP-Funktion &raquo;exec&laquo; ist nicht m&ouml;glich!"; // Meldung, Information an den Benutzer

// Bereich: Variablen der Delete-Seite
$delete_main_head_line="" . $obelix_hyperlink_array[4] . " - L&ouml;schen der OBELIX-Dateien"; // Ueberschrift des Hauptinhaltes
$delete_main_content="Auf dieser Seite k&ouml;nnen Dateien und Verzeichnisse mit spezifischen Standard-Aufgaben, die von diesem PHP-Skript erstellt wurden, gel&ouml;scht werden (siehe auch: Array am Anfang des Quellcodes, " . $obelix_hyperlink_array[9] . ", " . $obelix_hyperlink_array[12] . "). Dateien und Verzeichnisse die nicht gel&ouml;scht werden sollen, deren zugeh&ouml;rige Checkbox muss vor dem L&ouml;schen deaktiviert werden.<br><br><strong>Hinweis:</strong> Die L&ouml;schung der Dateien und Verzeichnisse ist nicht mehr r&uuml;ckg&auml;ngig zu machen. Die Dateien .htaccess und .htpasswd (siehe auch: " . $obelix_hyperlink_array[6] . ") immer gemeinsam l&ouml;schen, d.h. niemals einzeln l&ouml;schen!"; // Text des Hauptinhaltes
$delete_button_name="AUSGEW&Auml;HLTE DATEIEN ODER VERZEICHNISSE L&Ouml;SCHEN"; // Beschriftung des Submit-Button
$delete_messages_not_successful="Die ausgew&auml;hlten Verzeichnisse und Dateien konnten nicht oder nur unvollst&auml;ndig gel&ouml;scht werden!<br>Grund: M&ouml;glicherweise besitzen Sie unzureichende Zugriffsrechte."; // Meldung, Information an den Benutzer
$delete_directory_messages_not_successful="Die ausgew&auml;hlten Verzeichnisse konnten nicht oder nur unvollst&auml;ndig gel&ouml;scht werden!<br>Grund: M&ouml;glicherweise besitzen Sie unzureichende Zugriffsrechte."; // Meldung, Information an den Benutzer
$delete_file_messages_not_successful="Die ausgew&auml;hlten Dateien konnten nicht oder nur unvollst&auml;ndig gel&ouml;scht werden!<br>Grund: M&ouml;glicherweise besitzen Sie unzureichende Zugriffsrechte."; // Meldung, Information an den Benutzer

// Bereich: Variablen der Hyperlink-Listing-Seite
$hyperlink_listing_main_head_line="" . $obelix_hyperlink_array[5] . " - Zugriff auf gespeicherte Internet-Links"; // Ueberschrift des Hauptinhaltes
$hyperlink_listing_main_content="Auf dieser Seite bekommen Sie Zugriff auf eine vorhandene CSV-Datei mit Webadressen. Die CSV-Datei ist daf&uuml;r gedacht, Webadressen aufzunehmen die sich keiner merken kann. Diese Webadressen sind dann von jeden Internet-Rechner der Welt aufrufbar. Die CSV-Datei <strong>&raquo;" . basename($obelix_file_name_array[3]) . "&laquo;</strong> kann mit jeden beliebigen Texteditor erstellt und bearbeitet werden (siehe auch: " . $obelix_hyperlink_array[18] . ").<br><br>Die CSV-Datei ist in demselben Verzeichnis abzulegen in dem sich auch das PHP-Skript &raquo;OBELIX&laquo; befindet. Als Feldtrenner ist der senkrechte Strich (|) zu verwenden, alternativ kann aber auch ein Semikolon (;) als Feldtrenner benutzt werden. Diese Feldtrenner d&uuml;rfen nicht in der Webadresse und im beschreibenden Text enthalten sein.<br><br><strong>Hinweis:</strong> Syntax der CSV-Datei (" . basename($obelix_file_name_array[3]) . "): <strong>https://www.domainname.de | beschreibender Text des Links</strong>"; // Text des Hauptinhaltes
$hyperlink_listing_file_access=0644; // Zugriffsrecht der CSV-Datei, muss identisch mit $create_file_file_access sein; moegliche Werte: 0666, 0664, 0644 (default), 0640, 0600
$hyperlink_listing_messages_bad_entry="Hinweis: Eine oder mehrere Eintr&auml;ge sind in der Hyperlink-Listing-Datei sind fehlerbehaftet!"; // Meldung, Information an den Benutzer
$hyperlink_listing_messages_file_not_readable="Hinweis: Die Hyperlink-Listing-Datei kann NICHT gelesen werden!<br>Grund: M&ouml;glicherweise besitzen Sie unzureichende Zugriffsrechte."; // Meldung, Information an den Benutzer
$hyperlink_listing_messages_file_not_found="Hinweis: Die Hyperlink-Listing-Datei wurde NICHT gefunden!"; // Meldung, Information an den Benutzer

// Bereich: Variablen der Htaccess-Seite
$htaccess_main_head_line="" . $obelix_hyperlink_array[6] . "-Dateien anlegen"; // Ueberschrift des Hauptinhaltes
$htaccess_main_content="Htaccess-Dateien sind Konfigurationsdateien f&uuml;r Verzeichnisse, die im allgemeinen zum Angebot der Webhoster geh&ouml;ren. Der Verzeichnisschutz mit der .htaccess-Technik ist der &uuml;bliche Weg, um nur bestimmten Benutzern den Zugriff auf Daten und Unterverzeichnisse einer Webseite zu gestatten. Die beiden .htaccess-Dateien (.htaccess, .htpasswd) werden in dem zu sch&uuml;tzenden Verzeichnis (aktuelles Verzeichnis: " . getcwd() . ") abgelegt.<br><br>Landestypische Umlaute f&uuml;r den Login-Namen und das Passwort sollten vermieden werden. Die .htaccess-Dateien (.htaccess, .htpasswd) k&ouml;nnen nur bei ausreichenden Zugriffsrechten angelegt werden.<br><br>Alle Webseiten-Besucher des Web-Projekts, die nun versuchen, auf das Verzeichnis mit den .htaccess-Dateien zuzugreifen, bekommen von ihrem Internet-Browser einen Dialog angeboten, in dem sie Benutzernamen und Passwort eingeben m&uuml;ssen (siehe auch: " . $obelix_hyperlink_array[4] . ").<br><br><strong>Hinweis:</strong> Der vorangestellte Punkt kennzeichnet die .htaccess-Dateien als versteckte Dateien. Die versteckten Dateien k&ouml;nnen &uuml;ber das Ansichtsmen&uuml; eines Dateimanagers angezeigt werden bzw. &uuml;ber ein UNIX/LINUX-Terminalprogramm mittels des Befehls <strong>ls -­a</strong>."; // Text des Hauptinhaltes
$htaccess_loginname_password_min_count=5; // minimale Zeichenlaenge des Passwortes
$htaccess_loginname_password_max_count=128; // maximale Zeichenlaenge des Passwortes
$htaccess_file_access=0600; // Zugriffsrechte der erstellten Dateien; moegliche Werte: 0666, 0664, 0644 (default), 0640, 0600
$htaccess_auth_user_file_name="AuthUserFile";
$htaccess_auth_name="AuthName \"OBELIX-Schutzraum:\""; // frei waehlbarer Name (OBELIX-Schutzraum:), der in der Dialogbox des Browsers erscheint
$htaccess_auth_type_name="AuthType Basic"; // Art der Authentifizierung
$htaccess_require_user_name="require user";
$htaccess_login_input_field_name="Login-Name:"; // Beschriftung eines input-Feldes
$htaccess_password_input_field_name="Passwort:"; // Beschriftung eines input-Feldes
$htaccess_button_name="HTACCESS-DATEIEN ANLEGEN"; // Button-Beschriftung
$htaccess_messages_current_directory_not_writable="Hinweis: Das PHP-Skript besitzt im aktuellen Verzeichnis keine Schreibberechtigung!"; // Meldung, Information an den Benutzer
$htaccess_messages_htaccess_successful="Die Datei " . $obelix_file_name_array[1] . " wurde angelegt!"; // Meldung, Information an den Benutzer
$htaccess_messages_htpasswd_successful="Die Datei " . $obelix_file_name_array[2] . " wurde angelegt!"; // Meldung, Information an den Benutzer
$htaccess_messages_htaccess_not_successful="Die HTACCESS-Datei " . $obelix_file_name_array[1] . " konnte nicht angelegt werden! Grund: M&ouml;glicherweise besitzen Sie unzureichende Zugriffsrechte."; // Meldung, Information an den Benutzer
$htaccess_messages_htpasswd_not_successful="Die HTACCESS-Datei " . $obelix_file_name_array[2] . " konnte nicht angelegt werden! Grund: M&ouml;glicherweise besitzen Sie unzureichende Zugriffsrechte."; // Meldung, Information an den Benutzer
$htaccess_messages_file_to_exist="Hinweis: Die HTACCESS-Dateien existieren bereits, d.h. es k&ouml;nnen keine weiteren HTACCESS-Dateien angelegt werden!"; // Meldung, Information an den Benutzer
$htaccess_messages_loginname_password_note="Hinweis: Es m&uuml;ssen beide Felder ausgef&uuml;llt werden und die Zeichenl&auml;nge sollte jeweils mindestens " . $htaccess_loginname_password_min_count . " Zeichen betragen!"; // Meldung, Information an den Benutzer
 
// Bereich: Variablen der Getcwd-Seite
$getcwd_main_head_line="GETCWD - aktuelles Arbeitsverzeichnis"; // Ueberschrift des Hauptinhaltes
$getcwd_main_content="Arbeitsverzeichnis auf dem Server"; // Text des Hauptinhaltes

// Bereich: Variablen der Phpinfo-Seite
$phpinfo_main_head_line="Informationen &uuml;ber die aktuelle PHP-Konfiguration"; // Ueberschrift des Hauptinhaltes
$phpinfo_main_content="" . $obelix_hyperlink_array[8] . " zeigt eine gro&szlig;e Anzahl von Informationen &uuml;ber den aktuellen Zustand des PHP-Servers an. Dies umfasst Informationen &uuml;ber die Optionen w&auml;hrend des Kompilierens und die Extensions, die PHP-Version, Server-Informationen und Server-Umgebung (falls als Modul kompiliert), die PHP-Umgebung, Versionsinformationen zum Betriebssystem, Pfade, Master- und lokale Werte der Konfigurationsoptionen, HTTP-Header und die PHP-Lizenz. Weil jedes System anders installiert ist, wird phpinfo() oft genutzt, um die Konfigurationseinstellungen und die verf&uuml;gbaren vordefinierten Variablen auf einem System zu pr&uuml;fen. Der Hinweis BAD VARIABLE deutet daraufhin, dass die aktuelle Konfigurationsdatei php.ini diesen Eintrag nicht kennt (Schreibweise beachten)."; // Text des Hauptinhaltes
$phpinfo_module_head_line="PHP-Module (extensions)"; // Meldung, Information an den Benutzer
$phpinfo_all_data_hyperlink_title="Alle verf&uuml;gbaren Informationen &uuml;ber den PHP-Server ausgeben."; // Beschriftung des Hyperlinks, vollstaendige PHPINFO-Seite
$phpinfo_variables_head_line="PHP-Variablen aus der Datei php.ini"; // Meldung, Information an den Benutzer
$phpinfo_php_version=phpversion();
$phpinfo_php_version_title_name="PHP-VERSION"; // Meldung, Information an den Benutzer
$phpinfo_server_variables_array=array('HTTP_USER_AGENT',
                                      'HTTP_REFERER',
                                      'SERVER_SOFTWARE',
                                      'SERVER_NAME',
                                      'SERVER_ADDR',
                                      'SERVER_PORT',
                                      'REMOTE_ADDR',
                                      'DOCUMENT_ROOT',
                                      'SERVER_ADMIN',
                                      'SCRIPT_FILENAME',
                                      'REMOTE_PORT',
                                      'GATEWAY_INTERFACE',
                                      'SERVER_PROTOCOL',
                                      'REQUEST_METHOD',
                                      'REQUEST_URI',
                                      'SCRIPT_NAME'); // Array mit einigen vordefinierten Servervariablen
$phpinfo_ini_get_variables_array=array('default_charset',
                                       'disable_classes',
                                       'disable_functions',
                                       'max_execution_time',
                                       'memory_limit',
                                       'post_max_size',
                                       'upload_max_filesize',
                                       'session.auto_start',
                                       'session.name',
                                       'session.save_path'); // Array mit einigen vordefinierten PHP-Variablen der Datei php.ini

// Bereich: Variablen der Filelist-Seite
$filelist_main_head_line="" . $obelix_hyperlink_array[9] . " - L&ouml;schung und Auflistung von ausgew&auml;hlten Dateitypen"; // Ueberschrift des Hauptinhaltes
$filelist_main_content="Auf dieser Seite kann eine tabellarische &Uuml;bersicht von ausgw&auml;hlten Dateitypen erstellt werden (siehe auch: " . $obelix_hyperlink_array[10] . ", " . $obelix_hyperlink_array[12] . ", " . $obelix_hyperlink_array[13] . "). Bei der Auflistung der Dateitypen k&ouml;nnen im Auswahlfeld auch bereits vordefinierte regul&auml;re Ausdr&uuml;cke (.[a-z][a-z][a-z] - .php, .htm, .txt, .pdf, ... oder .[a-z][a-z][0-9] - .mp3, .mp4, ...) gew&auml;hlt werden.<br><br>Beim Download einiger Dateien, wird der Internet-Browser versuchen bekannte Dateitypen (HTML, PHP, TEXT, JPEG, PNG, GIF, MP3, MP4, ...) im Internet-Browser zu &ouml;ffnen. Diese Dateien k&ouml;nnen mit dem Men&uuml; des Internet-Browsers (Seite speichern unter ...) auf dem lokalen Rechner gespeichert werden. Wird der aktuelle Zeichencode von Textdateien vom Internet-Browser oder vom Betriebssystem nicht unterst&uuml;tzt, so k&ouml;nnen einige Zeichen nicht korrekt dargestellt werden.<br><br>Es ist zu beachten, dass existierende Dateien nicht unbedingt f&uuml;r das PHP-Skript auch lesbar sind und lesbare Dateien bei unzureichenden Zugriffsrechten nicht bearbeitbar und damit auch nicht l&ouml;schbar sein k&ouml;nnen (Pr&uuml;fung: &#10003; ... true, &#10007; ... false).<br><br><strong>Hinweis:</strong> Bei einer umfangreichen Verzeichnis- und Datei&uuml;bersicht, kann die interne Suchfunktion des Internet-Browsers aufgerufen werden (Tastenkombination: [Strg] + [F]). Die L&ouml;schung - ausreichende Zugriffsrechte vorausgesetzt, kann nur durch ein vorhandenes Backup r&uuml;ckg&auml;ngig gemacht werden."; // Text des Hauptinhaltes
$filelist_title_table="AUSGEW&Auml;HLTE DATEITYPEN ANZEIGEN"; // Beschriftung des Tabellenkopfes
$filelist_directory_default_depth=3; // Vorgabe der Verzeichnistiefe, 1 ... 9, 3 (default)
$filelist_title_filetype_fieldname="Dateityp oder Gruppe ausw&auml;hlen:"; // Meldung, Information an den Benutzer
$filelist_title_change_directory_depth="Verzeichnistiefe (1-9):"; // Meldung, Information an den Benutzer
$filelist_button_name="DATEIEN ANZEIGEN"; // Beschriftung des Submit-Buttons
$filelist_data_fieldname_1="Lfd.-Nr.:"; // Beschriftung des Tabellenkopfes
$filelist_data_fieldname_2="Dateiname"; // Beschriftung des Tabellenkopfes
$filelist_data_fieldname_3="letzte &Auml;nderung<br>des Inhaltes"; // Beschriftung des Tabellenkopfes
$filelist_data_fieldname_4="Dateigr&ouml;&szlig;e"; // Beschriftung des Tabellenkopfes
$filelist_data_fieldname_5="lesbar"; // Beschriftung des Tabellenkopfes
$filelist_data_fieldname_6="schreibbar"; // Beschriftung des Tabellenkopfes
$filelist_data_fieldname_7="Bearbeiten"; // Beschriftung des Tabellenkopfes
$filelist_data_fieldname_8="L&ouml;schen"; // Beschriftung des Tabellenkopfes
$filelist_data_fieldname_9="Download"; // Beschriftung des Tabellenkopfes
$filelist_table_foot_title="aktuelles Arbeitsverzeichnis:"; // Beschriftung des Tabellenfuszes
$filelist_filetype_title_array=array('.zip',
                                     '.7z',
                                     '.tgz',
                                     '.tar.gz',
                                     '.gz',
                                     '.[0-9][a-z]',
                                     '.[a-z][a-z]',
                                     '.[a-z][a-z][a-z]',
                                     '.[a-z][a-z][0-9]',
                                     '.[0-9][a-z][a-z]',
                                     '_[a-z][a-z]',
                                     '[a-z][a-z]',
                                     '_[a-z][a-z][a-z]',
                                     '.zip[a-z][a-z]',
                                     '.tgz[a-z][a-z]',
                                     '.tar.gz[a-z][a-z]',
                                     '.[a-z0-9_]{1,32}'); // Array mit den Dateitypen, die als sichtbare Bezeichner verwendet werden
$filelist_filetype_regex_array=array('\.zip$',
                                     '\.7z$',
                                     '\.tgz$',
                                     '\.tar.gz$',
                                     '\.gz$',
                                     '\.[0-9][a-z]$',
                                     '\.[a-z][a-z]$',
                                     '\.[a-z][a-z][a-z]$',
                                     '\.[a-z][a-z][0-9]$',
                                     '\.[0-9][a-z][a-z]$',
                                     '_[a-z][a-z]',
                                     '[a-z][a-z]',
                                     '_[a-z][a-z][a-z]',
                                     '\.zip[a-z][a-z]$',
                                     '\.tgz[a-z][a-z]$',
                                     '\.tar\.gz[a-z][a-z]$',
                                     '^\.[a-z0-9_]{1,32}'); // Array mit den Dateitypen, die in regulaeren Ausdruecken verwendet werden
$filelist_file_text_editing_regex='\.(htm[l]?|php|txt|css|js|csv|dat)$'; // regulaeren Ausdruck, fuer die Filterung von Textdateien
$filelist_file_image_editing_regex='\.(jp[e]?g|gif|png)$'; // regulaeren Ausdruck, fuer die Filterung von Bilddateien
$filelist_file_download_zip_regex='\.(tgz|tar\.gz|zip|7z|tgz[a-z][a-z]|tar\.gz[a-z][a-z]|zip[a-z][a-z])$'; // regulaeren Ausdruck, fuer die Filterung von ZIP-Dateien
$filelist_remove_messages_not_successful="Hinweis: Datei konnte nicht gel&ouml;scht werden!<br>Grund: M&ouml;glicherweise besitzen Sie unzureichende Zugriffsrechte."; // Meldung, Information an den Benutzer";
$filelist_remove_messages_file_not_found="Hinweis: Datei existiert nicht oder es wurde kein Dateiname &uuml;bergeben!"; // Meldung, Information an den Benutzer";

// Bereich: Variablen der Sitemap-Seite
$sitemap_main_head_line="" . $obelix_hyperlink_array[10] . " - Erstellung einer Verzeichnis- und Datei&uuml;bersicht"; // Ueberschrift des Hauptinhaltes
$sitemap_main_content="Auf dieser Seite kann eine  Verzeichnis- und Datei&uuml;bersicht (Sitemap) erstellt werden. Eine Sitemap kann ein sehr hilfreiches Werkzeug (siehe auch: " . $obelix_hyperlink_array[13] . ", " . $obelix_hyperlink_array[9] . ", " . $obelix_hyperlink_array[18] . ") sein, um sich in gr&ouml;&szlig;eren Verzeichnisb&auml;umen zurecht zu finden. Die Sitemap erlaubt es Textdateien (PHP, HTML, TXT, CSS, JS, DAT und CSV-Dateien) direkt im Internet-Browser zu bearbeiten.<br><br>Bei der freien Eintragung des Startverzeichnisses, sind nur relative Verzeichnispfade zul&auml;ssig. Die relativen Verzeichnispfade fangen immer mit der Zeichenkette ./, ../, ../../ usw. an.<br><br>Im Editor-Modus kann der Image-Editor f&uuml;r die Bearbeitung von Bildern aufgerufen werden. Der Image-Editor unterst&uuml;tzt nur die Bildtypen JPEG, PNG und GIF. Diese Bildtypen werden von allen grafischen Internet-Browser unterst&uuml;tzt. Das Ausgangsbild wird beim Aufruf des Image-Editors immer in den Arbeitsbereich des Image-Editors kopiert. Der Image-Editor kann das Ausgangsbild nicht durch das bearbeitete Bild ersetzen. Der Austausch einer bearbeiteten Bilddatei erfolgt auf der Seite " . $obelix_hyperlink_array[16] . " (Voraussetzung: ausreichende Zugriffsberechtigungen)."; // Text des Hauptinhaltes
$sitemap_title_start_directory="Ausgangsverzeichnis:"; // Meldung, Information an den Benutzer
$sitemap_title_work_directory="aktuelles Arbeitsverzeichnis:"; // Meldung, Information an den Benutzer
$sitemap_title_filetypes="Auswahl der Dateitypen"; // Bereichs-Ueberschrift
$sitemap_title_current_directory_depth="aktuelle Verzeichnistiefe:"; // Meldung, Information an den Benutzer
$sitemap_title_help_text="Hinweis- und Hilfetext"; // Meldung, Information an den Benutzer
$sitemap_main_help_text="Die verschiedenen Dateitypen werden von der Sitemap, ausschlie&szlig;lich an den Dateiendungen (.html, .txt, .php, ...) erkannt.<br><br>Im Editor-Modus, sollten Sie wissen was Sie tun. Die &Auml;nderungen an den Textdateien k&ouml;nnen nach dem Speichern, nur durch ein vorhandenes Backup r&uuml;ckg&auml;ngig gemacht werden.<br><br>Dateityp DAT: Dieser Dateityp wird mitunter f&uuml;r umfangreiche Text-Datenbanken verwendet.<br>Dateitypen mit der Endung AZ (Beispiel: TARGZAZ): Gro&szlig;e Dateien k&ouml;nnen auf einer UNIX/LINUX-Maschine mit dem Befehl &raquo;split&laquo; in kleine Dateist&uuml;cke (Endung: aa, ab, ac ... az) aufgeteilt werden.<br><br>Wird die Checkbox &raquo;Unbekannte Dateitypen&laquo; aktiviert, so versucht die Sitemap alle unbekannten Dateitypen zu ermitteln. Die Auswahl der aktuell markierten Dateitypen bleibt dabei unber&uuml;cksichtigt.<br><br>Die Dateigruppe UFO (unidentified file object) in der Sitemap-Legende kennzeichnet alle Dateitypen die der aktuellen Verzeichnis- und Datei&uuml;bersicht (Sitemap) unbekannt sind.<br><br>Neben den Verzeichnisnamen in der Sitemap ist die &Auml;nderungszeit der Inode-Daten eingetragen (&Auml;nderungszeit der Rechte, Eigent&uuml;mer, Gruppe oder anderer Metadaten des Inodes) und neben den Dateien ist die aktuellen Dateigr&ouml;&szlig;e und die &Auml;nderungszeit der letzen &Auml;nderung des Datei-Inhaltes zu finden.<br><br>F&uuml;r das Anschauen einiger Textdateien (PHP, HTML, TXT, CSS, JS, CSV, DAT-Dateien), werden Sie m&ouml;glicherweise vom Internet-Browser aufgerufen ein Programm auszuw&auml;hlen. Im Normalfall w&auml;hlen Sie am besten einen einfachen Texteditor. Wird der aktuelle Zeichencode der Datei vom Internet-Browser oder vom Betriebssystem nicht unterst&uuml;tzt, so k&ouml;nnen einige Zeichen nicht korrekt dargestellt werden.<br><br>Bei einer umfangreichen Verzeichnis- und Datei&uuml;bersicht, kann die interne Suchfunktion des Internet-Browsers aufgerufen werden (Tastenkombination: [Strg] + [F]).<br><br>F&uuml;r das Hinzuf&uuml;gen von neuen Dateitypen sind in der Konfiguration des PHP-Skriptes (Bereich: Variablen der Sitemap-Seite) 4 Arrays (regul&auml;rer Ausdr&uuml;cke und CSS-Namen) und die Funktionen create_sitemap() und create_sitemap_css() anzupassen."; // Meldung, Information an den Benutzer
$sitemap_title_choice_start_directory="Startverzeichnis ausw&auml;hlen"; // Meldung, Information an den Benutzer
$sitemap_title_current_directory="aktuelles Verzeichnis (./)"; // Meldung, Information an den Benutzer
$sitemap_title_directory_level_one_higher="eine Verzeichnisebene h&ouml;her (../)"; // Meldung, Information an den Benutzer
$sitemap_title_directory_level_two_higher="zwei Verzeichnisebene h&ouml;her (../../)"; // Meldung, Information an den Benutzer
$sitemap_title_directory_level_free_choice="freie Wahl des Startverzeichnissses"; // Meldung, Information an den Benutzer
$sitemap_title_directory_level_change="Startverzeichnis hier eingeben:"; // Meldung, Information an den Benutzer
$sitemap_directory_level_change_example="Beispiel: ../../../tmp/install/"; // Meldung, Information an den Benutzer
$sitemap_directory_level_change_note="<strong>Hinweis:</strong> Bezugspunkt f&uuml;r das Startverzeichnis ist das Verzeichnis in dem OBELIX abgelegt wurde."; // Meldung, Information an den Benutzer
$sitemap_title_unknown_files_checkbox="Unbekannte Dateitypen suchen (UFO)"; // Meldung, Information an den Benutzer
$sitemap_title_editor_checkbox="Editor-Modus einschalten (PHP, HTML, TXT, CSS, JS, CSV, DAT,<br>JPEG, PNG, und GIF-Dateien)"; // Meldung, Information an den Benutzer
$sitemap_title_change_directory_depth="Verzeichnistiefe (1-9):"; // Meldung, Information an den Benutzer
$sitemap_directory_default_depth=3; // Vorgabe der Verzeichnistiefe, 1 ... 9, 3 (default)
$sitemap_title_color_legend="Sitemap-Legende"; // Meldung, Information an den Benutzer
$sitemap_legend_color_directory="Verzeichnis"; // Meldung, Information an den Benutzer
$sitemap_legend_color_html="HTML"; // Meldung, Information an den Benutzer
$sitemap_legend_color_php="PHP"; // Meldung, Information an den Benutzer
$sitemap_legend_color_text="Text"; // Meldung, Information an den Benutzer
$sitemap_legend_color_images="Bilder"; // Meldung, Information an den Benutzer
$sitemap_legend_color_zip="ZIP"; // Meldung, Information an den Benutzer
$sitemap_legend_color_pdf="PDF"; // Meldung, Information an den Benutzer
$sitemap_legend_color_audio="Audio"; // Meldung, Information an den Benutzer
$sitemap_legend_color_video="Video"; // Meldung, Information an den Benutzer
$sitemap_legend_color_miscellaneous="UFO"; // Meldung, Information an den Benutzer
$sitemap_button_name="SITEMAP ERSTELLEN"; // Beschriftung des Submit-Buttons
$sitemap_file_view_linkname="Aufrufen"; // Meldung, Information an den Benutzer
$sitemap_file_editing_linkname="Bearbeiten"; // Meldung, Information an den Benutzer
$sitemap_file_download_linkname="Download"; // Meldung, Information an den Benutzer
$sitemap_title_footer_summary_directory="Verzeichnisse:"; // Meldung, Information an den Benutzer
$sitemap_title_footer_summary_file="Dateien:"; // Meldung, Information an den Benutzer
$sitemap_filetype_title_array=array('HTML',
                                    'PHP',
                                    'CSS',
                                    'JS',
                                    'TEXT',
                                    'CSV',
                                    'DAT',
                                    'ZIP',
                                    'TAR-GZIP',
                                    'GIF',
                                    'JPEG',
                                    'PNG',
                                    '7ZIP',
                                    'ZIPAZ',
                                    'TGZAZ',
                                    'TARGZAZ',
                                    'PDF',
                                    'MP3',
                                    'OGG',
                                    'WAV',
                                    'MP4'); // Array mit den Dateitypen, die als sichtbare Bezeichner verwendet werden
$sitemap_filetype_regex_array=array('\.htm[l]?$',
                                    '\.php$',
                                    '\.css$',
                                    '\.js$',
                                    '\.txt$',
                                    '\.csv$',
                                    '\.dat$',
                                    '\.zip$',
                                    '\.(tgz|tar\.gz)$',
                                    '\.gif$',
                                    '\.(jpg|jpeg)$',
                                    '\.png$',
                                    '\.7z$',
                                    '\.zip[a-z][a-z]$',
                                    '\.tgz[a-z][a-z]$',
                                    '\.tar\.gz[a-z][a-z]$',
                                    '\.pdf$',
                                    '\.mp3$',
                                    '\.ogg$',
                                    '\.wav$',
                                    '\.mp4$'); // Array mit den Dateitypen, die in regulaeren Ausdruecken verwendet werden
$sitemap_file_background_color_regex_array=array('\.htm[l]?$',
                                                 '\.php$',
                                                 '\.(jp[e]?g|gif|png)$',
                                                 '\.(tgz|tar\.gz|zip|7z|tgz[a-z][a-z]|tar\.gz[a-z][a-z]|zip[a-z][a-z])$',
                                                 '\.(txt|css|js|csv|dat)$',
                                                 '\.pdf$',
                                                 '\.(mp3|ogg|wav)$',
                                                 '\.mp4'); // Array mit regulaeren Ausdruecken, fuer die Filterung von Dateigruppen
$sitemap_file_background_color_css_name_array=array('dir', 'htm', 'php', 'img', 'zip', 'text', 'pdf', 'audio', 'video', 'files'); // CSS-Namen fuer die Hintergrundfarbe von Dateitypen
$sitemap_directory_change_messages_not_successful="Hinweis: Der f&uuml;r &raquo;" . $obelix_hyperlink_array[10] . "&laquo; notwendige Wechsel ins &uuml;bergeordnete Verzeichnis konnte nicht durchgef&uuml;hrt werden!<br>Grund: M&ouml;glicherweise wurde das angegebene  Verzeichnis nicht gefunden oder Sie besitzen unzureichende Zugriffsrechte."; // Meldung, Information an den Benutzer

// Bereich: Variablen der Splitfiles-Seite
$splitfiles_main_head_line="" . $obelix_hyperlink_array[11] . " - gesplittete Dateien wider zusammenf&uuml;hren"; // Ueberschrift des Hauptinhaltes
$splitfiles_main_content="Auf dieser Seite k&ouml;nnen bereits hochgeladene und gesplittete Dateien (siehe auch: " . $obelix_hyperlink_array[2] . ", " . $obelix_hyperlink_array[9] . ") wieder zu einer einzigen Datei zusammengef&uuml;gt werden. Im Feld &raquo;SPLIT-Dateien&laquo; tragen Sie den <strong>Teil des Namens</strong> ein, der bei allen Split-Dateien gleich ist. Beispiel: Die Namen der Dateist&uuml;cke lauten: upload_part.tar.gz.aa, upload_part.tar.gz.ab, upload_part.tar.gz.ac usw., d.h. Sie tragen in das Feld &raquo;SPLIT-Dateien&laquo; <strong>&raquo;upload_part.tar.gz.&laquo;</strong> ein und w&auml;hlen hier im Beispiel f&uuml;r den Dateinamen der wieder zusammengef&uuml;gten Datei das Auswahlfeld &raquo;" . basename($obelix_file_name_array[5]) . "&laquo; aus (siehe auch: UNPACK). Existiert eine gleichnamige Zieldatei so wird diese <strong>ohne</strong> Abfrage &uuml;berschrieben. Die Zugriffsrechte des aktuellen Verzeichnisses, sowie einer bereits vorhandenen Zieldatei, sollten dabei ausreichend bemessen sein.<br><br><strong>Hinweis: </strong> Gro&szlig;e Dateien k&ouml;nnen Sie auf einer UNIX/LINUX-Maschine mit dem Befehl <strong>&raquo;split -b 6m " . basename($obelix_file_name_array[5]) . " uload_part.tar.gz.&laquo;</strong> in 6 Mbyte (Parameter: 6m) kleine St&uuml;cke zerteilen. Die kleinen Dateien hei&szlig;en dann: upload_part.tar.gzaa, upload_part.tar.gzab, upload_part.tar.gzac usw. Es wird vorausgesetzt das PHP auf ein UNIX/LINUX-Server l&auml;uft. Weiterhin haben Sie Zugriff auf die UNIX/LINUX-Kommadozeile &uuml;ber das PHP-Kommando &raquo;exec&laquo; (siehe auch: " . $obelix_hyperlink_array[8] . " =&gt; disable_functions; &raquo;exec&laquo; sollte dort <strong>nicht</strong> aufgelistet sein)."; // Text des Hauptinhaltes
$splitfiles_input_text_filename="SPLIT-Dateien:"; // Beschriftung eines input-Feldes
$splitfiles_remove_checkbox_name="Split-Dateien nach dem Zusammenf&uuml;gen l&ouml;schen"; // Beschriftung der Checkbox Remove
$splitfiles_input_radio_filename="Auswahl des Ziel-Namens der zusammengef&uuml;gten SPLIT-Dateien (ZIP, TAR-GZIP, GZ, 7ZIP)."; // Beschriftung eines input-Feldes
$splitfiles_button_name="SPLIT-DATEIEN ZUSAMMENF&Uuml;GEN"; // Beschriftung des Submit-Buttons
$splitfiles_cat_messages_successful= "Hinweis: Die Dateist&uuml;cke wurden zusammengef&uuml;gt. Name der zusammengef&uuml;gten Datei:"; // Meldung, Information an den Benutzer
$splitfiles_remove_messages_successful= "Hinweis: Die Dateist&uuml;cke wurden nach dem Zusammenf&uuml;gen gel&ouml;scht!"; // Meldung, Information an den Benutzer
$splitfiles_cat_messages_not_successful="Hinweis: Die Dateist&uuml;cke konnten nicht zusammengef&uuml;gt werden!<br>Grund: M&ouml;glicherweise wurden die Split-Dateien nicht gefunden oder Sie besitzen unzureichende Zugriffsrechte."; // Meldung, Information an den Benutzer
$splitfiles_remove_messages_not_successful="Hinweis: Die Dateist&uuml;cke konnten nach dem Zusammenf&uuml;gen nicht gel&ouml;scht werden!<br>Grund: M&ouml;glicherweise besitzen Sie unzureichende Zugriffsrechte."; // Meldung, Information an den Benutzer
$splitfiles_messages_no_exec_function="Hinweis: Die PHP-Funktion &raquo;exec&laquo; steht nicht zur Verf&uuml;gung!"; // Meldung, Information an den Benutzer

// Bereich: Variablen der DirDelete-Seite
$dirdelete_main_head_line="" . $obelix_hyperlink_array[12] . " - L&ouml;schung und Auflistung von ausgew&auml;hlten Verzeichnissen"; // Ueberschrift des Hauptinhaltes
$dirdelete_main_content="Auf dieser Seite k&ouml;nnen komplette Verzeichnisse und alle seine Unterverzeichnisse gel&ouml;scht werden (siehe auch: " . $obelix_hyperlink_array[10] . ", " . $obelix_hyperlink_array[9] . ", " . $obelix_hyperlink_array[13] . "). Es wird vorausgesetzt das PHP auf ein UNIX/LINUX-Server l&auml;uft. Weiterhin haben Sie Zugriff auf die UNIX/LINUX-Kommadozeile &uuml;ber die PHP-Funktion &raquo;exec&laquo; (siehe Startmen&uuml;: " . $obelix_hyperlink_array[8] . " =&gt; disable_functions; &raquo;exec&laquo; sollte dort <strong>nicht</strong> aufgelistet sein).<br><br>Es ist zu beachten, dass existierende Verzeichnisse und Dateien nicht unbedingt f&uuml;r das PHP-Skript auch lesbar sind und lesbare Verzeichnisse und Dateien bei unzureichenden Zugriffsrechten nicht l&ouml;schbar sein k&ouml;nnen (Pr&uuml;fung: &#10003; ... true, &#10007; ... false).<br><br><strong>Hinweis:</strong> Die Berechnungsbasis f&uuml;r die Ermittlung der Speichergr&ouml;&szlig;e ist 1 kByte = 1024 Byte (Beispiel: 1 MegaByte = 1024 * 1024 Byte). Die L&ouml;schung - ausreichende Zugriffsrechte vorausgesetzt, kann nur durch ein vorhandenes Backup r&uuml;ckg&auml;ngig gemacht werden."; // Text des Hauptinhaltes
$dirdelete_title_table="AUSGEW&Auml;HLTE VERZEICHNISSE ANZEIGEN"; // Beschriftung des Tabellenkopfes
$dirdelete_directory_default_depth=3; // Vorgabe der Verzeichnistiefe, 1 ... 9, 3 (default)
$dirdelete_title_change_directory_depth="Verzeichnistiefe (1-9):"; // Meldung, Information an den Benutzer
$dirdelete_button_name="VERZEICHNISSE ANZEIGEN"; // Beschriftung des Submit-Buttons
$dirdelete_data_fieldname_1="Lfd.-Nr.:"; // Beschriftung des Tabellenkopfes
$dirdelete_data_fieldname_2="Verzeichnisname"; // Beschriftung des Tabellenkopfes
$dirdelete_data_fieldname_3="Anzahl der<br>Unterverzeichnisse"; // Beschriftung des Tabellenkopfes
$dirdelete_data_fieldname_4="Anzahl der<br>Dateien"; // Beschriftung des Tabellenkopfes
$dirdelete_data_fieldname_5="Speichergr&ouml;&szlig;e"; // Beschriftung des Tabellenkopfes
$dirdelete_data_fieldname_6="lesbar"; // Beschriftung des Tabellenkopfes
$dirdelete_data_fieldname_7="schreibbar"; // Beschriftung des Tabellenkopfes
$dirdelete_data_fieldname_8="L&ouml;schen"; // Beschriftung des Tabellenkopfes
$dirdelete_table_foot_title="aktuelles Arbeitsverzeichnis:"; // Beschriftung des Tabellenfuszes
$dirdelete_remove_messages_successful="Hinweis: Das ausgew&auml;hlte Verzeichnis wurde komplett gel&ouml;scht!"; // Meldung, Information an den Benutzer
$dirdelete_remove_messages_not_successful="Hinweis: Das ausgew&auml;hlte Verzeichnis konnte nicht gel&ouml;scht werden!<br>Grund: M&ouml;glicherweise besitzen Sie unzureichende Zugriffsrechte."; // Meldung, Information an den Benutzer
$dirdelete_remove_messages_directory_not_found="Hinweis: Das ausgew&auml;hlte Verzeichnis wurde nicht gefunden!"; // Meldung, Information an den Benutzer
$dirdelete_remove_messages_no_exec_function="Hinweis: Die PHP-Funktion &raquo;exec&laquo; steht nicht zur Verf&uuml;gung!"; // Meldung, Information an den Benutzer

// Bereich: Variablen der Exec-Seite
$exec_main_head_line="EXEC - Ausf&uuml;hren von Terminal-Befehle"; // Ueberschrift des Hauptinhaltes
$exec_main_content="Auf dieser Seite k&ouml;nnen Terminal-Befehle an einen UNIX/LINUX-Server &uuml;bergeben werden. Im Texteingabefeld &raquo;Befehl&laquo; ist ein vollst&auml;ndiger UNIX/LINUX-Befehl einzutragen:<br><br>Beispiel 1: <strong>ls -lh</strong> <br>Beispiel 2: <strong>ping 127.0.0.1 -c 2</strong><br>Beispiel 3: <strong>pwd</strong><br>Beispiel 4: <strong>cp upload.zip ../data/upload.zip</strong><br>Beispiel 5: <strong>cp obelix5.php ../tmp/obelix5.php</strong><br><br>Es wird vorausgesetzt das PHP auf ein UNIX/LINUX-Server l&auml;uft. Bei einer ausreichenden Kenntnis &uuml;ber die Verzeichnishierarchie der Webseite (siehe auch: " . $obelix_hyperlink_array[10] . "), k&ouml;nnen hier auch Backupdateien (GZIP-Archive) erstellt werden. Mit den Terminal-Befehlen <strong>export</strong> und <strong>printenv</strong> werden alle bekannten Shell-Variablen (siehe auch: echo &#36;UID, echo &#36;SHELL, echo &#36;PATH) ausgegeben.<br><br><strong>Hinweis:</strong> Interaktive Terminal-Programme (Editor, Dateibrowser, ...) oder Programme mit komplexen Bildschirmausgaben sollten an dieser Stelle nicht aufgerufen werden. Weiterhin sollten Sie Zugriff auf die UNIX/LINUX-Kommadozeile &uuml;ber die PHP-Funktion &raquo;exec&laquo; haben (siehe auch: " . $obelix_hyperlink_array[8] . " =&gt; disable_functions; &raquo;exec&laquo; sollte dort <strong>nicht</strong> aufgelistet sein)."; // Text des Hauptinhaltes
$exec_title_exec_command="Exec-Befehl:"; // Text des Hauptinhaltes
$exec_button_name="EXEC-KOMMANDO AUSF&Uuml;HREN"; // Beschriftung des Submit-Buttons
$exec_messages_successful= "Hinweis: Der Befehl wurde ausgef&uuml;hrt!"; // Meldung, Information an den Benutzer
$exec_messages_not_successful="Hinweis: Der Befehl konnte nicht ausgef&uuml;hrt werden!<br>Grund: M&ouml;glicherweise ist die Syntax des Befehls fehlerbehaftet oder Sie besitzen unzureichende Zugriffsrechte."; // Meldung, Information an den Benutzer
$exec_messages_no_exec_function="Hinweis: Die PHP-Funktion &raquo;exec&laquo; steht nicht zur Verf&uuml;gung!"; // Meldung, Information an den Benutzer

// Bereich: Variablen der Mysqli-Tables-Seite
$mysql_tables_main_head_line="" . $obelix_hyperlink_array[14] . " - Ermittlung der SQL-Tabellen und ihrer Inhalte"; // Ueberschrift des Hauptinhaltes
$mysql_tables_main_content="Diese Seite kann f&uuml;r die Auflistung der Namen von SQL-Tabellen (verf&uuml;gbare Datenbank-Module: siehe Startmen&uuml; - " . $obelix_hyperlink_array[8] . ") einer benannten Datenbank genutzt werden. Au&szlig;erdem ist es hier m&ouml;glich sich die Inhalte von ausgew&auml;hlten Tabellen anzeigen zu lassen. Bei einer Abfrage werden bei langen Texten - um die &Uuml;bersichtlichkeit zu wahren, nur die ersten 65 Zeichen auf dieser Seite dargestellt, gefolgt von 3 Punkten (z.B. hier steht ein langer Text...).<br><br>Bei der Ausgabe der Feldtypen ist folgendes zu beachten: INT -&gt; LONG, SMALLINT -&gt; SHORT, TINYINT -&gt; CHAR, TEXT -&gt; BLOB, VARCHAR -&gt; VAR_STRING, BLOB -&gt; BLOB, MEDIUMBLOB -&gt; BLOB, LONGBLOB -&gt; BLOB.<br><br>Soll f&uuml;r die SQL-Datenbankverbindung eine Include-Datei genutzt werden, so ist diese Datei (<strong>Dateiname:</strong> " . basename($obelix_file_name_array[7]) . ") im aktuellen Verzeichnis zu speichern. Die Include-Datei kann auch durch diese Seite automatisch erstellt werden. Die Include-Datei (<strong>Dateiname:</strong> " . basename($obelix_file_name_array[7]) . ") ist auch zu verwenden, falls f&uuml;r die Datenbankverbindung eine &Uuml;bertragung der Zugangsdaten mittels des HTTP-Protokolls aus Sicherheitsgr&uuml;nden nicht erlaubt ist. F&uuml;r andere SQL-Datenbanken (MariaDB, PostgreSQL) kann diese Seite erst genutzt werden, wenn der Quellcode entsprechend angepasst und erg&auml;nzt wurde.<br><br><strong>Hinweis:</strong> Die MySQL-Erweiterung ist seit PHP 5.5.0 als veraltet markiert und wird seit PHP 7.2.16 nicht mehr unterst&uuml;tzt. Stattdessen ist die Erweiterung MySQLi bevorzugt zu nutzen. Beachte: Die MySQL-Erweiterung (Modul) wird aber noch von vielen Anbieter weiterhin genutzt (verf&uuml;gbare Datenbank-Module: siehe Startmen&uuml; - " . $obelix_hyperlink_array[8] . "). F&uuml;r den Fall das beide Module (MySQL und MySQLi) geladen wurden, k&ouml;nnen die Einstellungen des Webhosters die Benutzung eines SQL-Moduls trotzdem verbieten (L&ouml;sung: MySQL &lt;-&gt; MySQLi)."; // Text des Hauptinhaltes
$mysql_tables_db_type_mysqli="MySQLi:"; // Meldung, Information an den Benutzer
$mysql_tables_db_type_mysql="MySQL:"; // Meldung, Information an den Benutzer
$mysql_tables_host_name_title="Host-Name:"; // Meldung, Information an den Benutzer
$mysql_tables_db_name_title="Datenbank-Name:"; // Meldung, Information an den Benutzer
$mysql_tables_db_user_name_title="Benutzer-Name:"; // Meldung, Information an den Benutzer
$mysql_tables_db_password_title="Passwort:"; // Meldung, Information an den Benutzer
$mysql_tables_note_title_1="Hinweis:"; // Meldung, Information an den Benutzer
$mysql_tables_note_title_2="Auswahl der Art und Weise des Verbindungsaufbaues mit der SQL-Datenbank"; // Meldung, Information an den Benutzer
$mysql_tables_note_1="Standard - Angaben in den Felder nutzen"; // Meldung, Information an den Benutzer
$mysql_tables_note_2="Angaben aus einer Include-Datei (Text) verwenden"; // Meldung, Information an den Benutzer
$mysql_tables_note_3="Angaben aus einer Include-Datei (Base64-Kodiert) verwenden"; // Meldung, Information an den Benutzer
$mysql_tables_note_4="Angaben der Felder in eine Include-Datei schreiben (Text) und verwenden"; // Meldung, Information an den Benutzer
$mysql_tables_note_5="Angaben der Felder in eine Include-Datei schreiben (Base64-Kodiert) und verwenden"; // Meldung, Information an den Benutzer
$mysql_tables_button_name="SQL-BEFEHL &Uuml;BERTRAGEN"; // Beschriftung des Submit-Buttons
$mysql_tables_data_fieldname_1="Lfd.-Nr."; // Beschriftung des Tabellenkopfes 1
$mysql_tables_data_fieldname_2="Tabellenname"; // Beschriftung des Tabellenkopfes 1
$mysql_tables_data_fieldname_3="Feldanzahl"; // Beschriftung des Tabellenkopfes 1
$mysql_tables_data_fieldname_4="Anzahl der Datens&auml;tze"; // Beschriftung des Tabellenkopfes 1
$mysql_tables_data_fieldname_5="Auswahl"; // Beschriftung des Tabellenkopfes 1
$mysql_tables_table_content_titel_name="Tabelle:"; // Beschriftung des Tabellenkopfes 2
$mysql_tables_table_content_fieldname="Feldname:"; // Beschriftung des Zeilennamen Tabelle 2
$mysql_tables_table_content_fieldlength="L&auml;nge:"; // Beschriftung des Zeilennamen Tabelle 2
$mysql_tables_table_content_fieldtype="Feldtyp:"; // Beschriftung des Zeilennamen Tabelle 2
$mysql_tables_messages_to_fill_all_fields="Hinweis: Es m&uuml;ssen alle Felder (Host-Name, Datenbank-Name, Benutzer-Name) ausgef&uuml;llt werden!"; // Meldung, Information an den Benutzer
$mysql_tables_messages_binary_content="HINWEIS: FELD ENH&Auml;LT BIN&Auml;RDATEN"; // Meldung, Information an den Benutzer
$mysql_tables_messages_include_file_damaged="Hinweis: Die include-Datei " . $obelix_file_name_array[7] . " - mit den Datenbank-Zugangsdaten - ist besch&auml;digt!"; // Meldung, Information an den Benutzer
$mysql_tables_messages_include_file_not_found="Hinweis: Die Include-Datei " . $obelix_file_name_array[7] . " - mit den Datenbank-Zugangsdaten - wurde im aktuellen Verzeichnis nicht gefunden!"; // Meldung, Information an den Benutzer
$mysql_tables_messages_include_file_not_delete="Hinweis: Eine bereits vorhandene Include-Datei " . $obelix_file_name_array[7] . " konnte nicht gel&ouml;scht werden!"; // Meldung, Information an den Benutzer
$mysql_tables_messages_include_file_not_readable="Hinweis: Die include-Datei " . $obelix_file_name_array[7] . " - mit den Datenbank-Zugangsdaten - ist nicht lesbar (unzureichende Zugriffsrechte)!"; // Meldung, Information an den Benutzer
$mysql_tables_messages_include_file_not_writable="Hinweis: Die Include-Datei " . $obelix_file_name_array[7] . " - f&uuml;r die Datenbank-Zugangsdaten - konnte nicht beschrieben werden!"; // Meldung, Information an den Benutzer
$mysql_tables_messages_include_file_not_create="Hinweis: Die Include-Datei " . $obelix_file_name_array[7] . " - f&uuml;r die Datenbank-Zugangsdaten - konnte nicht erstellt werden!"; // Meldung, Information an den Benutzer
$mysql_tables_messages_current_directory_not_writable="Hinweis: Das aktuelle Verzeichnis ist nicht beschreibbar!"; // Meldung, Information an den Benutzer
$mysql_tables_messages_mysqli_extension_not_found="Hinweis: Die MySQLi-Bibliothek (MySQLi-Extension) ist nicht verf&uuml;gbar oder der Zugriff auf die MySQLi-Datenbank wurde deaktiviert!"; // Meldung, Information an den Benutzer
$mysql_tables_messages_mysql_extension_not_found="Hinweis: Die MySQL-Bibliothek (MySQL-Extension) ist nicht verf&uuml;gbar oder der Zugriff auf die MySQL-Datenbank wurde deaktiviert!"; // Meldung, Information an den Benutzer
$mysql_tables_messages_not_db_connection="Hinweis: Die Verbindung zur Datenbank konnte nicht hergestellt werden! Datenbankname:"; // Meldung, Information an den Benutzer
$mysql_tables_messages_sql_query_successful="Hinweis: Die SQL-Anfrage wurde ausgef&uuml;hrt!"; // Meldung, Information an den Benutzer
$mysql_tables_messages_sql_query_not_successful="Hinweis: SQL-Anfrage ist fehlgeschlagen! SQL-Anfrage:"; // Meldung, Information an den Benutzer
$mysql_tables_messages_not_table_found="Hinweis: Die Suchabfrage konnte keine Tabellen finden!"; // Meldung, Information an den Benutzer
$mysql_tables_messages_not_data_records_found="Hinweis: Die Suchabfrage konnte keine Datens&auml;tze finden!"; // Meldung, Information an den Benutzer
$mysql_tables_messages_short_content="Hinweis: Von den ausgw&auml;hlten Tabellen k&ouml;nnen die gek&uuml;rzten Inhalte der Tabellen angezeigt werden."; // Meldung, Information an den Benutzer
$mysql_tables_messages_db_not_closed="Hinweis: Das Schlie&szlig;en der Verbindung zur SQL-Datenbank ist fehlgeschlagen! Datenbankname:"; // Meldung, Information an den Benutzer

// Bereich: Variablen der Mysqli-Command-Seite
$mysql_command_main_head_line="" . $obelix_hyperlink_array[15] . " - Erstellung, &Auml;nderung, Entfernung von SQL-Tabellen und Datens&auml;tze"; // Ueberschrift des Hauptinhaltes
$mysql_command_main_content="Auf dieser Seite k&ouml;nnen neue SQL-Tabellen (verf&uuml;gbare Datenbank-Module: siehe Startmen&uuml; - " . $obelix_hyperlink_array[8] . ") erstellt werden und Datens&auml;tze in die Tabellen eingef&uuml;gt bzw. ge&auml;ndert werden. F&uuml;r nachtr&auml;gliche &Auml;nderungen der Tabellenstruktur (Feldzahl, Feldtyp, Feldname) ist dieses Tool nur bedingt empfehlenswert. &Auml;nderungen an der Tabellenstruktur sollten durch spezielle Programme wie PHPMyAdmin realisiert werden. Au&szlig;erdem ist es hier m&ouml;glich sich die Inhalte von ausgew&auml;hlten Tabellen anzeigen zu lassen. F&uuml;r alle diese Prozeduren sind gute Kenntnisse in der SQL-Syntax unbedingt erforderlich.<br><br>Soll f&uuml;r die SQL-Datenbankverbindung eine Include-Datei genutzt werden, so ist diese Datei (<strong>Dateiname:</strong> " . basename($obelix_file_name_array[7]) . ", Aufbau: siehe unten) im aktuellen Verzeichnis zu speichern. Die Include-Datei kann auch durch diese Seite automatisch erstellt werden. Die Include-Datei (<strong>Dateiname:</strong> " . basename($obelix_file_name_array[7]) . ") ist zu verwenden, falls f&uuml;r die Datenbankverbindung eine &Uuml;bertragung der Zugangsdaten mittels des HTTP-Protokolls aus Sicherheitsgr&uuml;nden nicht erlaubt ist. F&uuml;r andere SQL-Datenbanken (MariaDB, PostgreSQL) kann diese Seite erst genutzt werden, wenn der Quellcode entsprechend angepasst und erg&auml;nzt wurde.<br><br><strong>Hinweis: </strong> Die MySQL-Erweiterung ist seit PHP 5.5.0 als veraltet markiert und wird seit PHP 7.2.16 nicht mehr unterst&uuml;tzt. Stattdessen ist die Erweiterungen MySQLi bevorzugt zu nutzen. Beachte: Die MySQL-Erweiterung (Modul) wird aber noch von vielen Anbieter weiterhin genutzt (verf&uuml;gbare Datenbank-Module: siehe Startmen&uuml; - " . $obelix_hyperlink_array[8] . " oder auf dieser Seite weiter unten). F&uuml;r den Fall das beide Module (MySQL und MySQLi) geladen wurden, k&ouml;nnen die Einstellungen des Webhosters die Benutzung eines SQL-Moduls trotzdem verbieten (L&ouml;sung: MySQL &lt;-&gt; MySQLi)."; // Text des Hauptinhaltes
$mysql_command_db_type_mysqli="MySQLi:"; // Meldung, Information an den Benutzer
$mysql_command_db_type_mysql="MySQL:"; // Meldung, Information an den Benutzer
$mysql_command_host_name_title="Host-Name:"; // Meldung, Information an den Benutzer
$mysql_command_db_name_title="Datenbank-Name:"; // Meldung, Information an den Benutzer
$mysql_command_db_user_name_title="Benutzer-Name:"; // Meldung, Information an den Benutzer
$mysql_command_db_password_title="Passwort:"; // Meldung, Information an den Benutzer
$mysql_command_note_title_1="Hinweis:"; // Meldung, Information an den Benutzer
$mysql_command_note_title_2="Auswahl der Art und Weise des Verbindungsaufbaues mit der SQL-Datenbank"; // Meldung, Information an den Benutzer
$mysql_command_note_1="Standard - Angaben in den Felder nutzen"; // Meldung, Information an den Benutzer
$mysql_command_note_2="Angaben aus einer Include-Datei (Text) verwenden"; // Meldung, Information an den Benutzer
$mysql_command_note_3="Angaben aus einer Include-Datei (Base64-Kodiert) verwenden"; // Meldung, Information an den Benutzer
$mysql_command_note_4="Angaben der Felder in eine Include-Datei schreiben (Text) und verwenden"; // Meldung, Information an den Benutzer
$mysql_command_note_5="Angaben der Felder in eine Include-Datei schreiben (Base64-Kodiert) und verwenden"; // Meldung, Information an den Benutzer
$mysql_command_textarea_title="SQL-Befehl hier eingeben:"; // Meldung, Information an den Benutzer
$mysql_command_button_name="SQL-BEFEHL &Uuml;BERTRAGEN"; // Beschriftung des Submit-Buttons
$mysql_command_data_fieldname_1="Lfd.-Nr."; // Beschriftung des Tabellenkopfes 1
$mysql_command_data_fieldname_2="Tabellenname"; // Beschriftung des Tabellenkopfes 1
$mysql_command_data_fieldname_3="Feldanzahl"; // Beschriftung des Tabellenkopfes 1
$mysql_command_data_fieldname_4="Anzahl der Datens&auml;tze"; // Beschriftung des Tabellenkopfes 1
$mysql_command_table_content_titel_name="Tabelle:"; // Beschriftung des Tabellenkopfes 2
$mysql_command_table_content_fieldname="Feldname"; // Beschriftung des Zeilennamen Tabelle 2
$mysql_command_table_content_fieldlength="L&auml;nge"; // Beschriftung des Zeilennamen Tabelle 2
$mysql_command_table_content_fieldtype="Feldtyp"; // Beschriftung des Zeilennamen Tabelle 2
$mysql_command_info_row_1_column_1="<strong>Info: Standard-SQL:</strong><br><br><strong>Beispiel:</strong> neue MySQL- oder MySQLi-Tabelle<br><br>CREATE TABLE `capital_city` (<br>`id` SMALLINT(6) UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,<br>`date` DATE,<br>`country` VARCHAR(255),<br>`capital` VARCHAR(255),<br>`capital_info` TEXT,<br>`population` INT(10) UNSIGNED NOT NULL,<br>`status` TINYINT(3) UNSIGNED NOT NULL<br>)<br>COMMENT = 'Kommentar zur Tabelle';<br>INSERT INTO capital_city (date, country, capital, capital_info, population, status) VALUES (NOW(), &apos;Frankreich&apos;, &apos;Paris&apos;, &apos;hier steht Text&apos;, 10000000, 1);<br>INSERT INTO capital_city (date, country, capital, capital_info, population, status) VALUES (NOW(), &apos;Spanien&apos;, &apos;Madrid&apos;, &apos;hier steht Text&apos;, 3400000, 1);<br>INSERT INTO capital_city (date, country, capital, capital_info, population, status) VALUES (NOW(), &apos;Chile&apos;, &apos;Santiago de Chile&apos;, &apos;hier steht Text&apos;, 4000000, 1);"; // Meldung, Information an den Benutzer
$mysql_command_info_row_1_column_2="<strong>Info: Tabellenliste</strong><br>Mit der Markierung des Radiobuttons <strong>&laquo;alle Tabellen anzeigen&raquo;</strong> und mit der Best&auml;tigung durch den Button <strong>&laquo;SQL-Befehl &uuml;bertragen&raquo;</strong> werden alle verf&uuml;gbaren Tabellen der aktuellen Datenbank angezeigt, einschlie&szlig;lich der Feldanzahl und der Anzahl der Datens&auml;tze. Voraussetzung ist, dass sich im Texteingabefeld &laquo;SQL-Befehl&raquo; <strong>kein</strong> Eintrag befindet.<br><strong>Hinweis: </strong>Sollen nur Tabellen in deren Namen sich ein gesuchter Namensbestandteil befindet, so ist dieser im Texteingabefeld &laquo;SQL-Befehl&raquo; einzutragen (z.B. <strong>termine</strong> - d.h. es werden alle Tabellen gefunden, in deren Tabellennamen die Zeichenkette <strong>termine</strong> enthalten ist). Es k&ouml;nnen mehrere Suchbegriffe im Texteingabefeld eingetragen werden, aber jeweils nur ein Suchbegriff pro Zeile (harter Zeilenumbruch durch die Enter-Taste, ohne abschlie&szlig;endes Semikolon - ;). SQL-Befehle im Texteingabefeld &raquo;SQL-Befehl&laquo; (CREATE, INSERT, UPDATE, ...) sind w&auml;hrend der Suche nach vorhandenen Tabellen unzul&auml;ssig."; // Meldung, Information an den Benutzer
$mysql_command_info_row_1_column_3="<strong>Info: Tabelleninformationen</strong><br>Mit der Markierung des Radiobuttons <strong>&laquo;Tabelleninformationen&raquo;</strong> und mit der Best&auml;tigung durch den Button<strong> &laquo;SQL-Befehl &uuml;bertragen&raquo;</strong> werden f&uuml;r alle Tabellen der aktuellen Datenbank einige Tabelleninfornationen (Anzahl der Datens&auml;tze, Feldanzahl, Feldtypen, Feldl&auml;ngen) verf&uuml;gbar. Voraussetzung ist, dass sich im Texteingabefeld &laquo;SQL-Befehl&raquo; <strong>kein</strong> Eintrag befindet. Bei der Ausgabe der Feldtypen ist folgendes zu beachten: INT -&gt; LONG, SMALLINT -&gt; SHORT, TINYINT -&gt; CHAR, TEXT -&gt; BLOB, VARCHAR -&gt; VAR_STRING, BLOB -&gt; BLOB, MEDIUMBLOB -&gt; BLOB, LONGBLOB -&gt; BLOB.<br><strong>Hinweis: </strong>Sollen nur Tabellen in deren Namen sich ein gesuchter Namensbestandteil befindet, so ist dieser im Texteingabefeld &laquo;SQL-Befehl&raquo; einzutragen (z.B. <strong>termine</strong> - d.h. es werden alle Tabellen gefunden, in deren Tabellennamen die Zeichenkette <strong>termine</strong> enthalten ist). Es k&ouml;nnen mehrere Suchbegriffe im Texteingabefeld eingetragen werden, aber jeweils nur ein Suchbegriff pro Zeile (harter Zeilenumbruch durch die Enter-Taste, ohne abschlie&szlig;endes Semikolon - ;). SQL-Befehle im Texteingabefeld &raquo;SQL-Befehl&laquo; (CREATE, INSERT, UPDATE, ...) sind w&auml;hrend der Suche nach vorhandenen Tabellen unzul&auml;ssig."; // Meldung, Information an den Benutzer
$mysql_command_info_row_2="<strong>Anmerkung:</strong> NOT NULL: Mit NOT NULL wird festgelegt, da&szlig; ein Wert (das kann auch ein leerer Wert sein) eingetragen werden mu&szlig;. NULL ist nicht mit der Zahl 0 zu verwechseln. NULL bedeutet einfach kein Wert. Wenn bei INSERT kein Wert f&uuml;r dieses Feld angegeben wurde, wird der Standardwert genommen. AUTO_INCREMENT: Wenn ein Zahlenfeld mit dem Schl&uuml;sselwort AUTO_INCREMENT angelegt wurde und kein Wert f&uuml;r dieses Feld festgelegt wurde, wird der h&ouml;chste Wert +1 genommen. AUTO_INCREMENT kann nur einmal pro Tabelle in einem Prim&auml;rschl&uuml;sselfeld verwendet werden. PRIMARY KEY: Mit PRIMARY KEY wird der Prim&auml;rschl&uuml;ssel festgelegt. Bei zusammengesetzten Prim&auml;rschl&uuml;sseln sind alle Felder, die Teil des Schl&uuml;ssels sind, anzugeben. Prim&auml;rschl&uuml;ssel m&uuml;ssen eindeutig sein und es mu&szlig; NOT NULL angegeben werden. TINYINT (-128 .. 127), TINYINT UNSIGNED (0 .. 255, UNSIGNED .. ohne Vorzeichen), INT (-2.147.483.648 .. 2.147.483.647), INT UNSIGNED (0 .. 4.294.967.295), VARCHAR (Zeichenkette: 1 .. 255 Stellen, Leerstellen am Ende werden gel&ouml;scht), TEXT (Text mit einer max. L&auml;nge von 65535 Zeichen), TIME (Format: HH:MM:SS, HHMMSS, HHMM oder HH), DATE (Format: YYYY-MM-DD, wobei der Bindestrich - jedes nicht numerische Zeichen sein kann).<br><br>F&uuml;r die Verwendung von Transaktionen und Rollbacks ist der Tabellentyp InnoDB unbedingt erforderlich. Mit Rollback bezeichnet man das R&uuml;ckg&auml;ngigmachen einer Transaktion oder einer einzelnen Datenbank-Operation. Eine Transaktion kann man sich wie eine Art von Container vorstellen, der mehrere SQL-Befehle enth&auml;lt. Der Container wird als Einheit an die Datenbank &uuml;bergeben und die darin enthaltenen SQL-Befehle werden als Einheit von der Datenbank ausgef&uuml;hrt. F&uuml;r die Nutzung von Transaktionen und Rollbacks sind innerhalb von PHP-Skripts die Funktionen mysqli_autocommit(&#36;db_name, FALSE), mysqli_commit(&#36;db_name) und mysqli_rollback(&#36;db_name) zust&auml;ndig. Die aktuelle Storage Engine (Default-Wert f&uuml;r den Tabellentyp) kann &uuml;ber den SQL-Befehl SHOW VARIABLES LIKE &apos;%storage_engine%&apos; ermittelt werden. Ist der Default-Wert des Tabellentyps identisch mit dem gew&uuml;nschten Tabellentyp, so kan die Angabe ENGINE=InnoDB in der CREATE TABLE-Anweisung entfallen. Tabellen vom Typ MyISAM einer bereits vorhandenen Datenbank k&ouml;nnen mittels des SQL-Befehl ALTER TABLE in den Tabellentyp InnoDB konvertiert werden. Die Konvertierung des Tabellentyps InnoDB in den Tabellentyp MyISAM ist nicht m&ouml;glich."; // Meldung, Information an den Benutzer
$mysql_command_info_row_3="<strong>Info: Standard-SQL:</strong> Im Texteingabefeld ist je Zeile eine SQL-Abfrage zul&auml;sssig. Eine SQL-Abfrage besteht aus mindestens 9 bis etwa maximal 520 Zeichen (SQL-Befehle: UPDATE, INSERT, DELETE, ALTER TABLE, ...) und jede einzelne Abfrage ist mit einem Semikolon (;) abzuschlie&szlig;en.<br>F&uuml;r Tabellennamen sollte nur das englische Alphabet, Zahlen und der Unterstrich verwendet werden (a-zA-Z0-1_).<br><strong>Hinweis:</strong> In SQL-Sprachen gibt es einige reservierte Namen, die f&uuml;r Tabellen- und Feldnamen nicht genutzt werden sollten. Beispiel - Tabellennamen: &raquo;table_capital_city&laquo; ist nicht zul&auml;ssig; &raquo;capital_city&laquo; ist zul&auml;ssig. Daher sollte in Tabellen- oder Feldnamen auf Namensbestandteile mit typischen SQL-Befehlen verzichtet werden.<br>Bei einer SELECT-Abfrage werden bei langen Texten - um die &Uuml;bersichtlichkeit zu wahren, nur die ersten 64 Zeichen am Bildschirm dargestellt, gefolgt von 3 Punkten (z.B. hier steht ein langer Text...)."; // Meldung, Information an den Benutzer
$mysql_command_info_row_4_column_1="<strong>MySQL und MySQLi-Befehle (Beispiele):</strong><br><br>INSERT INTO capital_city (date, country, capital, capital_info, population, status) VALUES (NOW(), &apos;Brasilien&apos;, &apos;Brasilia&apos;, &apos;hier steht Text&apos;, 1000000, 1);<br>INSERT INTO capital_city (date, country, capital, capital_info, population, status) VALUES (NOW(), &apos;Algerien&apos;, &apos;Algier&apos;, &apos;hier steht Text&apos;, 700000, 1);<br>INSERT INTO capital_city (date, country, capital, capital_info, population, status) VALUES (NOW(), &apos;Kanada&apos;, &apos;Ottawa&apos;, &apos;hier steht Text&apos;, 2500000, 1);<br>INSERT INTO capital_city (date, capital, status) VALUES (&apos;2020-10-05&apos;, &apos;Rom&apos;, 1);<br>UPDATE capital_city SET country=&apos;Italien&apos;, capital_info=&apos;hier steht der eingef&uuml;gte Text&apos;, population=2900000 WHERE id=7;<br>SELECT * FROM capital_city;<br>SELECT * FROM capital_city WHERE id&gt;2 ORDER BY date;<br>SELECT * FROM capital_city ORDER BY id LIMIT 10;<br>SELECT * FROM capital_city ORDER BY id LIMIT 3,10;<br>SELECT * FROM capital_city WHERE country LIKE &apos;%Bra%&apos;;<br>ALTER TABLE capital_city ADD embassy VARCHAR(255) NOT NULL AFTER population;<br>ALTER TABLE capital_city CHANGE embassy embassy_address VARCHAR(255) NOT NULL;<br>ALTER TABLE capital_city DROP embassy_address;<br>ALTER TABLE capital_city RENAME capital_city_europe;<br>ALTER TABLE capital_city_europe CHANGE country country VARCHAR(128) NOT NULL;<br>ALTER TABLE capital_city_europe CHANGE capital capital VARCHAR(128) NOT NULL;<br>SHOW COLUMNS FROM capital_city_europe;<br>DELETE FROM capital_city_europe WHERE id=3;<br>DELETE FROM capital_city_europe WHERE id BETWEEN 4 AND 6;<br>DELETE FROM capital_city_europe WHERE id>50;<br>DROP TABLE capital_city_europe;<br>SHOW TABLES;<br><br>DROP TABLE capital_city_1, capital_city_2, capital_city_3;<br>DELETE FROM capital_city_1 WHERE country=&apos;Chile&apos; OR country=&apos;Brasilien&apos; OR country=&apos;Algerien&apos; OR country=&apos;Kanada&apos;;<br><br> <strong>Hinweis:</strong> F&uuml;r vorgenannte Befehle sollte der Radiobutton <strong>&laquo;Standard-SQL&raquo;</strong> markiert sein und alle SQL-Befehle sind mit einem Semikolon (;) abzuschlie&szlig;en. In der SQL-Abfrage ist das einfache Hochkomma (&apos;) und das Semikolon (;) innerhalb von Strings, Texten nicht zu verwenden - dies ist bedingt durch die SQL-Syntax und dem zugrundeliegenden PHP-Algorithmus. Der Backslash &#92; innerhalb von Strings, Texten ist durch einen zweiten Backslash zu sch&uuml;tzen, also &#92;&#92; (Backslash - zul&auml;ssige Anzahl: 2, 4, ...)."; // Meldung, Information an den Benutzer
$mysql_command_info_row_4_column_2="<strong>Hinweis:</strong> nachfolgender PHP-Code <strong>nicht</strong> in das Texteingabefeld eintragen (siehe auch: weiter oben) !! <br><br><strong>Datei: " . basename($obelix_file_name_array[7]) . " (Text)</strong><br> &lt;?php <br>&#36;host_name = &apos;host_name.provider.com&apos;; <br>&#36;db_name = &apos;DB12345&apos;; <br>&#36;db_user_name = &apos;user_db12345&apos;; <br>&#36;db_password = &apos;secret&apos;; <br>?&gt; <br><br><strong>Datei: " . basename($obelix_file_name_array[7]) . " (Base64-kodiert)</strong> <br>&lt;?php<br>&#36;host_name = &apos;aG9zdF9uYW1lLnByb3ZpZGVyLmNvbQ==&apos;; <br>&#36;db_name = &apos;REIxMjM0NQ==&apos;; <br>&#36;db_user_name = &apos;dXNlcl9kYjEyMzQ1&apos;; <br>&#36;db_password = &apos;c2VjcmV0&apos;; <br>?&gt; <br><br><strong>Datei: info_php_module.php (PHP-Module anzeigen)</strong> <br>&lt;?php<br>print &quot;&lt;pre&gt;&quot;; <br>print_r(get_loaded_extensions()); <br>print &quot;&lt;/pre&gt;&quot;; <br>?&gt; <br><br><strong>Datei: sql_field_types.php (MySQLi-Feldtypen anzeigen)</strong> <br>&lt;?php<br>&#36;types = array(); <br>&#36;constants = get_defined_constants(true); <br>foreach (&#36;constants[&apos;mysqli&apos;] as &#36;c =&gt; &#36;n) if (preg_match(&apos;/^MYSQLI_TYPE_(.*)/&apos;, &#36;c, &#36;m)) &#36;types[&#36;n] = &#36;m[1]; <br>echo &quot;&lt;pre&gt;&quot;; <br>echo print_r(&#36;types); <br>echo &quot;&lt;/pre&gt;&quot;; <br>?&gt;<br><br>MySQL-Feldtypen anzeigen: MYSQLI_TYPE -&gt; MYSQL_TYPE"; // Meldung, Information an den Benutzer
$mysql_command_sql_choice_title_1="Standard-SQL:"; // Meldung, Information an den Benutzer
$mysql_command_sql_choice_title_2="Tabellenliste (alle Tabellen anzeigen):"; // Meldung, Information an den Benutzer
$mysql_command_sql_choice_title_3="Tabelleninformationen:"; // Meldung, Information an den Benutzer
$mysql_command_messages_to_fill_all_fields="Hinweis: Es m&uuml;ssen alle Felder (Host-Name, Datenbank-Name, Benutzer-Name) ausgef&uuml;llt werden!"; // Meldung, Information an den Benutzer
$mysql_command_messages_binary_content="HINWEIS: FELD ENH&Auml;LT BIN&Auml;RDATEN"; // Meldung, Information an den Benutzer
$mysql_command_messages_include_file_damaged="Hinweis: Die include-Datei " . $obelix_file_name_array[7] . " - mit den Datenbank-Zugangsdaten - ist besch&auml;digt!"; // Meldung, Information an den Benutzer
$mysql_command_messages_include_file_not_found="Hinweis: Die Include-Datei " . $obelix_file_name_array[7] . " - mit den Datenbank-Zugangsdaten - wurde im aktuellen Verzeichnis nicht gefunden!"; // Meldung, Information an den Benutzer
$mysql_command_messages_include_file_not_delete="Hinweis: Eine bereits vorhandene Include-Datei " . $obelix_file_name_array[7] . " konnte nicht gel&ouml;scht werden!"; // Meldung, Information an den Benutzer
$mysql_command_messages_include_file_not_readable="Hinweis: Die include-Datei " . $obelix_file_name_array[7] . " - mit den Datenbank-Zugangsdaten - ist nicht lesbar (unzureichende Zugriffsrechte)!"; // Meldung, Information an den Benutzer
$mysql_command_messages_include_file_not_writable="Hinweis: Die Include-Datei " . $obelix_file_name_array[7] . " - f&uuml;r die Datenbank-Zugangsdaten - konnte nicht beschrieben werden!"; // Meldung, Information an den Benutzer
$mysql_command_messages_include_file_not_create="Hinweis: Die Include-Datei " . $obelix_file_name_array[7] . " - f&uuml;r die Datenbank-Zugangsdaten - konnte nicht erstellt werden!"; // Meldung, Information an den Benutzer
$mysql_command_messages_current_directory_not_writable="Hinweis: Das aktuelle Verzeichnis ist nicht beschreibbar!"; // Meldung, Information an den Benutzer
$mysql_command_messages_not_db_connection="Hinweis: Die Verbindung zur Datenbank konnte nicht hergestellt werden! Datenbankname:"; // Meldung, Information an den Benutzer
$mysql_command_messages_mysqli_extension_not_found="Hinweis: Die MySQLi-Bibliothek (MySQLi-Extension) ist nicht verf&uuml;gbar oder der Zugriff auf die MySQLi-Datenbank wurde deaktiviert!"; // Meldung, Information an den Benutzer
$mysql_command_messages_mysql_extension_not_found="Hinweis: Die MySQL-Bibliothek (MySQL-Extension) ist nicht verf&uuml;gbar oder der Zugriff auf die MySQL-Datenbank wurde deaktiviert!"; // Meldung, Information an den Benutzer
$mysql_command_messages_sql_query_successful="Hinweis: Die SQL-Anfrage wurde ausgef&uuml;hrt!"; // Meldung, Information an den Benutzer
$mysql_command_messages_not_table_found="Hinweis: Die Suchabfrage konnte keine Tabellen finden!"; // Meldung, Information an den Benutzer
$mysql_command_messages_not_data_records_found="Hinweis: Die Suchabfrage konnte keine Datens&auml;tze finden!"; // Meldung, Information an den Benutzer
$mysql_command_messages_sql_query_not_successful="Hinweis: Die SQL-Anfrage konnte nicht ausgef&uuml;hrt werden! SQL-Anfrage:"; // Meldung, Information an den Benutzer
$mysql_command_messages_table_short_content="Tabelleninformation: Den Tabellennamen oder einen Teiĺ des Namens ins Texteingabefeld eintragen und den Radio-Button &raquo;Tabelleninformationen&laquo; aktivieren."; // Meldung, Information an den Benutzer
$mysql_command_messages_sql_query_having_errors="Hinweis: Die Syntax der SQL-Anfrage ist m&ouml;glicherweise fehlerbehaftet!  SQL-Anfrage:"; // Meldung, Information an den Benutzer
$mysql_command_messages_db_not_closed="Hinweis: Das Schlie&szlig;en der Verbindung zur SQL-Datenbank ist fehlgeschlagen! Datenbankname:"; // Meldung, Information an den Benutzer

// Bereich: Variablen der Image-Editing--Seite
$image_editing_main_head_line="" . $obelix_hyperlink_array[16] . " - grundlegende Bildbearbeitung"; // Ueberschrift des Hauptinhaltes
$image_editing_main_content="Der von dieser Seite aufgerufene Image-Editor unterst&uuml;tzt nur die Bildtypen JPEG, PNG und GIF (siehe auch: " . $obelix_hyperlink_array[10] . ", " . $obelix_hyperlink_array[2] . ", " . $obelix_hyperlink_array[3] . ", " . $obelix_hyperlink_array[4] . "). Diese Bildtypen werden von allen grafischen Internet-Browser unterst&uuml;tzt. Die Darstellung anderer Bildtypen erfordert h&auml;ufig die Installation von zus&auml;tzlicher Software (Module, Add-Ons).<br><br>Die verschiedenen Dateitypen der Bilder werden von Image-Editing, ausschlie&szlig;lich an den Dateiendungen (.jpeg, .jpg, .gif, .png) erkannt. Das GIF-Format (Transparenz, Animationen) unterst&uuml;tzt maximal 256 Farben, das JPEG-Format maximal 16,7 Millionen Farben und das PNG-Format (Transparenz, Alphakanal) unterst&uuml;tzt ebenfalls bis zu 16,7 Millionen Farben. Den Eigenschaften der einzelnen Bild-Formate sollte bei der Bildbearbeitung und Bildkonvertierung durch den Image-Editor immer ausreichende Aufmerksamkeit geschenkt werden.<br><br>Das Ausgangsbild wird beim Aufruf des Image-Editors immer in den Arbeitsbereich des Image-Editors kopiert. Der Image-Editor kann das Ausgangsbild nicht durch das bearbeitete Bild ersetzen, der Austausch einer bearbeiteten Bilddatei (aktuelle Seite sollte voher aktualisiert werden) erfolgt erst durch die aktuelle Seite Image-Editing (Voraussetzung: ausreichende Zugriffsberechtigungen).<br><br>Bei der freien Eintragung des Startverzeichnisses, sind nur relative Verzeichnispfade zul&auml;ssig. Die relativen Verzeichnispfade fangen immer mit der Zeichenkette ./, ../, ../../ usw. an.<br><br>"; // Text des Hauptinhaltes
$image_editing_max_execution_time_part_1="<strong>Hinweis:</strong> Die maximale Ausf&uuml;hrungszeit (Serverzeit, siehe auch: " . $obelix_hyperlink_array[8] . ") des PHP-Skriptes betr&auml;gt aktuell";
$image_editing_max_execution_time_part_2 = @ini_get('max_execution_time');
$image_editing_max_execution_time_part_3="Sekunden.";
$image_editing_current_max_execution_time=$image_editing_max_execution_time_part_1 . " " . $image_editing_max_execution_time_part_2 . " " . $image_editing_max_execution_time_part_3; // zusaetzlicher Text des Hauptinhaltes
$image_editing_max_memory_limit_part_1="Der maximal verwendbare Arbeitsspeicher (Server, siehe auch: " . $obelix_hyperlink_array[8] . ") betr&auml;gt aktuell";
$image_editing_max_memory_limit_part_2 = @ini_get('memory_limit');
$image_editing_max_memory_limit_part_3="(M .. Megabyte).";
$image_editing_current_max_memory_limit=$image_editing_max_memory_limit_part_1 . " " . $image_editing_max_memory_limit_part_2 . " " . $image_editing_max_memory_limit_part_3; // zusaetzlicher Text des Hauptinhaltes
$image_editing_title_max_execution_time_memory_limit_modified="maximale Ausf&uuml;hrungszeit und Arbeitsspeicher f&uuml;r das PHP-Skript erh&ouml;hen"; // Meldung, Information an den Benutzer
$image_editing_title_choice_start_directory="Startverzeichnis f&uuml;r die Bildersuche ausw&auml;hlen"; // Meldung, Information an den Benutzer
$image_editing_title_start_directory="Ausgangsverzeichnis:"; // Meldung, Information an den Benutzer
$image_editing_title_work_directory="aktuelles Arbeitsverzeichnis:"; // Meldung, Information an den Benutzer
$image_editing_title_start_current_directory_depth="aktuelle Verzeichnistiefe:"; // Meldung, Information an den Benutzer
$image_editing_title_current_directory="aktuelles Verzeichnis (./)"; // Meldung, Information an den Benutzer
$image_editing_title_directory_level_one_higher="eine Verzeichnisebene h&ouml;her (../)"; // Meldung, Information an den Benutzer
$image_editing_title_directory_level_two_higher="zwei Verzeichnisebene h&ouml;her (../../)"; // Meldung, Information an den Benutzer
$image_editing_title_directory_level_free_choice="freie Wahl des Startverzeichnissses"; // Meldung, Information an den Benutzer
$image_editing_title_directory_level_change="Startverzeichnis hier eingeben:"; // Meldung, Information an den Benutzer
$image_editing_directory_level_change_example="Beispiel: ../../../tmp/install/"; // Meldung, Information an den Benutzer
$image_editing_directory_level_change_note="<strong>Hinweis:</strong> Bezugspunkt f&uuml;r das Startverzeichnis ist das Verzeichnis in dem OBELIX abgelegt wurde."; // Meldung, Information an den Benutzer
$image_editing_title_thumbnail_main_directory="Hauptverzeichnisse (Image-Editor):"; // Meldung, Information an den Benutzer
$image_editing_title_thumbnail_work_directory="Bild-Verzeichnis:"; // Meldung, Information an den Benutzer
$image_editing_title_thumbnail_result_directory="Verzeichnisse mit den gefundenen Bildern"; // Meldung, Information an den Benutzer
$image_editing_hyperlink_title="BEARBEITEN"; // Meldung, Information an den Benutzer
$image_editing_source_file_title="BILD 1"; // Meldung, Information an den Benutzer
$image_editing_target_file_title="BILD 2"; // Meldung, Information an den Benutzer
$image_editing_title_change_directory_depth="Verzeichnistiefe (1-9):"; // Meldung, Information an den Benutzer
$image_editing_directory_default_depth=3; // Vorgabe der Verzeichnistiefe, 1 ... 9, 3 (default)
$image_editing_file_type_regex='\.(jp[e]?g|gif|png)$'; // regulaeren Ausdruck, fuer die Filterung von Bild-Dateien
$image_editing_thumbnail_width=250; // Breite der Thumbnail-Bilder, 1 ... 999 (Pixel), 250 (default)
$image_editing_thumbnail_height=150; // Hoehe der Thumbnail-Bilder, 1 ... 999 (Pixel), 150 (default)
$image_editing_jpeg_quality=90; // Bildqualitaet: 0 ... 100 (0 .. geringste Qualitaet, kleine Datei - 100 .. beste Qualitaet, grosze Datei), 90 (default)
$image_editing_png_quality=6; // Bildqualitaet: 0 ... 9 (0 .. keine Kompression, hohe Qualitaet - 9 .. hohe Kompression, geringste Qualitaet), 6 (default)
$image_editing_search_button_name="VERF&Uuml;GBARE BILDER SUCHEN ODER ANSICHT AKTUALISIEREN"; // Beschriftung des Submit-Buttons
$image_editing_overwrite_button_name="DAS AUSGEW&Auml;HLTE BILD - " . $image_editing_target_file_title . " - DURCH EIN BEARBEITETES BILD - " . $image_editing_source_file_title . " - &Uuml;BERSCHREIBEN"; // Beschriftung des Submit-Buttons
$image_editing_title_help_text="Hinweis- und Hilfetext"; // Meldung, Information an den Benutzer
$image_editing_help_text="Ein bearbeitetes Bild (Gruppe: " . $image_editing_source_file_title . ") kann ein ausgw&auml;hltes Bild (Gruppe: " . $image_editing_target_file_title . ") im unteren Bereich &uuml;berschreiben (Voraussetzung: ausreichende Zugriffsberechtigungen).<br><br>Das Verzeichnis mit den Thumbnail-Bildern kann nach einiger Zeit viele nicht mehr ben&ouml;tigte Thumbnail-Bilder enthalten. Dies Verzeichnis sollte daher von Zeit zu Zeit gel&ouml;scht werden (siehe auch: " . $obelix_hyperlink_array[12] . ", " . $obelix_hyperlink_array[4] . ").<br><br>Die Erstellung der Thumbnail-Bilder, kann bei vielen Bilder einige Zeit in Anspruch nehmen. Sollte die Ausf&uuml;hrungszeit gr&ouml;&szlig;er sein als die &uuml;bliche Standardzeit, so wird unweigerlich die Ausf&uuml;hrung des PHP-Skriptes mit einer entsprechenden Server-Meldung beendet. Falls dies eintritt, so kann die Ausf&uuml;hrungszeit zeitweilig &uuml;ber die betreffende Checkbox auf dieser Seite erh&ouml;ht werden (siehe auch: " . $obelix_hyperlink_array[8] . " =&gt; disable_functions; &raquo;ini_set&laquo; sollte dort <strong>nicht</strong> aufgelistet sein).<br><br>Bei leistungschwachen Servern, sollte man sich bei der Bildersuche auf das aktuelle Verzeichnis konzentrieren.";
$image_editing_no_editor_image_found_message="Damit Bilder hier angezeigt werden k&ouml;nnen, muss vorher ein Bild im unteren Bereich (" . $image_editing_title_thumbnail_result_directory . ") zur Bearbeitung ausgw&auml;hlt werden."; // Meldung, Information an den Benutzer
$image_editing_no_search_image_found_message="Die Bildsuche konnte keine Bilder finden."; // Meldung, Information an den Benutzer
$image_editing_overwrite_successful_messages="Hinweis: Die ausgew&auml;hlte Bilddatei wurde &uuml;berschrieben!"; // Meldung, Information an den Benutzer
$image_editing_overwrite_not_successful_messages="Hinweis: Die ausgew&auml;hlte Bilddatei konnte nicht &uuml;berschrieben werden!"; // Meldung, Information an den Benutzer
$image_editing_file_not_writable_messages="Hinweis: Die ausgew&auml;hlte Bilddatei konnte nicht &uuml;berschrieben werden! Grund: M&ouml;glicherweise besitzen Sie unzureichende Zugriffsrechte."; // Meldung, Information an den Benutzer
$image_editing_file_not_found_messages="Hinweis: Die Bilddateien existieren nicht oder es wurde kein Dateiname &uuml;bergeben!"; // Meldung, Information an den Benutzer
$image_editing_messages_to_select_two_fields="Hinweis: Es m&uuml;ssen 2 vorhandene Bilddateien (Gruppe: " . $image_editing_source_file_title . " und " . $image_editing_target_file_title . ") ausgew&auml;hlt werden!"; // Meldung, Information an den Benutzer
$image_editing_thumbnail_directory_returncode_messages_array=array('Hinweis: Es ist ein schwerwiegender Fehler (RETURNCODE 0) aufgetreten! Funktion: create_thumbnail_directory()',
                                                                   '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                                   'Hinweis: Das Thumbnail-Verzeichnis (RETURNCODE 2) kann nicht genutzt werden - keine Schreibberechtigung! Funktion: create_thumbnail_directory()'); // Array mit Meldungen, Informationen an den Benutzer
$image_editing_directory_file_list_returncode_messages_array=array('Hinweis: Es ist ein schwerwiegender Fehler (RETURNCODE 0) aufgetreten! Funktion: create_work_directory_file_list()',
                                                                   '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                                   'Hinweis: Der f&uuml;r &raquo;IMAGE EDITING&laquo; notwendige Wechsel ins &uuml;bergeordnete Verzeichnis konnte nicht durchgef&uuml;hrt werden!<br>Grund: M&ouml;glicherweise wurde das angegebene  Verzeichnis nicht gefunden oder Sie besitzen unzureichende Zugriffsrechte.<br>Funktion: create_work_directory_file_list()'); // Array mit Meldungen, Informationen an den Benutzer

// Bereich: Variablen des Image-Editor-Seite
$image_editor_main_head_line="IMAGE-EDITOR"; // Ueberschrift des Hauptinhaltes
$image_editor_main_content="Der Image-Editor unterst&uuml;tzt nur die Bildtypen JPEG, PNG und GIF. Diese Bildtypen werden von allen grafischen Internet-Browser unterst&uuml;tzt. Die Darstellung anderer Bildtypen erfordert h&auml;ufig die Installation von zus&auml;tzlicher Software (Module, Add-Ons). Das GIF-Format (Transparenz, Animationen) unterst&uuml;tzt maximal 256 Farben, das JPEG-Format maximal 16,7 Millionen Farben und das PNG-Format (Transparenz, Alphakanal) unterst&uuml;tzt ebenfalls bis zu 16,7 Millionen Farben. Den Eigenschaften der einzelnen Bild-Formate sollte bei der Bildbearbeitung und Bildkonvertierung immer ausreichende Aufmerksamkeit geschenkt werden. Bei einigen Bildbearbeitungsfunktionen, muss man den Aufruf der Bildbearbeitungsfunktion mehrmals wiederholen um einen deutlich erkennbaren Effekt zu erzielen. Einige wenige Funktionen f&uuml;r die Bildbearbeitung sind als experimentell zu betrachten und sollten daher sparsam bis gar nicht verwendet werden. Bei einer Ver&auml;nderung der Bildgr&ouml;&szlig;e (Resize 1-3), werden die Bilder immer proportional verkleinert oder vergr&ouml;&szlig;ert, das hei&szlig;t eine schiefe Gr&ouml;&szlig;enver&auml;nderung wird vom Image-Editor nicht unterst&uuml;tzt. Bei einer Drehung eines Bildes k&ouml;nnen die Gradangaben von 0 bis 360 Grad verwendet werden. In den meisten F&auml;llen, sind nur die Gradangaben 90&deg;, 180&deg; und 270&deg; hilfreich. Bei anderen Gradangaben, sollte das entstandene verdrehte Bild durch eine andere Funktion (Bild zuschneiden), wieder begradigt werden. Das Ausgangsbild wird beim Aufruf des Image-Editors immer in den Arbeitsbereich des Image-Editors kopiert. Der Image-Editor kann das Ausgangsbild nicht durch das bearbeitete Bild ersetzen. Der Austausch des Ausgangsbildes kann nur durch den Aufruf der Seite " . $obelix_hyperlink_array[16] . " bewerkstelligt werden (Voraussetzung: ausreichende Zugriffsberechtigungen). K&ouml;nnen Sie sich einige Funktionen des Image-Editors nicht erkl&auml;ren, so probieren Sie es einfach mit einem Test-Bild aus. Alles was hier m&ouml;glich ist, ist meistens auch erlaubt."; // Text des Hauptinhaltes
$image_editor_max_execution_time_part_1="<strong>Hinweis:</strong> Die maximale Ausf&uuml;hrungszeit (Serverzeit, siehe auch: " . $obelix_hyperlink_array[8] . ") des PHP-Skriptes betr&auml;gt aktuell";
$image_editor_max_execution_time_part_2 = @ini_get('max_execution_time');
$image_editor_max_execution_time_part_3="Sekunden.";
$image_editor_current_max_execution_time=$image_editing_max_execution_time_part_1 . " " . $image_editing_max_execution_time_part_2 . " " . $image_editing_max_execution_time_part_3; // zusaetzlicher Text des Hauptinhaltes
$image_editor_max_memory_limit_part_1="Der maximal verwendbare Arbeitsspeicher (Server, siehe auch: " . $obelix_hyperlink_array[8] . ") betr&auml;gt aktuell";
$image_editor_max_memory_limit_part_2 = @ini_get('memory_limit');
$image_editor_max_memory_limit_part_3="(M .. Megabyte).";
$image_editor_current_max_memory_limit=$image_editing_max_memory_limit_part_1 . " " . $image_editing_max_memory_limit_part_2 . " " . $image_editing_max_memory_limit_part_3; // zusaetzlicher Text des Hauptinhaltes
$image_editor_title_tag_name="IMAGE-EDITOR"; // Text des title-Tag
$image_editor_edgedetect_button_name="Kantenbetonung"; // Beschriftung des Submit-Buttons
$image_editor_sketchy_button_name="Bildskizzierung"; // Beschriftung des Submit-Buttons
$image_editor_emboss_button_name="Pr&auml;gungseffekt"; // Beschriftung des Submit-Buttons
$image_editor_inverting_button_name="Bildfarben invertieren"; // Beschriftung des Submit-Buttons
$image_editor_reflection_horizontal_button_name="Horizontale Spiegelung"; // Beschriftung des Submit-Buttons
$image_editor_reflection_vertical_button_name="Vertikale Spiegelung"; // Beschriftung des Submit-Buttons
$image_editor_rgb_color_1_title="RGB (0-255):"; // Meldung, Information an den Benutzer
$image_editor_alpha_channel_title="Alpha-Kanal:"; // Meldung, Information an den Benutzer
$image_editor_colorize_button_name="Bild einf&auml;rben"; // Beschriftung des Submit-Buttons
$image_editor_pixel_size_title="Pixel:"; // Meldung, Information an den Benutzer
$image_editor_pixel_button_name="Verpixelung des Bildes"; // Beschriftung des Submit-Buttons
$image_editor_x1_y1_title="X1, Y1:"; // Meldung, Information an den Benutzer
$image_editor_x2_y2_title="X2, Y2:"; // Meldung, Information an den Benutzer
$image_editor_line_thickness_title="Dicke:"; // Meldung, Information an den Benutzer
$image_editor_rgb_color_2_title="RGB (0-255):"; // Meldung, Information an den Benutzer
$image_editor_line_button_name="Linie in Bild einf&uuml;gen"; // Beschriftung des Submit-Buttons
$image_editor_color_palette_button_name="Farbpalette:"; // Beschriftung des Buttons
$image_editor_font_size_title="Gr&ouml;&szlig;e (1-5):"; // Meldung, Information an den Benutzer
$image_editor_x_y_1_title="X, Y:"; // Meldung, Information an den Benutzer
$image_editor_rgb_color_3_title="RGB (0-255):"; // Meldung, Information an den Benutzer
$image_editor_horizontal_radio_button_name="Horizontal:"; // Beschriftung des Radio-Buttons
$image_editor_vertical_radio_button_name="Vertikal:"; // Beschriftung des Radio-Buttons
$image_editor_text_title="Text:"; // Meldung, Information an den Benutzer
$image_editor_text_button_name="Text in Bild einf&uuml;gen"; // Beschriftung des Submit-Buttons
$image_editor_brightness_higher_button_name="Bild-Helligkeit erh&ouml;hen"; // Beschriftung des Submit-Buttons
$image_editor_brightness_lower_button_name="Bild-Helligkeit verringern"; // Beschriftung des Submit-Buttons
$image_editor_contrast_higher_button_name="Bild-Kontrast erh&ouml;hen"; // Beschriftung des Submit-Buttons
$image_editor_contrast_lower_button_name="Bild-Kontrast verringern"; // Beschriftung des Submit-Buttons
$image_editor_greyscale_button_name="Graustufen-Bild"; // Beschriftung des Submit-Buttons
$image_editor_softfocus_button_name="Weichzeichnung des Bildes"; // Beschriftung des Submit-Buttons
$image_editor_softfocus_gauss_button_name="Gau&szlig;sche Weichzeichnung"; // Beschriftung des Submit-Buttons
$image_editor_smooth_button_name="Bildgl&auml;ttung"; // Beschriftung des Submit-Buttons
$image_editor_width_title="B:"; // Meldung, Information an den Benutzer
$image_editor_resize_1_button_name="Resize 1"; // Beschriftung des Submit-Buttons
$image_editor_height_title="H:"; // Meldung, Information an den Benutzer
$image_editor_resize_2_button_name="Resize 2"; // Beschriftung des Submit-Buttons
$image_editor_width_height_1_title="B x H:"; // Meldung, Information an den Benutzer
$image_editor_resize_3_button_name="Resize 3"; // Beschriftung des Submit-Buttons
$image_editor_x_y_2_title="X, Y:"; // Meldung, Information an den Benutzer
$image_editor_width_height_2_title="B x H:"; // Meldung, Information an den Benutzer
$image_editor_crop_button_name="Bild zuschneiden"; // Beschriftung des Submit-Buttons
$image_editor_image_name_title="Bildname:"; // Meldung, Information an den Benutzer
$image_editor_image_size_title="Bildgr&ouml;&szlig;e (BxH):"; // Meldung, Information an den Benutzer
$image_editor_file_size_title="Dateigr&ouml;&szlig;e:"; // Meldung, Information an den Benutzer
$image_editor_file_type_title="Typ:"; // Meldung, Information an den Benutzer
$image_editor_mime_type_title="MIME:"; // Meldung, Information an den Benutzer
$image_editor_conversion_button_name="Konvertierung des Bildes"; // Beschriftung des Submit-Buttons
$image_editor_rotate_button_name="Bilddrehung (90&deg;, 180&deg;, 270&deg;)"; // Beschriftung des Submit-Buttons
$image_editor_undo_button_name="UNDO - letzte Bearbeitung am aktuellen Bild r&uuml;ckg&auml;ngig machen"; // Beschriftung des Submit-Buttons
$image_editor_recovery_button_name="Wiederherstellung des aktuellen Bildes durch das Original-Bild"; // Beschriftung des Submit-Buttons
$image_editor_original_button_name="Original-Bild im Verzeichnis original durch das aktuelle Bild ersetzen"; // Beschriftung des Submit-Buttons
$image_editor_close_button_name="Image-Editor schlie&szlig;en"; // Beschriftung des Buttons
$image_dimension_title="Pixel"; // Meldung, Information an den Benutzer
$image_editor_main_help_text="<strong>Kurzhilfe:</strong> Gr&ouml;&szlig;enangaben der Bilder in Pixel; RGB: Rot-, Gr&uuml;n- und Blauanteil eines Bildes; B: Bildbreite, H: Bildh&ouml;he; <strong>Bild zuschneiden:</strong> X,Y-Koordinaten der linken oberen Bildecke eintragen (z.B. 0, 0) und die gew&uuml;nschte Bildbreite und Bildh&ouml;he eintragen, X, Y m&uuml;ssen kleiner als die Bildbreite oder Bildh&ouml;he sein; <strong>Linie einf&uuml;gen:</strong> X1,Y1 .. Anfangspunkt einer Linie; X2,Y2 .. Endpunkt einer Linie, f&uuml;r eine gerade horizontale Linie m&uuml;ssen die Werte f&uuml;r Y1 und Y2 gleich sein, f&uuml;r eine gerade vertikale Linie m&uuml;ssen die Werte f&uuml;r X1 und X2 gleich sein, bei dicken Linien befinden sich die X,Y-Koordinaten in der Mitte der Linie; <strong>Text einf&uuml;gen (horizontal, vertikal):</strong> als Schriftarten und Schriftgr&ouml;&szlig;en stehen nur die in PHP eingebauten Schriftarten (Textkodierung: englisches Alphabet, Zahlen und einige Sonderzeichen) zur Verf&uuml;gung, die Lesbarkeit des eingef&uuml;gten Textes verbessert sich, wenn dieser Text auf eine vorher eingef&uuml;gten dicken Linie platziert wird; <strong>Text (horizontal):</strong> X,Y-Koordinaten des oberen Einf&uuml;gepunktes des 1. Zeichens; <strong>Text (vertikal):</strong> X,Y-Koordinaten des unteren Einf&uuml;gepunktes des 1. Zeichens; <strong>Resize 1:</strong> gew&uuml;nschte Bildbreite eintragen; <strong>Resize 2:</strong> gew&uuml;nschte Bildh&ouml;he eintragen; <strong>Resize 3:</strong> gew&uuml;nschte Bildbreite und Bildh&ouml;he eintragen; <strong>Limit erh&ouml;hen:</strong> Mit der aktivierter Checkbox kann die maximale Ausf&uuml;hrungszeit und der maximal verwendbare Arbeitsspeicher f&uuml;r das PHP-Skript erh&ouml;ht werden; <strong>Bild einf&auml;rben:</strong> 1-3 Farbwerte (0-255) eintragen; der optionale Alpha-Kanal (0-127) f&uuml;r PNG-Bilder bestimmt die Durchsichtigkeit des Bildes, 0 .. undurchsichtig, 127 .. vollst&auml;ndige Transparenz; <strong>Farbpalette:</strong> Die Farpalette dient der einfachen Ermittlung von RGB-Werten, die f&uuml;r die manuelle Eintragung in den anderen Felder ben&ouml;tigt werden. <strong>Hinweis:</strong> Mitunter muss man dem aktuell benutzten Internet-Browser mitteilen, nicht das im Arbeitsspeicher des Internet-Browsers gespeicherte Bild anzuzeigen, sondern das bearbeitete Bild (Aktualisierung des Bildschirms, Funktionstaste F5).";
$image_editor_sub_directory_name_array=array('original', 'edit', 'undo'); // Array mit den Namen der Unterverzeichnisse fuer die Bilder des Image-Editors
$image_editor_returncode_messages_array=array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                              '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                              'HINWEIS: DIE ARBEITSVERZEICHNISSE (RETURNCODE 2) KONNTEN NICHT ERSTELLT WERDEN!',
                                              'HINWEIS: DAS ZU BEARBEITENDE BILD (RETURNCODE 3) WURDE NICHT GEFUNDEN!',
                                              'HINWEIS: KEINE SCHREIBBERECHTIGUNG (RETURNCODE 4) F&Uuml;R EIN ARBEITSVERZEICHNIS!',
                                              'HINWEIS: DER KOPIERVORGANG (RETURNCODE 5) IN DAS ARBEITSVERZEICHNIS KONNTE NICHT DURCHGEF&Uuml;HRT WERDEN!'); // Array mit Meldungen, Informationen an den Benutzer
$image_editor_edgedetect_returncode_messages_array=array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                                         '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                         'HINWEIS: DAS ZU BEARBEITENDE BILD (RETURNCODE 2) WURDE NICHT GEFUNDEN ODER ES WURDE KEIN SCHREIBRECHT GEW&Auml;HRT!',
                                                         'HINWEIS: DIE BILDBEARBEITUNG (RETURNCODE 3) KONNTE NICHT DURCHGEF&Uuml;HRT WERDEN!'); // Array mit Meldungen, Informationen an den Benutzer
$image_editor_sketchy_returncode_messages_array=array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                                      '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                      'HINWEIS: DAS ZU BEARBEITENDE BILD (RETURNCODE 2) WURDE NICHT GEFUNDEN ODER ES WURDE KEIN SCHREIBRECHT GEW&Auml;HRT!',
                                                      'HINWEIS: DIE BILDBEARBEITUNG (RETURNCODE 3) KONNTE NICHT DURCHGEF&Uuml;HRT WERDEN!'); // Array mit Meldungen, Informationen an den Benutzer
$image_editor_emboss_returncode_messages_array=array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                                     '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                     'HINWEIS: DAS ZU BEARBEITENDE BILD (RETURNCODE 2) WURDE NICHT GEFUNDEN ODER ES WURDE KEIN SCHREIBRECHT GEW&Auml;HRT!',
                                                     'HINWEIS: DIE BILDBEARBEITUNG (RETURNCODE 3) KONNTE NICHT DURCHGEF&Uuml;HRT WERDEN!'); // Array mit Meldungen, Informationen an den Benutzer
$image_editor_negate_returncode_messages_array=array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                                      '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                      'HINWEIS: DAS ZU BEARBEITENDE BILD (RETURNCODE 2) WURDE NICHT GEFUNDEN ODER ES WURDE KEIN SCHREIBRECHT GEW&Auml;HRT!',
                                                      'HINWEIS: DIE BILDBEARBEITUNG (RETURNCODE 3) KONNTE NICHT DURCHGEF&Uuml;HRT WERDEN!'); // Array mit Meldungen, Informationen an den Benutzer
$image_editor_flip_returncode_messages_array=array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                                    '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                    'HINWEIS: DAS ZU BEARBEITENDE BILD (RETURNCODE 2) WURDE NICHT GEFUNDEN ODER ES WURDE KEIN SCHREIBRECHT GEW&Auml;HRT!',
                                                    'HINWEIS: DIE BILDBEARBEITUNG (RETURNCODE 3) KONNTE NICHT DURCHGEF&Uuml;HRT WERDEN!'); // Array mit Meldungen, Informationen an den Benutzer
$image_editor_colorize_returncode_messages_array=array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                                       '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                       'HINWEIS: DAS ZU BEARBEITENDE BILD (RETURNCODE 2) WURDE NICHT GEFUNDEN ODER ES WURDE KEIN SCHREIBRECHT GEW&Auml;HRT!',
                                                       'HINWEIS: DIE BILDBEARBEITUNG (RETURNCODE 3) KONNTE NICHT DURCHGEF&Uuml;HRT WERDEN!'); // Array mit Meldungen, Informationen an den Benutzer
$image_editor_maximal_pixelate_argument=250; // maximaler Wert (Pixelgroesze) fuer die Bildbearbeitung, 1 ... 999, 250 (default)
$image_editor_default_pixelate_argument=5; // Default-Wert (Pixelgroesze) fuer die Bildbearbeitung, 1 ... 999, 5 (default)
$image_editor_pixelate_returncode_messages_array=array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                                       '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                       'HINWEIS: DAS ZU BEARBEITENDE BILD (RETURNCODE 2) WURDE NICHT GEFUNDEN ODER ES WURDE KEIN SCHREIBRECHT GEW&Auml;HRT!',
                                                       'HINWEIS: DIE BILDBEARBEITUNG (RETURNCODE 3) KONNTE NICHT DURCHGEF&Uuml;HRT WERDEN!'); // Array mit Meldungen, Informationen an den Benutzer
$image_editor_line_returncode_messages_array=array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                                   '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                   'HINWEIS: DAS ZU BEARBEITENDE BILD (RETURNCODE 2) WURDE NICHT GEFUNDEN ODER ES WURDE KEIN SCHREIBRECHT GEW&Auml;HRT!',
                                                   'HINWEIS: DIE BILDBEARBEITUNG (RETURNCODE 3) KONNTE NICHT DURCHGEF&Uuml;HRT WERDEN!',
                                                   ''); // einfache Fehleingaben (Returncode 4), keine Meldung, Array mit Meldungen, Informationen an den Benutzer
$image_editor_string_returncode_messages_array=array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                                     '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                     'HINWEIS: DAS ZU BEARBEITENDE BILD (RETURNCODE 2) WURDE NICHT GEFUNDEN ODER ES WURDE KEIN SCHREIBRECHT GEW&Auml;HRT!',
                                                     'HINWEIS: DIE BILDBEARBEITUNG (RETURNCODE 3) KONNTE NICHT DURCHGEF&Uuml;HRT WERDEN!',
                                                     ''); // einfache Fehleingaben (Returncode 4), keine Meldung, Array mit Meldungen, Informationen an den Benutzer
$image_editor_brightness_higher_argument=10; // zusaetzlicher Wert fuer die Bildbearbeitung, 0 ... 255, 10 (default)
$image_editor_brightness_lower_argument=-10; // zusaetzlicher Wert fuer die Bildbearbeitung, 0 ... -255, -10 (default)
$image_editor_brightness_returncode_messages_array=array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                                         '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                         'HINWEIS: DAS ZU BEARBEITENDE BILD (RETURNCODE 2) WURDE NICHT GEFUNDEN ODER ES WURDE KEIN SCHREIBRECHT GEW&Auml;HRT!',
                                                         'HINWEIS: DIE BILDBEARBEITUNG (RETURNCODE 3) KONNTE NICHT DURCHGEF&Uuml;HRT WERDEN!'); // Array mit Meldungen, Informationen an den Benutzer
$image_editor_contrast_higher_argument=-5; // zusaetzlicher Wert fuer die Bildbearbeitung, 0 ... -255, -5 (default)
$image_editor_contrast_lower_argument=5; // zusaetzlicher Wert fuer die Bildbearbeitung, 0 ... 255, 5 (default)
$image_editor_contrast_returncode_messages_array=array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                                       '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                       'HINWEIS: DAS ZU BEARBEITENDE BILD (RETURNCODE 2) WURDE NICHT GEFUNDEN ODER ES WURDE KEIN SCHREIBRECHT GEW&Auml;HRT!',
                                                       'HINWEIS: DIE BILDBEARBEITUNG (RETURNCODE 3) KONNTE NICHT DURCHGEF&Uuml;HRT WERDEN!'); // Array mit Meldungen, Informationen an den Benutzer
$image_editor_greyscale_returncode_messages_array=array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                                        '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                        'HINWEIS: DAS ZU BEARBEITENDE BILD (RETURNCODE 2) WURDE NICHT GEFUNDEN ODER ES WURDE KEIN SCHREIBRECHT GEW&Auml;HRT!',
                                                        'HINWEIS: DIE BILDBEARBEITUNG (RETURNCODE 3) KONNTE NICHT DURCHGEF&Uuml;HRT WERDEN!'); // Array mit Meldungen, Informationen an den Benutzer
$image_editor_softfocus_returncode_messages_array=array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                                        '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                        'HINWEIS: DAS ZU BEARBEITENDE BILD (RETURNCODE 2) WURDE NICHT GEFUNDEN ODER ES WURDE KEIN SCHREIBRECHT GEW&Auml;HRT!',
                                                        'HINWEIS: DIE BILDBEARBEITUNG (RETURNCODE 3) KONNTE NICHT DURCHGEF&Uuml;HRT WERDEN!'); // Array mit Meldungen, Informationen an den Benutzer
$image_editor_softfocus_gauss_returncode_messages_array=array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                                              '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                              'HINWEIS: DAS ZU BEARBEITENDE BILD (RETURNCODE 2) WURDE NICHT GEFUNDEN ODER ES WURDE KEIN SCHREIBRECHT GEW&Auml;HRT!',
                                                              'HINWEIS: DIE BILDBEARBEITUNG (RETURNCODE 3) KONNTE NICHT DURCHGEF&Uuml;HRT WERDEN!'); // Array mit Meldungen, Informationen an den Benutzer
$image_editor_smooth_argument=25; // zusaetzlicher Wert fuer die Bildbearbeitung, 0 ... 100, 25 (default)
$image_editor_smooth_returncode_messages_array=array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                                     '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                     'HINWEIS: DAS ZU BEARBEITENDE BILD (RETURNCODE 2) WURDE NICHT GEFUNDEN ODER ES WURDE KEIN SCHREIBRECHT GEW&Auml;HRT!',
                                                     'HINWEIS: DIE BILDBEARBEITUNG (RETURNCODE 3) KONNTE NICHT DURCHGEF&Uuml;HRT WERDEN!'); // Array mit Meldungen, Informationen an den Benutzer
$image_editor_resize_1_returncode_messages_array=array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                                       '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                       'HINWEIS: DAS ZU BEARBEITENDE BILD (RETURNCODE 2) WURDE NICHT GEFUNDEN ODER ES WURDE KEIN SCHREIBRECHT GEW&Auml;HRT!',
                                                       'HINWEIS: DIE BILDBEARBEITUNG (RETURNCODE 3) KONNTE NICHT DURCHGEF&Uuml;HRT WERDEN!',
                                                       'HINWEIS: DAS ZUGRIFFSRECHT EINES ODER MEHRERER BILDER (RETURNCODE 4) KONNTE NICHT GE&Auml;NDERT WERDEN!'); // Array mit Meldungen, Informationen an den Benutzer
$image_editor_resize_2_returncode_messages_array=array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                                       '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                       'HINWEIS: DAS ZU BEARBEITENDE BILD (RETURNCODE 2) WURDE NICHT GEFUNDEN!',
                                                       'HINWEIS: DIE BILDBEARBEITUNG (RETURNCODE 3) KONNTE NICHT DURCHGEF&Uuml;HRT WERDEN!',
                                                       'HINWEIS: DAS ZUGRIFFSRECHT EINES ODER MEHRERER BILDER (RETURNCODE 4) KONNTE NICHT GE&Auml;NDERT WERDEN!'); // Array mit Meldungen, Informationen an den Benutzer
$image_color_red=255; // Hintergrundfarbe - Rotanteil, 0 ... 255, 255 (default)
$image_color_green=255; // Hintergrundfarbe - Gruenanteil, 0 ... 255, 255 (default)
$image_color_blue=255; // Hintergrundfarbe - Blauanteil, 0 ... 255, 255 (default)
$image_editor_resize_3_returncode_messages_array=array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                                       '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                       'HINWEIS: DAS ZU BEARBEITENDE BILD (RETURNCODE 2) WURDE NICHT GEFUNDEN ODER ES WURDE KEIN SCHREIBRECHT GEW&Auml;HRT!',
                                                       'HINWEIS: DIE BILDBEARBEITUNG (RETURNCODE 3) KONNTE NICHT DURCHGEF&Uuml;HRT WERDEN!',
                                                       'HINWEIS: DAS ZUGRIFFSRECHT EINES ODER MEHRERER BILDER (RETURNCODE 4) KONNTE NICHT GE&Auml;NDERT WERDEN!'); // Array mit Meldungen, Informationen an den Benutzer
$image_editor_resize_4_returncode_messages_array=array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                                       '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                       'HINWEIS: DAS ZU BEARBEITENDE BILD (RETURNCODE 2) WURDE NICHT GEFUNDEN ODER ES WURDE KEIN SCHREIBRECHT GEW&Auml;HRT!',
                                                       'HINWEIS: DIE BILDBEARBEITUNG (RETURNCODE 3) KONNTE NICHT DURCHGEF&Uuml;HRT WERDEN!',
                                                       'HINWEIS: DAS ZUGRIFFSRECHT EINES ODER MEHRERER BILDER (RETURNCODE 4) KONNTE NICHT GE&Auml;NDERT WERDEN!'); // Array mit Meldungen, Informationen an den Benutzer
$image_editor_crop_returncode_messages_array=array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                                   '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                   'HINWEIS: DAS ZU BEARBEITENDE BILD (RETURNCODE 2) WURDE NICHT GEFUNDEN ODER ES WURDE KEIN SCHREIBRECHT GEW&Auml;HRT!',
                                                   'HINWEIS: DIE BILDBEARBEITUNG (RETURNCODE 3) KONNTE NICHT DURCHGEF&Uuml;HRT WERDEN!',
                                                   ''); // einfache Fehleingaben (Returncode 4), keine Meldung, Array mit Meldungen, Informationen an den Benutzer
$image_editor_jpeg_quality=90; // Bildqualitaet: 0 ... 100 (0 .. geringste Qualitaet, kleine Datei - 100 .. beste Qualitaet, grosze Datei), 90 (default)
$image_editor_png_quality=6; // Bildqualitaet: 0 ... 9 (0 .. keine Kompression, hohe Qualitaet - 9 .. hohe Kompression, geringste Qualitaet), 6 (default)
$image_editor_conversion_returncode_messages_array=array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                                         '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                         'HINWEIS: DAS ZU BEARBEITENDE BILD (RETURNCODE 2) WURDE NICHT GEFUNDEN ODER ES WURDE KEIN SCHREIBRECHT GEW&Auml;HRT!',
                                                         'HINWEIS: DIE BILDBEARBEITUNG (RETURNCODE 3) KONNTE NICHT DURCHGEF&Uuml;HRT WERDEN!'); // Array mit Meldungen, Informationen an den Benutzer
$image_editor_rotate_returncode_messages_array=array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                                     '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                     'HINWEIS: DAS ZU BEARBEITENDE BILD (RETURNCODE 2) WURDE NICHT GEFUNDEN ODER ES WURDE KEIN SCHREIBRECHT GEW&Auml;HRT!',
                                                     'HINWEIS: DIE BILDBEARBEITUNG (RETURNCODE 3) KONNTE NICHT DURCHGEF&Uuml;HRT WERDEN!'); // Array mit Meldungen, Informationen an den Benutzer
$image_editor_message_file_not_found="Hinweis: Die Bilddatei existiert nicht oder es wurde kein Dateiname &uuml;bergeben!"; // Meldung, Information an den Benutzer

// Bereich: Variablen der Access-Authority-Seite
$access_authority_main_head_line="" . $obelix_hyperlink_array[17] . " - Eigent&uuml;mer und die Gruppenzugeh&ouml;rigkeit von Dateien ermitteln"; // Ueberschrift des Hauptinhaltes
$access_authority_main_content="Mit dieser Testfunktion kann der Eigent&uuml;mer und die Gruppenzugeh&ouml;rigkeit von Dateien, sowie die Standard-Zugriffsrechte von Dateien ermittelt werden (siehe auch: " . $obelix_hyperlink_array[13] . "). Die Testfunktion versucht f&uuml;r die Ermittlung dieser Daten ein Test-Verzeichnis und eine Test-Datei im aktuellen Verzeichnis anzulegen. Wurde durch den Webhoster eine oder mehrere PHP-Funktionen deaktiviert, so versucht die Testfunktion mittels des UNIX/LINUX-Programms &raquo;ls&laquo; eine Ausgabe &uuml;ber die PHP-Funktion &raquo;exec&laquo; zu erreichen.<br><br><strong>Hinweis: </strong> Nach der Ermittlung des Eigent&uuml;mers und der Gruppenzugeh&ouml;rigkeit, wird das Test-Verzeichnis im aktuellen Verzeichnis und die darin angelegte Testdatei automatisch wieder gel&ouml;scht. Falls die Testfunktion den Eigent&uuml;mer und die Gruppenzugeh&ouml;rigkeit von Dateien nicht ermitteln kann, so muss man &uuml;ber andere Ma&szlig;nahmen an die ben&ouml;tigten Informationen gelangen (z.B. Anfrage an den Webhoster)."; // Text des Hauptinhaltes
$access_authority_owner_group_title="OWNER AND GROUP"; // Meldung, Information an den Benutzer
$access_authority_directory_owner_title="DIRECTORY-OWNER:"; // Meldung, Information an den Benutzer
$access_authority_directory_group_title="DIRECTORY-GROUP:"; // Meldung, Information an den Benutzer
$access_authority_file_owner_title="FILE-OWNER:"; // Meldung, Information an den Benutzer
$access_authority_file_group_title="FILE-GROUP:"; // Meldung, Information an den Benutzer
$access_authority_output_directory_ls_title="DIRECTORY-LS:"; // Meldung, Information an den Benutzer
$access_authority_output_file_ls_title="FILE-LS:"; // Meldung, Information an den Benutzer
$access_authority_default_permission_title="DEFAULT-PERMISSION"; // Meldung, Information an den Benutzer
$access_authority_directory_title="DIRECTORY:"; // Meldung, Information an den Benutzer
$access_authority_file_title="FILE:"; // Meldung, Information an den Benutzer
$access_authority_button_name="EIGENT&Uuml;MER UND GRUPPENZUGEH&Ouml;RIGKEIT ERMITTELN"; // Beschriftung des Submit-Buttons
$access_authority_no_exec_function_messages="Die PHP-Funktion &raquo;exec&laquo; steht nicht zur Verf&uuml;gung!"; // Meldung, Information an den Benutzer

// Bereich: Variablen der Create-File-Seite
$create_file_main_head_line="" . $obelix_hyperlink_array[18] . " - Erstellung von eigenen Dateien"; // Ueberschrift des Hauptinhaltes
$create_file_main_content="Auf dieser Seite k&ouml;nnen beliebige Text-Dateien (HTML, PHP, TEXT, CSV, CSS, JS) erstellt und bearbeitet werden. F&uuml;r den Dateinamen der zu erstellenden Datei ist nur das englische Alphabet, Zahlen und der Unterstrich (a-zA-Z0-9_) erlaubt. F&uuml;r eine PHP-Datei mit speziellen Arbeitsaufgaben sollte vorzugsweise der Dateiname <strong>various_task.php</strong> gew&auml;hlt werden. Voraussetzung f&uuml;r die Erstellung der neuen Datei sind ausreichende Schreibrechte im aktuellen Verzeichnis erforderlich. Es k&ouml;nnen nacheinander mehrere Text-Dateien erstellt werden, aber es wird nur zur letzten erstellten Datei ein Link zum Aufruf und zur Bearbeitung eingef&uuml;gt (siehe auch: " . $obelix_hyperlink_array[9] . ", " . $obelix_hyperlink_array[10] . ", " . $obelix_hyperlink_array[4] . ", " . $obelix_hyperlink_array[5] . ").<br><br><strong>Hinweis: </strong>Werden einige Zeichen nicht korrekt angezeigt, so sind im Obelix-Editor nur das englische Alphabet und einige typische Sonderzeichen (ASCII-Zeichen 32 bis 126) zu benutzen. Dies kann vorkommen, wenn Server und Arbeitsrechner (Internet-Browser) sehr unterschiedliche Zeichensatztabellen (charset, aktuelle Server-Zeichensatztabelle: <strong>" . @ini_get('default_charset') . "</strong>) verwenden."; // Text des Hauptinhaltes
$create_file_file_type_array=array('txt', 'php', 'htm', 'html', 'csv', 'css', 'js'); // Array mit den erstellbaren Dateitypen (Textdateien)
$create_file_file_type_selected_array=array(' selected', '', '', '', '', '', ''); // Array mit dem aktuell ausgewaehlten Dateityp
$create_file_name_work_directory="aktuelles Arbeitsverzeichnis auf dem Server"; // Meldung, Information an den Benutzer
$create_file_input_field_name="Datei-Name:"; // Meldung, Information an den Benutzer
$create_file_link_name_load_file="Datei aufrufen"; // Meldung, Information an den Benutzer
$create_file_link_name_load_editor="Datei bearbeiten"; // Meldung, Information an den Benutzer
$create_file_button_name="DATEI ANLEGEN"; // Beschriftung des Submit-Buttons
$create_file_new_content_default="THIS IS A ERASABLE TEXT"; // Meldung, Information an den Benutzer
$create_file_file_access=0644; // Zugriffsrechte der erstellten Dateien, muss identisch mit $hyperlink_listing_file_access sein; moegliche Werte: 0666, 0664, 0644 (default), 0640, 0600
$create_file_messages_file_to_exist="Hinweis: Die Datei existiert bereits!"; // Meldung, Information an den Benutzer
$create_file_messages_file_can_not_open="Hinweis: Die Datei konnte nicht ge&ouml;ffnet werden! Dateiname:"; // Meldung, Information an den Benutzer
$create_file_messages_file_not_create="Hinweis:  Die Datei konnte nicht angelegt werden! Dateiname:"; // Meldung, Information an den Benutzer
$create_file_messages_directoy_not_writable="Hinweis: Das aktuelle Verzeichnis ist nicht beschreibbar!"; // Meldung, Information an den Benutzer
$create_file_messages_not_permitted_char="Hinweis: Es ist nur das englische Alphabet, Zahlen und der Unterstrich (a-zA-Z0-9_) erlaubt."; // Meldung, Information an den Benutzer
$create_file_title_example_1 = "Datei: PHP- und HTML-Grundger&uuml;st"; // Meldung, Information an den Benutzer
$create_file_title_example_2 = "Datei: various_task.php (obelix.php ins &uuml;bergeordnete Verzeichnis kopieren)"; // Meldung, Information an den Benutzer
$create_file_title_example_3 = "Datei: info_php_module.php (PHP-Module anzeigen)"; // Meldung, Information an den Benutzer
$create_file_title_example_4 = "Datei: hyperlink_listing.csv (Liste mit Internet-Links, Hauptmen&uuml; -&gt; " . $obelix_hyperlink_array[5] . ")"; // Meldung, Information an den Benutzer
$create_file_note_1_example_1 = "Hinweis: F&uuml;r eine reine HTML-Datei ist der PHP-Anteil zu entfernen (Dateiendung: php -&gt; html)."; // Meldung, Information an den Benutzer
$create_file_note_1_example_2 = "Hinweis: Datei wurde ins Zielverzeichnis kopiert!"; // Meldung, Information an den Benutzer
$create_file_note_2_example_2 = "Hinweis: Datei konnte nicht erstellt werden!"; // Meldung, Information an den Benutzer
$create_file_note_3_example_2 = "Hinweis: keine Schreiberechtigung!"; // Meldung, Information an den Benutzer
$create_file_note_1_example_4 = "Hinweis - Syntax der CSV-Datei &raquo;hyperlink_listing.csv&laquo;:<br>https://www.domainname.de | beschreibender Text des Links"; // Meldung, Information an den Benutzer
$create_file_content_example_4 = "https://db-ip.com <strong> | </strong> GEO-Targeting\n<br>https://myip.is <strong> | </strong> eigene IP-Adresse\n<br>https://panopticlick.eff.org/ <strong> | </strong> Panopticlick - im Internet ist jeder einzigartig und auch erkennbar\n<br>https://www.openstreetmap.org <strong> | </strong> Open-Street-Map\n<br>https://www.startpage.com <strong> | </strong> StartPage - StartPage benutzt google, aber liefert keine Daten an google\n<br>https://www.qwant.com <strong> | </strong> QWANT eine franz&ouml;sische Suchmaschine - www.qwant.com, www.qwant.fr, qwant.com<br>https://getvideo.org/en/ <strong> | </strong> Download von Youtube-Videos (Hinweis: Im Hintergrund der russischen Webseite laufen mehr oder wenige notwendige Skripte!)\n<br>https://yt5s.com/en11 <strong> | </strong> Download von Youtube-Videos (Hinweis: Diese Webseite kommt aus San Francisco - USA!)"; // Meldung, Information an den Benutzer

// Bereich: Variablen der Host-Intrusion-Detection-Seite
$host_intrusion_detection_main_head_line="" . $obelix_hyperlink_array[19] . " - IDS-System zur Erstellung von Pr&uuml;fsummen (Einbruchserkennung)"; // Ueberschrift des Hauptinhaltes
$host_intrusion_detection_current_directory_array = explode('/',getcwd());
$host_intrusion_detection_current_directory=end($host_intrusion_detection_current_directory_array); // aktuelles Verzeichnis
$host_intrusion_detection_main_content="Das Host-Intrusion-Detection-System erstellt eine Datenbank mit Pr&uuml;fsummen, um autorisierte und nicht-autorisierte Ver&auml;nderungen an erreichbaren Webseiten (siehe auch: " . $obelix_hyperlink_array[4] . ", " . $obelix_hyperlink_array[10] . ") festzustellen. Es k&ouml;nnen bis zu 4 Hauptverzeichnisse (Webseiten) oder 1 Hauptverzeichnis und 3 Unterverzeichnisse (Subdirectories) des eingetragenen Hauptverzeichnis oder alle weiteren zul&auml;ssige Kombinationen (Hauptverzeichnisse, Unterverzeichnisse) &uuml;berwacht werden. Bei dynamischen Webseiten k&ouml;nnen im normalen Betrieb (Aufruf der Webseite durch Webseitenbesucher) Verzeichnisse, Dateien neu angelegt, ver&auml;ndert oder gel&ouml;scht werden. Um Fehlalarme auszuschlie&szlig;en, sollten zeitweise (tempor&auml;r) existierenden Verzeichnisse und Dateien von einer Pr&uuml;fung auf ihr aktuelles Vorhandensein ausgeschlossen werden (siehe unten: Tabelle &uuml;ber der Checkbox).<br><br>Bei aktivierter Checkbox ist die Syntax der auszuschlie&szlig;enden Verzeichnisse und Dateien vor der Eintragung in die IDS-Datenbank zu &uuml;berpr&uuml;fen. Bei den Eintragungen in die IDS-Datenbank wird zwischen Gro&szlig;- und Kleinschreibung unterschieden. Diese vorgenannten Verzeichnisse und Dateien k&ouml;nnen auch erst nach einen Testlauf hier eingetragen werden. Anschlie&szlig;end kann die IDS-Datenbank mit den ermittelten und gepr&uuml;ften Formulareintragungen neu erstellt werden (siehe unten: Radio-Button). In die Datenbanken werden nur vollst&auml;ndige relative Verzeichnispfade, die mit Punkt Slash (./) oder mit Punkt Punkt Slash (../, ../../, [...]) beginnen, aufgenommen.<br><br>Um das aktuelle Verzeichnis mit diesem PHP-Skript und seinen Unterverzeichnissen in eine IDS-Datenbank aufzunehmen, ist der Verzeichnispfad wie folgt einzutragen: ../" . $host_intrusion_detection_current_directory . "<br><br>Nach einem Download der IDS-Danbank (Textformat) kann es vorkommen, dass einige Zeichen nicht korrekt dargestellt werden. Dies kann vorkommen, wenn die Textkodierung der Datenbank nicht kompatibel mit der Textkodierung des aufgerufenen Programms (Internet-Borwser) &uuml;bereinstimmt. In diesem Fall sollte man sich ein wenig mit der Konvertierung von Textkodierungen befassen.<br><br><strong>Hinweis:</strong> Die in der IDS-Daten gespeicherten Verzeichnis- und Dateipfade orientieren sich an den aktuellen Speicherort des PHP-Skriptes. Bei einer Verlagerung des PHP-Skriptes und der zugeh&ouml;rigen IDS-Datenbank, wird das Host-Intrusion-Detection-System funktionsunt&uuml;chtig. Weiterhin ist es durchaus m&ouml;glich und ratsam, eine umfangreiche IDS-Datenbank miit einem externen Programm zu analysieren. Voraussetzung f&uuml;r alle Aktivit&auml;ten sind ausreichende Zugriffsberechtigungen."; // Text des Hauptinhaltes
$host_intrusion_detection_current_work_directory_title="aktuelles Arbeitsverzeichnis:"; // Meldung, Information an den Benutzer
$host_intrusion_detection_title_directory_depth="Verzeichnistiefe (1-12):"; // Meldung, Information an den Benutzer
$host_intrusion_detection_directory_default_depth=8; // Vorgabe der Verzeichnistiefe, 1 ... 12, 8 (default)
$host_intrusion_detection_ids_monitoring_directory_title="Verzeichnispfad der zu &uuml;berwachenden Webseite:"; // Meldung, Information an den Benutzer
$host_intrusion_detection_current_database_title="Aktuelle IDS-Datenbank"; // Meldung, Information an den Benutzer
$host_intrusion_detection_hyperlink_title_download="Download"; // Meldung, Information an den Benutzer
$host_intrusion_detection_textarea_title="Erl&auml;uterungen zur IDS-Datenbank:"; // Meldung, Information an den Benutzer
$host_intrusion_detection_ids_options_title="IDS-Optionen"; // Meldung, Information an den Benutzer
$host_intrusion_detection_database_update_title="aktuelle IDS-Datenbank aktualsieren"; // Meldung, Information an den Benutzer
$host_intrusion_detection_database_upgrade_title="aktuelle IDS-Datenbank neu erstellen"; // Meldung, Information an den Benutzer
$host_intrusion_detection_current_database_delete_title="aktuelle IDS-Datenbank l&ouml;schen"; // Meldung, Information an den Benutzer
$host_intrusion_detection_short_help_title="Kurzhilfe"; // Meldung, Information an den Benutzer
$host_intrusion_detection_short_help_content="Der wichtigste Eintrag ist der relative Verzeichnispfad, der zu der &uuml;berwachenden Webseite f&uuml;hrt. Ausgangspunkt f&uuml;r den Verzeichnispfad ist der aktuelle Speicherort (siehe: aktuelles Arbeitsverzeichnis) dieses PHP-Skriptes. Bevor eine IDS-Datenbank aktualisiert wird, sollte vorher unbedingt das bereits gespeicherte Ergebnis der letzten Pr&uuml;fung aufgerufen werden.<br><br>Beispiel f&uuml;r ein Verzeichnispfad: ../example<br><br><strong>Schritt 1:</strong> Anzeige des Ergebnisses der letzten &Uuml;berpr&uuml;fung.<br><strong>Schritt 2:</strong> Aktualisierung der gew&auml;hlten IDS-Datenbank.<br><br><strong>Hinweis:</strong> Schritt 2, Aktualisierung der IDS-Datenbank, ist auch zust&auml;ndig f&uuml;r die Neuerstellung oder L&ouml;schung (" . $host_intrusion_detection_ids_options_title . ") der gew&auml;hlten Datenbank. Werden nach der Erstellung einer Datenbank Ausnahmen festgelegt, so werden diese Dateien in der Tabelle (Feld: MD5-Status ...) mit dem Status <strong>ausgeschlossen</strong> gekennzeichnet."; // Meldung, Information an den Benutzer
$host_intrusion_detection_exception_main_titel="Ausnahmen f&uuml;r das Host-Intrusion-Detection-System"; // Meldung, Information an den Benutzer
$host_intrusion_detection_directory_exception_titel="Verzeichnisse unterhalb des Hauptverzeichnisses"; // Meldung, Information an den Benutzer
$host_intrusion_detection_file_exception_titel="Dateien unterhalb des Hauptverzeichnisses"; // Meldung, Information an den Benutzer
$host_Intrusion_detection_file_exists_no_check_text="Die hier eingetragenen Verzeichnisse und Dateien <strong>nicht</strong> auf ihr Vorhandensein pr&uuml;fen."; // Meldung, Information an den Benutzer
$host_intrusion_detection_create_database_button_name="NEUE HOST-INTRUSION-DETECTION-DATENBANK ANLEGEN"; // Beschriftung des Submit-Buttons
$host_intrusion_detection_display_database_button_name="SCHRITT 1: HOST-INTRUSION-DETECTION-DATENBANK ANZEIGEN"; // Beschriftung des Submit-Buttons
$host_intrusion_detection_update_database_button_name="SCHRITT 2: HOST-INTRUSION-DETECTION-DATENBANK AKTUALISIEREN"; // Beschriftung des Submit-Buttons
$host_intrusion_detection_directory_access=0755; // Zugriffsrechte des Verzeichnisses mit den Dateien; moegliche Werte: 0777, 0775, 0755 (default), 0750, 0744, 0700
$host_intrusion_detection_file_access=0644; // Zugriffsrechte der erstellten Dateien; moegliche Werte: 0666, 0644 (default), 0640, 0600
$host_intrusion_detection_general_survey_titles_array = array('Hauptverzeichnis:',
                                                              'Datenbank erstellt am (Y-M-D):',
                                                              'Uhrzeit (h:m:s):',
                                                              'Letzte &Uuml;berpr&uuml;fung (Y-M-D):',
                                                              'Uhrzeit (h:m:s):',
                                                              'Anzahl der Dateien zum Zeitpunkt der Erstellung',
                                                              'Anzahl der Dateien zum Zeitpunkt der letzten &Uuml;berpr&uuml;fung',
                                                              'Anzahl der Verzeichnisse:',
                                                              'Anzahl der Dateien:',
                                                              'Anmerkung:'); // Array mit den Feldnamen der Uebersichtstablle
$host_intrusion_detection_result_table_titles_array = array('Lfd.-Nr:',
                                                            'Verzeichnis',
                                                            'Eigent&uuml;mer 1',
                                                            'Eigent&uuml;mer 2',
                                                            'Gruppe 1',
                                                            'Gruppe 2',
                                                            'Zugriffsrecht 1',
                                                            'Zugriffsrecht 2',
                                                            '&Auml;nderungszeit 1',
                                                            '&Auml;nderungszeit 2',
                                                            'Verzeichnis-Anzahl 1',
                                                            'Verzeichnis-Anzahl 2',
                                                            'Datei-Anzahl 1',
                                                            'Datei-Anzahl 2',
                                                            'MD5-Status des Verzeichnisses',
                                                            'Datei',
                                                            'Eigent&uuml;mer 1',
                                                            'Eigent&uuml;mer 2',
                                                            'Gruppe 1',
                                                            'Gruppe 2',
                                                            'Zugriffsrecht 1',
                                                            'Zugriffsrecht 2',
                                                            'Modifikationszeit 1',
                                                            'Modifikationszeit 2',
                                                            'Dateigr&ouml;&szlig;e 1',
                                                            'Dateigr&ouml;&szlig;e 2',
                                                            'MD5-Status der Datei'); // Array mit den Feldnamen der Ergenistablle
$host_intrusion_detection_md5_status_note_array = array('gel&ouml;scht',
                                                        'unver&auml;ndert',
                                                        'ge&auml;ndert',
                                                        'hinzugef&uuml;gt',
                                                        'ausgeschlossen'); // Array mit den Bezeichnungen des MD5-Status
$host_intrusion_detection_messages_modification_note="Hinweis: Es wurden &Auml;nderungen innerhalb des zu &uuml;berpr&uuml;fenden Hauptverzeichnisses festgestellt."; // Meldung, Information an den Benutzer
$host_intrusion_detection_messages_table_comment="Die 1 an den nachfolgenden Spaltentitel kennzeichnet den Wert zum Zeitpunkt der Erstellung der Datenbank (Eigent&uuml;mer 1, Zugriffsrecht 1, ...) und die 2 kennzeichnet den Wert zum Zeitpunkt der letzten &Uuml;berpr&uuml;fung. Der MD5-Status (unver&auml;ndert, ge&auml;ndert, gel&ouml;scht oder hinzugef&uuml;gt) ist das Ergebnis einer Pr&uuml;fung. Bei Verzeichnisse wird das Zugriffsrecht, der Zeitstempel und die Anzahl der enthaltenen Dateien und bei Dateien das Zugriffsrecht, der Zeitstempel und die Dateigr&ouml;&szlig;e &uuml;berpr&uuml;ft. Die &Auml;nderungszeit eines Verzeichnisses &auml;ndert sich, sobald sich ihre Inode-Daten &auml;ndern (Rechte, Eigent&uuml;mer, Gruppe oder andere Metadaten). Die Modifikationszeit gibt das Datum und die Uhrzeit der letzten &Auml;nderung des Inhaltes einer Datei an."; // Meldung, Information an den Benutzer
$host_intrusion_detection_messages_database_not_found="<strong>Hinweis:</strong> Es muss erst eine IDS-Datenbank erstellt werden!"; // Meldung, Information an den Benutzer
$host_intrusion_detection_messages_create_directory_not_successful="Hinweis: Das Verzeichnis f&uuml;r die IDS-Datenbank konnte nicht erstellt werden!<br>Grund: M&ouml;glicherweise besitzen Sie unzureichende Zugriffsrechte."; // Meldung, Information an den Benutzer
$host_intrusion_detection_messages_create_ids_file_not_successful="Hinweis: Die Datei f&uuml;r die IDS-Datenbank konnte nicht erstellt werden!<br>Grund: M&ouml;glicherweise besitzen Sie unzureichende Zugriffsrechte."; // Meldung, Information an den Benutzer
$host_intrusion_detection_messages_create_configuration_file_not_successful="Hinweis: Die Datei mit Konfigurations-Datenbank konnte nicht erstellt werden!<br>Grund: M&ouml;glicherweise besitzen Sie unzureichende Zugriffsrechte."; // Meldung, Information an den Benutzer
$host_intrusion_detection_messages_create_report_file_not_successful="Hinweis: Die Datei f&uuml;r die Datenbank der &Uuml;bersicht mit den Verzeichnissen und Dateien konnte nicht erstellt werden!<br>Grund: M&ouml;glicherweise besitzen Sie unzureichende Zugriffsrechte."; // Meldung, Information an den Benutzer
$host_intrusion_detection_messages_create_directory_exclusion_not_successful="Hinweis: Die Datei f&uuml;r die Datenbank der auszuschlie&szlig;enden Verzeichnisse konnte nicht erstellt werden!<br>Grund: M&ouml;glicherweise besitzen Sie unzureichende Zugriffsrechte."; // Meldung, Information an den Benutzer
$host_intrusion_detection_messages_create_file_exclusion_not_successful="Hinweis: Die Datei f&uuml;r die Datenbank der auszuschlie&szlig;enden Dateien konnte nicht erstellt werden!<br>Grund: M&ouml;glicherweise besitzen Sie unzureichende Zugriffsrechte."; // Meldung, Information an den Benutzer
$host_intrusion_detection_messages_monitoring_directory_not_readable="Hinweis: Das Hauptverzeichnis der Webseite ist nicht lesbarbar!<br>Grund: M&ouml;glicherweise besitzen Sie unzureichende Zugriffsrechte."; // Meldung, Information an den Benutzer
$host_intrusion_detection_messages_monitoring_directory_not_found="Hinweis: Das Hauptverzeichnis der Webseite wurde nicht gefunden oder es wurde kein Verzeichnispfad eingetragen!"; // Meldung, Information an den Benutzer
$host_intrusion_detection_messages_directory_not_found="Hinweis: Das Verzeichnis f&uuml;r die IDS-Datenbank wurde nicht gefunden!"; // Meldung, Information an den Benutzer
$host_intrusion_detection_messages_file_not_readable="Hinweis: Die Datei mit der IDS-Datenbank ist nicht lesbar!<br>Grund: M&ouml;glicherweise besitzen Sie unzureichende Zugriffsrechte."; // Meldung, Information an den Benutzer
$host_intrusion_detection_messages_file_not_writable="Hinweis: Die Datei mit der IDS-Datenbank ist nicht beschreibbar!<br>Grund: M&ouml;glicherweise besitzen Sie unzureichende Zugriffsrechte."; // Meldung, Information an den Benutzer
$host_intrusion_detection_messages_file_not_found="Hinweis: Die Datei mit der IDS-Datenbank wurde nicht gefunden!"; // Meldung, Information an den Benutzer
$host_intrusion_detection_messages_directory_not_writable="Hinweis: Das IDS-Verzeichnis ist nicht beschreibbar oder ein oder einige System-Arrays sind besch&auml;digt!"; // Meldung, Information an den Benutzer
$host_intrusion_detection_messages_database_maximum_number="Hinweis: Es k&ouml;nnen keine neue IDS-Datenbanken erstellt werden! <br>Grund: Die maximale Anzahl der Datenbanken ist begrenzt."; // Meldung, Information an den Benutzer
$host_intrusion_detection_messages_updating_ids_file_successful="Hinweis: Die Dateien f&uuml;r die IDS-Datenbank wurden aktualisiert!"; // Meldung, Information an den Benutzer
$host_intrusion_detection_messages_updating_ids_file_not_successful="Hinweis: Die Dateien f&uuml;r die IDS-Datenbank konnten nicht oder nur teilweise aktualisiert werden!"; // Meldung, Information an den Benutzer
$host_intrusion_detection_messages_rewrite_ids_file_successful="Hinweis: Die Dateien f&uuml;r die IDS-Datenbank wurden neu erstellt!"; // Meldung, Information an den Benutzer
$host_intrusion_detection_messages_rewrite_ids_file_not_successful="Hinweis: Die Dateien f&uuml;r die IDS-Datenbank konnten nicht oder nur teilweise neu erstellt werden!"; // Meldung, Information an den Benutzer
$host_intrusion_detection_messages_not_data_records_found="Hinweis: Die ausgew&auml;hlte IDS-Datenbank enth&auml;lt keine Datens&auml;tze!"; // Meldung, Information an den Benutzer
$host_intrusion_detection_messages_database_delete_successful="Hinweis: Die Dateien mit der ausgew&auml;hlten IDS-Datenbank wurden gel&ouml;scht!"; // Meldung, Information an den Benutzer
$host_intrusion_detection_messages_database_delete_not_successful="Hinweis: Die Dateien mit der ausgew&auml;hlte IDS-Datenbank konnte nicht oder nur teilweise gel&ouml;scht werden!"; // Meldung, Information an den Benutzer
$host_intrusion_detection_messages_directory_exclusion_delete_not_successful="Hinweis: Die Datei mit den auszuschlie&szlig;enden Verzeichnissen der ausgew&auml;hlte IDS-Datenbank konnte nicht gel&ouml;scht werden!"; // Meldung, Information an den Benutzer
$host_intrusion_detection_messages_file_exclusion_delete_not_successful="Hinweis: Die Datei mit den auszuschlie&szlig;enden Dateien der ausgew&auml;hlte IDS-Datenbank konnte nicht gel&ouml;scht werden!"; // Meldung, Information an den Benutzer
$host_intrusion_detection_messages_database_display_not_successful="Hinweis: Der Inhalt der IDS-Datenbank konnte nicht ermittelt werden!"; // Meldung, Information an den Benutzer
$host_intrusion_detection_create_database_returncode_messages_array = array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                                                            '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                                            'HINWEIS: EINE DATEI MIT EINER DATENBANK (RETURNCODE 2) KONNTE NICHT ERSTELLT WERDEN!'); // Array mit Meldungen, Informationen an den Benutzer
$host_intrusion_detection_ids_database_returncode_messages_array = array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                                                         '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                                         'HINWEIS: ES BESTEHT F&Uuml;R DIE DATEI MIT DER IDS-DATENBANK (RETURNCODE 2) KEIN SCHREIBRECHT ODER DIE DATEI WURDE NICHT GEFUNDEN!',
                                                                         'HINWEIS: DIE DATEI MIT DER IDS-DATENBANK (RETURNCODE 3) IST BESCH&Auml;DIGT (ANZAHL DER DATENS&Auml;TZE)!',
                                                                         'HINWEIS: EIN DATENSATZ INNERHALB DER DATEI MIT DER IDS-DATENBANK (RETURNCODE 4) IST BESCH&Auml;DIGT (ANZAHL DER FELDER)!',
                                                                         'HINWEIS: DIE DATEI MIT DER IDS-DATENBANK (RETURNCODE 5) KONNTE NICHT GE&Ouml;FFNET WERDEN!'); // Array mit Meldungen, Informationen an den Benutzer
$host_intrusion_detection_configuration_database_returncode_messages_array = array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                                                                   '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                                                   'HINWEIS: ES BESTEHT F&Uuml;R DIE DATEI MIT DER KONFIGURATIONS-DATENBANK (RETURNCODE 2) KEIN SCHREIBRECHT ODER DIE DATEI WURDE NICHT GEFUNDEN!',
                                                                                   'HINWEIS: DIE DATEI MIT DER KONFIGURATIONS-DATENBANK (RETURNCODE 3) IST BESCH&Auml;DIGT (ANZAHL DER FELDER ODER DATENS&Auml;TZE)!',
                                                                                   'HINWEIS: DIE DATEI MIT DER KONFIGURATIONS-DATENBANK (RETURNCODE 4) KONNTE NICHT GE&Ouml;FFNET WERDEN!'); // Array mit Meldungen, Informationen an den Benutzer
$host_intrusion_detection_report_database_returncode_messages_array = array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                                                            '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                                            'HINWEIS: ES BESTEHT F&Uuml;R DIE DATEI MIT DER REPORT-DATENBANK (RETURNCODE 2) KEIN SCHREIBRECHT ODER DIE DATEI WURDE NICHT GEFUNDEN!',
                                                                            'HINWEIS: DIE DATEI MIT DER &Uuml;BERSICHT VON DEN VERZEICHNISSEN UND DATEIEN (RETURNCODE 3) IST BESCH&Auml;DIGT (ANZAHL DER FELDER ODER DATENS&Auml;TZE)!',
                                                                            'HINWEIS: DIE DATEI MIT DER &Uuml;BERSICHT VON DEN VERZEICHNISSEN UND DATEIEN (RETURNCODE 4) KONNTE NICHT GE&Ouml;FFNET WERDEN!'); // Array mit Meldungen, Informationen an den Benutzer
$host_intrusion_detection_exclusion_directory_returncode_messages_array = array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                                                                '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                                                'HINWEIS: DIE DATEI MIT DEN AUSZUSCHLIESSENDEN VERZEICHNISSEN (RETURNCODE 2) IST BESCH&Auml;DIGT (ANZAHL DER DATENS&Auml;TZE)!',
                                                                                'HINWEIS: EIN DATENSATZ INNERHALB DER DATEI MIT DEN AUSZUSCHLIESSENDEN VERZEICHNISSEN (RETURNCODE 3) IST BESCH&Auml;DIGT (ANZAHL DER FELDER)!',
                                                                                'HINWEIS: DIE DATEI MIT DEN AUSZUSCHLIESSENDEN VERZEICHNISSEN (RETURNCODE 4) KONNTE NICHT GE&Ouml;FFNET WERDEN!'); // Array mit Meldungen, Informationen an den Benutzer
$host_intrusion_detection_exclusion_file_returncode_messages_array = array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                                                           '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                                           'HINWEIS: DIE DATEI MIT DEN AUSZUSCHLIESSENDEN DATEIEN (RETURNCODE 2) IST BESCH&Auml;DIGT (ANZAHL DER DATENS&Auml;TZE)!',
                                                                           'HINWEIS: EIN DATENSATZ INNERHALB DER DATEI MIT DEN AUSZUSCHLIESSENDEN DATEIEN (RETURNCODE 3) IST BESCH&Auml;DIGT (ANZAHL DER FELDER)!',
                                                                           'HINWEIS: DIE DATEI MIT DEN AUSZUSCHLIESSENDEN DATEIEN (RETURNCODE 4) KONNTE NICHT GE&Ouml;FFNET WERDEN!'); // Array mit Meldungen, Informationen an den Benutzer
$host_intrusion_detection_database_check_returncode_messages_array = array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                                                           '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                                           'HINWEIS: DIE ANZAHL DER FELDER IN DER ERSTEN ZEILE DER DATENBANK IST FEHLERBEHAFTET (RETURNCODE 2)! DATEI-PFAD: ',
                                                                           'HINWEIS: DIE ANZAHL DER FELDER IN DER ZWEITEN ZEILE DER DATENBANK IST FEHLERBEHAFTET (RETURNCODE 3)! DATEI-PFAD: ',
                                                                           'HINWEIS: DIE INTERNEN FELDNAMEN IN DER ERSTEN ZEILE DER DATENBANK STIMMEM NICHT MIT DEN VORGABEN DES PHP-SKRIPTES &Uuml;BEREIN (RETURNCODE 4)! DATEI-PFAD: ',
                                                                           'HINWEIS: DIE ANGABEN F&Uuml;R DIE  MAXIMALE STRINGL&Auml;NGE IN DER ZWEITEN ZEILE DER DATENBANK IST BESCH&Auml;DIGT (RETURNCODE 5)! DATEI-PFAD: ',
                                                                           'HINWEIS: DIE ANGABEN F&Uuml;R DIE  MAXIMALE STRINGL&Auml;NGE IN DER ZWEITEN ZEILE DER DATENBANK STIMMEM NICHT MIT DEN VORGABEN DES PHP-SKRIPTES &Uuml;BEREIN (RETURNCODE 6)! DATEI-PFAD: '); // Array mit Meldungen, Informationen an den Benutzer

// Bereich: Variablen der Move-Obelix-Seite
$move_obelix_main_head_line="" . $obelix_hyperlink_array[20] . " - PHP-Skript in ein anderes Arbeits-Verzeichnis kopieren"; // Ueberschrift des Hauptinhaltes
$move_obelix_main_content="Auf dieser Seite k&ouml;nnen Verzeichnisse gesucht werden, in den das PHP-Skript Obelix kopiert werden kann. Nach der Erstellung der Tabelle mit den gefundenen Verzeichnissen, wird neben dem vollst&auml;ndigen Verzeichnispfad auch die &Auml;nderungszeit der Inode-Daten (&Auml;nderungszeit der Rechte, Eigent&uuml;mer, Gruppe oder anderer Metadaten des Inodes) des Verzeichnisses in die Tabelle eingetragen. Wurden nach der Erstellung eines Verzeichnisses keine Inode-Daten ge&auml;ndert, so ist die &Auml;nderungszeit auch gleichzeitig die Erstellungszeit eines Verzeichnisses.<br><br>Bei der freien Eintragung des Startverzeichnisses, sind nur relative Verzeichnispfade zul&auml;ssig. Die relativen Verzeichnispfade fangen immer mit der Zeichenkette ./, ../, ../../ usw. an.<br><br>Verzeichnisse mit Schreibrecht werden in der Tabelle automatisch durch ein Radiobutton gekennzeichnet (siehe auch: " . $obelix_hyperlink_array[4] . ", " . $obelix_hyperlink_array[10] . ", " . $obelix_hyperlink_array[18] . "). Das PHP-Skript Obelix kann mehrmals in verschiedene Verzeichnisse kopiert werden, aber es wird nur zum letzten Kopiervorgang ein Link zum Aufruf des PHP-Skriptes auf dieser Seite eingef&uuml;gt.<br><br><strong>Hinweis:</strong> Befindet sich eine gleichnamige Datei im Zielverzeichnis so wird diese beim Kopiervorgang OHNE Abfrage &uuml;berschrieben!"; // Text des Hauptinhaltes
$move_obelix_button_name_1="VERZEICHNISSE SUCHEN"; // Beschriftung des Submit-Buttons
$move_obelix_button_name_2="OBELIX INS GEW&Auml;HLTE ZIELVERZEICHNIS KOPIEREN"; // Beschriftung des Submit-Buttons
$move_obelix_title_start_directory="Ausgangsverzeichnis:"; // Meldung, Information an den Benutzer
$move_obelix_title_work_directory="aktuelles Arbeitsverzeichnis:"; // Meldung, Information an den Benutzer
$move_obelix_title_current_directory_depth="aktuelle Verzeichnistiefe:"; // Meldung, Information an den Benutzer
$move_obelix_title_hyperlink="Link zum kopierten PHP-Skript:"; // Meldung, Information an den Benutzer
$move_obelix_directory_default_depth=3; // Vorgabe der Verzeichnistiefe, 1 ... 9, 3 (default)
$move_obelix_title_choice_start_directory="Startverzeichnis ausw&auml;hlen"; // Meldung, Information an den Benutzer
$move_obelix_title_current_directory="aktuelles Verzeichnis (./)"; // Meldung, Information an den Benutzer
$move_obelix_title_directory_level_one_higher="eine Verzeichnisebene h&ouml;her (../)"; // Meldung, Information an den Benutzer
$move_obelix_title_directory_level_two_higher="zwei Verzeichnisebene h&ouml;her (../../)"; // Meldung, Information an den Benutzer
$move_obelix_title_directory_level_free_choice="freie Wahl des Startverzeichnissses"; // Meldung, Information an den Benutzer
$move_obelix_title_directory_level_change="Startverzeichnis hier eingeben:"; // Meldung, Information an den Benutzer
$move_obelix_directory_level_change_example="Beispiel: ../../../tmp/install/"; // Meldung, Information an den Benutzer
$move_obelix_directory_level_change_note="<strong>Hinweis:</strong> Bezugspunkt f&uuml;r das Startverzeichnis ist das Verzeichnis in dem OBELIX abgelegt wurde."; // Meldung, Information an den Benutzer
$move_obelix_title_change_directory_depth="Verzeichnistiefe (1-9):"; // Meldung, Information an den Benutzer
$move_obelix_table_result_title_1="Verzeichnisname"; // Meldung, Information an den Benutzer
$move_obelix_table_result_title_2="&Auml;nderungszeit"; // Meldung, Information an den Benutzer
$move_obelix_table_result_title_3="Schreibrecht"; // Meldung, Information an den Benutzer
$move_obelix_title_footer_summary_directory="Verzeichnisse:"; // Meldung, Information an den Benutzer
$move_obelix_returncode_messages_array = array('HINWEIS: ES IST EIN SCHWERWIEGENDER FEHLER (RETURNCODE 0) AUFGETRETEN!',
                                               'HINWEIS: DAS PHP-SKRIPT OBELIX WURDE INS ZIELVERZEICHNIS KOPIERT!',
                                               'HINWEIS: DAS PHP-SKRIPT OBELIX (RETURNCODE 2) WURDE NICHT GEFUNDEN!',
                                               'HINWEIS: KEINE SCHREIBBERECHTIGUNG ODER DAS GEW&Auml;HLTE ZIELVERZEICHNIS (RETURNCODE 3) IST KEIN VERZEICHNIS!',
                                               'HINWEIS: DER KOPIERVORGANG IN DAS ZIELVERZEICHNIS (RETURNCODE 4) KONNTE NICHT DURCHGEF&Uuml;HRT WERDEN!');
$move_obelix_directory_change_messages_not_successful="Hinweis: Der f&uuml;r &raquo;MOVE-OBELIX&laquo; notwendige Wechsel ins &uuml;bergeordnete Verzeichnis konnte nicht durchgef&uuml;hrt werden!<br>Grund: M&ouml;glicherweise wurde das angegebene  Verzeichnis nicht gefunden oder Sie besitzen unzureichende Zugriffsrechte."; // Meldung, Information an den Benutzer
$move_obelix_file_copy_messages_no_field_selected="Hinweis: Es wurde kein Zielverzeichnis ausgew&auml;hlt!"; // Meldung, Information an den Benutzer

// Bereich: Variablen der Color-Palette-Seite
$color_palette_main_head_line="" . $obelix_hyperlink_array[21] . " - Extrahierung der Farben eines Bildes"; // Ueberschrift des Hauptinhaltes
$color_palette_upload_image_max_mega_byte=4; // maximale Dateigroesze in Megabyte (Default: 4 MByte)
$color_palette_upload_image_max_size=$color_palette_upload_image_max_mega_byte * 1024 * 1024; // maximale Dateigroesze in Byte (Default: 100 * 1024 * 1024 Byte)
$color_palette_main_content="Auf dieser Seite kann aus einer hochgeladenen Bilddatei (Datei-Typ: JPEG, GIF, PNG, MIME-Typ: image/jpeg, image/gif, image/png) eine Farbpalette extrahiert werden (siehe auch: " . $obelix_hyperlink_array[10] . ", " . $obelix_hyperlink_array[9] . ", " . $obelix_hyperlink_array[16] . ", " . $obelix_hyperlink_array[4] . "). Als Schriftarten und Schriftgr&ouml;&szlig;en stehen den Bildbearbeitungsfunktionen nur die in PHP eingebauten Schriftarten zur Verf&uuml;gung. Daher werden nur Dateinamen die aus dem englischen Alphabet (a-zA-Z), den Zahlen (0-9), den Unterstrich (_), dem Minuszeichen (-), dem Punkt (.) oder dem Leerzeichen bestehen vollst&auml;ndig von Color-Palette unterst&uuml;tzt.<br><br>Die extrahierte Farbpalette des Hauptbildes einer Webseite kann f&uuml;r das Farbdesign (Textfarben, Farben von Linien und andere Design-Elemente) hilfreich sein. Diese ausgew&auml;hlten Farben sind h&auml;ufig nur noch in der Farbintensit&auml;t oder Helligkeit &uuml;ber entsprechende Programme anzupassen (siehe auch: INTERNET - harmonische Farblehre).<br><br><strong>Hinweis:</strong> Das Bild mit der Farbpalette kann &uuml;ber das Kontextmen&uuml; der rechten Maustaste auf den lokalen Rechner &uuml;bertragen werden. Die maximale Dateigr&ouml;&szlig;e der hochgeladenen Bild-Datei sollte " . $color_palette_upload_image_max_mega_byte . " MByte nicht &uuml;berschreiten."; // Text des Hauptinhaltes
$color_palette_upload_input_field_title="Bilddatei (maximal " . $color_palette_upload_image_max_mega_byte . "MByte):"; // Meldung, Information an den Benutzer
$color_palette_field_title_1="die h&auml;ufigsten Farben extrahieren"; // Meldung, Information an den Benutzer
$color_palette_field_title_2="die am wenigsten vorkommenden Farben extrahieren"; // Meldung, Information an den Benutzer
$color_palette_button_name="FARBPALETTE DES BILDES ERSTELLEN"; // Beschriftung des Submit-Buttons
$color_palette_directory_name="color_palette"; // Verzeichnisname fuer die Bilder von Color-Palette
$color_palette_image_new_width=640; // Breite des eingefuegten Originalbildes, 640 (default), HINWEIS: Wert sollte in dieser Version nicht geaendert werden!!
$color_palette_image_new_height=480; // Hoehe des eingefuegten Originalbildes, 480 (default), HINWEIS: Wert sollte in dieser Version nicht geaendert werden!!
$color_palette_image_width=1100; // Bildbreite des Arbeitsbildes fuer die Ermittlung der Farbpalette, 1100 (Pixel) (default), HINWEIS: Wert sollte in dieser Version nicht geaendert werden!!
$color_palette_image_height=1500; // Bildhoehe des Arbeitsbildes fuer die Ermittlung der Farbpalette, 1500 (Pixel) (default), HINWEIS: Wert sollte in dieser Version nicht geaendert werden!!
$color_palette_image_color_red=255; // Hintergrundfarbe - Rotanteil, 0 ... 255, 255 (default)
$color_palette_image_color_green=255; // Hintergrundfarbe - Gruenanteil, 0 ... 255, 255 (default)
$color_palette_image_color_blue=255; // Hintergrundfarbe - Blauanteil, 0 ... 255, 255 (default)
$color_palette_pixel_size=20; // Pixelgroesze des Arbeitsbildes fuer die Ermittlung der Farbpalette, 10 ... 99 (Pixel), 20 (default)
$color_palette_file_access=0644; // Zugriffsrechte der erstellten Dateien; moegliche Werte: 0666, 0644 (default), 0640, 0600
$color_palette_upload_file_type_array=array("image/jpeg",
                                            "image/gif",
                                            "image/png"); // Array mit einigen Internet Media Types (MIME-Typen) von Bild-Dateien
$color_palette_directory_returncode_messages_array=array('Hinweis: Es ist ein schwerwiegender, unbekannter Fehler (RETURNCODE 0) aufgetreten!',
                                                         '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                         'Hinweis: Das Color-Palette-Verzeichnis (RETURNCODE 2) konnte nicht erstellt werden - keine Schreibberechtigung!',
                                                         'Hinweis: Das Color-Palette-Verzeichnis (RETURNCODE 3) kann nicht genutzt werden - keine Schreibberechtigung!'); // Array mit Meldungen, Informationen an den Benutzer
$color_palette_upload_image_returncode_messages_array=array('Hinweis: Es ist ein schwerwiegender, unbekannter Fehler (RETURNCODE 0) aufgetreten!',
                                                         '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                         'Hinweis: Die Uploaddatei (RETURNCODE 2) wurde nicht gefunden!',
                                                         'Hinweis: Der Upload (RETURNCODE 3) konnte nicht durchgef&uuml;hrt werden! Grund: M&ouml;glicherweise besitzen Sie unzureichende Zugriffsrechte.',
                                                         'Hinweis: Unzul&auml;ssiger Dateityp (RETURNCODE 4)!',
                                                         'Hinweis: Unzul&auml;ssiger Dateityp oder unzul&auml;ssige Dateigr&ouml;&szlig;e (RETURNCODE 5)!',
                                                         'Hinweis: Der Kopiervorgang im Color-Palette-Arbeitsverzeichnis (RETURNCODE 6) konnte nicht durchgef&uuml;hrt werden!'); // Array mit Meldungen, Informationen an den Benutzer
$color_palette_image_text_array=array('Color-Palette',
                                      'die am meisten vorkommenden Farben im Bild',
                                      'die seltensten Farben im Bild',
                                      'Dateiname:',
                                      'Image-Size (Original):',
                                      'Pixel',
                                      'File-Size:',
                                      'Datei-Typ:',
                                      'Mime-Typ:',
                                      'Notizen:',
                                      'Hex: #0d0e10 und RGB: 13-14-16 (R .. red, G .. green, B .. blue) - Die im Bild vorkommenden Farben sind',
                                      'nach ihren hexadezimalen Farbkodierungen sortiert und entsprechen keiner harmonischen Farbreihe.'); // Array mit Beschriftungstext des Bildes mit der Farbpalette, nur englische Buchstaben, Zahlen und einige Sonderzeichen werden unterstuetzt
$color_palette_create_image_messages_not_successful="Hinweis: Die Farbpalette konnte nicht erstellt werden!"; // Meldung, Information an den Benutzer
$color_palette_create_work_image_messages_not_successful="Hinweis: Die Arbeitsdatei f&uuml;r die Erstellung der Farbpalette ist besch&auml;digt!"; // Meldung, Information an den Benutzer
$color_palette_messages_file_not_found="Hinweis: Die Arbeitsdatei f&uuml;r die Erstellung der Farbpalette wurde nicht gefunden!"; // Meldung, Information an den Benutzer

// Bereich: Variablen der Download-Depot-Seite
$download_depot_main_head_line="" . $obelix_hyperlink_array[22] . " - Liste mit gepackten Archiven"; // Ueberschrift des Hauptinhaltes
$download_depot_file_max_mega_byte=40; // maximale Dateigroesze in Megabyte (Default: 40 MByte)
$download_depot_file_max_size=$download_depot_file_max_mega_byte * 1024 * 1024; // maximale Dateigroesze in Byte (Default: 100 * 1024 * 1024 Byte)
$download_depot_main_content="Auf dieser Seite k&ouml;nnen gepackte Archive (ZIP, GZIP, 7ZIP) hochgeladen werden (siehe auch: " . $obelix_hyperlink_array[2] . ", " . $obelix_hyperlink_array[13] . " und " . $obelix_hyperlink_array[3] . "). Beim Upload einer beliebigen ZIP-Datei, GZIP-Datei bzw. 7ZIP-Datei wird diese Datei im Download-Verzeichnis (" . $obelix_file_name_array[14] . ") gespeichert. Die aktuelle maximale Dateigr&ouml;&szlig;e betr&auml;gt entsprechend dem  Eintrag im Konfigurationsbereich dieses PHP-Skriptes zur Zeit " . $download_depot_file_max_mega_byte . " Megabyte. Es erfolgt keine R&uuml;ckmeldung bei &Uuml;berschreitung der maximalen Dateigr&ouml;&szlig;e beim Upload.<br><br>Der urspr&uuml;ngliche Dateiname wird durch die Eintragungen (ohne Dateiendung) in den beiden Eingabefeldern ersetzt. F&uuml;r den Dateinamen der zu &uuml;bertragenden Datei ist nur das englische Alphabet, Zahlen, Minuszeichen und das Leerzeichen (a-zA-Z0-9- ) erlaubt. Landestypische Sonderzeichen k&ouml;nnen f&uuml;r den Dateinamen (Dateiname wird aus dem Gruppennamen und der Beschreibung gebildet) nicht verwendet werden. Die Leerzeichen im ersten Eingabefeld werden durch ein Minuszeichen und die Leerzeichen im zweiten Eingabefeld durch einen Unterstrich ersetzt. In der Tabellenansicht wird der Unterstrich im Dateinamen wieder automatisch durch ein Leerzeichen ersetzt (besere Lesbarkeit).<br><br>Es ist zu beachten, dass existierende Dateien nicht unbedingt f&uuml;r das PHP-Skript auch lesbar sind und lesbare Dateien bei unzureichenden Zugriffsrechten nicht bearbeitbar und damit auch nicht l&ouml;schbar sein k&ouml;nnen (Pr&uuml;fung: &#10003; ... true, &#10007; ... false).<br><br><strong>Hinweis: </strong>Die max. Dateigr&ouml;&szlig;e betr&auml;gt entsprechend den Eintr&auml;gen in der PHP-Konfigurationsdatei &raquo;.../etc/php.ini&laquo; des PHP-Servers zur Zeit  <strong>Upload-Max-Filesize: " . @ini_get('upload_max_filesize') . "Byte</strong> bzw. <strong>Post-Max-Size: " . @ini_get('post_max_size') . "Byte</strong>. Der ma&szlig;gebliche Wert f&uuml;r die maximale Dateigr&ouml;&szlig;e der Upload-Datei ist immer der <strong>kleinere</strong> Wert. &Uuml;bergeordnete Einstellungen des Webhosters k&ouml;nnen die maximale Dateigr&ouml;&szlig;e der Upload-Datei zus&auml;tzlich einschr&auml;nken."; // Text des Hauptinhaltes
$download_depot_file_type_extension_array=array(".zip",
                                                ".tar.gz",
                                                ".gz",
                                                ".7z"); // Dateiendungen von ZIP-Dateien
$download_depot_file_type_mime_array=array("application/x-zip",
                                           "application/zip",
                                           "application/x-tgz",
                                           "application/tgz",
                                           "application/gzip",
                                           "application/x-gunzip",
                                           "application/x-gzip",
                                           "application/x-7z-compressed"); // Array mit einigen Internet Media Types (MIME-Typen) von ZIP-Dateien
$download_depot_input_field_name="Upload-Datei (max. " . $download_depot_file_max_mega_byte . "MByte):"; // Beschriftung des input-Feldes
$download_depot_file_group_name="Gruppenname eintragen:"; // Beschriftung des input-Feldes
$download_depot_file_description_text="kurze Beschreibung eintragen:"; // Beschriftung des input-Feldes
$download_depot_button_name="DATEI-UPLOAD BEGINNEN"; // Beschriftung des Submit-Button
$download_depot_start_directory=$obelix_file_name_array[14]; // Startverzeichnis fuer die Dateiliste
$download_depot_directory_depth=3; // Verzeichnis-Tiefe: gueltige Werte 1 - 9; default => 3
$download_depot_table_title_name="Download-Archiv"; // Titel der Tabelle
$download_depot_table_feet_name="Verzeichnisse:"; // Titel des Tabellenfuszes
$download_depot_table_column_name_array=array("Lfd.-Nr.:",
                                             "Thema",
                                             "Erl&auml;uterung",
                                             "letzte &Auml;nderung<br>des Inhaltes",
                                             "Dateigr&ouml;&szlig;e",
                                             "lesbar",
                                             "schreibbar",
                                             "L&ouml;schen",
                                             "Download"); // Spaltennamen der Tabelle
$download_depot_directory_access=0755; // Zugriffsrechte des Verzeichnisses mit den ZIP-Dateien; moegliche Werte: 0777, 0775, 0755 (default), 0750, 0744, 0700
$download_depot_file_access=0644; // Zugriffsrechte der ZIP-Dateien; moegliche Werte: 0666, 0644 (default), 0640, 0600
$download_depot_group_name_maxlength=28; // maximale Laenge des Gruppennamen; 1 bis 99, default => 28
$download_depot_file_info_maxlength=100; // maximale Laenge der Dateiinformation; 1 bis 128, default => 100
$download_depot_filename_regex_term='a-zA-Z0-9\- '; // erlaubte Zeichen fuer den Dateinamen, englisches Alphabet, Zahlen, Minuszeichen und das Leerzeichen
$download_depot_upload_returncode_messages_array=array('Hinweis: Es ist ein schwerwiegender, unbekannter Fehler (RETURNCODE 0) aufgetreten!',
                                                       '', // erfolgreiche Ausfuehrung (Returncode 1), keine Meldung
                                                       'Hinweis: Das Verzeichnis f&uuml;r die Uploaddateien konnte nicht erstellt werden (RETURNCODE 2)! Grund: M&ouml;glicherweise besitzen Sie unzureichende Zugriffsrechte.',
                                                       'Hinweis: Das Verzeichnis f&uuml;r die Uploaddateien (RETURNCODE 3) kann vom PHP-Skript nicht gelesen werden!',
                                                       'Hinweis: Es m&uuml;ssen alle Felder ausgef&uuml;llt werden (RETURNCODE 4)!',
                                                       'Hinweis: Die Uploaddatei (RETURNCODE 5) kann vom PHP-Skript nicht gelesen werden!',
                                                       'Hinweis: Die Uploaddatei (RETURNCODE 6) wurde nicht gefunden!',
                                                       'Hinweis: Der Upload (RETURNCODE 7) konnte nicht durchgef&uuml;hrt werden! Grund: M&ouml;glicherweise besitzen Sie unzureichende Zugriffsrechte.',
                                                       'Hinweis: Unzul&auml;ssiger Dateityp oder unzul&auml;ssige Dateigr&ouml;&szlig;e (RETURNCODE 8)!',
                                                       'Hinweis: Es d&uuml;rfen nur zul&auml;ssige Zeichen in den Eingabefeldern eingetragen werden (RETURNCODE 9)!'); // Array mit Meldungen, Informationen an den Benutzer
$download_depot_directory_not_found_messages="<strong>Hinweis:</strong> Das Verzeichnis f&uuml;r die Download-Archive existiert nicht."; // Meldung, Information an den Benutzer
$download_depot_directory_not_readable_messages="<strong>Hinweis:</strong> Das Verzeichnis f&uuml;r die Download-Archive ist nicht lesbar."; // Meldung, Information an den Benutzer
$download_depot_directory_not_writeable_messages="<strong>Hinweis:</strong> Die Datei im Verzeichnis f&uuml;r die Download-Archive k&ouml;nnte nicht gel&ouml;scht werden!<br>Grund: M&ouml;glicherweise besitzen Sie unzureichende Zugriffsrechte."; // Meldung, Information an den Benutzer
$download_depot_directory_empty_messages="<strong>Hinweis:</strong> Das Verzeichnis f&uuml;r die Download-Archive enth&auml;lt keine ZIP-Dateien."; // Meldung, Information an den Benutzer
$download_depot_remove_messages_not_successful="<strong>Hinweis:</strong> Datei konnte nicht gel&ouml;scht werden!<br>Grund: M&ouml;glicherweise besitzen Sie unzureichende Zugriffsrechte."; // Meldung, Information an den Benutzer";
$download_depot_remove_messages_file_not_found="<strong>Hinweis:</strong> Datei existiert nicht oder es wurde kein Dateiname &uuml;bergeben!"; // Meldung, Information an den Benutzer";

// Bereich: Variablen der Routine-Check-Seite
$routine_check_main_head_line="" . $obelix_hyperlink_array[23] . " - &Uuml;berpr&uuml;fung von Systemdateien (PHP-Skript)"; // Ueberschrift des Hauptinhaltes
$routine_check_main_content="Auf dieser Seite werden die Verzeichnisse und Dateien, die von diesem PHP-Skript erstellt werden, einer kurzen &Uuml;berpr&uuml;fung unterzogen. Bei der &Uuml;berpr&uuml;fung werden die im Konfigurationsbereich dieses PHP-Skriptes eingetragenen Zugriffsrechte mit den aktuellen Zugriffsrechten verglichen.<br><br>Alle von diesem PHP-Skript <strong>erstellten</strong> Verzeichnisse und Dateien, m&uuml;ssen in der Tabelle als vorhanden, lesbar und als schreibbar gekennzeichnet sein (Eintrag: &#10003; ... true). Ist das aktuelle Verzeichnis (./) in der Tabelle nur als lesbar gekennzeichnet, so k&ouml;nnen einige Funktionen des PHP-Skriptes nicht genutzt werden (siehe auch: EXEC, MOVE-OBELIX).<br><br>Es ist zu beachten, dass vorhandene Dateien nicht unbedingt f&uuml;r das PHP-Skript auch lesbar sind und lesbare Dateien bei unzureichenden Zugriffsrechten nicht bearbeitbar und damit auch nicht l&ouml;schbar sein k&ouml;nnen (Pr&uuml;fung: &#10003; ... true, &#10007; ... false). Ist das PHP-Skript " . $obelix_file_name_array[4] . " nur als lesbar gekennzeichnet, so k&ouml;nnen alle Funktionen genutzt werden. Die einzige Einschr&auml;nkung besteht darin, dass das PHP-Skript sich selbst nicht bearbeiten kann (siehe auch: SITEMAP).<br><br><strong>Hinweis:</strong> Werden in den vom PHP-Skript erstellten Verzeichnisse weitere Verzeichnisse und Dateien manuell abgelegt, so sollten die Zugriffsrechte &uuml;berpr&uuml;ft und entsprechend angepasst werden (vermeidet Fehlalarme)."; // Text des Hauptinhaltes
$routine_check_table_title_name="Routine-&Uuml;berpr&uuml;fung der Verzeichnisse und Dateien"; // Titel der Tabelle
$routine_check_table_feet_name="aktuelles Startverzeichnis:"; // Titel des Tabellenfuszes
$routine_check_table_titles_array=array('Lfd.-Nr.:',
                                        'Verzeichnis',
                                        'Dateiname',
                                        'Eigent&uuml;mer',
                                        'Gruppe',
                                        'Vorgabe-<br>Zugriffsrecht',
                                        'aktuelles<br>Zugriffsrecht',
                                        'Dateigr&ouml;&szlig;e',
                                        'vorhanden',
                                        'lesbar',
                                        'schreibbar'); // Array mit den Feldnamen
$routine_check_file_array=array(array('./', '&minus;'),
                                array($obelix_file_name_array[4], '&minus;'),
                                array($obelix_file_name_array[1], $htaccess_file_access),
                                array($obelix_file_name_array[2], $htaccess_file_access),
                                array($obelix_file_name_array[3], $hyperlink_listing_file_access),
                                array($obelix_file_name_array[7], $mysql_inc_db_config_file_access),
                                array($obelix_file_name_array[8], $upload_file_access),
                                array($obelix_file_name_array[5], $upload_file_access),
                                array($obelix_file_name_array[6], $upload_file_access),
                                array($obelix_file_name_array[0], $upload_file_access),
                                array($obelix_file_name_array[9], $create_file_file_access),
                                array($obelix_file_name_array[10], $access_limitations_file_access)); // Array mit den zu pruefenden Obelix-Dateien
$routine_check_directory_array=array(array($obelix_file_name_array[11], $image_editing_color_palette_directory_access, $image_editing_color_palette_file_access),
                                     array($obelix_file_name_array[12], $image_editing_color_palette_directory_access, $image_editing_color_palette_file_access),
                                     array($obelix_file_name_array[13], $host_intrusion_detection_directory_access, $host_intrusion_detection_file_access),
                                     array($obelix_file_name_array[14], $download_depot_directory_access, $download_depot_file_access)); // Array mit den zu pruefenden Obelix-Verzeichnissen

// Bereich: Variablen der Editor-Seite
$editor_main_head_line="Obelix-Editor"; // Ueberschrift des Hauptinhaltes
$editor_main_content="Der Obelix-Editor ist ein reiner Texteditor f&uuml;r die Barbeitung von HTML, PHP-, CSS-, TXT-, Javaskript-, DAT- und CSV-Dateien. Da Text-Datenbanken (CSV-, DAT-Dateien) mitunter einige Sonderzeichen enthalten, sollten diese nicht durch den HTML-Code ersetzt werden. Wird die aktuelle Datei gleichzeitig von einem anderen Ort mit einem anderen Programm oder von einer anderen Person ge&auml;ndert, so sollte die Bildschirm-Ansicht regelm&auml;&szlig;ig aktualisiert werden. Textkodierungen von Textdokumenten die mit anderen Programmen erstellt wurden, k&ouml;nnen vom Obelix-Editor mitunter nur fehlerbehaftet gelesen werden. F&uuml;r die Bearbeitung der Dateien sind ausreichende Zugriffsrechte erforderlich.<br><strong>Hinweis:</strong>  Bei fehlerbehafteten Darstellungen, nur das englische Alphabet und typische Sonderzeichen (ASCII-Zeichen 32 bis 126) verwenden. &Auml;nderungen an den Dateien, k&ouml;nnen nach dem Speichervorgang nicht mehr oder nur teilweise wieder r&uuml;ckg&auml;ngig gemacht werden."; // Text des Hauptinhaltes
$editor_title_tag_name="EDITOR"; // Text des title-Tag
$editor_string_file_name="Dateiname"; // Meldung, Information an den Benutzer
$editor_string_save="Speichern"; // Button-Beschriftung
$editor_string_restore="Original wiederherstellen"; // Button-Beschriftung
$editor_string_screen_refresh="Aktualisieren"; // Button-Beschriftung
$editor_string_annuler="Editor schlie&szlig;en"; // Button-Beschriftung
$editor_message_save_file_not_successful="Hinweis: Fehler beim Abspeichern der Datei - m&ouml;glichweise unzureichende Zugriffsberechtigungen!"; // Meldung, Information an den Benutzer
$editor_message_file_not_found="Hinweis: Datei existiert nicht oder es wurde kein Dateiname &uuml;bergeben!"; // Meldung, Information an den Benutzer
$editor_radio_text_a="enthaltenen HTML-Code anzeigen (Button: " . $editor_string_screen_refresh . ")"; // Meldung, Information an den Benutzer
$editor_radio_text_b="l&auml;nderspezifische Zeichen (DE, PL, RU, CZ, FR) durch HTML-Code ersetzen (Dateitypen: .html, .htm, .php, 1. Button: " . $editor_string_save . " und 2. Button: " . $editor_string_screen_refresh . ")"; // Meldung, Information an den Benutzer
$editor_radio_text_c="enthaltenen HTML-Code durch die entsprechenden Zeichen ersetzen (Button: " . $editor_string_save . ")"; // Meldung, Information an den Benutzer
$editor_radio_text_d="keine Sonderfunktionen anwenden oder anzeigen (Button: " . $editor_string_screen_refresh . ")"; // Meldung, Information an den Benutzer
$editor_html_help_text="<strong>Hinweis:</strong> Enthalten die Textdateien vom Internet-Browser auswertbaren HTML-Code, so kann es zu fehlerbehafteten Darstellungen kommen (L&ouml;sung: den obersten Radio-Button markieren und die Editor-Ansicht aktualisieren)."; // Meldung, Information an den Benutzer

// +++ ENDE KONFIGURATION +++

// Definierung von grundlegenden Variablen
$navigation_css_content="";
$current_page_css="";
$first_head_line="";
$navigation_list="";
$main_content="";

/*
Obelix-ID fuer die Webseiten-Hyperlinks erstellen bzw. ueberpruefen
Zugangsbeschraenkung: nur einen Benutzer zur selben Zeit Zugang gewaehren
*/
if(isset($access_limitations_enable)) {
   if(!preg_match("/^[0-1]{1}$/", $access_limitations_enable)) {
      $access_limitations_enable=1;
   }
}
else
{
$access_limitations_enable=1;
}
if(!empty($access_limitations_time)) {
   if(!preg_match("/^[0-9]{2,5}$/", $access_limitations_time)) {
      if($access_limitations_time < 60) {
         $access_limitations_time=60*60*6;
      }
   }
}
else
{
$access_limitations_time=60*60*6;
}
if(isset($_GET['OBELIX_ID']) &&
   preg_match("/^[0-9]{1,2}$/",$_GET['OBELIX_ID']) &&
   $_GET['OBELIX_ID'] == 0 &&
   isset($_GET['ACCESS_ID']) &&
   preg_match("/^[0-9a-fA-F]{1,32}$/",$_GET['ACCESS_ID'])) {
   // Logout
   $obelix_file_id=0;
   $obelix_access_id=0;
   if(file_exists($obelix_file_name_array[10])) {
      @unlink($obelix_file_name_array[10]);
      if(file_exists($obelix_file_name_array[10])) {
         $access_not_allowed=1;
      }
   }
} elseif(isset($_GET['OBELIX_ID']) &&
   preg_match("/^[0-9]{1,2}$/",$_GET['OBELIX_ID']) &&
   isset($_GET['ACCESS_ID']) &&
   preg_match("/^[0-9a-fA-F]{32}$/",$_GET['ACCESS_ID']) &&
   $access_limitations_enable == 1) {
   if(isset($obelix_file_name_array) && is_array($obelix_file_name_array)) {
      // Aufruf einer neuen Seite und Pruefung der Zugangsberechtigung
      if(!empty($obelix_file_name_array[10]) &&
         file_exists($obelix_file_name_array[10]) &&
         is_readable($obelix_file_name_array[10])) {
         $access_limitations_file_array = file($obelix_file_name_array[10]);
         $access_limitations_file_array_count = count($access_limitations_file_array);
         if($access_limitations_file_array_count >= 1) {
            $access_limitations_file_line_one_array = explode("|", $access_limitations_file_array[0]);
            $access_limitations_file_line_one_array_count = count($access_limitations_file_line_one_array);
            if($access_limitations_file_line_one_array_count == 2) {
               $access_limitations_id = trim($access_limitations_file_line_one_array[0]);
               $access_limitations_unix_timestamp = trim($access_limitations_file_line_one_array[1]);
               $current_unix_timestamp = time();
               $obelix_access_id=trim($_GET['ACCESS_ID']);
               if(preg_match("/^[0-9a-fA-F]{32}$/", $access_limitations_id) && strcmp($obelix_access_id, $access_limitations_id) == 0) {
                  if(preg_match("/^[0-9]{1,10}$/", $access_limitations_unix_timestamp) && $access_limitations_unix_timestamp > $current_unix_timestamp) {
                     $obelix_file_id=trim($_GET['OBELIX_ID']);
                  } elseif(preg_match("/^[0-9]{1,10}$/", $access_limitations_unix_timestamp) && $access_limitations_unix_timestamp <= $current_unix_timestamp) {
                     @unlink($obelix_file_name_array[10]);
                     if(!file_exists($obelix_file_name_array[10])) {
                        $access_not_allowed=2;
                     }
                     else
                     {
                     $access_not_allowed=1;
                     }
                  }
                  else
                  {
                  $access_not_allowed=3;
                  }
               }
               else
               {
               $access_not_allowed=1;
               }
            }
            else
            {
            $access_not_allowed=3;
            }
         }
         else
         {
          $access_not_allowed=3;
         }
      }
      else
      {
      $access_not_allowed=3;
      }
   }
   else
   {
   $access_not_allowed=1;
   }
} elseif(isset($_GET['OBELIX_ID']) &&
   preg_match("/^[0-9]{1,2}$/",$_GET['OBELIX_ID']) &&
   isset($_GET['ACCESS_ID']) &&
   preg_match("/^[0]$/",$_GET['ACCESS_ID']) &&
   isset($obelix_file_name_array) &&
   is_array($obelix_file_name_array) &&
   !empty($obelix_file_name_array[10]) &&
   $access_limitations_enable == 0) {
   // Aufruf einer neuen Seite ohne Pruefung der Zugangsberechtigung
   $obelix_file_id=trim($_GET['OBELIX_ID']);
   $obelix_access_id=0;
   if(file_exists($obelix_file_name_array[10])) {
      @unlink($obelix_file_name_array[10]);
      if(file_exists($obelix_file_name_array[10])) {
         $access_not_allowed=1;
      }
   }
} elseif(!empty($_POST['OBELIX_KEY']) && strcmp($_POST['OBELIX_KEY'], date("Y")) == 0) {
   if(isset($obelix_file_name_array) && is_array($obelix_file_name_array)) {
      if(!empty($obelix_file_name_array[10]) &&
         file_exists($obelix_file_name_array[10]) &&
         is_readable($obelix_file_name_array[10]) &&
         !empty($access_limitations_time) &&
         $access_limitations_enable == 1) {
         // Login und Pruefung der Ablaufzeit der Access-ID
         $access_limitations_file_array = file($obelix_file_name_array[10]);
         $access_limitations_file_array_count = count($access_limitations_file_array);
         if($access_limitations_file_array_count >= 1) {
            $access_limitations_file_line_one_array = explode("|", $access_limitations_file_array[0]);
            $access_limitations_file_line_one_array_count = count($access_limitations_file_line_one_array);
            if($access_limitations_file_line_one_array_count == 2) {
               $access_limitations_unix_timestamp = trim($access_limitations_file_line_one_array[1]);
               $current_unix_timestamp = time();
               $current_sojourn_time = $current_unix_timestamp + $access_limitations_time;
               if(preg_match("/^[0-9]{1,10}$/", $access_limitations_unix_timestamp) && $access_limitations_unix_timestamp <= $current_unix_timestamp) {
                  @unlink($obelix_file_name_array[10]);
                  if(!file_exists($obelix_file_name_array[10])) {
                     $obelix_file_id=1;
                     $raw_access_id = $_SERVER['HTTP_USER_AGENT'] . $_SERVER['REMOTE_ADDR'] . time();
                     $obelix_access_id = md5($raw_access_id);
                     $access_limitations_unix_timestamp = $current_sojourn_time;
                     $access_limitations_file_content = $obelix_access_id . "|" . $access_limitations_unix_timestamp . "\n";
                     if(is_writeable('./') && !empty($access_limitations_file_access)) {
                        if(@touch($obelix_file_name_array[10])) {
                           chmod($obelix_file_name_array[10], $access_limitations_file_access);
                           if($FileWrite = @fopen($obelix_file_name_array[10],'w')) {
                              @flock($FileWrite,2);
                              @fwrite($FileWrite, $access_limitations_file_content);
                              @flock($FileWrite,3);
                              @fclose($FileWrite);
                           }
                           else
                           {
                           $access_not_allowed=3;
                           }
                        }
                        else
                        {
                        $access_not_allowed=3;
                        }
                     }
                     else
                     {
                     $access_not_allowed=3;
                     }
                  }
                  else
                  {
                  $access_not_allowed=1;
                  }
               }
               else
               {
               $access_not_allowed=1;
               }
            }
            else
            {
            $access_not_allowed=3;
            }
         }
         else
         {
         $access_not_allowed=3;
         }
      } elseif(!empty($obelix_file_name_array[10]) &&
         !file_exists($obelix_file_name_array[10]) &&
         !empty($access_limitations_time) &&
         $access_limitations_enable == 1) {
         // Loging und Anlegung der Datei mit der Access-ID
         $obelix_file_id=1;
         $raw_access_id = $_SERVER['HTTP_USER_AGENT'] . $_SERVER['REMOTE_ADDR'] . time();
         $obelix_access_id = md5($raw_access_id);
         $access_limitations_unix_timestamp = time() + $access_limitations_time;
         $access_limitations_file_content = $obelix_access_id . "|" . $access_limitations_unix_timestamp . "\n";
         if(is_writeable('./') && !empty($access_limitations_file_access)) {
            if(@touch($obelix_file_name_array[10])) {
               chmod($obelix_file_name_array[10], $access_limitations_file_access);
               if($FileWrite = @fopen($obelix_file_name_array[10],'w')) {
                  @flock($FileWrite,2);
                  @fwrite($FileWrite, $access_limitations_file_content);
                  @flock($FileWrite,3);
                  @fclose($FileWrite);
               }
               else
               {
               $access_not_allowed=3;
               }
            }
            else
            {
            $access_not_allowed=3;
            }
         }
         else
         {
         $access_not_allowed=3;
         }
      } elseif(!empty($obelix_file_name_array[10]) &&
         file_exists($obelix_file_name_array[10]) &&
         !is_readable($obelix_file_name_array[10]) &&
         $access_limitations_enable == 1) {
         $access_not_allowed=1;
      } elseif(!empty($obelix_file_name_array[10]) && $access_limitations_enable == 0) {
         $obelix_file_id=1;
         $obelix_access_id=0;
         if(file_exists($obelix_file_name_array[10])) {
            @unlink($obelix_file_name_array[10]);
            if(file_exists($obelix_file_name_array[10])) {
               $access_not_allowed=1;
            }
         }
      }
      else
      {
      $access_not_allowed=1;
      }
   }
   else
   {
   $access_not_allowed=1;
   }
}
else
{
   $obelix_file_id=100;
   $obelix_access_id=0;
   $footer_date_time_current="Welcome to Obelix " . date("l, d.m.Y - H:i:s");
}
if(!empty($access_not_allowed)) {
   /*
   $access_not_allowed=1 -> automatischer Logout
   $access_not_allowed=2 -> automatischer Logout - Zeit ist regulaer abgelaufen - Meldung auf der Startseite
   $access_not_allowed=3 -> automatischer Logout und Meldung auf der Startseite - Datei fuer die Zugangsbeschraenkung ist beschaedigt
   siehe auch:
   switch ($obelix_file_id) {
   case 0:
   [...]
   */
   $obelix_file_id=0;
   $obelix_access_id=0;
   $footer_date_time_current="Welcome to Obelix " . date("l, d.m.Y - H:i:s");
}

// UEBERPRUEFUNG EINIGER VARIABLEN
// globale Variablen
if(isset($ini_max_execution_time) && !preg_match("/^[1-9][0-9]{1,2}$/", $ini_max_execution_time)) {
   $ini_max_execution_time=120;
} elseif(empty($ini_max_execution_time)) {
   $ini_max_execution_time=120;
}
if(isset($ini_memory_limit) && !preg_match("/^(256M|512M|1024M)$/", $ini_memory_limit)) {
   $ini_memory_limit='1024M';
} elseif(empty($ini_memory_limit)) {
   $ini_memory_limit='1024M';
}
// Werte fuer die CSS-Boxen
if(isset($wrapper_box_width) && preg_match("/^[0-9]{3,4}$/", $wrapper_box_width)) {
   if($wrapper_box_width < 1000) $wrapper_box_width=1500;
}
else
{
$wrapper_box_width=1500;
}
if(isset($navigation_box_width) && preg_match("/^[0-9]{3}$/", $navigation_box_width)) {
   if($navigation_box_width < 100) $navigation_box_width=200;
}
else
{
$navigation_box_width=200;
}
if(isset($main_box_width) && preg_match("/^[0-9]{3,4}$/", $main_box_width)) {
   if($main_box_width < 1000) $main_box_width=1225;
}
else
{
$main_box_width=1225;
}
if(isset($wrapper_text_editor_box_width) && preg_match("/^[0-9]{3,4}$/", $wrapper_text_editor_box_width)) {
   if($wrapper_text_editor_box_width < 1000) $wrapper_text_editor_box_width=1200;
}
else
{
$wrapper_text_editor_box_width=1200;
}
if(isset($wrapper_image_editor_box_width) && preg_match("/^[0-9]{3,4}$/", $wrapper_image_editor_box_width)) {
   if($wrapper_image_editor_box_width < 1000) $wrapper_image_editor_box_width=1400;
}
else
{
$wrapper_image_editor_box_width=1400;
}
// Host Intrusion Detection System
if(isset($host_intrusion_detection_directory_default_depth) && !preg_match("/^([1-9]|[1][0-2])$/", $host_intrusion_detection_directory_default_depth)) {
   $host_intrusion_detection_directory_default_depth=8;
}
else
{
$host_intrusion_detection_directory_default_depth=8;
}
// Color Palette
if(empty($color_palette_image_width)) {
   $color_palette_image_width=1100;
} elseif(!empty($color_palette_image_width) && !preg_match("/^1100$/", $color_palette_image_width)) {
   $color_palette_image_width=1100;
}
if(empty($color_palette_image_height)) {
   $color_palette_image_height=1500;
} elseif(!empty($color_palette_image_height) && !preg_match("/^1500$/", $color_palette_image_height)) {
   $color_palette_image_height=1500;
}
if(empty($color_palette_image_new_width)) {
   $color_palette_image_new_width=640;
} elseif(!empty($color_palette_image_new_width) && !preg_match("/^640$/", $color_palette_image_new_width)) {
   $color_palette_image_new_width=640;
}
if(empty($color_palette_image_new_height)) {
   $color_palette_image_new_height=480;
} elseif(!empty($color_palette_image_new_height) && !preg_match("/^480$/", $color_palette_image_new_height)) {
   $color_palette_image_new_height=480;
}
if(empty($color_palette_pixel_size)) {
   $color_palette_pixel_size=20;
} elseif(!empty($color_palette_pixel_size) && !preg_match("/^[1-9][0-9]{1}$/", $color_palette_pixel_size)) {
   $color_palette_pixel_size=20;
}
// Download-Depot
if(empty($download_depot_group_name_maxlength)) {
   $download_depot_group_name_maxlength=28;
} elseif(!empty($download_depot_group_name_maxlength) && !preg_match("/^[1-9][0-9]{1}$/", $download_depot_group_name_maxlength)) {
   $download_depot_group_name_maxlength=28;
}
if(empty($download_depot_file_info_maxlength)) {
   $download_depot_file_info_maxlength=100;
} elseif(!empty($download_depot_file_info_maxlength) && !preg_match("/^[1-9][0-9]{1,2}$/", $download_depot_file_info_maxlength)) {
   if($download_depot_file_info_maxlength > 128) $download_depot_file_info_maxlength=100;
}

// HTML-Seitenarray (Grundgeruest) erstellen
function create_html_page() {
   $HTMLPageArray=array();
   $HTMLPageArray[]="<!DOCTYPE html>\n<html>\n<head>\n<meta charset=\"UTF-8\">\n<title>";
   $HTMLPageArray[]="</title>\n";
   $HTMLPageArray[]="<script type=\"text/javascript\">\n<!-- hide\n";
   $HTMLPageArray[]="\nfunction stoperror() {\n  return true;\n}\nwindow.onerror=stoperror;\n//-->\n</script>\n";
   $HTMLPageArray[]="<style type=\"text/css\">\n";
   $HTMLPageArray[]="</style>\n";
   $HTMLPageArray[]="</head>\n<body>\n";
   $HTMLPageArray[]="</body>\n</html>\n";
   return $HTMLPageArray;
}

// Navigation: Liste mit den Webseiten-Hyperlinks erstellen
function create_navigation($CreateNavigationArray='') {
   $NavigationList="";
   $CreateNavigationArrayDefaultCount=6; // Vorgabe: Anzahl der Array-Elemente
   $CreateNavigationArrayCurrentCount=count($CreateNavigationArray);
   $CreateNavigationArrayElement3DefaultCount=24; // Vorgabe: Anzahl der Array-Elemente
   $CreateNavigationArrayElement3CurrentCount=count($CreateNavigationArray[5]);
   if(isset($CreateNavigationArray) &&
      is_array($CreateNavigationArray) &&
      $CreateNavigationArrayDefaultCount == $CreateNavigationArrayCurrentCount &&
      isset($CreateNavigationArray[5]) &&
      is_array($CreateNavigationArray[5]) &&
      $CreateNavigationArrayElement3DefaultCount == $CreateNavigationArrayElement3CurrentCount) {
      if(!empty($CreateNavigationArray[3]) &&
         !empty($CreateNavigationArray[0]) &&
         preg_match("(^[0-9]{1,2}$)", $CreateNavigationArray[1]) &&
         preg_match("(^[0-9a-fA-F]{32}$)", $CreateNavigationArray[2])) {
         $NavigationList .="    <h2>" . $CreateNavigationArray[4] . "</h2>\n";
         $NavigationList .="    <ul>\n";
         for($i=0; $i<$CreateNavigationArrayElement3CurrentCount; $i++) {
            if($i == $CreateNavigationArray[1]) {
               $NavigationList .= "      <li><a href=\"" . $CreateNavigationArray[0] . "?OBELIX_ID=" . $i . "&ACCESS_ID=" . $CreateNavigationArray[2] . "\" class=\"link_activated\">" . $CreateNavigationArray[5][$i] . "</a></li>\n";
            }
            else
            {
            $NavigationList .= "      <li><a href=\"" . $CreateNavigationArray[0] . "?OBELIX_ID=" . $i . "&ACCESS_ID=" . $CreateNavigationArray[2] . "\">" . $CreateNavigationArray[5][$i] . "</a></li>\n";
            }
         }
         $NavigationList .="    </ul>\n";
      } elseif(empty($CreateNavigationArray[3]) &&
         !empty($CreateNavigationArray[0]) &&
         preg_match("(^[0-9]{1,2}$)", $CreateNavigationArray[1]) &&
         preg_match("(^[0]$)", $CreateNavigationArray[2])) {
         $NavigationList .="    <h2>" . $CreateNavigationArray[4] . "</h2>\n";
         $NavigationList .="    <ul>\n";
         for($i=0; $i<$CreateNavigationArrayElement3CurrentCount; $i++) {
            if($i == $CreateNavigationArray[1]) {
               $NavigationList .= "      <li><a href=\"" . $CreateNavigationArray[0] . "?OBELIX_ID=" . $i . "&ACCESS_ID=" . $CreateNavigationArray[2] . "\" class=\"link_activated\">" . $CreateNavigationArray[5][$i] . "</a></li>\n";
            }
            else
            {
            $NavigationList .= "      <li><a href=\"" . $CreateNavigationArray[0] . "?OBELIX_ID=" . $i . "&ACCESS_ID=" . $CreateNavigationArray[2] . "\">" . $CreateNavigationArray[5][$i] . "</a></li>\n";
            }
         }
         $NavigationList .="    </ul>\n";
      }
   } elseif(!isset($CreateNavigationArray) ||
      !is_array($CreateNavigationArray) ||
      $CreateNavigationArrayDefaultCount != $CreateNavigationArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY CreateNavigationArray (ARRAY-COUNT) - function <strong>create_navigation</strong> - IS DAMAGED!';
      exit;
   }
   else
   {
      print 'NOTE: SYSTEM-ARRAY CreateNavigationArray[5] (ARRAY-COUNT) - function <strong>create_navigation</strong> - IS DAMAGED!';
      exit;
   }
   return $NavigationList;
}

// CSS - Navigation: DEFAULT
function create_navigation_css() {
   $NavigationCSS="ul, li {\n  list-style-type: disc;\n  font-size: 0.9em;\n  line-height: 1.7em;\n}\n\n";
   $NavigationCSS .="a {\n  font-family: sans-serif;\n  font-size: 0.95em;\n  font-weight: bold;\n}\n\n";
   $NavigationCSS .="a:link { color: #C15C63; }\n\n";
   $NavigationCSS .="a:active { color: #C15C63; }\n\n";
   $NavigationCSS .="a:visited { color: #C15C63; }\n\n";
   $NavigationCSS .="a:hover { color: #8D343A; }\n\n";
   $NavigationCSS .=".link_activated { background-color: #EBDACC; }\n\n";
   return $NavigationCSS;
}

// Start-Webseite beim ersten Aufruf von Obelix erstellen
function create_start_text($CreateStartTextArray='') {
   $CreateStartTextArrayDefaultCount=6; // Vorgabe: Anzahl der Array-Elemente
   $CreateStartTextArrayCurrentCount=count($CreateStartTextArray);
   if(isset($CreateStartTextArray) &&
      is_array($CreateStartTextArray) &&
      $CreateStartTextArrayDefaultCount == $CreateStartTextArrayCurrentCount) {
      $StartPageArray=array();
      $StartLeftInformation="    <h2>" . $CreateStartTextArray[1] . "</h2>\n ";
      $StartLeftInformation .="    <p>" . $CreateStartTextArray[3] . "</p>\n";
      $StartPageArray[]=$StartLeftInformation;
      $StartAccessControl="    <article>\n";
      $StartAccessControl .="      <h3>" . $CreateStartTextArray[2] . "</h3>\n";
      $StartAccessControl .="      <br>\n";
      $StartAccessControl .="      <form name=\"form_start\" method=\"post\" action=\"" . $CreateStartTextArray[0] . "\" target=\"_self\" class=\"form_center\">\n";
      $StartAccessControl .="        <table>\n";
      $StartAccessControl .="          <tr>\n";
      $StartAccessControl .="            <td>" . $CreateStartTextArray[4] . ": </td>\n";
      $StartAccessControl .="            <td><input type=\"password\" name=\"OBELIX_KEY\" size=\"16\" maxlength=\"16\"></td>\n";
      $StartAccessControl .="            <td ><input type=\"submit\" name=\"OBELIX_KEY_BUTTON\" value=\"&raquo; GO &laquo;\"></td>\n";
      $StartAccessControl .="          </tr>\n";
      $StartAccessControl .="        </table>\n";
      $StartAccessControl .="      </form>\n";
      $StartAccessControl .="    </article>\n";
      $StartAccessControl .="    <br><br>\n";
      $StartAccessControl .="    <p class=\"center\">" . $CreateStartTextArray[5] . "</p>\n";
      $StartPageArray[]=$StartAccessControl;
   }
   else
   {
      print 'NOTE: SYSTEM-ARRAY CreateStartTextArray (ARRAY-COUNT) - function <strong>create_start_text</strong> - IS DAMAGED!';
      exit;
   }
   return $StartPageArray;
}

// CSS - Navigation: START
function create_start_css() {
   $StartCSS="h3 {\n  font-size: 1.15em;\n  font-weight: bold;\n  text-align: center;\n}\n\n";
   $StartCSS .=".form_center {\n  display: flex;\n  justify-content: center;\n  align-content: center;\n}\n\n";
   $StartCSS .="input { font-size: 0.85em; }\n\n";
   return $StartCSS;
}

// Ueberpruefung der Systemdateien
function create_home_directory_file_check($RoutineCheckDirectoryArray='', $RoutineCheckFileArray='') {
   $ReturnCode='';
   $DirectoryDefaultDepth=9; // Vorgabe der Verzeichnistiefe (siehe auch: function create_routine_check()), 1 ... 12, 9 (default)
   $RoutineCheckDirectoryArrayDefaultCount=4; // Vorgabe: Anzahl der Array-Elemente
   $RoutineCheckDirectoryArrayCurrentCount=count($RoutineCheckDirectoryArray);
   $RoutineCheckFileArrayDefaultCount=12; // Vorgabe: Anzahl der Array-Elemente
   $RoutineCheckFileArrayCurrentCount=count($RoutineCheckFileArray);
   if(isset($RoutineCheckDirectoryArray) &&
      is_array($RoutineCheckDirectoryArray) &&
      $RoutineCheckDirectoryArrayDefaultCount == $RoutineCheckDirectoryArrayCurrentCount &&
      isset($RoutineCheckFileArray) &&
      is_array($RoutineCheckFileArray) &&
      $RoutineCheckFileArrayDefaultCount == $RoutineCheckFileArrayCurrentCount) {
      $RoutineCheckFileArrayCount = count($RoutineCheckFileArray);
      for($x=0; $x<$RoutineCheckFileArrayCount; $x++) {
         // das erste uebergebene Array (Konfigurationsbereich) auswerten
         $ConfigurationExistingFileAccessRight='';
         if(isset($RoutineCheckFileArray[$x]) && is_array($RoutineCheckFileArray[$x])) {
            $FilenameFileaccessArrayCount = count($RoutineCheckFileArray[$x]);
            if($FilenameFileaccessArrayCount == 2) {
               if($x > 1) {
                  if(is_int($RoutineCheckFileArray[$x][1])) {
                     $FileAccessRight = decoct($RoutineCheckFileArray[$x][1]);
                     if(!preg_match("/^[0][0-6]{3}$/", $FileAccessRight)) {
                        if(preg_match("/^[0-6]{3}$/", $FileAccessRight)) {
                           $ConfigurationExistingFileAccessRight = "0" . $FileAccessRight;
                        }
                        else
                        {
                           $ReturnCode=1;
                           break;
                        }
                     }
                     else
                     {
                     $ConfigurationExistingFileAccessRight = $FileAccessRight;
                     }
                  }
                  else
                  {
                     $ReturnCode=1;
                     break;
                  }
               }
               if(!empty($RoutineCheckFileArray[$x][0]) && file_exists($RoutineCheckFileArray[$x][0])) {
                  $FileAccessRight = decoct(fileperms($RoutineCheckFileArray[$x][0]));
                  $CurrentExistingFileAccessRight = substr($FileAccessRight, -4);
                  if($x > 1) {
                     if(strcasecmp($ConfigurationExistingFileAccessRight, $CurrentExistingFileAccessRight) != 0) {
                        $ReturnCode=2;
                        break;
                     }
                  }
                  if(!is_readable($RoutineCheckFileArray[$x][0])) {
                     $ReturnCode=3;
                     break;
                  }
                  if(!is_writeable($RoutineCheckFileArray[$x][0])) {
                     $ReturnCode=4;
                     break;
                  }
               }
            }
            else
            {
               $ReturnCode=5;
               break;
            }
         }
      }
      $RoutineCheckDirectoryArrayCount = count($RoutineCheckDirectoryArray);
      for($x=0; $x<$RoutineCheckDirectoryArrayCount; $x++) {
         if(isset($RoutineCheckDirectoryArray[$x]) && is_array($RoutineCheckDirectoryArray[$x])) {
            // das zweite uebergebene Array (Konfigurationsbereich) auswerten
            $ConfigurationExistingDirectoryAccessRight='';
            $ConfigurationExistingFileAccessRight='';
            $DirectoryNameFileaccessArrayCount = count($RoutineCheckDirectoryArray[$x]);
            if($DirectoryNameFileaccessArrayCount == 3) {
               if(is_int($RoutineCheckDirectoryArray[$x][1])) {
                  $DirectoryAccessRight = decoct($RoutineCheckDirectoryArray[$x][1]);
                  if(!preg_match("/^[0][0-7]{3}$/", $DirectoryAccessRight)) {
                     if(preg_match("/^[0-7]{3}$/", $DirectoryAccessRight)) {
                        $ConfigurationExistingDirectoryAccessRight = "0" . $DirectoryAccessRight;
                     }
                     else
                     {
                        $ReturnCode=1;
                        break;
                     }
                  }
                  else
                  {
                  $ConfigurationExistingDirectoryAccessRight = $DirectoryAccessRight;
                  }
               }
               else
               {
                  $ReturnCode=1;
                  break;
               }
               if(is_int($RoutineCheckDirectoryArray[$x][2])) {
                  $FileAccessRight = decoct($RoutineCheckDirectoryArray[$x][2]);
                  if(!preg_match("/^[0][0-6]{3}$/", $FileAccessRight)) {
                     if(preg_match("/^[0-6]{3}$/", $FileAccessRight)) {
                        $ConfigurationExistingFileAccessRight = "0" . $FileAccessRight;
                     }
                     else
                     {
                        $ReturnCode=1;
                        break;
                     }
                  }
                  else
                  {
                  $ConfigurationExistingFileAccessRight = $FileAccessRight;
                  }
               }
               else
               {
                  $ReturnCode=1;
                  break;
               }
            }
            else
            {
               $ReturnCode=5;
               break;
            }
            if(!empty($RoutineCheckDirectoryArray[$x][0])) {
               $RoutineCheckCurrentDirectoryArray=array();
               if(is_dir($RoutineCheckDirectoryArray[$x][0])) {
                  $RoutineCheckCurrentDirectoryArray[] = $RoutineCheckDirectoryArray[$x][0];
                  $RoutineCheckCurrentDirectoryArrayCount = count($RoutineCheckCurrentDirectoryArray);
                  $RoutineCheckDirectoryMaxDepthCount = substr_count($RoutineCheckCurrentDirectoryArray[0], '/') + $DirectoryDefaultDepth - 1;
                  for($y=0; $y<$RoutineCheckCurrentDirectoryArrayCount; $y++) {
                     $RoutineCheckDirectoryHandle = @opendir($RoutineCheckCurrentDirectoryArray[$y]);
                     while($RoutineCheckDirectoryName = @readdir($RoutineCheckDirectoryHandle)) {
                        if($RoutineCheckDirectoryName != "." && $RoutineCheckDirectoryName != "..") {
                           $RoutineCheckDirectoryNameLength = strlen($RoutineCheckCurrentDirectoryArray[$y]) - 1;
                           $RoutineCheckDirectoryNameLastSlashPosition = strrpos($RoutineCheckCurrentDirectoryArray[$y], '/');
                           if($RoutineCheckDirectoryNameLength == $RoutineCheckDirectoryNameLastSlashPosition) {
                              $RoutineCheckCurrentDirectoryArray[$y] = substr($RoutineCheckCurrentDirectoryArray[$y], 0, -1);
                           }
                           $RoutineCheckNextDirectory = $RoutineCheckCurrentDirectoryArray[$y] . "/" . $RoutineCheckDirectoryName;
                           $RoutineCheckCurrentDirectoryCount = substr_count($RoutineCheckNextDirectory, '/');
                           if(is_dir($RoutineCheckNextDirectory) && $RoutineCheckCurrentDirectoryCount <= $RoutineCheckDirectoryMaxDepthCount) {
                              $RoutineCheckCurrentDirectoryArray[] = $RoutineCheckNextDirectory;
                              $RoutineCheckCurrentDirectoryArrayCount = count($RoutineCheckCurrentDirectoryArray);
                           }
                        }
                     }
                     @closedir($RoutineCheckDirectoryHandle);
                  }
               }
               // Verzeichnis-Eintraege ermitteln
               if(isset($RoutineCheckCurrentDirectoryArray) && is_array($RoutineCheckCurrentDirectoryArray)) {
                  sort($RoutineCheckCurrentDirectoryArray);
                  $RoutineCheckCurrentDirectoryArrayCount = count($RoutineCheckCurrentDirectoryArray);
                  for($y=0; $y<$RoutineCheckCurrentDirectoryArrayCount; $y++) {
                     $CurrentExistingDirectoryAccessRight='';
                     $RoutineCheckCurrentDirectoryName=$RoutineCheckCurrentDirectoryArray[$y];
                     if(is_dir($RoutineCheckCurrentDirectoryArray[$y])) {
                        $DirectoryAccessRight = decoct(fileperms($RoutineCheckCurrentDirectoryArray[$y]));
                        $CurrentExistingDirectoryAccessRight = substr($DirectoryAccessRight, -4);
                        if(strcasecmp($ConfigurationExistingDirectoryAccessRight, $CurrentExistingDirectoryAccessRight) != 0) {
                           $ReturnCode=2;
                           break;
                        }
                        if(!is_readable($RoutineCheckCurrentDirectoryName)) {
                           $ReturnCode=3;
                           break;
                        }
                        if(!is_writeable($RoutineCheckCurrentDirectoryName)) {
                           $ReturnCode=4;
                           break;
                        }
                     }
                     // Datei-Eintraege innerhalb einzelner Verzeichnisse ermitteln
                     $RoutineCheckCurrentFileArray=array();
                     if(isset($RoutineCheckCurrentDirectoryName) && is_dir($RoutineCheckCurrentDirectoryName)) {
                        $RoutineCheckFileHandle = @opendir($RoutineCheckCurrentDirectoryName);
                        while($RoutineCheckNextFile = @readdir($RoutineCheckFileHandle)) {
                           if($RoutineCheckNextFile != "." && $RoutineCheckNextFile != "..") {
                              $RoutineCheckFilePath = $RoutineCheckCurrentDirectoryName . "/" . $RoutineCheckNextFile;
                              if(file_exists($RoutineCheckFilePath) && !is_dir($RoutineCheckFilePath)) {
                                 $RoutineCheckCurrentFileArray[] = $RoutineCheckFilePath;
                              }
                           }
                        }
                        @closedir($RoutineCheckFileHandle);
                     }
                     if(isset($RoutineCheckCurrentFileArray) && is_array($RoutineCheckCurrentFileArray)) {
                        sort($RoutineCheckCurrentFileArray);
                        $RoutineCheckCurrentFileArrayCount = count($RoutineCheckCurrentFileArray);
                        for($z=0; $z<$RoutineCheckCurrentFileArrayCount; $z++) {
                           $CurrentExistingFileAccessRight='';
                           $FileAccessRight = decoct(fileperms($RoutineCheckCurrentFileArray[$z]));
                           $CurrentExistingFileAccessRight = substr($FileAccessRight, -4);
                           if(strcasecmp($ConfigurationExistingFileAccessRight, $CurrentExistingFileAccessRight) != 0) {
                              $ReturnCode=2;
                              break;
                           }
                           if(!is_readable($RoutineCheckCurrentFileArray[$z])) {
                              $ReturnCode=3;
                              break;
                           }
                           if(!is_writeable($RoutineCheckCurrentFileArray[$z])) {
                              $ReturnCode=4;
                              break;
                           }
                        }
                        unset($RoutineCheckCurrentFileArray);
                     }
                  }
                  unset($RoutineCheckCurrentDirectoryArray);
               }
            }
         }
      }
      if(empty($ReturnCode)) $ReturnCode=0;
      /* Returncode:
         0 .. keine Fehler
         1 .. Zugriffsberechtigung - fehlerbehaftete Eintraege im Konfigurationsbereich
         2 .. aktuelle Zugriffsberechtigung und Zugriffsberechtigung im Konfigurationsbereich - ungleich
         3 .. Verzeichnisse und Dateien - nicht lesbar fuer das PHP-Skript
         4 .. Verzeichnisse und Dateien - nicht beschreibbar fuer das PHP-Skript
         5 .. Array im Konfigurationsbereich fehlerbehaftet
      */
   } elseif(!isset($RoutineCheckDirectoryArray) ||
      !is_array($RoutineCheckDirectoryArray) ||
      $RoutineCheckDirectoryArrayDefaultCount != $RoutineCheckDirectoryArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY RoutineCheckDirectoryArray (ARRAY-COUNT) - function <strong>create_home_directory_file_check</strong> - IS DAMAGED!';
      exit;
   }
   else
   {
      print 'NOTE: SYSTEM-ARRAY RoutineCheckFileArray (ARRAY-COUNT) - function <strong>create_home_directory_file_check</strong> - IS DAMAGED!';
      exit;
   }
   return $ReturnCode;
}

// Ermittlung der verbleidenen Arbeitszeit
function remaining_working_time($AccessLimitationsUnixTimestamp=0) {
   $RemainingWorkingTimeArray=array(0, 0, 0);
   if(!empty($AccessLimitationsUnixTimestamp) && preg_match("/^[0-9]{1,10}$/", $AccessLimitationsUnixTimestamp)) {
      $CurrentUnixTimestamp = time();
      if($AccessLimitationsUnixTimestamp > $CurrentUnixTimestamp) {
         $RemainingWorkingTimeSecondsTotal = $AccessLimitationsUnixTimestamp - $CurrentUnixTimestamp;
         if($RemainingWorkingTimeSecondsTotal > 0) {
            if($RemainingWorkingTimeSecondsTotal < 60) {
               $RemainingWorkingTimeArray[2] = $RemainingWorkingTimeSecondsTotal;
            } elseif($RemainingWorkingTimeSecondsTotal < 3600) {
               $RemainingWorkingTimeMinutes = floor($RemainingWorkingTimeSecondsTotal / 60);
               $RemainingWorkingTimeMinutesModulus = $RemainingWorkingTimeSecondsTotal % 60;
               $RemainingWorkingTimeArray[1] = $RemainingWorkingTimeMinutes;
               $RemainingWorkingTimeArray[2] = $RemainingWorkingTimeMinutesModulus; // Rest in Sekunden
            }
            else
            {
               $RemainingWorkingTimeHours = floor($RemainingWorkingTimeSecondsTotal / 3600);
               $RemainingWorkingTimeHoursModulus = $RemainingWorkingTimeSecondsTotal % 3600;
               $RemainingWorkingTimeMinutes = floor($RemainingWorkingTimeHoursModulus / 60);
               $RemainingWorkingTimeMinutesModulus = $RemainingWorkingTimeHoursModulus % 60;
               $RemainingWorkingTimeArray[0] = $RemainingWorkingTimeHours;
               $RemainingWorkingTimeArray[1] = $RemainingWorkingTimeMinutes;
               $RemainingWorkingTimeArray[2] = $RemainingWorkingTimeMinutesModulus; // Rest in Sekunden
            }
         }
      }
   }
   return $RemainingWorkingTimeArray;
}

// Erstellung der Webseite HOME
function create_home($HomeDetailsArray='', $HomeCheckReturnCode='', $HomeLinkRoutineCheckMessages='') {
   $HomeDetailsArrayDefaultCount=8; // Vorgabe: Anzahl der Array-Elemente
   $HomeDetailsArrayCurrentCount=count($HomeDetailsArray);
   if(isset($HomeDetailsArray) &&
      is_array($HomeDetailsArray) &&
      $HomeDetailsArrayDefaultCount == $HomeDetailsArrayCurrentCount) {
      $MainContent="    <article>\n";
      $MainContent .="      <h3>" . $HomeDetailsArray[0] . "</h3>\n";
      if(isset($HomeDetailsArray[7]) && is_array($HomeDetailsArray[7])) {
        $HomeDetailsElementSevenArrayCount=count($HomeDetailsArray[7]);
        if($HomeDetailsElementSevenArrayCount == 3) {
           if(!empty($HomeDetailsArray[7][0]) &&
              isset($HomeDetailsArray[7][1]) &&
              isset($HomeDetailsArray[7][2])) {
              $MainContent .="      <p>" . $HomeDetailsArray[1] . " " . $HomeDetailsArray[2] . " " . $HomeDetailsArray[7][0] . " " . $HomeDetailsArray[4] . " " . $HomeDetailsArray[7][1] . " " . $HomeDetailsArray[5] . " " . $HomeDetailsArray[7][2] . " " . $HomeDetailsArray[6] . "<br><br></p>\n";
           } elseif(empty($HomeDetailsArray[7][0]) &&
              !empty($HomeDetailsArray[7][1]) &&
              isset($HomeDetailsArray[7][2])) {
              $MainContent .="      <p>" . $HomeDetailsArray[1] . " " . $HomeDetailsArray[2] . " " . $HomeDetailsArray[7][1] . " " . $HomeDetailsArray[5] . " " . $HomeDetailsArray[7][2] . " " . $HomeDetailsArray[6] . "<br><br></p>\n";
           } elseif(empty($HomeDetailsArray[7][0]) &&
              empty($HomeDetailsArray[7][1]) &&
              !empty($HomeDetailsArray[7][2])) {
              $MainContent .="      <p>" . $HomeDetailsArray[1] . " " . $HomeDetailsArray[2] . " " . $HomeDetailsArray[7][2] . " " . $HomeDetailsArray[6] . "<br><br></p>\n";
           }
           else
           {
           $MainContent .="      <p>" . $HomeDetailsArray[1] . "<br><br></p>\n";
           }
         }
         else
         {
         $MainContent .="      <p>" . $HomeDetailsArray[1] . "<br><br></p>\n";
         }
      }
      else
      {
      $MainContent .="      <p>" . $HomeDetailsArray[1] . "<br><br></p>\n";
      }
      $MainContent .="      <p class=\"red\">" . $HomeDetailsArray[3] . "</p>\n";
      if(!empty($HomeCheckReturnCode)) {
         $MainContent .="      <p><br><br>" . $HomeLinkRoutineCheckMessages . "</p>\n";
      }
      $MainContent .="    </article>\n";
   }
   else
   {
      print 'NOTE: SYSTEM-ARRAY HomeDetailsArray (ARRAY-COUNT) - function <strong>create_home</strong> - IS DAMAGED!';
      exit;
   }
   return $MainContent;
}

// CSS - Navigation: HOME
function create_home_css() {
   $HomeCSS="h3 {\n  font-size: 1.15em;\n  font-weight: bold;\n  text-align: center;\n}\n\n";
   $HomeCSS .=".red {\n  font-size: 0.95em;\n  font-weight: bold;\n  text-align: center;\n  color: #DD0000;\n}\n\n";
   return $HomeCSS;
}

// Erstellung der Webseite  UPLOAD
function create_upload($ObelixFileNameArray='', $UploadDetailsArray='', $UploadFileArray='', $UploadFileTypeArray='', $UploadMessagesArray='') {
   if(empty($UploadDetailsArray[0])) $UploadDetailsArray[0]=0;
   if(empty($UploadDetailsArray[1])) $UploadDetailsArray[1]=0;
   $UploadMessages='';
   $ObelixFileNameArrayDefaultCount=15; // Vorgabe: Anzahl der Array-Elemente
   $ObelixFileNameArrayCurrentCount=count($ObelixFileNameArray);
   $UploadDetailsArrayDefaultCount=9; // Vorgabe: Anzahl der Array-Elemente
   $UploadDetailsArrayCurrentCount=count($UploadDetailsArray);
   $UploadFileArrayDefaultCount=7; // Vorgabe: Anzahl der Array-Elemente
   $UploadFileArrayCurrentCount=count($UploadFileArray);
   $UploadMessagesArrayDefaultCount=7; // Vorgabe: Anzahl der Array-Elemente
   $UploadMessagesArrayCurrentCount=count($UploadMessagesArray);
   if(isset($ObelixFileNameArray) &&
      is_array($ObelixFileNameArray) &&
      $ObelixFileNameArrayDefaultCount == $ObelixFileNameArrayCurrentCount &&
      isset($UploadDetailsArray) &&
      is_array($UploadDetailsArray) &&
      $UploadDetailsArrayDefaultCount == $UploadDetailsArrayCurrentCount &&
      isset($UploadFileArray) &&
      is_array($UploadFileArray) &&
      $UploadFileArrayDefaultCount == $UploadFileArrayCurrentCount &&
      isset($UploadMessagesArray) &&
      is_array($UploadMessagesArray) &&
      $UploadMessagesArrayDefaultCount == $UploadMessagesArrayCurrentCount) {
      if(!empty($UploadFileArray[0])) {
         if(!empty($UploadFileArray[1]) &&
            !empty($UploadFileArray[2]) &&
            !empty($UploadFileArray[3]) &&
            !empty($UploadFileArray[4]) &&
            !empty($UploadFileArray[5]) &&
            isset($UploadFileArray[6]) &&
            $UploadFileArray[6] == 0) {
            if(in_array($UploadFileArray[3], $UploadFileTypeArray) &&
               $UploadFileArray[4] > 10 &&
               $UploadFileArray[4] <= $UploadDetailsArray[5]) {
               if(strcasecmp($UploadFileArray[3], $UploadFileTypeArray[0]) == 0 || strcasecmp($UploadFileArray[3], $UploadFileTypeArray[1]) == 0) {
                  $UploadTargetFileName = $ObelixFileNameArray[0];
               } elseif(strcasecmp($UploadFileArray[3], $UploadFileTypeArray[3]) == 0 || strcasecmp($UploadFileArray[3], $UploadFileTypeArray[4]) == 0) {
                  $UploadTargetFileName = $ObelixFileNameArray[5];
               } elseif(strcasecmp($UploadFileArray[3], $UploadFileTypeArray[2]) == 0 ||
                  strcasecmp($UploadFileArray[3], $UploadFileTypeArray[5]) == 0 ||
                  strcasecmp($UploadFileArray[3], $UploadFileTypeArray[6]) == 0) {
                  if(!preg_match("/^.+(\.tar\.gz|\.tgz)$/", $UploadFileArray[2])) {
                     $UploadTargetFileName = $ObelixFileNameArray[6];
                  }
                  else
                  {
                  $UploadTargetFileName = $ObelixFileNameArray[5];
                  }
               } elseif(strcasecmp($UploadFileArray[3], $UploadFileTypeArray[7]) == 0) {
                  $UploadTargetFileName = $ObelixFileNameArray[8];
               }
               else
               {
               $UploadTargetFileName = $ObelixFileNameArray[5];
               }
               if(@move_uploaded_file($UploadFileArray[5], $UploadTargetFileName)) {
                  if(file_exists($UploadTargetFileName)) {
                     if(is_writeable($UploadTargetFileName)) {
                        chmod($UploadTargetFileName, $UploadDetailsArray[4]);
                        $UploadMessages .="        <tr>\n";
                        $UploadMessages .="          <td colspan=\"3\" class=\"red\">" . $UploadMessagesArray[1] . " " . $UploadTargetFileName . "</td>\n";
                        $UploadMessages .="        </tr>\n";
                        $UploadMessages .="        <tr>\n";
                        $UploadMessages .="          <td colspan=\"3\"><hr></td>\n";
                        $UploadMessages .="        </tr>\n";
                     }
                     else
                     {
                        $UploadMessages .="        <tr>\n";
                        $UploadMessages .="          <td colspan=\"3\" class=\"red\">" . $UploadMessagesArray[3] . " " . $UploadTargetFileName . "</td>\n";
                        $UploadMessages .="        </tr>\n";
                        $UploadMessages .="        <tr>\n";
                        $UploadMessages .="          <td colspan=\"3\"><hr></td>\n";
                        $UploadMessages .="        </tr>\n";
                     }
                  }
                  else
                  {
                     $UploadMessages .="        <tr>\n";
                     $UploadMessages .="          <td colspan=\"3\" class=\"red\">" . $UploadMessagesArray[4] . " " . $UploadTargetFileName . "</td>\n";
                     $UploadMessages .="        </tr>\n";
                     $UploadMessages .="        <tr>\n";
                     $UploadMessages .="          <td colspan=\"3\"><hr></td>\n";
                     $UploadMessages .="        </tr>\n";
                  }
               }
               else
               {
                  $UploadMessages .="        <tr>\n";
                  $UploadMessages .="          <td colspan=\"3\" class=\"red\">" . $UploadMessagesArray[2] . " " . $UploadFileArray[2] . "</td>\n";
                  $UploadMessages .="        </tr>\n";
                  $UploadMessages .="        <tr>\n";
                  $UploadMessages .="          <td colspan=\"3\"><hr></td>\n";
                  $UploadMessages .="        </tr>\n";
               }
            }
            else
            {
               $UploadMessages .="        <tr>\n";
               $UploadMessages .="          <td colspan=\"3\" class=\"red\">" . $UploadMessagesArray[5] . " " . $UploadFileArray[2] . "</td>\n";
               $UploadMessages .="        </tr>\n";
               $UploadMessages .="        <tr>\n";
               $UploadMessages .="          <td colspan=\"3\"><hr></td>\n";
               $UploadMessages .="        </tr>\n";
            }
         }
      } elseif(!empty($UploadFileArray[1]) &&
         !empty($UploadFileArray[2]) &&
         !empty($UploadFileArray[4]) &&
         !empty($UploadFileArray[5]) &&
         isset($UploadFileArray[6]) &&
         $UploadFileArray[6] == 0) {
         if($UploadFileArray[4] > 10 && $UploadFileArray[4] <= $UploadDetailsArray[5]) {
            if(@move_uploaded_file($UploadFileArray[5], $UploadFileArray[2])) {
               if(file_exists($UploadFileArray[2])) {
                  if(is_writeable($UploadFileArray[2])) {
                     chmod($UploadFileArray[2], $UploadDetailsArray[4]);
                     $UploadMessages .="        <tr>\n";
                     $UploadMessages .="          <td colspan=\"3\" class=\"red\">" . $UploadMessagesArray[1] . " " . $UploadFileArray[2] . "</td>\n";
                     $UploadMessages .="        </tr>\n";
                     $UploadMessages .="        <tr>\n";
                     $UploadMessages .="          <td colspan=\"3\"><hr></td>\n";
                     $UploadMessages .="        </tr>\n";
                  }
                  else
                  {
                     $UploadMessages .="        <tr>\n";
                     $UploadMessages .="          <td colspan=\"3\" class=\"red\">" . $UploadMessagesArray[3] . " " . $UploadFileArray[2] . "</td>\n";
                     $UploadMessages .="        </tr>\n";
                     $UploadMessages .="        <tr>\n";
                     $UploadMessages .="          <td colspan=\"3\"><hr></td>\n";
                     $UploadMessages .="        </tr>\n";
                  }
               }
               else
               {
                  $UploadMessages .="        <tr>\n";
                  $UploadMessages .="          <td colspan=\"3\" class=\"red\">" . $UploadMessagesArray[4] . " " . $UploadFileArray[2] . "</td>\n";
                  $UploadMessages .="        </tr>\n";
                  $UploadMessages .="        <tr>\n";
                  $UploadMessages .="          <td colspan=\"3\"><hr></td>\n";
                  $UploadMessages .="        </tr>\n";
               }
            }
            else
            {
               $UploadMessages .="        <tr>\n";
               $UploadMessages .="          <td colspan=\"3\" class=\"red\">" . $UploadMessagesArray[2] . " " . $UploadFileArray[2] . "</td>\n";
               $UploadMessages .="        </tr>\n";
               $UploadMessages .="        <tr>\n";
               $UploadMessages .="          <td colspan=\"3\"><hr></td>\n";
               $UploadMessages .="        </tr>\n";
            }
         }
         else
         {
            $UploadMessages .="        <tr>\n";
            $UploadMessages .="          <td colspan=\"3\" class=\"red\">" . $UploadMessagesArray[6] . " " . $UploadFileArray[2] . "</td>\n";
            $UploadMessages .="        </tr>\n";
            $UploadMessages .="        <tr>\n";
            $UploadMessages .="          <td colspan=\"3\"><hr></td>\n";
            $UploadMessages .="        </tr>\n";
         }
      }
   } elseif(!isset($ObelixFileNameArray) ||
      !is_array($ObelixFileNameArray) ||
      $ObelixFileNameArrayDefaultCount != $ObelixFileNameArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY ObelixFileNameArray (ARRAY-COUNT) - function <strong>create_upload</strong> - IS DAMAGED!';
      exit;
   } elseif(!isset($UploadDetailsArray) ||
      !is_array($UploadDetailsArray) ||
      $UploadDetailsArrayDefaultCount != $UploadDetailsArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY UploadDetailsArray (ARRAY-COUNT) - function <strong>create_upload</strong> - IS DAMAGED!';
      exit;
   } elseif(!isset($UploadFileArray) ||
      !is_array($UploadFileArray) ||
      $UploadFileArrayDefaultCount != $UploadFileArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY UploadFileArray (ARRAY-COUNT) - function <strong>create_upload</strong> - IS DAMAGED!';
      exit;
   }
   else
   {
      print 'NOTE: SYSTEM-ARRAY UploadMessagesArray (ARRAY-COUNT) - function <strong>create_upload</strong> - IS DAMAGED!';
      exit;
   }
   $MainContent="    <form name=\"form_upload\" enctype=\"multipart/form-data\" method=\"post\" action=\"" . $ObelixFileNameArray[4] . "?OBELIX_ID=" . $UploadDetailsArray[0] . "&ACCESS_ID=" . $UploadDetailsArray[1] . "\" target=\"_self\">\n";
   $MainContent .="      <table>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\" class=\"center\"><h3>" . $UploadDetailsArray[2] . "</h3></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">" . $UploadDetailsArray[3] . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\"><hr></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .= $UploadMessages;
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="          <td class=\"right\">" . $UploadDetailsArray[6] . "</td>\n";
   $MainContent .="          <td><input type=\"file\" name=\"UPLOAD_FILE\"></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="          <td class=\"right\"><input type=\"checkbox\" name=\"OBELIX_CHECK_FILE\" value=\"1\" checked></td>\n";
   $MainContent .="          <td>" . $UploadDetailsArray[7] . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\" class=\"center\"><input type=\"submit\" name=\"upload_button\" value=\"" . $UploadDetailsArray[8] . "\"></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="      </table>\n";
   $MainContent .="    </form>\n";
   return $MainContent;
}

// CSS - Navigation: UPLOAD
function create_upload_css() {
   $UploadCSS="h3 {\n  font-size: 1.15em;\n  font-weight: bold;\n}\n\n";
   $UploadCSS .="table { width: 100%; }\n\n";
   $UploadCSS .="td { font-size: 0.9em; }\n\n";
   $UploadCSS .="hr { width: 100%; }\n\n";
   $UploadCSS .=".red {\n  font-size: 0.95em;\n  font-weight: bold;\n  text-align: center;\n  color:#DD0000;\n}\n\n";
   $UploadCSS .=".right { text-align: right; }\n\n";
   return $UploadCSS;
}

// Erstellung der Webseite  UNPACK
function create_unpack($ObelixFileNameArray='', $UnpackFileArray='', $UnpackFileTypeArray='', $UnpackDetailsArray='', $UnpackMessagesArray='') {
   if(empty($UnpackDetailsArray[0])) $UnpackDetailsArray[0]=0;
   if(empty($UnpackDetailsArray[1])) $UnpackDetailsArray[1]=0;
   $UnpackMessages='';
   $ObelixFileNameArrayDefaultCount=15; // Vorgabe: Anzahl der Array-Elemente
   $ObelixFileNameArrayCurrentCount=count($ObelixFileNameArray);
   $UnpackFileArrayDefaultCount=3; // Vorgabe: Anzahl der Array-Elemente
   $UnpackFileArrayCurrentCount=count($UnpackFileArray);
   $UnpackFileTypeArrayDefaultCount=7; // Vorgabe: Anzahl der Array-Elemente
   $UnpackFileTypeArrayCurrentCount=count($UnpackFileTypeArray);
   $UnpackDetailsArrayDefaultCount=7; // Vorgabe: Anzahl der Array-Elemente
   $UnpackDetailsArrayCurrentCount=count($UnpackDetailsArray);
   $UnpackMessagesArrayDefaultCount=15; // Vorgabe: Anzahl der Array-Elemente
   $UnpackMessagesArrayCurrentCount=count($UnpackMessagesArray);
   if(isset($ObelixFileNameArray) &&
      is_array($ObelixFileNameArray) &&
      $ObelixFileNameArrayDefaultCount == $ObelixFileNameArrayCurrentCount &&
      isset($UnpackFileArray) &&
      is_array($UnpackFileArray) &&
      $UnpackFileArrayDefaultCount == $UnpackFileArrayCurrentCount &&
      isset($UnpackFileTypeArray) &&
      is_array($UnpackFileTypeArray) &&
      $UnpackFileTypeArrayDefaultCount == $UnpackFileTypeArrayCurrentCount &&
      isset($UnpackDetailsArray) &&
      is_array($UnpackDetailsArray) &&
      $UnpackDetailsArrayDefaultCount == $UnpackDetailsArrayCurrentCount &&
      isset($UnpackMessagesArray) &&
      is_array($UnpackMessagesArray) &&
      $UnpackMessagesArrayDefaultCount == $UnpackMessagesArrayCurrentCount) {
      $UnpackZipTarget = './';
      $FunctionsDisable=@ini_get('disable_functions');
      if(is_dir('./') && is_writeable('./')) {
         if(isset($UnpackFileArray[0]) &&
            preg_match("/^[0]$/",$UnpackFileArray[0]) &&
            !empty($UnpackFileArray[2]) &&
            file_exists($ObelixFileNameArray[0]) &&
            is_readable($ObelixFileNameArray[0])) {
            $FileNameZip = getcwd() . "/" . basename($ObelixFileNameArray[0]);
            if(extension_loaded("zlib") && function_exists("zip_open")) {
               if(file_exists($FileNameZip) &&
                  is_readable($FileNameZip) &&
                  $Zip = zip_open($FileNameZip)) {
                  while($ZipEntry = zip_read($Zip)) {
                     $FileName = zip_entry_name($ZipEntry);
                     $FileSize = zip_entry_filesize($ZipEntry);
                     $CompMeth = zip_entry_compressionmethod($ZipEntry);
                     if(zip_entry_open($Zip, $ZipEntry, 'rb')) {
                        $Buffer = zip_entry_read($ZipEntry, $FileSize);
                        if(preg_match('/\/$/', $FileName) && ($CompMeth == 'stored')) {
                           if(!is_dir($UnpackZipTarget . $FileName)) @mkdir($UnpackZipTarget . $FileName, $UnpackDetailsArray[4]);
                        }
                        else
                        {
                           $Fp = fopen($UnpackZipTarget . $FileName, 'wb');
                           fwrite($Fp, $Buffer);
                           fclose($Fp);
                        }
                        zip_entry_close($ZipEntry);
                     }
                  }
                  zip_close($Zip);
                  clearstatcache();
                  $UnpackMessagesAdd = $UnpackMessagesArray[0] . " " . basename($FileNameZip) . "<br>";
                  if(!empty($UnpackFileArray[1]) && preg_match("/^[1]$/", $UnpackFileArray[1])) {
                     @unlink($ObelixFileNameArray[0]);
                     if(!file_exists($ObelixFileNameArray[0])) {
                        $UnpackMessages .="        <tr>\n";
                        $UnpackMessages .="          <td colspan=\"3\" class=\"red\">" . $UnpackMessagesAdd . $UnpackMessagesArray[2] . "</td>\n";
                        $UnpackMessages .="        </tr>\n";
                        $UnpackMessages .="        <tr>\n";
                        $UnpackMessages .="          <td colspan=\"3\"><hr></td>\n";
                        $UnpackMessages .="        </tr>\n";
                     }
                     else
                     {
                        $UnpackMessages .="        <tr>\n";
                        $UnpackMessages .="          <td colspan=\"3\" class=\"red\">" . $UnpackMessagesAdd . $UnpackMessagesArray[3] . "</td>\n";
                        $UnpackMessages .="        </tr>\n";
                        $UnpackMessages .="        <tr>\n";
                        $UnpackMessages .="          <td colspan=\"3\"><hr></td>\n";
                        $UnpackMessages .="        </tr>\n";
                     }
                  }
                  else
                  {
                     $UnpackMessages .="        <tr>\n";
                     $UnpackMessages .="          <td colspan=\"3\" class=\"red\">" . $UnpackMessagesArray[0] . " " . basename($ObelixFileNameArray[0]) . "</td>\n";
                     $UnpackMessages .="        </tr>\n";
                     $UnpackMessages .="        <tr>\n";
                     $UnpackMessages .="          <td colspan=\"3\"><hr></td>\n";
                     $UnpackMessages .="        </tr>\n";
                  }
               }
               else
               {
                  $UnpackMessages .="        <tr>\n";
                  $UnpackMessages .="          <td colspan=\"3\" class=\"red\">" . $UnpackMessagesArray[4] . " " . basename($ObelixFileNameArray[0]) . "</td>\n";
                  $UnpackMessages .="        </tr>\n";
                  $UnpackMessages .="        <tr>\n";
                  $UnpackMessages .="          <td colspan=\"3\"><hr></td>\n";
                  $UnpackMessages .="        </tr>\n";
               }
            } elseif(!preg_match("/exec/",$FunctionsDisable)) {
               $UnpackLinuxCommand = "unzip -q " . $ObelixFileNameArray[0];
               @exec($UnpackLinuxCommand, $LinuxCommandMessageArray, $ExitStatusUnzip);
               if($ExitStatusUnzip == 0) {
                  $UnpackMessagesAdd = $UnpackMessagesArray[0] . " " . basename($ObelixFileNameArray[0]) . "<br>";
                  if(!empty($UnpackFileArray[1]) && preg_match("/^[1]$/", $UnpackFileArray[1])) {
                     $UnpackLinuxCommandRm = "rm -f " . $ObelixFileNameArray[0];
                     @exec($UnpackLinuxCommandRm, $LinuxCommandMessageArray, $ExitStatusRm);
                     if($ExitStatusRm == 0) {
                        $UnpackMessages .="        <tr>\n";
                        $UnpackMessages .="          <td colspan=\"3\" class=\"red\">" . $UnpackMessagesAdd . $UnpackMessagesArray[2] . "</td>\n";
                        $UnpackMessages .="        </tr>\n";
                        $UnpackMessages .="        <tr>\n";
                        $UnpackMessages .="          <td colspan=\"3\"><hr></td>\n";
                        $UnpackMessages .="        </tr>\n";
                     }
                     else
                     {
                        $UnpackMessages .="        <tr>\n";
                        $UnpackMessages .="          <td colspan=\"3\" class=\"red\">" . $UnpackMessagesAdd . $UnpackMessagesArray[3] . "</td>\n";
                        $UnpackMessages .="        </tr>\n";
                        $UnpackMessages .="        <tr>\n";
                        $UnpackMessages .="          <td colspan=\"3\"><hr></td>\n";
                        $UnpackMessages .="        </tr>\n";
                     }
                  }
                  else
                  {
                     $UnpackMessages .="        <tr>\n";
                     $UnpackMessages .="          <td colspan=\"3\" class=\"red\">" . $UnpackMessagesArray[0] . " " . basename($ObelixFileNameArray[0]) . "</td>\n";
                     $UnpackMessages .="        </tr>\n";
                     $UnpackMessages .="        <tr>\n";
                     $UnpackMessages .="          <td colspan=\"3\"><hr></td>\n";
                     $UnpackMessages .="        </tr>\n";
                  }
               }
               else
               {
                  $UnpackMessages .="        <tr>\n";
                  $UnpackMessages .="          <td colspan=\"3\" class=\"red\">" . $UnpackMessagesArray[1] . " " . basename($ObelixFileNameArray[0]) . "</td>\n";
                  $UnpackMessages .="        </tr>\n";
                  $UnpackMessages .="        <tr>\n";
                  $UnpackMessages .="          <td colspan=\"3\"><hr></td>\n";
                  $UnpackMessages .="        </tr>\n";
               }
            }
            else
            {
               $UnpackMessages .="        <tr>\n";
               $UnpackMessages .="          <td colspan=\"3\" class=\"red\">" . $UnpackMessagesArray[5] . "</td>\n";
               $UnpackMessages .="        </tr>\n";
               $UnpackMessages .="        <tr>\n";
               $UnpackMessages .="          <td colspan=\"3\"><hr></td>\n";
               $UnpackMessages .="        </tr>\n";
            }
         } elseif(isset($UnpackFileArray[0]) &&
            preg_match("/^[5]$/", $UnpackFileArray[0]) &&
            !empty($UnpackFileArray[2]) &&
            file_exists($ObelixFileNameArray[5]) &&
            is_readable($ObelixFileNameArray[5])) {
            if(!preg_match("/exec/",$FunctionsDisable)) {
               $UnpackLinuxCommand = "tar -xzf " . $ObelixFileNameArray[5];
               @exec($UnpackLinuxCommand, $LinuxCommandMessageArray, $ExitStatusTar);
               if($ExitStatusTar == 0) {
                  $UnpackMessagesAdd = $UnpackMessagesArray[6] . " " . basename($ObelixFileNameArray[5]) . "<br>";
                  if(!empty($UnpackFileArray[1]) && preg_match("/^[1]$/", $UnpackFileArray[1])) {
                     $UnpackLinuxCommandRm="rm -f " . $ObelixFileNameArray[5];
                     @exec($UnpackLinuxCommandRm, $LinuxCommandMessageArray, $ExitStatusRm);
                     if($ExitStatusRm == 0) {
                        $UnpackMessages .="        <tr>\n";
                        $UnpackMessages .="          <td colspan=\"3\" class=\"red\">" . $UnpackMessagesAdd . $UnpackMessagesArray[8] . "</td>\n";
                        $UnpackMessages .="        </tr>\n";
                        $UnpackMessages .="        <tr>\n";
                        $UnpackMessages .="          <td colspan=\"3\"><hr></td>\n";
                        $UnpackMessages .="        </tr>\n";
                     }
                     else
                     {
                        $UnpackMessages .="        <tr>\n";
                        $UnpackMessages .="          <td colspan=\"3\" class=\"red\">" . $UnpackMessagesAdd . $UnpackMessagesArray[9] . "</td>\n";
                        $UnpackMessages .="        </tr>\n";
                        $UnpackMessages .="        <tr>\n";
                        $UnpackMessages .="          <td colspan=\"3\"><hr></td>\n";
                        $UnpackMessages .="        </tr>\n";
                     }
                  }
                  else
                  {
                     $UnpackMessages .="        <tr>\n";
                     $UnpackMessages .="          <td colspan=\"3\" class=\"red\">" . $UnpackMessagesArray[6] . " " . basename($ObelixFileNameArray[5]) . "</td>\n";
                     $UnpackMessages .="        </tr>\n";
                     $UnpackMessages .="        <tr>\n";
                     $UnpackMessages .="          <td colspan=\"3\"><hr></td>\n";
                     $UnpackMessages .="        </tr>\n";
                  }
               }
               else
               {
                  $UnpackMessages .="        <tr>\n";
                  $UnpackMessages .="          <td colspan=\"3\" class=\"red\">" . $UnpackMessagesArray[7] . " " . basename($ObelixFileNameArray[5]) . "</td>\n";
                  $UnpackMessages .="        </tr>\n";
                  $UnpackMessages .="        <tr>\n";
                  $UnpackMessages .="          <td colspan=\"3\"><hr></td>\n";
                  $UnpackMessages .="        </tr>\n";
               }
            }
            else
            {
               $UnpackMessages .="        <tr>\n";
               $UnpackMessages .="          <td colspan=\"3\" class=\"red\">" . $UnpackMessagesArray[10] . "</td>\n";
               $UnpackMessages .="        </tr>\n";
               $UnpackMessages .="        <tr>\n";
               $UnpackMessages .="          <td colspan=\"3\"><hr></td>\n";
               $UnpackMessages .="        </tr>\n";
            }
         } elseif(isset($UnpackFileArray[0]) &&
            preg_match("/^[6]$/", $UnpackFileArray[0]) &&
            !empty($UnpackFileArray[2]) &&
            file_exists($ObelixFileNameArray[6]) &&
            is_readable($ObelixFileNameArray[6])) {
            if(!preg_match("/exec/",$FunctionsDisable)) {
               $UnpackLinuxCommand = "gunzip -f -k -N " . $ObelixFileNameArray[6];
               @exec($UnpackLinuxCommand, $LinuxCommandMessageArray, $ExitStatusGz);
               if($ExitStatusGz == 0) {
                  $UnpackMessagesAdd = $UnpackMessagesArray[6] . " " . basename($ObelixFileNameArray[6]) . "<br>";
                  if(!empty($UnpackFileArray[1]) && preg_match("/^[1]$/", $UnpackFileArray[1])) {
                     $UnpackLinuxCommandRm="rm -f " . $ObelixFileNameArray[6];
                     @exec($UnpackLinuxCommandRm, $LinuxCommandMessageArray, $ExitStatusRm);
                     if($ExitStatusRm == 0) {
                        $UnpackMessages .="        <tr>\n";
                        $UnpackMessages .="          <td colspan=\"3\" class=\"red\">" . $UnpackMessagesAdd . $UnpackMessagesArray[8] . "</td>\n";
                        $UnpackMessages .="        </tr>\n";
                        $UnpackMessages .="        <tr>\n";
                        $UnpackMessages .="          <td colspan=\"3\"><hr></td>\n";
                        $UnpackMessages .="        </tr>\n";
                     }
                     else
                     {
                        $UnpackMessages .="        <tr>\n";
                        $UnpackMessages .="          <td colspan=\"3\" class=\"red\">" . $UnpackMessagesAdd . $UnpackMessagesArray[9] . "</td>\n";
                        $UnpackMessages .="        </tr>\n";
                        $UnpackMessages .="        <tr>\n";
                        $UnpackMessages .="          <td colspan=\"3\"><hr></td>\n";
                        $UnpackMessages .="        </tr>\n";
                     }
                  }
                  else
                  {
                     $UnpackMessages .="        <tr>\n";
                     $UnpackMessages .="          <td colspan=\"3\" class=\"red\">" . $UnpackMessagesArray[6] . " " . basename($ObelixFileNameArray[6]) . "</td>\n";
                     $UnpackMessages .="        </tr>\n";
                     $UnpackMessages .="        <tr>\n";
                     $UnpackMessages .="          <td colspan=\"3\"><hr></td>\n";
                     $UnpackMessages .="        </tr>\n";
                  }
               }
               else
               {
                  $UnpackMessages .="        <tr>\n";
                  $UnpackMessages .="          <td colspan=\"3\" class=\"red\">" . $UnpackMessagesArray[7] . " " . basename($ObelixFileNameArray[6]) . "</td>\n";
                  $UnpackMessages .="        </tr>\n";
                  $UnpackMessages .="        <tr>\n";
                  $UnpackMessages .="          <td colspan=\"3\"><hr></td>\n";
                  $UnpackMessages .="        </tr>\n";
               }
            }
            else
            {
               $UnpackMessages .="        <tr>\n";
               $UnpackMessages .="          <td colspan=\"3\" class=\"red\">" . $UnpackMessagesArray[10] . "</td>\n";
               $UnpackMessages .="        </tr>\n";
               $UnpackMessages .="        <tr>\n";
               $UnpackMessages .="          <td colspan=\"3\"><hr></td>\n";
               $UnpackMessages .="        </tr>\n";
            }
         } elseif(file_exists($ObelixFileNameArray[0]) && !is_readable($ObelixFileNameArray[0])) {
            $UnpackMessages .="        <tr>\n";
            $UnpackMessages .="          <td colspan=\"3\" class=\"red\">" . $UnpackMessagesArray[4] . "</td>\n";
            $UnpackMessages .="        </tr>\n";
            $UnpackMessages .="        <tr>\n";
            $UnpackMessages .="          <td colspan=\"3\"><hr></td>\n";
            $UnpackMessages .="        </tr>\n";
         } elseif(file_exists($ObelixFileNameArray[5]) && !is_readable($ObelixFileNameArray[5])) {
            $UnpackMessages .="        <tr>\n";
            $UnpackMessages .="          <td colspan=\"3\" class=\"red\">" . $UnpackMessagesArray[4] . "</td>\n";
            $UnpackMessages .="        </tr>\n";
            $UnpackMessages .="        <tr>\n";
            $UnpackMessages .="          <td colspan=\"3\"><hr></td>\n";
            $UnpackMessages .="        </tr>\n";
         } elseif(file_exists($ObelixFileNameArray[6]) && !is_readable($ObelixFileNameArray[6])) {
            $UnpackMessages .="        <tr>\n";
            $UnpackMessages .="          <td colspan=\"3\" class=\"red\">" . $UnpackMessagesArray[4] . "</td>\n";
            $UnpackMessages .="        </tr>\n";
            $UnpackMessages .="        <tr>\n";
            $UnpackMessages .="          <td colspan=\"3\"><hr></td>\n";
            $UnpackMessages .="        </tr>\n";
         }
      }
      else
      {
         $UnpackMessages .="        <tr>\n";
         $UnpackMessages .="          <td colspan=\"3\" class=\"red\">" . $UnpackMessagesArray[14] . "</td>\n";
         $UnpackMessages .="        </tr>\n";
         $UnpackMessages .="        <tr>\n";
         $UnpackMessages .="          <td colspan=\"3\"><hr></td>\n";
         $UnpackMessages .="        </tr>\n";
      }
   } elseif(!isset($ObelixFileNameArray) ||
      !is_array($ObelixFileNameArray) ||
      $ObelixFileNameArrayDefaultCount != $ObelixFileNameArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY ObelixFileNameArray (ARRAY-COUNT) - function <strong>create_unpack</strong> - IS DAMAGED!';
      exit;
   } elseif(!isset($UnpackFileArray) ||
      !is_array($UnpackFileArray) ||
      $UnpackFileArrayDefaultCount != $UnpackFileArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY UnpackFileArray (ARRAY-COUNT) - function <strong>create_unpack</strong> - IS DAMAGED!';
      exit;
   } elseif(!isset($UnpackFileTypeArray) ||
      !is_array($UnpackFileTypeArray) ||
      $UnpackFileTypeArrayDefaultCount != $UnpackFileTypeArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY UnpackFileTypeArray (ARRAY-COUNT) - function <strong>create_unpack</strong> - IS DAMAGED!';
      exit;
   } elseif(!isset($UnpackDetailsArray) ||
      !is_array($UnpackDetailsArray) ||
      $UnpackDetailsArrayDefaultCount != $UnpackDetailsArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY UnpackDetailsArray (ARRAY-COUNT) - function <strong>create_unpack</strong> - IS DAMAGED!';
      exit;
   }
   else
   {
      print 'NOTE: SYSTEM-ARRAY UnpackMessagesArray (ARRAY-COUNT) - function <strong>create_unpack</strong> - IS DAMAGED!';
      exit;
   }
   // MIME-Typ der gefundenen ZIP-Datei pruefen
   $UnpackFileTypeArrayCount = count($UnpackFileTypeArray);
   if(file_exists($ObelixFileNameArray[0]) && is_readable($ObelixFileNameArray[0])) {
      $UnpackZipFileMimeType = mime_content_type($ObelixFileNameArray[0]);
      for($x=0; $x<$UnpackFileTypeArrayCount; $x++) {
         $UnpackFileTypeZipComparison = strcasecmp($UnpackZipFileMimeType, $UnpackFileTypeArray[$x]);
         if($UnpackFileTypeZipComparison == 0) {
            $ReturnCodeZipComparison=1;
            break;
         }
      }
   }
   // MIME-Typ der gefundenen TAR-GZIP-Datei pruefen
   if(file_exists($ObelixFileNameArray[5]) && is_readable($ObelixFileNameArray[5])) {
      $UnpackTarGzipFileMimeType = mime_content_type($ObelixFileNameArray[5]);
      for($y=0; $y<$UnpackFileTypeArrayCount; $y++) {
         $UnpackFileTypeGzipComparison = strcasecmp($UnpackTarGzipFileMimeType, $UnpackFileTypeArray[$y]);
         if($UnpackFileTypeGzipComparison == 0) {
            $ReturnCodeTarGzipComparison=1;
            break;
         }
      }
   }
   // MIME-Typ der gefundenen GZIP-Datei pruefen
   if(file_exists($ObelixFileNameArray[6]) && is_readable($ObelixFileNameArray[6])) {
      $UnpackGzipFileMimeType = mime_content_type($ObelixFileNameArray[6]);
      for($z=0; $z<$UnpackFileTypeArrayCount; $z++) {
         $UnpackFileTypeGzipComparison = strcasecmp($UnpackGzipFileMimeType, $UnpackFileTypeArray[$z]);
         if($UnpackFileTypeGzipComparison == 0) {
            $ReturnCodeGzipComparison=1;
            break;
         }
      }
   }
   $MainContent="    <form name=\"form_unpack\" enctype=\"multipart/form-data\" method=\"post\" action=\"" . $ObelixFileNameArray[4] . "?OBELIX_ID=" . $UnpackDetailsArray[0] . "&ACCESS_ID=" . $UnpackDetailsArray[1] . "\" target=\"_self\">\n";
   $MainContent .="      <table>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\" class=\"center\"><h3>" . $UnpackDetailsArray[2] . "</h3></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">" . $UnpackDetailsArray[3] . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\"><hr></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .= $UnpackMessages;
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   if((file_exists($ObelixFileNameArray[0]) && is_readable($ObelixFileNameArray[0]) && !empty($ReturnCodeZipComparison)) ||
      (file_exists($ObelixFileNameArray[5]) && is_readable($ObelixFileNameArray[5]) && !empty($ReturnCodeTarGzipComparison)) ||
      (file_exists($ObelixFileNameArray[6]) && is_readable($ObelixFileNameArray[6]) && !empty($ReturnCodeGzipComparison))) {
      $MainContent .="        <tr>\n";
      $MainContent .="          <td colspan=\"3\" class=\"center\">" . $UnpackMessagesArray[11] . "</td>\n";
      $MainContent .="        </tr>\n";
      $MainContent .="        <tr>\n";
      $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
      $MainContent .="        </tr>\n";
   }
   if((file_exists($ObelixFileNameArray[0]) && is_readable($ObelixFileNameArray[0]) && !empty($ReturnCodeZipComparison)) &&
      (file_exists($ObelixFileNameArray[5]) && is_readable($ObelixFileNameArray[5]) && !empty($ReturnCodeTarGzipComparison)) &&
      (file_exists($ObelixFileNameArray[6]) && is_readable($ObelixFileNameArray[6]) && !empty($ReturnCodeGzipComparison))) {
      $MainContent .="        <tr>\n";
      $MainContent .="          <td>&nbsp;</td>\n";
      $MainContent .="          <td class=\"right\"><input type=\"radio\" name=\"OBELIX_ARCHIV_NR\" value=\"0\" checked></td>\n";
      $MainContent .="          <td>" . basename($ObelixFileNameArray[0]) . "</td>\n";
      $MainContent .="        </tr>\n";
      $MainContent .="        <tr>\n";
      $MainContent .="          <td>&nbsp;</td>\n";
      $MainContent .="          <td class=\"right\"><input type=\"radio\" name=\"OBELIX_ARCHIV_NR\" value=\"5\"></td>\n";
      $MainContent .="          <td>" . basename($ObelixFileNameArray[5]) . "</td>\n";
      $MainContent .="        </tr>\n";
      $MainContent .="        <tr>\n";
      $MainContent .="          <td>&nbsp;</td>\n";
      $MainContent .="          <td class=\"right\"><input type=\"radio\" name=\"OBELIX_ARCHIV_NR\" value=\"6\"></td>\n";
      $MainContent .="          <td>" . basename($ObelixFileNameArray[6]) . "</td>\n";
      $MainContent .="        </tr>\n";
   } elseif((file_exists($ObelixFileNameArray[0]) && is_readable($ObelixFileNameArray[0]) && !empty($ReturnCodeZipComparison)) &&
      (file_exists($ObelixFileNameArray[5]) && is_readable($ObelixFileNameArray[5]) && !empty($ReturnCodeTarGzipComparison))) {
      $MainContent .="        <tr>\n";
      $MainContent .="          <td>&nbsp;</td>\n";
      $MainContent .="          <td class=\"right\"><input type=\"radio\" name=\"OBELIX_ARCHIV_NR\" value=\"0\" checked></td>\n";
      $MainContent .="          <td>" . basename($ObelixFileNameArray[0]) . "</td>\n";
      $MainContent .="        </tr>\n";
      $MainContent .="        <tr>\n";
      $MainContent .="          <td>&nbsp;</td>\n";
      $MainContent .="          <td class=\"right\"><input type=\"radio\" name=\"OBELIX_ARCHIV_NR\" value=\"5\"></td>\n";
      $MainContent .="          <td>" . basename($ObelixFileNameArray[5]) . "</td>\n";
      $MainContent .="        </tr>\n";
   } elseif((file_exists($ObelixFileNameArray[0]) && is_readable($ObelixFileNameArray[0]) && !empty($ReturnCodeZipComparison)) &&
      (file_exists($ObelixFileNameArray[6]) && is_readable($ObelixFileNameArray[6]) && !empty($ReturnCodeGzipComparison))) {
      $MainContent .="        <tr>\n";
      $MainContent .="          <td>&nbsp;</td>\n";
      $MainContent .="          <td class=\"right\"><input type=\"radio\" name=\"OBELIX_ARCHIV_NR\" value=\"0\" checked></td>\n";
      $MainContent .="          <td>" . basename($ObelixFileNameArray[0]) . "</td>\n";
      $MainContent .="        </tr>\n";
      $MainContent .="        <tr>\n";
      $MainContent .="          <td>&nbsp;</td>\n";
      $MainContent .="          <td class=\"right\"><input type=\"radio\" name=\"OBELIX_ARCHIV_NR\" value=\"6\"></td>\n";
      $MainContent .="          <td>" . basename($ObelixFileNameArray[6]) . "</td>\n";
      $MainContent .="        </tr>\n";
   } elseif((file_exists($ObelixFileNameArray[5]) && is_readable($ObelixFileNameArray[5]) && !empty($ReturnCodeTarGzipComparison)) &&
      (file_exists($ObelixFileNameArray[6]) && is_readable($ObelixFileNameArray[6]) && !empty($ReturnCodeGzipComparison))) {
      $MainContent .="        <tr>\n";
      $MainContent .="          <td>&nbsp;</td>\n";
      $MainContent .="          <td class=\"right\"><input type=\"radio\" name=\"OBELIX_ARCHIV_NR\" value=\"5\"></td>\n";
      $MainContent .="          <td>" . basename($ObelixFileNameArray[5]) . "</td>\n";
      $MainContent .="        </tr>\n";
      $MainContent .="        <tr>\n";
      $MainContent .="          <td>&nbsp;</td>\n";
      $MainContent .="          <td class=\"right\"><input type=\"radio\" name=\"OBELIX_ARCHIV_NR\" value=\"6\"></td>\n";
      $MainContent .="          <td>" . basename($ObelixFileNameArray[6]) . "</td>\n";
      $MainContent .="        </tr>\n";
   } elseif(file_exists($ObelixFileNameArray[0]) && is_readable($ObelixFileNameArray[0]) && !empty($ReturnCodeZipComparison)) {
      $MainContent .="        <tr>\n";
      $MainContent .="          <td>&nbsp;</td>\n";
      $MainContent .="          <td class=\"right\"><input type=\"radio\" name=\"OBELIX_ARCHIV_NR\" value=\"0\" checked></td>\n";
      $MainContent .="          <td>" . basename($ObelixFileNameArray[0]) . "</td>\n";
      $MainContent .="        </tr>\n";
   } elseif(file_exists($ObelixFileNameArray[5]) && is_readable($ObelixFileNameArray[5]) && !empty($ReturnCodeTarGzipComparison)) {
      $MainContent .="        <tr>\n";
      $MainContent .="          <td>&nbsp;</td>\n";
      $MainContent .="          <td class=\"right\"><input type=\"radio\" name=\"OBELIX_ARCHIV_NR\" value=\"5\" checked></td>\n";
      $MainContent .="          <td>" . basename($ObelixFileNameArray[5]) . "</td>\n";
      $MainContent .="        </tr>\n";
   } elseif(file_exists($ObelixFileNameArray[6]) && is_readable($ObelixFileNameArray[6]) && !empty($ReturnCodeGzipComparison)) {
      $MainContent .="        <tr>\n";
      $MainContent .="          <td>&nbsp;</td>\n";
      $MainContent .="          <td class=\"right\"><input type=\"radio\" name=\"OBELIX_ARCHIV_NR\" value=\"6\" checked></td>\n";
      $MainContent .="          <td>" . basename($ObelixFileNameArray[6]) . "</td>\n";
      $MainContent .="        </tr>\n";
   } elseif(!empty($UnpackFileArray[2])) {
      $MainContent .="        <tr>\n";
      $MainContent .="          <td colspan=\"3\" class=\"center\">" . $UnpackMessagesArray[12] . "</td>\n";
      $MainContent .="        </tr>\n";
   }
   else
   {
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\" class=\"center\">" . $UnpackMessagesArray[13] . "</td>\n";
   $MainContent .="        </tr>\n";
   }
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   if((file_exists($ObelixFileNameArray[0]) && is_readable($ObelixFileNameArray[0]) && !empty($ReturnCodeZipComparison)) ||
      (file_exists($ObelixFileNameArray[5]) && is_readable($ObelixFileNameArray[5]) && !empty($ReturnCodeTarGzipComparison)) ||
      (file_exists($ObelixFileNameArray[6]) && is_readable($ObelixFileNameArray[6]) && !empty($ReturnCodeGzipComparison))) {
      $MainContent .="        <tr>\n";
      $MainContent .="          <td>&nbsp;</td>\n";
      $MainContent .="          <td class=\"right\"><input type=\"checkbox\" name=\"OBELIX_ARCHIV_DELETE\" value=\"1\" checked></td>\n";
      $MainContent .="          <td>" . $UnpackDetailsArray[5] . "</td>\n";
      $MainContent .="        </tr>\n";
      $MainContent .="        <tr>\n";
      $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
      $MainContent .="        </tr>\n";
      $MainContent .="        <tr>\n";
      $MainContent .="          <td colspan=\"3\" class=\"center\"><input type=\"submit\" name=\"UNPACK_BUTTON\" value=\"" . $UnpackDetailsArray[6] . "\"></td>\n";
      $MainContent .="        </tr>\n";
      $MainContent .="        <tr>\n";
      $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
      $MainContent .="        </tr>\n";
   }
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="      </table>\n";
   $MainContent .="    </form>\n";
   return $MainContent;
}

// CSS - Navigation: UNPACK
function create_unpack_css() {
   $UnpackCSS="h3 {\n  font-size: 1.15em;\n  font-weight: bold;\n  text-align: center;\n}\n\n";
   $UnpackCSS .="table { width: 100%; }\n\n";
   $UnpackCSS .="td { font-size: 0.9em; }\n\n";
   $UnpackCSS .="hr { width: 100%; }\n\n";
   $UnpackCSS .=".red {\n  font-size: 0.95em;\n  font-weight: bold;\n  text-align: center;\n  color:#DD0000;\n}\n\n";
   $UnpackCSS .=".right { text-align: right; }\n\n";
   return $UnpackCSS;
}

// Erstellung der Webseite  DELETE
function create_delete($ObelixFileNameArray='', $DeleteObelixFileArray='', $DeleteDetailsArray='', $DeleteMessagesArray='') {
   $DeleteMessages="";
   if(empty($DeleteDetailsArray[0])) $DeleteDetailsArray[0]=0;
   if(empty($DeleteDetailsArray[1])) $DeleteDetailsArray[1]=0;
   $ObelixFileNameArrayDefaultCount=15; // Vorgabe: Anzahl der Array-Elemente
   $ObelixFileNameArrayCurrentCount=count($ObelixFileNameArray);
   $DeleteDetailsArrayDefaultCount=5; // Vorgabe: Anzahl der Array-Elemente
   $DeleteDetailsArrayCurrentCount=count($DeleteDetailsArray);
   $DeleteMessagesArrayDefaultCount=3; // Vorgabe: Anzahl der Array-Elemente
   $DeleteMessagesArrayCurrentCount=count($DeleteMessagesArray);
   if(isset($ObelixFileNameArray) &&
      is_array($ObelixFileNameArray) &&
      $ObelixFileNameArrayDefaultCount == $ObelixFileNameArrayCurrentCount &&
      isset($DeleteDetailsArray) &&
      is_array($DeleteDetailsArray) &&
      $DeleteDetailsArrayDefaultCount == $DeleteDetailsArrayCurrentCount &&
      isset($DeleteMessagesArray) &&
      is_array($DeleteMessagesArray) &&
      $DeleteMessagesArrayDefaultCount == $DeleteMessagesArrayCurrentCount) {
      // Loeschung: Obelix-Dateien und Array mit den Verzeichnissen erstellen
      if(!empty($DeleteObelixFileArray) && is_array($DeleteObelixFileArray)) {
         $DeleteDirectoryArray=array();
         $DeleteFileArray=array();
         $DeleteDirectoryErrorArray=array();
         $DeleteFileErrorArray=array();
         $DeleteObelixFileArrayCount = count($DeleteObelixFileArray);
         for($x=0; $x<$DeleteObelixFileArrayCount; $x++) {
            if(!is_dir($DeleteObelixFileArray[$x]) && file_exists($DeleteObelixFileArray[$x])) {
               @unlink($DeleteObelixFileArray[$x]);
               if(file_exists($DeleteObelixFileArray[$x])) $DeleteFileErrorArray[] = $DeleteObelixFileArray[$x];
            } elseif(is_dir($DeleteObelixFileArray[$x])) {
               $DeleteDirectoryArray[] = $DeleteObelixFileArray[$x];
            }
         }
         // Verzeichnis-Array mit den Unterverzeichnissen vervollstaendigen, Datei-Array erstellen
         $DeleteDirectoryArrayCount = count($DeleteDirectoryArray);
         for($y=0; $y<$DeleteDirectoryArrayCount; $y++) {
            $DeleteFileHandle = @opendir($DeleteDirectoryArray[$y]);
            while($DeleteFileName = @readdir($DeleteFileHandle)) {
               if($DeleteFileName != "." && $DeleteFileName != "..") {
                  $DeleteFileNamePath = $DeleteDirectoryArray[$y] . "/" . $DeleteFileName;
                  if(is_dir($DeleteFileNamePath)) {
                     $DeleteDirectoryArray[] = $DeleteFileNamePath;
                     $DeleteDirectoryArrayCount = count($DeleteDirectoryArray);
                  }
                  else
                  {
                  $DeleteFileArray[] = $DeleteFileNamePath;
                  }
               }
            }
         }
         // Loeschung der Dateien (Array: DeleteFileArray)
         $DeleteFileArrayCount = count($DeleteFileArray);
         for($i=0; $i<$DeleteFileArrayCount; $i++) {
            if(file_exists($DeleteFileArray[$i])) @unlink($DeleteFileArray[$i]);
            if(file_exists($DeleteFileArray[$i])) $DeleteFileErrorArray[] = $DeleteFileArray[$i];
         }
         // Loeschung der Verzeichnisse (Array: DeleteDirectoryArray)
         sort($DeleteDirectoryArray);
         $DeleteDirectoryArray = array_reverse($DeleteDirectoryArray);
         $DeleteDirectoryArrayCount = count($DeleteDirectoryArray);
         for($j=0; $j<$DeleteDirectoryArrayCount; $j++) {
            if(is_dir($DeleteDirectoryArray[$j])) @rmdir($DeleteDirectoryArray[$j]);
            if(is_dir($DeleteDirectoryArray[$j])) $DeleteDirectoryErrorArray[] = $DeleteDirectoryArray[$j];
         }
         $DeleteDirectoryErrorArrayCount = count($DeleteDirectoryErrorArray);
         $DeleteFileErrorArrayCount = count($DeleteFileErrorArray);
         if($DeleteDirectoryErrorArrayCount >= 1 && $DeleteFileErrorArrayCount >= 1) {
            $DeleteMessages .="        <tr>\n";
            $DeleteMessages .="          <td colspan=\"3\" class=\"red\">" . $DeleteMessagesArray[0] . "</td>\n";
            $DeleteMessages .="        </tr>\n";
            $DeleteMessages .="        <tr>\n";
            $DeleteMessages .="          <td colspan=\"3\"><hr></td>\n";
            $DeleteMessages .="        </tr>\n";
         } elseif($DeleteDirectoryErrorArrayCount >= 1 && $DeleteFileErrorArrayCount == 0) {
            $DeleteMessages .="        <tr>\n";
            $DeleteMessages .="          <td colspan=\"3\" class=\"red\">" . $DeleteMessagesArray[1] . "</td>\n";
            $DeleteMessages .="        </tr>\n";
            $DeleteMessages .="        <tr>\n";
            $DeleteMessages .="          <td colspan=\"3\"><hr></td>\n";
            $DeleteMessages .="        </tr>\n";
         } elseif($DeleteDirectoryErrorArrayCount == 0 && $DeleteFileErrorArrayCount >= 1) {
            $DeleteMessages .="        <tr>\n";
            $DeleteMessages .="          <td colspan=\"3\" class=\"red\">" . $DeleteMessagesArray[2] . "</td>\n";
            $DeleteMessages .="        </tr>\n";
            $DeleteMessages .="        <tr>\n";
            $DeleteMessages .="          <td colspan=\"3\"><hr></td>\n";
            $DeleteMessages .="        </tr>\n";
         }
         clearstatcache();
      }
   } elseif(!isset($ObelixFileNameArray) ||
      !is_array($ObelixFileNameArray) ||
      $ObelixFileNameArrayDefaultCount != $ObelixFileNameArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY ObelixFileNameArray (ARRAY-COUNT) - function <strong>create_delete</strong> - IS DAMAGED!';
      exit;
   } elseif(!isset($DeleteDetailsArray) ||
      !is_array($DeleteDetailsArray) ||
      $DeleteDetailsArrayDefaultCount != $DeleteDetailsArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY DeleteDetailsArray (ARRAY-COUNT) - function <strong>create_delete</strong> - IS DAMAGED!';
      exit;
   }
   else
   {
      print 'NOTE: SYSTEM-ARRAY DeleteMessagesArray (ARRAY-COUNT) - function <strong>create_delete</strong> - IS DAMAGED!';
      exit;
   }
   $MainContent="    <form name=\"form_delete\" method=\"post\" action=\"" . $ObelixFileNameArray[4] . "?OBELIX_ID=" . $DeleteDetailsArray[0] . "&ACCESS_ID=" . $DeleteDetailsArray[1] . "\" target=\"_self\">\n";
   $MainContent .="      <table>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\" class=\"center\"><h3>" . $DeleteDetailsArray[2] . "</h3></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">" . $DeleteDetailsArray[3] . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\"><hr></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .= $DeleteMessages;
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $ObelixFileNameArrayCount = count($ObelixFileNameArray);
   for($z=0; $z<$ObelixFileNameArrayCount; $z++) {
      if(file_exists($ObelixFileNameArray[$z])) {
         $MainContent .="        <tr>\n";
         $MainContent .="          <td class=\"column_wide\">&nbsp;</td>\n";
         $MainContent .="          <td class=\"right\"><input type=\"checkbox\" name=\"OBELIX_DELETE[]\" value=\"" . $ObelixFileNameArray[$z] . "\" checked></td>\n";
         $MainContent .="          <td>" . basename($ObelixFileNameArray[$z]) . "</td>\n";
         $MainContent .="        </tr>\n";
      }
   }
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\" class=\"center\"><input type=\"submit\" name=\"OBELIX_DELETE_SUBMIT\" value=\"" . $DeleteDetailsArray[4] . "\"></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="      </table>\n";
   $MainContent .="    </form>\n";
   return $MainContent;
}

// CSS - Navigation: DELETE
function create_delete_css() {
   $DeleteCSS="h3 {\n  font-size: 1.15em;\n  font-weight: bold;\n}\n\n";
   $DeleteCSS .="table { width: 100%; }\n\n";
   $DeleteCSS .="td { font-size: 0.9em; }\n\n";
   $DeleteCSS .="hr { width: 100%; }\n\n";
   $DeleteCSS .=".column_wide { width: 25%; }\n\n";
   $DeleteCSS .=".red {\n  font-size: 0.95em;\n  font-weight: bold;\n  text-align: center;\n  color:#DD0000;\n}\n\n";
   $DeleteCSS .=".right { text-align: right; }\n\n";
   return $DeleteCSS;
}

// Erstellung der Webseite  HYPERLINK-LISTING
function create_hyperlink_listing($HyperlinkDetailsArray='', $HyperlinkMessagesArray='') {
   $HyperListingMessages='';
   $HyperListingResult="";
   $HyperlinkDetailsArrayDefaultCount=3; // Vorgabe: Anzahl der Array-Elemente
   $HyperlinkDetailsArrayCurrentCount=count($HyperlinkDetailsArray);
   $HyperlinkMessagesArrayDefaultCount=3; // Vorgabe: Anzahl der Array-Elemente
   $HyperlinkMessagesArrayCurrentCount=count($HyperlinkMessagesArray);
   if(isset($HyperlinkDetailsArray) &&
      is_array($HyperlinkDetailsArray) &&
      $HyperlinkDetailsArrayDefaultCount == $HyperlinkDetailsArrayCurrentCount &&
      isset($HyperlinkMessagesArray) &&
      is_array($HyperlinkMessagesArray) &&
      $HyperlinkMessagesArrayDefaultCount == $HyperlinkMessagesArrayCurrentCount) {
      if(file_exists($HyperlinkDetailsArray[0]) && is_readable($HyperlinkDetailsArray[0])) {
         $LinkListArray = file($HyperlinkDetailsArray[0]);
         $LinkListArrayCount = count($LinkListArray);
         for($x=0; $x<$LinkListArrayCount; $x++) {
            $LinkListLineArray = explode("|", $LinkListArray[$x]);
            $LinkListLineArrayCount = count($LinkListLineArray);
            if($LinkListLineArrayCount < 2) {
               $LinkListLineArray = explode(";", $LinkListArray[$x]);
               $LinkListLineArrayCount = count($LinkListLineArray);
               if($LinkListLineArrayCount < 2) $LinkListLineArray[]="";
            }
            $LinkListHttpValue = trim($LinkListLineArray[0]);
            $LinkListHttpText = trim($LinkListLineArray[1]);
            if(!empty($LinkListHttpValue) || !empty($LinkListHttpText)) {
               if(!empty($LinkListHttpValue) &&
                  preg_match("/^http[s]?:\/\/.+/i", $LinkListHttpValue) &&
                  !empty($LinkListHttpText)) {
                  $HyperListingResult .= "      <tr>\n";
                  $HyperListingResult .= "        <td>&nbsp;</td>\n";
                  $HyperListingResult .= "        <td class=\"column_wide\"><a href=\"" . $LinkListHttpValue . "\" target=\"LINKVIEWER\">" . $LinkListHttpText . "</a></td>\n";
                  $HyperListingResult .= "        <td>&nbsp;</td>\n";
                  $HyperListingResult .= "      </tr>\n";
               }
               else
               {
                  $HyperListingMessages .="       <tr>\n";
                  $HyperListingMessages .="         <td colspan=\"3\" class=\"red\">" . $HyperlinkMessagesArray[0] . "</td>\n";
                  $HyperListingMessages .="       </tr>\n";
                  $HyperListingMessages .="       <tr>\n";
                  $HyperListingMessages .="         <td colspan=\"3\"><hr></td>\n";
                  $HyperListingMessages .="       </tr>\n";
               }
            }
         }
      } elseif(file_exists($HyperlinkDetailsArray[0]) && !is_readable($HyperlinkDetailsArray[0])) {
         $HyperListingMessages .="      <tr>\n";
         $HyperListingMessages .="        <td colspan=\"3\" class=\"red\">" . $HyperlinkMessagesArray[1] . "</td>\n";
         $HyperListingMessages .="      </tr>\n";
         $HyperListingMessages .="      <tr>\n";
         $HyperListingMessages .="        <td colspan=\"3\"><hr></td>\n";
         $HyperListingMessages .="      </tr>\n";
      }
      else
      {
         $HyperListingMessages .="      <tr>\n";
         $HyperListingMessages .="        <td colspan=\"3\" class=\"red\">" . $HyperlinkMessagesArray[2] . "</td>\n";
         $HyperListingMessages .="      </tr>\n";
         $HyperListingMessages .="      <tr>\n";
         $HyperListingMessages .="        <td colspan=\"3\"><hr></td>\n";
         $HyperListingMessages .="      </tr>\n";
      }
   } elseif(!isset($HyperlinkDetailsArray) ||
      !is_array($HyperlinkDetailsArray) ||
      $HyperlinkDetailsArrayDefaultCount != $HyperlinkDetailsArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY HyperlinkDetailsArray (ARRAY-COUNT) - function <strong>create_hyperlink_listing</strong> - IS DAMAGED!';
      exit;
   }
   else
   {
      print 'NOTE: SYSTEM-ARRAY HyperlinkMessagesArray (ARRAY-COUNT) - function <strong>create_hyperlink_listing</strong> - IS DAMAGED!';
      exit;
   }
   $MainContent="    <table>\n";
   $MainContent .="      <tr>\n";
   $MainContent .="        <td colspan=\"3\" class=\"center\"><h3>" . $HyperlinkDetailsArray[1] . "</h3></td>\n";
   $MainContent .="      </tr>\n";
   $MainContent .="      <tr>\n";
   $MainContent .="        <td colspan=\"3\">" . $HyperlinkDetailsArray[2] . "</td>\n";
   $MainContent .="      </tr>\n";
   $MainContent .="      <tr>\n";
   $MainContent .="        <td colspan=\"3\"><hr></td>\n";
   $MainContent .="      </tr>\n";
   $MainContent .= $HyperListingMessages;
   $MainContent .="      <tr>\n";
   $MainContent .="        <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="      </tr>\n";
   $MainContent .= $HyperListingResult;
   $MainContent .="      <tr>\n";
   $MainContent .="        <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="      </tr>\n";
   $MainContent .="      <tr>\n";
   $MainContent .="        <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="      </tr>\n";
   $MainContent .="    </table>\n";
   return $MainContent;
}

// CSS - Navigation: HYPERLINK-LISTING
function create_hyperlink_listing_css() {
   $HyperlinkListingCSS="h3 {\n  font-size: 1.15em;\n  font-weight: bold;\n  text-align: center;\n}\n\n";
   $HyperlinkListingCSS .="table { width: 100%; }\n\n";
   $HyperlinkListingCSS .="td { font-size: 0.9em; }\n\n";
   $HyperlinkListingCSS .="hr { width: 100%; }\n\n";
   $HyperlinkListingCSS .=".column_wide {\n  width: 90%;\n  text-align: center;\n}\n\n";
   $HyperlinkListingCSS .=".red {\n  font-size: 0.95em;\n  font-weight: bold;\n  text-align: center;\n  color:#DD0000;\n}\n\n";
   return $HyperlinkListingCSS;
}

// Erstellung der Webseite  HTACCESS
function create_htaccess($ObelixFileNameArray='', $HtaccessDataArray='', $HtaccessDetailsArray='', $HtaccessMessagesArray='') {
   $HtaccessMessages="";
   if(empty($HtaccessDetailsArray[0])) $HtaccessDetailsArray[0]=0;
   if(empty($HtaccessDetailsArray[1])) $HtaccessDetailsArray[1]=0;
   $ObelixFileNameArrayDefaultCount=15; // Vorgabe: Anzahl der Array-Elemente
   $ObelixFileNameArrayCurrentCount=count($ObelixFileNameArray);
   $HtaccessDataArrayDefaultCount=9; // Vorgabe: Anzahl der Array-Elemente
   $HtaccessDataArrayCurrentCount=count($HtaccessDataArray);
   $HtaccessDetailsArrayDefaultCount=8; // Vorgabe: Anzahl der Array-Elemente
   $HtaccessDetailsArrayCurrentCount=count($HtaccessDetailsArray);
   $HtaccessMessagesArrayDefaultCount=7; // Vorgabe: Anzahl der Array-Elemente
   $HtaccessMessagesArrayCurrentCount=count($HtaccessMessagesArray);
   if(isset($ObelixFileNameArray) &&
      is_array($ObelixFileNameArray) &&
      $ObelixFileNameArrayDefaultCount == $ObelixFileNameArrayCurrentCount &&
      isset($HtaccessDataArray) &&
      is_array($HtaccessDataArray) &&
      $HtaccessDataArrayDefaultCount == $HtaccessDataArrayCurrentCount &&
      isset($HtaccessDetailsArray) &&
      is_array($HtaccessDetailsArray) &&
      $HtaccessDetailsArrayDefaultCount == $HtaccessDetailsArrayCurrentCount &&
      isset($HtaccessMessagesArray) &&
      is_array($HtaccessMessagesArray) &&
      $HtaccessMessagesArrayDefaultCount == $HtaccessMessagesArrayCurrentCount) {
      if(!empty($HtaccessDataArray[8]) &&
         !empty($HtaccessDataArray[0]) &&
         strlen($HtaccessDataArray[0]) >= $HtaccessDataArray[2] &&
         strlen($HtaccessDataArray[0]) <= $HtaccessDataArray[3] &&
         !empty($HtaccessDataArray[1]) &&
         strlen($HtaccessDataArray[1]) >= $HtaccessDataArray[2] &&
         strlen($HtaccessDataArray[1]) <= $HtaccessDataArray[3]) {
         if(is_dir('./') && is_writeable('./')) {
            if(!file_exists($ObelixFileNameArray[1]) && !file_exists($ObelixFileNameArray[2])) {
               $HtaccessPasswordHash = password_hash($HtaccessDataArray[1], PASSWORD_DEFAULT);
               $ContentHtaccessFile=$HtaccessDataArray[4] . " " . getcwd() . "/" . basename($ObelixFileNameArray[2]) . "\n";
               $ContentHtaccessFile .=$HtaccessDataArray[5] . "\n";
               $ContentHtaccessFile .=$HtaccessDataArray[6] . "\n\n";
               $ContentHtaccessFile .=$HtaccessDataArray[7] . " " . $HtaccessDataArray[0] ."\n";
               $ContentHtpasswdFile = $HtaccessDataArray[0] . ":" . $HtaccessPasswordHash . "\n";
               if($FileWrite = @fopen($ObelixFileNameArray[1],'w')) {
                  chmod($ObelixFileNameArray[1], $HtaccessDetailsArray[4]);
                  @flock($FileWrite,2);
                  @fwrite($FileWrite, $ContentHtaccessFile);
                  @flock($FileWrite,3);
                  @fclose($FileWrite);
                  $HtaccessMessagesAdd = $HtaccessMessagesArray[0] . "<br>";
               }
               else
               {
               $HtaccessMessagesAdd = $HtaccessMessagesArray[2] . "<br>";
               }
               if($FileWrite = @fopen($ObelixFileNameArray[2],'w')) {
                  chmod($ObelixFileNameArray[2], $HtaccessDetailsArray[4]);
                  @flock($FileWrite,2);
                  @fwrite($FileWrite, $ContentHtpasswdFile);
                  @flock($FileWrite,3);
                  @fclose($FileWrite);
                  $HtaccessMessages .="        <tr>\n";
                  $HtaccessMessages .="          <td colspan=\"2\" class=\"red\">" . $HtaccessMessagesAdd . $HtaccessMessagesArray[1] . "</td>\n";
                  $HtaccessMessages .="        </tr>\n";
                  $HtaccessMessages .="        <tr>\n";
                  $HtaccessMessages .="          <td colspan=\"2\"><hr></td>\n";
                  $HtaccessMessages .="        </tr>\n";
                }
                else
                {
                   $HtaccessMessages .="        <tr>\n";
                   $HtaccessMessages .="          <td colspan=\"2\" class=\"red\">" . $HtaccessMessagesAdd . $HtaccessMessagesArray[3] . "</td>\n";
                   $HtaccessMessages .="        </tr>\n";
                   $HtaccessMessages .="        <tr>\n";
                   $HtaccessMessages .="          <td colspan=\"2\"><hr></td>\n";
                   $HtaccessMessages .="        </tr>\n";
                }
            }
            else
            {
               $HtaccessMessages .="        <tr>\n";
               $HtaccessMessages .="          <td colspan=\"2\" class=\"red\">" . $HtaccessMessagesArray[4] . "</td>\n";
               $HtaccessMessages .="        </tr>\n";
               $HtaccessMessages .="        <tr>\n";
               $HtaccessMessages .="          <td colspan=\"2\"><hr></td>\n";
               $HtaccessMessages .="        </tr>\n";
            }
         }
         else
         {
            $HtaccessMessages .="        <tr>\n";
            $HtaccessMessages .="          <td colspan=\"2\" class=\"red\">" . $HtaccessMessagesArray[6] . "</td>\n";
            $HtaccessMessages .="        </tr>\n";
            $HtaccessMessages .="        <tr>\n";
            $HtaccessMessages .="          <td colspan=\"2\"><hr></td>\n";
            $HtaccessMessages .="        </tr>\n";
         }
      } elseif(!empty($HtaccessDataArray[0]) || !empty($HtaccessDataArray[1])) {
          $HtaccessMessages .="        <tr>\n";
          $HtaccessMessages .="          <td colspan=\"2\" class=\"red\">" . $HtaccessMessagesArray[5] . "</td>\n";
          $HtaccessMessages .="        </tr>\n";
          $HtaccessMessages .="        <tr>\n";
          $HtaccessMessages .="          <td colspan=\"2\"><hr></td>\n";
          $HtaccessMessages .="        </tr>\n";
      }
   } elseif(!isset($ObelixFileNameArray) ||
      !is_array($ObelixFileNameArray) ||
      $ObelixFileNameArrayDefaultCount != $ObelixFileNameArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY ObelixFileNameArray (ARRAY-COUNT) - function <strong>create_htaccess</strong> - IS DAMAGED!';
      exit;
   } elseif(!isset($HtaccessDataArray) ||
      !is_array($HtaccessDataArray) ||
      $HtaccessDataArrayDefaultCount != $HtaccessDataArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY HtaccessDataArray (ARRAY-COUNT) - function <strong>create_htaccess</strong> - IS DAMAGED!';
      exit;
   } elseif(!isset($HtaccessDetailsArray) &&
      !is_array($HtaccessDetailsArray) &&
      $HtaccessDetailsArrayDefaultCount != $HtaccessDetailsArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY HtaccessDetailsArray (ARRAY-COUNT) - function <strong>create_htaccess</strong> - IS DAMAGED!';
      exit;
   }
   else
   {
      print 'NOTE: SYSTEM-ARRAY HtaccessMessagesArray (ARRAY-COUNT) - function <strong>create_htaccess</strong> - IS DAMAGED!';
      exit;
   }
   $MainContent="    <form name=\"form_htaccess\" enctype=\"multipart/form-data\" method=\"post\" action=\"" . $ObelixFileNameArray[4] . "?OBELIX_ID=" . $HtaccessDetailsArray[0] . "&ACCESS_ID=" . $HtaccessDetailsArray[1] . "\" target=\"_self\">\n";
   $MainContent .="      <table>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"2\" class=\"center\"><h3>" . $HtaccessDetailsArray[2] . "</h3></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"2\">" . $HtaccessDetailsArray[3] . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"2\"><hr></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .= $HtaccessMessages;
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"2\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"2\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"right\">" . $HtaccessDetailsArray[5] . "</td>\n";
   $MainContent .="          <td><input type=\"text\" name=\"HTACCESS_KW\" value=\"\" size=\"30\" maxlength=\"128\"></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"right\">" . $HtaccessDetailsArray[6] . "</td>\n";
   $MainContent .="          <td><input type=\"password\" name=\"HTACCESS_PW\" value=\"\" size=\"30\" maxlength=\"128\"></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"2\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"2\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"2\" class=\"center\"><input type=\"submit\" name=\"HTACCESS_SUBMIT\" value=\"" . $HtaccessDetailsArray[7] . "\"></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="      </table>\n";
   $MainContent .="    </form>\n";
   return $MainContent;
}

// CSS - Navigation: HTACCESS
function create_htaccess_css() {
   $HtaccessCSS="h3 {\n  font-size: 1.15em;\n  font-weight: bold;\n  text-align: center;\n}\n\n";
   $HtaccessCSS .="table { width: 100%; }\n\n";
   $HtaccessCSS .="td { font-size: 0.9em; }\n\n";
   $HtaccessCSS .="hr { width: 100%; }\n\n";
   $HtaccessCSS .="input { font-size: 0.85em; }\n\n";
   $HtaccessCSS .=".red {\n  font-size: 0.95em;\n  text-align: center;\n  font-weight: bold;\n  color:#DD0000;\n}\n\n";
   $HtaccessCSS .=".right {\n  width: 36%;\n  text-align: right;\n  font-weight: bold;\n}\n\n";
   return $HtaccessCSS;
}

// Erstellung der Webseite  GETCWD
function create_getcwd($GetcwdMainHeadLine='', $GetcwdMainContent='') {
   $WorkDir=getcwd();
   $MainContent="    <article>\n";
   $MainContent .="      <h3>" . $GetcwdMainHeadLine . "</h3>\n";
   $MainContent .="      <p class=\"getcwd_output\"><strong>" . $GetcwdMainContent . ": </strong>" . $WorkDir . "</p>\n";
   $MainContent .="    </article>\n";
   return $MainContent;
}

// CSS - Navigation: GETCWD
function create_getcwd_css() {
   $GetcwdCSS="h3 {\n  font-size: 1.15em;\n  font-weight: bold;\n  text-align: center;\n}\n\n";
   $GetcwdCSS .=".getcwd_output {\n  font-size: 0.95em;\n  text-align: center;\n}\n\n";
   return $GetcwdCSS;
}

// Erstellung der Webseite PHPINFO
function create_phpinfo($PhpinfoServerVariablesArray='', $PhpinfoIniGetVariablesArray='', $PhpinfoDetailsArray='') {
   if(empty($PhpinfoDetailsArray[1])) $PhpinfoDetailsArray[1]=0;
   if(empty($PhpinfoDetailsArray[2])) $PhpinfoDetailsArray[2]=0;
   $PhpinfoServerVariablesArrayDefaultCount=16; // Vorgabe: Anzahl der Array-Elemente
   $PhpinfoServerVariablesArrayCurrentCount=count($PhpinfoServerVariablesArray);
   $PhpinfoIniGetVariablesArrayDefaultCount=10; // Vorgabe: Anzahl der Array-Elemente
   $PhpinfoIniGetVariablesArrayCurrentCount=count($PhpinfoIniGetVariablesArray);
   $PhpinfoDetailsArrayDefaultCount=10; // Vorgabe: Anzahl der Array-Elemente
   $PhpinfoDetailsArrayCurrentCount=count($PhpinfoDetailsArray);
   if(isset($PhpinfoServerVariablesArray) &&
      is_array($PhpinfoServerVariablesArray) &&
      $PhpinfoServerVariablesArrayDefaultCount == $PhpinfoServerVariablesArrayCurrentCount &&
      isset($PhpinfoIniGetVariablesArray) &&
      is_array($PhpinfoIniGetVariablesArray) &&
      $PhpinfoIniGetVariablesArrayDefaultCount == $PhpinfoIniGetVariablesArrayCurrentCount &&
      isset($PhpinfoDetailsArray) &&
      is_array($PhpinfoDetailsArray) &&
      $PhpinfoDetailsArrayDefaultCount == $PhpinfoDetailsArrayCurrentCount) {
      $TableColumnCount=8;
      $TableColumnVariablesLeftCount=2;
      $TableColumnVariablesRightCount=6;
      $MainContent="    <table>\n";
      $MainContent .="      <tr>\n";
      $MainContent .="        <td colspan=\"" . $TableColumnCount . "\"><h3>" . $PhpinfoDetailsArray[3] . "</h3></td>\n";
      $MainContent .="      </tr>\n";
      $MainContent .="      <tr>\n";
      $MainContent .="        <td colspan=\"" . $TableColumnCount . "\">" . $PhpinfoDetailsArray[4] . "</td>\n";
      $MainContent .="      </tr>\n";
      $MainContent .="      <tr>\n";
      $MainContent .="        <td colspan=\"" . $TableColumnCount . "\"><hr></td>\n";
      $MainContent .="      </tr>\n";
      $MainContent .="      <tr>\n";
      $MainContent .="        <td colspan=\"" . $TableColumnCount . "\">&nbsp;</td>\n";
      $MainContent .="      </tr>\n";
      $MainContent .="      <tr>\n";
      $MainContent .="        <th colspan=\"" . $TableColumnCount . "\">" . $PhpinfoDetailsArray[5] . "</th>\n";
      $MainContent .="      </tr>\n";
      $ModuleArray = get_loaded_extensions();
      $ModuleArrayCount=count($ModuleArray);
      $ModuleNumber=0;
      for($x=0; $x<$ModuleArrayCount; $x++) {
         $MainContent .="      <tr>\n";
         for($y=0; $y<$TableColumnCount; $y++) {
            $ModuleValue="";
            if($x < $ModuleArrayCount) {
              $ModuleValue=$ModuleArray[$x];
              $ModuleNumber++;
              $MainContent .="        <td>" . $ModuleNumber . " - " . $ModuleValue . "</td>\n";
              $x++;
            }
            else
            {
            $MainContent .="        <td>&nbsp;</td>\n";
            }
         }
         $MainContent .="      </tr>\n";
         $x--;
      }
      $MainContent .="      <tr>\n";
      $MainContent .="        <td colspan=\"" . $TableColumnCount . "\">&nbsp;</td>\n";
      $MainContent .="      </tr>\n";
      $MainContent .="      <tr>\n";
      $MainContent .="        <th colspan=\"" . $TableColumnCount . "\">" . $PhpinfoDetailsArray[6] . "</th>\n";
      $MainContent .="      </tr>\n";
      $MainContent .="      <tr>\n";
      $MainContent .="        <td colspan=\"" . $TableColumnVariablesLeftCount . "\" class=\"right\">" . $PhpinfoDetailsArray[7] . "&nbsp;&nbsp;-&nbsp;&nbsp;</td>\n";
      $MainContent .="        <td colspan=\"" . $TableColumnVariablesRightCount . "\">" . $PhpinfoDetailsArray[8] . "</td>\n";
      $MainContent .="      </tr>\n";
      $MainContent .="      <tr>\n";
      $PhpinfoServerVariablesArrayCount=count($PhpinfoServerVariablesArray);
      for($i=0; $i<$PhpinfoServerVariablesArrayCount; $i++) {
         $ServerVariables=@$_SERVER[$PhpinfoServerVariablesArray[$i]];
         if($ServerVariables != TRUE) {
           if($ServerVariables == 0) {
              $ServerVariables=0;
            } elseif($ServerVariables == '') {
              $ServerVariables = 'NO VALUE';
            }
            else
            {
            $ServerVariables = 'BAD VARIABLE';
            }
         }
         $MainContent .="      <tr>\n";
         $MainContent .="        <td colspan=\"" . $TableColumnVariablesLeftCount . "\" class=\"right\">" . $PhpinfoServerVariablesArray[$i] . "&nbsp;&nbsp;-&nbsp;&nbsp;</td>\n";
         $MainContent .="        <td colspan=\"" . $TableColumnVariablesRightCount . "\">" . $ServerVariables . "</td>\n";
         $MainContent .="      </tr>\n";
      }
      $MainContent .="      <tr>\n";
      $MainContent .="        <td colspan=\"" . $TableColumnCount . "\">&nbsp;</td>\n";
      $MainContent .="      </tr>\n";
      $PhpinfoIniGetVariablesArrayCount = count($PhpinfoIniGetVariablesArray);
      for($k=0; $k<$PhpinfoIniGetVariablesArrayCount; $k++) {
         $IniGetValue = @ini_get($PhpinfoIniGetVariablesArray[$k]);
         if($IniGetValue != TRUE) {
           if($IniGetValue == 0) {
              $IniGetValue=0;
            } elseif($IniGetValue == '') {
              $IniGetValue = 'NO VALUE';
            }
            else
            {
            $IniGetValue = 'BAD VARIABLE';
            }
         }
         $MainContent .="      <tr>\n";
         $MainContent .="        <td colspan=\"" . $TableColumnVariablesLeftCount . "\" class=\"right\">" . $PhpinfoIniGetVariablesArray[$k] . "&nbsp;&nbsp;-&nbsp;&nbsp;</td>\n";
         $MainContent .="        <td colspan=\"" . $TableColumnVariablesRightCount . "\">" . $IniGetValue . "</td>\n";
         $MainContent .="      </tr>\n";
      }
      $MainContent .="      </tr>\n";
      $MainContent .="      <tr>\n";
      $MainContent .="        <td colspan=\"" . $TableColumnCount . "\">&nbsp;</td>\n";
      $MainContent .="      </tr>\n";
      $MainContent .="      <tr>\n";
      $MainContent .="        <td colspan=\"" . $TableColumnCount . "\">&nbsp;</td>\n";
      $MainContent .="      </tr>\n";
      $MainContent .="      <tr>\n";
      $MainContent .="        <td colspan=\"" . $TableColumnCount . "\" class=\"center\"><a href=\"" . $PhpinfoDetailsArray[0] . "?OBELIX_ID=" . $PhpinfoDetailsArray[1] . "&ACCESS_ID=" . $PhpinfoDetailsArray[2] . "\" target=\"PHPINFO\">" . $PhpinfoDetailsArray[9] . "</a></td>\n";
      $MainContent .="      </tr>\n";
      $MainContent .="      <tr>\n";
      $MainContent .="        <td colspan=\"" . $TableColumnCount . "\">&nbsp;</td>\n";
      $MainContent .="      </tr>\n";
      $MainContent .="    </table>\n";
      return $MainContent;
   } elseif(!isset($PhpinfoServerVariablesArray) ||
      !is_array($PhpinfoServerVariablesArray) ||
      $PhpinfoServerVariablesArrayDefaultCount != $PhpinfoServerVariablesArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY PhpinfoServerVariablesArray (ARRAY-COUNT) - function <strong>create_phpinfo</strong> - IS DAMAGED!';
      exit;
   } elseif(!isset($PhpinfoIniGetVariablesArray) ||
      !is_array($PhpinfoIniGetVariablesArray) ||
      $PhpinfoIniGetVariablesArrayDefaultCount != $PhpinfoIniGetVariablesArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY PhpinfoIniGetVariablesArray (ARRAY-COUNT) - function <strong>create_phpinfo</strong> - IS DAMAGED!';
      exit;
   }
   else
   {
      print 'NOTE: SYSTEM-ARRAY PhpinfoDetailsArray (ARRAY-COUNT) - function <strong>create_phpinfo</strong> - IS DAMAGED!';
      exit;
   }
}

// CSS - Navigation: PHPINFO
function create_phpinfo_css() {
   $PhpinfoCSS="h3 {\n  font-size: 1.15em;\n  font-weight: bold;\n  text-align: center;\n}\n\n";
   $PhpinfoCSS .="td { font-size: 0.9em; }\n\n";
   $PhpinfoCSS .="table { width: 100%; }\n\n";
   $PhpinfoCSS .="hr { width: 100%; }\n\n";
   $PhpinfoCSS .=".right { text-align: right; }\n\n";
   return $PhpinfoCSS;
}

// Erstellung der Webseite FILELIST
function create_filelist($FilelistArray='', $FilelistFileTypeTitleArray='', $FilelistFileTypeRegexArray='', $FilelistDetailsArray='', $FilelistMessagesArray='') {
   $FilelistChoiceFileTypeHtml="";
   $FilelistContentHtml="";
   $FilelistMessagesHtml="";
   if(isset($FilelistArray[0]) && $FilelistArray[0] == '') $FilelistArray[0]=0; 
   if(empty($FilelistDetailsArray[1])) $FilelistDetailsArray[1]=0;
   if(empty($FilelistDetailsArray[2])) $FilelistDetailsArray[2]=0;
   if(empty($FilelistDetailsArray[3])) $FilelistDetailsArray[3]=0;
   if(empty($FilelistDetailsArray[4])) $FilelistDetailsArray[4]=0;
   if(empty($FilelistDetailsArray[9])) $FilelistDetailsArray[9]=3;
   $FilelistArrayDefaultCount=4; // Vorgabe: Anzahl der Array-Elemente
   $FilelistArrayCurrentCount=count($FilelistArray);
   $FilelistFileTypeTitleArrayDefaultCount=17; // Vorgabe: Anzahl der Array-Elemente
   $FilelistFileTypeTitleArrayCurrentCount=count($FilelistFileTypeTitleArray);
   $FilelistFileTypeRegexArrayDefaultCount=17; // Vorgabe: Anzahl der Array-Elemente
   $FilelistFileTypeRegexArrayCurrentCount=count($FilelistFileTypeRegexArray);
   $FilelistDetailsArrayDefaultCount=29; // Vorgabe: Anzahl der Array-Elemente
   $FilelistDetailsArrayCurrentCount=count($FilelistDetailsArray);
   $FilelistMessagesArrayDefaultCount=2; // Vorgabe: Anzahl der Array-Elemente
   $FilelistMessagesArrayCurrentCount=count($FilelistMessagesArray);
   if(isset($FilelistArray) &&
      is_array($FilelistArray) &&
      $FilelistArrayDefaultCount == $FilelistArrayCurrentCount &&
      isset($FilelistFileTypeTitleArray) &&
      is_array($FilelistFileTypeTitleArray) &&
      $FilelistFileTypeTitleArrayDefaultCount == $FilelistFileTypeTitleArrayCurrentCount &&
      isset($FilelistFileTypeRegexArray) &&
      is_array($FilelistFileTypeRegexArray) &&
      $FilelistFileTypeRegexArrayDefaultCount == $FilelistFileTypeRegexArrayCurrentCount &&
      isset($FilelistDetailsArray) &&
      is_array($FilelistDetailsArray) &&
      $FilelistDetailsArrayDefaultCount == $FilelistDetailsArrayCurrentCount &&
      isset($FilelistMessagesArray) &&
      is_array($FilelistMessagesArray) &&
      $FilelistMessagesArrayDefaultCount == $FilelistMessagesArrayCurrentCount) {
      $FilelistCurrentWorkDirectory = getcwd() . "/";
      if(!empty($FilelistArray[2]) && file_exists($FilelistArray[2])) {
         @unlink($FilelistArray[2]);
         if(file_exists($FilelistArray[2])) {
            $FilelistMessagesHtml .="        <tr>\n";
            $FilelistMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $FilelistMessagesArray[0] . "</td>\n";
            $FilelistMessagesHtml .="        </tr>\n";
            $FilelistMessagesHtml .="        <tr>\n";
            $FilelistMessagesHtml .="          <td colspan=\"3\"><hr></td>\n";
            $FilelistMessagesHtml .="        </tr>\n";
         }
      } elseif(!empty($FilelistArray[2]) && !file_exists($FilelistArray[2])) {
         $FilelistMessagesHtml .="        <tr>\n";
         $FilelistMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $FilelistMessagesArray[1] . "</td>\n";
         $FilelistMessagesHtml .="        </tr>\n";
         $FilelistMessagesHtml .="        <tr>\n";
         $FilelistMessagesHtml .="          <td colspan=\"3\"><hr></td>\n";
         $FilelistMessagesHtml .="        </tr>\n";
      }
      $FilelistChoiceFileTypeHtml .="            <div id=\"div_center\">\n";
      $FilelistChoiceFileTypeHtml .="              <table>\n";
      $FilelistChoiceFileTypeHtml .="                <tr>\n";
      $FilelistChoiceFileTypeHtml .="                  <td>" . $FilelistDetailsArray[7] . "</td>\n";
      $FilelistChoiceFileTypeHtml .="                  <td>&nbsp;</td>\n";
      $FilelistChoiceFileTypeHtml .="                  <td>\n";
      $FilelistChoiceFileTypeHtml .="                    <select size=\"1\" name=\"FILELIST_FILE_TYPE\">\n";
      for($x=0; $x<$FilelistFileTypeTitleArrayCurrentCount; $x++){
         $FilelistFileTypeChecked='';
         if(preg_match("/^[0-9]{1,2}$/", $FilelistArray[0]) && $FilelistArray[0] == $x) $FilelistFileTypeChecked=" selected";
         $FilelistChoiceFileTypeHtml .="                      <option value=\"" . $x . "\"" . $FilelistFileTypeChecked . ">" . $FilelistFileTypeTitleArray[$x] . "</option>\n";
      }
      if(!preg_match("/^[1-9]$/", $FilelistArray[1])) $FilelistArray[1] = $FilelistDetailsArray[9];
      $FilelistChoiceFileTypeHtml .="                    </select>\n";
      $FilelistChoiceFileTypeHtml .="                  </td>\n";
      $FilelistChoiceFileTypeHtml .="                  <td>&nbsp;</td>\n";
      $FilelistChoiceFileTypeHtml .="                  <td>" . $FilelistDetailsArray[8] . "</td>\n";
      $FilelistChoiceFileTypeHtml .="                  <td>&nbsp;</td>\n";
      $FilelistChoiceFileTypeHtml .="                  <td><input type=\"number\" name=\"FILELIST_DIRECTORY_DEPTH\" min=\"1\" max=\"9\" size=\"1\" value=\"" . $FilelistArray[1] . "\"></td>\n";
      $FilelistChoiceFileTypeHtml .="                  <td>&nbsp;</td>\n";
      $FilelistChoiceFileTypeHtml .="                  <td><input type=\"submit\" name=\"SUBMIT_FILE_TYPE\" value=\"" . $FilelistDetailsArray[10] . "\"></td>\n";
      $FilelistChoiceFileTypeHtml .="                </tr>\n";
      $FilelistChoiceFileTypeHtml .="              </table>\n";
      $FilelistChoiceFileTypeHtml .="            </div>\n";
      $FilelistContentHtml .="            <div id=\"div_center\">\n";
      $FilelistContentHtml .="              <table class=\"table_filelist\">\n";
      $FilelistContentHtml .="                <thead>\n";
      $FilelistContentHtml .="                  <tr>\n";
      $FilelistContentHtml .="                    <th colspan=\"9\" class=\"table_main_title\">" . $FilelistDetailsArray[25] . "</th>\n";
      $FilelistContentHtml .="                  </tr>\n";
      $FilelistContentHtml .="                  <tr>\n";
      $FilelistContentHtml .="                    <th class=\"title_field_1\">" . $FilelistDetailsArray[11] . "</th>\n";
      $FilelistContentHtml .="                    <th class=\"title_field_2\">" . $FilelistDetailsArray[12] . "</th>\n";
      $FilelistContentHtml .="                    <th class=\"title_field_3\">" . $FilelistDetailsArray[13] . "</th>\n";
      $FilelistContentHtml .="                    <th class=\"title_field_4\">" . $FilelistDetailsArray[14] . "</th>\n";
      $FilelistContentHtml .="                    <th class=\"title_field_5\">" . $FilelistDetailsArray[15] . "</th>\n";
      $FilelistContentHtml .="                    <th class=\"title_field_6\">" . $FilelistDetailsArray[16] . "</th>\n";
      $FilelistContentHtml .="                    <th class=\"title_field_7_9\">" . $FilelistDetailsArray[17] . "</th>\n";
      $FilelistContentHtml .="                    <th class=\"title_field_7_9\">" . $FilelistDetailsArray[18] . "</th>\n";
      $FilelistContentHtml .="                    <th class=\"title_field_7_9\">" . $FilelistDetailsArray[19] . "</th>\n";
      $FilelistContentHtml .="                  </tr>\n";
      $FilelistContentHtml .="                </thead>\n";
      $FilelistContentHtml .="                <tbody>\n";
      // Erstellung der Dateiliste
      if(isset($FilelistArray[0]) &&
         !empty($FilelistArray[1]) &&
         !empty($FilelistArray[3])) {
         $FilelistDirectoryArray=array();
         $FilelistResultArray=array();
         $FilelistFilenameArray=array();
         $FilelistFileMtimeArray=array();
         $FilelistFilesizeArray=array();
         $FilelistStartDirectory = "./";
         $FilelistDirectoryArray[] = $FilelistStartDirectory;
         $FileTypeCurrentRegex = $FilelistFileTypeRegexArray[$FilelistArray[0]];
         $FilelistDirectoryArrayCount = count($FilelistDirectoryArray);
         $FilelistDirectoryMaxDepthCount = substr_count($FilelistStartDirectory, '/') + $FilelistArray[1];
         if($FilelistDirectoryMaxDepthCount >= 2) $FilelistDirectoryMaxDepthCount = $FilelistDirectoryMaxDepthCount - 2;
         for($x=0; $x<$FilelistDirectoryArrayCount; $x++) {
            $FilelistFileHandle = @opendir($FilelistDirectoryArray[$x]);
            while($FileName = @readdir($FilelistFileHandle)) {
               if($FileName != "." && $FileName != "..") {
                  if(isset($FilelistDirectoryArray[0]) && $FilelistDirectoryArray[0] != "") $FilelistDirectoryArray[0]="";
                  if(isset($FilelistDirectoryArray[$x])) {
                     if($FilelistDirectoryArray[$x] == "") {
                        $NextFile = $FileName;
                     }
                     else
                     {
                     $NextFile = $FilelistDirectoryArray[$x] . "/" . $FileName;
                     }
                  }
                  else
                  {
                  $NextFile = $FileName;
                  }
                  $NextFileSlashCount = substr_count($NextFile, '/');
                  $NextDirOrFileExists = $FilelistStartDirectory . $NextFile;
                  if(is_dir($NextDirOrFileExists) && $NextFileSlashCount <= $FilelistDirectoryMaxDepthCount) {
                     $FilelistDirectoryArray[] = $NextFile;
                     $FilelistDirectoryArrayCount = count($FilelistDirectoryArray);
                  } elseif(preg_match("/" . $FileTypeCurrentRegex . "$/i", $NextFile)) {
                     if(file_exists($NextDirOrFileExists)) {
                        $FilelistFilenameArray[] = $NextFile;
                        $FilelistFileMtimeArray[] = date("d.m.Y - H:i:s", filemtime($NextFile));
                        $FilelistFilesizeArray[] = filesize($NextFile);
                     }
                  }
               }
            }
            @closedir($FilelistFileHandle);
         }
         clearstatcache();
         array_push($FilelistResultArray, $FilelistFilenameArray, $FilelistFileMtimeArray, $FilelistFilesizeArray);
         $LineNumber=0;
         $FilelistFilenameCount = count($FilelistResultArray[0]);
         for($y=0; $y < $FilelistFilenameCount; $y++) {
            $LineNumber++;
            $FilelistCallEditor="";
            $FilelistCallDelete="";
            $FilelistCallDownload="";
            $FileName = $FilelistResultArray[0][$y];
            $GigaByte=1024 * 1024 * 1024;
            $MegaByte=1024 * 1024;
            $KiloByte=1024;
            if($FilelistResultArray[2][$y] > $GigaByte) {
               $SizeValue = $FilelistResultArray[2][$y] / $GigaByte;
               $FileSize = round($SizeValue, 1) . " " . $FilelistDetailsArray[20];
            } elseif($FilelistResultArray[2][$y] > $MegaByte) {
               $SizeValue = $FilelistResultArray[2][$y] / $MegaByte;
               $FileSize = round($SizeValue, 1) . " " . $FilelistDetailsArray[21];
            } elseif($FilelistResultArray[2][$y] > $KiloByte) {
               $SizeValue = $FilelistResultArray[2][$y] / $KiloByte;
               $FileSize = round($SizeValue, 0) . " " . $FilelistDetailsArray[22];
            }
            else
            {
            $FileSize = $FilelistResultArray[2][$y] . " " . $FilelistDetailsArray[23];
            }
            if(preg_match("/.*" . $FilelistDetailsArray[26] . "/i", $FileName)) {
               $FilelistCallEditor = "<a href=\"" . $FilelistDetailsArray[0] . "?OBELIX_ID=" . $FilelistDetailsArray[3] . "&ACCESS_ID=" . $FilelistDetailsArray[2] . "&GET_FILENAME=" . $FilelistStartDirectory . $FileName . "\" target=\"EDITOR\" class=\"filelist\">" . $FilelistDetailsArray[17] . "</a>";
            } elseif(preg_match("/.*" . $FilelistDetailsArray[27] . "/i", $FileName)) {
               $FilelistCallEditor = "<a href=\"" . $FilelistDetailsArray[0] . "?OBELIX_ID=" . $FilelistDetailsArray[4] . "&ACCESS_ID=" . $FilelistDetailsArray[2] . "&GET_FILENAME=" . $FilelistStartDirectory . $FileName . "\" target=\"IMAGEEDITOR\" class=\"filelist\">" . $FilelistDetailsArray[17] . "</a>";
            } elseif(preg_match("/.*" . $FilelistDetailsArray[28] . "/i", $FileName)) {
               $FilelistCallDownload = "<a href=\"" . $FilelistStartDirectory . $FileName . "\" target=\"_self\" class=\"filelist\">" . $FilelistDetailsArray[19] . "</a>";
            }
            if(empty($FilelistCallEditor)) $FilelistCallEditor="&nbsp;";
            $FilelistCallDelete = "<a href=\"" . $FilelistDetailsArray[0] . "?OBELIX_ID=" . $FilelistDetailsArray[1] . "&ACCESS_ID=" . $FilelistDetailsArray[2] . "&FILELIST_CURRENT_FILENAME_DELETE=" . $FilelistStartDirectory . $FileName . "&FILELIST_CURRENT_FILE_TYPE=" . $FilelistArray[0] . "&FILELIST_CURRENT_DIRECTORY_DEPTH=" . $FilelistArray[1] . "&FILELIST_GET_FILE_DELETE=1\" target=\"_self\" class=\"filelist\">" . $FilelistDetailsArray[18] . "</a>";
            if(empty($FilelistCallDownload)) $FilelistCallDownload = "<a href=\"" . $FilelistStartDirectory . $FileName . "\" target=\"FILEVIEWER\" class=\"filelist\">" . $FilelistDetailsArray[19] . "</a>";
            $FilelistContentHtml .="                  <tr>\n";
            $FilelistContentHtml .="                    <td class=\"data_field_1\">" . $LineNumber . "</td>\n";
            $FilelistContentHtml .="                    <td class=\"data_field_2\">" . $FileName . "</td>\n";
            $FilelistContentHtml .="                    <td class=\"data_field_3\">" . $FilelistResultArray[1][$y] . "</td>\n";
            $FilelistContentHtml .="                    <td class=\"data_field_4\">" . $FileSize . "</td>\n";
            if(is_readable($FileName)) {
               $FilelistContentHtml .="                    <td class=\"data_field_5\">&#10003;</td>\n";
            }
            else
            {
            $FilelistContentHtml .="                    <td class=\"data_field_5\">&#10007;</td>\n";
            }
            if(is_writeable($FileName)) {
               $FilelistContentHtml .="                    <td class=\"data_field_6\">&#10003;</td>\n";
            }
            else
            {
            $FilelistContentHtml .="                    <td class=\"data_field_6\">&#10007;</td>\n";
            }
            $FilelistContentHtml .="                    <td class=\"data_field_7_9\">" . $FilelistCallEditor . "</td>\n";
            $FilelistContentHtml .="                    <td class=\"data_field_7_9\">" . $FilelistCallDelete . "</td>\n";
            $FilelistContentHtml .="                    <td class=\"data_field_7_9\">" . $FilelistCallDownload . "</td>\n";
            $FilelistContentHtml .="                  </tr>\n";
         }
      }
      $FilelistContentHtml .="                  <tr>\n";
      $FilelistContentHtml .="                    <td colspan=\"9\">&nbsp;</td>\n";
      $FilelistContentHtml .="                  </tr>\n";
      $FilelistContentHtml .="                </tbody>\n";
      $FilelistContentHtml .="                <tfoot>\n";
      $FilelistContentHtml .="                  <tr>\n";
      $FilelistContentHtml .="                    <td colspan=\"9\" class=\"footer\"><strong>" . $FilelistDetailsArray[24] . "</strong> " . $FilelistCurrentWorkDirectory . "</td>\n";
      $FilelistContentHtml .="                  </tr>\n";
      $FilelistContentHtml .="                </tfoot>\n";
      $FilelistContentHtml .="              </table>\n";
      $FilelistContentHtml .="            </div>\n";
   } elseif(!isset($FilelistArray) ||
      !is_array($FilelistArray) ||
      $FilelistArrayDefaultCount != $FilelistArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY FilelistArray (ARRAY-COUNT) - function <strong>create_filelist</strong> - IS DAMAGED!';
      exit;
   } elseif(!isset($FilelistFileTypeTitleArray) ||
      !is_array($FilelistFileTypeTitleArray) ||
      $FilelistFileTypeTitleArrayDefaultCount != $FilelistFileTypeTitleArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY FilelistFileTypeTitleArray (ARRAY-COUNT) - function <strong>create_filelist</strong> - IS DAMAGED!';
      exit;
   } elseif(!isset($FilelistFileTypeRegexArray) ||
      !is_array($FilelistFileTypeRegexArray) ||
      $FilelistFileTypeRegexArrayDefaultCount != $FilelistFileTypeRegexArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY FilelistFileTypeRegexArray (ARRAY-COUNT) - function <strong>create_filelist</strong> - IS DAMAGED!';
      exit;
   } elseif(!isset($FilelistDetailsArray) ||
      !is_array($FilelistDetailsArray) ||
      $FilelistDetailsArrayDefaultCount != $FilelistDetailsArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY FilelistDetailsArray (ARRAY-COUNT) - function <strong>create_filelist</strong> - IS DAMAGED!';
      exit;
   }
   else
   {
      print 'NOTE: SYSTEM-ARRAY FilelistMessagesArray (ARRAY-COUNT) - function <strong>create_filelist</strong> - IS DAMAGED!';
      exit;
   }
   $MainContent="    <form name=\"form_filelist\" method=\"post\" action=\"" . $FilelistDetailsArray[0] . "?OBELIX_ID=" . $FilelistDetailsArray[1] . "&ACCESS_ID=" . $FilelistDetailsArray[2] . "\" target=\"_self\">\n";
   $MainContent .="      <table class=\"table_wide\">\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\" class=\"center\"><h3>" . $FilelistDetailsArray[5] . "</h3></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">" . $FilelistDetailsArray[6] . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\"><hr></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .= $FilelistMessagesHtml;
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">\n";
   $MainContent .= $FilelistChoiceFileTypeHtml;
   $MainContent .="          </td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">\n";
   $MainContent .= $FilelistContentHtml;
   $MainContent .="          </td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="      </table>\n";
   $MainContent .="    </form>\n";
   return $MainContent;
}

// CSS - Navigation: FILELIST
function create_filelist_css() {
   $FilelistCSS="h3 {\n  font-size: 1.15em;\n  font-weight: bold;\n  text-align: center;\n}\n\n";
   $FilelistCSS .=".table_wide { width: 100%; }\n\n";
   $FilelistCSS .=".table_filelist {\n  border-collapse: collapse;\n  border: 1px solid gray;\n}\n\n";
   $FilelistCSS .="td { font-size: 0.9em; }\n\n";
   $FilelistCSS .="#div_center {\n  display: flex;\n  justify-content: center;\n  align-content: center;\n}\n\n";
   $FilelistCSS .="hr { width: 100%; }\n\n";
   $FilelistCSS .="a.filelist {\n  font-family: sans-serif;\n  font-size: 0.85em;\n  font-weight: normal;\n}\n\n";
   $FilelistCSS .=".table_main_title {\n  padding: 8px 8px 8px 8px;\n  border-bottom: 1px solid gray;\n}\n\n";
   $FilelistCSS .=".title_field_1 {\n  width: 80px;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n  background-color: #D6B194;\n}\n\n";
   $FilelistCSS .=".title_field_2 {\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n  background-color: #D6B194;\n}\n\n";
   $FilelistCSS .=".title_field_3 {\n  width: 150px;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n  background-color: #D6B194;\n}\n\n";
   $FilelistCSS .=".title_field_4 {\n  width: 120px;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n  background-color: #D6B194;\n}\n\n";
   $FilelistCSS .=".title_field_5 {\n  width: 60px;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n  background-color: #D6B194;\n}\n\n";
   $FilelistCSS .=".title_field_6 {\n  width: 80px;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n  background-color: #D6B194;\n}\n\n";
   $FilelistCSS .=".title_field_7_9 {\n  width: 100px;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n  background-color: #D6B194;\n}\n\n";
   $FilelistCSS .=".data_field_1 {\n  text-align: right;\n  padding: 2px 4px 2px 4px;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n}\n\n";
   $FilelistCSS .=".data_field_2 {\n  padding: 2px 4px 2px 4px;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n}\n\n";
   $FilelistCSS .=".data_field_3 {\n  padding: 2px 4px 2px 4px;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n}\n\n";
   $FilelistCSS .=".data_field_4 {\n  text-align: center;\n  padding: 2px 4px 2px 4px;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n}\n\n";
   $FilelistCSS .=".data_field_5 {\n  text-align: center;\n  padding: 2px 4px 2px 4px;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n}\n\n";
   $FilelistCSS .=".data_field_6 {\n  text-align: center;\n  padding: 2px 4px 2px 4px;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n}\n\n";
   $FilelistCSS .=".data_field_7_9 {\n  text-align: center;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n}\n\n";
   $FilelistCSS .=".footer {\n  padding: 4px 4px 4px 4px;\n  border-top: 1px solid gray;\n  background-color: #D6B194;\n}\n\n";
   $FilelistCSS .=".red {\n  font-size: 0.95em;\n  font-weight: bold;\n  text-align: center;\n  color:#DD0000;\n}\n\n";
   return $FilelistCSS;
}

// Erstellung der Webseite SITEMAP
function create_sitemap($SitemapArray='', $SitemapFileTypeTitleArray='', $SitemapFileTypeRegexArray='', $SitemapFileBackgroundColorRegexArray='', $SitemapFileBackgroundColorCssNameArray='', $SitemapDetailsArray='', $SitemapDirectoryChangeMessagesNotSuccessful='') {
   $SitemapFileTypeHtml="";
   $SitemapContentHtml="";
   $SitemapMessagesHtml="";
   $SitemapStartWorkDirectory="";
   $SitemapCurrentWorkDirectory="";
   $SitemapDirectoryDepth="";
   $SitemapDirectoryLevel0="";
   $SitemapDirectoryLevel1="";
   $SitemapDirectoryLevel2="";
   $SitemapDirectoryLevel3="";
   $SitemapDirectoryPathCorrection="";
   $SitemapDirectoryPathChangeValue="";
   $SitemapUnknownFilesOn="";
   $SitemapEditingModusOn="";
   $GigaByte=1024 * 1024 * 1024;
   $MegaByte=1024 * 1024;
   $KiloByte=1024;
   $SitemapNumberFiletypeLine=4;
   $SitemapTermArray=array('(/){2,}', '(\.){3,}', '(/\./)', '^(\./){2,}');
   $SitemapReplacementArray=array('/', '\.\.', '/', '\./');
   if(empty($SitemapDetailsArray[1])) $SitemapDetailsArray[1]=0;
   if(empty($SitemapDetailsArray[2])) $SitemapDetailsArray[2]=0;
   if(empty($SitemapDetailsArray[3])) $SitemapDetailsArray[3]=0;
   if(empty($SitemapDetailsArray[4])) $SitemapDetailsArray[4]=0;
   if(empty($SitemapDetailsArray[41])) $SitemapDetailsArray[41]=3;
   $SitemapArrayDefaultCount=7; // Vorgabe: Anzahl der Array-Elemente
   $SitemapArrayCurrentCount=count($SitemapArray);
   $SitemapFileTypeTitleArrayDefaultCount=21; // Vorgabe: Anzahl der Array-Elemente
   $SitemapFileTypeTitleArrayCurrentCount=count($SitemapFileTypeTitleArray);
   $SitemapFileTypeRegexArrayDefaultCount=21; // Vorgabe: Anzahl der Array-Elemente
   $SitemapFileTypeRegexArrayCurrentCount=count($SitemapFileTypeRegexArray);
   $SitemapFileBackgroundColorRegexArrayDefaultCount=8; // Vorgabe: Anzahl der Array-Elemente
   $SitemapFileBackgroundColorRegexArrayCurrentCount=count($SitemapFileBackgroundColorRegexArray);
   $SitemapFileBackgroundColorCssNameArrayDefaultCount=10; // Vorgabe: Anzahl der Array-Elemente
   $SitemapFileBackgroundColorCssNameArrayCurrentCount=count($SitemapFileBackgroundColorCssNameArray);
   $SitemapDetailsArrayDefaultCount=46; // Vorgabe: Anzahl der Array-Elemente
   $SitemapDetailsArrayCurrentCount=count($SitemapDetailsArray);
   if(isset($SitemapArray) &&
      is_array($SitemapArray) &&
      $SitemapArrayDefaultCount == $SitemapArrayCurrentCount &&
      isset($SitemapFileTypeTitleArray) &&
      is_array($SitemapFileTypeTitleArray) &&
      $SitemapFileTypeTitleArrayDefaultCount == $SitemapFileTypeTitleArrayCurrentCount &&
      isset($SitemapFileTypeRegexArray) &&
      is_array($SitemapFileTypeRegexArray) &&
      $SitemapFileTypeRegexArrayDefaultCount == $SitemapFileTypeRegexArrayCurrentCount &&
      isset($SitemapFileBackgroundColorRegexArray) &&
      is_array($SitemapFileBackgroundColorRegexArray) &&
      $SitemapFileBackgroundColorRegexArrayDefaultCount == $SitemapFileBackgroundColorRegexArrayCurrentCount &&
      isset($SitemapFileBackgroundColorCssNameArray) &&
      is_array($SitemapFileBackgroundColorCssNameArray) &&
      $SitemapFileBackgroundColorCssNameArrayDefaultCount == $SitemapFileBackgroundColorCssNameArrayCurrentCount &&
      isset($SitemapDetailsArray) &&
      is_array($SitemapDetailsArray) &&
      $SitemapDetailsArrayDefaultCount == $SitemapDetailsArrayCurrentCount) {
      // Sitemap-Menue Bereich 1 - Ausgangsverzeichnis, Verzeichnistiefe
      $SitemapStartWorkDirectory = getcwd() . "/";
      if(!empty($SitemapArray[0]) && preg_match("/^[1-9]$/", $SitemapArray[0])) {
         $SitemapDirectoryDepth = $SitemapArray[0];
      }
      else
      {
      $SitemapDirectoryDepth = $SitemapDetailsArray[41];
      }
      // Sitemap-Menue Bereich 2 - Dateitypen
      $SitemapFileTypeHtml .="        <tr>\n";
      $SitemapFileTypeHtml .="          <td colspan=\"2\">\n";
      $SitemapFileTypeHtml .="            <table>\n";
      $SitemapFileTypeHtml .="              <tr>\n";
      $SitemapFileTypeHtml .="                <th colspan=\"8\">" . $SitemapDetailsArray[9] . "</th>\n";
      $SitemapFileTypeHtml .="              </tr>\n";
      for($x=0; $x<$SitemapFileTypeTitleArrayDefaultCount; $x++) {
         $SitemapFileTypeHtml .="              <tr>\n";
         for($y=0; $y<$SitemapNumberFiletypeLine; $y++){
            if($x < $SitemapFileTypeTitleArrayCurrentCount) {
               if(isset($SitemapArray[3]) &&
                  !is_array($SitemapArray[3]) &&
                  $x == 0) {
                  $SitemapFileTypeHtml .="                <td><input type=\"checkbox\" name=\"SITEMAP_FILE_TYPE[]\" value=\"" . $x . "\" checked></td>\n";
               } elseif(isset($SitemapArray[3]) && is_array($SitemapArray[3])) {
                  if(in_array($x, $SitemapArray[3])) {
                     $SitemapFileTypeHtml .="                <td><input type=\"checkbox\" name=\"SITEMAP_FILE_TYPE[]\" value=\"" . $x . "\" checked></td>\n";
                  }
                  else
                  {
                  $SitemapFileTypeHtml .="                <td><input type=\"checkbox\" name=\"SITEMAP_FILE_TYPE[]\" value=\"" . $x . "\"></td>\n";
                  } 
               }
               else
               {
               $SitemapFileTypeHtml .="                <td><input type=\"checkbox\" name=\"SITEMAP_FILE_TYPE[]\" value=\"" . $x . "\"></td>\n";
               }
               $SitemapFileTypeHtml .="                <td>" . $SitemapFileTypeTitleArray[$x] . "</td>\n";
            }
            else
            {
               $SitemapFileTypeHtml .="                <td>&nbsp;</td>\n";
               $SitemapFileTypeHtml .="                <td>&nbsp;</td>\n";
            }
            $x++;
         }
         $x--;
         $SitemapFileTypeHtml .="              </tr>\n";
      }
      $SitemapFileTypeHtml .="            </table>\n";
      $SitemapFileTypeHtml .="          </td>\n";
      $SitemapFileTypeHtml .="        </tr>\n";
      // Sitemap-Menue Bereich 3 - aktuelles Verzeichnis, Wechsel der Verzeichnisebene
      if(!empty($SitemapArray[1]) && preg_match("/^[1]$/", $SitemapArray[1])) {
         if(@chdir("../")) {
            $SitemapDirectoryLevel1=" checked";
            $SitemapCurrentWorkDirectory = getcwd() . "/";
            $SitemapDirectoryPathCorrection = "../";
         }
         else
         {
            $SitemapDirectoryLevel0=" checked";
            $SitemapMessagesHtml .="        <tr>\n";
            $SitemapMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $SitemapDirectoryChangeMessagesNotSuccessful . "</td>\n";
            $SitemapMessagesHtml .="        </tr>\n";
            $SitemapMessagesHtml .="        <tr>\n";
            $SitemapMessagesHtml .="          <td colspan=\"3\"><hr></td>\n";
            $SitemapMessagesHtml .="        </tr>\n";
         }
      } elseif(!empty($SitemapArray[1]) && preg_match("/^[2]$/", $SitemapArray[1])) {
         if(@chdir("../../")) {
            $SitemapDirectoryLevel2=" checked";
            $SitemapCurrentWorkDirectory = getcwd() . "/";
            $SitemapDirectoryPathCorrection = "../../";
         }
         else
         {
            $SitemapDirectoryLevel0=" checked";
            $SitemapMessagesHtml .="        <tr>\n";
            $SitemapMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $SitemapDirectoryChangeMessagesNotSuccessful . "</td>\n";
            $SitemapMessagesHtml .="        </tr>\n";
            $SitemapMessagesHtml .="        <tr>\n";
            $SitemapMessagesHtml .="          <td colspan=\"3\"><hr></td>\n";
            $SitemapMessagesHtml .="        </tr>\n";
         }
      } elseif(!empty($SitemapArray[1]) &&
         preg_match("/^[3]$/", $SitemapArray[1]) &&
         !empty($SitemapArray[2])) {
         $SitemapDirectoryPathChangeValue = trim($SitemapArray[2]);
         // einige Korrekturen bei moeglichen Fehleingaben (Verzeichnispfad)
         $SitemapTermArrayCount = count($SitemapTermArray);
         $SitemapReplacementArrayCount = count($SitemapReplacementArray);
         if(isset($SitemapTermArray) &&
            is_array($SitemapTermArray) &&
            isset($SitemapReplacementArray) &&
            is_array($SitemapReplacementArray) &&
            $SitemapTermArrayCount == $SitemapReplacementArrayCount) {
            for($x=0; $x<$SitemapTermArrayCount; $x++) {
               if(preg_match("@" . $SitemapTermArray[$x] . "@", $SitemapDirectoryPathChangeValue)) {
                  $SitemapDirectoryPathChangeValue = preg_replace("@" . $SitemapTermArray[$x] . "@", $SitemapReplacementArray[$x], $SitemapDirectoryPathChangeValue);
                  if(preg_match("@" . $SitemapTermArray[$x] . "@", $SitemapDirectoryPathChangeValue)) $x--;
               }
               if(preg_match('@^(\./|\.\./).+@', $SitemapDirectoryPathChangeValue)) {
                  if(!preg_match('@^.*/$@', $SitemapDirectoryPathChangeValue)) $SitemapDirectoryPathChangeValue = $SitemapDirectoryPathChangeValue . "/";
               }
               else
               {
               $SitemapDirectoryPathChangeValue='';
               }
            }
         }
         else
         {
            print 'NOTE: SYSTEM-ARRAY SitemapTermArray OR SitemapReplacementArray (ARRAY-COUNT) - function <strong>create_sitemap</strong> - ARE DAMAGED!';
            exit;
         }
         if(is_dir($SitemapDirectoryPathChangeValue) && @chdir($SitemapDirectoryPathChangeValue)) {
            $SitemapDirectoryLevel3=" checked";
            $SitemapCurrentWorkDirectory = getcwd() . "/";
            $SitemapDirectoryPathCorrection = $SitemapDirectoryPathChangeValue;
         }
         else
         {
            $SitemapDirectoryLevel0=" checked";
            $SitemapMessagesHtml .="        <tr>\n";
            $SitemapMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $SitemapDirectoryChangeMessagesNotSuccessful . "</td>\n";
            $SitemapMessagesHtml .="        </tr>\n";
            $SitemapMessagesHtml .="        <tr>\n";
            $SitemapMessagesHtml .="          <td colspan=\"3\"><hr></td>\n";
            $SitemapMessagesHtml .="        </tr>\n";
         }
      }
      else
      {
         $SitemapDirectoryLevel0=" checked";
         $SitemapCurrentWorkDirectory = $SitemapStartWorkDirectory;
         $SitemapDirectoryPathCorrection = "./";
      }
      // Sitemap - Verzeichnisse und Dateien ab dem aktuellen Startverzeichnis ermitteln
      if(!empty($SitemapArray[3]) &&
         is_array($SitemapArray[3]) &&
         isset($SitemapArray[5]) &&
         !empty($SitemapArray[6]) &&
         !empty($SitemapCurrentWorkDirectory)) {
         $SitemapCurrentDirectoryArray=array();
         $SitemapCurrentFileArray=array();
         $SitemapCurrentDirectoryArray[] = $SitemapCurrentWorkDirectory;
         $SitemapCurrentDirectoryArrayCount = count($SitemapCurrentDirectoryArray);
         $SitemapDirectoryMaxDepthCount = substr_count($SitemapCurrentWorkDirectory, '/') + $SitemapDirectoryDepth - 1;
         for($x=0; $x<$SitemapCurrentDirectoryArrayCount; $x++) {
            $SitemapFileHandle = @opendir($SitemapCurrentDirectoryArray[$x]);
            while($SitemapFileName = @readdir($SitemapFileHandle)) {
               if($SitemapFileName != "." && $SitemapFileName != "..") {
                  $SitemapDirectoryNameLength = strlen($SitemapCurrentDirectoryArray[$x]) - 1;
                  $SitemapDirectoryNameLastSlashPosition = strrpos($SitemapCurrentDirectoryArray[$x], '/');
                  if($SitemapDirectoryNameLength == $SitemapDirectoryNameLastSlashPosition) {
                     $SitemapCurrentDirectoryArray[$x] = substr($SitemapCurrentDirectoryArray[$x], 0, -1);
                  }
                  $SitemapNextFile = $SitemapCurrentDirectoryArray[$x] . "/" . $SitemapFileName;
                  $SitemapCurrentDirectoryCount = substr_count($SitemapNextFile, '/');
                  if(is_dir($SitemapNextFile) && $SitemapCurrentDirectoryCount <= $SitemapDirectoryMaxDepthCount) {
                     $SitemapCurrentDirectoryArray[] = $SitemapNextFile;
                     $SitemapCurrentDirectoryArrayCount = count($SitemapCurrentDirectoryArray);
                  } elseif(file_exists($SitemapNextFile)) {
                     $SitemapFileTypeNumberArrayCount = count($SitemapArray[3]);
                     if(!empty($SitemapArray[4])) {
                        $SitemapNoUnknownFiles=0;
                        for($y=0; $y<$SitemapFileTypeRegexArrayCurrentCount; $y++) {
                           if(preg_match("/" . $SitemapFileTypeRegexArray[$y] . "/i", $SitemapNextFile)) {
                              $SitemapNoUnknownFiles=1;
                              break;
                           }
                        }
                        if(empty($SitemapNoUnknownFiles)) $SitemapCurrentFileArray[] = $SitemapNextFile;
                     }
                     else
                     {
                        for($y=0; $y<$SitemapFileTypeNumberArrayCount; $y++) {
                           $SitemapFileTypeNumber = $SitemapArray[3][$y];
                           if(preg_match("/[0-9]{1,2}/", $SitemapArray[3][$y]) &&
                              $SitemapArray[3][$y] < $SitemapFileTypeRegexArrayCurrentCount &&
                              preg_match("/" . $SitemapFileTypeRegexArray[$SitemapFileTypeNumber] . "/i", $SitemapNextFile)) {
                              $SitemapCurrentFileArray[] = $SitemapNextFile;
                           }
                        }
                     }
                  }
               }
            }
            @closedir($SitemapFileHandle);
         }
         // Sitemap-Tabelle erstellen
         sort($SitemapCurrentDirectoryArray);
         sort($SitemapCurrentFileArray);
         $SitemapCurrentDirectoryArrayCount = count($SitemapCurrentDirectoryArray);
         $SitemapCurrentFileArrayCount = count($SitemapCurrentFileArray);
         $SitemapFileTypeRegexCurrentArrayCount = count($SitemapArray[3]);
         // Checkbox Unbekannte Dateitypen suchen aktivieren
         if(!empty($SitemapArray[4]) && preg_match("/^[1]$/", $SitemapArray[4])) $SitemapUnknownFilesOn=" checked";
         // Checkbox Editor-Modus aktivieren, Dateitypen: PHP, HTML, TXT, CSS, JS, CSV und DAT
         if(!empty($SitemapArray[5]) && preg_match("/^[1]$/", $SitemapArray[5])) $SitemapEditingModusOn=" checked";
         $SitemapContentHtml .="        <tr>\n";
         $SitemapContentHtml .="          <td colspan=\"3\">&nbsp;</td>\n";
         $SitemapContentHtml .="        </tr>\n";
         $SitemapContentHtml .="        <tr>\n";
         $SitemapContentHtml .="          <td colspan=\"3\">\n";
         $SitemapContentHtml .="            <table>\n";
         for($x=0; $x < $SitemapCurrentDirectoryArrayCount; $x++) {
            $SitemapCurrentDirectoryCtime = filectime($SitemapCurrentDirectoryArray[$x]);
            $SitemapCurrentDirectoryCtime = gmdate("Y-m-d H:i:s", $SitemapCurrentDirectoryCtime);
            $SitemapContentHtml .="              <tr>\n";
            $SitemapContentHtml .="                <td colspan=\"5\" class=\"" . $SitemapFileBackgroundColorCssNameArray[0] . "\">" . $SitemapCurrentDirectoryArray[$x] . "/</td>\n";
            $SitemapContentHtml .="                <td colspan=\"3\" class=\"" . $SitemapFileBackgroundColorCssNameArray[0] . "\">" . $SitemapCurrentDirectoryCtime . "</td>\n";
            $SitemapContentHtml .="              </tr>\n";
            for($y=0; $y<$SitemapCurrentFileArrayCount; $y++) {
               if(empty($SitemapArray[4])) {
                  for($z=0; $z<$SitemapFileTypeRegexCurrentArrayCount; $z++) {
                     $SitemapFileView='&nbsp;';
                     $SitemapCallEditor='&nbsp;';
                     $SitemapFileDownload='&nbsp;';
                     $SitemapFileTypeRegexCurrentElement = $SitemapArray[3][$z];
                     if(preg_match("@^" . $SitemapCurrentDirectoryArray[$x] . "/[^/]+" . $SitemapFileTypeRegexArray[$SitemapFileTypeRegexCurrentElement] . "$@i", $SitemapCurrentFileArray[$y])) {
                        $SitemapCurrentFilenameArray = explode('/', $SitemapCurrentFileArray[$y]);
                        $SitemapCurrentFilename = end($SitemapCurrentFilenameArray);
                        $SitemapCurrentFilenameSize = filesize($SitemapCurrentFileArray[$y]);
                        $SitemapCurrentFileMtime = filemtime($SitemapCurrentFileArray[$y]);
                        $SitemapCurrentFilenameMtime = gmdate("Y-m-d H:i:s", $SitemapCurrentFileMtime);
                        $SitemapCurrentFileView = preg_replace('@^' . $SitemapCurrentDirectoryArray[0] . '/@', $SitemapDirectoryPathCorrection, $SitemapCurrentFileArray[$y]);
                        $SitemapContentHtml .="              <tr>\n";
                        $SitemapContentHtml .="                <td class=\"sitemap_column_wide\">&nbsp;</td>\n";
                        if(preg_match("/.*" . $SitemapFileBackgroundColorRegexArray[0] . "/i", $SitemapCurrentFilename)) {
                           $SitemapContentHtml .= "                <td colspan=\"2\" class=\"" . $SitemapFileBackgroundColorCssNameArray[1] . "\">" . $SitemapCurrentFilename . "</td>\n";
                           $SitemapFileView = "<a href=\"" . $SitemapCurrentFileView . "\" target=\"FILEVIEWER\" class=\"sitemap\">" . $SitemapDetailsArray[36] . "</a>";
                           if(!empty($SitemapEditingModusOn)) $SitemapCallEditor = "<a href=\"" . $SitemapDetailsArray[0] . "?OBELIX_ID=" . $SitemapDetailsArray[3] . "&ACCESS_ID=" . $SitemapDetailsArray[2] . "&GET_FILENAME=" . $SitemapCurrentFileArray[$y] . "\" target=\"EDITOR\" class=\"sitemap\">" . $SitemapDetailsArray[37] . "</a>";
                        } elseif(preg_match("/.*" . $SitemapFileBackgroundColorRegexArray[1] . "/i", $SitemapCurrentFilename)) {
                           $SitemapContentHtml .= "                <td colspan=\"2\" class=\"" . $SitemapFileBackgroundColorCssNameArray[2] . "\">" . $SitemapCurrentFilename . "</td>\n";
                           $SitemapFileView = "<a href=\"" . $SitemapCurrentFileView . "\" target=\"FILEVIEWER\" class=\"sitemap\">" . $SitemapDetailsArray[36] . "</a>";
                           if(!empty($SitemapEditingModusOn)) $SitemapCallEditor = "<a href=\"" . $SitemapDetailsArray[0] . "?OBELIX_ID=" . $SitemapDetailsArray[3] . "&ACCESS_ID=" . $SitemapDetailsArray[2] . "&GET_FILENAME=" . $SitemapCurrentFileArray[$y] . "\" target=\"EDITOR\" class=\"sitemap\">" . $SitemapDetailsArray[37] . "</a>";
                        } elseif(preg_match("/.*" . $SitemapFileBackgroundColorRegexArray[2] . "/i", $SitemapCurrentFilename)) {
                           $SitemapContentHtml .= "                <td colspan=\"2\" class=\"" . $SitemapFileBackgroundColorCssNameArray[3] . "\">" . $SitemapCurrentFilename . "</td>\n";
                           $SitemapFileView = "<a href=\"" . $SitemapCurrentFileView . "\" target=\"FILEVIEWER\" class=\"sitemap\">" . $SitemapDetailsArray[36] . "</a>";
                           if(!empty($SitemapEditingModusOn)) $SitemapCallEditor = "<a href=\"" . $SitemapDetailsArray[0] . "?OBELIX_ID=" . $SitemapDetailsArray[4] . "&ACCESS_ID=" . $SitemapDetailsArray[2] . "&GET_FILENAME=" . $SitemapCurrentFileArray[$y] . "\" target=\"IMAGEEDITOR\" class=\"sitemap\">" . $SitemapDetailsArray[37] . "</a>";
                        } elseif(preg_match("/.*" . $SitemapFileBackgroundColorRegexArray[3] . "/i", $SitemapCurrentFilename)) {
                           $SitemapContentHtml .= "                <td colspan=\"2\" class=\"" . $SitemapFileBackgroundColorCssNameArray[4] . "\">" . $SitemapCurrentFilename . "</td>\n";
                           $SitemapFileDownload = "<a href=\"" . $SitemapCurrentFileView . "\" target=\"_self\" class=\"sitemap\">" . $SitemapDetailsArray[38] . "</a>";
                        } elseif(preg_match("/.*" . $SitemapFileBackgroundColorRegexArray[4] . "/i", $SitemapCurrentFilename)) {
                           $SitemapContentHtml .= "                <td colspan=\"2\" class=\"" . $SitemapFileBackgroundColorCssNameArray[5] . "\">" . $SitemapCurrentFilename . "</td>\n";
                           $SitemapFileView = "<a href=\"" . $SitemapCurrentFileView . "\" target=\"FILEVIEWER\" class=\"sitemap\">" . $SitemapDetailsArray[36] . "</a>";
                           if(!empty($SitemapEditingModusOn)) $SitemapCallEditor = "<a href=\"" . $SitemapDetailsArray[0] . "?OBELIX_ID=" . $SitemapDetailsArray[3] . "&ACCESS_ID=" . $SitemapDetailsArray[2] . "&GET_FILENAME=" . $SitemapCurrentFileArray[$y] . "\" target=\"EDITOR\" class=\"sitemap\">" . $SitemapDetailsArray[37] . "</a>";
                        } elseif(preg_match("/.*" . $SitemapFileBackgroundColorRegexArray[5] . "/i", $SitemapCurrentFilename)) {
                           $SitemapContentHtml .= "                <td colspan=\"2\" class=\"" . $SitemapFileBackgroundColorCssNameArray[6] . "\">" . $SitemapCurrentFilename . "</td>\n";
                           $SitemapFileView = "<a href=\"" . $SitemapCurrentFileView . "\" target=\"FILEVIEWER\" class=\"sitemap\">" . $SitemapDetailsArray[36] . "</a>";
                           $SitemapFileDownload = "<a href=\"" . $SitemapCurrentFileView . "\" target=\"FILEVIEWER\" class=\"sitemap\">" . $SitemapDetailsArray[38] . "</a>";
                        } elseif(preg_match("/.*" . $SitemapFileBackgroundColorRegexArray[6] . "/i", $SitemapCurrentFilename)) {
                           $SitemapContentHtml .= "                <td colspan=\"2\" class=\"" . $SitemapFileBackgroundColorCssNameArray[7] . "\">" . $SitemapCurrentFilename . "</td>\n";
                           $SitemapFileView = "<a href=\"" . $SitemapCurrentFileView . "\" target=\"FILEVIEWER\" class=\"sitemap\">" . $SitemapDetailsArray[36] . "</a>";
                           $SitemapFileDownload = "<a href=\"" . $SitemapCurrentFileView . "\" target=\"FILEVIEWER\" class=\"sitemap\">" . $SitemapDetailsArray[38] . "</a>";
                        } elseif(preg_match("/.*" . $SitemapFileBackgroundColorRegexArray[7] . "/i", $SitemapCurrentFilename)) {
                           $SitemapContentHtml .= "                <td colspan=\"2\" class=\"" . $SitemapFileBackgroundColorCssNameArray[8] . "\">" . $SitemapCurrentFilename . "</td>\n";
                           $SitemapFileView = "<a href=\"" . $SitemapCurrentFileView . "\" target=\"FILEVIEWER\" class=\"sitemap\">" . $SitemapDetailsArray[36] . "</a>";
                           $SitemapFileDownload = "<a href=\"" . $SitemapCurrentFileView . "\" target=\"FILEVIEWER\" class=\"sitemap\">" . $SitemapDetailsArray[38] . "</a>";
                        }
                        else
                        {
                           $SitemapContentHtml .= "                <td colspan=\"2\" class=\"" . $SitemapFileBackgroundColorCssNameArray[9] . "\">" . $SitemapCurrentFilename . "</td>\n";
                           $SitemapFileView = "<a href=\"" . $SitemapCurrentFileView . "\" target=\"FILEVIEWER\" class=\"sitemap\">" . $SitemapDetailsArray[36] . "</a>";
                        }
                        if($SitemapCurrentFilenameSize > $GigaByte) {
                           $SizeValue = $SitemapCurrentFilenameSize / $GigaByte;
                           $FileSize = round($SizeValue, 3) . " " . $SitemapDetailsArray[42];
                        } elseif($SitemapCurrentFilenameSize > $MegaByte) {
                           $SizeValue = $SitemapCurrentFilenameSize / $MegaByte;
                           $FileSize = round($SizeValue, 3) . " " . $SitemapDetailsArray[43];
                        } elseif($SitemapCurrentFilenameSize > $KiloByte) {
                           $SizeValue = $SitemapCurrentFilenameSize / $KiloByte;
                           $FileSize = round($SizeValue, 2) . " " . $SitemapDetailsArray[44];
                        }
                        else
                        {
                        $FileSize = $SitemapCurrentFilenameSize . " " . $SitemapDetailsArray[45];
                        }
                        $SitemapContentHtml .="                <td class=\"gray_right\">" . $FileSize . "</td>\n";
                        $SitemapContentHtml .="                <td class=\"gray\">" . $SitemapCurrentFilenameMtime . "</td>\n";
                        $SitemapContentHtml .="                <td class=\"gray\">" . $SitemapFileView . "</td>\n";
                        $SitemapContentHtml .="                <td class=\"gray\">" . $SitemapCallEditor . "</td>\n";
                        $SitemapContentHtml .="                <td class=\"gray\">" . $SitemapFileDownload . "</td>\n";
                        $SitemapContentHtml .="              </tr>\n";
                     }
                  }
               } elseif(!empty($SitemapArray[4])) {
                  for($y=0; $y<$SitemapCurrentFileArrayCount; $y++) {
                     $SitemapFileView='&nbsp;';
                     $SitemapCallEditor='&nbsp;';
                     $SitemapFileDownload='&nbsp;';
                     if(preg_match("@^" . $SitemapCurrentDirectoryArray[$x] . "/[^/]+$@", $SitemapCurrentFileArray[$y])) {
                        $SitemapCurrentFilenameArray = explode('/', $SitemapCurrentFileArray[$y]);
                        $SitemapCurrentFilename = end($SitemapCurrentFilenameArray);
                        $SitemapCurrentFilenameSize = filesize($SitemapCurrentFileArray[$y]);
                        $SitemapCurrentFileMtime = filemtime($SitemapCurrentFileArray[$y]);
                        $SitemapCurrentFilenameMtime = gmdate("Y-m-d H:i:s", $SitemapCurrentFileMtime);
                        $SitemapCurrentFileView = preg_replace('@^' . $SitemapCurrentDirectoryArray[0] . '/@', $SitemapDirectoryPathCorrection, $SitemapCurrentFileArray[$y]);
                        if($SitemapCurrentFilenameSize > $GigaByte) {
                           $SizeValue = $SitemapCurrentFilenameSize / $GigaByte;
                           $FileSize = round($SizeValue, 3) . " " . $SitemapDetailsArray[42];
                        } elseif($SitemapCurrentFilenameSize > $MegaByte) {
                           $SizeValue = $SitemapCurrentFilenameSize / $MegaByte;
                           $FileSize = round($SizeValue, 3) . " " . $SitemapDetailsArray[43];
                        } elseif($SitemapCurrentFilenameSize > $KiloByte) {
                           $SizeValue = $SitemapCurrentFilenameSize / $KiloByte;
                           $FileSize = round($SizeValue, 2) . " " . $SitemapDetailsArray[44];
                        }
                        else
                        {
                        $FileSize = $SitemapCurrentFilenameSize . " " . $SitemapDetailsArray[45];
                        }
                        $SitemapContentHtml .="              <tr>\n";
                        $SitemapContentHtml .="                <td class=\"sitemap_column_wide\">&nbsp;</td>\n";
                        $SitemapContentHtml .= "               <td colspan=\"2\" class=\"" . $SitemapFileBackgroundColorCssNameArray[9] . "\">" . $SitemapCurrentFilename . "</td>\n";
                        $SitemapFileView = "<a href=\"./" . $SitemapCurrentFileView . "\" target=\"FILEVIEWER\" class=\"sitemap\">" . $SitemapDetailsArray[36] . "</a>";
                        $SitemapContentHtml .="                <td class=\"gray_right\">" . $FileSize . "</td>\n";
                        $SitemapContentHtml .="                <td class=\"gray\">" . $SitemapCurrentFilenameMtime . "</td>\n";
                        $SitemapContentHtml .="                <td class=\"gray\">" . $SitemapFileView . "</td>\n";
                        $SitemapContentHtml .="                <td class=\"gray\">" . $SitemapCallEditor . "</td>\n";
                        $SitemapContentHtml .="                <td class=\"gray\">" . $SitemapFileDownload . "</td>\n";
                        $SitemapContentHtml .="              </tr>\n";
                     }
                  }
               }
            }
         }
         $SitemapContentHtml .="              <tr>\n";
         $SitemapContentHtml .="                <td class=\"" . $SitemapFileBackgroundColorCssNameArray[0] . "\">&nbsp;</td>\n";
         $SitemapContentHtml .="                <td colspan=\"7\" class=\"" . $SitemapFileBackgroundColorCssNameArray[0] . "\">" . $SitemapDetailsArray[39] . " " . $SitemapCurrentDirectoryArrayCount . "&nbsp;&nbsp;&nbsp;" . $SitemapDetailsArray[40] . " " . $SitemapCurrentFileArrayCount . "</td>\n";
         $SitemapContentHtml .="              </tr>\n";
         $SitemapContentHtml .="            </table>\n";
         $SitemapContentHtml .="          </td>\n";
         $SitemapContentHtml .="        </tr>\n";
      }
      clearstatcache();
   } elseif(!isset($SitemapArray) ||
      !is_array($SitemapArray) ||
      $SitemapArrayDefaultCount != $SitemapArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY SitemapArray (ARRAY-COUNT) - function <strong>create_sitemap</strong> - IS DAMAGED!';
      exit;
   } elseif(!isset($SitemapFileTypeTitleArray) ||
      !is_array($SitemapFileTypeTitleArray) ||
      $SitemapFileTypeTitleArrayDefaultCount != $SitemapFileTypeTitleArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY SitemapFileTypeTitleArray (ARRAY-COUNT) - function <strong>create_sitemap</strong> - IS DAMAGED!';
      exit;
   } elseif(!isset($SitemapFileTypeRegexArray) ||
      !is_array($SitemapFileTypeRegexArray) ||
      $SitemapFileTypeRegexArrayDefaultCount != $SitemapFileTypeRegexArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY SitemapFileTypeRegexArray (ARRAY-COUNT) - function <strong>create_sitemap</strong> - IS DAMAGED!';
      exit;
   } elseif(!isset($SitemapFileBackgroundColorRegexArray) ||
      !is_array($SitemapFileBackgroundColorRegexArray) ||
      $SitemapFileBackgroundColorRegexArrayDefaultCount != $SitemapFileBackgroundColorRegexArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY SitemapFileBackgroundColorRegexArray (ARRAY-COUNT) - function <strong>create_sitemap</strong> - IS DAMAGED!';
      exit;
   } elseif(!isset($SitemapFileBackgroundColorCssNameArray) ||
      !is_array($SitemapFileBackgroundColorCssNameArray) ||
      $SitemapFileBackgroundColorCssNameArrayDefaultCount != $SitemapFileBackgroundColorCssNameArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY SitemapFileBackgroundColorCssNameArray (ARRAY-COUNT) - function <strong>create_sitemap</strong> - IS DAMAGED!';
      exit;
   }
   else
   {
      print 'NOTE: SYSTEM-ARRAY SitemapDetailsArray (ARRAY-COUNT) - function <strong>create_sitemap</strong> - IS DAMAGED!';
      exit;
   }
   $MainContent="    <form name=\"form_sitemap\" method=\"post\" action=\"" . $SitemapDetailsArray[0] . "?OBELIX_ID=" . $SitemapDetailsArray[1] . "&ACCESS_ID=" . $SitemapDetailsArray[2] . "\" target=\"_self\">\n";
   $MainContent .="      <table class=\"table_wide\">\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\" class=\"center\"><h3>" . $SitemapDetailsArray[5] . "</h3></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">" . $SitemapDetailsArray[6] . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\"><hr></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .= $SitemapMessagesHtml;
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"2\"><strong>" . $SitemapDetailsArray[7] . "</strong> " . $SitemapStartWorkDirectory . "<br></td>\n";
   $MainContent .="          <td class=\"center\"><strong>" . $SitemapDetailsArray[11] . "</strong></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"2\"><strong>" . $SitemapDetailsArray[8] . "</strong> " . $SitemapCurrentWorkDirectory . "<br></td>\n";
   $MainContent .="          <td rowspan=\"21\" class=\"column_help_text\">" . $SitemapDetailsArray[12] . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"2\"><strong>" . $SitemapDetailsArray[10] . "</strong> " . $SitemapDirectoryDepth . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"2\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .= $SitemapFileTypeHtml;
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"2\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"column_wide\">&nbsp;</td>\n";
   $MainContent .="          <td><strong>" . $SitemapDetailsArray[13] . "</strong></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"right\"><input type=\"radio\" name=\"SITEMAP_DIRECTORY_LEVEL\" value=\"0\"" . $SitemapDirectoryLevel0 . "></td>\n";
   $MainContent .="          <td>" . $SitemapDetailsArray[14] . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"right\"><input type=\"radio\" name=\"SITEMAP_DIRECTORY_LEVEL\" value=\"1\"" . $SitemapDirectoryLevel1 . "></td>\n";
   $MainContent .="          <td>" . $SitemapDetailsArray[15] . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"right\"><input type=\"radio\" name=\"SITEMAP_DIRECTORY_LEVEL\" value=\"2\"" . $SitemapDirectoryLevel2 . "></td>\n";
   $MainContent .="          <td>" . $SitemapDetailsArray[16] . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"right\"><input type=\"radio\" name=\"SITEMAP_DIRECTORY_LEVEL\" value=\"3\"" . $SitemapDirectoryLevel3 . "></td>\n";
   $MainContent .="          <td>" . $SitemapDetailsArray[17] . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"right\">" . $SitemapDetailsArray[18] . " </td>\n";
   $MainContent .="          <td><input type=\"text\" name=\"SITEMAP_DIRECTORY_LEVEL_CHANGE\" size=\"20\" maxlength=\"128\" value=\"" . $SitemapDirectoryPathChangeValue . "\">&nbsp;" . $SitemapDetailsArray[19] . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"2\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"2\">" . $SitemapDetailsArray[20] . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"2\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"right\"><input type=\"checkbox\" name=\"SITEMAP_VIEW_UNKNOWN_FILETYPES\" value=\"1\"" . $SitemapUnknownFilesOn . "></td>\n";
   $MainContent .="          <td>" . $SitemapDetailsArray[21] . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"2\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"right\"><input type=\"checkbox\" name=\"SITEMAP_EDIT_MODUS\" value=\"1\"" . $SitemapEditingModusOn . "></td>\n";
   $MainContent .="          <td>" . $SitemapDetailsArray[22] . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"2\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"right\">" . $SitemapDetailsArray[23] . "</td>\n";
   $MainContent .="          <td><input type=\"number\" name=\"SITEMAP_DIRECTORY_DEPTH\" min=\"1\" max=\"9\" size=\"1\" value=\"" . $SitemapDirectoryDepth ."\"></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"2\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"2\">\n";
   $MainContent .="            <table class=\"legend_table\">\n";
   $MainContent .="              <tr>\n";
   $MainContent .="                <th colspan=\"12\">" . $SitemapDetailsArray[24] . "</th>\n";
   $MainContent .="              </tr>\n";
   $MainContent .="              <tr>\n";
   $MainContent .="                <td>&nbsp;</td>\n";
   $MainContent .="                <td class=\"legend_dir\">&nbsp;</td>\n";
   $MainContent .="                <td class=\"legend_htm\">&nbsp;</td>\n";
   $MainContent .="                <td class=\"legend_php\">&nbsp;</td>\n";
   $MainContent .="                <td class=\"legend_text\">&nbsp;</td>\n";
   $MainContent .="                <td class=\"legend_img\">&nbsp;</td>\n";
   $MainContent .="                <td class=\"legend_zip\">&nbsp;</td>\n";
   $MainContent .="                <td class=\"legend_pdf\">&nbsp;</td>\n";
   $MainContent .="                <td class=\"legend_audio\">&nbsp;</td>\n";
   $MainContent .="                <td class=\"legend_video\">&nbsp;</td>\n";
   $MainContent .="                <td class=\"legend_files\">&nbsp;</td>\n";
   $MainContent .="                <td>&nbsp;</td>\n";
   $MainContent .="              </tr>\n";
   $MainContent .="              <tr>\n";
   $MainContent .="                <td>&nbsp;</td>\n";
   $MainContent .="                <td class=\"center\">" . $SitemapDetailsArray[25] . " </td>\n";
   $MainContent .="                <td class=\"center\">" . $SitemapDetailsArray[26] . " </td>\n";
   $MainContent .="                <td class=\"center\">" . $SitemapDetailsArray[27] . " </td>\n";
   $MainContent .="                <td class=\"center\">" . $SitemapDetailsArray[28] . " </td>\n";
   $MainContent .="                <td class=\"center\">" . $SitemapDetailsArray[29] . " </td>\n";
   $MainContent .="                <td class=\"center\">" . $SitemapDetailsArray[30] . " </td>\n";
   $MainContent .="                <td class=\"center\">" . $SitemapDetailsArray[31] . " </td>\n";
   $MainContent .="                <td class=\"center\">" . $SitemapDetailsArray[32] . " </td>\n";
   $MainContent .="                <td class=\"center\">" . $SitemapDetailsArray[33] . " </td>\n";
   $MainContent .="                <td class=\"center\">" . $SitemapDetailsArray[34] . " </td>\n";
   $MainContent .="                <td>&nbsp;</td>\n";
   $MainContent .="              </tr>\n";
   $MainContent .="            </table>\n";
   $MainContent .="          </td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\" class=\"center\"><input type=\"submit\" name=\"SITEMAP_SUBMIT\" value=\"" . $SitemapDetailsArray[35] . "\"></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\"><hr></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .= $SitemapContentHtml;
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="      </table>\n";
   $MainContent .="    </form>\n";
   return $MainContent;
}

// CSS - Navigation: SITEMAP
function create_sitemap_css() {
   $SitemapCSS="h3 {\n  font-size: 1.15em;\n  font-weight: bold;\n  text-align: center;\n}\n\n";
   $SitemapCSS .=".table_wide { width: 100%; }\n\n";
   $SitemapCSS .="td { font-size: 0.9em; }\n\n";
   $SitemapCSS .="hr { width: 100%; }\n\n";
   $SitemapCSS .="a.sitemap {\n  font-family: sans-serif;\n  font-size: 0.85em;\n  font-weight: normal;\n}\n\n";
   $SitemapCSS .=".column_wide { width: 20%; }\n\n";
   $SitemapCSS .=".sitemap_column_wide {\n  width: 8%;\n  background-color: #E0E0E0;\n}\n\n";
   $SitemapCSS .=".column_help_text {\n  width: 38%;\n  vertical-align: top;\n}\n\n";
   $SitemapCSS .=".red {\n  font-size: 0.95em;\n  font-weight: bold;\n  text-align: center;\n  color:#DD0000;\n}\n\n";
   $SitemapCSS .=".right {\n  width: 15%;\n  text-align: right;\n}\n\n";
   $SitemapCSS .=".legend_table { width: 100%; }\n\n";
   $SitemapCSS .="input { font-size: 0.85em; }\n\n";
   $SitemapCSS .=".gray {\n  font-size: 0.9em;\n  background-color: #EDEDED;\n}\n\n";
   $SitemapCSS .=".gray_right {\n  font-size: 0.9em;\n  text-align: right;\n  background-color: #EDEDED;\n}\n\n";
   $SitemapCSS .=".dir {\n  font-size: 0.9em;\n  background-color: #CFC181;\n}\n\n";
   $SitemapCSS .=".htm {\n  font-size: 0.9em;\n  background-color: #6FA2C8;\n}\n\n";
   $SitemapCSS .=".php {\n  font-size: 0.9em;\n  background-color: #75C86F;\n}\n\n";
   $SitemapCSS .=".text {\n  font-size: 0.9em;\n  background-color: #EAC8CA;\n}\n\n";
   $SitemapCSS .=".img {\n  font-size: 0.9em;\n  background-color: #CD7A7F;\n}\n\n";
   $SitemapCSS .=".zip {\n  font-size: 0.9em;\n  background-color: #CA81CF;\n}\n\n";
   $SitemapCSS .=".pdf {\n  font-size: 0.9em;\n  background-color: #3B9B95;\n}\n\n";
   $SitemapCSS .=".audio {\n  font-size: 0.9em;\n  background-color: #C8966F;\n}\n\n";
   $SitemapCSS .=".video {\n  font-size: 0.9em;\n  background-color: #E6B800;\n}\n\n";
   $SitemapCSS .=".files {\n  font-size: 0.9em;\n  background-color: #9BD9D5;\n}\n\n";
   $SitemapCSS .=".legend_dir {\n  width: 12%;\n  font-size: 0.9em;\n  background-color: #CFC181;\n}\n\n";
   $SitemapCSS .=".legend_htm {\n  width: 8%;\n  font-size: 0.9em;\n  background-color: #6FA2C8;\n}\n\n";
   $SitemapCSS .=".legend_php {\n  width: 8%;\n  font-size: 0.9em;\n  background-color: #75C86F;\n}\n\n";
   $SitemapCSS .=".legend_text {\n  width: 8%;\n  font-size: 0.9em;\n  background-color: #EAC8CA;\n}\n\n";
   $SitemapCSS .=".legend_img {\n  width: 8%;\n  font-size: 0.9em;\n  background-color: #CD7A7F;\n}\n\n";
   $SitemapCSS .=".legend_zip {\n  width: 8%;\n  font-size: 0.9em;\n  background-color: #CA81CF;\n}\n\n";
   $SitemapCSS .=".legend_pdf {\n  width: 8%;\n  font-size: 0.9em;\n  background-color: #3B9B95;\n}\n\n";
   $SitemapCSS .=".legend_audio {\n  width: 8%;\n  font-size: 0.9em;\n  background-color: #C8966F;\n}\n\n";
   $SitemapCSS .=".legend_video {\n  width: 8%;\n  font-size: 0.9em;\n  background-color: #E6B800;\n}\n\n";
   $SitemapCSS .=".legend_files {\n  width: 8%;\n  font-size: 0.9em;\n  background-color: #9BD9D5;\n}\n\n";
   return $SitemapCSS;
}

// Erstellung der Webseite SPLITFILES
function create_splitfiles($ObelixFileNameArray='', $SplitfilesArray='', $SplitfilesDetailsArray='', $SplitfilesMessagesArray='') {
   $SplitfilesMessagesHtml="";
   if(empty($SplitfilesDetailsArray[0])) $SplitfilesDetailsArray[0]=0;
   if(empty($SplitfilesDetailsArray[1])) $SplitfilesDetailsArray[1]=0;
   $ObelixFileNameArrayDefaultCount=15; // Vorgabe: Anzahl der Array-Elemente
   $ObelixFileNameArrayCurrentCount=count($ObelixFileNameArray);
   $SplitfilesArrayDefaultCount=4; // Vorgabe: Anzahl der Array-Elemente
   $SplitfilesArrayCurrentCount=count($SplitfilesArray);
   $SplitfilesDetailsArrayDefaultCount=8; // Vorgabe: Anzahl der Array-Elemente
   $SplitfilesDetailsArrayCurrentCount=count($SplitfilesDetailsArray);
   $SplitfilesMessagesArrayDefaultCount=5; // Vorgabe: Anzahl der Array-Elemente
   $SplitfilesMessagesArrayCurrentCount=count($SplitfilesMessagesArray);
   if(isset($ObelixFileNameArray) &&
      is_array($ObelixFileNameArray) &&
      $ObelixFileNameArrayDefaultCount == $ObelixFileNameArrayCurrentCount &&
      isset($SplitfilesArray) &&
      is_array($SplitfilesArray) &&
      $SplitfilesArrayDefaultCount == $SplitfilesArrayCurrentCount &&
      isset($SplitfilesDetailsArray) &&
      is_array($SplitfilesDetailsArray) &&
      $SplitfilesDetailsArrayDefaultCount == $SplitfilesDetailsArrayCurrentCount &&
      isset($SplitfilesMessagesArray) &&
      is_array($SplitfilesMessagesArray) &&
      $SplitfilesMessagesArrayDefaultCount == $SplitfilesMessagesArrayCurrentCount) {
      $FunctionsDisable=@ini_get('disable_functions');
      if(!preg_match("/exec/",$FunctionsDisable)) {
         if(!empty($SplitfilesArray[1]) && !empty($SplitfilesArray[2])) {
            $SplitfilesMessagesHtml .="        <tr>\n";
            $SplitfilesMessagesHtml .="          <td colspan=\"3\"><hr></td>\n";
            $SplitfilesMessagesHtml .="        </tr>\n";
            $SplitfilesLinuxCommand = "cat \"" . $SplitfilesArray[1] . "\"* > " . $SplitfilesArray[2];
            @exec($SplitfilesLinuxCommand, $CatCommandMessagesArray, $CatExitStatus);
            if($CatExitStatus == 0 && file_exists($SplitfilesArray[2])) {
               $SplitfilesMessagesHtml .="        <tr>\n";
               $SplitfilesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $SplitfilesMessagesArray[0] . " " . $SplitfilesArray[2] . " !</td>\n";
               $SplitfilesMessagesHtml .="        </tr>\n";
               if(!empty($SplitfilesArray[0])) {
                  $SplitfilesLinuxCommandRemove="rm -f \"" . $SplitfilesArray[1] . "\"*";
                  @exec($SplitfilesLinuxCommandRemove, $RemoveCommandMessagesArray, $RemoveExitStatus);
                  if($RemoveExitStatus == 0) {
                     $SplitfilesMessagesHtml .="        <tr>\n";
                     $SplitfilesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $SplitfilesMessagesArray[1] . "</td>\n";
                     $SplitfilesMessagesHtml .="        </tr>\n";
                  }
                  else
                  {
                     $SplitfilesMessagesHtml .="        <tr>\n";
                     $SplitfilesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $SplitfilesMessagesArray[3] . "</td>\n";
                     $SplitfilesMessagesHtml .="        </tr>\n";
                  }
               }
            }
            else
            {
               $SplitfilesMessagesHtml .="        <tr>\n";
               $SplitfilesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $SplitfilesMessagesArray[2] . "</td>\n";
               $SplitfilesMessagesHtml .="        </tr>\n";
            }
            $SplitfilesMessagesHtml .="        <tr>\n";
            $SplitfilesMessagesHtml .="          <td colspan=\"3\"><hr></td>\n";
            $SplitfilesMessagesHtml .="        </tr>\n";
         }
      } elseif(!empty($SplitfilesArray[3])) {
         $SplitfilesMessagesHtml .="        <tr>\n";
         $SplitfilesMessagesHtml .="          <td colspan=\"3\"><hr></td>\n";
         $SplitfilesMessagesHtml .="        </tr>\n";
         $SplitfilesMessagesHtml .="        <tr>\n";
         $SplitfilesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $SplitfilesMessagesArray[4] . "</td>\n";
         $SplitfilesMessagesHtml .="        </tr>\n";
         $SplitfilesMessagesHtml .="        <tr>\n";
         $SplitfilesMessagesHtml .="          <td colspan=\"3\"><hr></td>\n";
         $SplitfilesMessagesHtml .="        </tr>\n";
      }
   } elseif(!isset($ObelixFileNameArray) ||
      !is_array($ObelixFileNameArray) ||
      $ObelixFileNameArrayDefaultCount != $ObelixFileNameArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY ObelixFileNameArray (ARRAY-COUNT) - function <strong>create_splitfiles</strong> - IS DAMAGED!';
      exit;
   } elseif(!isset($SplitfilesArray) ||
      !is_array($SplitfilesArray) ||
      $SplitfilesArrayDefaultCount != $SplitfilesArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY SplitfilesArray (ARRAY-COUNT) - function <strong>create_splitfiles</strong> - IS DAMAGED!';
      exit;
   } elseif(!isset($SplitfilesDetailsArray) ||
      !is_array($SplitfilesDetailsArray) ||
      $SplitfilesDetailsArrayDefaultCount != $SplitfilesDetailsArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY SplitfilesDetailsArray (ARRAY-COUNT) - function <strong>create_splitfiles</strong> - IS DAMAGED!';
      exit;
   }
   else
   {
      print 'NOTE: SYSTEM-ARRAY SplitfilesMessagesArray (ARRAY-COUNT) - function <strong>create_splitfiles</strong> - IS DAMAGED!';
      exit;
   }
   $MainContent="    <form name=\"form_splitfiles\" method=\"post\" action=\"" . $ObelixFileNameArray[4] . "?OBELIX_ID=" . $SplitfilesDetailsArray[0] . "&ACCESS_ID=" . $SplitfilesDetailsArray[1] . "\" target=\"_self\">\n";
   $MainContent .="      <table>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\" class=\"center\"><h3>" . $SplitfilesDetailsArray[2] . "</h3></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">" . $SplitfilesDetailsArray[3] . "</td>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .= $SplitfilesMessagesHtml;
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="          <td class=\"right_bold\">" . $SplitfilesDetailsArray[4] . "</td>\n";
   $MainContent .="          <td><input type=\"text\" name=\"SPLITFILES_NAME\" size=\"40\" maxlength=\"128\" value=\"" . $SplitfilesArray[1] . "\"></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"column_wide\">&nbsp;</td>\n";
   $MainContent .="          <td class=\"right\"><input type=\"checkbox\" name=\"SPLITFILES_REMOVE\" value=\"1\" checked></td>\n";
   $MainContent .="          <td>" . $SplitfilesDetailsArray[5] . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="          <td colspan=\"2\">" . $SplitfilesDetailsArray[6] . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="          <td class=\"right\">" . $ObelixFileNameArray[0] . "</td>\n";
   $MainContent .="          <td><input type=\"radio\" name=\"SPLITFILES_CAT_NAME\" value=\"" . $ObelixFileNameArray[0] . "\" checked></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="          <td class=\"right\">" . $ObelixFileNameArray[5] . "</td>\n";
   $MainContent .="          <td><input type=\"radio\" name=\"SPLITFILES_CAT_NAME\" value=\"" . $ObelixFileNameArray[5] . "\"></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="          <td class=\"right\">" . $ObelixFileNameArray[6] . "</td>\n";
   $MainContent .="          <td><input type=\"radio\" name=\"SPLITFILES_CAT_NAME\" value=\"" . $ObelixFileNameArray[6] . "\"></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="          <td class=\"right\">" . $ObelixFileNameArray[8] . "</td>\n";
   $MainContent .="          <td><input type=\"radio\" name=\"SPLITFILES_CAT_NAME\" value=\"" . $ObelixFileNameArray[8] . "\"></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\" class=\"center\"><input type=\"submit\" name=\"SPLITFILES_SUBMIT\" value=\"" . $SplitfilesDetailsArray[7] . "\"></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="      </table>\n";
   $MainContent .="    </form>\n";
   return $MainContent;
}

// CSS - Navigation: SPLITFILES
function create_splitfiles_css() {
   $SplitfilesCSS="h3 {\n  font-size: 1.15em;\n  font-weight: bold;\n  text-align: center;\n}\n\n";
   $SplitfilesCSS .="table { width: 100%; }\n\n";
   $SplitfilesCSS .="td { font-size: 0.9em; }\n\n";
   $SplitfilesCSS .=".column_wide { width: 20%; }\n\n";
   $SplitfilesCSS .="hr { width: 100%; }\n\n";
   $SplitfilesCSS .="input { font-size: 0.85em; }\n\n";
   $SplitfilesCSS .=".red {\n  font-size: 0.95em;\n  font-weight: bold;\n  text-align: center;\n  color:#DD0000;\n}\n\n";
   $SplitfilesCSS .=".right { text-align: right; }\n\n";
   $SplitfilesCSS .=".right_bold {\n  font-weight: bold;\n  text-align: right;\n}\n\n";
   return $SplitfilesCSS;
}

// Erstellung der Webseite DIRDELETE
function create_dirdelete($DirDeleteArray='', $DirdeleteDetailsArray='', $DirdeleteMessagesArray='') {
   $DirDeleteDirectoryDepthHtml="";
   $DirDeleteContentHtml="";
   $DirDeleteMessagesHtml="";
   if(empty($DirdeleteDetailsArray[1])) $DirdeleteDetailsArray[1]=0;
   if(empty($DirdeleteDetailsArray[2])) $DirdeleteDetailsArray[2]=0;
   if(empty($DirdeleteDetailsArray[6])) $DirdeleteDetailsArray[6]=3;
   $DirDeleteCurrentWorkDirectory = getcwd() . "/";
   $DirDeleteArrayDefaultCount=3; // Vorgabe: Anzahl der Array-Elemente
   $DirDeleteArrayCurrentCount=count($DirDeleteArray);
   $DirdeleteDetailsArrayDefaultCount=22; // Vorgabe: Anzahl der Array-Elemente
   $DirdeleteDetailsArrayCurrentCount=count($DirdeleteDetailsArray);
   $DirdeleteMessagesArrayDefaultCount=4; // Vorgabe: Anzahl der Array-Elemente
   $DirdeleteMessagesArrayCurrentCount=count($DirdeleteMessagesArray);
   if(isset($DirDeleteArray) &&
      is_array($DirDeleteArray) &&
      $DirDeleteArrayDefaultCount == $DirDeleteArrayCurrentCount &&
      isset($DirdeleteDetailsArray) &&
      is_array($DirdeleteDetailsArray) &&
      $DirdeleteDetailsArrayDefaultCount == $DirdeleteDetailsArrayCurrentCount &&
      isset($DirdeleteMessagesArray) &&
      is_array($DirdeleteMessagesArray) &&
      $DirdeleteMessagesArrayDefaultCount == $DirdeleteMessagesArrayCurrentCount) {
      if(!empty($DirDeleteArray[2]) && $DirDeleteArray[2] == 1) {
         $DirDeleteFunctionsDisable = @ini_get('disable_functions');
         if(!preg_match("/exec/",$DirDeleteFunctionsDisable)) {
            if(!empty($DirDeleteArray[1]) && is_dir($DirDeleteArray[1])) {
               $DirDeleteCommand = "rm -rf \"" . $DirDeleteArray[1] . "\"";
               @exec($DirDeleteCommand, $DirDeleteCommandMessageArray, $DirDeleteExitStatus);
               if($DirDeleteExitStatus == 0) {
                  $DirDeleteMessagesHtml .="        <tr>\n";
                  $DirDeleteMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $DirdeleteMessagesArray[0] . "</td>\n";
                  $DirDeleteMessagesHtml .="        </tr>\n";
                  $DirDeleteMessagesHtml .="        <tr>\n";
                  $DirDeleteMessagesHtml .="          <td colspan=\"3\"><hr></td>\n";
                  $DirDeleteMessagesHtml .="        </tr>\n";
               }
               else
               {
                  $DirDeleteMessagesHtml .="        <tr>\n";
                  $DirDeleteMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $DirdeleteMessagesArray[1] . "</td>\n";
                  $DirDeleteMessagesHtml .="        </tr>\n";
                  $DirDeleteMessagesHtml .="        <tr>\n";
                  $DirDeleteMessagesHtml .="          <td colspan=\"3\"><hr></td>\n";
                  $DirDeleteMessagesHtml .="        </tr>\n";
               }
            } elseif(!empty($DirDeleteArray[1]) && !is_dir($DirDeleteArray[1])) {
               $DirDeleteMessagesHtml .="        <tr>\n";
               $DirDeleteMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $DirdeleteMessagesArray[2] . "</td>\n";
               $DirDeleteMessagesHtml .="        </tr>\n";
               $DirDeleteMessagesHtml .="        <tr>\n";
               $DirDeleteMessagesHtml .="          <td colspan=\"3\"><hr></td>\n";
               $DirDeleteMessagesHtml .="        </tr>\n";
            }
         }
         else
         {
            $DirDeleteMessagesHtml .="        <tr>\n";
            $DirDeleteMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $DirdeleteMessagesArray[3] . "</td>\n";
            $DirDeleteMessagesHtml .="        </tr>\n";
            $DirDeleteMessagesHtml .="        <tr>\n";
            $DirDeleteMessagesHtml .="          <td colspan=\"3\"><hr></td>\n";
            $DirDeleteMessagesHtml .="        </tr>\n";
         }
      }
      if(!preg_match("/^[1-9]$/", $DirDeleteArray[0])) $DirDeleteArray[0] = $DirdeleteDetailsArray[6];
      $DirDeleteDirectoryDepthHtml .="            <div id=\"div_center\">\n";
      $DirDeleteDirectoryDepthHtml .="              <table>\n";
      $DirDeleteDirectoryDepthHtml .="                <tr>\n";
      $DirDeleteDirectoryDepthHtml .="                  <td>" . $DirdeleteDetailsArray[7] . "</td>\n";
      $DirDeleteDirectoryDepthHtml .="                  <td>&nbsp;</td>\n";
      $DirDeleteDirectoryDepthHtml .="                  <td><input type=\"number\" name=\"DIRDELETE_DIRECTORY_DEPTH\" min=\"1\" max=\"9\" size=\"1\" value=\"" . $DirDeleteArray[0] . "\"></td>\n";
      $DirDeleteDirectoryDepthHtml .="                  <td>&nbsp;</td>\n";
      $DirDeleteDirectoryDepthHtml .="                  <td><input type=\"submit\" name=\"DIRDELETE_VIEW_SUBMIT\" value=\"" . $DirdeleteDetailsArray[8] . "\"></td>\n";
      $DirDeleteDirectoryDepthHtml .="                </tr>\n";
      $DirDeleteDirectoryDepthHtml .="              </table>\n";
      $DirDeleteDirectoryDepthHtml .="            </div>\n";
      $DirDeleteContentHtml .="            <div id=\"div_center\">\n";
      $DirDeleteContentHtml .="              <table class=\"table_dirdelete\">\n";
      $DirDeleteContentHtml .="                <thead>\n";
      $DirDeleteContentHtml .="                  <tr>\n";
      $DirDeleteContentHtml .="                    <th colspan=\"8\" class=\"table_main_title\">" . $DirdeleteDetailsArray[5] . "</th>\n";
      $DirDeleteContentHtml .="                  </tr>\n";
      $DirDeleteContentHtml .="                  <tr>\n";
      $DirDeleteContentHtml .="                    <th class=\"title_field_1\">" . $DirdeleteDetailsArray[9] . "</th>\n";
      $DirDeleteContentHtml .="                    <th class=\"title_field_2\">" . $DirdeleteDetailsArray[10] . "</th>\n";
      $DirDeleteContentHtml .="                    <th class=\"title_field_3\">" . $DirdeleteDetailsArray[11] . "</th>\n";
      $DirDeleteContentHtml .="                    <th class=\"title_field_4\">" . $DirdeleteDetailsArray[12] . "</th>\n";
      $DirDeleteContentHtml .="                    <th class=\"title_field_5\">" . $DirdeleteDetailsArray[13] . "</th>\n";
      $DirDeleteContentHtml .="                    <th class=\"title_field_6\">" . $DirdeleteDetailsArray[14] . "</th>\n";
      $DirDeleteContentHtml .="                    <th class=\"title_field_7\">" . $DirdeleteDetailsArray[15] . "</th>\n";
      $DirDeleteContentHtml .="                    <th class=\"title_field_8\">" . $DirdeleteDetailsArray[16] . "</th>\n";
      $DirDeleteContentHtml .="                  </tr>\n";
      $DirDeleteContentHtml .="                </thead>\n";
      $DirDeleteContentHtml .="                <tbody>\n";
      // Erstellung der Verzeichnisliste
      if(!empty($DirDeleteArray[0]) && !empty($DirDeleteArray[2])) {
         $DirDeleteDirectoryArray=array();
         $DirDeleteResultArray=array();
         $DirDeleteFilenameArray=array();
         $DirDeleteFilesizeArray=array();
         $DirDeleteStartDirectory = "./";
         // Array: Start-Directory an den Anfang einfuegen
         $DirDeleteDirectoryArray[] = $DirDeleteStartDirectory;
         $DirDeleteDirectoryArrayCount = count($DirDeleteDirectoryArray);
         $DirDeleteDirectoryMaxDepthCount = substr_count($DirDeleteStartDirectory, '/') + $DirDeleteArray[0];
         if($DirDeleteDirectoryMaxDepthCount >= 2) $DirDeleteDirectoryMaxDepthCount = $DirDeleteDirectoryMaxDepthCount - 2;
         for($x=0; $x<$DirDeleteDirectoryArrayCount; $x++) {
            $DirDeleteFileHandle = @opendir($DirDeleteDirectoryArray[$x]);
            while($FileName = @readdir($DirDeleteFileHandle)) {
               if($FileName != "." && $FileName != "..") {
                  if(isset($DirDeleteDirectoryArray[0]) && $DirDeleteDirectoryArray[0] != "") $DirDeleteDirectoryArray[0]="";
                  if(isset($DirDeleteDirectoryArray[$x])) {
                     if($DirDeleteDirectoryArray[$x] == "") {
                        $NextFile = $FileName;
                     }
                     else
                     {
                     $NextFile = $DirDeleteDirectoryArray[$x] . "/" . $FileName;
                     }
                  }
                  else
                  {
                  $NextFile = $FileName;
                  }
                  $NextFileSlashCount = substr_count($NextFile, '/');
                  $NextDirOrFileExists = $DirDeleteStartDirectory . $NextFile;
                  if(is_dir($NextDirOrFileExists) && $NextFileSlashCount <= $DirDeleteDirectoryMaxDepthCount) {
                     $DirDeleteDirectoryArray[] = $NextFile;
                     $DirDeleteDirectoryArrayCount = count($DirDeleteDirectoryArray);
                  } elseif($NextFileSlashCount >= 1 && file_exists($NextDirOrFileExists)) {
                     $DirDeleteFilenameArray[] = $NextFile;
                     $DirDeleteFilesizeArray[] = filesize($NextFile);
                  }
               }
            }
            @closedir($DirDeleteFileHandle);
         }
         // Start-Directory aus dem Array entfernen
         array_shift($DirDeleteDirectoryArray);
         array_push($DirDeleteResultArray, $DirDeleteDirectoryArray, $DirDeleteFilenameArray, $DirDeleteFilesizeArray);
         $LineNumber=0;
         $DirDeleteResultDirectoryArrayCount = count($DirDeleteResultArray[0]);
         for($y=0; $y < $DirDeleteResultDirectoryArrayCount; $y++) {
            $LineNumber++;
            $DirDeleteCallDelete="";
            $DirectoryName = $DirDeleteResultArray[0][$y];
            $CurrentSubdirectoryCount=0;
            for($m=0; $m < $DirDeleteResultDirectoryArrayCount; $m++) {
               if(preg_match('@^' . $DirectoryName . '.*$@', $DirDeleteResultArray[0][$m])) $CurrentSubdirectoryCount++;
            }
            if(empty($CurrentSubdirectoryCount)) $CurrentSubdirectoryCount="";
            $DirDeleteResultFilenameArrayCount = count($DirDeleteResultArray[1]);
            $CurrentFileCount=0;
            $ResultCurrentFilesize=0;
            for($n=0; $n < $DirDeleteResultFilenameArrayCount; $n++) {
               if(preg_match('@^' . $DirectoryName . '.*$@', $DirDeleteResultArray[1][$n]) && !is_dir($DirDeleteResultArray[1][$n])) {
                  $CurrentFileCount++;
                  $ResultCurrentFilesize = $ResultCurrentFilesize + $DirDeleteResultArray[2][$n];
               }
            }
            if(empty($CurrentFileCount)) $CurrentFileCount="";
            if(empty($ResultCurrentFilesize)) $ResultCurrentFilesize="";
            $GigaByte=1024 * 1024 * 1024;
            $MegaByte=1024 * 1024;
            $KiloByte=1024;
            if(empty($ResultCurrentFilesize)) {
               $FileSize="";
            } elseif($ResultCurrentFilesize > $GigaByte) {
               $SizeValue = $ResultCurrentFilesize / $GigaByte;
               $FileSize = round($SizeValue, 1) . " " . $DirdeleteDetailsArray[17];
            } elseif($ResultCurrentFilesize > $MegaByte) {
               $SizeValue = $ResultCurrentFilesize / $MegaByte;
               $FileSize = round($SizeValue, 1) . " " . $DirdeleteDetailsArray[18];
            } elseif($ResultCurrentFilesize > $KiloByte) {
               $SizeValue = $ResultCurrentFilesize / $KiloByte;
               $FileSize = round($SizeValue, 0) . " " . $DirdeleteDetailsArray[19];
            }
            else
            {
            $FileSize = $ResultCurrentFilesize . " " . $DirdeleteDetailsArray[20];
            }
            $DirDeleteCallDelete = "<a href=\"" . $DirdeleteDetailsArray[0] . "?OBELIX_ID=" . $DirdeleteDetailsArray[1] . "&ACCESS_ID=" . $DirdeleteDetailsArray[2] . "&DIRDELETE_CURRENT_DIRECTORYNAME_DELETE=" . $DirDeleteStartDirectory . $DirectoryName . "&DIRDELETE_CURRENT_DIRECTORY_DEPTH=" . $DirDeleteArray[0] . "&DIRDELETE_GET_DIRECTORY_DELETE=1\" target=\"_self\" class=\"dirdelete\">" . $DirdeleteDetailsArray[16] . "</a>";
            $DirDeleteContentHtml .="                  <tr>\n";
            $DirDeleteContentHtml .="                    <td class=\"data_field_1\">" . $LineNumber . "</td>\n";
            $DirDeleteContentHtml .="                    <td class=\"data_field_2\">" . $DirectoryName . "</td>\n";
            $DirDeleteContentHtml .="                    <td class=\"data_field_3\">" . $CurrentSubdirectoryCount . "</td>\n";
            $DirDeleteContentHtml .="                    <td class=\"data_field_4\">" . $CurrentFileCount . "</td>\n";
            $DirDeleteContentHtml .="                    <td class=\"data_field_5\">" . $FileSize . "&nbsp;</td>\n";
            if(is_readable($DirectoryName)) {
               $DirDeleteContentHtml .="                    <td class=\"data_field_6\">&#10003;</td>\n";
            }
            else
            {
            $DirDeleteContentHtml .="                    <td class=\"data_field_6\">&#10007;</td>\n";
            }
            if(is_writeable($DirectoryName)) {
               $DirDeleteContentHtml .="                    <td class=\"data_field_7\">&#10003;</td>\n";
            }
            else
            {
            $DirDeleteContentHtml .="                    <td class=\"data_field_7\">&#10007;</td>\n";
            }
            $DirDeleteContentHtml .="                    <td class=\"data_field_8\">" . $DirDeleteCallDelete . "</td>\n";
            $DirDeleteContentHtml .="                  </tr>\n";
         }
      }
      clearstatcache();
      $DirDeleteContentHtml .="                  <tr>\n";
      $DirDeleteContentHtml .="                    <td colspan=\"8\">&nbsp;</td>\n";
      $DirDeleteContentHtml .="                  </tr>\n";
      $DirDeleteContentHtml .="                </tbody>\n";
      $DirDeleteContentHtml .="                <tfoot>\n";
      $DirDeleteContentHtml .="                  <tr>\n";
      $DirDeleteContentHtml .="                    <td colspan=\"8\" class=\"footer\"><strong>" . $DirdeleteDetailsArray[21] . "</strong> " . $DirDeleteCurrentWorkDirectory . "</td>\n";
      $DirDeleteContentHtml .="                  </tr>\n";
      $DirDeleteContentHtml .="                </tfoot>\n";
      $DirDeleteContentHtml .="              </table>\n";
      $DirDeleteContentHtml .="            </div>\n";
   } elseif(!isset($DirDeleteArray) ||
      !is_array($DirDeleteArray) ||
      $DirDeleteArrayDefaultCount != $DirDeleteArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY DirDeleteArray (ARRAY-COUNT) - function <strong>create_dirdelete</strong> - IS DAMAGED!';
      exit;
   } elseif(!isset($DirdeleteDetailsArray) ||
      !is_array($DirdeleteDetailsArray) ||
      $DirdeleteDetailsArrayDefaultCount != $DirdeleteDetailsArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY DirdeleteDetailsArray (ARRAY-COUNT) - function <strong>create_dirdelete</strong> - IS DAMAGED!';
      exit;
   }
   else
   {
      print 'NOTE: SYSTEM-ARRAY DirdeleteMessagesArray (ARRAY-COUNT) - function <strong>create_dirdelete</strong> - IS DAMAGED!';
      exit;
   }
   $MainContent="    <form name=\"form_dirdelete\" method=\"post\" action=\"" . $DirdeleteDetailsArray[0] . "?OBELIX_ID=" . $DirdeleteDetailsArray[1] . "&ACCESS_ID=" . $DirdeleteDetailsArray[2] . "\" target=\"_self\">\n";
   $MainContent .="      <table class=\"table_wide\">\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\" class=\"center\"><h3>" . $DirdeleteDetailsArray[3] . "</h3></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">" . $DirdeleteDetailsArray[4] . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\"><hr></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .= $DirDeleteMessagesHtml;
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">\n";
   $MainContent .= $DirDeleteDirectoryDepthHtml;
   $MainContent .="          </td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">\n";
   $MainContent .= $DirDeleteContentHtml;
   $MainContent .="          </td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="      </table>\n";
   $MainContent .="    </form>\n";
   return $MainContent;
}

// CSS - Navigation: DIRDELETE
function create_dirdelete_css() {
   $DirDeleteCSS="h3 {\n  font-size: 1.15em;\n  font-weight: bold;\n  text-align: center;\n}\n\n";
   $DirDeleteCSS .=".table_wide { width: 100%; }\n\n";
   $DirDeleteCSS .=".table_dirdelete {\n  border-collapse: collapse;\n  border: 1px solid gray;\n}\n\n";
   $DirDeleteCSS .="td { font-size: 0.9em; }\n\n";
   $DirDeleteCSS .="#div_center {\n  display: flex;\n  justify-content: center;\n  align-content: center;\n}\n\n";
   $DirDeleteCSS .="hr { width: 100%; }\n\n";
   $DirDeleteCSS .="input { font-size: 0.85em; }\n\n";
   $DirDeleteCSS .="a.dirdelete {\n  font-family: sans-serif;\n  font-size: 0.85em;\n  font-weight: normal;\n}\n\n";
   $DirDeleteCSS .=".table_main_title {\n  padding: 8px 8px 8px 8px;\n  border-bottom: 1px solid gray;\n}\n\n";
   $DirDeleteCSS .=".title_field_1 {\n  width: 80px;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n  background-color: #CFC181;\n}\n\n";
   $DirDeleteCSS .=".title_field_2 {\n  min-width: 150px;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n  background-color: #CFC181;\n}\n\n";
   $DirDeleteCSS .=".title_field_3 {\n  width: 150px;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n  background-color: #CFC181;\n}\n\n";
   $DirDeleteCSS .=".title_field_4 {\n  width: 120px;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n  background-color: #CFC181;\n}\n\n";
   $DirDeleteCSS .=".title_field_5 {\n  width: 120px;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n  background-color: #CFC181;\n}\n\n";
   $DirDeleteCSS .=".title_field_6 {\n  width: 60px;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n  background-color: #CFC181;\n}\n\n";
   $DirDeleteCSS .=".title_field_7 {\n  width: 80px;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n  background-color: #CFC181;\n}\n\n";
   $DirDeleteCSS .=".title_field_8 {\n  width: 80px;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n  background-color: #CFC181;\n}\n\n";
   $DirDeleteCSS .=".data_field_1 {\n  text-align: right;\n  padding: 2px 4px 2px 4px;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n}\n\n";
   $DirDeleteCSS .=".data_field_2 {\n  padding: 2px 4px 2px 4px;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n}\n\n";
   $DirDeleteCSS .=".data_field_3 {\n  text-align: center;\n  padding: 2px 4px 2px 4px;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n}\n\n";
   $DirDeleteCSS .=".data_field_4 {\n  text-align: center;\n  padding: 2px 4px 2px 4px;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n}\n\n";
   $DirDeleteCSS .=".data_field_5 {\n  text-align: right;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n}\n\n";
   $DirDeleteCSS .=".data_field_6 {\n  text-align: center;\n  padding: 2px 4px 2px 4px;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n}\n\n";
   $DirDeleteCSS .=".data_field_7 {\n  text-align: center;\n  padding: 2px 4px 2px 4px;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n}\n\n";
   $DirDeleteCSS .=".data_field_8 {\n  text-align: center;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n}\n\n";
   $DirDeleteCSS .=".footer {\n  padding: 4px 4px 4px 4px;\n  border-top: 1px solid gray;\n  background-color: #CFC181;\n}\n\n";
   $DirDeleteCSS .=".red {\n  font-size: 0.95em;\n  font-weight: bold;\n  text-align: center;\n  color:#DD0000;\n}\n\n";
   return $DirDeleteCSS;
}

// Erstellung der Webseite EXEC
function create_exec($ExecCommandArray='', $ExecDetailsArray='', $ExecMessagesArray='') {
   $ExecOutputHtml="";
   $ExecMessagesHtml="";
   if(empty($ExecDetailsArray[1])) $ExecDetailsArray[1]=0;
   if(empty($ExecDetailsArray[2])) $ExecDetailsArray[2]=0;
   $ExecArrayDefaultCount=2; // Vorgabe: Anzahl der Array-Elemente
   $ExecArrayCurrentCount=count($ExecCommandArray);
   $ExecDetailsArrayDefaultCount=7; // Vorgabe: Anzahl der Array-Elemente
   $ExecDetailsArrayCurrentCount=count($ExecDetailsArray);
   $ExecMessagesArrayDefaultCount=3; // Vorgabe: Anzahl der Array-Elemente
   $ExecMessagesArrayCurrentCount=count($ExecMessagesArray);
   if(isset($ExecCommandArray) &&
      is_array($ExecCommandArray) &&
      $ExecArrayDefaultCount == $ExecArrayCurrentCount &&
      isset($ExecDetailsArray) &&
      is_array($ExecDetailsArray) &&
      $ExecDetailsArrayDefaultCount == $ExecDetailsArrayCurrentCount &&
      isset($ExecMessagesArray) &&
      is_array($ExecMessagesArray) &&
      $ExecMessagesArrayDefaultCount == $ExecMessagesArrayCurrentCount) {
      $FunctionsDisable = @ini_get('disable_functions');
      if(!preg_match("/exec/", $FunctionsDisable)) {
         if(!empty($ExecCommandArray[0])) {
            @exec($ExecCommandArray[0], $ExecCommandMessageArray, $ExecExitStatus);
            if(isset($ExecCommandMessageArray) && is_array($ExecCommandMessageArray)) {
               $ExecOutputArrayContent="";
               $ExecCommandMessageArrayCount = count($ExecCommandMessageArray);
               for($x=0; $x<$ExecCommandMessageArrayCount; $x++){
                  $ExecOutputArrayContent .= $ExecCommandMessageArray[$x] . "<br>";
               }
               $ExecOutputHtml .="        <tr>\n";
               $ExecOutputHtml .="          <td colspan=\"3\"><hr></td>\n";
               $ExecOutputHtml .="        </tr>\n";
               $ExecOutputHtml .="        <tr>\n";
               $ExecOutputHtml .="          <td colspan=\"3\">" . $ExecOutputArrayContent . "</td>\n";
               $ExecOutputHtml .="        </tr>\n";
               $ExecOutputHtml .="        <tr>\n";
               $ExecOutputHtml .="          <td colspan=\"3\"><hr></td>\n";
               $ExecOutputHtml .="        </tr>\n";
            }
            if(isset($ExecExitStatus) && $ExecExitStatus == 0) {
               $ExecMessagesHtml .="        <tr>\n";
               $ExecMessagesHtml .="          <td colspan=\"3\"><hr></td>\n";
               $ExecMessagesHtml .="        </tr>\n";
               $ExecMessagesHtml .="        <tr>\n";
               $ExecMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $ExecMessagesArray[0] . "</td>\n";
               $ExecMessagesHtml .="        </tr>\n";
            }
            else
            {
               $ExecOutputHtml='';
               $ExecMessagesHtml .="        <tr>\n";
               $ExecMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $ExecMessagesArray[1] . "</td>\n";
               $ExecMessagesHtml .="        </tr>\n";
            }
         }
      } elseif(!empty($ExecCommandArray[1])) {
         $ExecMessagesHtml .="        <tr>\n";
         $ExecMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $ExecMessagesArray[2] . "</td>\n";
         $ExecMessagesHtml .="        </tr>\n";
      }
   } elseif(!isset($ExecCommandArray) ||
      !is_array($ExecCommandArray) ||
      $ExecArrayDefaultCount != $ExecArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY ExecCommandArray (ARRAY-COUNT) - function <strong>create_exec</strong> - IS DAMAGED!';
      exit;
   } elseif (!isset($ExecDetailsArray) ||
      !is_array($ExecDetailsArray) ||
      $ExecDetailsArrayDefaultCount != $ExecDetailsArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY ExecDetailsArray (ARRAY-COUNT) - function <strong>create_exec</strong> - IS DAMAGED!';
      exit;
   }
   else
   {
      print 'NOTE: SYSTEM-ARRAY ExecMessagesArray (ARRAY-COUNT) - function <strong>create_exec</strong> - IS DAMAGED!';
      exit;
   }
   $MainContent="    <form name=\"form_exec\" method=\"post\" action=\"" . $ExecDetailsArray[0] . "?OBELIX_ID=" . $ExecDetailsArray[1] . "&ACCESS_ID=" . $ExecDetailsArray[2] . "\" target=\"_self\">\n";
   $MainContent .="      <table>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\" class=\"center\"><h3>" . $ExecDetailsArray[3] . "</h3></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">" . $ExecDetailsArray[4] . "</td>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .= $ExecMessagesHtml;
   $MainContent .= $ExecOutputHtml;
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"column_wide\">&nbsp;</td>\n";
   $MainContent .="          <td class=\"right_bold\">" . $ExecDetailsArray[5] . "</td>\n";
   $MainContent .="          <td><input type=\"text\" name=\"EXEC_COMMAND\" size=\"40\" maxlength=\"128\" value=\"" . $ExecCommandArray[0] . "\"></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\" class=\"center\"><input type=\"submit\" name=\"EXEC_SUBMIT\" value=\"" . $ExecDetailsArray[6] . "\"></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="      </table>\n";
   $MainContent .="    </form>\n";
   return $MainContent;
}

// CSS - Navigation: EXEC
function create_exec_css() {
   $ExecCSS="h3 {\n  font-size: 1.15em;\n  font-weight: bold;\n  text-align: center;\n}\n\n";
   $ExecCSS .="table { width: 100%; }\n\n";
   $ExecCSS .="td { font-size: 0.9em; }\n\n";
   $ExecCSS .=".column_wide { width: 20%; }\n\n";
   $ExecCSS .="hr { width: 100%; }\n\n";
   $ExecCSS .="input { font-size: 0.85em; }\n\n";
   $ExecCSS .=".red {\n  font-size: 0.95em;\n  font-weight: bold;\n  text-align: center;\n  color:#DD0000;\n}\n\n";
   $ExecCSS .=".right { text-align: right; }\n\n";
   $ExecCSS .=".right_bold {\n  font-weight: bold;\n  text-align: right;\n}\n\n";
   return $ExecCSS;
}

// Erstellung der Webseite MySQLi-TABLES
function create_mysqli_tables($ObelixFileNameArray='', $MysqlTablesArray='', $MysqliTablesDetailsArray='', $MysqliTablesMessagesArray='') {
   $MysqlTablesMessagesHtml="";
   $HostName='';
   $DbName='';
   $DbUserName='';
   $DbPassword='';
   $MysqlTablesOutputSector='';
   $Extension1 = 'mysqli';
   $Extension2 = 'mysql';
   $SqlLanguage1Checked = " checked";
   $SqlLanguage2Checked='';
   $SqlDbConnection1Checked = " checked";
   $SqlDbConnection2Checked='';
   $SqlDbConnection3Checked='';
   $SqlDbConnection4Checked='';
   $SqlDbConnection5Checked='';
   $SqlContentNoValue = "no value";
   if(empty($MysqliTablesDetailsArray[0])) $MysqliTablesDetailsArray[0]=0;
   if(empty($MysqliTablesDetailsArray[1])) $MysqliTablesDetailsArray[1]=0;
   $ObelixFileNameArrayDefaultCount=15; // Vorgabe: Anzahl der Array-Elemente
   $ObelixFileNameArrayCurrentCount=count($ObelixFileNameArray);
   $MysqlTablesArrayDefaultCount=8; // Vorgabe: Anzahl der Array-Elemente
   $MysqlTablesArrayCurrentCount=count($MysqlTablesArray);
   $MysqliTablesDetailsArrayDefaultCount=29; // Vorgabe: Anzahl der Array-Elemente
   $MysqliTablesDetailsArrayCurrentCount=count($MysqliTablesDetailsArray);
   $MysqliTablesMessagesArrayDefaultCount=17; // Vorgabe: Anzahl der Array-Elemente
   $MysqliTablesMessagesArrayCurrentCount=count($MysqliTablesMessagesArray);
   if(isset($ObelixFileNameArray) &&
      is_array($ObelixFileNameArray) &&
      $ObelixFileNameArrayDefaultCount == $ObelixFileNameArrayCurrentCount &&
      isset($MysqlTablesArray) &&
      is_array($MysqlTablesArray) &&
      $MysqlTablesArrayDefaultCount == $MysqlTablesArrayCurrentCount &&
      isset($MysqliTablesDetailsArray) &&
      is_array($MysqliTablesDetailsArray) &&
      $MysqliTablesDetailsArrayDefaultCount == $MysqliTablesDetailsArrayCurrentCount &&
      isset($MysqliTablesMessagesArray) &&
      is_array($MysqliTablesMessagesArray) &&
      $MysqliTablesMessagesArrayDefaultCount == $MysqliTablesMessagesArrayCurrentCount) {
      if(!empty($MysqlTablesArray[6])) {
         if(!empty($MysqlTablesArray[5]) && $MysqlTablesArray[5] == 1) {
            if(!empty($MysqlTablesArray[1]) &&
               !empty($MysqlTablesArray[2]) &&
               !empty($MysqlTablesArray[3])) {
               $HostName = $MysqlTablesArray[1];
               $DbName = $MysqlTablesArray[2];
               $DbUserName = $MysqlTablesArray[3];
               if(isset($MysqlTablesArray[4])) $DbPassword = $MysqlTablesArray[4];
               $DbAccessDataReturnCode=1;
            }
            else
            {
               $MysqlTablesMessagesHtml .="        <tr>\n";
               $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[0] . "</td>\n";
               $MysqlTablesMessagesHtml .="        </tr>\n";
            }
         } elseif(!empty($MysqlTablesArray[5]) && $MysqlTablesArray[5] == 2) {
            $SqlDbConnection1Checked='';
            $SqlDbConnection2Checked = " checked";
            if(file_exists($ObelixFileNameArray[7]) && is_readable($ObelixFileNameArray[7])) {
               include($ObelixFileNameArray[7]);
               if(!empty($HostName) &&
                  !empty($DbName) &&
                  !empty($DbUserName) &&
                  isset($DbPassword)) {
                  $DbAccessDataReturnCode=1;
               }
               else
               {
                  $MysqlTablesMessagesHtml .="        <tr>\n";
                  $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[2] . "</td>\n";
                  $MysqlTablesMessagesHtml .="        </tr>\n";
               }
            } elseif(file_exists($ObelixFileNameArray[7]) && !is_readable($ObelixFileNameArray[7])) {
               $MysqlTablesMessagesHtml .="        <tr>\n";
               $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[16] . "</td>\n";
               $MysqlTablesMessagesHtml .="        </tr>\n";
            }
            else
            {
               $MysqlTablesMessagesHtml .="        <tr>\n";
               $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[3] . "</td>\n";
               $MysqlTablesMessagesHtml .="        </tr>\n";
            }
         } elseif(!empty($MysqlTablesArray[5]) && $MysqlTablesArray[5] == 3) {
            $SqlDbConnection1Checked='';
            $SqlDbConnection3Checked = " checked";
            if(file_exists($ObelixFileNameArray[7]) && is_readable($ObelixFileNameArray[7])) {
               include($ObelixFileNameArray[7]);
               if(!empty($HostName) &&
                  !empty($DbName) &&
                  !empty($DbUserName) &&
                  isset($DbPassword)) {
                  $HostName = base64_decode($HostName);
                  $DbName = base64_decode($DbName);
                  $DbUserName = base64_decode($DbUserName);
                  $DbPassword = base64_decode($DbPassword);
                  $DbAccessDataReturnCode=1;
               }
               else
               {
                  $MysqlTablesMessagesHtml .="        <tr>\n";
                  $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[2] . "</td>\n";
                  $MysqlTablesMessagesHtml .="        </tr>\n";
               }
            } elseif(file_exists($ObelixFileNameArray[7]) && !is_readable($ObelixFileNameArray[7])) {
               $MysqlTablesMessagesHtml .="        <tr>\n";
               $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[16] . "</td>\n";
               $MysqlTablesMessagesHtml .="        </tr>\n";
            }
            else
            {
               $MysqlTablesMessagesHtml .="        <tr>\n";
               $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[3] . "</td>\n";
               $MysqlTablesMessagesHtml .="        </tr>\n";
            } 
         } elseif(!empty($MysqlTablesArray[5]) && $MysqlTablesArray[5] == 4) {
            $SqlDbConnection1Checked='';
            $SqlDbConnection4Checked = " checked";
            if(!empty($MysqlTablesArray[1]) &&
               !empty($MysqlTablesArray[2]) &&
               !empty($MysqlTablesArray[3])) {
               $HostName = $MysqlTablesArray[1];
               $DbName = $MysqlTablesArray[2];
               $DbUserName = $MysqlTablesArray[3];
               if(isset($MysqlTablesArray[4])) $DbPassword = $MysqlTablesArray[4];
               $IncFileContent = "<?php\n";
               $IncFileContent .= '$HostName = ' . "'" . $HostName . "';\n";
               $IncFileContent .= '$DbName = ' . "'" . $DbName . "';\n";
               $IncFileContent .= '$DbUserName = ' . "'" . $DbUserName . "';\n";
               $IncFileContent .= '$DbPassword = ' . "'" . $DbPassword . "';\n";
               $IncFileContent .= "?>\n";
               if(is_writeable('./')) {
                  if(file_exists($ObelixFileNameArray[7])) {
                     @unlink($ObelixFileNameArray[7]);
                     if(file_exists($ObelixFileNameArray[7])) {
                        $MysqlTablesMessagesHtml .="        <tr>\n";
                        $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[4] . "</td>\n";
                        $MysqlTablesMessagesHtml .="        </tr>\n";
                        $ErrorReturnCode=1;
                     }
                  }
                  if(empty($ErrorReturnCode)) {
                     if(!file_exists($ObelixFileNameArray[7])) {
                        if(@touch($ObelixFileNameArray[7])) {
                           chmod($ObelixFileNameArray[7], $MysqliTablesDetailsArray[28]);
                           if($FileWrite = @fopen($ObelixFileNameArray[7],'w')) {
                              @flock($FileWrite,2);
                              @fwrite($FileWrite, $IncFileContent);
                              @flock($FileWrite,3);
                              @fclose($FileWrite);
                           }
                           else
                           {
                              $MysqlTablesMessagesHtml .="        <tr>\n";
                              $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[5] . "</td>\n";
                              $MysqlTablesMessagesHtml .="        </tr>\n";
                              $ErrorReturnCode=1;
                           }
                        }
                        else
                        {
                           $MysqlTablesMessagesHtml .="        <tr>\n";
                           $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[6] . "</td>\n";
                           $MysqlTablesMessagesHtml .="        </tr>\n";
                           $ErrorReturnCode=1;
                        }
                     }
                     if(empty($ErrorReturnCode)) {
                        if(file_exists($ObelixFileNameArray[7]) && is_readable($ObelixFileNameArray[7])) {
                           include($ObelixFileNameArray[7]);
                           if(!empty($HostName) &&
                              !empty($DbName) &&
                              !empty($DbUserName) &&
                              isset($DbPassword)) {
                              $DbAccessDataReturnCode=1;
                              $SqlDbConnection2Checked = " checked";
                              $SqlDbConnection4Checked='';
                           }
                           else
                           {
                              $MysqlTablesMessagesHtml .="        <tr>\n";
                              $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[2] . "</td>\n";
                              $MysqlTablesMessagesHtml .="        </tr>\n";
                           }
                        } elseif(file_exists($ObelixFileNameArray[7]) && !is_readable($ObelixFileNameArray[7])) {
                           $MysqlTablesMessagesHtml .="        <tr>\n";
                           $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[16] . "</td>\n";
                           $MysqlTablesMessagesHtml .="        </tr>\n";
                        }
                        else
                        {
                           $MysqlTablesMessagesHtml .="        <tr>\n";
                           $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[3] . "</td>\n";
                           $MysqlTablesMessagesHtml .="        </tr>\n";
                        }
                     }
                  }
               }
               else
               {
                  $MysqlTablesMessagesHtml .="        <tr>\n";
                  $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[7] . "</td>\n";
                  $MysqlTablesMessagesHtml .="        </tr>\n";
               }
            }
            else
            {
               $MysqlTablesMessagesHtml .="        <tr>\n";
               $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[0] . "</td>\n";
               $MysqlTablesMessagesHtml .="        </tr>\n";
            }
         } elseif(!empty($MysqlTablesArray[5]) && $MysqlTablesArray[5] == 5) {
            $SqlDbConnection1Checked='';
            $SqlDbConnection5Checked = " checked";
            if(!empty($MysqlTablesArray[1]) &&
               !empty($MysqlTablesArray[2]) &&
               !empty($MysqlTablesArray[3])) {
               $HostName = $MysqlTablesArray[1];
               $DbName = $MysqlTablesArray[2];
               $DbUserName = $MysqlTablesArray[3];
               if(isset($MysqlTablesArray[4])) $DbPassword = $MysqlTablesArray[4];
               $IncFileContent = "<?php\n";
               $IncFileContent .= '$HostName = ' . "'" . base64_encode($HostName) . "';\n";
               $IncFileContent .= '$DbName = ' . "'" . base64_encode($DbName) . "';\n";
               $IncFileContent .= '$DbUserName = ' . "'" . base64_encode($DbUserName) . "';\n";
               $IncFileContent .= '$DbPassword = ' . "'" . base64_encode($DbPassword) . "';\n";
               $IncFileContent .= "?>\n";
               if(is_writeable('./')) {
                  if(file_exists($ObelixFileNameArray[7])) {
                     @unlink($ObelixFileNameArray[7]);
                     if(file_exists($ObelixFileNameArray[7])) {
                        $MysqlTablesMessagesHtml .="        <tr>\n";
                        $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[4] . "</td>\n";
                        $MysqlTablesMessagesHtml .="        </tr>\n";
                        $ErrorReturnCode=1;
                     }
                  }
                  if(empty($ErrorReturnCode)) {
                     if(!file_exists($ObelixFileNameArray[7])) {
                        if(@touch($ObelixFileNameArray[7])) {
                           chmod($ObelixFileNameArray[7], $MysqliTablesDetailsArray[28]);
                           if($FileWrite = @fopen($ObelixFileNameArray[7],'w')) {
                              @flock($FileWrite,2);
                              @fwrite($FileWrite, $IncFileContent);
                              @flock($FileWrite,3);
                              @fclose($FileWrite);
                           }
                           else
                           {
                              $MysqlTablesMessagesHtml .="        <tr>\n";
                              $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[5] . "</td>\n";
                              $MysqlTablesMessagesHtml .="        </tr>\n";
                              $ErrorReturnCode=1;
                           }
                        }
                        else
                        {
                           $MysqlTablesMessagesHtml .="        <tr>\n";
                           $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[6] . "</td>\n";
                           $MysqlTablesMessagesHtml .="        </tr>\n";
                           $ErrorReturnCode=1;
                        }
                     }
                     if(empty($ErrorReturnCode)) {
                        if(file_exists($ObelixFileNameArray[7]) && is_readable($ObelixFileNameArray[7])) {
                           include($ObelixFileNameArray[7]);
                           if(!empty($HostName) &&
                              !empty($DbName) &&
                              !empty($DbUserName) &&
                              isset($DbPassword)) {
                              $HostName = base64_decode($HostName);
                              $DbName = base64_decode($DbName);
                              $DbUserName = base64_decode($DbUserName);
                              $DbPassword = base64_decode($DbPassword);
                              $DbAccessDataReturnCode=1;
                              $SqlDbConnection3Checked = " checked";
                              $SqlDbConnection5Checked='';
                           }
                           else
                           {
                              $MysqlTablesMessagesHtml .="        <tr>\n";
                              $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[2] . "</td>\n";
                              $MysqlTablesMessagesHtml .="        </tr>\n";
                           }
                        } elseif(file_exists($ObelixFileNameArray[7]) && !is_readable($ObelixFileNameArray[7])) {
                           $MysqlTablesMessagesHtml .="        <tr>\n";
                           $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[16] . "</td>\n";
                           $MysqlTablesMessagesHtml .="        </tr>\n";
                        }
                        else
                        {
                           $MysqlTablesMessagesHtml .="        <tr>\n";
                           $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[3] . "</td>\n";
                           $MysqlTablesMessagesHtml .="        </tr>\n";
                        }
                     }
                  }
               }
               else
               {
                  $MysqlTablesMessagesHtml .="        <tr>\n";
                  $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[7] . "</td>\n";
                  $MysqlTablesMessagesHtml .="        </tr>\n";
               }
            }
            else
            {
               $MysqlTablesMessagesHtml .="        <tr>\n";
               $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[0] . "</td>\n";
               $MysqlTablesMessagesHtml .="        </tr>\n";
            }
         }
         else
         {
            print "NOTE: SYSTEM-VARIABLE DATABASE CONNECTION (DB_CONNECTION) - function <strong>create_mysqli_tables</strong> - IS DAMAGED!";
            exit;
         }
         if(empty($ErrorReturnCode) &&
            empty($MysqlTablesArray[7]) &&
            !empty($MysqlTablesArray[0]) &&
            !empty($HostName) &&
            !empty($DbName) &&
            !empty($DbUserName) &&
            isset($DbPassword) &&
            !empty($Extension1) &&
            !empty($Extension2) &&
            !empty($DbAccessDataReturnCode) &&
            $DbAccessDataReturnCode == 1) {
            $SqlStringCmp1 = strcmp($Extension1, $MysqlTablesArray[0]);
            $SqlStringCmp2 = strcmp($Extension2, $MysqlTablesArray[0]);
            if($SqlStringCmp1 == 0) {
               // MySQLi
               if(extension_loaded($Extension1) && (!empty(@ini_get('mysqli.allow_local_infile')) || !empty(@ini_get('mysqli.allow_persistent')))) {
                  if($DbConnect = @mysqli_connect($HostName, $DbUserName, $DbPassword, $DbName)) {
                     $SqlDbTablesArray = array_column(@mysqli_fetch_all($DbConnect->query('SHOW TABLES')),0);
                     $SqlDbTablesArrayCount = count($SqlDbTablesArray);
                     if(!empty($SqlDbTablesArrayCount)) {
                        $MysqlTablesOutputSector .= "        <tr>\n";
                        $MysqlTablesOutputSector .= "          <td colspan=\"3\"><hr></td>\n";
                        $MysqlTablesOutputSector .= "        </tr>\n";
                        $MysqlTablesOutputSector .= "        <tr>\n";
                        $MysqlTablesOutputSector .= "          <td colspan=\"3\">&nbsp;</td>\n";
                        $MysqlTablesOutputSector .= "        </tr>\n";
                        $MysqlTablesOutputSector .= "        <tr>\n";
                        $MysqlTablesOutputSector .= "          <td colspan=\"3\">\n";
                        $MysqlTablesOutputSector .= "            <div id=\"div_result\">\n";
                        $MysqlTablesOutputSector .= "              <table class=\"table_result\">\n";
                        $MysqlTablesOutputSector .= "                <tr>\n";
                        $MysqlTablesOutputSector .= "                  <th colspan=\"5\" class=\"title_note_a\">" . $MysqliTablesDetailsArray[18] . "</th>\n";
                        $MysqlTablesOutputSector .= "                </tr>\n";
                        $MysqlTablesOutputSector .= "                <tr>\n";
                        $MysqlTablesOutputSector .= "                  <th class=\"title_field_1\">" . $MysqliTablesDetailsArray[19] . "</th>\n";
                        $MysqlTablesOutputSector .= "                  <th class=\"title_field_2\">" . $MysqliTablesDetailsArray[20] . "</th>\n";
                        $MysqlTablesOutputSector .= "                  <th class=\"title_field_3\">" . $MysqliTablesDetailsArray[21] . "</th>\n";
                        $MysqlTablesOutputSector .= "                  <th class=\"title_field_4\">" . $MysqliTablesDetailsArray[22] . "</th>\n";
                        $MysqlTablesOutputSector .= "                  <th class=\"title_field_5\">" . $MysqliTablesDetailsArray[23] . "</th>\n";
                        $MysqlTablesOutputSector .= "                </tr>\n";
                        for($x=0; $x<$SqlDbTablesArrayCount; $x++) {
                           $DsNumber = $x + 1;
                           if($DsNumber < 10) {
                              $DsStringNumber = "&nbsp;&nbsp;" . $DsNumber;
                           } elseif($DsNumber < 100) {
                              $DsStringNumber = "&nbsp;" . $DsNumber;
                           }
                           else
                           {
                           $DsStringNumber = $DsNumber;
                           }
                           $CurrentTableFieldCount = $SqlContentNoValue;
                           $CurrentTableRowCount = $SqlContentNoValue;
                           $SqlCommand = "SELECT * FROM " . $SqlDbTablesArray[$x];
                           if($CurrentResult = @mysqli_query($DbConnect, $SqlCommand)) {
                              $CurrentTableFieldCount = @mysqli_num_fields($CurrentResult);
                              $CurrentTableRowCount = @mysqli_num_rows($CurrentResult);
                              @mysqli_free_result($CurrentResult);
                           }
                           $MysqlTablesOutputSector .= "                <tr>\n";
                           $MysqlTablesOutputSector .= "                  <td class=\"data_field_1\">" . $DsStringNumber . "</td>\n";
                           $MysqlTablesOutputSector .= "                  <td class=\"data_field_2\">" . $SqlDbTablesArray[$x] . "</td>\n";
                           $MysqlTablesOutputSector .= "                  <td class=\"data_field_3\">" . $CurrentTableFieldCount . "</td>\n";
                           $MysqlTablesOutputSector .= "                  <td class=\"data_field_4\">" . $CurrentTableRowCount . "</td>\n";
                           $MysqlTablesOutputSector .= "                  <td class=\"data_field_5\"><input type=\"checkbox\" name=\"SQL_TABLE_CHOICE[]\" value=\"" . $SqlDbTablesArray[$x] . "\"></td>\n";
                           $MysqlTablesOutputSector .= "                </tr>\n";
                        }
                        $MysqlTablesOutputSector .= "              </table>\n";
                        $MysqlTablesOutputSector .= "            </div>\n";
                        $MysqlTablesOutputSector .= "          </td>\n";
                        $MysqlTablesOutputSector .= "        </tr>\n";
                        $MysqlTablesOutputSector .= "        <tr>\n";
                        $MysqlTablesOutputSector .= "          <td colspan=\"3\">&nbsp;</td>\n";
                        $MysqlTablesOutputSector .= "        </tr>\n";
                        $SqlDatabaseNotClosedMessage = $MysqliTablesMessagesArray[11] . " " . $DbName;
                        @mysqli_close($DbConnect) or die($SqlDatabaseNotClosedMessage);
                     }
                     else
                     {
                        $MysqlTablesMessagesHtml .="        <tr>\n";
                        $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[14] . "</td>\n";
                        $MysqlTablesMessagesHtml .="        </tr>\n";
                        $NoSuccessfulReturnCode=1;
                     }
                  }
                  else
                  {
                     $MysqlTablesMessagesHtml .="        <tr>\n";
                     $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[8] . " " . $DbName . "</td>\n";
                     $MysqlTablesMessagesHtml .="        </tr>\n";
                     $NoSuccessfulReturnCode=1;
                  }
               }
               else
               {
                  $MysqlTablesMessagesHtml .="        <tr>\n";
                  $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[12] . "</td>\n";
                  $MysqlTablesMessagesHtml .="        </tr>\n";
                  $NoSuccessfulReturnCode=1;
               }
               if(empty($NoSuccessfulReturnCode)) {
                  $MysqlTablesMessagesHtml .="        <tr>\n";
                  $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[9] . "</td>\n";
                  $MysqlTablesMessagesHtml .="        </tr>\n";
              }
            } elseif($SqlStringCmp2 == 0) {
               // MySQL
               $SqlLanguage1Checked='';
               $SqlLanguage2Checked = " checked";
               if(extension_loaded($Extension2) && (!empty(@ini_get('mysql.allow_local_infile')) || !empty(@ini_get('mysql.allow_persistent')))) {
                  $DbConnect = @mysql_connect($HostName, $DbUserName, $DbPassword);
                  if(@mysql_select_db($DbName, $DbConnect)) {
                     $SqlDbTablesArray = @mysql_list_tables($DbName);
                     $SqlDbTablesArrayCount = @mysql_num_rows($SqlDbTablesArray);
                     if(!empty($SqlDbTablesArrayCount)) {
                        $MysqlTablesOutputSector .= "        <tr>\n";
                        $MysqlTablesOutputSector .= "          <td colspan=\"3\"><hr></td>\n";
                        $MysqlTablesOutputSector .= "        </tr>\n";
                        $MysqlTablesOutputSector .= "        <tr>\n";
                        $MysqlTablesOutputSector .= "          <td colspan=\"3\">&nbsp;</td>\n";
                        $MysqlTablesOutputSector .= "        </tr>\n";
                        $MysqlTablesOutputSector .= "        <tr>\n";
                        $MysqlTablesOutputSector .= "          <td colspan=\"3\">\n";
                        $MysqlTablesOutputSector .= "            <div id=\"div_result\">\n";
                        $MysqlTablesOutputSector .= "              <table class=\"table_result\">\n";
                        $MysqlTablesOutputSector .= "                <tr>\n";
                        $MysqlTablesOutputSector .= "                  <th colspan=\"5\" class=\"title_note_a\">" . $MysqliTablesDetailsArray[18] . "</th>\n";
                        $MysqlTablesOutputSector .= "                </tr>\n";
                        $MysqlTablesOutputSector .= "                <tr>\n";
                        $MysqlTablesOutputSector .= "                  <th class=\"title_field_1\">" . $MysqliTablesDetailsArray[19] . "</th>\n";
                        $MysqlTablesOutputSector .= "                  <th class=\"title_field_2\">" . $MysqliTablesDetailsArray[20] . "</th>\n";
                        $MysqlTablesOutputSector .= "                  <th class=\"title_field_3\">" . $MysqliTablesDetailsArray[21] . "</th>\n";
                        $MysqlTablesOutputSector .= "                  <th class=\"title_field_4\">" . $MysqliTablesDetailsArray[22] . "</th>\n";
                        $MysqlTablesOutputSector .= "                  <th class=\"title_field_5\">" . $MysqliTablesDetailsArray[23] . "</th>\n";
                        $MysqlTablesOutputSector .= "                </tr>\n";
                        for($x=0; $x<$SqlDbTablesArrayCount; $x++) {
                           $SqlTableName = @mysql_tablename($SqlDbTablesArray, $x);
                           $DsNumber = $x + 1;
                           if($DsNumber < 10) {
                              $DsStringNumber = "&nbsp;&nbsp;" . $DsNumber;
                           } elseif($DsNumber < 100) {
                              $DsStringNumber = "&nbsp;" . $DsNumber;
                           }
                           else
                           {
                           $DsStringNumber = $DsNumber;
                           }
                           $CurrentTableFieldCount = $SqlContentNoValue;
                           $CurrentTableRowCount = $SqlContentNoValue;
                           $SqlCommand = "SELECT * FROM " . $SqlTableName;
                           if($CurrentResult = @mysql_db_query($DbName, $SqlCommand)) {
                              $CurrentTableFieldCount = @mysql_num_fields($CurrentResult);
                              $CurrentTableRowCount = @mysql_num_rows($CurrentResult);
                              @mysql_free_result($CurrentResult);
                           }
                           $MysqlTablesOutputSector .= "                <tr>\n";
                           $MysqlTablesOutputSector .= "                  <td class=\"data_field_1\">" . $DsStringNumber . "</td>\n";
                           $MysqlTablesOutputSector .= "                  <td class=\"data_field_2\">" . $SqlTableName . "</td>\n";
                           $MysqlTablesOutputSector .= "                  <td class=\"data_field_3\">" . $CurrentTableFieldCount . "</td>\n";
                           $MysqlTablesOutputSector .= "                  <td class=\"data_field_4\">" . $CurrentTableRowCount . "</td>\n";
                           $MysqlTablesOutputSector .= "                  <td class=\"data_field_5\"><input type=\"checkbox\" name=\"SQL_TABLE_CHOICE[]\" value=\"" . $SqlTableName . "\"></td>\n";
                           $MysqlTablesOutputSector .= "                </tr>\n";
                        }
                        @mysql_free_result($SqlDbTablesArrayCount);
                        $MysqlTablesOutputSector .= "              </table>\n";
                        $MysqlTablesOutputSector .= "            </div>\n";
                        $MysqlTablesOutputSector .= "          </td>\n";
                        $MysqlTablesOutputSector .= "        </tr>\n";
                        $MysqlTablesOutputSector .= "        <tr>\n";
                        $MysqlTablesOutputSector .= "          <td colspan=\"3\">&nbsp;</td>\n";
                        $MysqlTablesOutputSector .= "        </tr>\n";
                        $SqlDatabaseNotClosedMessage = $MysqliTablesMessagesArray[11] . " " . $DbName;
                        @mysql_close($DbConnect) or die($SqlDatabaseNotClosedMessage);
                     }
                     else
                     {
                        $MysqlTablesMessagesHtml .="        <tr>\n";
                        $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[14] . "</td>\n";
                        $MysqlTablesMessagesHtml .="        </tr>\n";
                        $NoSuccessfulReturnCode=1;
                     }
                  }
                  else
                  {
                     $MysqlTablesMessagesHtml .="        <tr>\n";
                     $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[8] . " " . $DbName . "</td>\n";
                     $MysqlTablesMessagesHtml .="        </tr>\n";
                     $NoSuccessfulReturnCode=1;
                  }
               }
               else
               {
                  $MysqlTablesMessagesHtml .="        <tr>\n";
                  $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[13] . "</td>\n";
                  $MysqlTablesMessagesHtml .="        </tr>\n";
                  $NoSuccessfulReturnCode=1;
               }
               if(empty($NoSuccessfulReturnCode)) {
                  $MysqlTablesMessagesHtml .="        <tr>\n";
                  $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[9] . "</td>\n";
                  $MysqlTablesMessagesHtml .="        </tr>\n";
              }
            }
            else
            {
               print "NOTE: SYSTEM-VARIABLE SQL-LANGUAGE-SPECIFICATION (SQL_DB_TYPE) - function <strong>create_mysqli_tables</strong> - IS DAMAGED!";
               exit;
            }
         } elseif(empty($ErrorReturnCode) &&
            !empty($MysqlTablesArray[0]) &&
            !empty($MysqlTablesArray[7]) &&
            is_array($MysqlTablesArray[7]) &&
            !empty($HostName) &&
            !empty($DbName) &&
            !empty($DbUserName) &&
            isset($DbPassword) &&
            !empty($Extension1) &&
            !empty($Extension2) &&
            !empty($DbAccessDataReturnCode) &&
            $DbAccessDataReturnCode == 1) {
            $SqlStringCmp1 = strcmp($Extension1, $MysqlTablesArray[0]);
            $SqlStringCmp2 = strcmp($Extension2, $MysqlTablesArray[0]);
            if($SqlStringCmp1 == 0) {
               // MySQLi
               if(extension_loaded($Extension1) && (!empty(@ini_get('mysqli.allow_local_infile')) || !empty(@ini_get('mysqli.allow_persistent')))) {
                  if($DbConnect = @mysqli_connect($HostName, $DbUserName, $DbPassword, $DbName)) {
                     $TypesArray=array();
                     $GetConstants = get_defined_constants(true);
                     foreach($GetConstants['mysqli'] as $c => $n) if(preg_match('/^MYSQLI_TYPE_(.*)/', $c, $m)) $TypesArray[$n] = $m[1];
                     $TypesArrayCount = count($TypesArray);
                     $TableCount = count($MysqlTablesArray[7]);
                     $TableNumber=1;
                     $MysqlTablesOutputSector .= "        <tr>\n";
                     $MysqlTablesOutputSector .= "          <td colspan=\"3\"><hr></td>\n";
                     $MysqlTablesOutputSector .= "        </tr>\n";
                     $MysqlTablesOutputSector .= "        <tr>\n";
                     $MysqlTablesOutputSector .= "          <td colspan=\"3\">&nbsp;</td>\n";
                     $MysqlTablesOutputSector .= "        </tr>\n";
                     $MysqlTablesOutputSector .= "        <tr>\n";
                     $MysqlTablesOutputSector .= "          <td colspan=\"3\">\n";
                     $MysqlTablesOutputSector .= "            <div id=\"div_result\">\n";
                     $MysqlTablesOutputSector .= "              <table>\n";
                     for($x=0; $x<$TableCount; $x++) {
                        $SqlFieldNameArray=array();
                        $SqlFieldLengthArray=array();
                        $SqlFieldTypeNumberArray=array();
                        $SqlFieldTypeArray=array();
                        $SqlFieldNameArray[] = $MysqliTablesDetailsArray[25];
                        $SqlFieldLengthArray[] = $MysqliTablesDetailsArray[26];
                        $SqlFieldTypeArray[] = $MysqliTablesDetailsArray[27];
                        $SqlDataRecordsContentArray=array();
                        $SqlCommand = "SELECT * FROM " . $MysqlTablesArray[7][$x];
                        $SqlQueryNotSuccessfulMessage = $MysqliTablesMessagesArray[10] . " " . $SqlCommand;
                        $SqlResult = $DbConnect -> query($SqlCommand) or die($SqlQueryNotSuccessfulMessage);
                        $MysqlTablesOutputSector .= "                <tr>\n";
                        $MysqlTablesOutputSector .= "                  <td>" . $TableNumber . "</td>\n";
                        $MysqlTablesOutputSector .= "                  <td class=\"right\">" . $MysqliTablesDetailsArray[24] . "</td>\n";
                        $MysqlTablesOutputSector .= "                  <td>" . $MysqlTablesArray[7][$x] . "</td>\n";
                        $MysqlTablesOutputSector .= "                </tr>\n";
                        $MysqlTablesOutputSector .= "                <tr>\n";
                        $MysqlTablesOutputSector .= "                  <td colspan=\"3\">\n";
                        while($FieldInfo = @mysqli_fetch_field($SqlResult)) {
                           $SqlFieldNameArray[] = $FieldInfo -> name;
                           $SqlFieldLengthArray[] = $FieldInfo -> length;
                           $CurrentFieldType = $FieldInfo -> type;
                           $SqlFieldTypeNumberArray[] = $CurrentFieldType;
                           for($y=0; $y<$TypesArrayCount; $y++) {
                              $TypesValue=0;
                              $CurrentArrayKey = key($TypesArray);
                              if($CurrentArrayKey == $CurrentFieldType) {
                                 $SqlFieldTypeArray[] = $TypesArray[$CurrentArrayKey];
                                 $TypesValue=1;
                              }
                              if(!empty($TypesValue)) break;
                              next($TypesArray);
                           }
                           if(empty($TypesValue)) $SqlFieldTypeArray[] = $SqlContentNoValue;
                           reset($TypesArray);
                        }
                        while($DataRecordsContent = @mysqli_fetch_row($SqlResult)) {
                           $FieldCount = @mysqli_num_fields($SqlResult);
                           $SqlFieldContentArray=array();
                           $SqlFieldContentArray[] = '&nbsp;';
                           for($y=0; $y<$FieldCount; $y++) {
                              // Binaerdaten: Feld-Typ 249 - TINY_BLOB, Feld-Typ 250 - MEDIUM_BLOB, Feld-Typ 251 - LONG_BLOB, Feld-Typ 252 - BLOB
                              if(preg_match("/^249|(25[0-2])$/", $SqlFieldTypeNumberArray[$y])) {
                                 if((is_string($DataRecordsContent[$y]) ||
                                    is_numeric($DataRecordsContent[$y]) ||
                                    is_bool($DataRecordsContent[$y])) &&
                                    preg_match('/^(.{65,})$/', $DataRecordsContent[$y])) {
                                    preg_match('/^(.{0,64})(.*)$/', $DataRecordsContent[$y], $TruncatedStringArray);
                                    $TruncatedCurrentFieldContent = $TruncatedStringArray[1] . "...";
                                    $SqlFieldContentArray[] = $TruncatedCurrentFieldContent;
                                 } elseif((is_string($DataRecordsContent[$y]) ||
                                    is_numeric($DataRecordsContent[$y]) ||
                                    is_bool($DataRecordsContent[$y])) &&
                                    preg_match('/^(.{0,64})$/', $DataRecordsContent[$y])) {
                                    $SqlFieldContentArray[] = $DataRecordsContent[$y];
                                 }
                                 else
                                 {
                                 $SqlFieldContentArray[] = $MysqliTablesMessagesArray[1];
                                 }
                              } elseif(preg_match('/^(.{65,})$/', $DataRecordsContent[$y])) {
                                 preg_match('/^(.{0,64})(.*)$/', $DataRecordsContent[$y], $TruncatedStringArray);
                                 $TruncatedCurrentFieldContent = $TruncatedStringArray[1] . "...";
                                 $SqlFieldContentArray[] = $TruncatedCurrentFieldContent;
                              }
                              else
                              {
                              $SqlFieldContentArray[] = $DataRecordsContent[$y];
                              }
                           }
                           $SqlDataRecordsContentArray[] = $SqlFieldContentArray;
                           unset($SqlFieldContentArray);
                        }
                        @mysqli_free_result($SqlResult);
                        $MysqlTablesOutputSector .= "                    <table class=\"table_result\">\n";
                        $MysqlTablesOutputSector .= "                      <tr>\n";
                        $SqlFieldNameArrayCount = count($SqlFieldNameArray);
                        for($y=0; $y<$SqlFieldNameArrayCount; $y++) {
                           if(isset($SqlFieldNameArray[$y])) {
                              if($y == 0) {
                                 $MysqlTablesOutputSector .= "                        <td class=\"title_column_1\">" . $SqlFieldNameArray[$y] . "&nbsp;</td>\n";
                              }
                              else
                              {
                              $MysqlTablesOutputSector .= "                        <td class=\"column_2_and_more\">" . $SqlFieldNameArray[$y] . "</td>\n";
                              }
                           }
                           else
                           {
                           $MysqlTablesOutputSector .= "                        <td class=\"column_vo_value\">" . $SqlContentNoValue . "</td>\n";
                           }
                        }
                        $MysqlTablesOutputSector .= "                      </tr>\n";
                        $MysqlTablesOutputSector .= "                      <tr>\n";
                        for($y=0; $y<$SqlFieldNameArrayCount; $y++) {
                           if(isset($SqlFieldLengthArray[$y])) {
                              if($y == 0) {
                                 $MysqlTablesOutputSector .= "                        <td class=\"title_column_1\">" . $SqlFieldLengthArray[$y] . "&nbsp;</td>\n";
                              }
                              else
                              {
                              $MysqlTablesOutputSector .= "                        <td class=\"column_2_and_more\">" . $SqlFieldLengthArray[$y] . "</td>\n";
                              }
                           }
                           else
                           {
                           $MysqlTablesOutputSector .= "                        <td class=\"column_vo_value\">" . $SqlContentNoValue . "</td>\n";
                           }
                        }
                        $MysqlTablesOutputSector .= "                      </tr>\n";
                        $MysqlTablesOutputSector .= "                      <tr>\n";
                        for($y=0; $y<$SqlFieldNameArrayCount; $y++) {
                           if(isset($SqlFieldTypeArray[$y])) {
                              if($y == 0) {
                                 $MysqlTablesOutputSector .= "                        <td class=\"title_column_1\">" . $SqlFieldTypeArray[$y] . "&nbsp;</td>\n";
                              }
                              else
                              {
                              $MysqlTablesOutputSector .= "                        <td class=\"column_2_and_more\">" . $SqlFieldTypeArray[$y] . "</td>\n";
                              }
                            }
                           else
                           {
                           $MysqlTablesOutputSector .= "                        <td class=\"column_vo_value\">" . $SqlContentNoValue . "</td>\n";
                           }
                        }
                        $MysqlTablesOutputSector .= "                      </tr>\n";
                        $SqlDataRecordsContentArrayCount = count($SqlDataRecordsContentArray);
                        for($y=0; $y<$SqlDataRecordsContentArrayCount; $y++) {
                           $MysqlTablesOutputSector .= "                      <tr>\n";
                           for($z=0; $z<$SqlFieldNameArrayCount; $z++) {
                              if(isset($SqlDataRecordsContentArray[$y])) {
                                 if($z == 0) {
                                    $MysqlTablesOutputSector .= "                        <td>" . $SqlDataRecordsContentArray[$y][$z] . "</td>\n";
                                 }
                                 else
                                 {
                                 $MysqlTablesOutputSector .= "                        <td class=\"data_field\">" . $SqlDataRecordsContentArray[$y][$z] . "</td>\n";
                                 }
                              }
                              else
                              {
                              $MysqlTablesOutputSector .= "                        <td class=\"center\">" . $SqlContentNoValue . "</td>\n";
                              }
                           }
                           $MysqlTablesOutputSector .= "                      </tr>\n";
                        }
                        if(empty($SqlDataRecordsContentArrayCount)) {
                           $MysqlTablesOutputSector .= "                      <tr>\n";
                           $MysqlTablesOutputSector .= "                        <td colspan=\"" . $SqlFieldNameArrayCount . "\">" . $MysqliTablesMessagesArray[15] . "</td>\n";
                           $MysqlTablesOutputSector .= "                      </tr>\n";
                        }
                        $MysqlTablesOutputSector .= "                    </table>\n";
                        $MysqlTablesOutputSector .= "                  </td>\n";
                        $MysqlTablesOutputSector .= "                </tr>\n";
                        if($TableNumber < $TableCount) {
                           $MysqlTablesOutputSector .= "                <tr>\n";
                           $MysqlTablesOutputSector .= "                  <td colspan=\"3\">&nbsp;</td>\n";
                           $MysqlTablesOutputSector .= "                </tr>\n";
                        }
                        $TableNumber++;
                        unset($SqlFieldNameArray);
                        unset($SqlFieldLengthArray);
                        unset($SqlFieldTypeNumberArray);
                        unset($SqlFieldTypeArray);
                        unset($SqlDataRecordsContentArray);
                     }
                     $MysqlTablesOutputSector .= "              </table>\n";
                     $MysqlTablesOutputSector .= "            </div>\n";
                     $MysqlTablesOutputSector .= "          </td>\n";
                     $MysqlTablesOutputSector .= "        </tr>\n";
                     $MysqlTablesOutputSector .= "        <tr>\n";
                     $MysqlTablesOutputSector .= "          <td colspan=\"3\">&nbsp;</td>\n";
                     $MysqlTablesOutputSector .= "        </tr>\n";
                     $SqlDatabaseNotClosedMessage = $MysqliTablesMessagesArray[11] . " " . $DbName;
                     @mysqli_close($DbConnect) or die($SqlDatabaseNotClosedMessage);
                  }
                  else
                  {
                     $MysqlTablesMessagesHtml .="        <tr>\n";
                     $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[8] . " " . $DbName . "</td>\n";
                     $MysqlTablesMessagesHtml .="        </tr>\n";
                     $NoSuccessfulReturnCode=1;
                  }
               }
               else
               {
                  $MysqlTablesMessagesHtml .="        <tr>\n";
                  $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[12] . "</td>\n";
                  $MysqlTablesMessagesHtml .="        </tr>\n";
                  $NoSuccessfulReturnCode=1;
               }
               if(empty($NoSuccessfulReturnCode)) {
                  $MysqlTablesMessagesHtml .="        <tr>\n";
                  $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[9] . "</td>\n";
                  $MysqlTablesMessagesHtml .="        </tr>\n";
              }
            } elseif($SqlStringCmp2 == 0) {
               // MySQL
               $SqlLanguage1Checked='';
               $SqlLanguage2Checked = " checked";
               if(extension_loaded($Extension2) &&  (!empty(@ini_get('mysql.allow_local_infile')) || !empty(@ini_get('mysql.allow_persistent')))) {
                  $DbConnect = @mysql_connect($HostName, $DbUserName, $DbPassword);
                  if(@mysql_select_db($DbName, $DbConnect)) {
                     $TableCount = count($MysqlTablesArray[7]);
                     $TableNumber=1;
                     $MysqlTablesOutputSector .= "        <tr>\n";
                     $MysqlTablesOutputSector .= "          <td colspan=\"3\"><hr></td>\n";
                     $MysqlTablesOutputSector .= "        </tr>\n";
                     $MysqlTablesOutputSector .= "        <tr>\n";
                     $MysqlTablesOutputSector .= "          <td colspan=\"3\">&nbsp;</td>\n";
                     $MysqlTablesOutputSector .= "        </tr>\n";
                     $MysqlTablesOutputSector .= "        <tr>\n";
                     $MysqlTablesOutputSector .= "          <td colspan=\"3\">\n";
                     $MysqlTablesOutputSector .= "            <div id=\"div_result\">\n";
                     $MysqlTablesOutputSector .= "              <table>\n";
                     for($x=0; $x<$TableCount; $x++) {
                        $SqlFieldNameArray=array();
                        $SqlFieldLengthArray=array();
                        $SqlFieldTypeArray=array();
                        $SqlFieldNameArray[] = $MysqliTablesDetailsArray[25];
                        $SqlFieldLengthArray[] = $MysqliTablesDetailsArray[26];
                        $SqlFieldTypeArray[] = $MysqliTablesDetailsArray[27];
                        $SqlDataRecordsContentArray=array();
                        $SqlCommand = "SELECT * FROM " . $MysqlTablesArray[7][$x];
                        $SqlQueryNotSuccessfulMessage = $MysqliTablesMessagesArray[10] . " " . $SqlCommand;
                        $SqlResult = @mysql_db_query($DbName, $SqlCommand) or die($SqlQueryNotSuccessfulMessage);
                        $MysqlTablesOutputSector .= "                <tr>\n";
                        $MysqlTablesOutputSector .= "                  <td>" . $TableNumber . "</td>\n";
                        $MysqlTablesOutputSector .= "                  <td class=\"right\">" . $MysqliTablesDetailsArray[24] . "</td>\n";
                        $MysqlTablesOutputSector .= "                  <td>" . $MysqlTablesArray[7][$x] . "</td>\n";
                        $MysqlTablesOutputSector .= "                </tr>\n";
                        $MysqlTablesOutputSector .= "                <tr>\n";
                        $MysqlTablesOutputSector .= "                  <td colspan=\"3\">\n";
                        $FieldCount = @mysql_num_fields($SqlResult);
                        for($y=0; $y<$FieldCount; $y++) {
                           $SqlFieldNameArray[] = @mysql_field_name($SqlResult, $y);
                           $SqlFieldLengthArray[] = @mysql_field_len($SqlResult, $y);
                           $SqlFieldTypeArray[] = @mysql_field_type($SqlResult, $y);
                        }
                        while($DataRecordsContent = @mysql_fetch_row($SqlResult)) {
                           $FieldCount = @mysql_num_fields($SqlResult);
                           $SqlFieldContentArray=array();
                           $SqlFieldContentArray[] = '&nbsp;';
                           for($y=0; $y<$FieldCount; $y++) {
                              if((is_string($DataRecordsContent[$y]) ||
                                 is_numeric($DataRecordsContent[$y]) ||
                                 is_bool($DataRecordsContent[$y])) &&
                                 preg_match('/^(.{65,})$/', $DataRecordsContent[$y])) {
                                 preg_match('/^(.{0,64})(.*)$/', $DataRecordsContent[$y], $TruncatedStringArray);
                                 $TruncatedCurrentFieldContent = $TruncatedStringArray[1] . "...";
                                 $SqlFieldContentArray[] = $TruncatedCurrentFieldContent;
                              } elseif((is_string($DataRecordsContent[$y]) ||
                                 is_numeric($DataRecordsContent[$y]) ||
                                 is_bool($DataRecordsContent[$y])) &&
                                 preg_match('/^(.{0,64})$/', $DataRecordsContent[$y])) {
                                 $SqlFieldContentArray[] = $DataRecordsContent[$y];
                              }
                              else
                              {
                              $SqlFieldContentArray[] = $MysqliTablesMessagesArray[1];
                              }
                           }
                           $SqlDataRecordsContentArray[] = $SqlFieldContentArray;
                           unset($SqlFieldContentArray);
                        }
                        @mysql_free_result($SqlResult);
                        $MysqlTablesOutputSector .= "                    <table class=\"table_result\">\n";
                        $MysqlTablesOutputSector .= "                      <tr>\n";
                        $SqlFieldNameArrayCount = count($SqlFieldNameArray);
                        for($z=0; $z<$SqlFieldNameArrayCount; $z++) {
                           if(isset($SqlFieldNameArray[$z])) {
                              if($z == 0) {
                                 $MysqlTablesOutputSector .= "                        <td class=\"title_column_1\">" . $SqlFieldNameArray[$z] . "&nbsp;</td>\n";
                              }
                              else
                              {
                              $MysqlTablesOutputSector .= "                        <td class=\"column_2_and_more\">" . $SqlFieldNameArray[$z] . "</td>\n";
                              }
                           }
                           else
                           {
                           $MysqlTablesOutputSector .= "                        <td class=\"column_vo_value\">" . $SqlContentNoValue . "</td>\n";
                           }
                        }
                        $MysqlTablesOutputSector .= "                      </tr>\n";
                        $MysqlTablesOutputSector .= "                      <tr>\n";
                        for($z=0; $z<$SqlFieldNameArrayCount; $z++) {
                           if(isset($SqlFieldLengthArray[$z])) {
                              if($z == 0) {
                                 $MysqlTablesOutputSector .= "                        <td class=\"title_column_1\">" . $SqlFieldLengthArray[$z] . "&nbsp;</td>\n";
                              }
                              else
                              {
                              $MysqlTablesOutputSector .= "                        <td class=\"column_2_and_more\">" . $SqlFieldLengthArray[$z] . "</td>\n";
                              }
                           }
                           else
                           {
                           $MysqlTablesOutputSector .= "                        <td class=\"column_vo_value\">" . $SqlContentNoValue . "</td>\n";
                           }
                        }
                        $MysqlTablesOutputSector .= "                      </tr>\n";
                        $MysqlTablesOutputSector .= "                      <tr>\n";
                        for($z=0; $z<$SqlFieldNameArrayCount; $z++) {
                           if(isset($SqlFieldTypeArray[$z])) {
                              if($z == 0) {
                                 $MysqlTablesOutputSector .= "                        <td class=\"title_column_1\">" . $SqlFieldTypeArray[$z] . "&nbsp;</td>\n";
                              }
                              else
                              {
                              $MysqlTablesOutputSector .= "                        <td class=\"column_2_and_more\">" . $SqlFieldTypeArray[$z] . "</td>\n";
                              }
                            }
                           else
                           {
                           $MysqlTablesOutputSector .= "                        <td class=\"column_vo_value\">" . $SqlContentNoValue . "</td>\n";
                           }
                        }
                        $MysqlTablesOutputSector .= "                      </tr>\n";
                        $SqlDataRecordsContentArrayCount = count($SqlDataRecordsContentArray);
                        for($z=0; $z<$SqlDataRecordsContentArrayCount; $z++) {
                           $MysqlTablesOutputSector .= "                      <tr>\n";
                           for($i=0; $i<$SqlFieldNameArrayCount; $i++) {
                              if(isset($SqlDataRecordsContentArray[$z])) {
                                 if($i == 0) {
                                    $MysqlTablesOutputSector .= "                        <td>" . $SqlDataRecordsContentArray[$z][$i] . "</td>\n";
                                 }
                                 else
                                 {
                                 $MysqlTablesOutputSector .= "                        <td class=\"data_field\">" . $SqlDataRecordsContentArray[$z][$i] . "</td>\n";
                                 }
                               }
                              else
                              {
                              $MysqlTablesOutputSector .= "                        <td class=\"center\">" . $SqlContentNoValue . "</td>\n";
                              }
                           }
                           $MysqlTablesOutputSector .= "                      </tr>\n";
                        }
                        if(empty($SqlDataRecordsContentArrayCount)) {
                           $MysqlTablesOutputSector .= "                      <tr>\n";
                           $MysqlTablesOutputSector .= "                        <td colspan=\"" . $SqlFieldNameArrayCount . "\">" . $MysqliTablesMessagesArray[15] . "</td>\n";
                           $MysqlTablesOutputSector .= "                      </tr>\n";
                        }
                        $MysqlTablesOutputSector .= "                    </table>\n";
                        $MysqlTablesOutputSector .= "                  </td>\n";
                        $MysqlTablesOutputSector .= "                </tr>\n";
                        if($TableNumber < $TableCount) {
                           $MysqlTablesOutputSector .= "                <tr>\n";
                           $MysqlTablesOutputSector .= "                  <td colspan=\"3\">&nbsp;</td>\n";
                           $MysqlTablesOutputSector .= "                </tr>\n";
                        }
                        $TableNumber++;
                        unset($SqlFieldNameArray);
                        unset($SqlFieldLengthArray);
                        unset($SqlFieldTypeArray);
                        unset($SqlDataRecordsContentArray);
                     }
                     $MysqlTablesOutputSector .= "              </table>\n";
                     $MysqlTablesOutputSector .= "            </div>\n";
                     $MysqlTablesOutputSector .= "          </td>\n";
                     $MysqlTablesOutputSector .= "        </tr>\n";
                     $MysqlTablesOutputSector .= "        <tr>\n";
                     $MysqlTablesOutputSector .= "          <td colspan=\"3\">&nbsp;</td>\n";
                     $MysqlTablesOutputSector .= "        </tr>\n";
                     $SqlDatabaseNotClosedMessage = $MysqliTablesMessagesArray[11] . " " . $DbName;
                     @mysql_close($DbConnect) or die($SqlDatabaseNotClosedMessage);
                  }
                  else
                  {
                     $MysqlTablesMessagesHtml .="        <tr>\n";
                     $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[8] . " " . $DbName . "</td>\n";
                     $MysqlTablesMessagesHtml .="        </tr>\n";
                     $NoSuccessfulReturnCode=1;
                  }
               }
               else
               {
                  $MysqlTablesMessagesHtml .="        <tr>\n";
                  $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[13] . "</td>\n";
                  $MysqlTablesMessagesHtml .="        </tr>\n";
                  $NoSuccessfulReturnCode=1;
               }
               if(empty($NoSuccessfulReturnCode)) {
                  $MysqlTablesMessagesHtml .="        <tr>\n";
                  $MysqlTablesMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqliTablesMessagesArray[9] . "</td>\n";
                  $MysqlTablesMessagesHtml .="        </tr>\n";
              }
            }
            else
            {
               print "NOTE: SYSTEM-VARIABLE SQL-LANGUAGE-SPECIFICATION (SQL_DB_TYPE) - function <strong>create_mysqli_tables</strong> - IS DAMAGED!";
               exit;
            }
         }
      }
      if(!empty($MysqlTablesMessagesHtml)) {
         $MysqlTablesMessagesHtml .="        <tr>\n";
         $MysqlTablesMessagesHtml .="          <td colspan=\"3\"><hr></td>\n";
         $MysqlTablesMessagesHtml .="        </tr>\n";
      }
      if(!empty($MysqlTablesOutputSector)) {
         $MysqlTablesOutputSector .= "        <tr>\n";
         $MysqlTablesOutputSector .= "          <td colspan=\"3\"><hr></td>\n";
         $MysqlTablesOutputSector .= "        </tr>\n";
      }
   } elseif(!isset($ObelixFileNameArray) ||
      !is_array($ObelixFileNameArray) ||
      $ObelixFileNameArrayDefaultCount != $ObelixFileNameArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY ObelixFileNameArray (ARRAY-COUNT) - function <strong>create_mysqli_tables</strong> - IS DAMAGED!';
      exit;
   } elseif(!isset($MysqlTablesArray) ||
      !is_array($MysqlTablesArray) ||
      $MysqlTablesArrayDefaultCount != $MysqlTablesArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY MysqliTablesArray (ARRAY-COUNT) - function <strong>create_mysqli_tables</strong> - IS DAMAGED!';
      exit;
   } elseif(!isset($MysqliTablesDetailsArray) ||
      !is_array($MysqliTablesDetailsArray) ||
      $MysqliTablesDetailsArrayDefaultCount != $MysqliTablesDetailsArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY MysqliTablesDetailsArray (ARRAY-COUNT) - function <strong>create_mysqli_tables</strong> - IS DAMAGED!';
      exit;
   }
   else
   {
      print 'NOTE: SYSTEM-ARRAY MysqliTablesMessagesArray (ARRAY-COUNT) - function <strong>create_mysqli_tables</strong> - IS DAMAGED!';
      exit;
   }
   $MainContent="    <form name=\"form_mysqli_tables\" method=\"post\" action=\"" . $ObelixFileNameArray[4] . "?OBELIX_ID=" . $MysqliTablesDetailsArray[0] . "&ACCESS_ID=" . $MysqliTablesDetailsArray[1] . "\" target=\"_self\">\n";
   $MainContent .="      <table class=\"table_main\">\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\" class=\"center\"><h3>" . $MysqliTablesDetailsArray[2] . "</h3></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">" . $MysqliTablesDetailsArray[3] . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\"><hr></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .= $MysqlTablesMessagesHtml;
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"input_title\">" . $MysqliTablesDetailsArray[4] . " </td>\n";
   $MainContent .="          <td><input type=\"radio\" name=\"SQL_DB_TYPE\" value=\"mysqli\"" . $SqlLanguage1Checked . "></td>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"input_title\">" . $MysqliTablesDetailsArray[5] . " </td>\n";
   $MainContent .="          <td><input type=\"radio\" name=\"SQL_DB_TYPE\" value=\"mysql\"" . $SqlLanguage2Checked . "></td>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"input_title\">" . $MysqliTablesDetailsArray[6] . " </td>\n";
   $MainContent .="          <td><input type=\"text\" name=\"HOST_NAME\" size=\"16\" maxlength=\"128\" value=\"" . $HostName . "\"></td>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"input_title\">" . $MysqliTablesDetailsArray[7] . " </td>\n";
   $MainContent .="          <td><input type=\"text\" name=\"DB_NAME\" size=\"16\" maxlength=\"128\" value=\"" . $DbName . "\"></td>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"input_title\">" . $MysqliTablesDetailsArray[8] . " </td>\n";
   $MainContent .="          <td><input type=\"text\" name=\"DB_USER_NAME\" size=\"16\" maxlength=\"128\" value=\"" . $DbUserName . "\"></td>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"input_title\">" . $MysqliTablesDetailsArray[9] . " </td>\n";
   $MainContent .="          <td><input type=\"password\" name=\"DB_PASSWORD\" size=\"16\" maxlength=\"128\" value=\"" . $DbPassword . "\"></td>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"note_bold\">" . $MysqliTablesDetailsArray[10] . " </td>\n";
   $MainContent .="          <td>" . $MysqliTablesDetailsArray[11] . "</td>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"right\"><input type=\"radio\" name=\"DB_CONNECTION\" value=\"1\"" . $SqlDbConnection1Checked . "></td>\n";
   $MainContent .="          <td>" . $MysqliTablesDetailsArray[12] . "</td>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"right\"><input type=\"radio\" name=\"DB_CONNECTION\" value=\"2\"" . $SqlDbConnection2Checked . "></td>\n";
   $MainContent .="          <td>" . $MysqliTablesDetailsArray[13] . "</td>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"right\"><input type=\"radio\" name=\"DB_CONNECTION\" value=\"3\"" . $SqlDbConnection3Checked . "></td>\n";
   $MainContent .="          <td>" . $MysqliTablesDetailsArray[14] . "</td>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"right\"><input type=\"radio\" name=\"DB_CONNECTION\" value=\"4\"" . $SqlDbConnection4Checked . "></td>\n";
   $MainContent .="          <td>" . $MysqliTablesDetailsArray[15] . "</td>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"right\"><input type=\"radio\" name=\"DB_CONNECTION\" value=\"5\"" . $SqlDbConnection5Checked . "></td>\n";
   $MainContent .="          <td>" . $MysqliTablesDetailsArray[16] . "</td>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .= $MysqlTablesOutputSector;
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\" class=\"center\"><input type=\"submit\" name=\"SQL_TABLES_SUBMIT\" value=\"" . $MysqliTablesDetailsArray[17] . "\"></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="      </table>\n";
   $MainContent .="    </form>\n";
   return $MainContent;
}

// CSS - Navigation: MySQLi-TABLES
function create_mysqli_tables_css() {
   $MysqlTablesCSS="h3 {\n  font-size: 1.15em;\n  font-weight: bold;\n  text-align: center;\n}\n\n";
   $MysqlTablesCSS .=".table_main { width: 100%; }\n\n";
   $MysqlTablesCSS .="td { font-size: 0.9em; }\n\n";
   $MysqlTablesCSS .="hr { width: 100%; }\n\n";
   $MysqlTablesCSS .="input { font-size: 0.85em; }\n\n";
   $MysqlTablesCSS .="#div_result {\n  overflow: auto;\n  margin: 3px 3px 3px 3px;\n  padding: 8px 8px 8px 8px;\n  width: 1100px;\n  max-height: 1200px;\n  float: right;\n}\n\n";
   $MysqlTablesCSS .=".table_result {\n  border-collapse: collapse;\n  border: 1px solid gray;\n}\n\n";
   $MysqlTablesCSS .=".title_note_a {\n  padding: 8px 4px 8px 4px;\n  text-align: center;\n  background-color: #F9F4F0;\n}\n\n";
   $MysqlTablesCSS .=".title_field_1 {\n  padding: 2px 4px 2px 4px;\n  width: 80px;\n  border-right: 1px solid gray;\n  border-top: 1px solid gray;\n  border-bottom: 1px solid gray;\n  background-color: #D6B194;\n}\n\n";
   $MysqlTablesCSS .=".title_field_2 {\n  padding: 2px 4px 2px 4px;\n  border-right: 1px solid gray;\n  border-top: 1px solid gray;\n  border-bottom: 1px solid gray;\n  background-color: #D6B194;\n}\n\n";
   $MysqlTablesCSS .=".title_field_3 {\n  padding: 2px 4px 2px 4px;\n  width: 150px;\n  border-right: 1px solid gray;\n  border-top: 1px solid gray;\n  border-bottom: 1px solid gray;\n  background-color: #D6B194;\n}\n\n";
   $MysqlTablesCSS .=".title_field_4 {\n  padding: 2px 4px 2px 4px;\n  width: 120px;\n  border-right: 1px solid gray;\n  border-top: 1px solid gray;\n  border-bottom: 1px solid gray;\n  background-color: #D6B194;\n}\n\n";
   $MysqlTablesCSS .=".title_field_5 {\n  padding: 2px 4px 2px 4px;\n  width: 100px;\n  border-right: 1px solid gray;\n  border-top: 1px solid gray;\n  border-bottom: 1px solid gray;\n  background-color: #D6B194;\n}\n\n";
   $MysqlTablesCSS .=".data_field_1 {\n  padding: 2px 4px 2px 4px;\n  text-align: right;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n}\n\n";
   $MysqlTablesCSS .=".data_field_2 {\n  padding: 2px 4px 2px 4px;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n}\n\n";
   $MysqlTablesCSS .=".data_field_3 {\n  padding: 2px 4px 2px 4px;\n  text-align: center;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n}\n\n";
   $MysqlTablesCSS .=".data_field_4 {\n  padding: 2px 4px 2px 4px;\n  text-align: center;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n}\n\n";
   $MysqlTablesCSS .=".data_field_5 {\n  text-align: center;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n}\n\n";
   $MysqlTablesCSS .=".title_column_1 {\n  padding: 2px 4px 2px 4px;\n  font-weight: bold;\n  border-right: 1px solid gray;\n  border-top: 1px solid gray;\n  border-bottom: 1px solid gray;\n  background-color: #DDDBA6;\n}\n\n";
   $MysqlTablesCSS .=".column_2_and_more {\n  padding: 2px 4px 2px 4px;\n  border-right: 1px solid gray;\n  border-top: 1px solid gray;\n  border-bottom: 1px solid gray;\n  background-color: #DDDBA6;\n}\n\n";
   $MysqlTablesCSS .=".column_vo_value {\n  padding: 2px 4px 2px 4px;\n  text-align: center;\n  border-right: 1px solid gray;\n  border-top: 1px solid gray;\n  border-bottom: 1px solid gray;\n  background-color: #DDDBA6;\n}\n\n";
   $MysqlTablesCSS .=".data_field {\n  padding: 2px 4px 2px 4px;\n  border-left: 1px solid gray;\n  border-bottom: 1px solid gray;\n}\n\n";
   $MysqlTablesCSS .=".input_title {\n  font-size: 0.95em;\n  text-align: right;\n  font-weight: bold;\n}\n\n";
   $MysqlTablesCSS .=".note_bold {\n  font-size: 0.95em;\n  text-align: right;\n  font-weight: bold;\n}\n\n";
   $MysqlTablesCSS .=".red {\n  font-size: 0.95em;\n  font-weight: bold;\n  text-align: center;\n  color:#DD0000;\n}\n\n";
   $MysqlTablesCSS .=".right { text-align: right; }\n\n";
   return $MysqlTablesCSS;
}

// Erstellung der Webseite  MySQLi-COMMAND
function create_mysqli_command($ObelixFileNameArray='', $MysqlCommandArray='', $MysqlCommandDetailsArray='', $MysqlCommandMessagesArray='') {
   $MysqlCommandMessagesHtml="";
   $HostName='';
   $DbName='';
   $DbUserName='';
   $DbPassword='';
   $MysqlCommandOutputSector='';
   $Extension1 = 'mysqli';
   $Extension2 = 'mysql';
   $SqlLanguage1Checked = " checked";
   $SqlLanguage2Checked='';
   $SqlDbConnection1Checked = " checked";
   $SqlDbConnection2Checked='';
   $SqlDbConnection3Checked='';
   $SqlDbConnection4Checked='';
   $SqlDbConnection5Checked='';
   $RadioButtonShow1 = " checked";
   $RadioButtonShow2='';
   $RadioButtonShow3='';
   $SqlContentNoValue = "no value";
   if(empty($MysqlCommandDetailsArray[0])) $MysqlCommandDetailsArray[0]=0;
   if(empty($MysqlCommandDetailsArray[1])) $MysqlCommandDetailsArray[1]=0;
   $ObelixFileNameArrayDefaultCount=15; // Vorgabe: Anzahl der Array-Elemente
   $ObelixFileNameArrayCurrentCount=count($ObelixFileNameArray);
   $MysqlCommandArrayDefaultCount=9; // Vorgabe: Anzahl der Array-Elemente
   $MysqlCommandArrayCurrentCount=count($MysqlCommandArray);
   $MysqlCommandDetailsArrayDefaultCount=38; // Vorgabe: Anzahl der Array-Elemente
   $MysqlCommandDetailsArrayCurrentCount=count($MysqlCommandDetailsArray);
   $MysqlCommandMessagesArrayDefaultCount=19; // Vorgabe: Anzahl der Array-Elemente
   $MysqlCommandMessagesArrayCurrentCount=count($MysqlCommandMessagesArray);
   if(isset($ObelixFileNameArray) &&
      is_array($ObelixFileNameArray) &&
      $ObelixFileNameArrayDefaultCount == $ObelixFileNameArrayCurrentCount &&
      isset($MysqlCommandArray) &&
      is_array($MysqlCommandArray) &&
      $MysqlCommandArrayDefaultCount == $MysqlCommandArrayCurrentCount &&
      isset($MysqlCommandDetailsArray) &&
      is_array($MysqlCommandDetailsArray) &&
      $MysqlCommandDetailsArrayDefaultCount == $MysqlCommandDetailsArrayCurrentCount &&
      isset($MysqlCommandMessagesArray) &&
      is_array($MysqlCommandMessagesArray) &&
      $MysqlCommandMessagesArrayDefaultCount == $MysqlCommandMessagesArrayCurrentCount) {
      if(!empty($MysqlCommandArray[8])) {
         if(!empty($MysqlCommandArray[5]) && $MysqlCommandArray[5] == 1) {
            if(!empty($MysqlCommandArray[1]) &&
               !empty($MysqlCommandArray[2]) &&
               !empty($MysqlCommandArray[3])) {
               $HostName = $MysqlCommandArray[1];
               $DbName = $MysqlCommandArray[2];
               $DbUserName = $MysqlCommandArray[3];
               if(isset($MysqlCommandArray[4])) $DbPassword = $MysqlCommandArray[4];
               $DbAccessDataReturnCode=1;
            }
            else
            {
               $MysqlCommandMessagesHtml .="        <tr>\n";
               $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[0] . "</td>\n";
               $MysqlCommandMessagesHtml .="        </tr>\n";
            }
         } elseif(!empty($MysqlCommandArray[5]) && $MysqlCommandArray[5] == 2) {
            $SqlDbConnection1Checked='';
            $SqlDbConnection2Checked = " checked";
            if(file_exists($ObelixFileNameArray[7]) && is_readable($ObelixFileNameArray[7])) {
               include($ObelixFileNameArray[7]);
               if(!empty($HostName) &&
                  !empty($DbName) &&
                  !empty($DbUserName) &&
                  isset($DbPassword)) {
                  $DbAccessDataReturnCode=1;
               }
               else
               {
                  $MysqlCommandMessagesHtml .="        <tr>\n";
                  $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[2] . "</td>\n";
                  $MysqlCommandMessagesHtml .="        </tr>\n";
               }
            } elseif(file_exists($ObelixFileNameArray[7]) && !is_readable($ObelixFileNameArray[7])) {
               $MysqlCommandMessagesHtml .="        <tr>\n";
               $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[18] . "</td>\n";
               $MysqlCommandMessagesHtml .="        </tr>\n";
            }
            else
            {
               $MysqlCommandMessagesHtml .="        <tr>\n";
               $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[3] . "</td>\n";
               $MysqlCommandMessagesHtml .="        </tr>\n";
            }
         } elseif(!empty($MysqlCommandArray[5]) && $MysqlCommandArray[5] == 3) {
            $SqlDbConnection1Checked='';
            $SqlDbConnection3Checked = " checked";
            if(file_exists($ObelixFileNameArray[7]) && is_readable($ObelixFileNameArray[7])) {
               include($ObelixFileNameArray[7]);
               if(!empty($HostName) &&
                  !empty($DbName) &&
                  !empty($DbUserName) &&
                  isset($DbPassword)) {
                  $HostName = base64_decode($HostName);
                  $DbName = base64_decode($DbName);
                  $DbUserName = base64_decode($DbUserName);
                  $DbPassword = base64_decode($DbPassword);
                  $DbAccessDataReturnCode=1;
               }
               else
               {
                  $MysqlCommandMessagesHtml .="        <tr>\n";
                  $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[2] . "</td>\n";
                  $MysqlCommandMessagesHtml .="        </tr>\n";
               }
            } elseif(file_exists($ObelixFileNameArray[7]) && !is_readable($ObelixFileNameArray[7])) {
               $MysqlCommandMessagesHtml .="        <tr>\n";
               $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[18] . "</td>\n";
               $MysqlCommandMessagesHtml .="        </tr>\n";
            }
            else
            {
               $MysqlCommandMessagesHtml .="        <tr>\n";
               $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[3] . "</td>\n";
               $MysqlCommandMessagesHtml .="        </tr>\n";
            } 
         } elseif(!empty($MysqlCommandArray[5]) && $MysqlCommandArray[5] == 4) {
            $SqlDbConnection1Checked='';
            $SqlDbConnection4Checked = " checked";
            if(!empty($MysqlCommandArray[1]) &&
               !empty($MysqlCommandArray[2]) &&
               !empty($MysqlCommandArray[3])) {
               $HostName = $MysqlCommandArray[1];
               $DbName = $MysqlCommandArray[2];
               $DbUserName = $MysqlCommandArray[3];
               if(isset($MysqlCommandArray[4])) $DbPassword = $MysqlCommandArray[4];
               $IncFileContent = "<?php\n";
               $IncFileContent .= '$HostName = ' . "'" . $HostName . "';\n";
               $IncFileContent .= '$DbName = ' . "'" . $DbName . "';\n";
               $IncFileContent .= '$DbUserName = ' . "'" . $DbUserName . "';\n";
               $IncFileContent .= '$DbPassword = ' . "'" . $DbPassword . "';\n";
               $IncFileContent .= "?>\n";
               if(is_writeable('./')) {
                  if(file_exists($ObelixFileNameArray[7])) {
                     @unlink($ObelixFileNameArray[7]);
                     if(file_exists($ObelixFileNameArray[7])) {
                        $MysqlCommandMessagesHtml .="        <tr>\n";
                        $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[4] . "</td>\n";
                        $MysqlCommandMessagesHtml .="        </tr>\n";
                        $ErrorReturnCode=1;
                     }
                  }
                  if(empty($ErrorReturnCode)) {
                     if(!file_exists($ObelixFileNameArray[7])) {
                        if(@touch($ObelixFileNameArray[7])) {
                           chmod($ObelixFileNameArray[7], $MysqlCommandDetailsArray[37]);
                           if($FileWrite = @fopen($ObelixFileNameArray[7],'w')) {
                              @flock($FileWrite,2);
                              @fwrite($FileWrite, $IncFileContent);
                              @flock($FileWrite,3);
                              @fclose($FileWrite);
                           }
                           else
                           {
                              $MysqlCommandMessagesHtml .="        <tr>\n";
                              $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[5] . "</td>\n";
                              $MysqlCommandMessagesHtml .="        </tr>\n";
                              $ErrorReturnCode=1;
                           }
                        }
                        else
                        {
                           $MysqlCommandMessagesHtml .="        <tr>\n";
                           $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[6] . "</td>\n";
                           $MysqlCommandMessagesHtml .="        </tr>\n";
                           $ErrorReturnCode=1;
                        }
                     }
                     if(empty($ErrorReturnCode)) {
                        if(file_exists($ObelixFileNameArray[7]) && is_readable($ObelixFileNameArray[7])) {
                           include($ObelixFileNameArray[7]);
                           if(!empty($HostName) &&
                              !empty($DbName) &&
                              !empty($DbUserName) &&
                              isset($DbPassword)) {
                              $DbAccessDataReturnCode=1;
                              $SqlDbConnection2Checked = " checked";
                              $SqlDbConnection4Checked='';
                           }
                           else
                           {
                              $MysqlCommandMessagesHtml .="        <tr>\n";
                              $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[2] . "</td>\n";
                              $MysqlCommandMessagesHtml .="        </tr>\n";
                           }
                        } elseif(file_exists($ObelixFileNameArray[7]) && !is_readable($ObelixFileNameArray[7])) {
                           $MysqlCommandMessagesHtml .="        <tr>\n";
                           $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[18] . "</td>\n";
                           $MysqlCommandMessagesHtml .="        </tr>\n";
                        }
                        else
                        {
                           $MysqlCommandMessagesHtml .="        <tr>\n";
                           $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[3] . "</td>\n";
                           $MysqlCommandMessagesHtml .="        </tr>\n";
                        }
                     }
                  }
               }
               else
               {
                  $MysqlCommandMessagesHtml .="        <tr>\n";
                  $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[7] . "</td>\n";
                  $MysqlCommandMessagesHtml .="        </tr>\n";
               }
            }
            else
            {
               $MysqlCommandMessagesHtml .="        <tr>\n";
               $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[0] . "</td>\n";
               $MysqlCommandMessagesHtml .="        </tr>\n";
            }
         } elseif(!empty($MysqlCommandArray[5]) && $MysqlCommandArray[5] == 5) {
            $SqlDbConnection1Checked='';
            $SqlDbConnection5Checked = " checked";
            if(!empty($MysqlCommandArray[1]) &&
               !empty($MysqlCommandArray[2]) &&
               !empty($MysqlCommandArray[3])) {
               $HostName = $MysqlCommandArray[1];
               $DbName = $MysqlCommandArray[2];
               $DbUserName = $MysqlCommandArray[3];
               if(isset($MysqlCommandArray[4])) $DbPassword = $MysqlCommandArray[4];
               $IncFileContent = "<?php\n";
               $IncFileContent .= '$HostName = ' . "'" . base64_encode($HostName) . "';\n";
               $IncFileContent .= '$DbName = ' . "'" . base64_encode($DbName) . "';\n";
               $IncFileContent .= '$DbUserName = ' . "'" . base64_encode($DbUserName) . "';\n";
               $IncFileContent .= '$DbPassword = ' . "'" . base64_encode($DbPassword) . "';\n";
               $IncFileContent .= "?>\n";
               if(is_writeable('./')) {
                  if(file_exists($ObelixFileNameArray[7])) {
                     @unlink($ObelixFileNameArray[7]);
                     if(file_exists($ObelixFileNameArray[7])) {
                        $MysqlCommandMessagesHtml .="        <tr>\n";
                        $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[4] . "</td>\n";
                        $MysqlCommandMessagesHtml .="        </tr>\n";
                        $ErrorReturnCode=1;
                     }
                  }
                  if(empty($ErrorReturnCode)) {
                     if(!file_exists($ObelixFileNameArray[7])) {
                        if(@touch($ObelixFileNameArray[7])) {
                           chmod($ObelixFileNameArray[7], $MysqlCommandDetailsArray[37]);
                           if($FileWrite = @fopen($ObelixFileNameArray[7],'w')) {
                              @flock($FileWrite,2);
                              @fwrite($FileWrite, $IncFileContent);
                              @flock($FileWrite,3);
                              @fclose($FileWrite);
                           }
                           else
                           {
                              $MysqlCommandMessagesHtml .="        <tr>\n";
                              $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[5] . "</td>\n";
                              $MysqlCommandMessagesHtml .="        </tr>\n";
                              $ErrorReturnCode=1;
                           }
                        }
                        else
                        {
                           $MysqlCommandMessagesHtml .="        <tr>\n";
                           $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[6] . "</td>\n";
                           $MysqlCommandMessagesHtml .="        </tr>\n";
                           $ErrorReturnCode=1;
                        }
                     }
                     if(empty($ErrorReturnCode)) {
                        if(file_exists($ObelixFileNameArray[7]) && is_readable($ObelixFileNameArray[7])) {
                           include($ObelixFileNameArray[7]);
                           if(!empty($HostName) &&
                              !empty($DbName) &&
                              !empty($DbUserName) &&
                              isset($DbPassword)) {
                              $HostName = base64_decode($HostName);
                              $DbName = base64_decode($DbName);
                              $DbUserName = base64_decode($DbUserName);
                              $DbPassword = base64_decode($DbPassword);
                              $DbAccessDataReturnCode=1;
                              $SqlDbConnection3Checked = " checked";
                              $SqlDbConnection5Checked='';
                           }
                           else
                           {
                              $MysqlCommandMessagesHtml .="        <tr>\n";
                              $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[2] . "</td>\n";
                              $MysqlCommandMessagesHtml .="        </tr>\n";
                           }
                        } elseif(file_exists($ObelixFileNameArray[7]) && !is_readable($ObelixFileNameArray[7])) {
                           $MysqlCommandMessagesHtml .="        <tr>\n";
                           $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[18] . "</td>\n";
                           $MysqlCommandMessagesHtml .="        </tr>\n";
                        }
                        else
                        {
                           $MysqlCommandMessagesHtml .="        <tr>\n";
                           $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[3] . "</td>\n";
                           $MysqlCommandMessagesHtml .="        </tr>\n";
                        }
                     }
                  }
               }
               else
               {
                  $MysqlCommandMessagesHtml .="        <tr>\n";
                  $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[7] . "</td>\n";
                  $MysqlCommandMessagesHtml .="        </tr>\n";
               }
            }
            else
            {
               $MysqlCommandMessagesHtml .="        <tr>\n";
               $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[0] . "</td>\n";
               $MysqlCommandMessagesHtml .="        </tr>\n";
            }
         }
         else
         {
            print "NOTE: SYSTEM-VARIABLE DATABASE CONNECTION (DB_CONNECTION) - function <strong>create_mysqli_command</strong> - IS DAMAGED!";
            exit;
         }
         if(empty($ErrorReturnCode) &&
            !empty($MysqlCommandArray[0]) &&
            !empty($MysqlCommandArray[6]) &&
            isset($MysqlCommandArray[7]) &&
            !empty($HostName) &&
            !empty($DbName) &&
            !empty($DbUserName) &&
            isset($DbPassword) &&
            !empty($Extension1) &&
            !empty($Extension2) &&
            !empty($DbAccessDataReturnCode) &&
            $DbAccessDataReturnCode == 1) {
            $MysqlCommandArray[7] = trim($MysqlCommandArray[7]);
            $SqlStringCmp1 = strcmp($Extension1, $MysqlCommandArray[0]);
            $SqlStringCmp2 = strcmp($Extension2, $MysqlCommandArray[0]);
            if($SqlStringCmp1 == 0) {
               // MySQLi
               if(extension_loaded($Extension1) && (!empty(@ini_get('mysqli.allow_local_infile')) || !empty(@ini_get('mysqli.allow_persistent')))) {
                  if($DbConnect = @mysqli_connect($HostName, $DbUserName, $DbPassword, $DbName)) {
                     if(preg_match("/^[1]$/", $MysqlCommandArray[6])) {
                        $RadioButtonShow1 = " checked";
                        $RadioButtonShow2='';
                        $RadioButtonShow3='';
                        if(!empty($MysqlCommandArray[7])) {
                           $SqlCommandArray=array();
                           $SqlTextareaCommandArray = explode(';', $MysqlCommandArray[7]);
                           $SqlTextareaCommandArrayCount = count($SqlTextareaCommandArray);
                           for($h=0; $h<$SqlTextareaCommandArrayCount; $h++) {
                              if(!empty($SqlTextareaCommandArray[$h])) {
                                 $SqlTextareaCommandArray[$h] = trim($SqlTextareaCommandArray[$h]);
                                 $SqlTextareaCommandArray[$h] = preg_replace('/\r\n|\r|\n/','', $SqlTextareaCommandArray[$h]);
                                 $SqlCommandArray[] = $SqlTextareaCommandArray[$h];
                              }
                           }
                           $SqlResultThreeArray=array();
                           $SqlCommandArrayCount = count($SqlCommandArray);
                           for($i=0; $i<$SqlCommandArrayCount; $i++) {
                              $CurrentSqlCommand = addcslashes($SqlCommandArray[$i], '.\+*?[^]$(){}=!<>|:-');
                              $CharReplaceOne = array("\"", "'", "\$", "<", ">");
                              $CharReplaceTwo = array( "&quot;", "&#39;", "&#36;", "&lt;", "&gt;");
                              $CharReplaceTwoCount = count($CharReplaceTwo);
                              if(preg_match("/^([a-zA-Z]{4,32})([ ]{1})(.{4,500})$/", $CurrentSqlCommand)) {
                                 if($CurrentResult = @mysqli_query($DbConnect, $SqlCommandArray[$i])) {
                                    if(preg_match("/^(SELECT|SHOW).*/i", $SqlCommandArray[$i])) {
                                       $SqlResultTwoArray=array();
                                       $SqlFieldNameArray=array();
                                       while($CurrentFieldInfo = @mysqli_fetch_field($CurrentResult)) {
                                          $SqlFieldNameArray[] = $CurrentFieldInfo -> name;
                                       }
                                       $SqlResultTwoArray[] = $SqlFieldNameArray;
                                       unset($SqlFieldNameArray);
                                       $CurrentResultFieldCount = @mysqli_num_fields($CurrentResult);
                                       while($DataRecordRow = @mysqli_fetch_row($CurrentResult)) {
                                          $SqlResultOneArray=array();
                                          for($k=0; $k<$CurrentResultFieldCount; $k++) {
                                             if((is_string($DataRecordRow[$k]) ||
                                                is_numeric($DataRecordRow[$k]) ||
                                                is_bool($DataRecordRow[$k])) &&
                                                preg_match('/^(.{65,})$/', $DataRecordRow[$k])) {
                                                preg_match('/^(.{0,64})(.*)$/', $DataRecordRow[$k], $TruncatedStringArray);
                                                $TruncatedCurrentFieldContent = $TruncatedStringArray[1] . "...";
                                                $SqlResultOneArray[] = $TruncatedCurrentFieldContent;
                                             } elseif((is_string($DataRecordRow[$k]) ||
                                                is_numeric($DataRecordRow[$k]) ||
                                                is_bool($DataRecordRow[$k])) &&
                                                preg_match('/^(.{0,64})$/', $DataRecordRow[$k])) {
                                                $SqlResultOneArray[] = $DataRecordRow[$k];
                                             }
                                             else
                                             {
                                             $SqlResultOneArray[] = $MysqlCommandMessagesArray[1];
                                             }
                                          }
                                          $SqlResultTwoArray[] = $SqlResultOneArray;
                                          unset($SqlResultOneArray);
                                       }
                                       @mysqli_free_result($CurrentResult);
                                       $SqlResultThreeArray[] = $SqlResultTwoArray;
                                       unset($SqlResultTwoArray);
                                       $SqlSelectReturnCode=1;
                                    }
                                 }
                                 else
                                 {
                                    for($g=0; $g<$CharReplaceTwoCount; $g++) {
                                       $SqlCommandArray[$i] = str_replace($CharReplaceOne[$g], $CharReplaceTwo[$g], $SqlCommandArray[$i]);
                                    }
                                    $MysqlCommandMessagesHtml .="        <tr>\n";
                                    $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[12] . " " . $SqlCommandArray[$i] . "</td>\n";
                                    $MysqlCommandMessagesHtml .="        </tr>\n";
                                    $NoSuccessfulReturnCode=1;
                                    break;
                                 }
                              }
                              else
                              {
                                 for($g=0; $g<$CharReplaceTwoCount; $g++) {
                                    $SqlCommandArray[$i] = str_replace($CharReplaceOne[$g], $CharReplaceTwo[$g], $SqlCommandArray[$i]);
                                 }
                                 $MysqlCommandMessagesHtml .="        <tr>\n";
                                 $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[13] . " " . $SqlCommandArray[$i] . "</td>\n";
                                 $MysqlCommandMessagesHtml .="        </tr>\n";
                                 $NoSuccessfulReturnCode=1;
                                 break;
                              }
                           }
                           if(empty($NoSuccessfulReturnCode)) {
                              if(!empty($SqlSelectReturnCode)) {
                                 $MysqlCommandOutputSector .= "        <tr>\n";
                                 $MysqlCommandOutputSector .= "          <td colspan=\"3\">\n";
                                 $MysqlCommandOutputSector .= "            <div id=\"#div_result\">\n";
                                 $MysqlCommandOutputSector .= "              <table>\n";
                                 $SqlResultThreeArrayCount1 = count($SqlResultThreeArray);
                                 for($x=0; $x<$SqlResultThreeArrayCount1; $x++) {
                                    $MysqlCommandOutputSector .= "                <tr>\n";
                                    $MysqlCommandOutputSector .= "                  <td>\n";
                                    $MysqlCommandOutputSector .= "                    <table class=\"table_result\">\n";
                                    $SqlResultThreeArrayCount2 = count($SqlResultThreeArray[$x]);
                                    for($y=0; $y<$SqlResultThreeArrayCount2; $y++) {
                                       $MysqlCommandOutputSector .= "                      <tr>\n";
                                       $SqlResultThreeArrayCount3 = count($SqlResultThreeArray[$x][$y]);
                                       for($z=0; $z<$SqlResultThreeArrayCount3; $z++) {
                                          if($y == 0) {
                                             if($z == 0) {
                                                $MysqlCommandOutputSector .= "                        <th class=\"title_column_1\">" . $SqlResultThreeArray[$x][$y][$z] . "</th>\n";
                                             }
                                             else
                                             {
                                             $MysqlCommandOutputSector .= "                        <th class=\"column_2_and_more\">" . $SqlResultThreeArray[$x][$y][$z] . "</th>\n";
                                             }
                                          } elseif($z == 0) {
                                             $DsNumber = $SqlResultThreeArray[$x][$y][$z];
                                             if($DsNumber < 10) {
                                                $DsStringNumber = "&nbsp;&nbsp;" . $DsNumber;
                                             } elseif($DsNumber < 100) {
                                                $DsStringNumber = "&nbsp;" . $DsNumber;
                                             }
                                             else
                                             {
                                             $DsStringNumber = $DsNumber;
                                             }
                                             $MysqlCommandOutputSector .= "                        <td class=\"data_field\">" . $DsStringNumber . "</td>\n";
                                          }
                                          else
                                          {
                                          $MysqlCommandOutputSector .= "                        <td class=\"data_field\">" . $SqlResultThreeArray[$x][$y][$z] . "</td>\n";
                                          }
                                       }
                                       $MysqlCommandOutputSector .= "                      </tr>\n";
                                    }
                                    if(isset($SqlResultThreeArrayCount2) && $SqlResultThreeArrayCount2 == 1) {
                                       $MysqlCommandOutputSector .= "                      <tr>\n";
                                       $MysqlCommandOutputSector .= "                        <td colspan=\"" . $SqlResultThreeArrayCount3 . "\" class=\"center\">" . $MysqlCommandMessagesArray[15] . "</td>\n";
                                       $MysqlCommandOutputSector .= "                      </tr>\n";
                                    }
                                    $MysqlCommandOutputSector .= "                    </table>\n";
                                    $MysqlCommandOutputSector .= "                  </td>\n";
                                    $MysqlCommandOutputSector .= "                </tr>\n";
                                    $MysqlCommandOutputSector .= "                <tr>\n";
                                    $MysqlCommandOutputSector .= "                  <td>&nbsp;</td>\n";
                                    $MysqlCommandOutputSector .= "                </tr>\n";
                                 }
                                 $MysqlCommandOutputSector .= "              </table>\n";
                                 $MysqlCommandOutputSector .= "            </div>\n";
                                 $MysqlCommandOutputSector .= "          </td>\n";
                                 $MysqlCommandOutputSector .= "        </tr>\n";
                              }
                              $MysqlCommandMessagesHtml .="        <tr>\n";
                              $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[14] . "</td>\n";
                              $MysqlCommandMessagesHtml .="        </tr>\n";
                           }
                        }
                     } elseif(preg_match("/^[2]$/", $MysqlCommandArray[6])) {
                        $RadioButtonShow1='';
                        $RadioButtonShow2 = " checked";
                        $RadioButtonShow3='';
                        $SqlDbTablesArray = array_column(@mysqli_fetch_all($DbConnect -> query('SHOW TABLES')),0);
                        $SqlDbTablesArrayCount = count($SqlDbTablesArray);
                        $SqlTableNamesArray=array();
                        $SqlTableNamesArrayCount = count($SqlTableNamesArray);
                        if(!empty($MysqlCommandArray[7])) {
                           $TableNamesSearch = preg_replace('/\r\n|\r|\n/',';', $MysqlCommandArray[7]);
                           $TableNamesSearchArray = explode(';', $TableNamesSearch);
                           $TableNamesSearchArrayCount = count($TableNamesSearchArray);
                           for($i=0; $i<$SqlDbTablesArrayCount; $i++) {
                              for($k=0; $k<$TableNamesSearchArrayCount; $k++) {
                                 $CurrentTableNameSearch = addcslashes($TableNamesSearchArray[$k], '.\+*?[^]$(){}=!<>|:-');
                                 if(!empty($TableNamesSearchArray[$k]) && preg_match("/" . $CurrentTableNameSearch . "/i", $SqlDbTablesArray[$i])) {
                                    $SqlTableNamesArray[] = $SqlDbTablesArray[$i];
                                    break;
                                 }
                              }
                           }
                        }
                        else
                        {
                        $SqlTableNamesArray = $SqlDbTablesArray;
                        }
                        $SqlTableNamesArrayCount = count($SqlTableNamesArray);
                        $MysqlCommandOutputSector .= "        <tr>\n";
                        $MysqlCommandOutputSector .= "          <td colspan=\"3\">\n";
                        $MysqlCommandOutputSector .= "            <div id=\"#div_result\">\n";
                        $MysqlCommandOutputSector .= "              <table class=\"table_result\">\n";
                        $MysqlCommandOutputSector .= "                <tr>\n";
                        $MysqlCommandOutputSector .= "                  <th colspan=\"4\" class=\"title_note_a\">" . $MysqlCommandMessagesArray[17] . "</th>\n";
                        $MysqlCommandOutputSector .= "                </tr>\n";
                        $MysqlCommandOutputSector .= "                <tr>\n";
                        $MysqlCommandOutputSector .= "                  <th class=\"title_field_1\">" . $MysqlCommandDetailsArray[29] . "</th>\n";
                        $MysqlCommandOutputSector .= "                  <th class=\"title_field_2\">" . $MysqlCommandDetailsArray[30] . "</th>\n";
                        $MysqlCommandOutputSector .= "                  <th class=\"title_field_3\">" . $MysqlCommandDetailsArray[31] . "</th>\n";
                        $MysqlCommandOutputSector .= "                  <th class=\"title_field_4\">" . $MysqlCommandDetailsArray[32] . "</th>\n";
                        $MysqlCommandOutputSector .= "                </tr>\n";
                        $DsNumber=0;
                        for($x=0; $x<$SqlTableNamesArrayCount; $x++) {
                           $DsNumber++;
                           if($DsNumber < 10) {
                             $DsStringNumber = "&nbsp;&nbsp;" . $DsNumber;
                           } elseif($DsNumber < 100) {
                              $DsStringNumber = "&nbsp;" . $DsNumber;
                           }
                           else
                           {
                           $DsStringNumber = $DsNumber;
                           }
                           $CurrentTableFieldCount = $SqlContentNoValue;
                           $CurrentTableRowsCount = $SqlContentNoValue;
                           $SqlCommand = "SELECT * FROM " . $SqlTableNamesArray[$x];
                           if($CurrentResult = @mysqli_query($DbConnect, $SqlCommand)) {
                              $CurrentTableFieldCount = @mysqli_num_fields($CurrentResult);
                              $CurrentTableRowsCount = @mysqli_num_rows($CurrentResult);
                              @mysqli_free_result($CurrentResult);
                              $SuccessfulReturnCode=1;
                           }
                           $MysqlCommandOutputSector .= "              <tr>\n";
                           $MysqlCommandOutputSector .= "                <td class=\"data_field_1\">" . $DsStringNumber . "</td>\n";
                           $MysqlCommandOutputSector .= "                <td class=\"data_field_2\">" . $SqlTableNamesArray[$x] . "</td>\n";
                           $MysqlCommandOutputSector .= "                <td class=\"data_field_3\">" . $CurrentTableFieldCount . "</td>\n";
                           $MysqlCommandOutputSector .= "                <td class=\"data_field_4\">" . $CurrentTableRowsCount . "</td>\n";
                           $MysqlCommandOutputSector .= "              </tr>\n";
                        }
                        if(isset($SqlTableNamesArrayCount) && $SqlTableNamesArrayCount == 0) {
                           $MysqlCommandOutputSector .= "             <tr>\n";
                           $MysqlCommandOutputSector .= "               <td colspan=\"4\">&nbsp;</td>\n";
                           $MysqlCommandOutputSector .= "             </tr>\n";
                           $MysqlCommandOutputSector .= "              <tr>\n";
                           $MysqlCommandOutputSector .= "                <td colspan=\"4\" class=\"center\">" . $MysqlCommandMessagesArray[16] . "</td>\n";
                           $MysqlCommandOutputSector .= "              </tr>\n";
                           $MysqlCommandOutputSector .= "              <tr>\n";
                           $MysqlCommandOutputSector .= "                <td colspan=\"4\">&nbsp;</td>\n";
                           $MysqlCommandOutputSector .= "              </tr>\n";
                        }
                        $MysqlCommandOutputSector .= "              </table>\n";
                        $MysqlCommandOutputSector .= "            </div>\n";
                        $MysqlCommandOutputSector .= "          </td>\n";
                        $MysqlCommandOutputSector .= "        </tr>\n";
                        if(!empty($SuccessfulReturnCode)) {
                           $MysqlCommandMessagesHtml .="        <tr>\n";
                           $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[14] . "</td>\n";
                           $MysqlCommandMessagesHtml .="        </tr>\n";
                        }
                     } elseif(preg_match("/^[3]$/", $MysqlCommandArray[6])) {
                        $RadioButtonShow1='';
                        $RadioButtonShow2='';
                        $RadioButtonShow3 = " checked";
                        $SqlDbTablesArray = array_column(@mysqli_fetch_all($DbConnect -> query('SHOW TABLES')),0);
                        $SqlDbTablesArrayCount = count($SqlDbTablesArray);
                        $SqlTableNamesArray=array();
                        $SqlTableNamesArrayCount = count($SqlTableNamesArray);
                        if(!empty($MysqlCommandArray[7])) {
                           $TableNamesSearch = preg_replace('/\r\n|\r|\n/',';', $MysqlCommandArray[7]);
                           $TableNamesSearchArray = explode(';', $TableNamesSearch);
                           $TableNamesSearchArrayCount = count($TableNamesSearchArray);
                           for($i=0; $i<$SqlDbTablesArrayCount; $i++) {
                              for($k=0; $k<$TableNamesSearchArrayCount; $k++) {
                                 $CurrentTableNameSearch = addcslashes($TableNamesSearchArray[$k], '.\+*?[^]$(){}=!<>|:-');
                                 if(!empty($TableNamesSearchArray[$k]) && preg_match("/" . $CurrentTableNameSearch . "/i", $SqlDbTablesArray[$i])) {
                                    $SqlTableNamesArray[] = $SqlDbTablesArray[$i];
                                    break;
                                 }
                              }
                           }
                        }
                        else
                        {
                        $SqlTableNamesArray = $SqlDbTablesArray;
                        }
                        $SqlTableNamesArrayCount = count($SqlTableNamesArray);
                        $TypesArray=array();
                        $GetConstants = get_defined_constants(true);
                        foreach($GetConstants['mysqli'] as $c => $n) if(preg_match('/^MYSQLI_TYPE_(.*)/', $c, $m)) $TypesArray[$n] = $m[1];
                        $TypesArrayCount = count($TypesArray);
                        if(!empty($SqlTableNamesArrayCount)) {
                           $TableNumber=1;
                           $MysqlCommandOutputSector .= "        <tr>\n";
                           $MysqlCommandOutputSector .= "          <td colspan=\"3\">\n";
                           $MysqlCommandOutputSector .= "            <div id=\"#div_result\">\n";
                           $MysqlCommandOutputSector .= "              <table>\n";
                           for($x=0; $x<$SqlTableNamesArrayCount; $x++) {
                              $SqlFieldNameArray=array($MysqlCommandDetailsArray[34]);
                              $SqlFieldLengthArray=array($MysqlCommandDetailsArray[35]);
                              $SqlFieldTypeNumberArray=array();
                              $SqlFieldTypeArray=array($MysqlCommandDetailsArray[36]);
                              $SqlDataRecordsContentArray=array();
                              $SqlCommand = "SELECT * FROM " . $SqlTableNamesArray[$x];
                              $SqlQueryNotSuccessfulMessage = $MysqlCommandMessagesArray[12] . " " . $SqlCommand;
                              $SqlResult = $DbConnect -> query($SqlCommand) or die($SqlQueryNotSuccessfulMessage);
                              $MysqlCommandOutputSector .= "                <tr>\n";
                              $MysqlCommandOutputSector .= "                  <td>" . $TableNumber . "</td>\n";
                              $MysqlCommandOutputSector .= "                  <td class=\"right\">" . $MysqlCommandDetailsArray[33] . "</td>\n";
                              $MysqlCommandOutputSector .= "                  <td>" . $SqlTableNamesArray[$x] . "</td>\n";
                              $MysqlCommandOutputSector .= "                </tr>\n";
                              $MysqlCommandOutputSector .= "                <tr>\n";
                              $MysqlCommandOutputSector .= "                  <td colspan=\"3\">\n";
                              while($FieldInfo = @mysqli_fetch_field($SqlResult)) {
                                 $SqlFieldNameArray[] = $FieldInfo -> name;
                                 $SqlFieldLengthArray[] = $FieldInfo -> length;
                                 $CurrentFieldType = $FieldInfo -> type;
                                 $SqlFieldTypeNumberArray[] = $CurrentFieldType;
                                 for($y=0; $y<$TypesArrayCount; $y++) {
                                    $TypesValue=0;
                                    $CurrentArrayKey = key($TypesArray);
                                    if($CurrentArrayKey == $CurrentFieldType) {
                                       $SqlFieldTypeArray[] = $TypesArray[$CurrentArrayKey];
                                       $TypesValue=1;
                                    }
                                    if(!empty($TypesValue)) break;
                                    next($TypesArray);
                                 }
                                 if(empty($TypesValue)) $SqlFieldTypeArray[] = $SqlContentNoValue;
                                 reset($TypesArray);
                              }
                              while($DataRecordsContent = @mysqli_fetch_row($SqlResult)) {
                                 $FieldCount = @mysqli_num_fields($SqlResult);
                                 $SqlFieldContentArray=array();
                                 $SqlFieldContentArray[] = '&nbsp;';
                                 for($y=0; $y<$FieldCount; $y++) {
                                    // Binaerdaten: Feld-Typ 249 - TINY_BLOB, Feld-Typ 250 - MEDIUM_BLOB, Feld-Typ 251 - LONG_BLOB, Feld-Typ 252 - BLOB
                                    if(preg_match("/^249|(25[0-2])$/", $SqlFieldTypeNumberArray[$y])) {
                                       if((is_string($DataRecordsContent[$y]) ||
                                          is_numeric($DataRecordsContent[$y]) ||
                                          is_bool($DataRecordsContent[$y])) &&
                                          preg_match('/^(.{65,})$/', $DataRecordsContent[$y])) {
                                          preg_match('/^(.{0,64})(.*)$/', $DataRecordsContent[$y], $TruncatedStringArray);
                                          $TruncatedCurrentFieldContent = $TruncatedStringArray[1] . "...";
                                          $SqlFieldContentArray[] = $TruncatedCurrentFieldContent;
                                       } elseif((is_string($DataRecordsContent[$y]) ||
                                          is_numeric($DataRecordsContent[$y]) ||
                                          is_bool($DataRecordsContent[$y])) &&
                                          preg_match('/^(.{0,64})$/', $DataRecordsContent[$y])) {
                                          $SqlFieldContentArray[] = $DataRecordsContent[$y];
                                       }
                                       else
                                       {
                                       $SqlFieldContentArray[] = $MysqlCommandMessagesArray[1];
                                       }
                                    } elseif(preg_match('/^(.{65,})$/', $DataRecordsContent[$y])) {
                                       preg_match('/^(.{0,64})(.*)$/', $DataRecordsContent[$y], $TruncatedStringArray);
                                       $TruncatedCurrentFieldContent = $TruncatedStringArray[1] . "...";
                                       $SqlFieldContentArray[] = $TruncatedCurrentFieldContent;
                                    }
                                    else
                                    {
                                    $SqlFieldContentArray[] = $DataRecordsContent[$y];
                                    }
                                 }
                                 $SqlDataRecordsContentArray[] = $SqlFieldContentArray;
                                 unset($SqlFieldContentArray);
                                 $SuccessfulReturnCode=1;
                              }
                              @mysqli_free_result($SqlResult);
                              $MysqlCommandOutputSector .= "                    <table class=\"table_result\">\n";
                              $MysqlCommandOutputSector .= "                      <tr>\n";
                              $SqlFieldNameArrayCount = count($SqlFieldNameArray);
                              for($y=0; $y<$SqlFieldNameArrayCount; $y++) {
                                 if(isset($SqlFieldNameArray[$y])) {
                                    if($y == 0) {
                                       $MysqlCommandOutputSector .= "                        <td class=\"title_column_1\">" .  $SqlFieldNameArray[$y] . "</td>\n";
                                    }
                                    else
                                    {
                                    $MysqlCommandOutputSector .= "                        <td class=\"column_2_and_more\">" .  $SqlFieldNameArray[$y] . "</td>\n";
                                    }
                                 }
                                 else
                                 {
                                 $MysqlCommandOutputSector .= "                        <td class=\"column_vo_value\">" .  $SqlContentNoValue . "</td>\n";
                                 }
                              }
                              $MysqlCommandOutputSector .= "                      </tr>\n";
                              $MysqlCommandOutputSector .= "                      <tr>\n";
                              for($y=0; $y<$SqlFieldNameArrayCount; $y++) {
                                 if(isset($SqlFieldLengthArray[$y])) {
                                    if($y == 0) {
                                       $MysqlCommandOutputSector .= "                        <td class=\"title_column_1\">" .  $SqlFieldLengthArray[$y] . "</td>\n";
                                    }
                                    else
                                    {
                                    $MysqlCommandOutputSector .= "                        <td class=\"column_2_and_more\">" .  $SqlFieldLengthArray[$y] . "</td>\n";
                                    }
                                 }
                                 else
                                 {
                                 $MysqlCommandOutputSector .= "                        <td class=\"column_vo_value\">" .  $SqlContentNoValue . "</td>\n";
                                 }
                              }
                              $MysqlCommandOutputSector .= "                      </tr>\n";
                              $MysqlCommandOutputSector .= "                      <tr>\n";
                              for($y=0; $y<$SqlFieldNameArrayCount; $y++) {
                                 if(isset($SqlFieldTypeArray[$y])) {
                                    if($y == 0) {
                                       $MysqlCommandOutputSector .= "                        <td class=\"title_column_1\">" .  $SqlFieldTypeArray[$y] . "</td>\n";
                                    }
                                    else
                                    {
                                    $MysqlCommandOutputSector .= "                        <td class=\"column_2_and_more\">" .  $SqlFieldTypeArray[$y] . "</td>\n";
                                    }
                                 }
                                 else
                                 {
                                 $MysqlCommandOutputSector .= "                        <td class=\"column_vo_value\">" .  $SqlContentNoValue . "</td>\n";
                                 }
                              }
                              $MysqlCommandOutputSector .= "                      </tr>\n";
                              $SqlDataRecordsContentArrayCount = count($SqlDataRecordsContentArray);
                              for($y=0; $y<$SqlDataRecordsContentArrayCount; $y++){
                                 $MysqlCommandOutputSector .= "                      <tr>\n";
                                 for($z=0; $z<$SqlFieldNameArrayCount; $z++){
                                    if(isset($SqlDataRecordsContentArray[$y])) {
                                       if($z == 0) {
                                          $MysqlCommandOutputSector .= "                        <td>" .  $SqlDataRecordsContentArray[$y][$z] . "</td>\n";
                                       }
                                       else
                                       {
                                       $MysqlCommandOutputSector .= "                        <td class=\"data_field\">" .  $SqlDataRecordsContentArray[$y][$z] . "</td>\n";
                                       }
                                    }
                                    else
                                    {
                                    $MysqlCommandOutputSector .= "                        <td class=\"column_vo_value\">" .  $SqlContentNoValue . "</td>\n";
                                    }
                                 }
                                 $MysqlCommandOutputSector .= "                      </tr>\n";
                              }
                              if(empty($SqlDataRecordsContentArrayCount)) {
                                 $MysqlCommandOutputSector .= "                      <tr>\n";
                                 $MysqlCommandOutputSector .= "                        <td colspan=\"" . $SqlFieldNameArrayCount . "\" class=\"center\">" . $MysqlCommandMessagesArray[15] . "</td>\n";
                                 $MysqlCommandOutputSector .= "                      </tr>\n";
                              }
                              $MysqlCommandOutputSector .= "                    </table>\n";
                              $MysqlCommandOutputSector .= "                  </td>\n";
                              $MysqlCommandOutputSector .= "                </tr>\n";
                              if($TableNumber < $SqlTableNamesArrayCount) {
                                 $MysqlCommandOutputSector .= "                <tr>\n";
                                 $MysqlCommandOutputSector .= "                  <td colspan=\"3\">&nbsp;</td>\n";
                                 $MysqlCommandOutputSector .= "                </tr>\n";
                              }
                              $TableNumber++;
                              unset($SqlFieldNameArray);
                              unset($SqlFieldLengthArray);
                              unset($SqlFieldTypeNumberArray);
                              unset($SqlFieldTypeArray);
                              unset($SqlDataRecordsContentArray);
                           }
                           $MysqlCommandOutputSector .= "              </table>\n";
                           $MysqlCommandOutputSector .= "            </div>\n";
                           $MysqlCommandOutputSector .= "          </td>\n";
                           $MysqlCommandOutputSector .= "        </tr>\n";
                        }
                        else
                        {
                           $MysqlCommandOutputSector .= "         <tr>\n";
                           $MysqlCommandOutputSector .= "           <td colspan=\"3\" class=\"center\">" . $MysqlCommandMessagesArray[16] . "</td>\n";
                           $MysqlCommandOutputSector .= "         </tr>\n";
                        }
                        if(!empty($SuccessfulReturnCode)) {
                           $MysqlCommandMessagesHtml .="        <tr>\n";
                           $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[14] . "</td>\n";
                           $MysqlCommandMessagesHtml .="        </tr>\n";
                        }
                     }
                     else
                     {
                        print "NOTE: SYSTEM-VARIABLE SQL-QUERY METHOD (SQL_SHOW) - function <strong>create_mysqli_command</strong> - IS DAMAGED!";
                        exit;
                     }
                     $SqlDatabaseNotClosedMessage = $MysqlCommandMessagesArray[9] . " " . $DbName;
                     @mysqli_close($DbConnect) or die($SqlDatabaseNotClosedMessage);
                  }
                  else
                  {
                     $MysqlCommandMessagesHtml .="        <tr>\n";
                     $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[8] . " " . $DbName . "</td>\n";
                     $MysqlCommandMessagesHtml .="        </tr>\n";
                  }
               }
               else
               {
                  $MysqlCommandMessagesHtml .="        <tr>\n";
                  $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[10] . "</td>\n";
                  $MysqlCommandMessagesHtml .="        </tr>\n";
               }
            } elseif($SqlStringCmp2 == 0) {
               // MySQL
               $SqlLanguage1Checked='';
               $SqlLanguage2Checked = " checked";
               if(extension_loaded($Extension2) && (!empty(@ini_get('mysql.allow_local_infile')) || !empty(@ini_get('mysql.allow_persistent')))) {
                  $DbConnect = @mysql_connect($HostName, $DbUserName, $DbPassword);
                  if(@mysql_select_db($DbName, $DbConnect)) {
                     if(preg_match("/^[1]$/", $MysqlCommandArray[6])) {
                        $RadioButtonShow1 = " checked";
                        $RadioButtonShow2='';
                        $RadioButtonShow3='';
                        if(!empty($MysqlCommandArray[7])) {
                           $SqlCommandArray=array();
                           $SqlTextareaCommandArray = explode(';', $MysqlCommandArray[7]);
                           $SqlTextareaCommandArrayCount = count($SqlTextareaCommandArray);
                           for($h=0; $h<$SqlTextareaCommandArrayCount; $h++) {
                              if(!empty($SqlTextareaCommandArray[$h])) {
                                 $SqlTextareaCommandArray[$h] = trim($SqlTextareaCommandArray[$h]);
                                 $SqlTextareaCommandArray[$h] = preg_replace('/\r\n|\r|\n/','', $SqlTextareaCommandArray[$h]);
                                 $SqlCommandArray[] = $SqlTextareaCommandArray[$h];
                              }
                           }
                           $SqlResultThreeArray=array();
                           $SqlCommandArrayCount = count($SqlCommandArray);
                           for($i=0; $i<$SqlCommandArrayCount; $i++) {
                              $CurrentSqlCommand = addcslashes($SqlCommandArray[$i], '.\+*?[^]$(){}=!<>|:-');
                              $CharReplaceOne = array("\"", "'", "\$", "<", ">");
                              $CharReplaceTwo = array( "&quot;", "&#39;", "&#36;", "&lt;", "&gt;");
                              $CharReplaceTwoCount = count($CharReplaceTwo);
                              if(preg_match("/^([a-zA-Z]{4,32})([ ]{1})(.{4,500})$/", $CurrentSqlCommand)) {
                                 if($CurrentResult = @mysql_db_query($DbName, $SqlCommandArray[$i])) {
                                    if(preg_match("/^(SELECT|SHOW).*/i", $SqlCommandArray[$i])) {
                                       $SqlResultTwoArray=array();
                                       $SqlFieldNameArray=array();
                                       while($CurrentFieldInfo = @mysql_fetch_field($CurrentResult)) {
                                          $SqlFieldNameArray[] = $CurrentFieldInfo -> name;
                                       }
                                       $SqlResultTwoArray[] = $SqlFieldNameArray;
                                       unset($SqlFieldNameArray);
                                       $CurrentResultFieldCount = @mysql_num_fields($CurrentResult);
                                       while($DataRecordRow = @mysql_fetch_row($CurrentResult)) {
                                          $SqlResultOneArray=array();
                                          for($k=0; $k<$CurrentResultFieldCount; $k++) {
                                             if((is_string($DataRecordRow[$k]) ||
                                                is_numeric($DataRecordRow[$k]) ||
                                                is_bool($DataRecordRow[$k])) &&
                                                preg_match('/^(.{65,})$/', $DataRecordRow[$k])) {
                                                preg_match('/^(.{0,64})(.*)$/', $DataRecordRow[$k], $TruncatedStringArray);
                                                $TruncatedCurrentFieldContent = $TruncatedStringArray[1] . "...";
                                                $SqlResultOneArray[] = $TruncatedCurrentFieldContent;
                                             } elseif((is_string($DataRecordRow[$k]) ||
                                                is_numeric($DataRecordRow[$k]) ||
                                                is_bool($DataRecordRow[$k])) &&
                                                preg_match('/^(.{0,64})$/', $DataRecordRow[$k])) {
                                                $SqlResultOneArray[] =$DataRecordRow[$k];
                                             }
                                             else
                                             {
                                             $SqlResultOneArray[] = $MysqliTablesMessagesArray[1];
                                             }
                                          }
                                          $SqlResultTwoArray[] = $SqlResultOneArray;
                                          unset($SqlResultOneArray);
                                       }
                                       @mysql_free_result($CurrentResult);
                                       $SqlResultThreeArray[] = $SqlResultTwoArray;
                                       unset($SqlResultTwoArray);
                                       $SqlSelectReturnCode=1;
                                    }
                                 }
                                 else
                                 {
                                    for($g=0; $g<$CharReplaceTwoCount; $g++) {
                                       $SqlCommandArray[$i] = str_replace($CharReplaceOne[$g], $CharReplaceTwo[$g], $SqlCommandArray[$i]);
                                    }
                                    $MysqlCommandMessagesHtml .="        <tr>\n";
                                    $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[12] . " " . $SqlCommandArray[$i] . "</td>\n";
                                    $MysqlCommandMessagesHtml .="        </tr>\n";
                                    $NoSuccessfulReturnCode=1;
                                    break;
                                 }
                              }
                              else
                              {
                                 for($g=0; $g<$CharReplaceTwoCount; $g++) {
                                    $SqlCommandArray[$i] = str_replace($CharReplaceOne[$g], $CharReplaceTwo[$g], $SqlCommandArray[$i]);
                                 }
                                 $MysqlCommandMessagesHtml .="        <tr>\n";
                                 $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[13] . " " . $SqlCommandArray[$i] . "</td>\n";
                                 $MysqlCommandMessagesHtml .="        </tr>\n";
                                 $NoSuccessfulReturnCode=1;
                                 break;
                              }
                           }
                           if(empty($NoSuccessfulReturnCode)) {
                              if(!empty($SqlSelectReturnCode)) {
                                 $MysqlCommandOutputSector .= "        <tr>\n";
                                 $MysqlCommandOutputSector .= "          <td colspan=\"3\">\n";
                                 $MysqlCommandOutputSector .= "            <div id=\"#div_result\">\n";
                                 $MysqlCommandOutputSector .= "              <table>\n";
                                 $SqlResultThreeArrayCount1 = count($SqlResultThreeArray);
                                 for($x=0; $x<$SqlResultThreeArrayCount1; $x++) {
                                    $MysqlCommandOutputSector .= "                <tr>\n";
                                    $MysqlCommandOutputSector .= "                  <td>\n";
                                    $MysqlCommandOutputSector .= "                    <table class=\"table_result\">\n";
                                    $SqlResultThreeArrayCount2 = count($SqlResultThreeArray[$x]);
                                    for($y=0; $y<$SqlResultThreeArrayCount2; $y++) {
                                       $MysqlCommandOutputSector .= "                      <tr>\n";
                                       $SqlResultThreeArrayCount3 = count($SqlResultThreeArray[$x][$y]);
                                       for($z=0; $z<$SqlResultThreeArrayCount3; $z++) {
                                          if($y == 0) {
                                             if($z == 0) {
                                                $MysqlCommandOutputSector .= "                        <th class=\"title_column_1\">" . $SqlResultThreeArray[$x][$y][$z] . "</th>\n";
                                             }
                                             else
                                             {
                                             $MysqlCommandOutputSector .= "                        <th class=\"column_2_and_more\">" . $SqlResultThreeArray[$x][$y][$z] . "</th>\n";
                                             }
                                          } elseif($z == 0) {
                                             $DsNumber = $SqlResultThreeArray[$x][$y][$z];
                                             if($DsNumber < 10) {
                                                $DsStringNumber = "&nbsp;&nbsp;" . $DsNumber;
                                             } elseif($DsNumber < 100) {
                                                $DsStringNumber = "&nbsp;" . $DsNumber;
                                             }
                                             else
                                             {
                                             $DsStringNumber = $DsNumber;
                                             }
                                             $MysqlCommandOutputSector .= "                        <td class=\"data_field\">" . $DsStringNumber . "</td>\n";
                                          }
                                          else
                                          {
                                          $MysqlCommandOutputSector .= "                        <td class=\"data_field\">" . $SqlResultThreeArray[$x][$y][$z] . "</td>\n";
                                          }
                                       }
                                       $MysqlCommandOutputSector .= "                      </tr>\n";
                                    }
                                    if(isset($SqlResultThreeArrayCount2) && $SqlResultThreeArrayCount2 == 1) {
                                       $MysqlCommandOutputSector .= "                      <tr>\n";
                                       $MysqlCommandOutputSector .= "                        <td colspan=\"" . $SqlResultThreeArrayCount3 . "\" class=\"center\">" . $MysqlCommandMessagesArray[15] . "</td>\n";
                                       $MysqlCommandOutputSector .= "                      </tr>\n";
                                    }
                                    $MysqlCommandOutputSector .= "                    </table>\n";
                                    $MysqlCommandOutputSector .= "                  </td>\n";
                                    $MysqlCommandOutputSector .= "                </tr>\n";
                                    $MysqlCommandOutputSector .= "                <tr>\n";
                                    $MysqlCommandOutputSector .= "                  <td>&nbsp;</td>\n";
                                    $MysqlCommandOutputSector .= "                </tr>\n";
                                 }
                                 $MysqlCommandOutputSector .= "             </table>\n";
                                 $MysqlCommandOutputSector .= "           </div>\n";
                                 $MysqlCommandOutputSector .= "         </td>\n";
                                 $MysqlCommandOutputSector .= "       </tr>\n";
                              }
                              $MysqlCommandMessagesHtml .="        <tr>\n";
                              $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[14] . "</td>\n";
                              $MysqlCommandMessagesHtml .="        </tr>\n";
                           }
                        }
                     } elseif(preg_match("/^[2]$/", $MysqlCommandArray[6])) {
                        $RadioButtonShow1='';
                        $RadioButtonShow2 = " checked";
                        $RadioButtonShow3='';
                        $SqlDbTablesArray = @mysql_list_tables($DbName, $DbConnect);
                        $SqlDbTablesArrayCount = @mysql_num_rows($SqlDbTablesArray);
                        $SqlTableNamesArray=array();
                        $SqlTableNamesArrayCount = count($SqlTableNamesArray);
                        if(!empty($MysqlCommandArray[7])) {
                           $TableNamesSearch = preg_replace('/\r\n|\r|\n/',';', $MysqlCommandArray[7]);
                           $TableNamesSearchArray = explode(';', $TableNamesSearch);
                           $TableNamesSearchArrayCount = count($TableNamesSearchArray);
                           for($i=0; $i<$SqlDbTablesArrayCount; $i++) {
                              $TableName = @mysql_tablename($SqlDbTablesArray, $i);
                              for($k=0; $k<$TableNamesSearchArrayCount; $k++) {
                                 $CurrentTableNameSearch = addcslashes($TableNamesSearchArray[$k], '.\+*?[^]$(){}=!<>|:-');
                                 if(!empty($TableNamesSearchArray[$k]) && preg_match("/" . $CurrentTableNameSearch . "/i", $TableName)) {
                                    $SqlTableNamesArray[] = $TableName;
                                    break;
                                 }
                              }
                           }
                        }
                        else
                        {
                           for($i=0; $i<$SqlDbTablesArrayCount; $i++){
                              $TableName = @mysql_tablename($SqlDbTablesArray, $i);
                              $SqlTableNamesArray[] = $TableName;
                           }
                        }
                        $SqlTableNamesArrayCount = count($SqlTableNamesArray);
                        $MysqlCommandOutputSector .= "        <tr>\n";
                        $MysqlCommandOutputSector .= "          <td colspan=\"3\">\n";
                        $MysqlCommandOutputSector .= "            <div id=\"#div_result\">\n";
                        $MysqlCommandOutputSector .= "              <table class=\"table_result\">\n";
                        $MysqlCommandOutputSector .= "                <tr>\n";
                        $MysqlCommandOutputSector .= "                  <th colspan=\"4\" class=\"title_note_a\">" . $MysqlCommandMessagesArray[17] . "</th>\n";
                        $MysqlCommandOutputSector .= "                </tr>\n";
                        $MysqlCommandOutputSector .= "                <tr>\n";
                        $MysqlCommandOutputSector .= "                  <th class=\"title_field_1\">" . $MysqlCommandDetailsArray[29] . "</th>\n";
                        $MysqlCommandOutputSector .= "                  <th class=\"title_field_2\">" . $MysqlCommandDetailsArray[30] . "</th>\n";
                        $MysqlCommandOutputSector .= "                  <th class=\"title_field_3\">" . $MysqlCommandDetailsArray[31] . "</th>\n";
                        $MysqlCommandOutputSector .= "                  <th class=\"title_field_4\">" . $MysqlCommandDetailsArray[32] . "</th>\n";
                        $MysqlCommandOutputSector .= "                </tr>\n";
                        $DsNumber=0;
                        for($x=0; $x<$SqlTableNamesArrayCount; $x++) {
                           $DsNumber++;
                           if($DsNumber < 10) {
                             $DsStringNumber = "&nbsp;&nbsp;" . $DsNumber;
                           } elseif($DsNumber < 100) {
                              $DsStringNumber = "&nbsp;" . $DsNumber;
                           }
                           else
                           {
                           $DsStringNumber = $DsNumber;
                           }
                           $CurrentTableFieldCount = $SqlContentNoValue;
                           $CurrentTableRowsCount = $SqlContentNoValue;
                           $SqlCommand = "SELECT * FROM " . $SqlTableNamesArray[$x];
                           if($CurrentResult = @mysql_db_query($DbName, $SqlCommand)) {
                              $CurrentTableFieldCount = @mysql_num_fields($CurrentResult);
                              $CurrentTableRowsCount = @mysql_num_rows($CurrentResult);
                              @mysql_free_result($CurrentResult);
                              $SuccessfulReturnCode=1;
                           }
                           $MysqlCommandOutputSector .= "              <tr>\n";
                           $MysqlCommandOutputSector .= "                <td class=\"data_field_1\">" . $DsStringNumber . "</td>\n";
                           $MysqlCommandOutputSector .= "                <td class=\"data_field_2\">" . $SqlTableNamesArray[$x] . "</td>\n";
                           $MysqlCommandOutputSector .= "                <td class=\"data_field_3\">" . $CurrentTableFieldCount . "</td>\n";
                           $MysqlCommandOutputSector .= "                <td class=\"data_field_4\">" . $CurrentTableRowsCount . "</td>\n";
                           $MysqlCommandOutputSector .= "              </tr>\n";
                        }
                        if(isset($SqlTableNamesArrayCount) && $SqlTableNamesArrayCount == 0) {
                           $MysqlCommandOutputSector .= "             <tr>\n";
                           $MysqlCommandOutputSector .= "               <td colspan=\"4\">&nbsp;</td>\n";
                           $MysqlCommandOutputSector .= "             </tr>\n";
                           $MysqlCommandOutputSector .= "             <tr>\n";
                           $MysqlCommandOutputSector .= "               <td colspan=\"4\" class=\"center\">" . $MysqlCommandMessagesArray[16] . "</td>\n";
                           $MysqlCommandOutputSector .= "             </tr>\n";
                           $MysqlCommandOutputSector .= "             <tr>\n";
                           $MysqlCommandOutputSector .= "               <td colspan=\"4\">&nbsp;</td>\n";
                           $MysqlCommandOutputSector .= "             </tr>\n";
                        }
                        $MysqlCommandOutputSector .= "             </table>\n";
                        $MysqlCommandOutputSector .= "           </div>\n";
                        $MysqlCommandOutputSector .= "         </td>\n";
                        $MysqlCommandOutputSector .= "       </tr>\n";
                        if(!empty($SuccessfulReturnCode)) {
                           $MysqlCommandMessagesHtml .="        <tr>\n";
                           $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[14] . "</td>\n";
                           $MysqlCommandMessagesHtml .="        </tr>\n";
                        }
                     } elseif(preg_match("/^[3]$/", $MysqlCommandArray[6])) {
                        $RadioButtonShow1='';
                        $RadioButtonShow2='';
                        $RadioButtonShow3 = " checked";
                        $SqlTableNamesArray=array();
                        $SqlDbTablesArray = @mysql_list_tables($DbName, $DbConnect);
                        $SqlDbTablesArrayCount = @mysql_num_rows($SqlDbTablesArray);
                        if(!empty($MysqlCommandArray[7])) {
                           $TableNamesSearch = preg_replace('/\r\n|\r|\n/',';', $MysqlCommandArray[7]);
                           $TableNamesSearchArray = explode(';', $TableNamesSearch);
                           $TableNamesSearchArrayCount = count($TableNamesSearchArray);
                           for($i=0; $i<$SqlDbTablesArrayCount; $i++) {
                              $TableNameCurrent = @mysql_tablename($SqlDbTablesArray, $i);
                              for($k=0; $k<$TableNamesSearchArrayCount; $k++) {
                                 $CurrentTableNameSearch = addcslashes($TableNamesSearchArray[$k], '.\+*?[^]$(){}=!<>|:-');
                                 if(!empty($TableNamesSearchArray[$k]) && preg_match("/" . $CurrentTableNameSearch . "/i", $TableNameCurrent)) {
                                    $SqlTableNamesArray[] = $TableNameCurrent;
                                    break;
                                 }
                              }
                           }
                        }
                        else
                        {
                           for($i=0; $i<$SqlDbTablesArrayCount; $i++) {
                              $TableNameCurrent = @mysql_tablename($SqlDbTablesArray, $i);
                              $SqlTableNamesArray[] = $TableNameCurrent;
                           }
                        }
                        $SqlTableNamesArrayCount = count($SqlTableNamesArray);
                        if(!empty($SqlTableNamesArrayCount)) {
                           $TableNumber=1;
                           $MysqlCommandOutputSector .= "            <tr>\n";
                           $MysqlCommandOutputSector .= "              <td colspan=\"3\">\n";
                           $MysqlCommandOutputSector .= "                <div id=\"#div_result\">\n";
                           $MysqlCommandOutputSector .= "                  <table>\n";
                           for($x=0; $x<$SqlTableNamesArrayCount; $x++) {
                              $SqlFieldNameArray=array($MysqlCommandDetailsArray[34]);
                              $SqlFieldLengthArray=array($MysqlCommandDetailsArray[35]);
                              $SqlFieldTypeArray=array($MysqlCommandDetailsArray[36]);
                              $SqlDataRecordsContentArray=array();
                              $SqlCommand = "SELECT * FROM " . $SqlTableNamesArray[$x];
                              $SqlQueryNotSuccessfulMessage = $MysqlCommandMessagesArray[12] . " " . $SqlCommand;
                              $SqlResult = @mysql_db_query($DbName, $SqlCommand) or die($SqlQueryNotSuccessfulMessage);
                              $MysqlCommandOutputSector .= "                    <tr>\n";
                              $MysqlCommandOutputSector .= "                      <td>" . $TableNumber . "</td>\n";
                              $MysqlCommandOutputSector .= "                      <td class=\"right\">" . $MysqlCommandDetailsArray[33] . "</td>\n";
                              $MysqlCommandOutputSector .= "                      <td>" . $SqlTableNamesArray[$x] . "</td>\n";
                              $MysqlCommandOutputSector .= "                    </tr>\n";
                              $MysqlCommandOutputSector .= "                    <tr>\n";
                              $MysqlCommandOutputSector .= "                      <td colspan=\"3\">\n";
                              $FieldCount = @mysql_num_fields($SqlResult);
                              for($y=0; $y<$FieldCount; $y++) {
                                 $SqlFieldNameArray[] = @mysql_field_name($SqlResult, $y);
                                 $SqlFieldLengthArray[] = @mysql_field_len($SqlResult, $y);
                                 $SqlFieldTypeArray[] = @mysql_field_type($SqlResult, $y);
                              }
                              while($DataRecordsContent = @mysql_fetch_row($SqlResult)) {
                                 $SqlFieldContentArray=array();
                                 $SqlFieldContentArray[] = '&nbsp;';
                                 for($y=0; $y<$FieldCount; $y++){
                                    if((is_string($DataRecordsContent[$y]) ||
                                       is_numeric($DataRecordsContent[$y]) ||
                                       is_bool($DataRecordsContent[$y])) &&
                                       preg_match('/^(.{65,})$/', $DataRecordsContent[$y])) {
                                       preg_match('/^(.{0,64})(.*)$/', $DataRecordsContent[$y], $TruncatedStringArray);
                                       $TruncatedCurrentFieldContent = $TruncatedStringArray[1] . "...";
                                       $SqlFieldContentArray[] = $TruncatedCurrentFieldContent;
                                    } elseif((is_string($DataRecordsContent[$y]) ||
                                       is_numeric($DataRecordsContent[$y]) ||
                                       is_bool($DataRecordsContent[$y])) &&
                                       preg_match('/^(.{0,64})$/', $DataRecordsContent[$y])) {
                                       $SqlFieldContentArray[] = $DataRecordsContent[$y];
                                    }
                                    else
                                    {
                                    $SqlFieldContentArray[] = $MysqlCommandMessagesArray[1];
                                    }
                                 }
                                 $SqlDataRecordsContentArray[] = $SqlFieldContentArray;
                                 unset($SqlFieldContentArray);
                                 $SuccessfulReturnCode=1;
                              }
                              @mysql_free_result($SqlResult);
                              $MysqlCommandOutputSector .= "                        <table class=\"table_result\">\n";
                              $MysqlCommandOutputSector .= "                          <tr>\n";
                              $SqlFieldNameArrayCount = count($SqlFieldNameArray);
                              for($y=0; $y<$SqlFieldNameArrayCount; $y++) {
                                 if(isset($SqlFieldNameArray[$y])) {
                                    if($y == 0) {
                                       $MysqlCommandOutputSector .= "                            <td class=\"title_column_1\">" .  $SqlFieldNameArray[$y] . "</td>\n";
                                    }
                                    else
                                    {
                                    $MysqlCommandOutputSector .= "                            <td class=\"column_2_and_more\">" .  $SqlFieldNameArray[$y] . "</td>\n";
                                    }
                                 }
                                 else
                                 {
                                 $MysqlCommandOutputSector .= "                            <td class=\"column_vo_value\">" .  $SqlContentNoValue . "</td>\n";
                                 }
                              }
                              $MysqlCommandOutputSector .= "                          </tr>\n";
                              $MysqlCommandOutputSector .= "                          <tr>\n";
                              for($y=0; $y<$SqlFieldNameArrayCount; $y++) {
                                 if(isset($SqlFieldLengthArray[$y])) {
                                    if($y == 0) {
                                       $MysqlCommandOutputSector .= "                            <td class=\"title_column_1\">" .  $SqlFieldLengthArray[$y] . "</td>\n";
                                    }
                                    else
                                    {
                                    $MysqlCommandOutputSector .= "                            <td class=\"column_2_and_more\">" .  $SqlFieldLengthArray[$y] . "</td>\n";
                                    }
                                 }
                                 else
                                 {
                                 $MysqlCommandOutputSector .= "                            <td class=\"column_vo_value\">" .  $SqlContentNoValue . "</td>\n";
                                 }
                              }
                              $MysqlCommandOutputSector .= "                          </tr>\n";
                              $MysqlCommandOutputSector .= "                          <tr>\n";
                              for($y=0; $y<$SqlFieldNameArrayCount; $y++) {
                                 if(isset($SqlFieldTypeArray[$y])) {
                                    if($y == 0) {
                                       $MysqlCommandOutputSector .= "                            <td class=\"title_column_1\">" .  $SqlFieldTypeArray[$y] . "</td>\n";
                                    }
                                    else
                                    {
                                    $MysqlCommandOutputSector .= "                            <td class=\"column_2_and_more\">" .  $SqlFieldTypeArray[$y] . "</td>\n";
                                    }
                                 }
                                 else
                                 {
                                 $MysqlCommandOutputSector .= "                            <td class=\"column_vo_value\">" .  $SqlContentNoValue . "</td>\n";
                                 }
                              }
                              $MysqlCommandOutputSector .= "                          </tr>\n";
                              $SqlDataRecordsContentArrayCount = count($SqlDataRecordsContentArray);
                              for($y=0; $y<$SqlDataRecordsContentArrayCount; $y++){
                                 $MysqlCommandOutputSector .= "                          <tr>\n";
                                 for($z=0; $z<$SqlFieldNameArrayCount; $z++){
                                    if(isset($SqlDataRecordsContentArray[$y])) {
                                       if($z == 0) {
                                          $MysqlCommandOutputSector .= "                            <td>" .  $SqlDataRecordsContentArray[$y][$z] . "</td>\n";
                                       }
                                       else
                                       {
                                       $MysqlCommandOutputSector .= "                            <td class=\"data_field\">" .  $SqlDataRecordsContentArray[$y][$z] . "</td>\n";
                                       }
                                     }
                                    else
                                    {
                                    $MysqlCommandOutputSector .= "                            <td class=\"column_vo_value\">" .  $SqlContentNoValue . "</td>\n";
                                    }
                                 }
                                 $MysqlCommandOutputSector .= "                          </tr>\n";
                              }
                              if(empty($SqlDataRecordsContentArrayCount)) {
                                 $MysqlCommandOutputSector .= "                          <tr>\n";
                                 $MysqlCommandOutputSector .= "                            <td colspan=\"" . $SqlFieldNameArrayCount . "\" class=\"center\">" . $MysqlCommandMessagesArray[15] . "</td>\n";
                                 $MysqlCommandOutputSector .= "                          </tr>\n";
                              }
                              $MysqlCommandOutputSector .= "                        </table>\n";
                              $MysqlCommandOutputSector .= "                      </td>\n";
                              $MysqlCommandOutputSector .= "                    </tr>\n";
                              if($TableNumber < $SqlTableNamesArrayCount) {
                                 $MysqlCommandOutputSector .= "                 <tr>\n";
                                 $MysqlCommandOutputSector .= "                   <td colspan=\"3\">&nbsp;</td>\n";
                                 $MysqlCommandOutputSector .= "                 </tr>\n";
                              }
                              $TableNumber++;
                              unset($SqlFieldNameArray);
                              unset($SqlFieldLengthArray);
                              unset($SqlFieldTypeArray);
                              unset($SqlDataRecordsContentArray);
                           }
                           $MysqlCommandOutputSector .= "              </table>\n";
                           $MysqlCommandOutputSector .= "            </div>\n";
                           $MysqlCommandOutputSector .= "          </td>\n";
                           $MysqlCommandOutputSector .= "        </tr>\n";
                        }
                        else
                        {
                           $MysqlCommandOutputSector .= "        <tr>\n";
                           $MysqlCommandOutputSector .= "          <td colspan=\"3\" class=\"center\">" . $MysqlCommandMessagesArray[16] . "</td>\n";
                           $MysqlCommandOutputSector .= "        </tr>\n";
                        }
                        if(!empty($SuccessfulReturnCode)) {
                           $MysqlCommandMessagesHtml .="        <tr>\n";
                           $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[14] . "</td>\n";
                           $MysqlCommandMessagesHtml .="        </tr>\n";
                        }
                     }
                     else
                     {
                        print "NOTE: SYSTEM-VARIABLE SQL-QUERY METHOD (SQL_SHOW) - function <strong>create_mysqli_command</strong> - IS DAMAGED!";
                        exit;
                     }
                     $SqlDatabaseNotClosedMessage = $MysqlCommandMessagesArray[9] . " " . $DbName;
                     @mysql_close($DbConnect) or die($SqlDatabaseNotClosedMessage);
                  }
                  else
                  {
                     $MysqlCommandMessagesHtml .="        <tr>\n";
                     $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[8] . " " . $DbName . "</td>\n";
                     $MysqlCommandMessagesHtml .="        </tr>\n";
                  }
               }
               else
               {
                  $MysqlCommandMessagesHtml .="        <tr>\n";
                  $MysqlCommandMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $MysqlCommandMessagesArray[11] . "</td>\n";
                  $MysqlCommandMessagesHtml .="        </tr>\n";
               }
            }
            else
            {
               print "NOTE: SYSTEM-VARIABLE SQL-LANGUAGE-SPECIFICATION (SQL_DB_TYPE) - function <strong>create_mysqli_command</strong> - IS DAMAGED!";
               exit;
            }
         }
      }
      if(!empty($MysqlCommandMessagesHtml)) {
         $MysqlCommandMessagesHtml .="        <tr>\n";
         $MysqlCommandMessagesHtml .="          <td colspan=\"3\"><hr></td>\n";
         $MysqlCommandMessagesHtml .="        </tr>\n";
      }
      if(!empty($MysqlCommandOutputSector)) {
         $MysqlCommandOutputSector .= "        <tr>\n";
         $MysqlCommandOutputSector .= "          <td colspan=\"3\">&nbsp;</td>\n";
         $MysqlCommandOutputSector .= "        </tr>\n";
         $MysqlCommandOutputSector .= "        <tr>\n";
         $MysqlCommandOutputSector .= "          <td colspan=\"3\"><hr></td>\n";
         $MysqlCommandOutputSector .= "        </tr>\n";
      }
   } elseif(!isset($ObelixFileNameArray) ||
      !is_array($ObelixFileNameArray) ||
      $ObelixFileNameArrayDefaultCount != $ObelixFileNameArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY ObelixFileNameArray (ARRAY-COUNT) - function <strong>create_mysqli_command</strong> - IS DAMAGED!';
      exit;
   } elseif(!isset($MysqlCommandArray) ||
      !is_array($MysqlCommandArray) ||
      $MysqlCommandArrayDefaultCount != $MysqlCommandArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY MysqlCommandArray (ARRAY-COUNT) - function <strong>create_mysqli_command</strong> - IS DAMAGED!';
      exit;
   } elseif(!isset($MysqlCommandDetailsArray) ||
      !is_array($MysqlCommandDetailsArray) ||
      $MysqlCommandDetailsArrayDefaultCount != $MysqlCommandDetailsArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY MysqlCommandDetailsArray (ARRAY-COUNT) - function <strong>create_mysqli_command</strong> - IS DAMAGED!';
      exit;
   }
   else
   {
      print 'NOTE: SYSTEM-ARRAY MysqlCommandMessagesArray (ARRAY-COUNT) - function <strong>create_mysqli_command</strong> - IS DAMAGED!';
      exit;
   }
   $MainContent="    <form name=\"form_mysqli_command\" method=\"post\" action=\"" . $ObelixFileNameArray[4] . "?OBELIX_ID=" . $MysqlCommandDetailsArray[0] . "&ACCESS_ID=" . $MysqlCommandDetailsArray[1] . "\" target=\"_self\">\n";
   $MainContent .="      <table class=\"table_main\">\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\" class=\"center\"><h3>" . $MysqlCommandDetailsArray[2] . "</h3></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">" . $MysqlCommandDetailsArray[3] . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\"><hr></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .= $MysqlCommandMessagesHtml;
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"input_title\">" . $MysqlCommandDetailsArray[4] . " </td>\n";
   $MainContent .="          <td><input type=\"radio\" name=\"SQL_DB_TYPE\" value=\"mysqli\"" . $SqlLanguage1Checked . "></td>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"input_title\">" . $MysqlCommandDetailsArray[5] . " </td>\n";
   $MainContent .="          <td><input type=\"radio\" name=\"SQL_DB_TYPE\" value=\"mysql\"" . $SqlLanguage2Checked . "></td>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"input_title\">" . $MysqlCommandDetailsArray[6] . " </td>\n";
   $MainContent .="          <td><input type=\"text\" name=\"HOST_NAME\" size=\"16\" maxlength=\"128\" value=\"" . $HostName . "\"></td>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"input_title\">" . $MysqlCommandDetailsArray[7] . " </td>\n";
   $MainContent .="          <td><input type=\"text\" name=\"DB_NAME\" size=\"16\" maxlength=\"128\" value=\"" . $DbName . "\"></td>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"input_title\">" . $MysqlCommandDetailsArray[8] . " </td>\n";
   $MainContent .="          <td><input type=\"text\" name=\"DB_USER_NAME\" size=\"16\" maxlength=\"128\" value=\"" . $DbUserName . "\"></td>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"input_title\">" . $MysqlCommandDetailsArray[9] . " </td>\n";
   $MainContent .="          <td><input type=\"password\" name=\"DB_PASSWORD\" size=\"16\" maxlength=\"128\" value=\"" . $DbPassword . "\"></td>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"note_bold\">" . $MysqlCommandDetailsArray[10] . " </td>\n";
   $MainContent .="          <td>" . $MysqlCommandDetailsArray[11] . "</td>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"right\"><input type=\"radio\" name=\"DB_CONNECTION\" value=\"1\"" . $SqlDbConnection1Checked . "></td>\n";
   $MainContent .="          <td>" . $MysqlCommandDetailsArray[12] . "</td>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"right\"><input type=\"radio\" name=\"DB_CONNECTION\" value=\"2\"" . $SqlDbConnection2Checked . "></td>\n";
   $MainContent .="          <td>" . $MysqlCommandDetailsArray[13] . "</td>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"right\"><input type=\"radio\" name=\"DB_CONNECTION\" value=\"3\"" . $SqlDbConnection3Checked . "></td>\n";
   $MainContent .="          <td>" . $MysqlCommandDetailsArray[14] . "</td>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"right\"><input type=\"radio\" name=\"DB_CONNECTION\" value=\"4\"" . $SqlDbConnection4Checked . "></td>\n";
   $MainContent .="          <td>" . $MysqlCommandDetailsArray[15] . "</td>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"right\"><input type=\"radio\" name=\"DB_CONNECTION\" value=\"5\"" . $SqlDbConnection5Checked . "></td>\n";
   $MainContent .="          <td>" . $MysqlCommandDetailsArray[16] . "</td>\n";
   $MainContent .="          <td>&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\"><hr></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .= "       <tr>\n";
   $MainContent .= "         <td colspan=\"3\">\n";
   $MainContent .= "           <table>\n";
   $MainContent .= "             <tr>\n";
   $MainContent .= "               <td class=\"info_1\">" . $MysqlCommandDetailsArray[18] . "</td>\n";
   $MainContent .= "               <td class=\"info_2\">" . $MysqlCommandDetailsArray[19] . "</td>\n";
   $MainContent .= "               <td class=\"info_3\">" . $MysqlCommandDetailsArray[20] . "</td>\n";
   $MainContent .= "             </tr>\n";
   $MainContent .="              <tr>\n";
   $MainContent .="                <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="              </tr>\n";
   $MainContent .= "             <tr>\n";
   $MainContent .="                <td colspan=\"3\">" . $MysqlCommandDetailsArray[21] . "</td>\n";
   $MainContent .= "             </tr>\n";
   $MainContent .="              <tr>\n";
   $MainContent .="                <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="              </tr>\n";
   $MainContent .= "             <tr>\n";
   $MainContent .= "               <td><strong>" . $MysqlCommandDetailsArray[25] . "</strong><input type=\"radio\" name=\"SQL_SHOW\" value=\"1\"" . $RadioButtonShow1 . "></td>\n";
   $MainContent .= "               <td><strong>" . $MysqlCommandDetailsArray[26] . "</strong><input type=\"radio\" name=\"SQL_SHOW\" value=\"2\"" . $RadioButtonShow2 . "></td>\n";
   $MainContent .= "               <td><strong>" . $MysqlCommandDetailsArray[27] . "</strong><input type=\"radio\" name=\"SQL_SHOW\" value=\"3\"" . $RadioButtonShow3 . "></td>\n";
   $MainContent .= "             </tr>\n";
   $MainContent .="              <tr>\n";
   $MainContent .="                <td colspan=\"3\"><hr></td>\n";
   $MainContent .="              </tr>\n";
   $MainContent .="              <tr>\n";
   $MainContent .="                <td colspan=\"3\">" . $MysqlCommandDetailsArray[17] . "</td>\n";
   $MainContent .="              </tr>\n";
   $MainContent .="              <tr>\n";
   $MainContent .="                <td colspan=\"2\"><textarea cols=\"100\" rows=\"20\" name=\"SQL_TEXTAREA_COMMAND\">" . $MysqlCommandArray[7] . "</textarea></td>\n";
   $MainContent .="                <td class=\"info_4\">" . $MysqlCommandDetailsArray[22] . "</td>\n";
   $MainContent .="              </tr>\n";
   $MainContent .="              <tr>\n";
   $MainContent .="                <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="              </tr>\n";
   $MainContent .="              <tr>\n";
   $MainContent .="                <td colspan=\"2\" class=\"info_4\">" . $MysqlCommandDetailsArray[23] . "</td>\n";
   $MainContent .="                <td class=\"info_4\">" . $MysqlCommandDetailsArray[24] . "</td>\n";
   $MainContent .="              </tr>\n";
   $MainContent .= "           </table>\n";
   $MainContent .= "         </td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\"><hr></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .= $MysqlCommandOutputSector;
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\" class=\"center\"><input type=\"submit\" name=\"SQL_COMMAND_SUBMIT\" value=\"" . $MysqlCommandDetailsArray[28] . "\"></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="      </table>\n";
   $MainContent .="    </form>\n";
   return $MainContent;
}

// CSS - Navigation: MySQLi-COMMAND
function create_mysqli_command_css() {
   $MysqlCommandCSS="h3 {\n  font-size: 1.15em;\n  font-weight: bold;\n  text-align: center;\n}\n\n";
   $MysqlCommandCSS .=".table_main { width: 100%; }\n\n";
   $MysqlCommandCSS .="td { font-size: 0.9em; }\n\n";
   $MysqlCommandCSS .="hr { width: 100%; }\n\n";
   $MysqlCommandCSS .="input { font-size: 0.85em; }\n\n";
   $MysqlCommandCSS .="textarea {\n  resize: none;\n  overflow:auto;\n}\n\n";
   $MysqlCommandCSS .="#div_result {\n  overflow: auto;\n  margin: 3px 3px 3px 3px;\n  padding: 8px 8px 8px 8px;\n  width: 1100px;\n  max-height: 1200px;\n  float: right;\n}\n\n";
   $MysqlCommandCSS .=".table_result {\n  border-collapse: collapse;\n  border: 1px solid gray;\n}\n\n";
   $MysqlCommandCSS .=".title_note_a {\n  padding: 8px 4px 8px 4px;\n  text-align: center;\n  background-color: #F9F4F0;\n}\n\n";
   $MysqlCommandCSS .=".title_field_1 {\n  padding: 2px 4px 2px 4px;\n  width: 80px;\n  border-right: 1px solid gray;\n  border-top: 1px solid gray;\n  border-bottom: 1px solid gray;\n  background-color: #D6B194;\n}\n\n";
   $MysqlCommandCSS .=".title_field_2 {\n  padding: 2px 4px 2px 4px;\n  border-right: 1px solid gray;\n  border-top: 1px solid gray;\n  border-bottom: 1px solid gray;\n  background-color: #D6B194;\n}\n\n";
   $MysqlCommandCSS .=".title_field_3 {\n  padding: 2px 4px 2px 4px;\n  width: 150px;\n  border-right: 1px solid gray;\n  border-top: 1px solid gray;\n  border-bottom: 1px solid gray;\n  background-color: #D6B194;\n}\n\n";
   $MysqlCommandCSS .=".title_field_4 {\n  padding: 2px 4px 2px 4px;\n  width: 120px;\n  border-right: 1px solid gray;\n  border-top: 1px solid gray;\n  border-bottom: 1px solid gray;\n  background-color: #D6B194;\n}\n\n";
   $MysqlCommandCSS .=".data_field_1 {\n  padding: 2px 4px 2px 4px;\n  text-align: right;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n}\n\n";
   $MysqlCommandCSS .=".data_field_2 {\n  padding: 2px 4px 2px 4px;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n}\n\n";
   $MysqlCommandCSS .=".data_field_3 {\n  padding: 2px 4px 2px 4px;\n  text-align: center;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n}\n\n";
   $MysqlCommandCSS .=".data_field_4 {\n  padding: 2px 4px 2px 4px;\n  text-align: center;\n  border-right: 1px solid gray;\n  border-bottom: 1px solid gray;\n}\n\n";
   $MysqlCommandCSS .=".title_column_1 {\n  padding: 2px 4px 2px 4px;\n  font-weight: bold;\n  border-right: 1px solid gray;\n  border-top: 1px solid gray;\n  border-bottom: 1px solid gray;\n  background-color: #DDDBA6;\n}\n\n";
   $MysqlCommandCSS .=".column_2_and_more {\n  padding: 2px 4px 2px 4px;\n  border-right: 1px solid gray;\n  border-top: 1px solid gray;\n  border-bottom: 1px solid gray;\n  background-color: #DDDBA6;\n}\n\n";
   $MysqlCommandCSS .=".column_vo_value {\n  padding: 2px 4px 2px 4px;\n  text-align: center;\n  border-right: 1px solid gray;\n  border-top: 1px solid gray;\n  border-bottom: 1px solid gray;\n  background-color: #DDDBA6;\n}\n\n";
   $MysqlCommandCSS .=".data_field {\n  padding: 2px 4px 2px 4px;\n  border-left: 1px solid gray;\n  border-bottom: 1px solid gray;\n}\n\n";
   $MysqlCommandCSS .=".info_1 {\n  width: 38%;\n  vertical-align: top;\n}\n\n";
   $MysqlCommandCSS .=".info_2 {\n  width: 30%;\n  vertical-align: top;\n}\n\n";
   $MysqlCommandCSS .=".info_3 {\n  width: 32%;\n  vertical-align: top;\n}\n\n";
   $MysqlCommandCSS .=".info_4 { vertical-align: top; }\n\n";
   $MysqlCommandCSS .=".input_title {\n  font-size: 0.95em;\n  text-align: right;\n  font-weight: bold;\n}\n\n";
   $MysqlCommandCSS .=".note_bold {\n  font-size: 0.95em;\n  text-align: right;\n  font-weight: bold;\n}\n\n";
   $MysqlCommandCSS .=".red {\n  font-size: 0.95em;\n  font-weight: bold;\n  text-align: center;\n  color:#DD0000;\n}\n\n";
   $MysqlCommandCSS .=".right { text-align: right; }\n\n";
   return $MysqlCommandCSS;
}

// Verzeichnis fuer die Thumbnail-Bilder erstellen
function create_thumbnail_directory($CreateThumbnailDirectoryArray='', $ImageEditingDirectoryAccess='') {
   $ReturnCode=0;
   $CreateThumbnailDirectoryArrayDefaultCount=1; // Vorgabe: Anzahl der Array-Elemente
   $CreateThumbnailDirectoryArrayCurrentCount=count($CreateThumbnailDirectoryArray);
   if(isset($CreateThumbnailDirectoryArray) &&
      is_array($CreateThumbnailDirectoryArray) &&
      $CreateThumbnailDirectoryArrayDefaultCount == $CreateThumbnailDirectoryArrayCurrentCount) {
      if(!empty($CreateThumbnailDirectoryArray[0]) &&
        is_dir($CreateThumbnailDirectoryArray[0]) &&
        is_writeable($CreateThumbnailDirectoryArray[0])) {
        $ReturnCode=1;
      } elseif(!empty($CreateThumbnailDirectoryArray[0]) && !is_dir($CreateThumbnailDirectoryArray[0])) {
         if(@mkdir($CreateThumbnailDirectoryArray[0], $ImageEditingDirectoryAccess)) $ReturnCode=1;
      } elseif(!empty($CreateThumbnailDirectoryArray[0]) &&
         is_dir($CreateThumbnailDirectoryArray[0]) &&
         !is_writeable($CreateThumbnailDirectoryArray[0])) {
         $ReturnCode=2;
      }
      else
      {
         print 'NOTE: UNKNOWN FAULT OR FUNKTION ARE DAMAGED - function <strong>create_thumbnail_directory</strong>!';
         exit;
      }
   }
   else
   {
      print 'NOTE: SYSTEM-ARRAY CreateThumbnailDirectoryArray (ARRAY-COUNT) - function <strong>create_thumbnail_directory</strong> - IS DAMAGED!';
      exit;
   }
   unset($CreateThumbnailDirectoryArray);
   return $ReturnCode;
}

// Verzeichnisse und Bilddateien des aktuellen Arbeitsverzeichnisses ermitteln
function create_work_directory_file_list($DirectoryFileListWorkArray='') {
   $ReturnCode=0;
   $SubsumedDirectoryFileListArray=array();
   $ImageEditingDirectoryEditorArray=array();
   $ImageEditingFileEditorArray=array();
   $ImageEditingDirectoryArray=array();
   $ImageEditingFileArray=array();
   $ImageEditingTermArray=array('(/){2,}', '(\.){3,}', '(/\./)', '^(\./){2,}');
   $ImageEditingReplacementArray=array('/', '\.\.', '/', '\./');
   $ImageEditingStartDirectory="";
   $ImageEditingDirectoryDepth="";
   $ImageEditingDirectoryLevel="";
   $ImageEditingDirectoryPathChangeValue="";
   $DirectoryFileListWorkArrayDefaultCount=7; // Vorgabe: Anzahl der Array-Elemente
   $DirectoryFileListWorkArrayCurrentCount=count($DirectoryFileListWorkArray);
   if(isset($DirectoryFileListWorkArray) &&
      is_array($DirectoryFileListWorkArray) &&
      $DirectoryFileListWorkArrayDefaultCount == $DirectoryFileListWorkArrayCurrentCount) {
      // Image-Editing-Menue Bereich 1 - Ausgangsverzeichnis, Verzeichnistiefe
      $ImageEditingStartDirectory = getcwd() . "/";
      if(!empty($DirectoryFileListWorkArray[2]) && preg_match("/^[1-9]$/", $DirectoryFileListWorkArray[2])) {
         $ImageEditingDirectoryDepth = $DirectoryFileListWorkArray[2];
      }
      else
      {
      $ImageEditingDirectoryDepth = $DirectoryFileListWorkArray[5];
      }
      // Image-Editing-Menue Bereich 2 - aktuelles Verzeichnis, Wechsel der Verzeichnisebene
      if(isset($DirectoryFileListWorkArray[0]) && preg_match("/^[0]$/", $DirectoryFileListWorkArray[0])) {
         $ImageEditingDirectoryLevel=0;
         $ImageEditingCurrentWorkDirectory = $ImageEditingStartDirectory;
         $ReturnCode=1;
      } elseif(!empty($DirectoryFileListWorkArray[0]) && preg_match("/^[1]$/", $DirectoryFileListWorkArray[0])) {
         if(@chdir("../")) {
            $ImageEditingDirectoryLevel=1;
            $ImageEditingCurrentWorkDirectory = getcwd() . "/";
            $ReturnCode=1;
         }
         else
         {
            $ImageEditingDirectoryLevel=0;
            $ImageEditingCurrentWorkDirectory = $ImageEditingStartDirectory;
            $ReturnCode=2;
         }
      } elseif(!empty($DirectoryFileListWorkArray[0]) && preg_match("/^[2]$/", $DirectoryFileListWorkArray[0])) {
         if(@chdir("../../")) {
            $ImageEditingDirectoryLevel=2;
            $ImageEditingCurrentWorkDirectory = getcwd() . "/";
            $ReturnCode=1;
         }
         else
         {
            $ImageEditingDirectoryLevel=0;
            $ImageEditingCurrentWorkDirectory = $ImageEditingStartDirectory;
            $ReturnCode=2;
         }
      } elseif(!empty($DirectoryFileListWorkArray[0]) &&
         preg_match("/^[3]$/", $DirectoryFileListWorkArray[0]) &&
         !empty($DirectoryFileListWorkArray[1])) {
         $ImageEditingDirectoryPathChangeValue = trim($DirectoryFileListWorkArray[1]);
         // einige Korrekturen bei moeglichen Fehleingaben (Verzeichnispfad)
         $ImageEditingTermArrayCount = count($ImageEditingTermArray);
         $ImageEditingReplacementArrayCount = count($ImageEditingReplacementArray);
         if(isset($ImageEditingTermArray) &&
            is_array($ImageEditingTermArray) &&
            isset($ImageEditingReplacementArray) &&
            is_array($ImageEditingReplacementArray) &&
            $ImageEditingTermArrayCount == $ImageEditingReplacementArrayCount) {
            for($x=0; $x<$ImageEditingTermArrayCount; $x++) {
               if(preg_match("@" . $ImageEditingTermArray[$x] . "@", $ImageEditingDirectoryPathChangeValue)) {
                  $ImageEditingDirectoryPathChangeValue = preg_replace("@" . $ImageEditingTermArray[$x] . "@", $ImageEditingReplacementArray[$x], $ImageEditingDirectoryPathChangeValue);
                  if(preg_match("@" . $ImageEditingTermArray[$x] . "@", $ImageEditingDirectoryPathChangeValue)) $x--;
               }
               if(preg_match('@^(\./|\.\./).+@', $ImageEditingDirectoryPathChangeValue)) {
                  if(!preg_match('@^.*/$@', $ImageEditingDirectoryPathChangeValue)) $ImageEditingDirectoryPathChangeValue = $ImageEditingDirectoryPathChangeValue . "/";
               }
               else
               {
               $ImageEditingDirectoryPathChangeValue='';
               }
            }
         }
         else
         {
            print 'NOTE: SYSTEM-ARRAY ImageEditingTermArray OR ImageEditingReplacementArray (ARRAY-COUNT) - function <strong>create_work_directory_file_list</strong> - ARE DAMAGED!';
            exit;
         }
         if(is_dir($ImageEditingDirectoryPathChangeValue) && @chdir($ImageEditingDirectoryPathChangeValue)) {
            $ImageEditingDirectoryLevel=3;
            $ImageEditingCurrentWorkDirectory = getcwd() . "/";
            $ReturnCode=1;
         }
         else
         {
            $ImageEditingDirectoryLevel=0;
            $ImageEditingCurrentWorkDirectory = $ImageEditingStartDirectory;
            $ReturnCode=2;
         }
      }
      else
      {
         $ImageEditingDirectoryLevel=0;
         $ImageEditingCurrentWorkDirectory = $ImageEditingStartDirectory;
         $ReturnCode=2;
      }
      // Verzeichnisse und Bild-Dateien des Image-Editor-Bereiches
      if(!empty($ImageEditingStartDirectory) &&
         !empty($ImageEditingCurrentWorkDirectory) &&
         !empty($DirectoryFileListWorkArray[4]) &&
         !empty($DirectoryFileListWorkArray[6])) {
         $ImageEditingImageEditorPathFilterString = $ImageEditingStartDirectory . basename($DirectoryFileListWorkArray[4]);
         $ImageEditingDirectoryEditorArray[] = $ImageEditingStartDirectory;
         $ImageEditingCurrentDirectoryEditorArrayCount = count($ImageEditingDirectoryEditorArray);
         for($x=0; $x<$ImageEditingCurrentDirectoryEditorArrayCount; $x++) {
            $ImageEditingFileHandle = @opendir($ImageEditingDirectoryEditorArray[$x]);
            while($ImageEditingFileName = @readdir($ImageEditingFileHandle)) {
               if($ImageEditingFileName != "." && $ImageEditingFileName != "..") {
                  $FileEditorTemporaryArray=array();
                  $ImageEditingDirectoryNameLength = strlen($ImageEditingDirectoryEditorArray[$x]) - 1;
                  $ImageEditingDirectoryNameLastSlashPosition = strrpos($ImageEditingDirectoryEditorArray[$x], '/');
                  if($ImageEditingDirectoryNameLength == $ImageEditingDirectoryNameLastSlashPosition) {
                     $ImageEditingDirectoryEditorArray[$x] = substr($ImageEditingDirectoryEditorArray[$x], 0, -1);
                  }
                  $ImageEditingNextFile = $ImageEditingDirectoryEditorArray[$x] . "/" . $ImageEditingFileName;
                  if(is_dir($ImageEditingNextFile) &&
                     is_readable($ImageEditingNextFile) &&
                     preg_match("@^(" . $ImageEditingImageEditorPathFilterString . ")@", $ImageEditingNextFile)) {
                     $ImageEditingDirectoryEditorArray[] = $ImageEditingNextFile;
                     $ImageEditingCurrentDirectoryEditorArrayCount = count($ImageEditingDirectoryEditorArray);
                  } elseif(file_exists($ImageEditingNextFile) &&
                     is_readable($ImageEditingNextFile) &&
                     preg_match("@" . $DirectoryFileListWorkArray[6] . "@i", $ImageEditingNextFile) &&
                     preg_match("@^(" . $ImageEditingCurrentWorkDirectory . ")@", $ImageEditingNextFile) &&
                     preg_match("@^(" . $ImageEditingImageEditorPathFilterString . ")@", $ImageEditingNextFile)) {
                     $PathInfo = pathinfo($ImageEditingNextFile);
                     if(is_array($PathInfo)) {
                        $ImageEditingCurrentDirectoryPath = $PathInfo["dirname"];
                        $ImageEditingFilePathRelativePart = preg_replace('@^(' . $ImageEditingCurrentWorkDirectory . ')@', '', $ImageEditingNextFile);
                        $ImageEditingFilePathRelative = "./" . $ImageEditingFilePathRelativePart;
                        $ImageEditingStartFilePathRelative = "./" . preg_replace('@^(' . $ImageEditingStartDirectory . ')@', '', $ImageEditingNextFile);
                        $ImageEditingFilePathMd5 = md5($ImageEditingNextFile);
                        $PathInfoExtension = $PathInfo["extension"];
                     }
                     else
                     {
                        print 'NOTE: UNKNOWN ERROR 1 - function <strong>create_work_directory_file_list</strong> - IS DAMAGED!';
                        exit;
                     }
                     $ImageEditingThumbnailFilename = $ImageEditingFilePathMd5 . "." . $PathInfoExtension;
                     $FileEditorTemporaryArray[] = $ImageEditingCurrentDirectoryPath;
                     $FileEditorTemporaryArray[] = $ImageEditingNextFile;
                     $FileEditorTemporaryArray[] = $ImageEditingFilePathRelative;
                     $FileEditorTemporaryArray[] = $ImageEditingStartFilePathRelative;
                     $FileEditorTemporaryArray[] = $ImageEditingThumbnailFilename;
                     $ImageEditingFileEditorArray[] = $FileEditorTemporaryArray;
                     unset($FileEditorTemporaryArray);
                  }
               }
            }
            @closedir($ImageEditingFileHandle);
         }
         array_shift($ImageEditingDirectoryEditorArray);
      }
      // Verzeichnisse und Bild-Dateien ab dem aktuellen Startverzeichnis ermitteln - ohne die Bild-Dateien des Image-Editor-Bereiches
      if(!empty($ImageEditingCurrentWorkDirectory) &&
         !empty($DirectoryFileListWorkArray[3]) &&
         !empty($DirectoryFileListWorkArray[4]) &&
         !empty($DirectoryFileListWorkArray[6])) {
         $ImageEditingThumbnailPathFilterString = $ImageEditingStartDirectory . basename($DirectoryFileListWorkArray[3]);
         $ImageEditingImageEditorPathFilterString = $ImageEditingStartDirectory . basename($DirectoryFileListWorkArray[4]);
         $ImageEditingDirectoryArray[] = $ImageEditingCurrentWorkDirectory;
         $ImageEditingCurrentDirectoryArrayCount = count($ImageEditingDirectoryArray);
         $ImageEditingDirectoryMaxDepthCount = substr_count($ImageEditingCurrentWorkDirectory, '/') + $ImageEditingDirectoryDepth - 1;
         for($x=0; $x<$ImageEditingCurrentDirectoryArrayCount; $x++) {
            $ImageEditingFileHandle = @opendir($ImageEditingDirectoryArray[$x]);
            while($ImageEditingFileName = @readdir($ImageEditingFileHandle)) {
               if($ImageEditingFileName != "." && $ImageEditingFileName != "..") {
                  $FileEditingTemporaryArray=array();
                  $ImageEditingDirectoryNameLength = strlen($ImageEditingDirectoryArray[$x]) - 1;
                  $ImageEditingDirectoryNameLastSlashPosition = strrpos($ImageEditingDirectoryArray[$x], '/');
                  if($ImageEditingDirectoryNameLength == $ImageEditingDirectoryNameLastSlashPosition) {
                     $ImageEditingDirectoryArray[$x] = substr($ImageEditingDirectoryArray[$x], 0, -1);
                  }
                  $ImageEditingNextFile = $ImageEditingDirectoryArray[$x] . "/" . $ImageEditingFileName;
                  $ImageEditingCurrentDirectoryCount = substr_count($ImageEditingNextFile, '/');
                  if(is_dir($ImageEditingNextFile) &&
                     is_readable($ImageEditingNextFile) &&
                     $ImageEditingCurrentDirectoryCount <= $ImageEditingDirectoryMaxDepthCount &&
                     !preg_match("@^(" . $ImageEditingThumbnailPathFilterString . "|" . $ImageEditingImageEditorPathFilterString . ")@", $ImageEditingDirectoryArray[$x])) {
                     $ImageEditingDirectoryArray[] = $ImageEditingNextFile;
                     $ImageEditingCurrentDirectoryArrayCount = count($ImageEditingDirectoryArray);
                  } elseif(file_exists($ImageEditingNextFile) &&
                     is_readable($ImageEditingNextFile) &&
                     preg_match("@" . $DirectoryFileListWorkArray[6] . "@i", $ImageEditingNextFile) &&
                     preg_match("@^(" . $ImageEditingCurrentWorkDirectory . ")@", $ImageEditingNextFile) &&
                     !preg_match("@^(" . $ImageEditingThumbnailPathFilterString . "|" . $ImageEditingImageEditorPathFilterString . ")@", $ImageEditingDirectoryArray[$x])) {
                     $PathInfo = pathinfo($ImageEditingNextFile);
                     if(is_array($PathInfo)) {
                        $ImageEditingCurrentDirectoryPath = $PathInfo["dirname"];
                        $ImageEditingFilePathRelativePart = preg_replace('@^(' . $ImageEditingCurrentWorkDirectory . ')@', '', $ImageEditingNextFile);
                        $ImageEditingFilePathRelative = "./" . $ImageEditingFilePathRelativePart;
                        $ImageEditingFilePathMd5 = md5($ImageEditingNextFile);
                        $PathInfoExtension = $PathInfo["extension"];
                     }
                     else
                     {
                        print 'NOTE: UNKNOWN ERROR 2 - function <strong>create_work_directory_file_list</strong> - IS DAMAGED!';
                        exit;
                     }
                     $ImageEditingThumbnailFilename = $ImageEditingFilePathMd5 . "." . $PathInfoExtension;
                     $FileEditingTemporaryArray[] = $ImageEditingCurrentDirectoryPath;
                     $FileEditingTemporaryArray[] = $ImageEditingNextFile;
                     $FileEditingTemporaryArray[] = $ImageEditingFilePathRelative;
                     $DirectoryComparison = strcmp($ImageEditingStartDirectory, $ImageEditingCurrentWorkDirectory);
                     if($DirectoryComparison == 0) {
                        $ImageEditingStartFilePathRelative = "./" . preg_replace('@^(' . $ImageEditingStartDirectory . ')@', '', $ImageEditingNextFile);
                     } elseif(preg_match("@^(" . $ImageEditingStartDirectory . ")@", $ImageEditingNextFile)) {
                        $ImageEditingStartFilePathRelative = "./" . preg_replace('@^(' . $ImageEditingStartDirectory . ')@', '', $ImageEditingNextFile);
                     } elseif(preg_match("@^(" . $ImageEditingCurrentWorkDirectory . ")@", $ImageEditingStartDirectory)) {
                        $ImageEditingStartFilePathRelativePart = preg_replace('@^(' . $ImageEditingCurrentWorkDirectory . ')@', '', $ImageEditingNextFile);
                        $CurrentDirectoryPart = preg_replace('@^(' . $ImageEditingCurrentWorkDirectory . ')@', '', $ImageEditingStartDirectory);
                        $DirectoryRankHigher='';
                        $CurrentDirectoryPartSlashCount = substr_count($CurrentDirectoryPart, '/');
                        for($y=0; $y<$CurrentDirectoryPartSlashCount; $y++) {
                           $DirectoryRankHigher .='../';
                        }
                        $ImageEditingStartFilePathRelative = $DirectoryRankHigher . $ImageEditingStartFilePathRelativePart;
                     }
                     else
                     {
                     $ImageEditingStartFilePathRelative='';
                     }
                     $FileEditingTemporaryArray[] = $ImageEditingStartFilePathRelative;
                     $FileEditingTemporaryArray[] = $ImageEditingThumbnailFilename;
                     $ImageEditingFileArray[] = $FileEditingTemporaryArray;
                     unset($FileEditingTemporaryArray); 
                  }
               }
            }
            @closedir($ImageEditingFileHandle);
         }
      }
   }
   else
   {
      print 'NOTE: SYSTEM-ARRAY DirectoryFileListWorkArray (ARRAY-COUNT) - function <strong>create_work_directory_file_list</strong> - IS DAMAGED!';
      exit;
   }
   sort($ImageEditingDirectoryEditorArray);
   sort($ImageEditingFileEditorArray);
   sort($ImageEditingDirectoryArray);
   sort($ImageEditingFileArray);
   array_push($SubsumedDirectoryFileListArray, $ImageEditingDirectoryEditorArray, $ImageEditingFileEditorArray, $ImageEditingDirectoryArray, $ImageEditingFileArray, $ImageEditingStartDirectory, $ImageEditingDirectoryDepth, $ImageEditingDirectoryLevel, $ImageEditingDirectoryPathChangeValue, $ReturnCode);
   unset($ImageEditingDirectoryEditorArray);
   unset($ImageEditingFileEditorArray);
   unset($ImageEditingDirectoryArray);
   unset($ImageEditingFileArray);
   unset($DirectoryFileListWorkArray);
   return $SubsumedDirectoryFileListArray;
}

// Erstellung der Webseite  IMAGE EDITING
function create_image_editing($ObelixFileNameArray='', $SubsumedDirectoryFileListArray='', $ImageEditingOverwriteFileArray='', $ImageEditingDetailsArray='', $ImageEditingMessagesArray='') {
   $ImageEditingMessagesHtml='';
   $ImageEditingOutputHtml='';
   $ImageEditingStartWorkDirectory="";
   $ImageEditingCurrentWorkDirectory="";
   $ImageEditingDirectoryDepth="";
   $ImageEditingDirectoryLevel0="";
   $ImageEditingDirectoryLevel1="";
   $ImageEditingDirectoryLevel2="";
   $ImageEditingDirectoryLevel3="";
   $ImageEditingDirectoryPathChangeValue="";
   $MaxExecutionTimeMemoryLimitModifiedCheckbox="";
   $ImageEditingTermArray=array('(/){2,}', '(\.){3,}', '(/\./)', '^(\./){2,}');
   $ImageEditingReplacementArray=array('/', '\.\.', '/', '\./');
   if(empty($ImageEditingDetailsArray[0])) $ImageEditingDetailsArray[0]=0;
   if(empty($ImageEditingDetailsArray[1])) $ImageEditingDetailsArray[1]=0;
   if(empty($ImageEditingDetailsArray[2])) $ImageEditingDetailsArray[2]=0;
   if(empty($ImageEditingDetailsArray[5])) $ImageEditingDetailsArray[5]=1125;
   if(empty($ImageEditingDetailsArray[8])) $ImageEditingDetailsArray[8]=0;
   if(empty($ImageEditingDetailsArray[10])) $ImageEditingDetailsArray[10]=250;
   if(empty($ImageEditingDetailsArray[24])) $ImageEditingDetailsArray[24]=3;
   if(!empty($ImageEditingDetailsArray[8])) $MaxExecutionTimeMemoryLimitModifiedCheckbox = " checked";
   $GigaByte=1024 * 1024 * 1024;
   $MegaByte=1024 * 1024;
   $KiloByte=1024;
   $ThumbnailImageWidth=250;
   if(preg_match("/^[1-9][0-9]{0,2}$/", $ImageEditingDetailsArray[10])) $ThumbnailImageWidth = $ImageEditingDetailsArray[10];
   // Breite des main-Anzeigebereichs - siehe CSS-Style im unteren Bereich des PHP-Skriptes (1125 - 50)
   $ImageEditingThumbnailVisibleRangeWidth = $ImageEditingDetailsArray[5] - 50;
   if($ImageEditingThumbnailVisibleRangeWidth >= $ThumbnailImageWidth) {
      $ColumnCount = floor($ImageEditingThumbnailVisibleRangeWidth / $ThumbnailImageWidth);
   }
   $ObelixFileNameArrayDefaultCount=15; // Vorgabe: Anzahl der Array-Elemente
   $ObelixFileNameArrayCurrentCount=count($ObelixFileNameArray);
   $SubsumedDirectoryFileListArrayDefaultCount=9; // Vorgabe: Anzahl der Array-Elemente
   $SubsumedDirectoryFileListArrayCurrentCount=count($SubsumedDirectoryFileListArray);
   $ImageEditingOverwriteFileArrayDefaultCount=3; // Vorgabe: Anzahl der Array-Elemente
   $ImageEditingOverwriteFileArrayCurrentCount=count($ImageEditingOverwriteFileArray);
   $ImageEditingDetailsArrayDefaultCount=39; // Vorgabe: Anzahl der Array-Elemente
   $ImageEditingDetailsArrayCurrentCount=count($ImageEditingDetailsArray);
   $ImageEditingMessagesArrayDefaultCount=8; // Vorgabe: Anzahl der Array-Elemente
   $ImageEditingMessagesArrayCurrentCount=count($ImageEditingMessagesArray);
   if(isset($ObelixFileNameArray) &&
      is_array($ObelixFileNameArray) &&
      $ObelixFileNameArrayDefaultCount == $ObelixFileNameArrayCurrentCount &&
      isset($SubsumedDirectoryFileListArray) &&
      is_array($SubsumedDirectoryFileListArray) &&
      $SubsumedDirectoryFileListArrayDefaultCount == $SubsumedDirectoryFileListArrayCurrentCount &&
      isset($ImageEditingOverwriteFileArray) &&
      is_array($ImageEditingOverwriteFileArray) &&
      $ImageEditingOverwriteFileArrayDefaultCount == $ImageEditingOverwriteFileArrayCurrentCount &&
      isset($ImageEditingDetailsArray) &&
      is_array($ImageEditingDetailsArray) &&
      $ImageEditingDetailsArrayDefaultCount == $ImageEditingDetailsArrayCurrentCount &&
      isset($ImageEditingMessagesArray) &&
      is_array($ImageEditingMessagesArray) &&
      $ImageEditingMessagesArrayDefaultCount == $ImageEditingMessagesArrayCurrentCount) {
      // Image-Editing-Menue Bereich 1 - Ausgangsverzeichnis, aktuelles Arbeitsverzeichnis, Verzeichnistiefe
      $ImageEditingStartDirectory = $SubsumedDirectoryFileListArray[4];
      if(empty($ImageEditingStartDirectory)) $ImageEditingStartDirectory = getcwd() . "/";
      $ImageEditingCurrentWorkDirectory = getcwd() . "/";
      $ImageEditingDirectoryDepth = $SubsumedDirectoryFileListArray[5];
      if(empty($ImageEditingDirectoryDepth)) $ImageEditingDirectoryDepth = $ImageEditingDetailsArray[24];
      // Image-Editing-Menue Bereich 2 - aktuelles Verzeichnis, Wechsel der Verzeichnisebene
      if(!empty($SubsumedDirectoryFileListArray[6]) && preg_match("/^[0]$/", $SubsumedDirectoryFileListArray[6])) {
         $ImageEditingDirectoryLevel0=" checked";
         if($SubsumedDirectoryFileListArray[8] == 1) {
            $ImageEditingDirectoryLevel0=" checked";
         }
         else
         {
            $ImageEditingDirectoryLevel0=" checked";
            $ErrorCode=1;
         }
      } elseif(!empty($SubsumedDirectoryFileListArray[6]) && preg_match("/^[1]$/", $SubsumedDirectoryFileListArray[6])) {
         if($SubsumedDirectoryFileListArray[8] == 1) {
            $ImageEditingDirectoryLevel1=" checked";
         }
         else
         {
            $ImageEditingDirectoryLevel0=" checked";
            $ErrorCode=1;
         }
      } elseif(!empty($SubsumedDirectoryFileListArray[6]) && preg_match("/^[2]$/", $SubsumedDirectoryFileListArray[6])) {
         if($SubsumedDirectoryFileListArray[8] == 1) {
            $ImageEditingDirectoryLevel2=" checked";
         }
         else
         {
            $ImageEditingDirectoryLevel0=" checked";
            $ErrorCode=1;
         }
      } elseif(!empty($SubsumedDirectoryFileListArray[6]) &&
         preg_match("/^[3]$/", $SubsumedDirectoryFileListArray[6]) &&
         !empty($SubsumedDirectoryFileListArray[7])) {
         $ImageEditingDirectoryPathChangeValue = trim($SubsumedDirectoryFileListArray[7]);
         // einige Korrekturen bei moeglichen Fehleingaben (Verzeichnispfad)
         $ImageEditingTermArrayCount = count($ImageEditingTermArray);
         $ImageEditingReplacementArrayCount = count($ImageEditingReplacementArray);
         if(isset($ImageEditingTermArray) &&
            is_array($ImageEditingTermArray) &&
            isset($ImageEditingReplacementArray) &&
            is_array($ImageEditingReplacementArray) &&
            $ImageEditingTermArrayCount == $ImageEditingReplacementArrayCount) {
            for($x=0; $x<$ImageEditingTermArrayCount; $x++) {
               if(preg_match("@" . $ImageEditingTermArray[$x] . "@", $ImageEditingDirectoryPathChangeValue)) {
                  $ImageEditingDirectoryPathChangeValue = preg_replace("@" . $ImageEditingTermArray[$x] . "@", $ImageEditingReplacementArray[$x], $ImageEditingDirectoryPathChangeValue);
                  if(preg_match("@" . $ImageEditingTermArray[$x] . "@", $ImageEditingDirectoryPathChangeValue)) $x--;
               }
               if(preg_match('@^(\./|\.\./).+@', $ImageEditingDirectoryPathChangeValue)) {
                  if(!preg_match('@^.*/$@', $ImageEditingDirectoryPathChangeValue)) $ImageEditingDirectoryPathChangeValue = $ImageEditingDirectoryPathChangeValue . "/";
               }
               else
               {
               $ImageEditingDirectoryPathChangeValue='';
               }
            }
         }
         else
         {
            print 'NOTE: SYSTEM-ARRAY ImageEditingTermArray OR ImageEditingReplacementArray (ARRAY-COUNT) - function <strong>create_image_editing</strong> - ARE DAMAGED!';
            exit;
         }
         if(is_dir($ImageEditingCurrentWorkDirectory)) {
            $ImageEditingDirectoryLevel3=" checked";
            $ImageEditingDirectoryPathChangeValue = $SubsumedDirectoryFileListArray[7];
         }
         else
         {
            $ImageEditingDirectoryLevel0=" checked";
            $ErrorCode=1;
         }
      }
      else
      {
         $ImageEditingDirectoryLevel0=" checked";
      }
      if(!empty($ErrorCode)) {
         $ImageEditingMessagesHtml .="        <tr>\n";
         $ImageEditingMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $ImageEditingMessagesArray[7] . "</td>\n";
         $ImageEditingMessagesHtml .="        </tr>\n";
         $ImageEditingMessagesHtml .="        <tr>\n";
         $ImageEditingMessagesHtml .="          <td colspan=\"3\"><hr></td>\n";
         $ImageEditingMessagesHtml .="        </tr>\n";
      }
      if(isset($SubsumedDirectoryFileListArray[0]) &&
         is_array($SubsumedDirectoryFileListArray[0]) &&
         isset($SubsumedDirectoryFileListArray[1]) &&
         is_array($SubsumedDirectoryFileListArray[1]) &&
         isset($SubsumedDirectoryFileListArray[2]) &&
         is_array($SubsumedDirectoryFileListArray[2]) &&
         isset($SubsumedDirectoryFileListArray[3]) &&
         is_array($SubsumedDirectoryFileListArray[3]) &&
         !empty($ImageEditingDetailsArray[9]) &&
         !empty($ThumbnailImageWidth) &&
         !empty($ColumnCount)) {
         // Tabelle mit den Thumbnails des Image-Editors erstellen
         $ImageEditingOutputHtml .="        <tr>\n";
         $ImageEditingOutputHtml .="          <td colspan=\"3\">\n";
         $ImageEditingDirectoryEditorArrayCount = count($SubsumedDirectoryFileListArray[0]);
         $ImageEditingFileEditorArrayCount = count($SubsumedDirectoryFileListArray[1]);
         if(empty($ImageEditingFileEditorArrayCount)) {
            $ImageEditingOutputHtml .="            <table class=\"table_no_result\">\n";
            $ImageEditingOutputHtml .="              <tr>\n";
            $ImageEditingOutputHtml .="                <td colspan=\"" . $ColumnCount . "\" class=\"center\"><strong>" . $ImageEditingDetailsArray[29] . "</strong></td>\n";
            $ImageEditingOutputHtml .="              </tr>\n";
            $ImageEditingOutputHtml .="              <tr>\n";
            $ImageEditingOutputHtml .="                <td colspan=\"" . $ColumnCount . "\">&nbsp;</td>\n";
            $ImageEditingOutputHtml .="              </tr>\n";
            $ImageEditingOutputHtml .="              <tr>\n";
            $ImageEditingOutputHtml .="                <td colspan=\"" . $ColumnCount . "\">" . $ImageEditingMessagesArray[0] . "</td>\n";
            $ImageEditingOutputHtml .="              </tr>\n";
            $ImageEditingOutputHtml .="              <tr>\n";
            $ImageEditingOutputHtml .="                <td colspan=\"" . $ColumnCount . "\">&nbsp;</td>\n";
            $ImageEditingOutputHtml .="              </tr>\n";
         }
         else
         {
            $ImageEditingOutputHtml .="            <table class=\"table_result\">\n";
            $ImageEditingOutputHtml .="              <tr>\n";
            $ImageEditingOutputHtml .="                <td colspan=\"" . $ColumnCount . "\">&nbsp;</td>\n";
            $ImageEditingOutputHtml .="              </tr>\n";
            for($x=0; $x<$ImageEditingDirectoryEditorArrayCount; $x++) {
               $TableCellCount=0;
               $ThumbnailNumber=0;
               $ArrayElementNumber=0;
               $ImageInfoOutputHtml='';
               if($x == 0) {
                  $ImageEditingOutputHtml .="              <tr>\n";
                  $ImageEditingOutputHtml .="                <td colspan=\"" . $ColumnCount . "\" class=\"center\"><strong>" . $ImageEditingDetailsArray[29] . "</strong> " . $SubsumedDirectoryFileListArray[0][$x] . "</td>\n";
                  $ImageEditingOutputHtml .="              </tr>\n";
                  $ImageEditingOutputHtml .="              <tr>\n";
                  $ImageEditingOutputHtml .="                <td colspan=\"" . $ColumnCount . "\">&nbsp;</td>\n";
                  $ImageEditingOutputHtml .="              </tr>\n";
               }
               for($y=0; $y<$ImageEditingFileEditorArrayCount; $y++) {
                  if(empty($ImageInfoArray)) $ImageInfoArray=array();
                  if(preg_match('@^' . $SubsumedDirectoryFileListArray[0][$x] . '$@', $SubsumedDirectoryFileListArray[1][$y][0])) {
                     $CurrentThumbnailImagePath = $ImageEditingDetailsArray[9] . "/" . $SubsumedDirectoryFileListArray[1][$y][4];
                     $ThumbnailImagePath = $ObelixFileNameArray[11] . "/" . $SubsumedDirectoryFileListArray[1][$y][4];
                     if(file_exists($CurrentThumbnailImagePath) && is_readable($CurrentThumbnailImagePath)) {
                        $ThumbnailNumber++;
                        if($ThumbnailNumber == 1) {
                           $ImageEditingOutputHtml .="              <tr>\n";
                           $ImageEditingOutputHtml .="                <td colspan=\"" . $ColumnCount . "\"><strong>" . $ImageEditingDetailsArray[30] . "</strong> " . $SubsumedDirectoryFileListArray[0][$x] . "</td>\n";
                           $ImageEditingOutputHtml .="              </tr>\n";
                        }
                        $ImageInfo = getimagesize($CurrentThumbnailImagePath);
                        if(is_array($ImageInfo)) {
                           $ImageHeight = $ImageInfo[1];
                           $ThumbnailImageHtmlTag = "<img src=\"" . $ThumbnailImagePath . "\" width=\"" . $ThumbnailImageWidth . "\" height=\"" . $ImageHeight . "\" alt=\"Editor-Image " . $ThumbnailNumber . "\" title=\"Editor-Image " . $ThumbnailNumber . "\">";
                           $ImageInfoArray[] = basename($SubsumedDirectoryFileListArray[1][$y][2]);
                           $ImageFileSizeByte = filesize($SubsumedDirectoryFileListArray[1][$y][2]);
                           if(empty($ImageFileSizeByte)) {
                             $ImageFileSize="";
                           } elseif($ImageFileSizeByte > $GigaByte) {
                              $SizeValue = $ImageFileSizeByte / $GigaByte;
                              $ImageFileSize = round($SizeValue, 1) . " " . $ImageEditingDetailsArray[35];
                           } elseif($ImageFileSizeByte > $MegaByte) {
                              $SizeValue = $ImageFileSizeByte / $MegaByte;
                              $ImageFileSize = round($SizeValue, 1) . " " . $ImageEditingDetailsArray[36];
                           } elseif($ImageFileSizeByte > $KiloByte) {
                              $SizeValue = $ImageFileSizeByte / $KiloByte;
                              $ImageFileSize = round($SizeValue, 0) . " " . $ImageEditingDetailsArray[37];
                           }
                           else
                           {
                           $ImageFileSize = $ImageFileSizeByte . " " . $ImageEditingDetailsArray[38];
                           }
                           $ImageInfoArray[] = $ImageFileSize;
                           $ImageCurrentFileMtime = filemtime($SubsumedDirectoryFileListArray[1][$y][2]);
                           $ImageCurrentFileGmdateMtime = gmdate("Y-m-d H:i:s", $ImageCurrentFileMtime);
                           $ImageInfoArray[] = $ImageCurrentFileGmdateMtime;
                           $ImageInfoArray[] = "<a href=\"" . $ObelixFileNameArray[4] . "?OBELIX_ID=" . $ImageEditingDetailsArray[2] . "&ACCESS_ID=" . $ImageEditingDetailsArray[1] . "&GET_FILENAME=" . $SubsumedDirectoryFileListArray[1][$y][3] . "\" target=\"EDITOR\">" . $ImageEditingDetailsArray[32] . "</a>";
                           $ImageInfoArray[] = "<input type=\"radio\" name=\"IMAGE_SOURCE_OVERWRITE\" value=\"" . $SubsumedDirectoryFileListArray[1][$y][3] . "\">";
                           $ImageInfoArray[] = $ImageEditingDetailsArray[33];
                           if($TableCellCount == 0) $ImageEditingOutputHtml .="              <tr>\n";
                           $ImageEditingOutputHtml .="                <td>" . $ThumbnailImageHtmlTag . "</td>\n";
                           $ImageInfoOutputHtml .="                <td>\n";
                           $ImageInfoOutputHtml .="                  <table>\n";
                           $ImageInfoOutputHtml .="                    <tr>\n";
                           if(isset($ImageInfoArray[$ArrayElementNumber])) {
                              $ImageInfoOutputHtml .="                      <td colspan=\"3\">" . $ImageInfoArray[$ArrayElementNumber] . "</td>\n";
                           }
                           else
                           {
                           $ImageInfoOutputHtml .="                      <td colspan=\"3\">&nbsp;</td>\n";
                           }
                           $ImageInfoOutputHtml .="                    </tr>\n";
                           $ArrayElementNumber++;
                           $ImageInfoOutputHtml .="                    <tr>\n";
                           if(isset($ImageInfoArray[$ArrayElementNumber])) {
                              $ImageInfoOutputHtml .="                      <td>" . $ImageInfoArray[$ArrayElementNumber] . "</td>\n";
                           }
                           else
                           {
                           $ImageInfoOutputHtml .="                      <td>&nbsp;</td>\n";
                           }
                           $ArrayElementNumber++;
                           if(isset($ImageInfoArray[$ArrayElementNumber])) {
                              $ImageInfoOutputHtml .="                      <td colspan=\"2\">" . $ImageInfoArray[$ArrayElementNumber] . "</td>\n";
                           }
                           else
                           {
                           $ImageInfoOutputHtml .="                      <td colspan=\"2\">&nbsp;</td>\n";
                           }
                           $ImageInfoOutputHtml .="                    </tr>\n";
                           $ArrayElementNumber++;
                           $ImageInfoOutputHtml .="                    <tr>\n";
                           if(isset($ImageInfoArray[$ArrayElementNumber])) {
                              $ImageInfoOutputHtml .="                      <td>" . $ImageInfoArray[$ArrayElementNumber] . "</td>\n";
                           }
                           else
                           {
                           $ImageInfoOutputHtml .="                      <td>&nbsp;</td>\n";
                           }
                           $ArrayElementNumber++;
                           if(isset($ImageInfoArray[$ArrayElementNumber])) {
                              $ImageInfoOutputHtml .="                      <td class=\"right\">" . $ImageInfoArray[$ArrayElementNumber] . "</td>\n";
                           }
                           else
                           {
                           $ImageInfoOutputHtml .="                      <td>&nbsp;</td>\n";
                           }
                           $ArrayElementNumber++;
                           if(isset($ImageInfoArray[$ArrayElementNumber])) {
                              $ImageInfoOutputHtml .="                      <td>" . $ImageInfoArray[$ArrayElementNumber] . "</td>\n";
                           }
                           else
                           {
                           $ImageInfoOutputHtml .="                      <td>&nbsp;</td>\n";
                           }
                           $ImageInfoOutputHtml .="                    </tr>\n";
                           $ImageInfoOutputHtml .="                  </table>\n";
                           $ImageInfoOutputHtml .="                </td>\n";
                           $ArrayElementNumber++;
                           $TableCellCount++;
                           if($TableCellCount == $ColumnCount) {
                              $ImageEditingOutputHtml .="              </tr>\n";
                              $ImageEditingOutputHtml .="              <tr>\n";
                              $ImageEditingOutputHtml .= $ImageInfoOutputHtml;
                              $ImageEditingOutputHtml .="              </tr>\n";
                              $ImageEditingOutputHtml .="              <tr>\n";
                              $ImageEditingOutputHtml .="                <td colspan=\"" . $ColumnCount . "\">&nbsp;</td>\n";
                              $ImageEditingOutputHtml .="              </tr>\n";
                              $ImageInfoOutputHtml='';
                              $ArrayElementNumber=0;
                              if(isset($ImageInfoArray)) unset($ImageInfoArray);
                              $TableCellCount=0;
                           }
                        }
                        else
                        {
                           print 'NOTE: UNKNOWN ERROR 1 - CAN NOT CREATE COLOR-PALETTE - function <strong>create_color_palette</strong>!';
                           exit;
                        }
                     }
                  }
               }
               if($TableCellCount != 0) {
                  for($z=$TableCellCount; $z<$ColumnCount; $z++) {
                     $ImageEditingOutputHtml .="                <td>&nbsp;</td>\n";
                  }
                  if($ThumbnailNumber == $ColumnCount) $ImageEditingOutputHtml .="              </tr>\n";
                  $ImageEditingOutputHtml .="              <tr>\n";
                  $ImageEditingOutputHtml .= $ImageInfoOutputHtml;
                  for($z=$TableCellCount; $z<$ColumnCount; $z++) {
                     $ImageEditingOutputHtml .="                <td>&nbsp;</td>\n";
                  }
                  $ImageEditingOutputHtml .="              </tr>\n";
                  $ImageEditingOutputHtml .="              <tr>\n";
                  $ImageEditingOutputHtml .="                <td colspan=\"" . $ColumnCount . "\">&nbsp;</td>\n";
                  $ImageEditingOutputHtml .="              </tr>\n";
                  if(isset($ImageInfoArray)) unset($ImageInfoArray);
               }
            }
         }
         $ImageEditingOutputHtml .="            </table>\n";
         $ImageEditingOutputHtml .="          </td>\n";
         $ImageEditingOutputHtml .="        </tr>\n";
         $ImageEditingOutputHtml .="        <tr>\n";
         $ImageEditingOutputHtml .="          <td colspan=\"3\"><hr></td>\n";
         $ImageEditingOutputHtml .="        </tr>\n";
         // Tabelle mit den Thumbnails der gefundenen Bilder erstellen
         $ImageEditingOutputHtml .="        <tr>\n";
         $ImageEditingOutputHtml .="          <td colspan=\"3\">\n";
         $ImageEditingDirectoryEditingArrayCount = count($SubsumedDirectoryFileListArray[2]);
         $ImageEditingFileEditingArrayCount = count($SubsumedDirectoryFileListArray[3]);
         if(empty($ImageEditingFileEditingArrayCount)) {
            $ImageEditingOutputHtml .="            <table class=\"table_no_result\">\n";
            $ImageEditingOutputHtml .="              <tr>\n";
            $ImageEditingOutputHtml .="                <td colspan=\"" . $ColumnCount . "\" class=\"center\"><strong>" . $ImageEditingDetailsArray[31] . "</strong></td>\n";
            $ImageEditingOutputHtml .="              </tr>\n";
            $ImageEditingOutputHtml .="              <tr>\n";
            $ImageEditingOutputHtml .="                <td colspan=\"" . $ColumnCount . "\">&nbsp;</td>\n";
            $ImageEditingOutputHtml .="              </tr>\n";
            $ImageEditingOutputHtml .="              <tr>\n";
            $ImageEditingOutputHtml .="                <td colspan=\"" . $ColumnCount . "\">" . $ImageEditingMessagesArray[1] . "</td>\n";
            $ImageEditingOutputHtml .="              </tr>\n";
            $ImageEditingOutputHtml .="              <tr>\n";
            $ImageEditingOutputHtml .="                <td colspan=\"" . $ColumnCount . "\">&nbsp;</td>\n";
            $ImageEditingOutputHtml .="              </tr>\n";
         }
         else
         {
            $ImageEditingOutputHtml .="            <table class=\"table_result\">\n";
            $ImageEditingOutputHtml .="              <tr>\n";
            $ImageEditingOutputHtml .="                <td colspan=\"" . $ColumnCount . "\">&nbsp;</td>\n";
            $ImageEditingOutputHtml .="              </tr>\n";
            for($x=0; $x<$ImageEditingDirectoryEditingArrayCount; $x++) {
               $TableCellCount=0;
               $ThumbnailNumber=0;
               $ArrayElementNumber=0;
               $ImageInfoOutputHtml='';
               if($x == 0) {
                  $ImageEditingOutputHtml .="              <tr>\n";
                  $ImageEditingOutputHtml .="                <td colspan=\"" . $ColumnCount . "\" class=\"center\"><strong>" . $ImageEditingDetailsArray[31] . "</strong></td>\n";
                  $ImageEditingOutputHtml .="              </tr>\n";
                  $ImageEditingOutputHtml .="              <tr>\n";
                  $ImageEditingOutputHtml .="                <td colspan=\"" . $ColumnCount . "\">&nbsp;</td>\n";
                  $ImageEditingOutputHtml .="              </tr>\n";
               }
               for($y=0; $y<$ImageEditingFileEditingArrayCount; $y++) {
                  if(empty($ImageInfoArray)) $ImageInfoArray=array();
                  if(preg_match('@^' . $SubsumedDirectoryFileListArray[2][$x] . '$@', $SubsumedDirectoryFileListArray[3][$y][0])) {
                     $CurrentThumbnailImagePath = $ImageEditingDetailsArray[9] . "/" . $SubsumedDirectoryFileListArray[3][$y][4];
                     $ThumbnailImagePath = $ObelixFileNameArray[11] . "/" . $SubsumedDirectoryFileListArray[3][$y][4];
                     if(file_exists($CurrentThumbnailImagePath) && is_readable($CurrentThumbnailImagePath)) {
                        $ThumbnailNumber++;
                        if($ThumbnailNumber == 1) {
                           $ImageEditingOutputHtml .="              <tr>\n";
                           $ImageEditingOutputHtml .="                <td colspan=\"" . $ColumnCount . "\"><strong>" . $ImageEditingDetailsArray[30] . "</strong> " . $SubsumedDirectoryFileListArray[2][$x] . "</td>\n";
                           $ImageEditingOutputHtml .="              </tr>\n";
                        }
                        $ImageInfo = getimagesize($CurrentThumbnailImagePath);
                        if(is_array($ImageInfo)) {
                           $ImageHeight = $ImageInfo[1];
                           $ThumbnailImageHtmlTag = "<img src=\"" . $ThumbnailImagePath . "\" width=\"" . $ThumbnailImageWidth . "\" height=\"" . $ImageHeight . "\" alt=\"Editor-Image " . $ThumbnailNumber . "\" title=\"Editor-Image " . $ThumbnailNumber . "\">";
                           $ImageInfoArray[] = basename($SubsumedDirectoryFileListArray[3][$y][2]);
                           $ImageFileSizeByte = filesize($SubsumedDirectoryFileListArray[3][$y][2]);
                           if(empty($ImageFileSizeByte)) {
                             $ImageFileSize="";
                           } elseif($ImageFileSizeByte > $GigaByte) {
                              $SizeValue = $ImageFileSizeByte / $GigaByte;
                              $ImageFileSize = round($SizeValue, 1) . " " . $ImageEditingDetailsArray[35];
                           } elseif($ImageFileSizeByte > $MegaByte) {
                              $SizeValue = $ImageFileSizeByte / $MegaByte;
                              $ImageFileSize = round($SizeValue, 1) . " " . $ImageEditingDetailsArray[36];
                           } elseif($ImageFileSizeByte > $KiloByte) {
                              $SizeValue = $ImageFileSizeByte / $KiloByte;
                              $ImageFileSize = round($SizeValue, 0) . " " . $ImageEditingDetailsArray[37];
                           }
                           else
                           {
                           $ImageFileSize = $ImageFileSizeByte . " " . $ImageEditingDetailsArray[38];
                           }
                           $ImageInfoArray[] = $ImageFileSize;
                           $ImageCurrentFileMtime = filemtime($SubsumedDirectoryFileListArray[3][$y][2]);
                           $ImageCurrentFileGmdateMtime = gmdate("Y-m-d H:i:s", $ImageCurrentFileMtime);
                           $ImageInfoArray[] = $ImageCurrentFileGmdateMtime;
                           $ImageInfoArray[] = "<a href=\"" . $ObelixFileNameArray[4] . "?OBELIX_ID=" . $ImageEditingDetailsArray[2] . "&ACCESS_ID=" . $ImageEditingDetailsArray[1] . "&GET_FILENAME=" . $SubsumedDirectoryFileListArray[3][$y][3] . "\" target=\"EDITOR\">" . $ImageEditingDetailsArray[32] . "</a>";
                           $ImageInfoArray[] = "<input type=\"radio\" name=\"IMAGE_TARGET_OVERWRITE\" value=\"" . $SubsumedDirectoryFileListArray[3][$y][3] . "\">";
                           $ImageInfoArray[] = $ImageEditingDetailsArray[34];
                           if($TableCellCount == 0) $ImageEditingOutputHtml .="              <tr>\n";
                           $ImageEditingOutputHtml .="                <td>" . $ThumbnailImageHtmlTag . "</td>\n";
                           $ImageInfoOutputHtml .="                <td>\n";
                           $ImageInfoOutputHtml .="                  <table>\n";
                           $ImageInfoOutputHtml .="                    <tr>\n";
                           if(isset($ImageInfoArray[$ArrayElementNumber])) {
                              $ImageInfoOutputHtml .="                      <td colspan=\"3\">" . $ImageInfoArray[$ArrayElementNumber] . "</td>\n";
                           }
                           else
                           {
                           $ImageInfoOutputHtml .="                      <td colspan=\"3\">&nbsp;</td>\n";
                           }
                           $ImageInfoOutputHtml .="                    </tr>\n";
                           $ArrayElementNumber++;
                           $ImageInfoOutputHtml .="                    <tr>\n";
                           if(isset($ImageInfoArray[$ArrayElementNumber])) {
                              $ImageInfoOutputHtml .="                      <td>" . $ImageInfoArray[$ArrayElementNumber] . "</td>\n";
                           }
                           else
                           {
                           $ImageInfoOutputHtml .="                      <td>&nbsp;</td>\n";
                           }
                           $ArrayElementNumber++;
                           if(isset($ImageInfoArray[$ArrayElementNumber])) {
                              $ImageInfoOutputHtml .="                      <td colspan=\"2\">" . $ImageInfoArray[$ArrayElementNumber] . "</td>\n";
                           }
                           else
                           {
                           $ImageInfoOutputHtml .="                      <td colspan=\"2\">&nbsp;</td>\n";
                           }
                           $ImageInfoOutputHtml .="                    </tr>\n";
                           $ArrayElementNumber++;
                           $ImageInfoOutputHtml .="                    <tr>\n";
                           if(isset($ImageInfoArray[$ArrayElementNumber])) {
                              $ImageInfoOutputHtml .="                      <td>" . $ImageInfoArray[$ArrayElementNumber] . "</td>\n";
                           }
                           else
                           {
                           $ImageInfoOutputHtml .="                      <td>&nbsp;</td>\n";
                           }
                           $ArrayElementNumber++;
                           if(isset($ImageInfoArray[$ArrayElementNumber])) {
                              $ImageInfoOutputHtml .="                      <td class=\"right\">" . $ImageInfoArray[$ArrayElementNumber] . "</td>\n";
                           }
                           else
                           {
                           $ImageInfoOutputHtml .="                      <td>&nbsp;</td>\n";
                           }
                           $ArrayElementNumber++;
                           if(isset($ImageInfoArray[$ArrayElementNumber])) {
                              $ImageInfoOutputHtml .="                      <td>" . $ImageInfoArray[$ArrayElementNumber] . "</td>\n";
                           }
                           else
                           {
                           $ImageInfoOutputHtml .="                      <td>&nbsp;</td>\n";
                           }
                           $ImageInfoOutputHtml .="                    </tr>\n";
                           $ImageInfoOutputHtml .="                  </table>\n";
                           $ImageInfoOutputHtml .="                </td>\n";
                           $ArrayElementNumber++;
                           $TableCellCount++;
                           if($TableCellCount == $ColumnCount) {
                              $ImageEditingOutputHtml .="              </tr>\n";
                              $ImageEditingOutputHtml .="              <tr>\n";
                              $ImageEditingOutputHtml .= $ImageInfoOutputHtml;
                              $ImageEditingOutputHtml .="              </tr>\n";
                              $ImageEditingOutputHtml .="              <tr>\n";
                              $ImageEditingOutputHtml .="                <td colspan=\"" . $ColumnCount . "\">&nbsp;</td>\n";
                              $ImageEditingOutputHtml .="              </tr>\n";
                              $ImageInfoOutputHtml='';
                              $ArrayElementNumber=0;
                              if(isset($ImageInfoArray)) unset($ImageInfoArray);
                              $TableCellCount=0;
                           }
                        }
                        else
                        {
                           print 'NOTE: UNKNOWN ERROR 2 - CAN NOT CREATE COLOR-PALETTE - function <strong>create_color_palette</strong>!';
                           exit;
                        }
                     }
                  }
               }
               if($TableCellCount != 0) {
                  for($z=$TableCellCount; $z<$ColumnCount; $z++) {
                     $ImageEditingOutputHtml .="                <td>&nbsp;</td>\n";
                  }
                  if($ThumbnailNumber == $ColumnCount) $ImageEditingOutputHtml .="              </tr>\n";
                  $ImageEditingOutputHtml .="              <tr>\n";
                  $ImageEditingOutputHtml .= $ImageInfoOutputHtml;
                  for($z=$TableCellCount; $z<$ColumnCount; $z++) {
                     $ImageEditingOutputHtml .="                <td>&nbsp;</td>\n";
                  }
                  $ImageEditingOutputHtml .="              </tr>\n";
                  $ImageEditingOutputHtml .="              <tr>\n";
                  $ImageEditingOutputHtml .="                <td colspan=\"" . $ColumnCount . "\">&nbsp;</td>\n";
                  $ImageEditingOutputHtml .="              </tr>\n";
                  if(isset($ImageInfoArray)) unset($ImageInfoArray);
               }
            }
         }
         $ImageEditingOutputHtml .="            </table>\n";
         $ImageEditingOutputHtml .="          </td>\n";
         $ImageEditingOutputHtml .="        </tr>\n";
         $ImageEditingOutputHtml .="        <tr>\n";
         $ImageEditingOutputHtml .="          <td colspan=\"3\">&nbsp;</td>\n";
         $ImageEditingOutputHtml .="        </tr>\n";
         $ImageEditingOutputHtml .="        <tr>\n";
         $ImageEditingOutputHtml .="          <td colspan=\"3\" class=\"center\"><input type=\"submit\" name=\"IMAGE_EDITING_OVERWRITE_SUBMIT\" value=\"" . $ImageEditingDetailsArray[26] . "\"></td>\n";
         $ImageEditingOutputHtml .="        </tr>\n";
         $ImageEditingOutputHtml .="        <tr>\n";
         $ImageEditingOutputHtml .="          <td colspan=\"3\">&nbsp;</td>\n";
         $ImageEditingOutputHtml .="        </tr>\n";
         $ImageEditingOutputHtml .="        <tr>\n";
         $ImageEditingOutputHtml .="          <td colspan=\"3\"><hr></td>\n";
         $ImageEditingOutputHtml .="        </tr>\n";
      }
      // Bild durch ein bearbeitetes Bild ueberschreiben
      if(!empty($ImageEditingOverwriteFileArray[0])) {
         if(!empty($ImageEditingOverwriteFileArray[1]) && !empty($ImageEditingOverwriteFileArray[2])) {
            if(file_exists($ImageEditingOverwriteFileArray[1]) && file_exists($ImageEditingOverwriteFileArray[2])) {
               if(is_writeable($ImageEditingOverwriteFileArray[2])) {
                  if(!@copy($ImageEditingOverwriteFileArray[1], $ImageEditingOverwriteFileArray[2])) {
                     $ImageEditingMessagesHtml .="        <tr>\n";
                     $ImageEditingMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $ImageEditingMessagesArray[3] . "</td>\n";
                     $ImageEditingMessagesHtml .="        </tr>\n";
                     $ImageEditingMessagesHtml .="        <tr>\n";
                     $ImageEditingMessagesHtml .="          <td colspan=\"3\"><hr></td>\n";
                     $ImageEditingMessagesHtml .="        </tr>\n";
                  }
                  else
                  {
                     $ImageEditingMessagesHtml .="        <tr>\n";
                     $ImageEditingMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $ImageEditingMessagesArray[2] . "</td>\n";
                     $ImageEditingMessagesHtml .="        </tr>\n";
                     $ImageEditingMessagesHtml .="        <tr>\n";
                     $ImageEditingMessagesHtml .="          <td colspan=\"3\"><hr></td>\n";
                     $ImageEditingMessagesHtml .="        </tr>\n";
                  }
               }
               else
               {
                  $ImageEditingMessagesHtml .="        <tr>\n";
                  $ImageEditingMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $ImageEditingMessagesArray[4] . "</td>\n";
                  $ImageEditingMessagesHtml .="        </tr>\n";
                  $ImageEditingMessagesHtml .="        <tr>\n";
                  $ImageEditingMessagesHtml .="          <td colspan=\"3\"><hr></td>\n";
                  $ImageEditingMessagesHtml .="        </tr>\n";
               }
            }
            else
            {
               $ImageEditingMessagesHtml .="        <tr>\n";
               $ImageEditingMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $ImageEditingMessagesArray[5] . "</td>\n";
               $ImageEditingMessagesHtml .="        </tr>\n";
               $ImageEditingMessagesHtml .="        <tr>\n";
               $ImageEditingMessagesHtml .="          <td colspan=\"3\"><hr></td>\n";
               $ImageEditingMessagesHtml .="        </tr>\n";
            }
         }
         else
         {
            $ImageEditingMessagesHtml .="        <tr>\n";
            $ImageEditingMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $ImageEditingMessagesArray[6] . "</td>\n";
            $ImageEditingMessagesHtml .="        </tr>\n";
            $ImageEditingMessagesHtml .="        <tr>\n";
            $ImageEditingMessagesHtml .="          <td colspan=\"3\"><hr></td>\n";
            $ImageEditingMessagesHtml .="        </tr>\n";
         }
      }
   } elseif(!isset($ObelixFileNameArray) ||
      !is_array($ObelixFileNameArray) ||
      $ObelixFileNameArrayDefaultCount != $SubsumedDirectoryFileListArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY ObelixFileNameArray (ARRAY-COUNT) - function <strong>create_image_editing</strong> - IS DAMAGED!';
      exit;
   } elseif(!isset($SubsumedDirectoryFileListArray) ||
      !is_array($SubsumedDirectoryFileListArray) ||
      $SubsumedDirectoryFileListArrayDefaultCount != $SubsumedDirectoryFileListArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY SubsumedDirectoryFileListArray (ARRAY-COUNT) - function <strong>create_image_editing</strong> - IS DAMAGED!';
      exit;
   } elseif(!isset($ImageEditingOverwriteFileArray) ||
       !is_array($ImageEditingOverwriteFileArray) ||
       $ImageEditingOverwriteFileArrayDefaultCount != $ImageEditingOverwriteFileArrayCurrentCount) {
       print 'NOTE: SYSTEM-ARRAY ImageEditingOverwriteFileArray (ARRAY-COUNT) - function <strong>create_image_editing</strong> - IS DAMAGED!';
       exit;
   } elseif(!isset($ImageEditingDetailsArray) ||
      !is_array($ImageEditingDetailsArray) ||
      $ImageEditingDetailsArrayDefaultCount != $ImageEditingDetailsArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY ImageEditingDetailsArray (ARRAY-COUNT) - function <strong>create_image_editing</strong> - IS DAMAGED!';
      exit;
   }
   else
   {
      print 'NOTE: SYSTEM-ARRAY ImageEditingMessagesArray (ARRAY-COUNT) - function <strong>create_image_editing</strong> - IS DAMAGED!';
      exit;
   }
   $MainContent="    <form name=\"form_image_editing\" method=\"post\" action=\"" . $ObelixFileNameArray[4] . "?OBELIX_ID=" . $ImageEditingDetailsArray[0] . "&ACCESS_ID=" . $ImageEditingDetailsArray[1] . "\" target=\"_self\">\n";
   $MainContent .="      <table>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\" class=\"center\"><h3>" . $ImageEditingDetailsArray[3] . "</h3></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">" . $ImageEditingDetailsArray[4] . " " . $ImageEditingDetailsArray[6] . " " . $ImageEditingDetailsArray[7] . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\"><hr></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .= $ImageEditingMessagesHtml;
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"2\"><strong>" . $ImageEditingDetailsArray[11] . "</strong> " . $ImageEditingStartDirectory . "<br></td>\n";
   $MainContent .="          <td class=\"center\"><strong>" . $ImageEditingDetailsArray[27] . "</strong></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"2\"><strong>" . $ImageEditingDetailsArray[12] . "</strong> " . $ImageEditingCurrentWorkDirectory . "<br></td>\n";
   $MainContent .="          <td rowspan=\"14\" class=\"column_help_text\">" . $ImageEditingDetailsArray[28] . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"2\"><strong>" . $ImageEditingDetailsArray[13] . "</strong> " . $ImageEditingDirectoryDepth . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"2\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"column_wide\">&nbsp;</td>\n";
   $MainContent .="          <td><strong>" . $ImageEditingDetailsArray[14] . "</strong></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"right\"><input type=\"radio\" name=\"IMAGES_DIRECTORY_LEVEL\" value=\"0\"" . $ImageEditingDirectoryLevel0 . "></td>\n";
   $MainContent .="          <td>" . $ImageEditingDetailsArray[15] . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"right\"><input type=\"radio\" name=\"IMAGES_DIRECTORY_LEVEL\" value=\"1\"" . $ImageEditingDirectoryLevel1 . "></td>\n";
   $MainContent .="          <td>" . $ImageEditingDetailsArray[16] . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"right\"><input type=\"radio\" name=\"IMAGES_DIRECTORY_LEVEL\" value=\"2\"" . $ImageEditingDirectoryLevel2 . "></td>\n";
   $MainContent .="          <td>" . $ImageEditingDetailsArray[17] . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"right\"><input type=\"radio\" name=\"IMAGES_DIRECTORY_LEVEL\" value=\"3\"" . $ImageEditingDirectoryLevel3 . "></td>\n";
   $MainContent .="          <td>" . $ImageEditingDetailsArray[18] . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"right\">" . $ImageEditingDetailsArray[19] . " </td>\n";
   $MainContent .="          <td><input type=\"text\" name=\"IMAGES_DIRECTORY_LEVEL_CHANGE\" size=\"20\" maxlength=\"128\" value=\"" . $ImageEditingDirectoryPathChangeValue . "\">&nbsp;" . $ImageEditingDetailsArray[20] . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"2\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"2\">" . $ImageEditingDetailsArray[21] . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"2\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"right\"><input type=\"checkbox\" name=\"MAX_EXECUTION_TIME_MEMORY_LIMIT_MODIFIED\" value=\"1\"" . $MaxExecutionTimeMemoryLimitModifiedCheckbox . "></td>\n";
   $MainContent .="          <td>" . $ImageEditingDetailsArray[22] . " </td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"2\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td class=\"right\">" . $ImageEditingDetailsArray[23] . "</td>\n";
   $MainContent .="          <td><input type=\"number\" name=\"IMAGES_DIRECTORY_DEPTH\" min=\"1\" max=\"9\" size=\"1\" value=\"" . $ImageEditingDirectoryDepth ."\"></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\" class=\"center\"><input type=\"submit\" name=\"IMAGE_EDITING_SEARCH_SUBMIT\" value=\"" . $ImageEditingDetailsArray[25] . "\"></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\"><hr></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .= $ImageEditingOutputHtml;
   $MainContent .="      </table>\n";
   $MainContent .="    </form>\n";
   return $MainContent;
}

// CSS - Navigation: IMAGE EDITING
function create_image_editing_css() {
   $ImageEditingCSS="h3 {\n  font-size: 1.15em;\n  font-weight: bold;\n  text-align: center;\n}\n\n";
   $ImageEditingCSS .="table { width: 100%; }\n\n";
   $ImageEditingCSS .=".table_result {\n  display: flex;\n  justify-content: left;\n  border-collapse: collapse;\n}\n\n";
   $ImageEditingCSS .=".table_no_result {\n  width: 100%;\n  text-align: center;\n}\n\n";
   $ImageEditingCSS .="td { font-size: 0.9em; }\n\n";
   $ImageEditingCSS .="hr { width: 100%; }\n\n";
   $ImageEditingCSS .="input { font-size: 0.85em; }\n\n";
   $ImageEditingCSS .=".column_wide { width: 20%; }\n\n";
   $ImageEditingCSS .=".column_help_text {\n  width: 35%;\n  vertical-align: top;\n}\n\n";
   $ImageEditingCSS .=".red {\n  font-size: 0.95em;\n  font-weight: bold;\n  text-align: center;\n  color:#DD0000;\n}\n\n";
   $ImageEditingCSS .=".right { text-align: right; }\n\n";
   return $ImageEditingCSS;
}

// Erstellung der Webseite  ACCESS-AUTHORITY
function create_access_authority($AccessAuthorityArray='', $AccessDetailsArray='', $AccessAuthorityNoExecFunctionMessages='') {
   $ReturnCode=0;
   $AccessAuthorityTestFile='test.txt';
   $AccessAuthorityTestDirectory = 'test_dir';
   $AccessAuthorityTestDirectoryPath = './' . $AccessAuthorityTestDirectory;
   $AccessAuthorityTestFilePath = './' . $AccessAuthorityTestDirectory . '/' . $AccessAuthorityTestFile;
   $DirectoryOwnerName='no value';
   $DirectoryGroupName='no value';
   $FileOwnerName='no value';
   $FileGroupName='no value';
   $PermissionFileOutput='no value';
   $PermissionDirectoryOutput='no value';
   $OutputNoValue='no value';
   $OutputFileLs='';
   $OutputDirectoryLs='';
   $AccessAuthorityMessages='';
   $AccessAuthorityOutputHtml='';
   $AccessAuthorityMessagesHtml='';
   $MessagesAdd='';
   if(empty($AccessDetailsArray[1])) $AccessDetailsArray[1]=0;
   if(empty($AccessDetailsArray[2])) $AccessDetailsArray[2]=0;
   $AccessAuthorityArrayDefaultCount=1; // Vorgabe: Anzahl der Array-Elemente
   $AccessAuthorityArrayCurrentCount=count($AccessAuthorityArray);
   $AccessDetailsArrayDefaultCount=16; // Vorgabe: Anzahl der Array-Elemente
   $AccessDetailsArrayCurrentCount=count($AccessDetailsArray);
   if(isset($AccessAuthorityArray) &&
      is_array($AccessAuthorityArray) &&
      $AccessAuthorityArrayDefaultCount == $AccessAuthorityArrayCurrentCount &&
      isset($AccessDetailsArray) &&
      is_array($AccessDetailsArray) &&
      $AccessDetailsArrayDefaultCount == $AccessDetailsArrayCurrentCount) {
      if(!empty($AccessAuthorityArray[0])) {
         if(!is_dir($AccessAuthorityTestDirectory) && $ReturnCode == 0) {
            @mkdir($AccessAuthorityTestDirectory) or $ReturnCode=1;
            if($ReturnCode == 1) {
               $AccessAuthorityMessages = 'ACCESS AUTHORITY - ERROR 01: CAN NOT CREATE DIRECTORY - ' . $AccessAuthorityTestDirectory . ' !';
            }
         }
         if(!file_exists($AccessAuthorityTestFilePath) && $ReturnCode == 0) {
            @touch($AccessAuthorityTestFilePath) or $ReturnCode=2;
            if($ReturnCode == 2) {
               $AccessAuthorityMessages = 'ACCESS AUTHORITY - ERROR 02: CAN NOT CREATE FILE - ' . $AccessAuthorityTestFilePath . ' !';
            }
         }
         if(is_dir($AccessAuthorityTestDirectory) &&
            is_readable($AccessAuthorityTestDirectory) &&
            file_exists($AccessAuthorityTestFilePath) &&
            is_readable($AccessAuthorityTestFilePath) &&
            $ReturnCode == 0) {
            $StatDirectoryArray = @stat($AccessAuthorityTestFilePath) or $ReturnCode=3;
            $StatFileArray = @stat($AccessAuthorityTestFilePath) or $ReturnCode=4;
            if($ReturnCode == 3) {
               $AccessAuthorityMessages = 'ACCESS AUTHORITY - ERROR 03: CAN NOT CREATE ARRAY (StatDirectoryArray) !';
            } elseif($ReturnCode == 4) {
               $AccessAuthorityMessages = 'ACCESS AUTHORITY - ERROR 04: CAN NOT CREATE ARRAY (StatFileArray) !';
            }
            else
            {
               $DirectoryOwnerId = $StatDirectoryArray[4];
               $DirectoryGroupId = $StatDirectoryArray[5];
               if($PosixGetPwuidDirectoryArray = @posix_getpwuid($DirectoryOwnerId)) {
                  $PosixGetPwuidDirectoryArrayCount = count($PosixGetPwuidDirectoryArray);
                  for($x=0; $x<$PosixGetPwuidDirectoryArrayCount; $x++) {
                     $Key1 = key($PosixGetPwuidDirectoryArray);
                     if(strcasecmp($Key1, "name") == 0) {
                        $DirectoryOwnerName = $PosixGetPwuidDirectoryArray[$Key1];
                        break;
                     }
                     next($PosixGetPwuidDirectoryArray);
                  }
               }
               if($PosixGetGrgidDirectoryArray = @posix_getgrgid($DirectoryGroupId)) {
                  $PosixGetGrgidDirectoryArrayCount = count($PosixGetGrgidDirectoryArray);
                  for($x=0; $x<$PosixGetGrgidDirectoryArrayCount; $x++) {
                     $Key2 = key($PosixGetGrgidDirectoryArray);
                     if(strcasecmp($Key2, "name") == 0) {
                        $DirectoryGroupName = $PosixGetGrgidDirectoryArray[$Key2];
                        break;
                     }
                     next($PosixGetGrgidDirectoryArray);
                  }
               }
               $FileOwnerId = $StatFileArray[4];
               $FileGroupId = $StatFileArray[5];
               if($PosixGetPwuidFileArray = @posix_getpwuid($FileOwnerId)) {
                  $PosixGetPwuidFileArrayCount = count($PosixGetPwuidFileArray);
                  for($x=0; $x<$PosixGetPwuidFileArrayCount; $x++) {
                     $Key1 = key($PosixGetPwuidFileArray);
                     if(strcasecmp($Key1, "name") == 0) {
                        $FileOwnerName = $PosixGetPwuidFileArray[$Key1];
                        break;
                     }
                     next($PosixGetPwuidFileArray);
                  }
               }
               if($PosixGetGrgidFileArray = @posix_getgrgid($FileGroupId)) {
                  $PosixGetGrgidFileArrayCount = count($PosixGetGrgidFileArray);
                  for($x=0; $x<$PosixGetGrgidFileArrayCount; $x++) {
                     $Key2 = key($PosixGetGrgidFileArray);
                     if(strcasecmp($Key2, "name") == 0) {
                        $FileGroupName = $PosixGetGrgidFileArray[$Key2];
                        break;
                     }
                     next($PosixGetGrgidFileArray);
                  }
               }
               $FunctionsDisable=@ini_get('disable_functions');
               if(!preg_match("/exec/",$FunctionsDisable)) {
                  $OutputDirectoryLs = @exec("ls -ld $AccessAuthorityTestDirectory");
                  $OutputFileLs = @exec("ls -l $AccessAuthorityTestDirectory");
                  if($OutputDirectoryLs == "") $OutputDirectoryLs = $OutputNoValue;
                  if($OutputFileLs == "") $OutputFileLs = $OutputNoValue;
               }
               else
               {
               $OutputDirectoryLs = $AccessAuthorityNoExecFunctionMessages;
               $OutputFileLs = $AccessAuthorityNoExecFunctionMessages;
               }
               if(file_exists($AccessAuthorityTestFilePath) && is_readable($AccessAuthorityTestFilePath)) {
                  $PermissionFile = @fileperms($AccessAuthorityTestFilePath) or $ReturnCode=5;
                  if($ReturnCode == 5) {
                     $AccessAuthorityMessages = 'ACCESS AUTHORITY - ERROR 05: CAN NOT TO DETECT PERMISSION - ' . $AccessAuthorityTestFilePath . ' !';
                  }
                  else
                  {
                     $DecoctPermissionFile = decoct($PermissionFile);
                     $PermissionFileOutput = substr($DecoctPermissionFile, -4);
                  }
                  @unlink($AccessAuthorityTestFilePath) or $ReturnCode=6;
                  if($ReturnCode == 6) {
                     if(!empty($AccessAuthorityMessages)) $MessagesAdd = '<br>';
                     $AccessAuthorityMessages = $AccessAuthorityMessages . $MessagesAdd . 'ACCESS AUTHORITY - ERROR 06: CAN NOT DELETE FILE - ' . $AccessAuthorityTestFilePath . ' !';
                  }
               }
               if(is_dir($AccessAuthorityTestDirectory) && is_readable($AccessAuthorityTestDirectory)) {
                  $PermissionDirectory = @fileperms($AccessAuthorityTestDirectory) or $ReturnCode=7;
                  if($ReturnCode == 7) {
                     if(!empty($AccessAuthorityMessages)) $MessagesAdd = '<br>';
                     $AccessAuthorityMessages = $AccessAuthorityMessages . $MessagesAdd . 'ACCESS AUTHORITY - ERROR 07: CAN NOT TO DETECT PERMISSION - ' . $AccessAuthorityTestDirectory . ' !';
                  }
                  else
                  {
                     $DecoctPermissionDirectory = decoct($PermissionDirectory);
                     $PermissionDirectoryOutput = substr($DecoctPermissionDirectory, -4);
                  }
                  @rmdir($AccessAuthorityTestDirectory) or $ReturnCode=8;
                  if($ReturnCode == 8) {
                     if(!empty($AccessAuthorityMessages)) $MessagesAdd = '<br>';
                     $AccessAuthorityMessages = $AccessAuthorityMessages . $MessagesAdd . 'ACCESS AUTHORITY - ERROR 08: CAN NOT DELETE DIRECTORY - ' . $AccessAuthorityTestDirectory . ' !';
                  }
               }
            }
         }
         clearstatcache();
         $AccessAuthorityOutputHtml .="        <tr>\n";
         $AccessAuthorityOutputHtml .="          <th class=\"column_wide\">&nbsp;</th>\n";
         $AccessAuthorityOutputHtml .="          <th><strong>" . $AccessDetailsArray[5] . "</strong></th>\n";
         $AccessAuthorityOutputHtml .="          <th class=\"column_wide\">&nbsp;</th>\n";
         $AccessAuthorityOutputHtml .="        </tr>\n";
         $AccessAuthorityOutputHtml .="        <tr>\n";
         $AccessAuthorityOutputHtml .="          <td>&nbsp;</td>\n";
         $AccessAuthorityOutputHtml .="          <td>\n";
         $AccessAuthorityOutputHtml .="            <ul>\n";
         $AccessAuthorityOutputHtml .="              <li>" . $AccessDetailsArray[6] . " " . $DirectoryOwnerName . "</li>\n";
         $AccessAuthorityOutputHtml .="              <li>" . $AccessDetailsArray[7] . " " . $DirectoryGroupName . "</li>\n";
         $AccessAuthorityOutputHtml .="              <li>" . $AccessDetailsArray[8] . " " . $FileOwnerName . "</li>\n";
         $AccessAuthorityOutputHtml .="              <li>" . $AccessDetailsArray[9] . " " . $FileGroupName . "</li>\n";
         $AccessAuthorityOutputHtml .="              <li>" . $AccessDetailsArray[10] . " " . $OutputDirectoryLs . "</li>\n";
         $AccessAuthorityOutputHtml .="              <li>" . $AccessDetailsArray[11] . " " . $OutputFileLs . "</li>\n";
         $AccessAuthorityOutputHtml .="            </ul>\n";
         $AccessAuthorityOutputHtml .="          </td>\n";
         $AccessAuthorityOutputHtml .="          <td>&nbsp;</td>\n";
         $AccessAuthorityOutputHtml .="        </tr>\n";
         $AccessAuthorityOutputHtml .="        <tr>\n";
         $AccessAuthorityOutputHtml .="          <td colspan=\"3\">&nbsp;</td>\n";
         $AccessAuthorityOutputHtml .="        </tr>\n";
         $AccessAuthorityOutputHtml .="        <tr>\n";
         $AccessAuthorityOutputHtml .="          <th>&nbsp;</th>\n";
         $AccessAuthorityOutputHtml .="          <th>" . $AccessDetailsArray[12] . "</th>\n";
         $AccessAuthorityOutputHtml .="          <th>&nbsp;</th>\n";
         $AccessAuthorityOutputHtml .="        </tr>\n";
         $AccessAuthorityOutputHtml .="        <tr>\n";
         $AccessAuthorityOutputHtml .="          <td>&nbsp;</td>\n";
         $AccessAuthorityOutputHtml .="          <td>\n";
         $AccessAuthorityOutputHtml .="            <ul>\n";
         $AccessAuthorityOutputHtml .="              <li>" . $AccessDetailsArray[13] . " " . $PermissionDirectoryOutput . "</li>\n";
         $AccessAuthorityOutputHtml .="              <li>" . $AccessDetailsArray[14] . " " . $PermissionFileOutput . "</li>\n";
         $AccessAuthorityOutputHtml .="            </ul>\n";
         $AccessAuthorityOutputHtml .="          </td>\n";
         $AccessAuthorityOutputHtml .="          <td>&nbsp;</td>\n";
         $AccessAuthorityOutputHtml .="        </tr>\n";
         if(!empty($AccessAuthorityMessages)) {
            $AccessAuthorityMessagesHtml .="        <tr>\n";
            $AccessAuthorityMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $AccessAuthorityMessages . "</td>\n";
            $AccessAuthorityMessagesHtml .="        </tr>\n";
            $AccessAuthorityMessagesHtml .="        <tr>\n";
            $AccessAuthorityMessagesHtml .="          <td colspan=\"3\"><hr></td>\n";
            $AccessAuthorityMessagesHtml .="        </tr>\n";
         }
      }
   } elseif(!isset($AccessAuthorityArray) ||
      !is_array($AccessAuthorityArray) ||
      $AccessAuthorityArrayDefaultCount != $AccessAuthorityArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY AccessAuthorityArray (ARRAY-COUNT) - function <strong>create_access_authority</strong> - IS DAMAGED!';
      exit;
   }
   else
   {
      print 'NOTE: SYSTEM-ARRAY AccessDetailsArray (ARRAY-COUNT) - function <strong>create_access_authority</strong> - IS DAMAGED!';
      exit;
   }
   $MainContent="    <form name=\"form_access_authority\" method=\"post\" action=\"" . $AccessDetailsArray[0] . "?OBELIX_ID=" . $AccessDetailsArray[1] . "&ACCESS_ID=" . $AccessDetailsArray[2] . "\" target=\"_self\">\n";
   $MainContent .="      <table>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\" class=\"center\"><h3>" . $AccessDetailsArray[3] . "</h3></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">" . $AccessDetailsArray[4] . "</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\"><hr></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .= $AccessAuthorityMessagesHtml;
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .= $AccessAuthorityOutputHtml;
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\" class=\"center\"><input type=\"submit\" name=\"ACCESS_AUTHORITY_SUBMIT\" value=\"" . $AccessDetailsArray[15] . "\"></td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="        <tr>\n";
   $MainContent .="          <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="        </tr>\n";
   $MainContent .="      </table>\n";
   $MainContent .="    </form>\n";
   return $MainContent;
}

// CSS - Navigation: ACCESS-AUTHORITY
function create_access_authority_css() {
   $AccessAuthorityCSS="h3 {\n  font-size: 1.15em;\n  font-weight: bold;\n  text-align: center;\n}\n\n";
   $AccessAuthorityCSS .="table { width: 100%; }\n\n";
   $AccessAuthorityCSS .="td { font-size: 0.9em; }\n\n";
   $AccessAuthorityCSS .="hr { width: 100%; }\n\n";
   $AccessAuthorityCSS .="input { font-size: 0.85em; }\n\n";
   $AccessAuthorityCSS .=".column_wide { width: 25%; }\n\n";
   $AccessAuthorityCSS .=".red {\n  font-size: 0.95em;\n  font-weight: bold;\n  text-align: center;\n  color:#DD0000;\n}\n\n";
   $AccessAuthorityCSS .=".right { text-align: right; }\n\n";
   return $AccessAuthorityCSS;
}

// Erstellung der Webseite CREATE-FILE
function create_create_file($FileTypeArray='', $FileTypeSelectedArray='', $CreateFileArray='', $CreateFileDetailsArray='', $CreateFileMessagesArray='') {
   $WorkDir=getcwd();
   $BaseFileName='';
   $CreateFileMessages='';
   $CreateFileHtmlTableContent='';
   if(empty($CreateFileDetailsArray[1])) $CreateFileDetailsArray[1]=0;
   if(empty($CreateFileDetailsArray[2])) $CreateFileDetailsArray[2]=0;
   if(empty($CreateFileDetailsArray[3])) $CreateFileDetailsArray[3]=0;
   $FileTypeArrayDefaultCount=7; // Vorgabe: Anzahl der Array-Elemente
   $FileTypeArrayCurrentCount=count($FileTypeArray);
   $FileTypeSelectedArrayDefaultCount=7; // Vorgabe: Anzahl der Array-Elemente
   $FileTypeSelectedArrayCurrentCount=count($FileTypeSelectedArray);
   $CreateFileArrayDefaultCount=3; // Vorgabe: Anzahl der Array-Elemente
   $CreateFileArrayCurrentCount=count($CreateFileArray);
   $CreateFileDetailsArrayDefaultCount=23; // Vorgabe: Anzahl der Array-Elemente
   $CreateFileDetailsArrayCurrentCount=count($CreateFileDetailsArray);
   $CreateFileMessagesArrayDefaultCount=5; // Vorgabe: Anzahl der Array-Elemente
   $CreateFileMessagesArrayCurrentCount=count($CreateFileMessagesArray);
   if(isset($FileTypeArray) &&
      is_array($FileTypeArray) &&
      $FileTypeArrayDefaultCount == $FileTypeArrayCurrentCount &&
      isset($FileTypeSelectedArray) &&
      is_array($FileTypeSelectedArray) &&
      $FileTypeSelectedArrayDefaultCount == $FileTypeSelectedArrayCurrentCount &&
      isset($CreateFileArray) &&
      is_array($CreateFileArray) &&
      $CreateFileArrayDefaultCount == $CreateFileArrayCurrentCount &&
      isset($CreateFileDetailsArray) &&
      is_array($CreateFileDetailsArray) &&
      $CreateFileDetailsArrayDefaultCount == $CreateFileDetailsArrayCurrentCount &&
      isset($CreateFileMessagesArray) &&
      is_array($CreateFileMessagesArray) &&
      $CreateFileMessagesArrayDefaultCount == $CreateFileMessagesArrayCurrentCount) {
      if(!empty($CreateFileArray[0]) &&
         !empty($CreateFileArray[1]) &&
         !empty($CreateFileArray[2]) &&
         isset($FileTypeArray) &&
         is_array($FileTypeArray) &&
         isset($FileTypeSelectedArray) &&
         is_array($FileTypeSelectedArray)) {
         $BaseFileName=$CreateFileArray[1];
         $CreateFileName = "./" . $CreateFileArray[1] . "." . $CreateFileArray[2];
         $FileTypeArrayCount = count($FileTypeArray);
         for($x=0; $x<$FileTypeArrayCount; $x++){
            if(strcmp($FileTypeArray[$x], $CreateFileArray[2]) == 0) {
               $FileTypeSelectedArray[0] = '';
               $FileTypeSelectedArray[$x] = ' selected';
               break;
            }
         }
         $CreateHyperlinkName = "<a href=\"./" . $CreateFileName . "\" target=\"FILEVIEWER\" class=\"center\">" . $CreateFileDetailsArray[9] . " (" . $CreateFileName . ")</a>";
         $EditorFileNname = "<a href=\"" . $CreateFileDetailsArray[0] . "?OBELIX_ID=" . $CreateFileDetailsArray[3] . "&ACCESS_ID=" . $CreateFileDetailsArray[2] . "&GET_FILENAME=" . $CreateFileName . "\" target=\"EDITOR\">" . $CreateFileDetailsArray[10] . " (" . $CreateFileName . ")</a>\n";
         $CreateFileHtmlTableContent .="            <tr>\n";
         $CreateFileHtmlTableContent .="              <td colspan=\"3\">&nbsp;</td>\n";
         $CreateFileHtmlTableContent .="            </tr>\n";
         if(file_exists($CreateFileName)) {
            $CreateFileMessages = $CreateFileMessagesArray[0];
            $CreateFileHtmlTableContent .="            <tr>\n";
            $CreateFileHtmlTableContent .="              <td class=\"right\">" . $CreateFileDetailsArray[9] . "&nbsp;&nbsp;&nbsp;</td>\n";
            $CreateFileHtmlTableContent .="              <td colspan=\"2\">" . $CreateHyperlinkName . "&nbsp;&nbsp;&nbsp;</td>\n";
            $CreateFileHtmlTableContent .="            </tr>\n";
            $CreateFileHtmlTableContent .="            <tr>\n";
            $CreateFileHtmlTableContent .="              <td class=\"right\">" . $CreateFileDetailsArray[10] . "&nbsp;&nbsp;&nbsp;</td>\n";
            $CreateFileHtmlTableContent .="              <td colspan=\"2\">" . $EditorFileNname . "&nbsp;&nbsp;&nbsp;</td>\n";
            $CreateFileHtmlTableContent .="            </tr>\n";
            $CreateFileHtmlTableContent .="            <tr>\n";
            $CreateFileHtmlTableContent .="              <td colspan=\"3\">&nbsp;</td>\n";
            $CreateFileHtmlTableContent .="            </tr>\n";
         } elseif(preg_match("@^([a-zA-Z0-9_]{1,128})$@", $BaseFileName) &&
                  preg_match("@^(\./)([a-zA-Z0-9_]{1,128})(\.)([a-zA-Z0-9\.]{1,8})$@", $CreateFileName)) {
            if(is_writeable('./')) {
               if(@touch($CreateFileName)) {
                  chmod($CreateFileName, $CreateFileDetailsArray[12]);
                  if($FileWrite = @fopen($CreateFileName,'w')) {
                     @flock($FileWrite,2);
                     @fwrite($FileWrite, $CreateFileDetailsArray[11]);
                     @flock($FileWrite,3);
                     @fclose($FileWrite);
                     $CreateFileHtmlTableContent .="            <tr>\n";
                     $CreateFileHtmlTableContent .="              <td class=\"right\">" . $CreateFileDetailsArray[9] . "&nbsp;&nbsp;&nbsp;</td>\n";
                     $CreateFileHtmlTableContent .="              <td colspan=\"2\">" . $CreateHyperlinkName . "&nbsp;&nbsp&nbsp;</td>\n";
                     $CreateFileHtmlTableContent .="            </tr>\n";
                     $CreateFileHtmlTableContent .="            <tr>\n";
                     $CreateFileHtmlTableContent .="              <td class=\"right\">" . $CreateFileDetailsArray[10] . "&nbsp;&nbsp;&nbsp;</td>\n";
                     $CreateFileHtmlTableContent .="              <td colspan=\"2\">" . $EditorFileNname . "&nbsp;&nbsp&nbsp;</td>\n";
                     $CreateFileHtmlTableContent .="            </tr>\n";
                     $CreateFileHtmlTableContent .="            <tr>\n";
                     $CreateFileHtmlTableContent .="              <td colspan=\"3\">&nbsp;</td>\n";
                     $CreateFileHtmlTableContent .="            </tr>\n";
                  }
                  else
                  {
                  $CreateFileMessages = $CreateFileMessagesArray[1] . " " . $CreateFileName;
                  }
               }
               else
               {
               $CreateFileMessages = $CreateFileMessagesArray[2] . " " . $CreateFileName;
               }
            }
            else
            {
            $CreateFileMessages = $CreateFileMessagesArray[3];
            }
         }
         else
         {
         $CreateFileMessages = $CreateFileMessagesArray[4];
         }
      }
   } elseif(!isset($FileTypeArray) ||
      !is_array($FileTypeArray) ||
      $FileTypeArrayDefaultCount != $FileTypeArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY FileTypeArray (ARRAY-COUNT) - function <strong>create_create_file</strong> - IS DAMAGED!';
      exit;
   } elseif(!isset($FileTypeSelectedArray) ||
      !is_array($FileTypeSelectedArray) ||
      $FileTypeSelectedArrayDefaultCount != $FileTypeSelectedArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY FileTypeSelectedArray (ARRAY-COUNT) - function <strong>create_create_file</strong> - IS DAMAGED!';
      exit;
   } elseif(!isset($CreateFileArray) ||
      !is_array($CreateFileArray) ||
      $CreateFileArrayDefaultCount != $CreateFileArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY CreateFileArray (ARRAY-COUNT) - function <strong>create_create_file</strong> - IS DAMAGED!';
      exit;
   } elseif(!isset($CreateFileDetailsArray) ||
      !is_array($CreateFileDetailsArray) ||
      $CreateFileDetailsArrayDefaultCount != $CreateFileDetailsArrayCurrentCount) {
      print 'NOTE: SYSTEM-ARRAY CreateFileDetailsArray (ARRAY-COUNT) - function <strong>create_create_file</strong> - IS DAMAGED!';
      exit;
   }
   else
   {
      print 'NOTE: SYSTEM-ARRAY CreateFileMessagesArray (ARRAY-COUNT) - function <strong>create_create_file</strong> - IS DAMAGED!';
      exit;
   }
   $MainContent="  <form name=\"form_create_file\" method=\"post\" action=\"" . $CreateFileDetailsArray[0] . "?OBELIX_ID=" . $CreateFileDetailsArray[1] . "&ACCESS_ID=" . $CreateFileDetailsArray[2] . "\" target=\"_self\">\n";
   $MainContent .="    <table class=\"table_main\">\n";
   $MainContent .="      <tr>\n";
   $MainContent .="        <td colspan=\"3\" class=\"center\"><h3>" . $CreateFileDetailsArray[4] . "</h3></td>\n";
   $MainContent .="      </tr>\n";
   $MainContent .="      <tr>\n";
   $MainContent .="        <td colspan=\"3\">" . $CreateFileDetailsArray[5] . "</td>\n";
   $MainContent .="      </tr>\n";
   $MainContent .="      <tr>\n";
   $MainContent .="        <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="      </tr>\n";
   $MainContent .="      <tr>\n";
   $MainContent .="        <td colspan=\"3\"><hr></td>\n";
   $MainContent .="      </tr>\n";
   $MainContent .="      <tr>\n";
   $MainContent .="        <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="      </tr>\n";
   $MainContent .="      <tr>\n";
   $MainContent .="        <td colspan=\"3\" class=\"center\"><strong>" . $CreateFileDetailsArray[7] . ": </strong>" . $WorkDir . "</td>\n";
   $MainContent .="      </tr>\n";
   $MainContent .="      <tr>\n";
   $MainContent .="        <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="      </tr>\n";
   $MainContent .="      <tr>\n";
   $MainContent .="        <td colspan=\"3\">\n";
   $MainContent .="          <table class=\"table_subordinate\">\n";
   $MainContent .="            <tr>\n";
   $MainContent .="              <td class=\"right_bold\">" . $CreateFileDetailsArray[8] . "</td>\n";
   $MainContent .="              <td><input type=\"text\" name=\"CREATE_FILE_NAME\" value=\"" . $BaseFileName . "\" size=\"35\" maxlength=\"128\"></td>\n";
   $MainContent .="              <td>\n";
   $MainContent .="                <select size=\"1\" name=\"CREATE_FILE_TYPE\">\n";
   $MainContent .="                  <option value=\"" . $FileTypeArray[0] . "\"" . $FileTypeSelectedArray[0] . ">." . $FileTypeArray[0] . "</option>\n                  <option value=\"" . $FileTypeArray[1] . "\"" . $FileTypeSelectedArray[1] . ">." . $FileTypeArray[1] . "</option>\n                  <option value=\"" . $FileTypeArray[2] . "\"" . $FileTypeSelectedArray[2] . ">." . $FileTypeArray[2] . "</option>\n                  <option value=\"" . $FileTypeArray[3] . "\"" . $FileTypeSelectedArray[3] . ">." . $FileTypeArray[3] . "</option>\n                  <option value=\"" . $FileTypeArray[4] . "\"" . $FileTypeSelectedArray[4] . ">." . $FileTypeArray[4] . "</option>\n                  <option value=\"" . $FileTypeArray[5] . "\"" . $FileTypeSelectedArray[5] . ">." . $FileTypeArray[5] . "</option>\n                  <option value=\"" . $FileTypeArray[6] . "\"" . $FileTypeSelectedArray[6] . ">." . $FileTypeArray[6] . "</option>\n";
   $MainContent .="                </select>\n";
   $MainContent .="              </td>\n";
   $MainContent .="            <tr>\n";
   $MainContent .="              <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="            </tr>\n";
   $MainContent .="            <tr>\n";
   $MainContent .="              <td colspan=\"3\" class=\"red\">" . $CreateFileMessages . "</td>\n";
   $MainContent .="            </tr>\n";
   $MainContent .= $CreateFileHtmlTableContent;
   $MainContent .="          </table>\n";
   $MainContent .="        </td>\n";
   $MainContent .="      </tr>\n";
   $MainContent .="      <tr>\n";
   $MainContent .="        <td colspan=\"3\" class=\"center\">&nbsp;</td>\n";
   $MainContent .="      </tr>\n";
   $MainContent .="      <tr>\n";
   $MainContent .="        <td colspan=\"3\" class=\"center\"><input type=\"submit\" name=\"CREATE_FILE_SUBMIT\" value=\"" . $CreateFileDetailsArray[6] . "\"></td>\n";
   $MainContent .="      </tr>\n";
   $MainContent .="      <tr>\n";
   $MainContent .="        <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="      </tr>\n";
   $MainContent .="      <tr>\n";
   $MainContent .="        <td colspan=\"3\"><hr></td>\n";
   $MainContent .="      </tr>\n";
   $MainContent .="      <tr>\n";
   $MainContent .="        <td colspan=\"3\">&nbsp;</td>\n";
   $MainContent .="      </tr>\n";
   $MainContent .="      <tr>\n";
   $MainContent .="        <td class=\"vertical_top_1\"><strong>" . $CreateFileDetailsArray[13] . "</strong>\n<br> &lt;?php\n<br> &#36;current_date_time = date(&quot;l dS of F Y h:i:s A&quot;);\n<br> ?&gt;\n<br> &lt;!DOCTYPE html&gt;\n<br> &lt;html&gt;\n<br> &lt;head&gt;\n<br> &lt;title&gt;Obelix&lt;/title&gt;\n<br> &lt;meta http-equiv=&quot;content-type&quot; content=&quot;text/html; charset=utf-8&quot;&gt;\n<br> &lt;style type=&quot;text/css&quot;&gt;\n<br> &lt;!--\n<br> body {\n<br> margin:10px 15px 15px 10px;\n<br>  font-family:&quot;Nimbus Roman No9 L&quot;,&quot;Times New Roman&quot;;\n<br> background-color:#FFFFFF;\n<br> color:#000000;\n<br> }\n<br> --&gt;\n<br> &lt;/style&gt;\n<br> &lt;/head&gt;\n<br> &lt;body&gt;\n<br> &lt;h1&gt;HELLO WORLD&lt;/h1&gt;\n<br> \n<br> &lt;?php echo &#36;current_date_time; ?&gt;\n<br> \n<br> &lt;/body&gt;\n<br> &lt;/html&gt;<br><br> " . $CreateFileDetailsArray[17] . "</td>\n";
   $MainContent .="        <td class=\"vertical_top_1\"><strong>" . $CreateFileDetailsArray[14] . "</strong>\n<br> &lt;?php\n<br> &#36;obelix_source_file_name=\"./obelix5.php\";\n<br> &#36;obelix_target_file_name=\"obelix5.php\";\n<br> &#36;obelix_target_directory=\"../\";\n<br> &#36;obelix_new_filepath=&#36;obelix_target_directory . &#36;obelix_target_file_name;\n<br> &#36;file_content_array=file(&#36;obelix_source_file_name);\n<br> if(is_writeable(&#36;obelix_target_directory)) {\n<br> &nbsp;&nbsp;&nbsp;&#36;file_content_array_count=count(&#36;file_content_array);\n<br> &nbsp;&nbsp;&nbsp;&#36;obelix_target_content='';\n<br> &nbsp;&nbsp;&nbsp;for(&#36;x=0; &#36;x<&#36;file_content_array_count; &#36;x++) {\n<br> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&#36;obelix_target_content .= &#36;file_content_array[&#36;x];\n<br> &nbsp;&nbsp;&nbsp;}\n<br> &nbsp;&nbsp;&nbsp;if(touch(&#36;obelix_new_filepath)) {\n<br> &nbsp;&nbsp;&nbsp;chmod(&#36;obelix_new_filepath, 0644);\n<br> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;if(&#36;datei_w = @fopen(&#36;obelix_new_filepath,'w')) {\n<br> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;@flock(&#36;datei_w,2);\n<br> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;@fwrite(&#36;datei_w,&#36;obelix_target_content);\n<br> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;@flock(&#36;datei_w,3);\n<br> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;@fclose(&#36;datei_w);\n<br> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;echo \"" . $CreateFileDetailsArray[18] . "\";\n<br> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}\n<br> &nbsp;&nbsp;&nbsp;}\n<br> &nbsp;&nbsp;&nbsp;else\n<br> &nbsp;&nbsp;&nbsp;{\n<br> &nbsp;&nbsp;&nbsp;echo \"" . $CreateFileDetailsArray[19] . "\";\n<br> &nbsp;&nbsp;&nbsp;}\n<br> }\n<br> else\n<br> {\n<br> echo \"" . $CreateFileDetailsArray[20] . "\";\n<br> }\n<br> ?&gt;\n<br><br></td>\n";
   $MainContent .="        <td class=\"vertical_top_2\"><strong>" . $CreateFileDetailsArray[15] . "</strong>\n<br> &lt;?php\n<br> print &quot;&lt;pre&gt;&quot;;\n<br> print_r(get_loaded_extensions());\n<br> print &quot;&lt;/pre&gt;&quot;;\n<br> ?&gt;\n<br><br><strong>" . $CreateFileDetailsArray[16] . "</strong>\n<br> " . $CreateFileDetailsArray[22] . "\n<br><br>" . $CreateFileDetailsArray[21] . "</td>\n";
   $MainContent .="      </tr>\n";
   $MainContent .="      <tr>\n";
   $MainContent .="        <td colspan=\"2\">&nbsp;</td>\n";
   $MainContent .="      </tr>\n";
   $MainContent .="    </table>\n";
   $MainContent .="    </form>\n";
   return $MainContent;
}

// CSS - Navigation: CREATE-FILE
function create_create_file_css() {
   $CreateFileCSS="h3 {\n  font-size: 1.15em;\n  font-weight: bold;\n}\n\n";
   $CreateFileCSS .=".table_main { width: 100%; }\n\n";
   $CreateFileCSS .="td { font-size: 0.9em; }\n\n";
   $CreateFileCSS .="hr { width: 100%; }\n\n";
   $CreateFileCSS .="input { font-size: 0.85em; }\n\n";
   $CreateFileCSS .=".table_subordinate {\n  display: flex;\n  justify-content: center;\n  align-content: center;\n}\n\n";
   $CreateFileCSS .=".vertical_top_1 {\n  width: 30%;\n  font-size: 0.9em;\n  vertical-align:top;\n}\n\n";
   $CreateFileCSS .=".vertical_top_2 {\n  width: 40%;\n  font-size: 0.9em;\n  vertical-align:top;\n}\n\n";
   $CreateFileCSS .=".red {\n  font-size: 0.95em;\n  font-weight: bold;\n  text-align: center;\n  color:#DD0000;\n}\n\n";
   $CreateFileCSS .=".right_bold {\n  font-size: 0.95em;\n  font-weight: bold;\n}\n\n";
   $CreateFileCSS .=".right { text-align: right; }\n\n";
   return $CreateFileCSS;
}

// Erstellung der Webseite HOST-INTRUSION-DETECTION
function create_host_intrusion_detection($ObelixFileNameArray='', $HostIntrusionDetectionArray='', $HostIntrusionDetectionGeneralSurveyTitlesArray='', $HostIntrusionDetectionResultTableTitlesArray='', $HostIntrusionDetectionMd5StatusNoteArray='', $HostIntrusionDetectionDetailsArray='', $HostIntrusionDetectionMessagesArray='', $HostIntrusionDetectionCreateDatabaseReturncodeMessagesArray='', $HostIntrusionDetectionConfigurationDatabaseReturncodeMessagesArray='', $HostIntrusionDetectionReportDatabaseReturncodeMessagesArray='', $HostIntrusionDetectionIdsDatabaseReturncodeMessagesArray='', $HostIntrusionDetectionExclusionDirectoryReturncodeMessagesArray='', $HostIntrusionDetectionExclusionFileReturncodeMessagesArray='', $HostIntrusionDetectionDatabaseCheckReturncodeMessagesArray='') {
   $HostIntrusionDetectionMessagesHtml='';
   $HostIntrusionDetectionDatabaseOutputHtml='';
   $HostIntrusionDetectionMonitoringDirectoryPath='';
   $HostIntrusionDetectionTextareaContent='';
   $HostIntrusionDetectionOptionUpdateChecked=' checked';
   $HostIntrusionDetectionOptionUpgradeChecked='';
   $HostIntrusionDetectionOptionDeleteChecked='';
   $HostIntrusionDetectionCurrentWorkDirectory = getcwd();
   $IdsDatabaseSelectionHtml='';
   if(empty($HostIntrusionDetectionDetailsArray[0])) $HostIntrusionDetectionDetailsArray[0]=0;
   if(empty($HostIntrusionDetectionDetailsArray[1])) $HostIntrusionDetectionDetailsArray[1]=0;
   if(empty($HostIntrusionDetectionDetailsArray[9])) $HostIntrusionDetectionDetailsArray[9]=8;
   $InputFieldDirectoryExclusionArray=array('', '', '', '', '');
   $InputFieldFileExclusionArray=array('', '', '', '', '');
   // nachfolgende 5 Arrays enthalten die Dateinamen der Datenbanken
   $HostIntrusionDetectionDatabaseFilenameArray=array('hids_db_1.dat', 'hids_db_2.dat', 'hids_db_3.dat', 'hids_db_4.dat'); // maximal 9 Eintraege
   $HostIntrusionDetectionDatabaseConfigurationFilenameArray=array('configuration_1.dat', 'configuration_2.dat', 'configuration_3.dat', 'configuration_4.dat');
   $HostIntrusionDetectionDatabaseDirectoryFileReportFilenameArray=array('directory_file_report_1.dat', 'directory_file_report_2.dat', 'directory_file_report_3.dat', 'directory_file_report_4.dat');
   $HostIntrusionDetectionDatabaseDirectoryExclusionArray=array('directory_exclusion_1.dat', 'directory_exclusion_2.dat', 'directory_exclusion_3.dat', 'directory_exclusion_4.dat');
   $HostIntrusionDetectionDatabaseFileExclusionArray=array('file_exclusion_1.dat', 'file_exclusion_2.dat', 'file_exclusion_3.dat', 'file_exclusion_4.dat');
   $DatabaseFieldnameConfigurationArray=array('id',
                                              'db_nr',
                                              'status',
                                              'create_time',
                                              'change_time',
                                              'main_directory_path',
                                              'directory_depth',
                                              'text_area'); // Array mit den internen Feldnamen
   // Array mit der maximalen Zeichenzahl der Datenbank-Felder (1 bis 3-stellig)
   $DatabaseCharCountConfigurationArray=array(1, 2, 1, 10, 10, 255, 2, 400);
   $DatabaseFieldnameDirectoryFileReportArray=array('id',
                                                    'db_nr',
                                                    'status',
                                                    'create_time',
                                                    'change_time',
                                                    'main_directory_path',
                                                    'directory_count_total_old',
                                                    'directory_count_total_new',
                                                    'directory_change_status',
                                                    'file_count_total_old',
                                                    'file_count_total_new',
                                                    'file_change_status'); // Array mit den internen Feldnamen
   // Array mit der maximalen Zeichenzahl der Datenbank-Felder (1 bis 3-stellig)
   $DatabaseCharCountDirectoryFileReportArray=array(1, 2, 1, 10, 10, 255, 32, 32, 1, 32, 32, 1);
   $HostIntrusionDetectionDatabaseFieldnameArray=array('id',
                                                       'db_nr',
                                                       'status',
                                                       'create_time',
                                                       'change_time',
                                                       'directory_path',
                                                       'directory_owner_old',
                                                       'directory_owner_new',
                                                       'directory_group_old',
                                                       'directory_group_new',
                                                       'directory_access_permission_old',
                                                       'directory_access_permission_new',
                                                       'directory_c_time_old',
                                                       'directory_c_time_new',
                                                       'directory_count_old',
                                                       'directory_count_new',
                                                       'directory_file_count_old',
                                                       'directory_file_count_new',
                                                       'directory_md5_key_old',
                                                       'directory_md5_key_new',
                                                       'directory_status',
                                                       'file_path',
                                                       'file_owner_old',
                                                       'file_owner_new',
                                                       'file_group_old',
                                                       'file_group_new',
                                                       'file_access_permission_old',
                                                       'file_access_permission_new',
                                                       'file_m_time_old',
                                                       'file_m_time_new',
                                                       'file_size_old',
                                                       'file_size_new',
                                                       'file_md5_key_old',
                                                       'file_md5_key_new',
                                                       'file_status'); // Array mit den internen Feldnamen
   $HostIntrusionDetectionDatabaseCharCountArray=array(10,
                                                       2,
                                                       1,
                                                       10,
                                                       10,
                                                       255,
                                                       32,
                                                       32,
                                                       32,
                                                       32,
                                                       4,
                                                       4,
                                                       10,
                                                       10,
                                                       32,
                                                       32,
                                                       32,
                                                       32,
                                                       32,
                                                       32,
                                                       1,
                                                       255,
                                                       32,
                                                       32,
                                                       32,
                                                       32,
                                                       4,
                                                       4,
                                                       10,
                                                       10,
                                                       32,
                                                       32,
                                                       32,
                                                       32,
                                                       1); // Array mit der maximalen Zeichenzahl der Datenbank-Felder (1 bis 5-stellig)
   // Array mit den internen Feldnamen
   $DatabaseFieldnameDirectoryExclusionArray=array('id', 'db_nr', 'status', 'create_time', 'change_time', 'directory_1', 'directory_2', 'directory_3', 'directory_4', 'directory_5', 'directory_exists_no_check');
   // Array mit der maximalen Zeichenzahl der Datenbank-Felder (1 bis 3-stellig)
   $DatabaseCharCountDirectoryExclusionArray=array(1, 2, 1, 10, 10, 255, 255, 255, 255, 255, 1);
    // Array mit den internen Feldnamen
   $DatabaseFieldnameFileExclusionArray=array('id', 'db_nr', 'status', 'create_time', 'change_time', 'file_1', 'file_2', 'file_3', 'file_4', 'file_5', 'file_exists_no_check');
   // Array mit der maximalen Zeichenzahl der Datenbank-Felder (1 bis 3-stellig)
   $DatabaseCharCountFileExclusionArray=array(1, 2, 1, 10, 10, 255, 255, 255, 255, 255, 1);

   //Funktion fuer die Ueberpruefung des Grundgeruestes der Text-Datenbanken
   function data_base_check($DatabaseFieldnameNumberOneArray='', $DatabaseFieldnameNumberTwoArray='', $DatabaseCharCountNumberOneArray='', $DatabaseCharCountNumberTwoArray='') {
      $DatabaseCheckReturncode=0;
      $DatabaseFieldnameNumberOneArrayCount=count($DatabaseFieldnameNumberOneArray);
      $DatabaseFieldnameNumberTwoArrayCount=count($DatabaseFieldnameNumberTwoArray);
      $DatabaseCharCountNumberOneArrayCount=count($DatabaseCharCountNumberOneArray);
      $DatabaseCharCountNumberTwoArrayCount=count($DatabaseCharCountNumberTwoArray);
      if(isset($DatabaseFieldnameNumberOneArray) &&
         is_array($DatabaseFieldnameNumberOneArray) &&
         isset($DatabaseFieldnameNumberTwoArray) &&
         is_array($DatabaseFieldnameNumberTwoArray) &&
         isset($DatabaseCharCountNumberOneArray) &&
         is_array($DatabaseCharCountNumberOneArray) &&
         isset($DatabaseCharCountNumberTwoArray) &&
         is_array($DatabaseCharCountNumberTwoArray)) {
            if($DatabaseFieldnameNumberOneArrayCount == $DatabaseFieldnameNumberTwoArrayCount && $DatabaseCharCountNumberOneArrayCount == $DatabaseCharCountNumberTwoArrayCount) {
               for($x=0; $x<$DatabaseFieldnameNumberOneArrayCount; $x++) {
                  $DatabaseFieldnameNumberOneArray[$x] = trim($DatabaseFieldnameNumberOneArray[$x]);
                  $DatabaseFieldnameNumberTwoArray[$x] = trim($DatabaseFieldnameNumberTwoArray[$x]);
                  $DatabaseCharCountNumberOneArray[$x] = trim($DatabaseCharCountNumberOneArray[$x]);
                  $DatabaseCharCountNumberTwoArray[$x] = trim($DatabaseCharCountNumberTwoArray[$x]);
                  $DatabaseFieldnameCompare = strcmp($DatabaseFieldnameNumberOneArray[$x], $DatabaseFieldnameNumberTwoArray[$x]);
                  if($DatabaseFieldnameCompare != 0) {
                     $DatabaseCheckReturncode=4;
                  } elseif(!preg_match("/^[0-9]{1,4}$/", $DatabaseCharCountNumberOneArray[$x]) || !preg_match("/^[0-9]{1,4}$/", $DatabaseCharCountNumberTwoArray[$x])) {
                     $DatabaseCheckReturncode=5;
                  } elseif(!preg_match("/^" . $DatabaseCharCountNumberOneArray[$x] . "$/", $DatabaseCharCountNumberTwoArray[$x])) {
                     $DatabaseCheckReturncode=6;
                  }
                  else
                  {
                     if($DatabaseCheckReturncode == 0 || $DatabaseCheckReturncode == 1) $DatabaseCheckReturncode=1;
                  }
               }
            } elseif($DatabaseFieldnameNumberOneArrayCount != $DatabaseFieldnameNumberTwoArrayCount) {
               $DatabaseCheckReturncode=2;
            }
            else
            {
            $DatabaseCheckReturncode=3;
            }
      } elseif(!isset($DatabaseFieldnameNumberOneArray) || !is_array($DatabaseFieldnameNumberOneArray)) {
         print 'NOTE: SYSTEM-ARRAY DatabaseFieldnameNumberOneArray - function <strong>data_base_check</strong> - IS DAMAGED!';
         exit;
      } elseif(!isset($DatabaseFieldnameNumberTwoArray) || !is_array($DatabaseFieldnameNumberTwoArray)) {
         print 'NOTE: SYSTEM-ARRAY DatabaseFieldnameNumberTwoArray - function <strong>data_base_check</strong> - IS DAMAGED!';
         exit;
      } elseif(!isset($DatabaseCharCountNumberOneArray) || !is_array($DatabaseCharCountNumberOneArray)) {
         print 'NOTE: SYSTEM-ARRAY DatabaseCharCountNumberOneArray - function <strong>data_base_check</strong> - IS DAMAGED!';
         exit;
      }
      else
      {
         print 'NOTE: SYSTEM-ARRAY DatabaseCharCountNumberTwoArray - function <strong>data_base_check</strong> - IS DAMAGED!';
         exit;
      }
      return $DatabaseCheckReturncode;
   }

   // Funktion fuer die Erstellung des Grundgeruestes der Text-Datenbanken
   function host_intrusion_detection_create_database($DatabaseFilepath='', $DatabaseFileAccess='', $FieldnameArray='', $FieldMaximalCharCountArray='') {
      $ReturnCode=0;
      $CreateDatabaseArray=array();
      // Hinweis: die Anzahl der Array-Elemente der uebergebenen Arrays (Exclusion-Arrays, IDS-Main-Array) ist variabel
      $FieldnameArrayCurrentCount=count($FieldnameArray);
      $FieldMaximalCharCountArrayCurrentCount=count($FieldMaximalCharCountArray);
      if(isset($FieldnameArray) &&
         is_array($FieldnameArray) &&
         isset($FieldMaximalCharCountArray) &&
         is_array($FieldMaximalCharCountArray) &&
         $FieldnameArrayCurrentCount == $FieldMaximalCharCountArrayCurrentCount) {
         if(!empty($DatabaseFilepath) &&
            !file_exists($DatabaseFilepath) &&
            !empty($DatabaseFileAccess)) {
            if(@touch($DatabaseFilepath)) {
               chmod($DatabaseFilepath, $DatabaseFileAccess);
               $FileContent='';
               for($x=0; $x<$FieldnameArrayCurrentCount; $x++) {
                  if(isset($FieldnameArray[$x])) {
                     if($x == 0) {
                        $FileContent .= $FieldnameArray[$x];
                     }
                     else
                     {
                     $FileContent .= '|' . $FieldnameArray[$x];
                     }
                  }
                  else
                  {
                  $FileContent .= '|';
                  }
               }
               $FileContent .= "\n";
               for($y=0; $y<$FieldMaximalCharCountArrayCurrentCount; $y++) {
                  if(isset($FieldMaximalCharCountArray[$y])) {
                     if($y == 0) {
                        $FileContent .= $FieldMaximalCharCountArray[$y];
                     }
                     else
                     {
                     $FileContent .= '|' . $FieldMaximalCharCountArray[$y];
                     }
                  }
                  else
                  {
                  $FileContent .= '|';
                  }
               }
               $FileContent .= "\n";
               if($FileWrite = @fopen($DatabaseFilepath,'w')) {
                  @flock($FileWrite,2);
                  @fwrite($FileWrite, $FileContent);
                  @flock($FileWrite,3);
                  @fclose($FileWrite);
                  $ReturnCode=1;
               }
               else
               { 
               $ReturnCode=2;
               }
            }
         }
         return $ReturnCode;
      } elseif(!isset($FieldnameArray) || !is_array($FieldnameArray)) {
         print 'NOTE: SYSTEM-ARRAY FieldnameArray - function <strong>host_intrusion_detection_create_database</strong> - IS DAMAGED!';
         exit;
      } elseif(!isset($FieldMaximalCharCountArray) || !is_array($FieldMaximalCharCountArray)) {
         print 'NOTE: SYSTEM-ARRAY FieldMaximalCharCountArray - function <strong>host_intrusion_detection_create_database</strong> - IS DAMAGED!';
         exit;
      }
      else
      {
         print 'NOTE: SYSTEM-ARRAY FieldnameArray OR FieldMaximalCharCountArray - function <strong>host_intrusion_detection_create_database</strong> - ARE DAMAGED!';
         exit;
      }
   }

   // Funktion fuer die Erstellung der IDS-Datenbanken
   function host_intrusion_detection_write_database($HostIntrusionDetectionCurrentDatabaseFilepath='', $HostIntrusionDetectionCurrentConfigurationDatabaseFilepath='', $HostIntrusionDetectionCurrentReportDatabaseFilepath='', $HostIntrusionDetectionCurrentDirectoryExclusionFilepath='', $HostIntrusionDetectionCurrentFileExclusionFilepath='', $HostIntrusionDetectionArray='', $CurrentIdsDatabaseNumber='') {
      // Funktion schreibt in 3 bis 5 Datenbanken (hids_db_x.dat, configuration_x.dat, directory_file_report_x.dat, directory_exclusion_x.dat, file_exclusion_x.dat)
      $ReturnCodeArray=array();
      $ConfigurationReturnCode=0;
      $ReportReturnCode=0;
      $ReturnCodeMainDatabase=0;
      $ReturnCodeDirectoryExclusion='';
      $ReturnCodeFileExclusion='';
      $HostIntrusionDetectionArrayDefaultCount=11; // Vorgabe: Anzahl der Array-Elemente
      $HostIntrusionDetectionArrayCurrentCount=count($HostIntrusionDetectionArray);
      $ConfigurationDatabaseMaximalFieldCount=8; // maximale Anzahl der Felder in der Reportdatenbank
      $ReportDatabaseMaximalFieldCount=12; // maximale Anzahl der Felder in der Reportdatenbank
      $IdsDatabaseMaximalFieldCount=35; // maximale Anzahl der Felder in der Hauptdatenbank
      $DatabaseDirectoryExclusionFieldCount=11; // maximale Anzahl der Felder in der Datenbank fuer die auszuschlieszenden Verzeichnisse
      $DirectoryExclusionMaximalCount=5; // maximale Anzahl der auszuschlieszenden Verzeichnisse
      $DatabaseFileExclusionFieldCount=11; // maximale Anzahl der Felder in der Datenbank fuer die auszuschlieszenden Dateien
      $FileExclusionMaximalCount=5; // maximale Anzahl der auszuschlieszenden Dateien
      if(isset($HostIntrusionDetectionArray) &&
         is_array($HostIntrusionDetectionArray) &&
         $HostIntrusionDetectionArrayDefaultCount == $HostIntrusionDetectionArrayCurrentCount) {
         if(!empty($HostIntrusionDetectionCurrentDatabaseFilepath) &&
            file_exists($HostIntrusionDetectionCurrentDatabaseFilepath) &&
            is_writeable($HostIntrusionDetectionCurrentDatabaseFilepath)) {
            if(!empty($HostIntrusionDetectionArray[0]) || !empty($HostIntrusionDetectionArray[2])) {
               if(!empty($HostIntrusionDetectionArray[3]) &&
                  !empty($HostIntrusionDetectionArray[4]) &&
                  preg_match("/^([1-9]|[1][0-2])$/", $HostIntrusionDetectionArray[4]) &&
                  isset($HostIntrusionDetectionArray[6]) &&
                  isset($HostIntrusionDetectionArray[8]) &&
                  is_array($HostIntrusionDetectionArray[8]) &&
                  isset($HostIntrusionDetectionArray[9]) &&
                  is_array($HostIntrusionDetectionArray[9]) &&
                  !empty($ConfigurationDatabaseMaximalFieldCount) &&
                  !empty($ReportDatabaseMaximalFieldCount) &&
                  !empty($DatabaseDirectoryExclusionFieldCount) &&
                  !empty($DatabaseFileExclusionFieldCount) &&
                  !empty($IdsDatabaseMaximalFieldCount) &&
                  !empty($CurrentIdsDatabaseNumber)) {
                  // die auszuschlieszenden Verzeichnisse in die zustaendige Datenbank eintragen
                  if(!empty($HostIntrusionDetectionCurrentDirectoryExclusionFilepath) &&
                     file_exists($HostIntrusionDetectionCurrentDirectoryExclusionFilepath) &&
                     is_writeable($HostIntrusionDetectionCurrentDirectoryExclusionFilepath)) {
                     $ReturnCodeDirectoryExclusion=0;
                     $DirectoryExclusionFileArray = file($HostIntrusionDetectionCurrentDirectoryExclusionFilepath);
                     $DirectoryExclusionFileArrayCount = count($DirectoryExclusionFileArray);
                     if($DirectoryExclusionFileArrayCount >= 2) {
                        $DirectoryExclusionDataRecords = trim($DirectoryExclusionFileArray[0]) . "\n";
                        $DirectoryExclusionDataRecords .= trim($DirectoryExclusionFileArray[1]) . "\n";
                        $DatabaseDirectoryExclusionFieldStringLenArray = explode("|", $DirectoryExclusionFileArray[1]);
                        unset($DirectoryExclusionFileArray);
                        $DatabaseDirectoryExclusionFieldStringLenArrayCount = count($DatabaseDirectoryExclusionFieldStringLenArray);
                        if(preg_match("/^[0-9]{1,2}$/", $DatabaseDirectoryExclusionFieldStringLenArrayCount) && $DatabaseDirectoryExclusionFieldStringLenArrayCount == $DatabaseDirectoryExclusionFieldCount) {
                           $DirectoryExclusionFormArrayCount = count($HostIntrusionDetectionArray[8]);
                           if($DirectoryExclusionFormArrayCount >= 1) {
                              $CurrentDirectoryExclusionArray=array();
                              $CurrentDirectoryExclusionArray[]=1;
                              $CurrentDirectoryExclusionArray[]=$CurrentIdsDatabaseNumber;
                              $CurrentDirectoryExclusionArray[]=1;
                              $CurrentDirectoryExclusionArray[]=time();
                              $CurrentDirectoryExclusionArray[]=time();
                              if(empty($HostIntrusionDetectionArray[10])) {
                                 for($x=0; $x<$DirectoryExclusionFormArrayCount; $x++) {
                                    $CurrentDirectoryExclusion = trim($HostIntrusionDetectionArray[8][$x]);
                                    $CurrentDirectoryExclusionSlashCount = substr_count($CurrentDirectoryExclusion, '/');
                                    for($y=0; $y<$CurrentDirectoryExclusionSlashCount; $y++) {
                                       $DirectoryPathSlashSearch = substr($CurrentDirectoryExclusion, -1);
                                       if(preg_match("@^/$@", $DirectoryPathSlashSearch)) {
                                          $CurrentDirectoryExclusion = substr($CurrentDirectoryExclusion, 0, -1);
                                       }
                                       else
                                       {
                                       break;
                                       }
                                    }
                                    if(!empty($CurrentDirectoryExclusion) &&
                                       preg_match("@^(\./|\.\./).*@", $CurrentDirectoryExclusion) &&
                                       is_dir($CurrentDirectoryExclusion)) {
                                       $CurrentDirectoryExclusionArray[]=$CurrentDirectoryExclusion;
                                    }
                                    else
                                    {
                                    $CurrentDirectoryExclusionArray[]='';
                                    }
                                 }
                              }
                              else
                              {
                                 for($x=0; $x<$DirectoryExclusionFormArrayCount; $x++) {
                                    $CurrentDirectoryExclusion = trim($HostIntrusionDetectionArray[8][$x]);
                                    $CurrentDirectoryExclusionArray[]=$CurrentDirectoryExclusion;
                                 }
                              }
                              if(!empty($HostIntrusionDetectionArray[10]) && preg_match("/^[1]$/", $HostIntrusionDetectionArray[10])) {
                                 $CurrentDirectoryExclusionArray[]=1;
                              }
                              else
                              {
                              $CurrentDirectoryExclusionArray[]=0;
                              }
                              $CurrentDirectoryExclusionArrayCount = count($CurrentDirectoryExclusionArray);
                              for($y=0; $y<$CurrentDirectoryExclusionArrayCount; $y++) {
                                 // maximale Stringlaenge pruefen
                                 $CurrentDirectoryExclusionFieldStringLen = strlen($CurrentDirectoryExclusionArray[$y]);
                                 $DatabaseDirectoryExclusionFieldStringLen = trim($DatabaseDirectoryExclusionFieldStringLenArray[$y]);
                                 if(preg_match("/^[0-9]{1,3}$/", $DatabaseDirectoryExclusionFieldStringLen)) {
                                    if($CurrentDirectoryExclusionFieldStringLen > $DatabaseDirectoryExclusionFieldStringLen) {
                                       // Laenge des Array-Elementes auf die maximale zulaessige Laenge kuerzen
                                       $CurrentDirectoryExclusionArray[$y] = substr($CurrentDirectoryExclusionArray[$y], 0, $DatabaseDirectoryExclusionFieldStringLen);
                                    }
                                    $CurrentDirectoryExclusionArray[$y] = htmlspecialchars($CurrentDirectoryExclusionArray[$y], ENT_QUOTES);
                                    // Zeilenumbruch (Windows: \r\n, MAC: \r, Unix/linux: \n) in den HTML-Code umsetzen
                                    $CurrentDirectoryExclusionArray[$y] = preg_replace('/\r\n|\r|\n/', '<br>', $CurrentDirectoryExclusionArray[$y]);
                                    // gerader Strich (|) ist reserveiert als Feldtrenner
                                    $CurrentDirectoryExclusionArray[$y] = preg_replace('/\|/', '&#124;', $CurrentDirectoryExclusionArray[$y]);
                                 }
                                 else
                                 {
                                    print 'NOTE 1: SYSTEM-FILE ' . $HostIntrusionDetectionCurrentDirectoryExclusionFilepath . ' - function <strong>host_intrusion_detection_write_database</strong> - IS DAMAGED!';
                                    exit;
                                 }
                              }
                              $DirectoryExclusionDataRecordFields='';
                              $CurrentDirectoryExclusionArrayCount = count($CurrentDirectoryExclusionArray);
                              for($z=0; $z<$CurrentDirectoryExclusionArrayCount; $z++) {
                                 if(isset($CurrentDirectoryExclusionArray[$z])) {
                                    if($z == 0) {
                                       $DirectoryExclusionDataRecordFields .= $CurrentDirectoryExclusionArray[$z];
                                    }
                                    else
                                    {
                                    $DirectoryExclusionDataRecordFields .= '|' . $CurrentDirectoryExclusionArray[$z];
                                    }
                                 }
                                 else
                                 {
                                 $DirectoryExclusionDataRecordFields .= '|';
                                 }
                              }
                              $DirectoryExclusionDataRecordFields .= "\n";
                              $DirectoryExclusionDataRecords .= $DirectoryExclusionDataRecordFields;
                              unset($CurrentDirectoryExclusionArray);
                              if($DirectoryExclusionFileWrite = @fopen($HostIntrusionDetectionCurrentDirectoryExclusionFilepath,'w')) {
                                 @flock($DirectoryExclusionFileWrite,2);
                                 @fwrite($DirectoryExclusionFileWrite, $DirectoryExclusionDataRecords);
                                 @flock($DirectoryExclusionFileWrite,3);
                                 @fclose($DirectoryExclusionFileWrite);
                                 $ReturnCodeDirectoryExclusion=1;
                              }
                              else
                              { 
                              $ReturnCodeDirectoryExclusion=4;
                              }
                           }
                        }
                        else
                        {
                        $ReturnCodeDirectoryExclusion=3;
                        }
                     }
                     else
                     {
                     $ReturnCodeDirectoryExclusion=2;
                     }
                  }
                  // die auszuschlieszenden Dateien in die zustaendige Datenbank eintragen
                  if(!empty($HostIntrusionDetectionCurrentFileExclusionFilepath) && 
                     file_exists($HostIntrusionDetectionCurrentFileExclusionFilepath) &&
                     is_writeable($HostIntrusionDetectionCurrentFileExclusionFilepath)) {
                     $ReturnCodeFileExclusion=0;
                     $FileExclusionFileArray = file($HostIntrusionDetectionCurrentFileExclusionFilepath);
                     $FileExclusionFileArrayCount = count($FileExclusionFileArray);
                     if($FileExclusionFileArrayCount == 2) {
                        $FileExclusionDataRecords = trim($FileExclusionFileArray[0]) . "\n";
                        $FileExclusionDataRecords .= trim($FileExclusionFileArray[1]) . "\n";
                        $DatabaseFileExclusionFieldStringLenArray = explode("|", $FileExclusionFileArray[1]);
                        unset($FileExclusionFileArray);
                        $DatabaseFileExclusionFieldStringLenArrayCount = count($DatabaseFileExclusionFieldStringLenArray);
                        if(preg_match("/^[0-9]{1,2}$/", $DatabaseFileExclusionFieldStringLenArrayCount) && $DatabaseFileExclusionFieldStringLenArrayCount == $DatabaseFileExclusionFieldCount) {
                           $FileExclusionFormArrayCount = count($HostIntrusionDetectionArray[9]);
                           if($FileExclusionFormArrayCount >= 2) {
                              $CurrentFileExclusionArray=array();
                              $CurrentFileExclusionArray[]=1;
                              $CurrentFileExclusionArray[]=$CurrentIdsDatabaseNumber;
                              $CurrentFileExclusionArray[]=1;
                              $CurrentFileExclusionArray[]=time();
                              $CurrentFileExclusionArray[]=time();
                              if(empty($HostIntrusionDetectionArray[10])) {
                                 for($x=0; $x<$FileExclusionFormArrayCount; $x++) {
                                    $CurrentFileExclusion = trim($HostIntrusionDetectionArray[9][$x]);
                                    if(!empty($CurrentFileExclusion) &&
                                       preg_match("@^(\./|\.\./).+@", $CurrentFileExclusion) &&
                                       file_exists($CurrentFileExclusion)) {
                                       $CurrentFileExclusionArray[]=$CurrentFileExclusion;
                                    }
                                    else
                                    {
                                    $CurrentFileExclusionArray[]='';
                                    }
                                 }
                              }
                              else
                              {
                                 for($x=0; $x<$FileExclusionFormArrayCount; $x++) {
                                    $CurrentFileExclusion = trim($HostIntrusionDetectionArray[9][$x]);
                                    $CurrentFileExclusionArray[]=$CurrentFileExclusion;
                                 }
                              }
                              if(!empty($HostIntrusionDetectionArray[10]) && preg_match("/^[1]$/", $HostIntrusionDetectionArray[10])) {
                                 $CurrentFileExclusionArray[]=1;
                              }
                              else
                              {
                              $CurrentFileExclusionArray[]=0;
                              }
                              $CurrentFileExclusionArrayCount = count($CurrentFileExclusionArray);
                              for($y=0; $y<$CurrentFileExclusionArrayCount; $y++) {
                                 // maximale Stringlaenge pruefen
                                 $CurrentFileExclusionFieldStringLen = strlen($CurrentFileExclusionArray[$y]);
                                 $DatabaseFileExclusionFieldStringLen = trim($DatabaseFileExclusionFieldStringLenArray[$y]);
                                 if(preg_match("/^[0-9]{1,3}$/", $DatabaseFileExclusionFieldStringLen)) {
                                    if($CurrentFileExclusionFieldStringLen > $DatabaseFileExclusionFieldStringLen) {
                                       // Laenge des Array-Elementes auf die maximale zulaessige Laenge kuerzen
                                       $CurrentFileExclusionArray[$y] = substr($CurrentFileExclusionArray[$y], 0, $DatabaseFileExclusionFieldStringLen);
                                    }
                                    $CurrentFileExclusionArray[$y] = htmlspecialchars($CurrentFileExclusionArray[$y], ENT_QUOTES);
                                    // Zeilenumbruch (Windows: \r\n, MAC: \r, Unix/linux: \n) in den HTML-Code umsetzen
                                    $CurrentFileExclusionArray[$y] = preg_replace('/\r\n|\r|\n/', '<br>', $CurrentFileExclusionArray[$y]);
                                    // gerader Strich (|) ist reserveiert als Feldtrenner
                                    $CurrentFileExclusionArray[$y] = preg_replace('/\|/', '&#124;', $CurrentFileExclusionArray[$y]);
                                 }
                                 else
                                 {
                                    print 'NOTE 1: SYSTEM-FILE ' . $HostIntrusionDetectionCurrentFileExclusionFilepath . ' - function <strong>host_intrusion_detection_write_database</strong> - IS DAMAGED!';
                                    exit;
                                 }
                              }
                              $FileExclusionDataRecordFields='';
                              $CurrentFileExclusionArrayCount = count($CurrentFileExclusionArray);
                              for($z=0; $z<$CurrentFileExclusionArrayCount; $z++) {
                                 if(isset($CurrentFileExclusionArray[$z])) {
                                    if($z == 0) {
                                       $FileExclusionDataRecordFields .= $CurrentFileExclusionArray[$z];
                                    }
                                    else
                                    {
                                    $FileExclusionDataRecordFields .= '|' . $CurrentFileExclusionArray[$z];
                                    }
                                 }
                                 else
                                 {
                                 $FileExclusionDataRecordFields .= '|';
                                 }
                              }
                              $FileExclusionDataRecordFields .= "\n";
                              $FileExclusionDataRecords .= $FileExclusionDataRecordFields;
                              unset($CurrentFileExclusionArray);
                              if($FileExclusionFileWrite = @fopen($HostIntrusionDetectionCurrentFileExclusionFilepath,'w')) {
                                 @flock($FileExclusionFileWrite,2);
                                 @fwrite($FileExclusionFileWrite, $FileExclusionDataRecords);
                                 @flock($FileExclusionFileWrite,3);
                                 @fclose($FileExclusionFileWrite);
                                 $ReturnCodeFileExclusion=1;
                              }
                              else
                              { 
                              $ReturnCodeFileExclusion=4;
                              }
                           }
                        }
                        else
                        {
                        $ReturnCodeFileExclusion=3;
                        }
                     }
                     else
                     {
                     $ReturnCodeFileExclusion=2;
                     }
                  }
                  // die Verzeichnisse und Dateien in Arrays eintragen
                  $DirectoryExclusionLineArray=array();
                  if(file_exists($HostIntrusionDetectionCurrentDirectoryExclusionFilepath) && is_readable($HostIntrusionDetectionCurrentDirectoryExclusionFilepath)) {
                     $DirectoryExclusionArray = file($HostIntrusionDetectionCurrentDirectoryExclusionFilepath);
                     $CurrentDirectoryExclusionArrayCount = count($DirectoryExclusionArray);
                     if($CurrentDirectoryExclusionArrayCount >= 3) {
                        $DirectoryExclusionExplodeArray = explode("|", $DirectoryExclusionArray[2]);
                        $DirectoryExclusionExplodeArrayCount = count($DirectoryExclusionExplodeArray);
                        $DirectoryExclusionFieldCount = $DirectoryExclusionExplodeArrayCount - 1;
                        // die ersten 5 Felder und das letzte Feld enthalten keine Verzeichnispfade
                        for($y=5; $y<$DirectoryExclusionFieldCount; $y++) {
                           $DirectoryExclusionLineArray[]=$DirectoryExclusionExplodeArray[$y];
                        }
                        unset($DirectoryExclusionExplodeArray);
                     }
                     else
                     {
                        print 'NOTE 2: SYSTEM-FILE ' . $HostIntrusionDetectionCurrentDirectoryExclusionFilepath . ' - function <strong>host_intrusion_detection_write_database</strong> - IS DAMAGED!';
                        exit;
                     }
                     unset($DirectoryExclusionArray);
                  }
                  $FileExclusionLineArray=array();
                  if(file_exists($HostIntrusionDetectionCurrentFileExclusionFilepath) && is_readable($HostIntrusionDetectionCurrentFileExclusionFilepath)) {
                     $FileExclusionArray = file($HostIntrusionDetectionCurrentFileExclusionFilepath);
                     $FileExclusionArrayCount = count($FileExclusionArray);
                     if($FileExclusionArrayCount >= 3) {
                        $FileExclusionExplodeArray = explode("|", $FileExclusionArray[2]);
                        $FileExclusionExplodeArrayCount = count($FileExclusionExplodeArray);
                        $FileExclusionFieldCount = $FileExclusionExplodeArrayCount - 1;
                        // die ersten 5 Felder und das letzte Feld enthalten keine Dateipfade
                        for($y=5; $y<$FileExclusionFieldCount; $y++) {
                           $FileExclusionLineArray[]=$FileExclusionExplodeArray[$y];
                        }

                        unset($FileExclusionExplodeArray);
                     }
                     else
                     {
                        print 'NOTE 2: SYSTEM-FILE ' . $HostIntrusionDetectionCurrentFileExclusionFilepath . ' - function <strong>host_intrusion_detection_write_database</strong> - IS DAMAGED!';
                        exit;
                     }
                     unset($FileExclusionArray);
                  }
                  // Verzeichnispfad, Verzeichnistiefe und Texthinweise (Textarea) in die Konfigurations-Datenbank eintragen
                  if(!empty($HostIntrusionDetectionCurrentConfigurationDatabaseFilepath) &&
                     file_exists($HostIntrusionDetectionCurrentConfigurationDatabaseFilepath) &&
                     is_writeable($HostIntrusionDetectionCurrentConfigurationDatabaseFilepath)) {
                     $CurrentConfigurationDatabaseArray = file($HostIntrusionDetectionCurrentConfigurationDatabaseFilepath);
                     $CurrentConfigurationDatabaseArrayCount = count($CurrentConfigurationDatabaseArray);
                     if($CurrentConfigurationDatabaseArray >= 2) {
                        $CurrentConfigurationDatabaseDataRecords = trim($CurrentConfigurationDatabaseArray[0]) . "\n";
                        $CurrentConfigurationDatabaseDataRecords .= trim($CurrentConfigurationDatabaseArray[1]) . "\n";
                        $CurrentConfigurationDatabaseStringLenArray = explode("|", $CurrentConfigurationDatabaseArray[1]);
                        $CurrentConfigurationDatabaseStringLenArrayCount = count($CurrentConfigurationDatabaseStringLenArray);
                        if(preg_match("/^[0-9]{1,2}$/", $CurrentConfigurationDatabaseStringLenArrayCount) && $CurrentConfigurationDatabaseStringLenArrayCount == $ConfigurationDatabaseMaximalFieldCount) {
                           unset($CurrentConfigurationDatabaseArray);
                           $CurrentConfigurationDataRecordArray=array();
                           $CurrentConfigurationDataRecordArray[]=1;
                           $CurrentConfigurationDataRecordArray[]=$CurrentIdsDatabaseNumber;
                           $CurrentConfigurationDataRecordArray[]=1;
                           $CurrentConfigurationDataRecordArray[]=time();
                           $CurrentConfigurationDataRecordArray[]=time();
                           $CurrentConfigurationDataRecordArray[]=$HostIntrusionDetectionArray[3];
                           $CurrentConfigurationDataRecordArray[]=$HostIntrusionDetectionArray[4];
                           $CurrentConfigurationDataRecordArray[]=$HostIntrusionDetectionArray[6];
                           $CurrentConfigurationDataRecordArrayCount = count($CurrentConfigurationDataRecordArray);
                           for($y=0; $y<$CurrentConfigurationDataRecordArrayCount; $y++) {
                              // maximale Stringlaenge pruefen
                              $CurrentFieldStringLen = strlen($CurrentConfigurationDataRecordArray[$y]);
                              $ConfigurationDatabaseFieldStringLen = trim($CurrentConfigurationDatabaseStringLenArray[$y]);
                              if(preg_match("/^[0-9]{1,5}$/", $ConfigurationDatabaseFieldStringLen)) {
                                 if($CurrentFieldStringLen > $ConfigurationDatabaseFieldStringLen) {
                                    // Laenge des Array-Elementes auf die maximale zulaessige Laenge kuerzen
                                    $CurrentConfigurationDataRecordArray[$y] = substr($CurrentConfigurationDataRecordArray[$y], 0, $ConfigurationDatabaseFieldStringLen);
                                 }
                                 $CurrentConfigurationDataRecordArray[$y] = htmlspecialchars($CurrentConfigurationDataRecordArray[$y], ENT_QUOTES);
                                 // Zeilenumbruch (Windows: \r\n, MAC: \r, Unix/linux: \n) in den HTML-Code umsetzen
                                 $CurrentConfigurationDataRecordArray[$y] = preg_replace('/\r\n|\r|\n/', '<br>', $CurrentConfigurationDataRecordArray[$y]);
                                 // gerader Strich (|) ist reserveiert als Feldtrenner
                                 $CurrentConfigurationDataRecordArray[$y] = preg_replace('/\|/', '&#124;', $CurrentConfigurationDataRecordArray[$y]);
                              }
                              else
                              {
                                 print 'NOTE: SYSTEM-FILE ' . $HostIntrusionDetectionCurrentConfigurationDatabaseFilepath . ' - function <strong>host_intrusion_detection_write_database</strong> - IS DAMAGED!';
                                 exit;
                              }
                           }
                           $CurrentConfigurationDataRecordLineOne='';
                           $CurrentConfigurationDataRecordArrayCount = count($CurrentConfigurationDataRecordArray);
                           for($y=0; $y<$CurrentConfigurationDataRecordArrayCount; $y++) {
                              if(isset($CurrentConfigurationDataRecordArray[$y])) {
                                 if($y == 0) {
                                    $CurrentConfigurationDataRecordLineOne .= $CurrentConfigurationDataRecordArray[$y];
                                 }
                                 else
                                 {
                                 $CurrentConfigurationDataRecordLineOne .= '|' . $CurrentConfigurationDataRecordArray[$y];
                                 }
                              }
                              else
                              {
                              $CurrentConfigurationDataRecordLineOne .= '|';
                              }
                           }
                           $CurrentConfigurationDataRecordLineOne .= "\n";
                           $CurrentConfigurationDatabaseDataRecords .= $CurrentConfigurationDataRecordLineOne;
                           if($ConfigurationDatabaseFileWrite = @fopen($HostIntrusionDetectionCurrentConfigurationDatabaseFilepath,'w')) {
                              @flock($ConfigurationDatabaseFileWrite,2);
                              @fwrite($ConfigurationDatabaseFileWrite, $CurrentConfigurationDatabaseDataRecords);
                              @flock($ConfigurationDatabaseFileWrite,3);
                              @fclose($ConfigurationDatabaseFileWrite);
                              $ConfigurationReturnCode=1;
                           }
                           else
                           { 
                           $ConfigurationReturnCode=4;
                           }
                        }
                        else
                        {
                        $ConfigurationReturnCode=3;
                        }
                     }
                     else
                     {
                     $ConfigurationReturnCode=3;
                     }
                  }
                  else
                  {
                  $ConfigurationReturnCode=2;
                  }
                  // Ermittlung der Verzeichnisse und Dateien des zu ueberwachenden Hauptverzeichnisses - ohne die auszuschlieszenden Verzeichnisse und Dateien
                  $IdsCurrentDirectoryMainArray=array();
                  $IdsCurrentFileMainArray=array();
                  $IdsCurrentDirectoryMainArray[] = $HostIntrusionDetectionArray[3];
                  $IdsCurrentDirectoryMainArrayCount = count($IdsCurrentDirectoryMainArray);
                  $IdsDirectoryMaxDepthCount = substr_count($IdsCurrentDirectoryMainArray[0], '/') + $HostIntrusionDetectionArray[4] - 1;
                  for($x=0; $x<$IdsCurrentDirectoryMainArrayCount; $x++) {
                     $IdsFileHandle = @opendir($IdsCurrentDirectoryMainArray[$x]);
                     while($IdsFileName = @readdir($IdsFileHandle)) {
                        if($IdsFileName != "." && $IdsFileName != "..") {
                           $IdsDirectoryNameLength = strlen($IdsCurrentDirectoryMainArray[$x]) - 1;
                           $IdsDirectoryNameLastSlashPosition = strrpos($IdsCurrentDirectoryMainArray[$x], '/');
                           if($IdsDirectoryNameLength == $IdsDirectoryNameLastSlashPosition) {
                              $IdsCurrentDirectoryMainArray[$x] = substr($IdsCurrentDirectoryMainArray[$x], 0, -1);
                           }
                           $IdsNextFile = $IdsCurrentDirectoryMainArray[$x] . "/" . $IdsFileName;
                           $IdsCurrentDirectoryCount = substr_count($IdsNextFile, '/');
                           if(file_exists($IdsNextFile) &&
                              is_dir($IdsNextFile) &&
                              $IdsCurrentDirectoryCount <= $IdsDirectoryMaxDepthCount) {
                              if(!empty($DirectoryExclusionLineArray) && is_array($DirectoryExclusionLineArray)) {
                                 $DirectoryExclusion=0;
                                 $DirectoryExclusionLineArrayCount = count($DirectoryExclusionLineArray);
                                 for($y=0; $y<$DirectoryExclusionLineArrayCount; $y++) {
                                    $DirectoryStringComparison = strcmp($IdsNextFile, $DirectoryExclusionLineArray[$y]);
                                    if($DirectoryExclusionLineArray[$y] != "" && $DirectoryStringComparison == 0) {
                                       $DirectoryExclusion=1;
                                       break;
                                    }
                                 }
                                 if(empty($DirectoryExclusion)) {
                                    $IdsCurrentDirectoryMainArray[] = $IdsNextFile;
                                    $IdsCurrentDirectoryMainArrayCount = count($IdsCurrentDirectoryMainArray);
                                 }
                                 else
                                 {
                                 unset($DirectoryExclusion);
                                 }
                              }
                              else
                              {
                                 $IdsCurrentDirectoryMainArray[] = $IdsNextFile;
                                 $IdsCurrentDirectoryMainArrayCount = count($IdsCurrentDirectoryMainArray);
                              }
                           } elseif(file_exists($IdsNextFile) && !is_dir($IdsNextFile)) {
                              if(!empty($FileExclusionLineArray) && is_array($FileExclusionLineArray)) {
                                 $FileExclusion=0;
                                 $FileExclusionLineArrayCount = count($FileExclusionLineArray);
                                 for($y=0; $y<$FileExclusionLineArrayCount; $y++) {
                                    $FileStringComparison = strcmp($IdsNextFile, $FileExclusionLineArray[$y]);
                                    if($FileExclusionLineArray[$y] != "" && $FileStringComparison == 0) {
                                       $FileExclusion=1;
                                       break;
                                    }
                                 }
                                 if(empty($FileExclusion)) {
                                    $IdsCurrentFileMainArray[] = $IdsNextFile;
                                 }
                                 else
                                 {
                                 unset($FileExclusion);
                                 }
                              }
                              else
                              {
                              $IdsCurrentFileMainArray[] = $IdsNextFile;
                              }
                           }
                        }
                     }
                     @closedir($IdsFileHandle);
                  }
                  sort($IdsCurrentDirectoryMainArray);
                  sort($IdsCurrentFileMainArray);
                  $IdsCurrentDirectoryMainArrayCount = count($IdsCurrentDirectoryMainArray);
                  $IdsCurrentFileMainArrayCount = count($IdsCurrentFileMainArray);
                  // die Anzahl der Verzeichnisse und Dateien in die Report-Datenbank eintragen
                  if(!empty($HostIntrusionDetectionCurrentReportDatabaseFilepath) &&
                     file_exists($HostIntrusionDetectionCurrentReportDatabaseFilepath) &&
                     is_writeable($HostIntrusionDetectionCurrentReportDatabaseFilepath)) {
                     $CurrentReportDatabaseArray = file($HostIntrusionDetectionCurrentReportDatabaseFilepath);
                     $CurrentReportDatabaseArrayCount = count($CurrentReportDatabaseArray);
                     if($CurrentReportDatabaseArrayCount >= 2) {
                        $CurrentReportDatabaseDataRecords = trim($CurrentReportDatabaseArray[0]) . "\n";
                        $CurrentReportDatabaseDataRecords .= trim($CurrentReportDatabaseArray[1]) . "\n";
                        $CurrentReportDatabaseStringLenArray = explode("|", $CurrentReportDatabaseArray[1]);
                        $CurrentReportDatabaseStringLenArrayCount = count($CurrentReportDatabaseStringLenArray);
                        if(preg_match("/^[0-9]{1,2}$/", $CurrentReportDatabaseStringLenArrayCount) && $CurrentReportDatabaseStringLenArrayCount == $ReportDatabaseMaximalFieldCount) {
                           unset($CurrentReportDatabaseArray);
                           $CurrentReportDataRecordArray=array();
                           $CurrentReportDataRecordArray[]=1;
                           $CurrentReportDataRecordArray[]=$CurrentIdsDatabaseNumber;
                           $CurrentReportDataRecordArray[]=1;
                           $CurrentReportDataRecordArray[]=time();
                           $CurrentReportDataRecordArray[]=time();
                           $CurrentReportDataRecordArray[]=$HostIntrusionDetectionArray[3];
                           $CurrentReportDataRecordArray[]=$IdsCurrentDirectoryMainArrayCount;
                           $CurrentReportDataRecordArray[]=$IdsCurrentDirectoryMainArrayCount;
                           $CurrentReportDataRecordArray[]=1;
                           /* Aenderungs-Status - Verzeichnisse
                                 0 .. geaendert
                                 1 .. unveraendert
                          */
                           $CurrentReportDataRecordArray[]=$IdsCurrentFileMainArrayCount;
                           $CurrentReportDataRecordArray[]=$IdsCurrentFileMainArrayCount;
                           $CurrentReportDataRecordArray[]=1;
                           /* Aenderungs-Status - Dateien
                                 0 .. geaendert
                                 1 .. unveraendert
                          */
                           $CurrentReportDataRecordArrayCount = count($CurrentReportDataRecordArray);
                           for($y=0; $y<$CurrentReportDataRecordArrayCount; $y++) {
                              // maximale Stringlaenge pruefen
                              $CurrentFieldStringLen = strlen($CurrentReportDataRecordArray[$y]);
                              $ReportDatabaseFieldStringLen = trim($CurrentReportDatabaseStringLenArray[$y]);
                              if(preg_match("/^[0-9]{1,5}$/", $ReportDatabaseFieldStringLen)) {
                                 if($CurrentFieldStringLen > $ReportDatabaseFieldStringLen) {
                                    // Laenge des Array-Elementes auf die maximale zulaessige Laenge kuerzen
                                    $CurrentReportDataRecordArray[$y] = substr($CurrentReportDataRecordArray[$y], 0, $ReportDatabaseFieldStringLen);
                                 }
                                 $CurrentReportDataRecordArray[$y] = htmlspecialchars($CurrentReportDataRecordArray[$y], ENT_QUOTES);
                                 // Zeilenumbruch (Windows: \r\n, MAC: \r, Unix/linux: \n) in den HTML-Code umsetzen
                                 $CurrentReportDataRecordArray[$y] = preg_replace('/\r\n|\r|\n/', '<br>', $CurrentReportDataRecordArray[$y]);
                                 // gerader Strich (|) ist reserveiert als Feldtrenner
                                 $CurrentReportDataRecordArray[$y] = preg_replace('/\|/', '&#124;', $CurrentReportDataRecordArray[$y]);
                              }
                              else
                              {
                                 print 'NOTE: SYSTEM-FILE ' . $HostIntrusionDetectionCurrentReportDatabaseFilepath . ' - function <strong>host_intrusion_detection_write_database</strong> - IS DAMAGED!';
                                 exit;
                              }
                           }
                           $CurrentReportDataRecordLineOne='';
                           $CurrentReportDataRecordArrayCount = count($CurrentReportDataRecordArray);
                           for($y=0; $y<$CurrentReportDataRecordArrayCount; $y++) {
                              if(isset($CurrentReportDataRecordArray[$y])) {
                                 if($y == 0) {
                                    $CurrentReportDataRecordLineOne .= $CurrentReportDataRecordArray[$y];
                                 }
                                 else
                                 {
                                 $CurrentReportDataRecordLineOne .= '|' . $CurrentReportDataRecordArray[$y];
                                 }
                              }
                              else
                              {
                              $CurrentReportDataRecordLineOne .= '|';
                              }
                           }
                           $CurrentReportDataRecordLineOne .= "\n";
                           $CurrentReportDatabaseDataRecords .= $CurrentReportDataRecordLineOne;
                           if($ReportDatabaseFileWrite = @fopen($HostIntrusionDetectionCurrentReportDatabaseFilepath,'w')) {
                              @flock($ReportDatabaseFileWrite,2);
                              @fwrite($ReportDatabaseFileWrite, $CurrentReportDatabaseDataRecords);
                              @flock($ReportDatabaseFileWrite,3);
                              @fclose($ReportDatabaseFileWrite);
                              $ReportReturnCode=1;
                           }
                           else
                           { 
                           $ReportReturnCode=4;
                           }
                        }
                        else
                        {
                        $ReportReturnCode=3;
                        }
                     }
                     else
                     {
                     $ReportReturnCode=3;
                     }
                  }
                  else
                  {
                  $ReportReturnCode=2;
                  }
                  // Daten in die IDS-Hauptdatenbank schreiben
                  $CurrentIdsDatabaseMainArray = file($HostIntrusionDetectionCurrentDatabaseFilepath);
                  $CurrentIdsDatabaseMainArrayCount = count($CurrentIdsDatabaseMainArray);
                  if($CurrentIdsDatabaseMainArrayCount >= 2) {
                     $LineNumber=0;
                     $CurrentIdsDatabaseDataRecords = trim($CurrentIdsDatabaseMainArray[0]) . "\n";
                     $CurrentIdsDatabaseDataRecords .= trim($CurrentIdsDatabaseMainArray[1]) . "\n";
                     $IdsDatabaseStringLenArray = explode("|", $CurrentIdsDatabaseMainArray[1]);
                     unset($CurrentIdsDatabaseMainArray);
                     for($x=0; $x<$IdsCurrentDirectoryMainArrayCount; $x++) {
                        if(isset($IdsCurrentDirectoryMainArray[$x]) && is_dir($IdsCurrentDirectoryMainArray[$x])) {
                           $CurrentDirectoryDataRecordArray=array();
                           $CurrentDirectoryDataRecord='';
                           $LineNumber++;
                           $CurrentDirectoryDataRecordArray[]=$LineNumber;
                           $CurrentDirectoryDataRecordArray[]=$CurrentIdsDatabaseNumber;
                           $CurrentDirectoryDataRecordArray[]=1;
                           $CurrentDirectoryDataRecordArray[]=time();
                           $CurrentDirectoryDataRecordArray[]=time();
                           $CurrentDirectoryDataRecordArray[]=$IdsCurrentDirectoryMainArray[$x];
                           $StatDirectoryArray = @stat($CurrentDirectoryDataRecordArray[5]) or $DirectoryOwnerGroupReturnCode=1;
                           $DirectoryOwnerName='';
                           $DirectoryGroupName='';
                           $DirectoryOwnerGroupReturnCode='';
                           if(!empty($DirectoryOwnerGroupReturnCode) && $DirectoryOwnerGroupReturnCode == 1) {
                              print 'NOTE: DIRECTORY ' . $CurrentDirectoryDataRecordArray[5] . ' - function <strong>host_intrusion_detection_write_database</strong> - DIRECTORY-OWNER AND DIRECTORY-GROUP CAN NOT DETECT!';
                              exit;
                           }
                           else
                           {
                              $DirectoryOwnerId = $StatDirectoryArray[4];
                              $DirectoryGroupId = $StatDirectoryArray[5];
                              if($PosixGetPwuidArray = @posix_getpwuid($DirectoryOwnerId)) {
                                 $PosixGetPwuidArrayCount = count($PosixGetPwuidArray);
                                 for($k=0; $k<$PosixGetPwuidArrayCount; $k++) {
                                    $Key1 = key($PosixGetPwuidArray);
                                    if(strcasecmp($Key1, "name") == 0) {
                                       $DirectoryOwnerName = $PosixGetPwuidArray[$Key1];
                                       break;
                                    }
                                    next($PosixGetPwuidArray);
                                 }
                              }
                              if($PosixGetGrgidArray = @posix_getgrgid($DirectoryGroupId)) {
                                 $PosixGetGrgidArrayCount = count($PosixGetGrgidArray);
                                 for($k=0; $k<$PosixGetGrgidArrayCount; $k++) {
                                    $Key2 = key($PosixGetGrgidArray);
                                    if(strcasecmp($Key2, "name") == 0) {
                                       $DirectoryGroupName = $PosixGetGrgidArray[$Key2];
                                       break;
                                    }
                                    next($PosixGetGrgidArray);
                                 }
                              }
                           }
                           clearstatcache();
                           $CurrentDirectoryDataRecordArray[]=$DirectoryOwnerName;
                           $CurrentDirectoryDataRecordArray[]=$DirectoryOwnerName;
                           $CurrentDirectoryDataRecordArray[]=$DirectoryGroupName;
                           $CurrentDirectoryDataRecordArray[]=$DirectoryGroupName;
                           $DirectoryCurrentAccessPermission1 = fileperms($CurrentDirectoryDataRecordArray[5]);
                           $DirectoryCurrentAccessPermission2 = decoct($DirectoryCurrentAccessPermission1);
                           $DirectoryCurrentAccessPermission3 = substr($DirectoryCurrentAccessPermission2, -4);
                           $CurrentDirectoryDataRecordArray[]=$DirectoryCurrentAccessPermission3;
                           $CurrentDirectoryDataRecordArray[]=$DirectoryCurrentAccessPermission3;
                           $CurrentDirectoryDataRecordArray[] = filectime($CurrentDirectoryDataRecordArray[5]);
                           $CurrentDirectoryDataRecordArray[] = filectime($CurrentDirectoryDataRecordArray[5]);
                           $IdsCurrentDirectoryNumber=0;
                           $IdsCurrentFileNumber=0;
                           $IdsCurrentDirectoryHandle = @opendir($CurrentDirectoryDataRecordArray[5]);
                           while($IdsCurrentFileName = @readdir($IdsCurrentDirectoryHandle)) {
                              if($IdsCurrentFileName != "." && $IdsCurrentFileName != "..") {
                                 $NextFile = $CurrentDirectoryDataRecordArray[5] . "/" . $IdsCurrentFileName;
                                 if(file_exists($NextFile) && is_dir($NextFile)) {
                                    if(!empty($DirectoryExclusionLineArray) && is_array($DirectoryExclusionLineArray)) {
                                       $DirectoryExclusion=0;
                                       $DirectoryExclusionLineArrayCount = count($DirectoryExclusionLineArray);
                                       for($y=0; $y<$DirectoryExclusionLineArrayCount; $y++) {
                                          $DirectoryStringComparison = strcmp($NextFile, $DirectoryExclusionLineArray[$y]);
                                          if($DirectoryExclusionLineArray[$y] != "" && $DirectoryStringComparison == 0) {
                                             $DirectoryExclusion=1;
                                             break;
                                          }
                                       }
                                       if(empty($DirectoryExclusion)) {
                                          $IdsCurrentDirectoryNumber++;
                                       }
                                       else
                                       {
                                       unset($DirectoryExclusion);
                                       }
                                    }
                                    else
                                    {
                                    $IdsCurrentDirectoryNumber++;
                                    }
                                 } elseif(file_exists($NextFile) && !is_dir($NextFile)) {
                                    if(!empty($FileExclusionLineArray) && is_array($FileExclusionLineArray)) {
                                       $FileExclusion=0;
                                       $FileExclusionLineArrayCount = count($FileExclusionLineArray);
                                       for($y=0; $y<$FileExclusionLineArrayCount; $y++) {
                                          $FileStringComparison = strcmp($NextFile, $FileExclusionLineArray[$y]);
                                          if($FileExclusionLineArray[$y] != "" && $FileStringComparison == 0) {
                                             $FileExclusion=1;
                                             break;
                                          }
                                       }
                                       if(empty($FileExclusion)) {
                                          $IdsCurrentFileNumber++;
                                       }
                                       else
                                       {
                                       unset($FileExclusion);
                                       }
                                    }
                                    else
                                    {
                                    $IdsCurrentFileNumber++;
                                    }
                                 }
                              }
                           }
                           @closedir($IdsCurrentDirectoryHandle);
                           $CurrentDirectoryDataRecordArray[]=$IdsCurrentDirectoryNumber;
                           $CurrentDirectoryDataRecordArray[]=$IdsCurrentDirectoryNumber;
                           $CurrentDirectoryDataRecordArray[]=$IdsCurrentFileNumber;
                           $CurrentDirectoryDataRecordArray[]=$IdsCurrentFileNumber;
                           $Md5DirectoryContent = $CurrentDirectoryDataRecordArray[6] . $CurrentDirectoryDataRecordArray[8] . $CurrentDirectoryDataRecordArray[10] . $CurrentDirectoryDataRecordArray[12] . $IdsCurrentDirectoryNumber . $IdsCurrentFileNumber;
                           $Md5DirectoryValue = md5($Md5DirectoryContent);
                           $CurrentDirectoryDataRecordArray[]=$Md5DirectoryValue;
                           $CurrentDirectoryDataRecordArray[]=$Md5DirectoryValue;
                           $CurrentDirectoryDataRecordArray[]=1;
                           $CurrentDirectoryDataRecordArrayCount = count($CurrentDirectoryDataRecordArray);
                           $DataRecordEmptyCount = $IdsDatabaseMaximalFieldCount - $CurrentDirectoryDataRecordArrayCount;
                           for($y=0; $y<$DataRecordEmptyCount; $y++) {
                              $CurrentDirectoryDataRecordArray[]='';
                           }
                           $CurrentDirectoryDataRecordArrayCount = count($CurrentDirectoryDataRecordArray);
                           for($y=0; $y<$CurrentDirectoryDataRecordArrayCount; $y++) {
                              // maximale Stringlaenge pruefen
                              $CurrentFieldStringLen = strlen($CurrentDirectoryDataRecordArray[$y]);
                              $IdsDatabaseFieldStringLen = trim($IdsDatabaseStringLenArray[$y]);
                              if(preg_match("/^[0-9]{1,5}$/", $IdsDatabaseFieldStringLen)) {
                                 if($CurrentFieldStringLen > $IdsDatabaseFieldStringLen) {
                                    // Laenge des Array-Elementes auf die maximale zulaessige Laenge kuerzen
                                    $CurrentDirectoryDataRecordArray[$y] = substr($CurrentDirectoryDataRecordArray[$y], 0, $IdsDatabaseFieldStringLen);
                                 }
                                 $CurrentDirectoryDataRecordArray[$y] = htmlspecialchars($CurrentDirectoryDataRecordArray[$y], ENT_QUOTES);
                                 // Zeilenumbruch (Windows: \r\n, MAC: \r, Unix/linux: \n) in den HTML-Code umsetzen
                                 $CurrentDirectoryDataRecordArray[$y] = preg_replace('/\r\n|\r|\n/', '<br>', $CurrentDirectoryDataRecordArray[$y]);
                                 // gerader Strich (|) ist reserveiert als Feldtrenner
                                 $CurrentDirectoryDataRecordArray[$y] = preg_replace('/\|/', '&#124;', $CurrentDirectoryDataRecordArray[$y]);
                              }
                              else
                              {
                                 print 'NOTE 1: SYSTEM-FILE ' . $HostIntrusionDetectionCurrentDatabaseFilepath . ' - function <strong>host_intrusion_detection_write_database</strong> - IS DAMAGED!';
                                 exit;
                              }
                           }
                           $CurrentDirectoryDataRecordArrayCount = count($CurrentDirectoryDataRecordArray);
                           for($y=0; $y<$CurrentDirectoryDataRecordArrayCount; $y++) {
                              if(isset($CurrentDirectoryDataRecordArray[$y])) {
                                 if($y == 0) {
                                    $CurrentDirectoryDataRecord .= $CurrentDirectoryDataRecordArray[$y];
                                 }
                                 else
                                 {
                                 $CurrentDirectoryDataRecord .= '|' . $CurrentDirectoryDataRecordArray[$y];
                                 }
                              }
                              else
                              {
                              $CurrentDirectoryDataRecord .= '|';
                              }
                           }
                           $CurrentDirectoryDataRecord .= "\n";
                           $CurrentIdsDatabaseDataRecords .= $CurrentDirectoryDataRecord;
                           unset($CurrentDirectoryDataRecordArray);
                           for($z=0; $z<$IdsCurrentFileMainArrayCount; $z++) {
                              if(isset($IdsCurrentFileMainArray[$z]) && file_exists($IdsCurrentFileMainArray[$z])) {
                                 if(preg_match("@^" . $IdsCurrentDirectoryMainArray[$x] . "/[^/]+$@", $IdsCurrentFileMainArray[$z])) {
                                    $CurrentFileDataRecordArray=array();
                                    $CurrentFileDataRecord='';
                                    $LineNumber++;
                                    $CurrentFileDataRecordArray[]=$LineNumber;
                                    $CurrentFileDataRecordArray[]=$CurrentIdsDatabaseNumber;
                                    $CurrentFileDataRecordArray[]=1;
                                    $CurrentFileDataRecordArray[]=time();
                                    $CurrentFileDataRecordArray[]=time();
                                    $DataRecordEmptyCount = $IdsDatabaseMaximalFieldCount - 19;
                                    for($y=0; $y<$DataRecordEmptyCount; $y++) {
                                       $CurrentFileDataRecordArray[]='';
                                    }
                                    $CurrentFileDataRecordArray[]=$IdsCurrentFileMainArray[$z];
                                    $StatFileArray = @stat($CurrentFileDataRecordArray[21]) or $FileOwnerGroupReturnCode=1;
                                    $FileOwnerName='';
                                    $FileGroupName='';
                                    $FileOwnerGroupReturnCode='';
                                    if(!empty($FileOwnerGroupReturnCode) && $FileOwnerGroupReturnCode == 1) {
                                       print 'NOTE: FILE ' . $CurrentFileDataRecordArray[21] . ' - function <strong>host_intrusion_detection_write_database</strong> - FILE-OWNER AND FILE-GROUP CAN NOT DETECT!';
                                       exit;
                                    }
                                    else
                                    {
                                       $FileOwnerId = $StatFileArray[4];
                                       $FileGroupId = $StatFileArray[5];
                                       if($PosixGetPwuidArray = @posix_getpwuid($FileOwnerId)) {
                                          $PosixGetPwuidArrayCount = count($PosixGetPwuidArray);
                                          for($k=0; $k<$PosixGetPwuidArrayCount; $k++) {
                                             $Key1 = key($PosixGetPwuidArray);
                                             if(strcasecmp($Key1, "name") == 0) {
                                                $FileOwnerName = $PosixGetPwuidArray[$Key1];
                                                break;
                                             }
                                             next($PosixGetPwuidArray);
                                          }
                                       }
                                       if($PosixGetGrgidArray = @posix_getgrgid($FileGroupId)) {
                                          $PosixGetGrgidArrayCount = count($PosixGetGrgidArray);
                                          for($k=0; $k<$PosixGetGrgidArrayCount; $k++) {
                                             $Key2 = key($PosixGetGrgidArray);
                                             if(strcasecmp($Key2, "name") == 0) {
                                                $FileGroupName = $PosixGetGrgidArray[$Key2];
                                                break;
                                             }
                                             next($PosixGetGrgidArray);
                                          }
                                       }
                                    }
                                    clearstatcache();
                                    $CurrentFileDataRecordArray[]=$FileOwnerName;
                                    $CurrentFileDataRecordArray[]=$FileOwnerName;
                                    $CurrentFileDataRecordArray[]=$FileGroupName;
                                    $CurrentFileDataRecordArray[]=$FileGroupName;
                                    $FileCurrentAccessPermission1 = fileperms($IdsCurrentFileMainArray[$z]);
                                    $FileCurrentAccessPermission2 = decoct($FileCurrentAccessPermission1);
                                    $FileCurrentAccessPermission3 = substr($FileCurrentAccessPermission2, -4);
                                    $CurrentFileDataRecordArray[]=$FileCurrentAccessPermission3;
                                    $CurrentFileDataRecordArray[]=$FileCurrentAccessPermission3;
                                    $CurrentFileDataRecordArray[] = filemtime($IdsCurrentFileMainArray[$z]);
                                    $CurrentFileDataRecordArray[] = filemtime($IdsCurrentFileMainArray[$z]);
                                    $CurrentFileDataRecordArray[] = filesize($IdsCurrentFileMainArray[$z]);
                                    $CurrentFileDataRecordArray[] = filesize($IdsCurrentFileMainArray[$z]);
                                    $Md5FileContent = $CurrentFileDataRecordArray[22] . $CurrentFileDataRecordArray[24] .  $CurrentFileDataRecordArray[26] . $CurrentFileDataRecordArray[28] . $CurrentFileDataRecordArray[30];
                                    $Md5FileValue = md5($Md5FileContent);
                                    $CurrentFileDataRecordArray[]=$Md5FileValue;
                                    $CurrentFileDataRecordArray[]=$Md5FileValue;
                                    $CurrentFileDataRecordArray[]=1;
                                    $CurrentFileDataRecordArrayCount = count($CurrentFileDataRecordArray);
                                    for($y=0; $y<$CurrentFileDataRecordArrayCount; $y++) {
                                       // maximale Stringlaenge pruefen
                                       $CurrentFieldStringLen = strlen($CurrentFileDataRecordArray[$y]);
                                       $IdsDatabaseFieldStringLen = trim($IdsDatabaseStringLenArray[$y]);
                                       if(preg_match("/^[0-9]{1,5}$/", $IdsDatabaseFieldStringLen)) {
                                          if($CurrentFieldStringLen > $IdsDatabaseFieldStringLen) {
                                             // Laenge des Array-Elementes auf die maximale zulaessige Laenge kuerzen
                                             $CurrentFileDataRecordArray[$y] = substr($CurrentFileDataRecordArray[$y], 0, $IdsDatabaseFieldStringLen);
                                          }
                                          $CurrentFileDataRecordArray[$y] = htmlspecialchars($CurrentFileDataRecordArray[$y], ENT_QUOTES);
                                          // Zeilenumbruch (Windows: \r\n, MAC: \r, Unix/linux: \n) in den HTML-Code umsetzen
                                          $CurrentFileDataRecordArray[$y] = preg_replace('/\r\n|\r|\n/', '<br>', $CurrentFileDataRecordArray[$y]);
                                          // gerader Strich (|) ist reserveiert als Feldtrenner
                                          $CurrentFileDataRecordArray[$y] = preg_replace('/\|/', '&#124;', $CurrentFileDataRecordArray[$y]);
                                       }
                                       else
                                       {
                                          print 'NOTE 2: SYSTEM-FILE ' . $HostIntrusionDetectionCurrentDatabaseFilepath . ' - function <strong>host_intrusion_detection_write_database</strong> - IS DAMAGED!';
                                          exit;
                                       }
                                    }
                                    $CurrentFileDataRecordArrayCount = count($CurrentFileDataRecordArray);
                                    for($y=0; $y<$CurrentFileDataRecordArrayCount; $y++) {
                                       if(isset($CurrentFileDataRecordArray[$y])) {
                                          if($y == 0) {
                                             $CurrentFileDataRecord .= $CurrentFileDataRecordArray[$y];
                                          }
                                          else
                                          {
                                          $CurrentFileDataRecord .= '|' . $CurrentFileDataRecordArray[$y];
                                          }
                                       }
                                       else
                                       {
                                       $CurrentFileDataRecord .= '|';
                                       }
                                    }
                                    $CurrentFileDataRecord .= "\n";
                                    $CurrentIdsDatabaseDataRecords .= $CurrentFileDataRecord;
                                    unset($CurrentFileDataRecordArray);
                                 }
                              }
                           }
                        }
                     }
                     if($DatabaseFileWrite = @fopen($HostIntrusionDetectionCurrentDatabaseFilepath,'w')) {
                        @flock($DatabaseFileWrite,2);
                        @fwrite($DatabaseFileWrite, $CurrentIdsDatabaseDataRecords);
                        @flock($DatabaseFileWrite,3);
                        @fclose($DatabaseFileWrite);
                        $ReturnCodeMainDatabase=1;
                     }
                     else
                     { 
                     $ReturnCodeMainDatabase=5;
                     }
                     unset($IdsCurrentDirectoryMainArray);
                     unset($IdsCurrentFileMainArray);
                  }
                  else
                  {
                  $ReturnCodeMainDatabase=3;
                  }
                  unset($DirectoryExclusionLineArray);
                  unset($FileExclusionLineArray);
               }
               else
               {
                  print 'NOTE: SYSTEM-VARIABLES - function <strong>host_intrusion_detection_write_database</strong> - NOT DEFINED OR DAMAGED!';
                  exit;
               }
            }
         }
         else
         {
         $ReturnCodeMainDatabase=2;
         }
         array_push($ReturnCodeArray, $ConfigurationReturnCode, $ReportReturnCode, $ReturnCodeMainDatabase, $ReturnCodeDirectoryExclusion, $ReturnCodeFileExclusion);
         return $ReturnCodeArray;
      }
      else
      {
         print 'NOTE: SYSTEM-ARRAY HostIntrusionDetectionArray (ARRAY-COUNT) - function <strong>host_intrusion_detection_write_database</strong> - IS DAMAGED!';
         exit;
      }
   }

   // Funktion fuer die Aktualisierung der IDS-Datenbanken
   function host_intrusion_detection_updating_database($HostIntrusionDetectionCurrentDatabaseFilepath='', $HostIntrusionDetectionCurrentConfigurationDatabaseFilepath='', $HostIntrusionDetectionCurrentReportDatabaseFilepath='', $HostIntrusionDetectionCurrentDirectoryExclusionFilepath='', $HostIntrusionDetectionCurrentFileExclusionFilepath='', $HostIntrusionDetectionArray='', $CurrentIdsDatabaseNumber='') {
      // Funktion ueberschreibt in 3 bis 5 Datenbanken (hids_db_x.dat, configuration_x.dat, directory_file_report_x.dat, directory_exclusion_x.dat, file_exclusion_x.dat)
      $ReturnCodeArray=array();
      $ConfigurationReturnCode=0;
      $ReportReturnCode=0;
      $ReturnCodeMainDatabase=0;
      $ReturnCodeDirectoryExclusion='';
      $ReturnCodeFileExclusion='';
      $HostIntrusionDetectionArrayDefaultCount=11; // Vorgabe: Anzahl der Array-Elemente
      $HostIntrusionDetectionArrayCurrentCount=count($HostIntrusionDetectionArray);
      $ConfigurationDatabaseMaximalFieldCount=8; // maximale Anzahl der Felder in der Reportdatenbank
      $ReportDatabaseMaximalFieldCount=12; // maximale Anzahl der Felder in der Reportdatenbank
      $IdsDatabaseMaximalFieldCount=35; // maximale Anzahl der Felder in der Hauptdatenbank
      $DatabaseDirectoryExclusionFieldCount=11; // maximale Anzahl der Felder in der Datenbank fuer die auszuschlieszenden Verzeichnisse
      $DirectoryExclusionMaximalCount=5; // maximale Anzahl der auszuschlieszenden Verzeichnisse
      $DatabaseFileExclusionFieldCount=11; // maximale Anzahl der Felder in der Datenbank fuer die auszuschlieszenden Dateien
      $FileExclusionMaximalCount=5; // maximale Anzahl der auszuschlieszenden Dateien
      if(isset($HostIntrusionDetectionArray) &&
         is_array($HostIntrusionDetectionArray) &&
         $HostIntrusionDetectionArrayDefaultCount == $HostIntrusionDetectionArrayCurrentCount) {
         if(!empty($HostIntrusionDetectionCurrentDatabaseFilepath) &&
            file_exists($HostIntrusionDetectionCurrentDatabaseFilepath) &&
            is_writeable($HostIntrusionDetectionCurrentDatabaseFilepath)) {
            if(!empty($HostIntrusionDetectionArray[2])) {
               if(!empty($HostIntrusionDetectionArray[3]) &&
                  !empty($HostIntrusionDetectionArray[4]) &&
                  preg_match("/^([1-9]|[1][0-2])$/", $HostIntrusionDetectionArray[4]) &&
                  isset($HostIntrusionDetectionArray[6]) &&
                  isset($HostIntrusionDetectionArray[8]) &&
                  is_array($HostIntrusionDetectionArray[8]) &&
                  isset($HostIntrusionDetectionArray[9]) &&
                  is_array($HostIntrusionDetectionArray[9]) &&
                  !empty($ConfigurationDatabaseMaximalFieldCount) &&
                  !empty($ReportDatabaseMaximalFieldCount) &&
                  !empty($DatabaseDirectoryExclusionFieldCount) &&
                  !empty($DatabaseFileExclusionFieldCount) &&
                  !empty($IdsDatabaseMaximalFieldCount) &&
                  !empty($CurrentIdsDatabaseNumber)) {
                  // die auszuschlieszenden Verzeichnisse in die zustaendige Datenbank eintragen
                  if(!empty($HostIntrusionDetectionCurrentDirectoryExclusionFilepath) &&
                     file_exists($HostIntrusionDetectionCurrentDirectoryExclusionFilepath) &&
                     is_readable($HostIntrusionDetectionCurrentDirectoryExclusionFilepath) &&
                     is_writeable($HostIntrusionDetectionCurrentDirectoryExclusionFilepath)) {
                     $ReturnCodeDirectoryExclusion=0;
                     $DirectoryExclusionFileArray = file($HostIntrusionDetectionCurrentDirectoryExclusionFilepath);
                     $DirectoryExclusionFileArrayCount = count($DirectoryExclusionFileArray);
                     if($DirectoryExclusionFileArrayCount >= 2) {
                        $DirectoryExclusionDataRecords = trim($DirectoryExclusionFileArray[0]) . "\n";
                        $DirectoryExclusionDataRecords .= trim($DirectoryExclusionFileArray[1]) . "\n";
                        $DatabaseDirectoryExclusionFieldStringLenArray = explode("|", $DirectoryExclusionFileArray[1]);
                        $DatabaseDirectoryExclusionFieldStringLenArrayCount = count($DatabaseDirectoryExclusionFieldStringLenArray);
                        if(preg_match("/^[0-9]{1,2}$/", $DatabaseDirectoryExclusionFieldStringLenArrayCount) && $DatabaseDirectoryExclusionFieldStringLenArrayCount == $DatabaseDirectoryExclusionFieldCount) {
                           $DirectoryExclusionFormArrayCount = count($HostIntrusionDetectionArray[8]);
                           if($DirectoryExclusionFormArrayCount >= 1) {
                              $CurrentDirectoryExclusionArray=array();
                              $CurrentDirectoryExclusionArray[]=1;
                              $CurrentDirectoryExclusionArray[]=$CurrentIdsDatabaseNumber;
                              $CurrentDirectoryExclusionArray[]=1;
                              if($DirectoryExclusionFileArrayCount >= 3) {
                                 $DatabaseDirectoryExclusionLineThreeArray = explode("|", $DirectoryExclusionFileArray[2]);
                                 $CurrentDirectoryExclusionCreateTime = trim($DatabaseDirectoryExclusionLineThreeArray[3]);
                                 if(preg_match("/^[0-9]{1,}$/", $CurrentDirectoryExclusionCreateTime)) {
                                    $CurrentDirectoryExclusionArray[]=$CurrentDirectoryExclusionCreateTime;
                                 }
                                 else
                                 {
                                    print 'NOTE 1: SYSTEM-FILE ' . $HostIntrusionDetectionCurrentDirectoryExclusionFilepath . ' - function <strong>host_intrusion_detection_updating_database</strong> - IS DAMAGED!';
                                    exit;
                                 }
                              }
                              else
                              {
                              $CurrentDirectoryExclusionArray[]=time();
                              }
                              $CurrentDirectoryExclusionArray[]=time();
                              if(empty($HostIntrusionDetectionArray[10])) {
                                 for($x=0; $x<$DirectoryExclusionFormArrayCount; $x++) {
                                    $CurrentDirectoryExclusion = trim($HostIntrusionDetectionArray[8][$x]);
                                    $CurrentDirectoryExclusionSlashCount = substr_count($CurrentDirectoryExclusion, '/');
                                    for($y=0; $y<$CurrentDirectoryExclusionSlashCount; $y++) {
                                       $DirectoryPathSlashSearch = substr($CurrentDirectoryExclusion, -1);
                                       if(preg_match("@^/$@", $DirectoryPathSlashSearch)) {
                                          $CurrentDirectoryExclusion = substr($CurrentDirectoryExclusion, 0, -1);
                                       }
                                       else
                                       {
                                       break;
                                       }
                                    }
                                    if(!empty($CurrentDirectoryExclusion) &&
                                       preg_match("@^(\./|\.\./).+@", $CurrentDirectoryExclusion) &&
                                       is_dir($CurrentDirectoryExclusion)) {
                                       $CurrentDirectoryExclusionArray[]=$CurrentDirectoryExclusion;
                                    }
                                    else
                                    {
                                    $CurrentDirectoryExclusionArray[]='';
                                    }
                                 }
                              }
                              else
                              {
                                 for($x=0; $x<$DirectoryExclusionFormArrayCount; $x++) {
                                    $CurrentDirectoryExclusion = trim($HostIntrusionDetectionArray[8][$x]);
                                    $CurrentDirectoryExclusionArray[]=$CurrentDirectoryExclusion;
                                 }
                              }
                              if(!empty($HostIntrusionDetectionArray[10]) && preg_match("/^[1]$/", $HostIntrusionDetectionArray[10])) {
                                 $CurrentDirectoryExclusionArray[]=1;
                              }
                              else
                              {
                              $CurrentDirectoryExclusionArray[]=0;
                              }
                              $CurrentDirectoryExclusionArrayCount = count($CurrentDirectoryExclusionArray);
                              for($y=0; $y<$CurrentDirectoryExclusionArrayCount; $y++) {
                                 // maximale Stringlaenge pruefen
                                 $CurrentDirectoryExclusionFieldStringLen = strlen($CurrentDirectoryExclusionArray[$y]);
                                 $DatabaseDirectoryExclusionFieldStringLen = trim($DatabaseDirectoryExclusionFieldStringLenArray[$y]);
                                 if(preg_match("/^[0-9]{1,3}$/", $DatabaseDirectoryExclusionFieldStringLen)) {
                                    if($CurrentDirectoryExclusionFieldStringLen > $DatabaseDirectoryExclusionFieldStringLen) {
                                       // Laenge des Array-Elementes auf die maximale zulaessige Laenge kuerzen
                                       $CurrentDirectoryExclusionArray[$y] = substr($CurrentDirectoryExclusionArray[$y], 0, $DatabaseDirectoryExclusionFieldStringLen);
                                    }
                                    $CurrentDirectoryExclusionArray[$y] = htmlspecialchars($CurrentDirectoryExclusionArray[$y], ENT_QUOTES);
                                    // Zeilenumbruch (Windows: \r\n, MAC: \r, Unix/linux: \n) in den HTML-Code umsetzen
                                    $CurrentDirectoryExclusionArray[$y] = preg_replace('/\r\n|\r|\n/', '<br>', $CurrentDirectoryExclusionArray[$y]);
                                    // gerader Strich (|) ist reserveiert als Feldtrenner
                                    $CurrentDirectoryExclusionArray[$y] = preg_replace('/\|/', '&#124;', $CurrentDirectoryExclusionArray[$y]);
                                 }
                                 else
                                 {
                                    print 'NOTE 2: SYSTEM-FILE ' . $HostIntrusionDetectionCurrentDirectoryExclusionFilepath . ' - function <strong>host_intrusion_detection_updating_database</strong> - IS DAMAGED!';
                                    exit;
                                 }
                              }
                              $DirectoryExclusionDataRecordFields='';
                              $CurrentDirectoryExclusionArrayCount = count($CurrentDirectoryExclusionArray);
                              for($z=0; $z<$CurrentDirectoryExclusionArrayCount; $z++) {
                                 if(isset($CurrentDirectoryExclusionArray[$z])) {
                                    if($z == 0) {
                                       $DirectoryExclusionDataRecordFields .= $CurrentDirectoryExclusionArray[$z];
                                    }
                                    else
                                    {
                                    $DirectoryExclusionDataRecordFields .= '|' . $CurrentDirectoryExclusionArray[$z];
                                    }
                                 }
                                 else
                                 {
                                 $DirectoryExclusionDataRecordFields .= '|';
                                 }
                              }
                              $DirectoryExclusionDataRecordFields .= "\n";
                              $DirectoryExclusionDataRecords .= $DirectoryExclusionDataRecordFields;
                              unset($CurrentDirectoryExclusionArray);
                              if($DirectoryExclusionFileWrite = @fopen($HostIntrusionDetectionCurrentDirectoryExclusionFilepath,'w')) {
                                 @flock($DirectoryExclusionFileWrite,2);
                                 @fwrite($DirectoryExclusionFileWrite, $DirectoryExclusionDataRecords);
                                 @flock($DirectoryExclusionFileWrite,3);
                                 @fclose($DirectoryExclusionFileWrite);
                                 $ReturnCodeDirectoryExclusion=1;
                              }
                              else
                              { 
                              $ReturnCodeDirectoryExclusion=4;
                              }
                           }
                        }
                        else
                        {
                        $ReturnCodeDirectoryExclusion=3;
                        }
                     }
                     else
                     {
                     $ReturnCodeDirectoryExclusion=2;
                     }
                     unset($DirectoryExclusionFileArray);
                  }
                  // die auszuschlieszenden Dateien in die zustaendige Datenbank eintragen
                  if(!empty($HostIntrusionDetectionCurrentFileExclusionFilepath) && 
                     file_exists($HostIntrusionDetectionCurrentFileExclusionFilepath) &&
                     is_readable($HostIntrusionDetectionCurrentFileExclusionFilepath) &&
                     is_writeable($HostIntrusionDetectionCurrentFileExclusionFilepath)) {
                     $ReturnCodeFileExclusion=0;
                     $FileExclusionFileArray = file($HostIntrusionDetectionCurrentFileExclusionFilepath);
                     $FileExclusionFileArrayCount = count($FileExclusionFileArray);
                     if($FileExclusionFileArrayCount >= 2) {
                        $FileExclusionDataRecords = trim($FileExclusionFileArray[0]) . "\n";
                        $FileExclusionDataRecords .= trim($FileExclusionFileArray[1]) . "\n";
                        $DatabaseFileExclusionFieldStringLenArray = explode("|", $FileExclusionFileArray[1]);
                        $DatabaseFileExclusionFieldStringLenArrayCount = count($DatabaseFileExclusionFieldStringLenArray);
                        if(preg_match("/^[0-9]{1,2}$/", $DatabaseFileExclusionFieldStringLenArrayCount) && $DatabaseFileExclusionFieldStringLenArrayCount == $DatabaseFileExclusionFieldCount) {
                           $FileExclusionFormArrayCount = count($HostIntrusionDetectionArray[9]);
                           if($FileExclusionFormArrayCount >= 1) {
                              $CurrentFileExclusionArray=array();
                              $CurrentFileExclusionArray[]=1;
                              $CurrentFileExclusionArray[]=$CurrentIdsDatabaseNumber;
                              $CurrentFileExclusionArray[]=1;
                              if($FileExclusionFileArrayCount >= 3) {
                                 $DatabaseFileExclusionLineThreeArray = explode("|", $FileExclusionFileArray[2]);
                                 $CurrentFileExclusionCreateTime = trim($DatabaseFileExclusionLineThreeArray[3]);
                                 if(preg_match("/^[0-9]{1,}$/", $CurrentFileExclusionCreateTime)) {
                                    $CurrentFileExclusionArray[]=$CurrentFileExclusionCreateTime;
                                 }
                                 else
                                 {
                                    print 'NOTE 1: SYSTEM-FILE ' . $HostIntrusionDetectionCurrentFileExclusionFilepath . ' - function <strong>host_intrusion_detection_updating_database</strong> - IS DAMAGED!';
                                    exit;
                                 }
                              }
                              else
                              {
                              $CurrentFileExclusionArray[]=time();
                              }
                              $CurrentFileExclusionArray[]=time();
                              if(empty($HostIntrusionDetectionArray[10])) {
                                 for($x=0; $x<$FileExclusionFormArrayCount; $x++) {
                                    $CurrentFileExclusion = trim($HostIntrusionDetectionArray[9][$x]);
                                    if(!empty($CurrentFileExclusion) &&
                                       preg_match("@^(\./|\.\./).+@", $CurrentFileExclusion) &&
                                       file_exists($CurrentFileExclusion)) {
                                       $CurrentFileExclusionArray[]=$CurrentFileExclusion;
                                    }
                                    else
                                    {
                                    $CurrentFileExclusionArray[]='';
                                    }
                                 }
                              }
                              else
                              {
                                 for($x=0; $x<$FileExclusionFormArrayCount; $x++) {
                                    $CurrentFileExclusion = trim($HostIntrusionDetectionArray[9][$x]);
                                    $CurrentFileExclusionArray[]=$CurrentFileExclusion;
                                 }
                              }
                              if(!empty($HostIntrusionDetectionArray[10]) && preg_match("/^[1]$/", $HostIntrusionDetectionArray[10])) {
                                 $CurrentFileExclusionArray[]=1;
                              }
                              else
                              {
                              $CurrentFileExclusionArray[]=0;
                              }
                              $CurrentFileExclusionArrayCount = count($CurrentFileExclusionArray);
                              for($y=0; $y<$CurrentFileExclusionArrayCount; $y++) {
                                 // maximale Stringlaenge pruefen
                                 $CurrentFileExclusionFieldStringLen = strlen($CurrentFileExclusionArray[$y]);
                                 $DatabaseFileExclusionFieldStringLen = trim($DatabaseFileExclusionFieldStringLenArray[$y]);
                                 if(preg_match("/^[0-9]{1,3}$/", $DatabaseFileExclusionFieldStringLen)) {
                                    if($CurrentFileExclusionFieldStringLen > $DatabaseFileExclusionFieldStringLen) {
                                       // Laenge des Array-Elementes auf die maximale zulaessige Laenge kuerzen
                                       $CurrentFileExclusionArray[$y] = substr($CurrentFileExclusionArray[$y], 0, $DatabaseFileExclusionFieldStringLen);
                                    }
                                    $CurrentFileExclusionArray[$y] = htmlspecialchars($CurrentFileExclusionArray[$y], ENT_QUOTES);
                                    // Zeilenumbruch (Windows: \r\n, MAC: \r, Unix/linux: \n) in den HTML-Code umsetzen
                                    $CurrentFileExclusionArray[$y] = preg_replace('/\r\n|\r|\n/', '<br>', $CurrentFileExclusionArray[$y]);
                                    // gerader Strich (|) ist reserveiert als Feldtrenner
                                    $CurrentFileExclusionArray[$y] = preg_replace('/\|/', '&#124;', $CurrentFileExclusionArray[$y]);
                                 }
                                 else
                                 {
                                    print 'NOTE 2: SYSTEM-FILE ' . $HostIntrusionDetectionCurrentFileExclusionFilepath . ' - function <strong>host_intrusion_detection_updating_database</strong> - IS DAMAGED!';
                                    exit;
                                 }
                              }
                              $FileExclusionDataRecordFields='';
                              $CurrentFileExclusionArrayCount = count($CurrentFileExclusionArray);
                              for($z=0; $z<$CurrentFileExclusionArrayCount; $z++) {
                                 if(isset($CurrentFileExclusionArray[$z])) {
                                    if($z == 0) {
                                       $FileExclusionDataRecordFields .= $CurrentFileExclusionArray[$z];
                                    }
                                    else
                                    {
                                    $FileExclusionDataRecordFields .= '|' . $CurrentFileExclusionArray[$z];
                                    }
                                 }
                                 else
                                 {
                                 $FileExclusionDataRecordFields .= '|';
                                 }
                              }
                              $FileExclusionDataRecordFields .= "\n";
                              $FileExclusionDataRecords .= $FileExclusionDataRecordFields;
                              unset($CurrentFileExclusionArray);
                              if($FileExclusionFileWrite = @fopen($HostIntrusionDetectionCurrentFileExclusionFilepath,'w')) {
                                 @flock($FileExclusionFileWrite,2);
                                 @fwrite($FileExclusionFileWrite, $FileExclusionDataRecords);
                                 @flock($FileExclusionFileWrite,3);
                                 @fclose($FileExclusionFileWrite);
                                 $ReturnCodeFileExclusion=1;
                              }
                              else
                              { 
                              $ReturnCodeFileExclusion=4;
                              }
                           }
                        }
                        else
                        {
                        $ReturnCodeFileExclusion=3;
                        }
                     }
                     else
                     {
                     $ReturnCodeFileExclusion=2;
                     }
                     unset($FileExclusionFileArray);
                  }
                  // auslesen der auszuschlieszenden Verzeichnisse
                  $DirectoryExclusionLineArray=array();
                  if(file_exists($HostIntrusionDetectionCurrentDirectoryExclusionFilepath) && is_readable($HostIntrusionDetectionCurrentDirectoryExclusionFilepath)) {
                     $DirectoryExclusionArray = file($HostIntrusionDetectionCurrentDirectoryExclusionFilepath);
                     $CurrentDirectoryExclusionArrayCount = count($DirectoryExclusionArray);
                     if($CurrentDirectoryExclusionArrayCount >= 3) {
                        $DirectoryExclusionExplodeArray = explode("|", $DirectoryExclusionArray[2]);
                        $DirectoryExclusionExplodeArrayCount = count($DirectoryExclusionExplodeArray);
                        $DirectoryExclusionFieldCount = $DirectoryExclusionExplodeArrayCount - 1;
                        // die ersten 5 Felder und das letzte Feld enthalten keine Verzeichnispfade
                        for($y=5; $y<$DirectoryExclusionFieldCount; $y++) {
                           $DirectoryExclusionLineArray[]=$DirectoryExclusionExplodeArray[$y];
                        }
                        unset($DirectoryExclusionExplodeArray);
                     }
                     else
                     {
                        print 'NOTE 3: SYSTEM-FILE ' . $HostIntrusionDetectionCurrentDirectoryExclusionFilepath . ' - function <strong>host_intrusion_detection_updating_database</strong> - IS DAMAGED!';
                        exit;
                     }
                     unset($DirectoryExclusionArray);
                  }
                  // auslesen der auszuschlieszenden Dateien
                  $FileExclusionLineArray=array();
                  if(file_exists($HostIntrusionDetectionCurrentFileExclusionFilepath) && is_readable($HostIntrusionDetectionCurrentFileExclusionFilepath)) {
                     $FileExclusionArray = file($HostIntrusionDetectionCurrentFileExclusionFilepath);
                     $FileExclusionArrayCount = count($FileExclusionArray);
                     if($FileExclusionArrayCount >= 3) {
                        $FileExclusionExplodeArray = explode("|", $FileExclusionArray[2]);
                        $FileExclusionExplodeArrayCount = count($FileExclusionExplodeArray);
                        $FileExclusionFieldCount = $FileExclusionExplodeArrayCount - 1;
                        // die ersten 5 Felder und das letzte Feld enthalten keine Dateipfade
                        for($y=5; $y<$FileExclusionFieldCount; $y++) {
                           $FileExclusionLineArray[]=$FileExclusionExplodeArray[$y];
                        }
                        unset($FileExclusionExplodeArray);
                     }
                     else
                     {
                        print 'NOTE 3: SYSTEM-FILE ' . $HostIntrusionDetectionCurrentFileExclusionFilepath . ' - function <strong>host_intrusion_detection_updating_database</strong> - IS DAMAGED!';
                        exit;
                     }
                     unset($FileExclusionArray);
                  }
                  // Verzeichnispfad, Verzeichnistiefe und Texthinweise (Textarea) in die Konfigurations-Datenbank eintragen
                  if(!empty($HostIntrusionDetectionCurrentConfigurationDatabaseFilepath) &&
                     file_exists($HostIntrusionDetectionCurrentConfigurationDatabaseFilepath) &&
                     is_writeable($HostIntrusionDetectionCurrentConfigurationDatabaseFilepath)) {
                     $CurrentConfigurationDatabaseArray = file($HostIntrusionDetectionCurrentConfigurationDatabaseFilepath);
                     $CurrentConfigurationDatabaseArrayCount = count($CurrentConfigurationDatabaseArray);
                     if($CurrentConfigurationDatabaseArray >= 2) {
                        $CurrentConfigurationDatabaseDataRecords = trim($CurrentConfigurationDatabaseArray[0]) . "\n";
                        $CurrentConfigurationDatabaseDataRecords .= trim($CurrentConfigurationDatabaseArray[1]) . "\n";
                        $CurrentConfigurationDatabaseStringLenArray = explode("|", $CurrentConfigurationDatabaseArray[1]);
                        $CurrentConfigurationDatabaseStringLenArrayCount = count($CurrentConfigurationDatabaseStringLenArray);
                        if(preg_match("/^[0-9]{1,2}$/", $CurrentConfigurationDatabaseStringLenArrayCount) && $CurrentConfigurationDatabaseStringLenArrayCount == $ConfigurationDatabaseMaximalFieldCount) {
                           unset($CurrentConfigurationDatabaseArray);
                           $CurrentConfigurationDataRecordArray=array();
                           $CurrentConfigurationDataRecordArray[]=1;
                           $CurrentConfigurationDataRecordArray[]=$CurrentIdsDatabaseNumber;
                           $CurrentConfigurationDataRecordArray[]=1;
                           $CurrentConfigurationDataRecordArray[]=time();
                           $CurrentConfigurationDataRecordArray[]=time();
                           $CurrentConfigurationDataRecordArray[]=$HostIntrusionDetectionArray[3];
                           $CurrentConfigurationDataRecordArray[]=$HostIntrusionDetectionArray[4];
                           $CurrentConfigurationDataRecordArray[]=$HostIntrusionDetectionArray[6];
                           $CurrentConfigurationDataRecordArrayCount = count($CurrentConfigurationDataRecordArray);
                           for($y=0; $y<$CurrentConfigurationDataRecordArrayCount; $y++) {
                              // maximale Stringlaenge pruefen
                              $CurrentFieldStringLen = strlen($CurrentConfigurationDataRecordArray[$y]);
                              $ConfigurationDatabaseFieldStringLen = trim($CurrentConfigurationDatabaseStringLenArray[$y]);
                              if(preg_match("/^[0-9]{1,5}$/", $ConfigurationDatabaseFieldStringLen)) {
                                 if($CurrentFieldStringLen > $ConfigurationDatabaseFieldStringLen) {
                                    // Laenge des Array-Elementes auf die maximale zulaessige Laenge kuerzen
                                    $CurrentConfigurationDataRecordArray[$y] = substr($CurrentConfigurationDataRecordArray[$y], 0, $ConfigurationDatabaseFieldStringLen);
                                 }
                                 $CurrentConfigurationDataRecordArray[$y] = htmlspecialchars($CurrentConfigurationDataRecordArray[$y], ENT_QUOTES);
                                 // Zeilenumbruch (Windows: \r\n, MAC: \r, Unix/linux: \n) in den HTML-Code umsetzen
                                 $CurrentConfigurationDataRecordArray[$y] = preg_replace('/\r\n|\r|\n/', '<br>', $CurrentConfigurationDataRecordArray[$y]);
                                 // gerader Strich (|) ist reserveiert als Feldtrenner
                                 $CurrentConfigurationDataRecordArray[$y] = preg_replace('/\|/', '&#124;', $CurrentConfigurationDataRecordArray[$y]);
                              }
                              else
                              {
                                 print 'NOTE: SYSTEM-FILE ' . $HostIntrusionDetectionCurrentConfigurationDatabaseFilepath . ' - function <strong>host_intrusion_detection_updating_database</strong> - IS DAMAGED!';
                                 exit;
                              }
                           }
                           $CurrentConfigurationDataRecordLineOne='';
                           $CurrentConfigurationDataRecordArrayCount = count($CurrentConfigurationDataRecordArray);
                           for($y=0; $y<$CurrentConfigurationDataRecordArrayCount; $y++) {
                              if(isset($CurrentConfigurationDataRecordArray[$y])) {
                                 if($y == 0) {
                                    $CurrentConfigurationDataRecordLineOne .= $CurrentConfigurationDataRecordArray[$y];
                                 }
                                 else
                                 {
                                 $CurrentConfigurationDataRecordLineOne .= '|' . $CurrentConfigurationDataRecordArray[$y];
                                 }
                              }
                              else
                              {
                              $CurrentConfigurationDataRecordLineOne .= '|';
                              }
                           }
                           $CurrentConfigurationDataRecordLineOne .= "\n";
                           $CurrentConfigurationDatabaseDataRecords .= $CurrentConfigurationDataRecordLineOne;
                           if($ConfigurationDatabaseFileWrite = @fopen($HostIntrusionDetectionCurrentConfigurationDatabaseFilepath,'w')) {
                              @flock($ConfigurationDatabaseFileWrite,2);
                              @fwrite($ConfigurationDatabaseFileWrite, $CurrentConfigurationDatabaseDataRecords);
                              @flock($ConfigurationDatabaseFileWrite,3);
                              @fclose($ConfigurationDatabaseFileWrite);
                              $ConfigurationReturnCode=1;
                           }
                           else
                           { 
                           $ConfigurationReturnCode=4;
                           }
                        }
                        else
                        {
                        $ConfigurationReturnCode=3;
                        }
                     }
                     else
                     {
                     $ConfigurationReturnCode=3;
                     }
                  }
                  else
                  {
                  $ConfigurationReturnCode=2;
                  }
                  // Ermittlung der Verzeichnisse und Dateien des zu ueberwachenden Hauptverzeichnisses - ohne die auszuschlieszenden Verzeichnisse und Dateien
                  $IdsCurrentDirectoryMainArray=array();
                  $IdsCurrentFileMainArray=array();
                  $IdsCurrentDirectoryMainArray[]=$HostIntrusionDetectionArray[3];
                  $IdsCurrentDirectoryMainArrayCount = count($IdsCurrentDirectoryMainArray);
                  $IdsDirectoryMaxDepthCount = substr_count($IdsCurrentDirectoryMainArray[0], '/') + $HostIntrusionDetectionArray[4] - 1;
                  for($x=0; $x<$IdsCurrentDirectoryMainArrayCount; $x++) {
                     $IdsFileHandle = @opendir($IdsCurrentDirectoryMainArray[$x]);
                     while($IdsFileName = @readdir($IdsFileHandle)) {
                        if($IdsFileName != "." && $IdsFileName != "..") {
                           $IdsDirectoryNameLength = strlen($IdsCurrentDirectoryMainArray[$x]) - 1;
                           $IdsDirectoryNameLastSlashPosition = strrpos($IdsCurrentDirectoryMainArray[$x], '/');
                           if($IdsDirectoryNameLength == $IdsDirectoryNameLastSlashPosition) {
                              $IdsCurrentDirectoryMainArray[$x] = substr($IdsCurrentDirectoryMainArray[$x], 0, -1);
                           }
                           $IdsNextFile = $IdsCurrentDirectoryMainArray[$x] . "/" . $IdsFileName;
                           $IdsCurrentDirectoryCount = substr_count($IdsNextFile, '/');
                           if(file_exists($IdsNextFile) &&
                              is_dir($IdsNextFile) &&
                              $IdsCurrentDirectoryCount <= $IdsDirectoryMaxDepthCount) {
                              if(!empty($DirectoryExclusionLineArray) && is_array($DirectoryExclusionLineArray)) {
                                 $DirectoryExclusion=0;
                                 $DirectoryExclusionLineArrayCount = count($DirectoryExclusionLineArray);
                                 for($y=0; $y<$DirectoryExclusionLineArrayCount; $y++) {
                                    $DirectoryStringComparison = strcmp($IdsNextFile, $DirectoryExclusionLineArray[$y]);
                                    if($DirectoryExclusionLineArray[$y] != "" && $DirectoryStringComparison == 0) {
                                       $DirectoryExclusion=1;
                                       break;
                                    }
                                 }
                                 if(empty($DirectoryExclusion)) {
                                    $IdsCurrentDirectoryMainArray[] = $IdsNextFile;
                                    $IdsCurrentDirectoryMainArrayCount = count($IdsCurrentDirectoryMainArray);
                                 }
                                 else
                                 {
                                 unset($DirectoryExclusion);
                                 }
                              }
                              else
                              {
                                 $IdsCurrentDirectoryMainArray[] = $IdsNextFile;
                                 $IdsCurrentDirectoryMainArrayCount = count($IdsCurrentDirectoryMainArray);
                              }
                           } elseif(file_exists($IdsNextFile) && !is_dir($IdsNextFile)) {
                              if(!empty($FileExclusionLineArray) && is_array($FileExclusionLineArray)) {
                                 $FileExclusion=0;
                                 $FileExclusionLineArrayCount = count($FileExclusionLineArray);
                                 for($y=0; $y<$FileExclusionLineArrayCount; $y++) {
                                    $FileStringComparison = strcmp($IdsNextFile, $FileExclusionLineArray[$y]);
                                    if($FileExclusionLineArray[$y] != "" && $FileStringComparison == 0) {
                                       $FileExclusion=1;
                                       break;
                                    }
                                 }
                                 if(empty($FileExclusion)) {
                                    $IdsCurrentFileMainArray[] = $IdsNextFile;
                                 }
                                 else
                                 {
                                 unset($FileExclusion);
                                 }
                              }
                              else
                              {
                              $IdsCurrentFileMainArray[] = $IdsNextFile;
                              }
                           }
                        }
                     }
                     @closedir($IdsFileHandle);
                  }
                  $IdsCurrentDirectoryMainArrayCount = count($IdsCurrentDirectoryMainArray);
                  $IdsCurrentFileMainArrayCount = count($IdsCurrentFileMainArray);
                  // die Anzahl der Verzeichnisse und Dateien in die Report-Datenbank eintragen
                  if(!empty($HostIntrusionDetectionCurrentReportDatabaseFilepath) &&
                     file_exists($HostIntrusionDetectionCurrentReportDatabaseFilepath) &&
                     is_writeable($HostIntrusionDetectionCurrentReportDatabaseFilepath)) {
                     $CurrentReportDatabaseArray = file($HostIntrusionDetectionCurrentReportDatabaseFilepath);
                     $CurrentReportDatabaseArrayCount = count($CurrentReportDatabaseArray);
                     if($CurrentReportDatabaseArrayCount >= 3) {
                        $CurrentReportDatabaseDataRecords = trim($CurrentReportDatabaseArray[0]) . "\n";
                        $CurrentReportDatabaseDataRecords .= trim($CurrentReportDatabaseArray[1]) . "\n";
                        $CurrentReportDatabaseStringLenArray = explode("|", $CurrentReportDatabaseArray[1]);
                        $CurrentReportDatabaseLineNumberOneArray = explode("|", $CurrentReportDatabaseArray[2]);
                        $CurrentReportDatabaseStringLenArrayCount = count($CurrentReportDatabaseStringLenArray);
                        if(preg_match("/^[0-9]{1,2}$/", $CurrentReportDatabaseStringLenArrayCount) && $CurrentReportDatabaseStringLenArrayCount == $ReportDatabaseMaximalFieldCount) {
                           unset($CurrentReportDatabaseArray);
                           $CurrentReportDataRecordArray=array();
                           $CurrentReportDataRecordArray[]=1;
                           $CurrentReportDataRecordArray[]=$CurrentIdsDatabaseNumber;
                           $CurrentReportDataRecordArray[]=1;
                           if(isset($CurrentReportDatabaseLineNumberOneArray[3]) &&  preg_match("/^[0-9]{1,}$/", $CurrentReportDatabaseLineNumberOneArray[3])) {
                              $CurrentReportDataRecordArray[]=$CurrentReportDatabaseLineNumberOneArray[3];
                           }
                           else
                           {
                           $CurrentReportDataRecordArray[]=0;
                           }
                           $CurrentReportDataRecordArray[]=time();
                           $CurrentReportDataRecordArray[]=$HostIntrusionDetectionArray[3];
                           if(isset($CurrentReportDatabaseLineNumberOneArray[6]) && preg_match("/^[0-9]{1,}$/", $CurrentReportDatabaseLineNumberOneArray[6])) {
                              $CurrentReportDataRecordArray[]=$CurrentReportDatabaseLineNumberOneArray[6];
                           }
                           else
                           {
                           $CurrentReportDataRecordArray[]=0;
                           }
                           if(isset($IdsCurrentDirectoryMainArrayCount) && preg_match("/^[0-9]{1,}$/", $IdsCurrentDirectoryMainArrayCount)) {
                              $CurrentReportDataRecordArray[]=$IdsCurrentDirectoryMainArrayCount;
                           }
                           else
                           {
                           $CurrentReportDataRecordArray[]=0;
                           }
                           if($CurrentReportDataRecordArray[6] == $CurrentReportDataRecordArray[7]) {
                              $CurrentReportDataRecordArray[]=1;
                           }
                           else
                           {
                              $CurrentReportDataRecordArray[]=0;
                              /* Aenderungs-Status - Verzeichnisse
                                 0 .. geaendert
                                 1 .. unveraendert
                              */
                           }
                           if(isset($CurrentReportDatabaseLineNumberOneArray[8]) && preg_match("/^[0-9]{1,}$/", $CurrentReportDatabaseLineNumberOneArray[9])) {
                              $CurrentReportDataRecordArray[]=$CurrentReportDatabaseLineNumberOneArray[9];
                           }
                           else
                           {
                           $CurrentReportDataRecordArray[]=0;
                           }
                           if(isset($IdsCurrentFileMainArrayCount) && preg_match("/^[0-9]{1,}$/", $IdsCurrentFileMainArrayCount)) {
                              $CurrentReportDataRecordArray[]=$IdsCurrentFileMainArrayCount;
                           }
                           else
                           {
                           $CurrentReportDataRecordArray[]=0;
                           }
                           if($CurrentReportDataRecordArray[9] == $CurrentReportDataRecordArray[10]) {
                              $CurrentReportDataRecordArray[]=1;
                           }
                           else
                           {
                              $CurrentReportDataRecordArray[]=0;
                              /* Aenderungs-Status - Dateien
                                 0 .. geaendert
                                 1 .. unveraendert
                              */
                           }
                           if($CurrentReportDataRecordArray[8] == 0 || $CurrentReportDataRecordArray[11] == 0) $CurrentReportDataRecordArray[4]=time();
                           $CurrentReportDataRecordArrayCount = count($CurrentReportDataRecordArray);
                           for($y=0; $y<$CurrentReportDataRecordArrayCount; $y++) {
                              // maximale Stringlaenge pruefen
                              $CurrentFieldStringLen = strlen($CurrentReportDataRecordArray[$y]);
                              $ReportDatabaseFieldStringLen = trim($CurrentReportDatabaseStringLenArray[$y]);
                              if(preg_match("/^[0-9]{1,5}$/", $ReportDatabaseFieldStringLen)) {
                                 if($CurrentFieldStringLen > $ReportDatabaseFieldStringLen) {
                                    // Laenge des Array-Elementes auf die maximale zulaessige Laenge kuerzen
                                    $CurrentReportDataRecordArray[$y] = substr($CurrentReportDataRecordArray[$y], 0, $ReportDatabaseFieldStringLen);
                                 }
                                 $CurrentReportDataRecordArray[$y] = htmlspecialchars($CurrentReportDataRecordArray[$y], ENT_QUOTES);
                                 // Zeilenumbruch (Windows: \r\n, MAC: \r, Unix/linux: \n) in den HTML-Code umsetzen
                                 $CurrentReportDataRecordArray[$y] = preg_replace('/\r\n|\r|\n/', '<br>', $CurrentReportDataRecordArray[$y]);
                                 // gerader Strich (|) ist reserveiert als Feldtrenner
                                 $CurrentReportDataRecordArray[$y] = preg_replace('/\|/', '&#124;', $CurrentReportDataRecordArray[$y]);
                              }
                              else
                              {
                                 print 'NOTE: SYSTEM-FILE ' . $HostIntrusionDetectionCurrentReportDatabaseFilepath . ' - function <strong>host_intrusion_detection_updating_database</strong> - IS DAMAGED!';
                                 exit;
                              }
                           }
                           $CurrentReportDataRecordLineOne='';
                           $CurrentReportDataRecordArrayCount = count($CurrentReportDataRecordArray);
                           for($y=0; $y<$CurrentReportDataRecordArrayCount; $y++) {
                              if(isset($CurrentReportDataRecordArray[$y])) {
                                 if($y == 0) {
                                    $CurrentReportDataRecordLineOne .= $CurrentReportDataRecordArray[$y];
                                 }
                                 else
                                 {
                                 $CurrentReportDataRecordLineOne .= '|' . $CurrentReportDataRecordArray[$y];
                                 }
                              }
                              else
                              {
                              $CurrentReportDataRecordLineOne .= '|';
                              }
                           }
                           $CurrentReportDataRecordLineOne .= "\n";
                           $CurrentReportDatabaseDataRecords .= $CurrentReportDataRecordLineOne;
                           if($ReportDatabaseFileWrite = @fopen($HostIntrusionDetectionCurrentReportDatabaseFilepath,'w')) {
                              @flock($ReportDatabaseFileWrite,2);
                              @fwrite($ReportDatabaseFileWrite, $CurrentReportDatabaseDataRecords);
                              @flock($ReportDatabaseFileWrite,3);
                              @fclose($ReportDatabaseFileWrite);
                              $ReportReturnCode=1;
                           }
                           else
                           { 
                           $ReportReturnCode=4;
                           }
                           unset($CurrentReportDataRecordArray);
                        }
                        else
                        {
                        $ReportReturnCode=3;
                        }
                     }
                     else
                     {
                     $ReportReturnCode=3;
                     }
                  }
                  else
                  {
                  $ReportReturnCode=2;
                  }
                  // IDS-Hauptdatenbank aktualiseren
                  $CurrentIdsDatabaseMainArray = file($HostIntrusionDetectionCurrentDatabaseFilepath);
                  $CurrentIdsDatabaseMainArrayCount = count($CurrentIdsDatabaseMainArray);
                  if($CurrentIdsDatabaseMainArrayCount >= 2) {
                     $IdsDatabaseUpdateArray=array();
                     $IdsDatabaseUpdateArray[] = trim($CurrentIdsDatabaseMainArray[0]);
                     $IdsDatabaseUpdateArray[] = trim($CurrentIdsDatabaseMainArray[1]);
                     $IdsDatabaseStringLenArray = explode("|", $CurrentIdsDatabaseMainArray[1]);
                     $IdsDatabaseDataRecordNumberArrayCount = count($IdsDatabaseStringLenArray);
                     // Ermittlung der Verzeichnis- und Dateipfade aus der IDS-Datenbank und Ermittlung der neu hinzugefuegten Verzeichnis- und Dateipfade
                     if($IdsDatabaseDataRecordNumberArrayCount == $IdsDatabaseMaximalFieldCount) {
                        $CurrentIdsDatabaseDirectoryArray=array();
                        $CurrentIdsDatabaseFileArray=array();
                        $AddedDirectoryArray=array();
                        $AddedFileArray=array();
                        if(isset($CurrentIdsDatabaseMainArray) &&
                           is_array($CurrentIdsDatabaseMainArray) &&
                           isset($IdsCurrentDirectoryMainArray) &&
                           is_array($IdsCurrentDirectoryMainArray) &&
                           isset($IdsCurrentFileMainArray) &&
                           is_array($IdsCurrentFileMainArray)) {
                           $CurrentIdsDatabaseMainArrayCount = count($CurrentIdsDatabaseMainArray);
                           // die ersten 2 Datensaetze enthalten keine relevanten Namen von Verzeichnissen und Dateien
                           for($y=2; $y<$CurrentIdsDatabaseMainArrayCount; $y++) {
                              $CurrentIdsDataRecordArray = explode("|", $CurrentIdsDatabaseMainArray[$y]);
                              $CurrentAddedDirectoryPath = trim($CurrentIdsDataRecordArray[5]);
                              $CurrentAddedFilePath = trim($CurrentIdsDataRecordArray[21]);
                              if($CurrentAddedDirectoryPath != "" &&
                                 file_exists($CurrentAddedDirectoryPath) &&
                                 is_dir($CurrentAddedDirectoryPath)) {
                                 // vorhandene Verzeichnisse in die neue IDS-Datenbank aufnehmen
                                 $CurrentIdsDatabaseDirectoryArray[] = $CurrentAddedDirectoryPath;
                              } elseif($CurrentAddedDirectoryPath != "" && !file_exists($CurrentAddedDirectoryPath)) {
                                 // geloeschte Verzeichnisse in die neue IDS-Datenbank aufnehmen
                                 $CurrentIdsDatabaseDirectoryArray[] = $CurrentAddedDirectoryPath;
                              } elseif($CurrentAddedFilePath != "" &&
                                 file_exists($CurrentAddedFilePath) &&
                                 !is_dir($CurrentAddedFilePath)) {
                                 // vorhandene Dateien in die neue IDS-Datenbank aufnehmen
                                 $CurrentIdsDatabaseFileArray[] = $CurrentAddedFilePath;
                              } elseif($CurrentAddedFilePath != "" &&  !file_exists($CurrentAddedFilePath)) {
                                 // geloeschte Dateien in die neue IDS-Datenbank aufnehmen
                                 $CurrentIdsDatabaseFileArray[] = $CurrentAddedFilePath;
                              }
                           }
                           $IdsCurrentDirectoryMainArrayCount = count($IdsCurrentDirectoryMainArray);
                           for($y=0; $y<$IdsCurrentDirectoryMainArrayCount; $y++) {
                              if($IdsCurrentDirectoryMainArray[$y] != "" && is_dir($IdsCurrentDirectoryMainArray[$y])) {
                                 if(isset($DirectoryExclusionLineArray) && is_array($DirectoryExclusionLineArray)) {
                                    if(!in_array($IdsCurrentDirectoryMainArray[$y], $CurrentIdsDatabaseDirectoryArray) && !in_array($IdsCurrentDirectoryMainArray[$y], $DirectoryExclusionLineArray)) {
                                       $AddedDirectoryArray[] = $IdsCurrentDirectoryMainArray[$y];
                                    }
                                 } elseif(!in_array($IdsCurrentDirectoryMainArray[$y], $CurrentIdsDatabaseDirectoryArray)) {
                                    $AddedDirectoryArray[] = $IdsCurrentDirectoryMainArray[$y];
                                 }
                              }
                           }
                           $IdsCurrentFileMainArrayCount = count($IdsCurrentFileMainArray);
                           for($y=0; $y<$IdsCurrentFileMainArrayCount; $y++) {
                              if($IdsCurrentFileMainArray[$y] != "" &&
                                 !is_dir($IdsCurrentFileMainArray[$y]) &&
                                 !in_array($IdsCurrentFileMainArray[$y], $CurrentIdsDatabaseFileArray)) {
                                 if(isset($FileExclusionLineArray) && is_array($FileExclusionLineArray)) {
                                    if(!in_array($IdsCurrentFileMainArray[$y], $FileExclusionLineArray)) {
                                       $AddedFileArray[] = $IdsCurrentFileMainArray[$y];
                                    }
                                 }
                                 else
                                 {
                                 $AddedFileArray[] = $IdsCurrentFileMainArray[$y];
                                 }
                              }
                           }
                        }
                        unset($IdsCurrentDirectoryMainArray);
                        unset($CurrentIdsDatabaseFileArray);
                        unset($IdsCurrentFileMainArray);
                        $NewIdsTotalDirectoryArray = array_merge($CurrentIdsDatabaseDirectoryArray, $AddedDirectoryArray);
                        unset($CurrentIdsDatabaseDirectoryArray);
                        sort($NewIdsTotalDirectoryArray);
                        sort($AddedDirectoryArray);
                        sort($AddedFileArray);
                        if(isset($IdsDatabaseUpdateArray) &&
                           is_array($IdsDatabaseUpdateArray) &&
                           isset($CurrentIdsDatabaseMainArray) &&
                           is_array($CurrentIdsDatabaseMainArray) &&
                           isset($NewIdsTotalDirectoryArray) &&
                           is_array($NewIdsTotalDirectoryArray) &&
                           isset($AddedDirectoryArray) &&
                           is_array($AddedDirectoryArray) &&
                           isset($AddedFileArray) &&
                           is_array($AddedFileArray) &&
                           isset($CurrentIdsDatabaseNumber)) {
                           $CurrentIdsDatabaseMainArrayCount = count($CurrentIdsDatabaseMainArray);
                           $NewIdsTotalDirectoryArrayCount = count($NewIdsTotalDirectoryArray);
                           $AddedDirectoryArrayCount = count($AddedDirectoryArray);
                           $AddedFileArrayCount = count($AddedFileArray);
                           for($x=0; $x<$NewIdsTotalDirectoryArrayCount; $x++) {
                              if(isset($NewIdsTotalDirectoryArray[$x]) && !in_array($NewIdsTotalDirectoryArray[$x], $AddedDirectoryArray)) {
                                 // die ersten 2 Zeilen der IDS-Datenbank enthalten keine relevanten Datensaetze
                                 for($y=2; $y<$CurrentIdsDatabaseMainArrayCount; $y++) {
                                    $CurrentIdsDatabaseDirectoryLineArray = explode("|", $CurrentIdsDatabaseMainArray[$y]);
                                    $CurrentIdsDatabaseDirectoryPath = trim($CurrentIdsDatabaseDirectoryLineArray[5]);
                                    $DirectoryCurrentStringComparison = strcmp($NewIdsTotalDirectoryArray[$x], $CurrentIdsDatabaseDirectoryPath);
                                    if($CurrentIdsDatabaseDirectoryPath != "" && $DirectoryCurrentStringComparison == 0) {
                                       // Verzeichnis-Datensatz aktualsieren
                                       $CurrentIdsDatabaseDirectoryLineArrayCount = count($CurrentIdsDatabaseDirectoryLineArray);
                                       for($z=0; $z<$CurrentIdsDatabaseDirectoryLineArrayCount; $z++) {
                                         $CurrentIdsDatabaseDirectoryLineArray[$z] = trim($CurrentIdsDatabaseDirectoryLineArray[$z]);
                                       }
                                       if(isset($CurrentIdsDatabaseDirectoryLineArray[5]) && $CurrentIdsDatabaseDirectoryLineArray[5] != "") {
                                          $CurrentDirectoryDataRecordArray=array();
                                          // die laufenden Datensatz-Nummern werden erst am Schluss der Routine eingefuegt - Sortierung der Datensaetze
                                          $CurrentDirectoryDataRecordArray[]='';
                                          $CurrentDirectoryDataRecordArray[]=$CurrentIdsDatabaseNumber;
                                          $CurrentDirectoryDataRecordArray[]=1;
                                          $CurrentDirectoryDataRecordArray[]=$CurrentIdsDatabaseDirectoryLineArray[3];
                                          $CurrentDirectoryDataRecordArray[]=$CurrentIdsDatabaseDirectoryLineArray[4];
                                          $CurrentDirectoryDataRecordArray[]=$CurrentIdsDatabaseDirectoryLineArray[5];
                                          $StatDirectoryArray = @stat($CurrentDirectoryDataRecordArray[5]) or $DirectoryOwnerGroupReturnCode=1;
                                          $DirectoryOwnerName='';
                                          $DirectoryGroupName='';
                                          $DirectoryOwnerGroupReturnCode='';
                                          if(!empty($DirectoryOwnerGroupReturnCode) && $DirectoryOwnerGroupReturnCode == 1) {
                                             print 'NOTE 1: DIRECTORY ' . $CurrentDirectoryDataRecordArray[5] . ' - function <strong>host_intrusion_detection_updating_database</strong> - DIRECTORY-OWNER AND DIRECTORY-GROUP CAN NOT DETECT!';
                                             exit;
                                          }
                                          else
                                          {
                                             $DirectoryOwnerId = $StatDirectoryArray[4];
                                             $DirectoryGroupId = $StatDirectoryArray[5];
                                             if($PosixGetPwuidArray = @posix_getpwuid($DirectoryOwnerId)) {
                                                $PosixGetPwuidArrayCount = count($PosixGetPwuidArray);
                                                for($k=0; $k<$PosixGetPwuidArrayCount; $k++) {
                                                   $Key1 = key($PosixGetPwuidArray);
                                                   if(strcasecmp($Key1, "name") == 0) {
                                                      $DirectoryOwnerName = $PosixGetPwuidArray[$Key1];
                                                      break;
                                                   }
                                                   next($PosixGetPwuidArray);
                                                }
                                             }
                                             if($PosixGetGrgidArray = @posix_getgrgid($DirectoryGroupId)) {
                                                $PosixGetGrgidArrayCount = count($PosixGetGrgidArray);
                                                for($k=0; $k<$PosixGetGrgidArrayCount; $k++) {
                                                   $Key2 = key($PosixGetGrgidArray);
                                                   if(strcasecmp($Key2, "name") == 0) {
                                                      $DirectoryGroupName = $PosixGetGrgidArray[$Key2];
                                                      break;
                                                   }
                                                   next($PosixGetGrgidArray);
                                                }
                                             }
                                          }
                                          clearstatcache();
                                          $CurrentDirectoryDataRecordArray[]=$CurrentIdsDatabaseDirectoryLineArray[6];
                                          $CurrentDirectoryDataRecordArray[]=$DirectoryOwnerName;
                                          $CurrentDirectoryDataRecordArray[]=$CurrentIdsDatabaseDirectoryLineArray[8];
                                          $CurrentDirectoryDataRecordArray[]=$DirectoryGroupName;
                                          $CurrentDirectoryDataRecordArray[]=$CurrentIdsDatabaseDirectoryLineArray[10];
                                          if(file_exists($CurrentDirectoryDataRecordArray[5]) && is_dir($CurrentDirectoryDataRecordArray[5])) {
                                             $DirectoryCurrentAccessPermission1 = fileperms($CurrentDirectoryDataRecordArray[5]);
                                             $DirectoryCurrentAccessPermission2 = decoct($DirectoryCurrentAccessPermission1);
                                             $DirectoryCurrentAccessPermission3 = substr($DirectoryCurrentAccessPermission2, -4);
                                             $CurrentDirectoryDataRecordArray[]=$DirectoryCurrentAccessPermission3;
                                             $CurrentDirectoryDataRecordArray[]=$CurrentIdsDatabaseDirectoryLineArray[12];
                                             $CurrentDirectoryDataRecordArray[] = filectime($CurrentDirectoryDataRecordArray[5]);
                                          } elseif(!file_exists($CurrentDirectoryDataRecordArray[5])) {
                                             $CurrentDirectoryDataRecordArray[]='';
                                             $CurrentDirectoryDataRecordArray[]=$CurrentIdsDatabaseDirectoryLineArray[12];
                                             $CurrentDirectoryDataRecordArray[]='';
                                          }
                                          else
                                          {
                                             $CurrentDirectoryDataRecordArray[]=$CurrentIdsDatabaseDirectoryLineArray[11];
                                             $CurrentDirectoryDataRecordArray[]=$CurrentIdsDatabaseDirectoryLineArray[12];
                                             $CurrentDirectoryDataRecordArray[]=$CurrentIdsDatabaseDirectoryLineArray[13];
                                          }
                                          $IdsCurrentDirectoryArray=array();
                                          $IdsCurrentFileArray=array();
                                          $IdsCurrentDirectoryName=$CurrentDirectoryDataRecordArray[5];
                                          $IdsCurrentDirectoryMaxDepthCount = substr_count($IdsCurrentDirectoryName, '/') + $HostIntrusionDetectionArray[4] - 1;
                                          $IdsCurrentFileHandle = @opendir($IdsCurrentDirectoryName);
                                          while($IdsCurrentFileName = @readdir($IdsCurrentFileHandle)) {
                                             if($IdsCurrentFileName != "." && $IdsCurrentFileName != "..") {
                                                $IdsCurrentDirectoryNameLength = strlen($IdsCurrentDirectoryName) - 1;
                                                $IdsDirectoryNameLastSlashPosition = strrpos($IdsCurrentDirectoryName, '/');
                                                if($IdsCurrentDirectoryNameLength == $IdsDirectoryNameLastSlashPosition) {
                                                   $IdsCurrentDirectoryName = substr($IdsCurrentDirectoryName, 0, -1);
                                                }
                                                $IdsCurrentNextFile = $IdsCurrentDirectoryName . "/" . $IdsCurrentFileName;
                                                $IdsCurrentDirectoryCount = substr_count($IdsCurrentNextFile, '/');
                                                if(file_exists($IdsCurrentNextFile) &&
                                                   is_dir($IdsCurrentNextFile) &&
                                                   $IdsCurrentDirectoryCount <= $IdsCurrentDirectoryMaxDepthCount) {
                                                   if(!empty($DirectoryExclusionLineArray) && is_array($DirectoryExclusionLineArray)) {
                                                      $CurrentDirectoryExclusion=0;
                                                      $DirectoryExclusionLineArrayCount = count($DirectoryExclusionLineArray);
                                                      for($z=0; $z<$DirectoryExclusionLineArrayCount; $z++) {
                                                         $DirectoryStringComparison = strcmp($IdsCurrentNextFile, $DirectoryExclusionLineArray[$z]);
                                                         if($DirectoryExclusionLineArray[$z] != "" && $DirectoryStringComparison == 0) {
                                                            $CurrentDirectoryExclusion=1;
                                                            break;
                                                         }
                                                      }
                                                      if(empty($CurrentDirectoryExclusion)) {
                                                         $IdsCurrentDirectoryArray[] = $IdsCurrentNextFile;
                                                      }
                                                      else
                                                      {
                                                      unset($CurrentDirectoryExclusion);
                                                      }
                                                   }
                                                   else
                                                   {
                                                   $IdsCurrentDirectoryArray[] = $IdsCurrentNextFile;
                                                   }
                                                } elseif(file_exists($IdsCurrentNextFile) && !is_dir($IdsCurrentNextFile)) {
                                                   if(!empty($FileExclusionLineArray) && is_array($FileExclusionLineArray)) {
                                                      $CurrentFileExclusion=0;
                                                      $FileExclusionLineArrayCount = count($FileExclusionLineArray);
                                                      for($z=0; $z<$FileExclusionLineArrayCount; $z++) {
                                                         $FileStringComparison = strcmp($IdsCurrentNextFile, $FileExclusionLineArray[$z]);
                                                         if($FileExclusionLineArray[$z] != "" && $FileStringComparison == 0) {
                                                            $CurrentFileExclusion=1;
                                                            break;
                                                         }
                                                      }
                                                      if(empty($CurrentFileExclusion)) {
                                                         $IdsCurrentFileArray[] = $IdsCurrentNextFile;
                                                      }
                                                      else
                                                      {
                                                      unset($CurrentFileExclusion);
                                                      }
                                                   }
                                                   else
                                                   {
                                                   $IdsCurrentFileArray[] = $IdsCurrentNextFile;
                                                   }
                                                }
                                             }
                                          }
                                          @closedir($IdsCurrentFileHandle);
                                          $IdsCurrentDirectoryNumber = count($IdsCurrentDirectoryArray);
                                          $IdsCurrentFileNumber = count($IdsCurrentFileArray);
                                          unset($IdsCurrentDirectoryArray);
                                          unset($IdsCurrentFileArray);
                                          $CurrentDirectoryDataRecordArray[]=$CurrentIdsDatabaseDirectoryLineArray[14];
                                          $CurrentDirectoryDataRecordArray[]=$IdsCurrentDirectoryNumber;
                                          $CurrentDirectoryDataRecordArray[]=$CurrentIdsDatabaseDirectoryLineArray[16];
                                          $CurrentDirectoryDataRecordArray[]=$IdsCurrentFileNumber;
                                          $CurrentDirectoryDataRecordArray[]=$CurrentIdsDatabaseDirectoryLineArray[18];
                                          $Md5DirectoryContent = $CurrentDirectoryDataRecordArray[7] . $CurrentDirectoryDataRecordArray[9] . $CurrentDirectoryDataRecordArray[11] . $CurrentDirectoryDataRecordArray[13] . $CurrentDirectoryDataRecordArray[15] . $CurrentDirectoryDataRecordArray[17];
                                          $Md5DirectoryValue = md5($Md5DirectoryContent);
                                          $CurrentDirectoryDataRecordArray[]=$Md5DirectoryValue;
                                          $Md5DirectoryValueComparison = strcmp($CurrentDirectoryDataRecordArray[18], $CurrentDirectoryDataRecordArray[19]);
                                          /* MD5-Status - Verzeichnis und Datei
                                             0 .. geloescht
                                             1 .. unveraendert
                                             2 .. geaendert
                                             3 .. hinzugefuegt
                                             4 .. ausgeschlossen
                                          */
                                          if($Md5DirectoryValueComparison != 0) {
                                             if(!file_exists($CurrentDirectoryDataRecordArray[5])) {
                                                $CurrentDirectoryDataRecordArray[]=0;
                                             } elseif(file_exists($CurrentDirectoryDataRecordArray[5]) &&
                                                is_dir($CurrentDirectoryDataRecordArray[5]) &&
                                                isset($DirectoryExclusionLineArray) &&
                                                is_array($DirectoryExclusionLineArray) &&
                                                in_array($CurrentDirectoryDataRecordArray[5], $DirectoryExclusionLineArray)) {
                                                $CurrentDirectoryDataRecordArray[]=4;
                                             } elseif(file_exists($CurrentDirectoryDataRecordArray[5]) && is_dir($CurrentDirectoryDataRecordArray[5])) {
                                                $CurrentDirectoryDataRecordArray[]=2;
                                             }
                                             $CurrentDirectoryDataRecordArray[4]=time();
                                          } elseif(file_exists($CurrentDirectoryDataRecordArray[5]) &&
                                             is_dir($CurrentDirectoryDataRecordArray[5]) &&
                                             isset($DirectoryExclusionLineArray) &&
                                             is_array($DirectoryExclusionLineArray) &&
                                             in_array($CurrentDirectoryDataRecordArray[5], $DirectoryExclusionLineArray)) {
                                             $CurrentDirectoryDataRecordArray[]=4;
                                          }
                                          else
                                          {
                                          $CurrentDirectoryDataRecordArray[]=1;
                                          }
                                          $CurrentDirectoryDataRecordArrayCount = count($CurrentDirectoryDataRecordArray);
                                          $DataRecordEmptyCount = $IdsDatabaseMaximalFieldCount - $CurrentDirectoryDataRecordArrayCount;
                                          for($z=0; $z<$DataRecordEmptyCount; $z++) {
                                             $CurrentDirectoryDataRecordArray[]='';
                                          }
                                          if(isset($CurrentDirectoryDataRecordArray[20])) $CurrentDirectoryMd5Status = trim($CurrentDirectoryDataRecordArray[20]);
                                          $CurrentDirectoryDataRecordArrayCount = count($CurrentDirectoryDataRecordArray);
                                          for($z=0; $z<$CurrentDirectoryDataRecordArrayCount; $z++) {
                                             // maximale Stringlaenge pruefen
                                             $CurrentFieldStringLen = strlen($CurrentDirectoryDataRecordArray[$z]);
                                             $IdsDatabaseFieldStringLen = trim($IdsDatabaseStringLenArray[$z]);
                                             if(preg_match("/^[0-9]{1,5}$/", $IdsDatabaseFieldStringLen)) {
                                                if($CurrentFieldStringLen > $IdsDatabaseFieldStringLen) {
                                                   // Laenge des Array-Elementes auf die maximale zulaessige Laenge kuerzen
                                                   $CurrentDirectoryDataRecordArray[$z] = substr($CurrentDirectoryDataRecordArray[$z], 0, $IdsDatabaseFieldStringLen);
                                                }
                                                $CurrentDirectoryDataRecordArray[$z] = htmlspecialchars($CurrentDirectoryDataRecordArray[$z], ENT_QUOTES);
                                                // Zeilenumbruch (Windows: \r\n, MAC: \r, Unix/linux: \n) in den HTML-Code umsetzen
                                                $CurrentDirectoryDataRecordArray[$z] = preg_replace('/\r\n|\r|\n/', '<br>', $CurrentDirectoryDataRecordArray[$z]);
                                                // gerader Strich (|) ist reserveiert als Feldtrenner
                                                $CurrentDirectoryDataRecordArray[$z] = preg_replace('/\|/', '&#124;', $CurrentDirectoryDataRecordArray[$z]);
                                             }
                                             else
                                             {
                                                print 'NOTE 2: SYSTEM-FILE ' . $HostIntrusionDetectionCurrentDatabaseFilepath . ' - function <strong>host_intrusion_detection_updating_database</strong> - IS DAMAGED!';
                                                exit;
                                             }
                                          }
                                          $CurrentDirectoryDataRecord='';
                                          $CurrentDirectoryDataRecordArrayCount = count($CurrentDirectoryDataRecordArray);
                                          for($z=0; $z<$CurrentDirectoryDataRecordArrayCount; $z++) {
                                             if(isset($CurrentDirectoryDataRecordArray[$z])) {
                                                if($z == 0) {
                                                   $CurrentDirectoryDataRecord .= $CurrentDirectoryDataRecordArray[$z];
                                                }
                                                else
                                                {
                                                $CurrentDirectoryDataRecord .= '|' . $CurrentDirectoryDataRecordArray[$z];
                                                }
                                             }
                                             else
                                             {
                                             $CurrentDirectoryDataRecord .= '|';
                                             }
                                          }
                                          $IdsDatabaseUpdateArray[] = $CurrentDirectoryDataRecord;
                                          unset($CurrentDirectoryDataRecord);
                                          unset($CurrentDirectoryDataRecordArray);
                                       }
                                       $IdsDatabaseUpdateFileArray=array();
                                       $ForLoopStopping=0;
                                       for($z=3; $z<$CurrentIdsDatabaseMainArrayCount; $z++) {
                                          $CurrentIdsDatabaseFileLineArray = explode("|", $CurrentIdsDatabaseMainArray[$z]);
                                          $CurrentIdsDatabaseFilePath = trim($CurrentIdsDatabaseFileLineArray[21]);
                                          if(preg_match("@^" . $CurrentIdsDatabaseDirectoryPath . "/[^/]+$@", $CurrentIdsDatabaseFilePath)) {
                                             // Datei-Datensatz aktualsieren
                                             $UpdateFileIdsDatabaseMainArray=array();
                                             $UpdateFileDataRecord='';
                                             // die laufenden Datensatz-Nummern werden erst am Schluss der Routine eingefuegt - Sortierung der Datensaetze
                                             $UpdateFileIdsDatabaseMainArray[]='';
                                             $UpdateFileIdsDatabaseMainArray[]=$CurrentIdsDatabaseNumber;
                                             $UpdateFileIdsDatabaseMainArray[]=1;
                                             $UpdateFileIdsDatabaseMainArray[]=$CurrentIdsDatabaseFileLineArray[3];
                                             $UpdateFileIdsDatabaseMainArray[]=$CurrentIdsDatabaseFileLineArray[4];
                                             $DataRecordEmptyCount = $IdsDatabaseMaximalFieldCount - 19;
                                             for($k=0; $k<$DataRecordEmptyCount; $k++) {
                                                $UpdateFileIdsDatabaseMainArray[]='';
                                             }
                                             $UpdateFileIdsDatabaseMainArray[]=$CurrentIdsDatabaseFilePath;
                                             $StatFileArray = @stat($UpdateFileIdsDatabaseMainArray[21]) or $FileOwnerGroupReturnCode=1;
                                             $FileOwnerName='';
                                             $FileGroupName='';
                                             $FileOwnerGroupReturnCode='';
                                             if(!empty($FileOwnerGroupReturnCode) && $FileOwnerGroupReturnCode == 1) {
                                                print 'NOTE 1: FILE ' . $UpdateFileIdsDatabaseMainArray[21] . ' - function <strong>host_intrusion_detection_updating_database</strong> - FILE-OWNER AND FILE-GROUP CAN NOT DETECT!';
                                                exit;
                                             }
                                             else
                                             {
                                                $FileOwnerId = $StatFileArray[4];
                                                $FileGroupId = $StatFileArray[5];
                                                if($PosixGetPwuidArray = @posix_getpwuid($FileOwnerId)) {
                                                   $PosixGetPwuidArrayCount = count($PosixGetPwuidArray);
                                                   for($k=0; $k<$PosixGetPwuidArrayCount; $k++) {
                                                      $Key1 = key($PosixGetPwuidArray);
                                                      if(strcasecmp($Key1, "name") == 0) {
                                                         $FileOwnerName = $PosixGetPwuidArray[$Key1];
                                                         break;
                                                      }
                                                      next($PosixGetPwuidArray);
                                                   }
                                                }
                                                if($PosixGetGrgidArray = @posix_getgrgid($FileGroupId)) {
                                                   $PosixGetGrgidArrayCount = count($PosixGetGrgidArray);
                                                   for($k=0; $k<$PosixGetGrgidArrayCount; $k++) {
                                                      $Key2 = key($PosixGetGrgidArray);
                                                      if(strcasecmp($Key2, "name") == 0) {
                                                         $FileGroupName = $PosixGetGrgidArray[$Key2];
                                                         break;
                                                      }
                                                      next($PosixGetGrgidArray);
                                                   }
                                                }
                                             }
                                             clearstatcache();
                                             $UpdateFileIdsDatabaseMainArray[]=$CurrentIdsDatabaseDirectoryLineArray[6];
                                             $UpdateFileIdsDatabaseMainArray[]=$FileOwnerName;
                                             $UpdateFileIdsDatabaseMainArray[]=$CurrentIdsDatabaseDirectoryLineArray[8];
                                             $UpdateFileIdsDatabaseMainArray[]=$FileGroupName;
                                             $UpdateFileIdsDatabaseMainArray[]=$CurrentIdsDatabaseFileLineArray[26];
                                             if(file_exists($UpdateFileIdsDatabaseMainArray[21]) && !is_dir($UpdateFileIdsDatabaseMainArray[21])) {
                                                $FileCurrentAccessPermission1 = fileperms($UpdateFileIdsDatabaseMainArray[21]);
                                                $FileCurrentAccessPermission2 = decoct($FileCurrentAccessPermission1);
                                                $FileCurrentAccessPermission3 = substr($FileCurrentAccessPermission2, -4);
                                                $UpdateFileIdsDatabaseMainArray[]=$FileCurrentAccessPermission3;
                                                $UpdateFileIdsDatabaseMainArray[]=$CurrentIdsDatabaseFileLineArray[28];
                                                $UpdateFileIdsDatabaseMainArray[] = filemtime($UpdateFileIdsDatabaseMainArray[21]);
                                                $UpdateFileIdsDatabaseMainArray[]=$CurrentIdsDatabaseFileLineArray[30];
                                                $UpdateFileIdsDatabaseMainArray[] = filesize($UpdateFileIdsDatabaseMainArray[21]);
                                             } elseif(!file_exists($UpdateFileIdsDatabaseMainArray[21])) {
                                                $UpdateFileIdsDatabaseMainArray[]='';
                                                $UpdateFileIdsDatabaseMainArray[]=$CurrentIdsDatabaseFileLineArray[28];
                                                $UpdateFileIdsDatabaseMainArray[]='';
                                                $UpdateFileIdsDatabaseMainArray[]=$CurrentIdsDatabaseFileLineArray[30];
                                                $UpdateFileIdsDatabaseMainArray[]='';
                                             }
                                             else
                                             {
                                                $UpdateFileIdsDatabaseMainArray[]=$CurrentIdsDatabaseFileLineArray[27];
                                                $UpdateFileIdsDatabaseMainArray[]=$CurrentIdsDatabaseFileLineArray[28];
                                                $UpdateFileIdsDatabaseMainArray[]=$CurrentIdsDatabaseFileLineArray[29];
                                                $UpdateFileIdsDatabaseMainArray[]=$CurrentIdsDatabaseFileLineArray[30];
                                                $UpdateFileIdsDatabaseMainArray[]=$CurrentIdsDatabaseFileLineArray[31];
                                             }
                                             $Md5FileContent = $UpdateFileIdsDatabaseMainArray[23] .  $UpdateFileIdsDatabaseMainArray[25] .  $UpdateFileIdsDatabaseMainArray[27] . $UpdateFileIdsDatabaseMainArray[29] . $UpdateFileIdsDatabaseMainArray[31];
                                             $Md5FileValue = md5($Md5FileContent);
                                             $UpdateFileIdsDatabaseMainArray[]=$CurrentIdsDatabaseFileLineArray[32];
                                             $UpdateFileIdsDatabaseMainArray[]=$Md5FileValue;
                                             $Md5FileValueComparison = strcmp($UpdateFileIdsDatabaseMainArray[32], $UpdateFileIdsDatabaseMainArray[33]);
                                             /* MD5-Status - Verzeichnis und Datei
                                                0 .. geloescht
                                                1 .. unveraendert
                                                2 .. geaendert
                                                3 .. hinzugefuegt
                                                4 .. ausgeschlossen
                                             */
                                             if(isset($CurrentDirectoryMd5Status) && preg_match("/^[0-3]$/", $CurrentDirectoryMd5Status)) {
                                                if($Md5FileValueComparison != 0) {
                                                   if(!file_exists($UpdateFileIdsDatabaseMainArray[21])) {
                                                      $UpdateFileIdsDatabaseMainArray[]=0;
                                                   } elseif(file_exists($UpdateFileIdsDatabaseMainArray[21]) &&
                                                      !is_dir($UpdateFileIdsDatabaseMainArray[21]) &&
                                                      isset($FileExclusionLineArray) &&
                                                      is_array($FileExclusionLineArray) &&
                                                      in_array($UpdateFileIdsDatabaseMainArray[21], $FileExclusionLineArray)) {
                                                      $UpdateFileIdsDatabaseMainArray[]=4;
                                                   } elseif(file_exists($UpdateFileIdsDatabaseMainArray[21]) && !is_dir($UpdateFileIdsDatabaseMainArray[21])) {
                                                      $UpdateFileIdsDatabaseMainArray[]=2;
                                                   }
                                                   $UpdateFileIdsDatabaseMainArray[4]=time();
                                                } elseif(file_exists($UpdateFileIdsDatabaseMainArray[21]) &&
                                                   !is_dir($UpdateFileIdsDatabaseMainArray[21]) &&
                                                   isset($FileExclusionLineArray) &&
                                                   is_array($FileExclusionLineArray) &&
                                                   in_array($UpdateFileIdsDatabaseMainArray[21], $FileExclusionLineArray)) {
                                                   $UpdateFileIdsDatabaseMainArray[]=4;
                                                }
                                                else
                                                {
                                                $UpdateFileIdsDatabaseMainArray[]=1;
                                                }
                                             }
                                             else
                                             {
                                             $UpdateFileIdsDatabaseMainArray[]=4;
                                             }
                                             $UpdateFileIdsDatabaseMainArrayCount = count($UpdateFileIdsDatabaseMainArray);
                                             for($k=0; $k<$UpdateFileIdsDatabaseMainArrayCount; $k++) {
                                                // maximale Stringlaenge pruefen
                                                $CurrentFieldStringLen = strlen($UpdateFileIdsDatabaseMainArray[$k]);
                                                $IdsDatabaseFieldStringLen = trim($IdsDatabaseStringLenArray[$k]);
                                                if(preg_match("/^[0-9]{1,5}$/", $IdsDatabaseFieldStringLen)) {
                                                   if($CurrentFieldStringLen > $IdsDatabaseFieldStringLen) {
                                                      // Laenge des Array-Elementes auf die maximale zulaessige Laenge kuerzen
                                                      $UpdateFileIdsDatabaseMainArray[$k] = substr($UpdateFileIdsDatabaseMainArray[$k], 0, $IdsDatabaseFieldStringLen);
                                                   }
                                                   $UpdateFileIdsDatabaseMainArray[$k] = htmlspecialchars($UpdateFileIdsDatabaseMainArray[$k], ENT_QUOTES);
                                                   // Zeilenumbruch (Windows: \r\n, MAC: \r, Unix/linux: \n) in den HTML-Code umsetzen
                                                   $UpdateFileIdsDatabaseMainArray[$k] = preg_replace('/\r\n|\r|\n/', '<br>', $UpdateFileIdsDatabaseMainArray[$k]);
                                                   // gerader Strich (|) ist reserveiert als Feldtrenner
                                                   $UpdateFileIdsDatabaseMainArray[$k] = preg_replace('/\|/', '&#124;', $UpdateFileIdsDatabaseMainArray[$k]);
                                                }
                                                else
                                                {
                                                   print 'NOTE 3: SYSTEM-FILE ' . $HostIntrusionDetectionCurrentDatabaseFilepath . ' - function <strong>host_intrusion_detection_updating_database</strong> - IS DAMAGED!';
                                                   exit;
                                                }
                                             }
                                             $UpdateFileIdsDatabaseMainArrayCount = count($UpdateFileIdsDatabaseMainArray);
                                             for($k=0; $k<$UpdateFileIdsDatabaseMainArrayCount; $k++) {
                                                if(isset($UpdateFileIdsDatabaseMainArray[$k])) {
                                                   if($k == 0) {
                                                      $UpdateFileDataRecord .= $UpdateFileIdsDatabaseMainArray[$k];
                                                   }
                                                   else
                                                   {
                                                   $UpdateFileDataRecord .= '|' . $UpdateFileIdsDatabaseMainArray[$k];
                                                   }
                                                }
                                                else
                                                {
                                                $UpdateFileDataRecord .= '|';
                                                }
                                             }
                                             $IdsDatabaseUpdateFileArray[] = $UpdateFileDataRecord;
                                             unset($UpdateFileDataRecord);
                                             unset($UpdateFileIdsDatabaseMainArray);
                                             $ForLoopStopping=1;
                                          }
                                          else
                                          {
                                          if(!empty($ForLoopStopping)) break;
                                          }
                                       }
                                       $ForLoopStopping=0;
                                       for($z=0; $z<$AddedFileArrayCount; $z++) {
                                          if(preg_match("@^" . $CurrentIdsDatabaseDirectoryPath . "/[^/]+$@", $AddedFileArray[$z])) {
                                             // Datei-Datensatz neu erstellen
                                             $AddedFileIdsDatabaseMainArray=array();
                                             $AddedFileDataRecord='';
                                             // die laufenden Datensatz-Nummern werden erst am Schluss der Routine eingefuegt - Sortierung der Datensaetze
                                             $AddedFileIdsDatabaseMainArray[]='';
                                             $AddedFileIdsDatabaseMainArray[]=$CurrentIdsDatabaseNumber;
                                             $AddedFileIdsDatabaseMainArray[]=1;
                                             $AddedFileIdsDatabaseMainArray[]=time();
                                             $AddedFileIdsDatabaseMainArray[]=time();
                                             $DataRecordEmptyCount = $IdsDatabaseMaximalFieldCount - 19;
                                             for($k=0; $k<$DataRecordEmptyCount; $k++) {
                                                $AddedFileIdsDatabaseMainArray[]='';
                                             }
                                             $AddedFileIdsDatabaseMainArray[]=$AddedFileArray[$z];
                                             $StatFileArray = @stat($AddedFileIdsDatabaseMainArray[21]) or $FileOwnerGroupReturnCode=1;
                                             $FileOwnerName='';
                                             $FileGroupName='';
                                             $FileOwnerGroupReturnCode='';
                                             if(!empty($FileOwnerGroupReturnCode) && $FileOwnerGroupReturnCode == 1) {
                                                print 'NOTE 2: FILE ' . $AddedFileIdsDatabaseMainArray[21] . ' - function <strong>host_intrusion_detection_updating_database</strong> - FILE-OWNER AND FILE-GROUP CAN NOT DETECT!';
                                                exit;
                                             }
                                             else
                                             {
                                                $FileOwnerId = $StatFileArray[4];
                                                $FileGroupId = $StatFileArray[5];
                                                if($PosixGetPwuidArray = @posix_getpwuid($FileOwnerId)) {
                                                   $PosixGetPwuidArrayCount = count($PosixGetPwuidArray);
                                                   for($k=0; $k<$PosixGetPwuidArrayCount; $k++) {
                                                      $Key1 = key($PosixGetPwuidArray);
                                                      if(strcasecmp($Key1, "name") == 0) {
                                                         $FileOwnerName = $PosixGetPwuidArray[$Key1];
                                                         break;
                                                      }
                                                      next($PosixGetPwuidArray);
                                                   }
                                                }
                                                if($PosixGetGrgidArray = @posix_getgrgid($FileGroupId)) {
                                                   $PosixGetGrgidArrayCount = count($PosixGetGrgidArray);
                                                   for($k=0; $k<$PosixGetGrgidArrayCount; $k++) {
                                                      $Key2 = key($PosixGetGrgidArray);
                                                      if(strcasecmp($Key2, "name") == 0) {
                                                         $FileGroupName = $PosixGetGrgidArray[$Key2];
                                                         break;
                                                      }
                                                      next($PosixGetGrgidArray);
                                                   }
                                                }
                                             }
                                             clearstatcache();
                                             $AddedFileIdsDatabaseMainArray[]=$FileOwnerName;
                                             $AddedFileIdsDatabaseMainArray[]=$FileOwnerName;
                                             $AddedFileIdsDatabaseMainArray[]=$FileGroupName;
                                             $AddedFileIdsDatabaseMainArray[]=$FileGroupName;
                                             $FileCurrentAccessPermission1 = fileperms($AddedFileIdsDatabaseMainArray[21]);
                                             $FileCurrentAccessPermission2 = decoct($FileCurrentAccessPermission1);
                                             $FileCurrentAccessPermission3 = substr($FileCurrentAccessPermission2, -4);
                                             $AddedFileIdsDatabaseMainArray[]=$FileCurrentAccessPermission3;
                                             $AddedFileIdsDatabaseMainArray[]=$FileCurrentAccessPermission3;
                                             $AddedFileIdsDatabaseMainArray[] = filemtime($AddedFileIdsDatabaseMainArray[21]);
                                             $AddedFileIdsDatabaseMainArray[] = filemtime($AddedFileIdsDatabaseMainArray[21]);
                                             $AddedFileIdsDatabaseMainArray[] = filesize($AddedFileIdsDatabaseMainArray[21]);
                                             $AddedFileIdsDatabaseMainArray[] = filesize($AddedFileIdsDatabaseMainArray[21]);
                                             $Md5FileContent = $AddedFileIdsDatabaseMainArray[22] . $AddedFileIdsDatabaseMainArray[24] . $AddedFileIdsDatabaseMainArray[26] . $AddedFileIdsDatabaseMainArray[28] . $AddedFileIdsDatabaseMainArray[30];
                                             $Md5FileValue = md5($Md5FileContent);
                                             $AddedFileIdsDatabaseMainArray[]=$Md5FileValue;
                                             $AddedFileIdsDatabaseMainArray[]=$Md5FileValue;
                                             /* MD5-Status - Verzeichnis und Datei
                                                0 .. geloescht
                                                1 .. unveraendert
                                                2 .. geaendert
                                                3 .. hinzugefuegt
                                                4 .. ausgeschlossen
                                             */
                                             $AddedFileIdsDatabaseMainArray[]=3;
                                             $AddedFileIdsDatabaseMainArrayCount = count($AddedFileIdsDatabaseMainArray);
                                             for($k=0; $k<$AddedFileIdsDatabaseMainArrayCount; $k++) {
                                                // maximale Stringlaenge pruefen
                                                $CurrentFieldStringLen = strlen($AddedFileIdsDatabaseMainArray[$k]);
                                                $IdsDatabaseFieldStringLen = trim($IdsDatabaseStringLenArray[$k]);
                                                if(preg_match("/^[0-9]{1,5}$/", $IdsDatabaseFieldStringLen)) {
                                                   if($CurrentFieldStringLen > $IdsDatabaseFieldStringLen) {
                                                      // Laenge des Array-Elementes auf die maximale zulaessige Laenge kuerzen
                                                      $AddedFileIdsDatabaseMainArray[$k] = substr($AddedFileIdsDatabaseMainArray[$k], 0, $IdsDatabaseFieldStringLen);
                                                   }
                                                   $AddedFileIdsDatabaseMainArray[$k] = htmlspecialchars($AddedFileIdsDatabaseMainArray[$k], ENT_QUOTES);
                                                   // Zeilenumbruch (Windows: \r\n, MAC: \r, Unix/linux: \n) in den HTML-Code umsetzen
                                                   $AddedFileIdsDatabaseMainArray[$k] = preg_replace('/\r\n|\r|\n/', '<br>', $AddedFileIdsDatabaseMainArray[$k]);
                                                   // gerader Strich (|) ist reserveiert als Feldtrenner
                                                   $AddedFileIdsDatabaseMainArray[$k] = preg_replace('/\|/', '&#124;', $AddedFileIdsDatabaseMainArray[$k]);
                                                }
                                                else
                                                {
                                                   print 'NOTE 4: SYSTEM-FILE ' . $HostIntrusionDetectionCurrentDatabaseFilepath . ' - function <strong>host_intrusion_detection_updating_database</strong> - IS DAMAGED!';
                                                   exit;
                                                }
                                             }
                                             $AddedFileIdsDatabaseMainArrayCount = count($AddedFileIdsDatabaseMainArray);
                                             for($k=0; $k<$AddedFileIdsDatabaseMainArrayCount; $k++) {
                                                if(isset($AddedFileIdsDatabaseMainArray[$k])) {
                                                   if($k == 0) {
                                                      $AddedFileDataRecord .= $AddedFileIdsDatabaseMainArray[$k];
                                                   }
                                                   else
                                                   {
                                                   $AddedFileDataRecord .= '|' . $AddedFileIdsDatabaseMainArray[$k];
                                                   }
                                                }
                                                else
                                                {
                                                $AddedFileDataRecord .= '|';
                                                }
                                             }
                                             $IdsDatabaseUpdateFileArray[] = $AddedFileDataRecord;
                                             unset($AddedFileDataRecord);
                                             unset($AddedFileIdsDatabaseMainArray);
                                             $ForLoopStopping=1;
                                          }
                                          else
                                          {
                                          if(!empty($ForLoopStopping)) break;
                                          }
                                       }
                                       sort($IdsDatabaseUpdateFileArray);
                                       $IdsDatabaseUpdateArray = array_merge($IdsDatabaseUpdateArray, $IdsDatabaseUpdateFileArray);
                                       unset($IdsDatabaseUpdateFileArray);
                                    }
                                    else
                                    {
                                    $ReturnCodeMainDatabase=4;
                                    }
                                 }
                              } elseif(isset($NewIdsTotalDirectoryArray[$x]) && in_array($NewIdsTotalDirectoryArray[$x], $AddedDirectoryArray)) {
                                 // Verzeichnis-Datensatz neu erstellen
                                 $AddedDirectoryIdsDatabaseMainArray=array();
                                 $AddedDirectoryDataRecord='';
                                 // die laufenden Datensatz-Nummern werden erst am Schluss der Routine eingefuegt - Sortierung der Datensaetze
                                 $AddedDirectoryIdsDatabaseMainArray[]='';
                                 $AddedDirectoryIdsDatabaseMainArray[]=$CurrentIdsDatabaseNumber;
                                 $AddedDirectoryIdsDatabaseMainArray[]=1;
                                 $AddedDirectoryIdsDatabaseMainArray[]=time();
                                 $AddedDirectoryIdsDatabaseMainArray[]=time();
                                 $AddedDirectoryIdsDatabaseMainArray[]=$NewIdsTotalDirectoryArray[$x];
                                 $StatAddedDirectoryArray = @stat($AddedDirectoryIdsDatabaseMainArray[5]) or $DirectoryOwnerGroupReturnCode=1;
                                 $DirectoryOwnerName='';
                                 $DirectoryGroupName='';
                                 $DirectoryOwnerGroupReturnCode='';
                                 if(!empty($DirectoryOwnerGroupReturnCode) && $DirectoryOwnerGroupReturnCode == 1) {
                                    print 'NOTE 2: DIRECTORY ' . $AddedDirectoryIdsDatabaseMainArray[5] . ' - function <strong>host_intrusion_detection_updating_database</strong> - DIRECTORY-OWNER AND DIRECTORY-GROUP CAN NOT DETECT!';
                                    exit;
                                 }
                                 else
                                 {
                                    $DirectoryOwnerId = $StatAddedDirectoryArray[4];
                                    $DirectoryGroupId = $StatAddedDirectoryArray[5];
                                    if($PosixGetPwuidArray = @posix_getpwuid($DirectoryOwnerId)) {
                                       $PosixGetPwuidArrayCount = count($PosixGetPwuidArray);
                                       for($k=0; $k<$PosixGetPwuidArrayCount; $k++) {
                                          $Key1 = key($PosixGetPwuidArray);
                                          if(strcasecmp($Key1, "name") == 0) {
                                             $DirectoryOwnerName = $PosixGetPwuidArray[$Key1];
                                             break;
                                          }
                                          next($PosixGetPwuidArray);
                                       }
                                    }
                                    if($PosixGetGrgidArray = @posix_getgrgid($DirectoryGroupId)) {
                                       $PosixGetGrgidArrayCount = count($PosixGetGrgidArray);
                                       for($k=0; $k<$PosixGetGrgidArrayCount; $k++) {
                                          $Key2 = key($PosixGetGrgidArray);
                                          if(strcasecmp($Key2, "name") == 0) {
                                             $DirectoryGroupName = $PosixGetGrgidArray[$Key2];
                                             break;
                                          }
                                          next($PosixGetGrgidArray);
                                       }
                                    }
                                 }
                                 clearstatcache();
                                 $AddedDirectoryIdsDatabaseMainArray[]=$DirectoryOwnerName;
                                 $AddedDirectoryIdsDatabaseMainArray[]=$DirectoryOwnerName;
                                 $AddedDirectoryIdsDatabaseMainArray[]=$DirectoryGroupName;
                                 $AddedDirectoryIdsDatabaseMainArray[]=$DirectoryGroupName;
                                 $AddedDirectoryCurrentAccessPermission1 = fileperms($AddedDirectoryIdsDatabaseMainArray[5]);
                                 $AddedDirectoryCurrentAccessPermission2 = decoct($AddedDirectoryCurrentAccessPermission1);
                                 $AddedDirectoryCurrentAccessPermission3 = substr($AddedDirectoryCurrentAccessPermission2, -4);
                                 $AddedDirectoryIdsDatabaseMainArray[]=$AddedDirectoryCurrentAccessPermission3;
                                 $AddedDirectoryIdsDatabaseMainArray[]=$AddedDirectoryCurrentAccessPermission3;
                                 $AddedDirectoryIdsDatabaseMainArray[] = filectime($AddedDirectoryIdsDatabaseMainArray[5]);
                                 $AddedDirectoryIdsDatabaseMainArray[] = filectime($AddedDirectoryIdsDatabaseMainArray[5]);
                                 $AddedIdsCurrentDirectoryNumber=0;
                                 $AddedIdsCurrentFileNumber=0;
                                 $AddedIdsCurrentDirectoryHandle = @opendir($AddedDirectoryIdsDatabaseMainArray[5]);
                                 while($AddedIdsCurrentFileName = @readdir($AddedIdsCurrentDirectoryHandle)) {
                                    if($AddedIdsCurrentFileName != "." && $AddedIdsCurrentFileName != "..") {
                                       $AddedNextFile = $AddedDirectoryIdsDatabaseMainArray[5] . "/" . $AddedIdsCurrentFileName;
                                       if(file_exists($AddedNextFile) && is_dir($AddedNextFile)) {
                                          if(!empty($DirectoryExclusionLineArray) && is_array($DirectoryExclusionLineArray)) {
                                             $AddedDirectoryExclusion=0;
                                             $AddedDirectoryExclusionLineArrayCount = count($DirectoryExclusionLineArray);
                                             for($y=0; $y<$AddedDirectoryExclusionLineArrayCount; $y++) {
                                                $AddedDirectoryStringComparison = strcmp($AddedNextFile, $DirectoryExclusionLineArray[$y]);
                                                if($DirectoryExclusionLineArray[$y] != "" && $AddedDirectoryStringComparison == 0) {
                                                   $AddedDirectoryExclusion=1;
                                                   break;
                                                }
                                             }
                                             if(empty($AddedDirectoryExclusion)) {
                                                $AddedIdsCurrentDirectoryNumber++;
                                             }
                                             else
                                             {
                                             unset($AddedDirectoryExclusion);
                                             }
                                          }
                                          else
                                          {
                                          $AddedIdsCurrentDirectoryNumber++;
                                          }
                                       } elseif(file_exists($AddedNextFile) && !is_dir($AddedNextFile)) {
                                          if(!empty($FileExclusionLineArray) && is_array($FileExclusionLineArray)) {
                                             $AddedFileExclusion=0;
                                             $AddedFileExclusionLineArrayCount = count($FileExclusionLineArray);
                                             for($y=0; $y<$AddedFileExclusionLineArrayCount; $y++) {
                                                $AddedFileStringComparison = strcmp($AddedNextFile, $FileExclusionLineArray[$y]);
                                                if($FileExclusionLineArray[$y] != "" && $AddedFileStringComparison == 0) {
                                                   $AddedFileExclusion=1;
                                                   break;
                                                }
                                             }
                                             if(empty($AddedFileExclusion)) {
                                                $AddedIdsCurrentFileNumber++;
                                             }
                                             else
                                             {
                                             unset($AddedFileExclusion);
                                             }
                                          }
                                          else
                                          {
                                          $AddedIdsCurrentFileNumber++;
                                          }
                                       }
                                    }
                                 }
                                 @closedir($AddedIdsCurrentDirectoryHandle);
                                 $AddedDirectoryIdsDatabaseMainArray[]=$AddedIdsCurrentDirectoryNumber;
                                 $AddedDirectoryIdsDatabaseMainArray[]=$AddedIdsCurrentDirectoryNumber;
                                 $AddedDirectoryIdsDatabaseMainArray[]=$AddedIdsCurrentFileNumber;
                                 $AddedDirectoryIdsDatabaseMainArray[]=$AddedIdsCurrentFileNumber;
                                 $Md5AddedDirectoryContent = $AddedDirectoryIdsDatabaseMainArray[6] .  $AddedDirectoryIdsDatabaseMainArray[8] .  $AddedDirectoryIdsDatabaseMainArray[10] . $AddedDirectoryIdsDatabaseMainArray[12] . $AddedIdsCurrentDirectoryNumber . $AddedIdsCurrentFileNumber;
                                 $Md5AddedDirectoryValue = md5($Md5AddedDirectoryContent);
                                 $AddedDirectoryIdsDatabaseMainArray[]=$Md5AddedDirectoryValue;
                                 $AddedDirectoryIdsDatabaseMainArray[]=$Md5AddedDirectoryValue;
                                 /* MD5-Status - Verzeichnis und Datei
                                    0 .. geloescht
                                    1 .. unveraendert
                                    2 .. geaendert
                                    3 .. hinzugefuegt
                                    4 .. ausgeschlossen
                                 */
                                 $AddedDirectoryIdsDatabaseMainArray[]=3;
                                 $AddedDirectoryDataRecordArrayCount = count($AddedDirectoryIdsDatabaseMainArray);
                                 $AddedDataRecordEmptyCount = $IdsDatabaseMaximalFieldCount - $AddedDirectoryDataRecordArrayCount;
                                 for($y=0; $y<$AddedDataRecordEmptyCount; $y++) {
                                    $AddedDirectoryIdsDatabaseMainArray[]='';
                                 }
                                 $AddedDirectoryIdsDatabaseMainArrayCount = count($AddedDirectoryIdsDatabaseMainArray);
                                 for($y=0; $y<$AddedDirectoryIdsDatabaseMainArrayCount; $y++) {
                                    // maximale Stringlaenge pruefen
                                    $CurrentFieldStringLen = strlen($AddedDirectoryIdsDatabaseMainArray[$y]);
                                    $IdsDatabaseFieldStringLen = trim($IdsDatabaseStringLenArray[$y]);
                                    if(preg_match("/^[0-9]{1,5}$/", $IdsDatabaseFieldStringLen)) {
                                       if($CurrentFieldStringLen > $IdsDatabaseFieldStringLen) {
                                          // Laenge des Array-Elementes auf die maximale zulaessige Laenge kuerzen
                                          $AddedDirectoryIdsDatabaseMainArray[$y] = substr($AddedDirectoryIdsDatabaseMainArray[$y], 0, $IdsDatabaseFieldStringLen);
                                       }
                                       $AddedDirectoryIdsDatabaseMainArray[$y] = htmlspecialchars($AddedDirectoryIdsDatabaseMainArray[$y], ENT_QUOTES);
                                       // Zeilenumbruch (Windows: \r\n, MAC: \r, Unix/linux: \n) in den HTML-Code umsetzen
                                       $AddedDirectoryIdsDatabaseMainArray[$y] = preg_replace('/\r\n|\r|\n/', '<br>', $AddedDirectoryIdsDatabaseMainArray[$y]);
                                       // gerader Strich (|) ist reserveiert als Feldtrenner
                                       $AddedDirectoryIdsDatabaseMainArray[$y] = preg_replace('/\|/', '&#124;', $AddedDirectoryIdsDatabaseMainArray[$y]);
                                    }
                                    else
                                    {
                                       print 'NOTE 3: SYSTEM-FILE ' . $HostIntrusionDetectionCurrentDatabaseFilepath . ' - function <strong>host_intrusion_detection_updating_database</strong> - IS DAMAGED!';
                                       exit;
                                    }
                                }
                                $AddedDirectoryIdsDatabaseMainArrayCount = count($AddedDirectoryIdsDatabaseMainArray);
                                for($y=0; $y<$AddedDirectoryIdsDatabaseMainArrayCount; $y++) {
                                   if(isset($AddedDirectoryIdsDatabaseMainArray[$y])) {
                                      if($y == 0) {
                                         $AddedDirectoryDataRecord .= $AddedDirectoryIdsDatabaseMainArray[$y];
                                      }
                                      else
                                      {
                                      $AddedDirectoryDataRecord .= '|' . $AddedDirectoryIdsDatabaseMainArray[$y];
                                      }
                                   }
                                   else
                                   {
                                   $AddedDirectoryDataRecord .= '|';
                                   }
                                }
                                $IdsDatabaseUpdateArray[] = $AddedDirectoryDataRecord;
                                unset($AddedDirectoryIdsDatabaseMainArray);
                                unset($AddedDirectoryDataRecord);
                                $IdsDatabaseUpdateAddedFileArray=array();
                                $ForLoopStopping=0;
                                for($y=0; $y<$AddedFileArrayCount; $y++) {
                                   if(preg_match("@^" . $NewIdsTotalDirectoryArray[$x] . "/[^/]+$@", $AddedFileArray[$y])) {
                                      // Datei-Datensatz neu erstellen
                                      $AddedFileIdsDatabaseMainArray=array();
                                      $AddedFileDataRecord='';
                                      // die laufenden Datensatz-Nummern werden erst am Schluss der Routine eingefuegt - Sortierung der Datensaetze
                                      $AddedFileIdsDatabaseMainArray[]='';
                                      $AddedFileIdsDatabaseMainArray[]=$CurrentIdsDatabaseNumber;
                                      $AddedFileIdsDatabaseMainArray[]=1;
                                      $AddedFileIdsDatabaseMainArray[]=time();
                                      $AddedFileIdsDatabaseMainArray[]=time();
                                      $DataRecordEmptyCount = $IdsDatabaseMaximalFieldCount - 19;
                                      for($z=0; $z<$DataRecordEmptyCount; $z++) {
                                         $AddedFileIdsDatabaseMainArray[]='';
                                      }
                                      $AddedFileIdsDatabaseMainArray[]=$AddedFileArray[$y];
                                      $StatAddedFileArray = @stat($AddedFileIdsDatabaseMainArray[21]) or $FileOwnerGroupReturnCode=1;
                                      $FileOwnerName='';
                                      $FileGroupName='';
                                      $FileOwnerGroupReturnCode='';
                                      if(!empty($FileOwnerGroupReturnCode) && $FileOwnerGroupReturnCode == 1) {
                                         print 'NOTE 3: FILE ' . $AddedFileIdsDatabaseMainArray[21] . ' - function <strong>host_intrusion_detection_updating_database</strong> - FILE-OWNER AND FILE-GROUP CAN NOT DETECT!';
                                         exit;
                                      }
                                      else
                                      {
                                         $FileOwnerId = $StatAddedFileArray[4];
                                         $FileGroupId = $StatAddedFileArray[5];
                                         if($PosixGetPwuidArray = @posix_getpwuid($FileOwnerId)) {
                                            $PosixGetPwuidArrayCount = count($PosixGetPwuidArray);
                                            for($k=0; $k<$PosixGetPwuidArrayCount; $k++) {
                                               $Key1 = key($PosixGetPwuidArray);
                                               if(strcasecmp($Key1, "name") == 0) {
                                                  $FileOwnerName = $PosixGetPwuidArray[$Key1];
                                                  break;
                                               }
                                               next($PosixGetPwuidArray);
                                            }
                                         }
                                         if($PosixGetGrgidArray = @posix_getgrgid($FileGroupId)) {
                                            $PosixGetGrgidArrayCount = count($PosixGetGrgidArray);
                                            for($k=0; $k<$PosixGetGrgidArrayCount; $k++) {
                                               $Key2 = key($PosixGetGrgidArray);
                                               if(strcasecmp($Key2, "name") == 0) {
                                                  $FileGroupName = $PosixGetGrgidArray[$Key2];
                                                  break;
                                               }
                                               next($PosixGetGrgidArray);
                                            }
                                         }
                                      }
                                      clearstatcache();
                                      $AddedFileIdsDatabaseMainArray[]=$FileOwnerName;
                                      $AddedFileIdsDatabaseMainArray[]=$FileOwnerName;
                                      $AddedFileIdsDatabaseMainArray[]=$FileGroupName;
                                      $AddedFileIdsDatabaseMainArray[]=$FileGroupName;
                                      $FileCurrentAccessPermission1 = fileperms($AddedFileIdsDatabaseMainArray[21]);
                                      $FileCurrentAccessPermission2 = decoct($FileCurrentAccessPermission1);
                                      $FileCurrentAccessPermission3 = substr($FileCurrentAccessPermission2, -4);
                                      $AddedFileIdsDatabaseMainArray[]=$FileCurrentAccessPermission3;
                                      $AddedFileIdsDatabaseMainArray[]=$FileCurrentAccessPermission3;
                                      $AddedFileIdsDatabaseMainArray[] = filemtime($AddedFileIdsDatabaseMainArray[21]);
                                      $AddedFileIdsDatabaseMainArray[] = filemtime($AddedFileIdsDatabaseMainArray[21]);
                                      $AddedFileIdsDatabaseMainArray[] = filesize($AddedFileIdsDatabaseMainArray[21]);
                                      $AddedFileIdsDatabaseMainArray[] = filesize($AddedFileIdsDatabaseMainArray[21]);
                                      $Md5FileContent = $AddedFileIdsDatabaseMainArray[22] .  $AddedFileIdsDatabaseMainArray[24] .  $AddedFileIdsDatabaseMainArray[26] . $AddedFileIdsDatabaseMainArray[28] . $AddedFileIdsDatabaseMainArray[30];
                                      $Md5FileValue = md5($Md5FileContent);
                                      $AddedFileIdsDatabaseMainArray[]=$Md5FileValue;
                                      $AddedFileIdsDatabaseMainArray[]=$Md5FileValue;
                                      /* MD5-Status - Verzeichnis und Datei
                                         0 .. geloescht
                                         1 .. unveraendert
                                         2 .. geaendert
                                         3 .. hinzugefuegt
                                         4 .. ausgeschlossen
                                      */
                                      $AddedFileIdsDatabaseMainArray[]=3;
                                      $AddedFileIdsDatabaseMainArrayCount = count($AddedFileIdsDatabaseMainArray);
                                      for($z=0; $z<$AddedFileIdsDatabaseMainArrayCount; $z++) {
                                         // maximale Stringlaenge pruefen
                                         $CurrentFieldStringLen = strlen($AddedFileIdsDatabaseMainArray[$z]);
                                         $IdsDatabaseFieldStringLen = trim($IdsDatabaseStringLenArray[$z]);
                                         if(preg_match("/^[0-9]{1,5}$/", $IdsDatabaseFieldStringLen)) {
                                            if($CurrentFieldStringLen > $IdsDatabaseFieldStringLen) {
                                               // Laenge des Array-Elementes auf die maximale zulaessige Laenge kuerzen
                                               $AddedFileIdsDatabaseMainArray[$z] = substr($AddedFileIdsDatabaseMainArray[$z], 0, $IdsDatabaseFieldStringLen);
                                            }
                                            $AddedFileIdsDatabaseMainArray[$z] = htmlspecialchars($AddedFileIdsDatabaseMainArray[$z], ENT_QUOTES);
                                            // Zeilenumbruch (Windows: \r\n, MAC: \r, Unix/linux: \n) in den HTML-Code umsetzen
                                            $AddedFileIdsDatabaseMainArray[$z] = preg_replace('/\r\n|\r|\n/', '<br>', $AddedFileIdsDatabaseMainArray[$z]);
                                            // gerader Strich (|) ist reserveiert als Feldtrenner
                                            $AddedFileIdsDatabaseMainArray[$z] = preg_replace('/\|/', '&#124;', $AddedFileIdsDatabaseMainArray[$z]);
                                         }
                                         else
                                         {
                                            print 'NOTE 4: SYSTEM-FILE ' . $HostIntrusionDetectionCurrentDatabaseFilepath . ' - function <strong>host_intrusion_detection_updating_database</strong> - IS DAMAGED!';
                                            exit;
                                         }
                                      }
                                      $AddedFileIdsDatabaseMainArrayCount = count($AddedFileIdsDatabaseMainArray);
                                      for($z=0; $z<$AddedFileIdsDatabaseMainArrayCount; $z++) {
                                         if(isset($AddedFileIdsDatabaseMainArray[$z])) {
                                            if($z == 0) {
                                               $AddedFileDataRecord .= $AddedFileIdsDatabaseMainArray[$z];
                                            }
                                            else
                                            {
                                            $AddedFileDataRecord .= '|' . $AddedFileIdsDatabaseMainArray[$z];
                                            }
                                         }
                                         else
                                         {
                                         $AddedFileDataRecord .= '|';
                                         }
                                      }
                                      $IdsDatabaseUpdateAddedFileArray[] = $AddedFileDataRecord;
                                      unset($AddedFileDataRecord);
                                      unset($AddedFileIdsDatabaseMainArray);
                                      $ForLoopStopping=1;
                                    }
                                    else
                                    {
                                    if(!empty($ForLoopStopping)) break;
                                    }
                                 }
                                 sort($IdsDatabaseUpdateAddedFileArray);
                                 $IdsDatabaseUpdateArray = array_merge($IdsDatabaseUpdateArray, $IdsDatabaseUpdateAddedFileArray);
                                 unset($IdsDatabaseUpdateAddedFileArray);
                              }
                              else
                              {
                                 print 'NOTE: SYSTEM-ARRAY NewIdsTotalDirectoryArray OR AddedDirectoryArray - function <strong>host_intrusion_detection_updating_database</strong> - ARE DAMAGED!';
                                 exit;
                              }
                           }
                           $CurrentIdsDatabaseDataRecords='';
                           $DataRecordNumber=0;
                           $IdsDatabaseUpdateArrayCount = count($IdsDatabaseUpdateArray);
                           for($x=0; $x<$IdsDatabaseUpdateArrayCount; $x++) {
                              if($x < 2) {
                                 $CurrentIdsDatabaseDataRecords .= $IdsDatabaseUpdateArray[$x] . "\n";
                              }
                              else
                              {
                                 $DataRecordNumber++;
                                 $CurrentIdsDatabaseDataRecords .= $DataRecordNumber . $IdsDatabaseUpdateArray[$x] . "\n";
                              }
                           }
                           unset($IdsDatabaseUpdateArray);
                           if($DatabaseFileWrite = @fopen($HostIntrusionDetectionCurrentDatabaseFilepath,'w')) {
                              @flock($DatabaseFileWrite,2);
                              @fwrite($DatabaseFileWrite, $CurrentIdsDatabaseDataRecords);
                              @flock($DatabaseFileWrite,3);
                              @fclose($DatabaseFileWrite);
                              $ReturnCodeMainDatabase=1;
                           }
                           else
                           { 
                           $ReturnCodeMainDatabase=5;
                           }
                        }
                     }
                     else
                     {
                     $ReturnCodeMainDatabase=4;
                     }
                  }
                  else
                  {
                  $ReturnCodeMainDatabase=3;
                  }
                  unset($CurrentIdsDatabaseMainArray);
                  unset($DirectoryExclusionLineArray);
                  unset($FileExclusionLineArray);
               }
               else
               {
                  print 'NOTE: SYSTEM-VARIABLES - function <strong>host_intrusion_detection_updating_database</strong> - NOT DEFINED OR DAMAGED!';
                  exit;
               }
            }
         }
         else
         {
         $ReturnCodeMainDatabase=2;
         }
         array_push($ReturnCodeArray, $ConfigurationReturnCode, $ReportReturnCode, $ReturnCodeMainDatabase, $ReturnCodeDirectoryExclusion, $ReturnCodeFileExclusion);
         return $ReturnCodeArray;
      }
      else
      {
         print 'NOTE: SYSTEM-ARRAY HostIntrusionDetectionArray (ARRAY-COUNT) - function <strong>host_intrusion_detection_updating_database</strong> - IS DAMAGED!';
         exit;
      }
   }

   // Funktion fuer die Anzeige der IDS-Datenbanken
   function host_intrusion_detection_read_database($HostIntrusionDetectionCurrentDatabaseFilepath='', $HostIntrusionDetectionCurrentReportDatabaseFilepath='', $HostIntrusionDetectionArray='', $HostIntrusionDetectionGeneralSurveyTitlesArray='', $HostIntrusionDetectionResultTableTitlesArray='', $HostIntrusionDetectionMd5StatusNoteArray='', $HostIntrusionDetectionReadDatabaseDetailsArray='', $HostIntrusionDetectionReadDatabaseMessagesArray='') {
      // Funktion liest 2 Datenbanken (hids_db_x.dat, directory_file_report_x.dat)
      $ReportReturnCode=0;
      $ReturnCode=0;
      $DatabaseOutputHtml='';
      $GigaByte=1024 * 1024 * 1024;
      $MegaByte=1024 * 1024;
      $KiloByte=1024;
      $ReturnCodeDatabaseOutputArray=array();
      $HostIntrusionDetectionArrayDefaultCount=11; // Vorgabe: Anzahl der Array-Elemente
      $HostIntrusionDetectionArrayCurrentCount=count($HostIntrusionDetectionArray);
      $HostIntrusionDetectionGeneralSurveyTitlesArrayDefaultCount=10; // Vorgabe: Anzahl der Array-Elemente
      $HostIntrusionDetectionGeneralSurveyTitlesArrayCurrentCount=count($HostIntrusionDetectionGeneralSurveyTitlesArray);
      $HostIntrusionDetectionResultTableTitlesArrayDefaultCount=27; // Vorgabe: Anzahl der Array-Elemente
      $HostIntrusionDetectionResultTableTitlesArrayCurrentCount=count($HostIntrusionDetectionResultTableTitlesArray);
      $HostIntrusionDetectionMd5StatusNoteArrayDefaultCount=5; // Vorgabe: Anzahl der Array-Elemente
      $HostIntrusionDetectionMd5StatusNoteArrayCurrentCount=count($HostIntrusionDetectionMd5StatusNoteArray);
      $HostIntrusionDetectionReadDatabaseDetailsArrayDefaultCount=4; // Vorgabe: Anzahl der Array-Elemente
      $HostIntrusionDetectionReadDatabaseDetailsArrayCurrentCount=count($HostIntrusionDetectionReadDatabaseDetailsArray);
      $HostIntrusionDetectionReadDatabaseMessagesArrayDefaultCount=3; // Vorgabe: Anzahl der Array-Elemente
      $HostIntrusionDetectionReadDatabaseMessagesArrayCurrentCount=count($HostIntrusionDetectionReadDatabaseMessagesArray);
      $ReportDatabaseMaximalFieldCount=11; // maximale Anzahl der Felder in der Reportdatenbank
      $IdsDatabaseMaximalFieldCount=35; // maximale Anzahl der Felder in der Hauptdatenbank
      if(isset($HostIntrusionDetectionArray) &&
         is_array($HostIntrusionDetectionArray) &&
         $HostIntrusionDetectionArrayDefaultCount == $HostIntrusionDetectionArrayCurrentCount &&
         isset($HostIntrusionDetectionGeneralSurveyTitlesArray) &&
         is_array($HostIntrusionDetectionGeneralSurveyTitlesArray) &&
         $HostIntrusionDetectionGeneralSurveyTitlesArrayDefaultCount == $HostIntrusionDetectionGeneralSurveyTitlesArrayCurrentCount &&
         isset($HostIntrusionDetectionResultTableTitlesArray) &&
         is_array($HostIntrusionDetectionResultTableTitlesArray) &&
         $HostIntrusionDetectionResultTableTitlesArrayDefaultCount == $HostIntrusionDetectionResultTableTitlesArrayCurrentCount &&
         isset($HostIntrusionDetectionMd5StatusNoteArray) &&
         is_array($HostIntrusionDetectionMd5StatusNoteArray) &&
         $HostIntrusionDetectionMd5StatusNoteArrayDefaultCount == $HostIntrusionDetectionMd5StatusNoteArrayCurrentCount &&
         isset($HostIntrusionDetectionReadDatabaseDetailsArray) &&
         is_array($HostIntrusionDetectionReadDatabaseDetailsArray) &&
         $HostIntrusionDetectionReadDatabaseMessagesArrayDefaultCount == $HostIntrusionDetectionReadDatabaseMessagesArrayCurrentCount &&
         isset($HostIntrusionDetectionReadDatabaseMessagesArray) &&
         is_array($HostIntrusionDetectionReadDatabaseMessagesArray) &&
         $HostIntrusionDetectionReadDatabaseMessagesArrayDefaultCount == $HostIntrusionDetectionReadDatabaseMessagesArrayCurrentCount) {
         if(file_exists($HostIntrusionDetectionCurrentDatabaseFilepath) &&
            is_readable($HostIntrusionDetectionCurrentDatabaseFilepath) &&
            file_exists($HostIntrusionDetectionCurrentReportDatabaseFilepath) &&
            is_readable($HostIntrusionDetectionCurrentReportDatabaseFilepath)) {
            if(!empty($HostIntrusionDetectionArray[0]) ||
               !empty($HostIntrusionDetectionArray[1]) ||
               !empty($HostIntrusionDetectionArray[2])) {
               // Datenbank mit der Uebersicht der Verzeichnisse und Dateien einlesen und ausgeben
               $ReportDatabaseLineThreeArray=array();
               $CurrentReportDatabaseArray = file($HostIntrusionDetectionCurrentReportDatabaseFilepath);
               $CurrentReportDatabaseArrayCount = count($CurrentReportDatabaseArray);
               if($CurrentReportDatabaseArrayCount > 2) {
                  $ReportDatabaseLineThreeArray = explode("|", $CurrentReportDatabaseArray[2]);
                  $ReportDatabaseLineThreeArrayCount = count($ReportDatabaseLineThreeArray);
                  if($ReportDatabaseLineThreeArrayCount < $ReportDatabaseMaximalFieldCount) {
                     for($y=$ReportDatabaseLineThreeArrayCount; $y<$ReportDatabaseMaximalFieldCount; $y++) {
                        $ReportDatabaseLineThreeArray[]='';
                     }
                  }
                  $ReportReturnCode=1;
               }
               else
               {
                  for($y=0; $y<$ReportDatabaseMaximalFieldCount; $y++) {
                     $ReportDatabaseLineThreeArray[]='';
                  }
                  $ReportReturnCode=3;
               }
               $DirectoryTotalStatus = trim($ReportDatabaseLineThreeArray[8]);
               $FileTotalStatus = trim($ReportDatabaseLineThreeArray[11]);
               if((preg_match("/^[0-9]$/", $DirectoryTotalStatus) && $DirectoryTotalStatus != 1) ||
                  (preg_match("/^[0-9]$/", $FileTotalStatus) && $FileTotalStatus != 1)) {
                  $ActivationMessagesModificationNote=1;
               }
               $DatabaseOutputHtml .="    <result>\n";
               $DatabaseOutputHtml .="      <table>\n";
               $DatabaseOutputHtml .="        <tr>\n";
               $DatabaseOutputHtml .="          <td>\n";
               $DatabaseOutputHtml .="            <table class=\"table_result_a\">\n";
               $DatabaseOutputHtml .="              <tr>\n";
               $DatabaseOutputHtml .="                <td class=\"title_column_1\">" . trim($HostIntrusionDetectionGeneralSurveyTitlesArray[0]) . "</td>\n";
               $DatabaseOutputHtml .="                <td class=\"data_column_2\" colspan=\"2\">" . trim($ReportDatabaseLineThreeArray[5]) . "</td>\n";
               $DatabaseOutputHtml .="                <td class=\"title_column_4\">" . trim($HostIntrusionDetectionGeneralSurveyTitlesArray[5]) . "</td>\n";
               $DatabaseOutputHtml .="                <td class=\"title_column_5\">" . trim($HostIntrusionDetectionGeneralSurveyTitlesArray[6]) . "</td>\n";
               $DatabaseOutputHtml .="              </tr>\n";
               $DatabaseOutputHtml .="              <tr>\n";
               $DatabaseOutputHtml .="                <td class=\"title_column_1\">" . trim($HostIntrusionDetectionGeneralSurveyTitlesArray[1]) . "</td>\n";
               $IdsDatabaseCreateUnixDate = trim($ReportDatabaseLineThreeArray[3]);
               if(!empty($IdsDatabaseCreateUnixDate) && preg_match("/^[0-9]{1,}$/", $IdsDatabaseCreateUnixDate)) {
                  $IdsDatabaseCreateDate = date("Y-m-d", $IdsDatabaseCreateUnixDate);
                  $DatabaseOutputHtml .="                <td class=\"data_column_2\">" . $IdsDatabaseCreateDate . "</td>\n";
               } elseif(empty($IdsDatabaseCreateUnixDate)) {
                  $DatabaseOutputHtml .="                <td class=\"data_column_2\">-</td>\n";
               }
               else
               {
               // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
               $DatabaseOutputHtml .="                <td class=\"data_column_2_red\">" . $IdsDatabaseCreateUnixDate . "</td>\n";
               }
               $DatabaseOutputHtml .="                <td class=\"title_column_3\">" . trim($HostIntrusionDetectionGeneralSurveyTitlesArray[7]) . "</td>\n";
               $DirectoryTotalNumber1 = trim($ReportDatabaseLineThreeArray[6]);
               $DirectoryTotalNumber2 = trim($ReportDatabaseLineThreeArray[7]);
               if(!empty($DirectoryTotalNumber1) && preg_match("/^[0-9]{1,}$/", $DirectoryTotalNumber1)) {
                  $DatabaseOutputHtml .="                <td class=\"data_column_4\">" . $DirectoryTotalNumber1 . "</td>\n";
               } elseif(empty($DirectoryTotalNumber1)) {
                  $DatabaseOutputHtml .="                <td class=\"data_column_4\">-</td>\n";
               }
               else
               {
               // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
               $DatabaseOutputHtml .="                <td class=\"data_column_4_red\">" . $DirectoryTotalNumber1 . "</td>\n";
               }
               if(!empty($DirectoryTotalStatus) && preg_match("/^[1]$/", $DirectoryTotalStatus)) {
                  if(empty($DirectoryTotalNumber2)) $DirectoryTotalNumber2='-';
                  $DatabaseOutputHtml .="                <td class=\"data_column_5\">" . $DirectoryTotalNumber2 . "</td>\n";
               } elseif(isset($DirectoryTotalStatus) && preg_match("/^[0]$/", $DirectoryTotalStatus)) {
                  $DatabaseOutputHtml .="                <td class=\"data_column_5_red\">" . $DirectoryTotalNumber2 . "</td>\n";
               } elseif(empty($DirectoryTotalNumber2)) {
                  $DatabaseOutputHtml .="                <td class=\"data_column_5\">-</td>\n";
               }
               else
               {
               // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
               $DatabaseOutputHtml .="                <td class=\"data_column_5_red\">" . $DirectoryTotalNumber2 . "</td>\n";
               }
               $DatabaseOutputHtml .="              </tr>\n";
               $DatabaseOutputHtml .="              <tr>\n";
               $DatabaseOutputHtml .="                <td class=\"title_column_1\">" . trim($HostIntrusionDetectionGeneralSurveyTitlesArray[2]) . "</td>\n";
               $IdsDatabaseCreateUnixTime = trim($ReportDatabaseLineThreeArray[3]);
               if(!empty($IdsDatabaseCreateUnixTime) && preg_match("/^[0-9]{1,}$/", $IdsDatabaseCreateUnixTime)) {
                  $IdsDataBaseCreateTime = date("H:i:s", $IdsDatabaseCreateUnixTime);
                  $DatabaseOutputHtml .="                <td class=\"data_column_2\">" . $IdsDataBaseCreateTime . "</td>\n";
               } elseif(empty($IdsDatabaseCreateUnixTime)) {
                  $DatabaseOutputHtml .="                <td class=\"data_column_2\">-</td>\n";
               }
               else
               {
               // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
               $DatabaseOutputHtml .="                <td class=\"data_column_2_red\">" . $IdsDatabaseCreateUnixTime . "</td>\n";
               }
               $DatabaseOutputHtml .="                <td class=\"data_column_3\">&nbsp;</td>\n";
               $DatabaseOutputHtml .="                <td class=\"data_column_4\">&nbsp;</td>\n";
               $DatabaseOutputHtml .="                <td class=\"data_column_5\">&nbsp;</td>\n";
               $DatabaseOutputHtml .="              </tr>\n";
               $DatabaseOutputHtml .="              <tr>\n";
               $DatabaseOutputHtml .="                <td class=\"title_column_1\">" . trim($HostIntrusionDetectionGeneralSurveyTitlesArray[3]) . "</td>\n";
               $IdsDatabaseLastCheckUnixDate = trim($ReportDatabaseLineThreeArray[4]);
               if(!empty($IdsDatabaseLastCheckUnixDate) && preg_match("/^[0-9]{1,}$/", $IdsDatabaseLastCheckUnixDate)) {
                  $IdsDatabaseLastCheckDate = date("Y-m-d", $IdsDatabaseLastCheckUnixDate);
                  $DatabaseOutputHtml .="                <td class=\"data_column_2\">" . $IdsDatabaseLastCheckDate . "</td>\n";
               } elseif(empty($IdsDatabaseLastCheckUnixDate)) {
                  $DatabaseOutputHtml .="                <td class=\"data_column_2\">-</td>\n";
               }
               else
               {
               // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
               $DatabaseOutputHtml .="                <td class=\"data_column_2_red\">" . $IdsDatabaseLastCheckUnixDate . "</td>\n";
               }
               $DatabaseOutputHtml .="                <td class=\"title_column_3\">" . trim($HostIntrusionDetectionGeneralSurveyTitlesArray[8]) . "</td>\n";
               $FileTotalNumber1 = trim($ReportDatabaseLineThreeArray[9]);
               $FileTotalNumber2 = trim($ReportDatabaseLineThreeArray[10]);
               if(!empty($FileTotalNumber1) && preg_match("/^[0-9]{1,}$/", $FileTotalNumber1)) {
                  $DatabaseOutputHtml .="                <td class=\"data_column_4\">" . $FileTotalNumber1 . "</td>\n";
               } elseif(empty($FileTotalNumber1)) {
                  $DatabaseOutputHtml .="                <td class=\"data_column_4\">-</td>\n";
               }
               else
               {
               // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
               $DatabaseOutputHtml .="                <td class=\"data_column_4_red\">" . $FileTotalNumber1 . "</td>\n";
               }
               if(!empty($FileTotalStatus) && preg_match("/^[1]$/", $FileTotalStatus)) {
                  if(empty($FileTotalNumber2)) $FileTotalNumber2='-';
                  $DatabaseOutputHtml .="                <td class=\"data_column_5\">" . $FileTotalNumber2 . "</td>\n";
               } elseif(isset($FileTotalStatus) && preg_match("/^[0]$/", $FileTotalStatus)) {
                  $DatabaseOutputHtml .="                <td class=\"data_column_5_red\">" . $FileTotalNumber2 . "</td>\n";
               } elseif(empty($FileTotalNumber2)) {
                  $DatabaseOutputHtml .="                <td class=\"data_column_5\">-</td>\n";
               }
               else
               {
               // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
               $DatabaseOutputHtml .="                <td class=\"data_column_5_red\">" . $FileTotalNumber2 . "</td>\n";
               }
               $DatabaseOutputHtml .="              </tr>\n";
               $DatabaseOutputHtml .="              <tr>\n";
               $DatabaseOutputHtml .="                <td class=\"title_column_1\">" . trim($HostIntrusionDetectionGeneralSurveyTitlesArray[4]) . "</td>\n";
               $IdsDatabaseLastCheckUnixTime = trim($ReportDatabaseLineThreeArray[4]);
               if(!empty($IdsDatabaseLastCheckUnixTime) && preg_match("/^[0-9]{1,}$/", $IdsDatabaseLastCheckUnixTime)) {
                  $IdsDataBaseLastCheckTime = date("H:i:s", $IdsDatabaseLastCheckUnixTime);
                  $DatabaseOutputHtml .="                <td class=\"data_column_2\">" . $IdsDataBaseLastCheckTime . "</td>\n";
               } elseif(empty($IdsDatabaseLastCheckUnixTime)) {
                  $DatabaseOutputHtml .="                <td class=\"data_column_2\">-</td>\n";
               }
               else
               {
               // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
               $DatabaseOutputHtml .="                <td class=\"data_column_2_red\">" . $IdsDatabaseLastCheckUnixTime . "</td>\n";
               }
               $DatabaseOutputHtml .="                <td class=\"data_column_3\">&nbsp;</td>\n";
               $DatabaseOutputHtml .="                <td class=\"data_column_4\">&nbsp;</td>\n";
               $DatabaseOutputHtml .="                <td class=\"data_column_5\">&nbsp;</td>\n";
               $DatabaseOutputHtml .="              </tr>\n";
               $DatabaseOutputHtml .="              <tr>\n";
               $DatabaseOutputHtml .="                <td class=\"title_column_1\">&nbsp;</td>\n";
               if(empty($ActivationMessagesModificationNote)) {
                  $DatabaseOutputHtml .="                <td class=\"data_column_2_red\" colspan=\"4\">&nbsp;</td>\n";
               }
               else
               {
               $DatabaseOutputHtml .="                <td class=\"data_column_2_red\" colspan=\"4\">" . $HostIntrusionDetectionReadDatabaseMessagesArray[0] . "</td>\n";
               }
               $DatabaseOutputHtml .="              </tr>\n";
               $DatabaseOutputHtml .="              <tr>\n";
               $DatabaseOutputHtml .="                <td class=\"note_column_1\">" . trim($HostIntrusionDetectionGeneralSurveyTitlesArray[9]) . "</td>\n";
               $DatabaseOutputHtml .="                <td class=\"data_column_2\" colspan=\"4\" rowspan=\"2\">" . $HostIntrusionDetectionReadDatabaseMessagesArray[1] . "</td>\n";
               $DatabaseOutputHtml .="              </tr>\n";
               $DatabaseOutputHtml .="              <tr>\n";
               $DatabaseOutputHtml .="                <td class=\"title_column_1\">&nbsp;</td>\n";
               $DatabaseOutputHtml .="              </tr>\n";
               $DatabaseOutputHtml .="            </table>\n";
               $DatabaseOutputHtml .="        </tr>\n";
               $DatabaseOutputHtml .="        <tr>\n";
               $DatabaseOutputHtml .="          <td>&nbsp;</td>\n";
               $DatabaseOutputHtml .="        </tr>\n";
               $DatabaseOutputHtml .="        <tr>\n";
               $DatabaseOutputHtml .="          <td>\n";
               $DatabaseOutputHtml .="            <table class=\"table_result_b\">\n";
               $DatabaseOutputHtml .="              <tr>\n";
               $DatabaseOutputHtml .="                <th class=\"title_ids_column_1\">" . trim($HostIntrusionDetectionResultTableTitlesArray[0]) . "</th>\n";
               $DatabaseOutputHtml .="                <th class=\"title_ids_column_2\">" . trim($HostIntrusionDetectionResultTableTitlesArray[1]) . "</th>\n";
               $DatabaseOutputHtml .="                <th class=\"title_ids_column_3\">" . trim($HostIntrusionDetectionResultTableTitlesArray[2]) . "</th>\n";
               $DatabaseOutputHtml .="                <th class=\"title_ids_column_4\">" . trim($HostIntrusionDetectionResultTableTitlesArray[3]) . "</th>\n";
               $DatabaseOutputHtml .="                <th class=\"title_ids_column_5\">" . trim($HostIntrusionDetectionResultTableTitlesArray[4]) . "</th>\n";
               $DatabaseOutputHtml .="                <th class=\"title_ids_column_6\">" . trim($HostIntrusionDetectionResultTableTitlesArray[5]) . "</th>\n";
               $DatabaseOutputHtml .="                <th class=\"title_ids_column_7\">" . trim($HostIntrusionDetectionResultTableTitlesArray[6]) . "</th>\n";
               $DatabaseOutputHtml .="                <th class=\"title_ids_column_8\">" . trim($HostIntrusionDetectionResultTableTitlesArray[7]) . "</th>\n";
               $DatabaseOutputHtml .="                <th class=\"title_ids_column_9\">" . trim($HostIntrusionDetectionResultTableTitlesArray[8]) . "</th>\n";
               $DatabaseOutputHtml .="                <th class=\"title_ids_column_10\">" . trim($HostIntrusionDetectionResultTableTitlesArray[9]) . "</th>\n";
               $DatabaseOutputHtml .="                <th class=\"title_ids_column_11\">" . trim($HostIntrusionDetectionResultTableTitlesArray[10]) . "</th>\n";
               $DatabaseOutputHtml .="                <th class=\"title_ids_column_12\">" . trim($HostIntrusionDetectionResultTableTitlesArray[11]) . "</th>\n";
               $DatabaseOutputHtml .="                <th class=\"title_ids_column_13\">" . trim($HostIntrusionDetectionResultTableTitlesArray[12]) . "</th>\n";
               $DatabaseOutputHtml .="                <th class=\"title_ids_column_14\">" . trim($HostIntrusionDetectionResultTableTitlesArray[13]) . "</th>\n";
               $DatabaseOutputHtml .="                <th class=\"title_ids_column_15\">" . trim($HostIntrusionDetectionResultTableTitlesArray[14]) . "</th>\n";
               $DatabaseOutputHtml .="                <th class=\"title_ids_column_16\">" . trim($HostIntrusionDetectionResultTableTitlesArray[1]) . "</th>\n";
               $DatabaseOutputHtml .="                <th class=\"title_ids_column_17\">" . trim($HostIntrusionDetectionResultTableTitlesArray[15]) . "</th>\n";
               $DatabaseOutputHtml .="                <th class=\"title_ids_column_18\">" . trim($HostIntrusionDetectionResultTableTitlesArray[16]) . "</th>\n";
               $DatabaseOutputHtml .="                <th class=\"title_ids_column_19\">" . trim($HostIntrusionDetectionResultTableTitlesArray[17]) . "</th>\n";
               $DatabaseOutputHtml .="                <th class=\"title_ids_column_20\">" . trim($HostIntrusionDetectionResultTableTitlesArray[18]) . "</th>\n";
               $DatabaseOutputHtml .="                <th class=\"title_ids_column_21\">" . trim($HostIntrusionDetectionResultTableTitlesArray[19]) . "</th>\n";
               $DatabaseOutputHtml .="                <th class=\"title_ids_column_22\">" . trim($HostIntrusionDetectionResultTableTitlesArray[20]) . "</th>\n";
               $DatabaseOutputHtml .="                <th class=\"title_ids_column_23\">" . trim($HostIntrusionDetectionResultTableTitlesArray[21]) . "</th>\n";
               $DatabaseOutputHtml .="                <th class=\"title_ids_column_24\">" . trim($HostIntrusionDetectionResultTableTitlesArray[22]) . "</th>\n";
               $DatabaseOutputHtml .="                <th class=\"title_ids_column_25\">" . trim($HostIntrusionDetectionResultTableTitlesArray[23]) . "</th>\n";
               $DatabaseOutputHtml .="                <th class=\"title_ids_column_26\">" . trim($HostIntrusionDetectionResultTableTitlesArray[24]) . "</th>\n";
               $DatabaseOutputHtml .="                <th class=\"title_ids_column_27\">" . trim($HostIntrusionDetectionResultTableTitlesArray[26]) . "</th>\n";
               $DatabaseOutputHtml .="                <th class=\"title_ids_column_28\">" . trim($HostIntrusionDetectionResultTableTitlesArray[26]) . "</th>\n";
               $DatabaseOutputHtml .="              </tr>\n";
               unset($ReportDatabaseLineThreeArray);
               // IDS-Datenbank einlesen und ausgeben
               $CurrentIdsDatabaseArray = file($HostIntrusionDetectionCurrentDatabaseFilepath);
               $CurrentIdsDatabaseArrayCount = count($CurrentIdsDatabaseArray);
               $LineNumber=0;
               for($x=2; $x<$CurrentIdsDatabaseArrayCount; $x++) {
                  // Kerndaten der IDS-Datenbank beginnen mit der 3. Zeile
                  $IdsDatabaseLineCurrentArray = explode("|", $CurrentIdsDatabaseArray[$x]);
                  $IdsDatabaseLineCurrentArrayCount = count($IdsDatabaseLineCurrentArray);
                  if($IdsDatabaseLineCurrentArrayCount < $IdsDatabaseMaximalFieldCount) {
                     // Darstellungs-Reparatur eines beschaedigten Datensatzes
                     for($y=$IdsDatabaseLineCurrentArrayCount; $y<$IdsDatabaseMaximalFieldCount; $y++) {
                        $IdsDatabaseLineCurrentArray[]='';
                     }
                  }
                  $LineNumber++;
                  $IdsDatabaseCurrentDirectory = trim($IdsDatabaseLineCurrentArray[5]);
                  if($IdsDatabaseCurrentDirectory != "") {
                     $DatabaseOutputHtml .="              <tr>\n";
                     $DatabaseOutputHtml .="                <td class=\"directory_data_right\">" . $LineNumber . "</td>\n";
                     $DatabaseOutputHtml .="                <td class=\"directory_data_left\">" . $IdsDatabaseCurrentDirectory . "</td>\n";
                     $IdsDatabaseCurrentDirectoryLineExcluded = trim($IdsDatabaseLineCurrentArray[20]);
                     $DirectoryOwner1 = trim($IdsDatabaseLineCurrentArray[6]);
                     $DirectoryOwner2 = trim($IdsDatabaseLineCurrentArray[7]);
                     $DirectoryOwnerComparison = strcmp($DirectoryOwner1, $DirectoryOwner2);
                     if(!empty($DirectoryOwner1)) {
                        $DatabaseOutputHtml .="                <td class=\"directory_data_center\">" . $DirectoryOwner1 . "</td>\n";
                     } elseif(empty($DirectoryOwner1)) {
                        $DatabaseOutputHtml .="                <td class=\"directory_data_center_red\">-</td>\n";
                     }
                     else
                     {
                     // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
                     $DatabaseOutputHtml .="                <td class=\"directory_data_center_red\">" . $DirectoryOwner1 . "</td>\n";
                     }
                     if(!empty($DirectoryOwner2) && $DirectoryOwnerComparison == 0) {
                        if(!empty($IdsDatabaseCurrentDirectoryLineExcluded) && preg_match("/^[4]$/", $IdsDatabaseCurrentDirectoryLineExcluded)) {
                           $DatabaseOutputHtml .="                <td class=\"directory_data_center_red\">-</td>\n";
                        }
                        else
                        {
                        $DatabaseOutputHtml .="                <td class=\"directory_data_center\">" . $DirectoryOwner2 . "</td>\n";
                        }
                     } elseif(!empty($DirectoryOwner2) && $DirectoryOwnerComparison != 0) {
                        if(!empty($IdsDatabaseCurrentDirectoryLineExcluded) && preg_match("/^[4]$/", $IdsDatabaseCurrentDirectoryLineExcluded)) {
                           $DatabaseOutputHtml .="                <td class=\"directory_data_center_red\">-</td>\n";
                        }
                        else
                        {
                        $DatabaseOutputHtml .="                <td class=\"directory_data_center_red\">" . $DirectoryOwner2 . "</td>\n";
                        }
                     } elseif(empty($DirectoryOwner2)) {
                        $DatabaseOutputHtml .="                <td class=\"directory_data_center_red\">-</td>\n";
                     }
                     else
                     {
                     // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
                     $DatabaseOutputHtml .="                <td class=\"directory_data_center_red\">" . $DirectoryOwner2 . "</td>\n";
                     }
                     $DirectoryGroup1 = trim($IdsDatabaseLineCurrentArray[8]);
                     $DirectoryGroup2  = trim($IdsDatabaseLineCurrentArray[9]);
                     $DirectoryGroupComparison = strcmp($DirectoryGroup1, $DirectoryGroup2);
                     if(!empty($DirectoryGroup1)) {
                        $DatabaseOutputHtml .="                <td class=\"directory_data_center\">" . $DirectoryGroup1 . "</td>\n";
                     } elseif(empty($DirectoryGroup1)) {
                        $DatabaseOutputHtml .="                <td class=\"directory_data_center_red\">-</td>\n";
                     }
                     else
                     {
                     // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
                     $DatabaseOutputHtml .="                <td class=\"directory_data_center_red\">" . $DirectoryGroup1 . "</td>\n";
                     }
                     if(!empty($DirectoryGroup2) && $DirectoryGroupComparison == 0) {
                        if(!empty($IdsDatabaseCurrentDirectoryLineExcluded) && preg_match("/^[4]$/", $IdsDatabaseCurrentDirectoryLineExcluded)) {
                           $DatabaseOutputHtml .="                <td class=\"directory_data_center_red\">-</td>\n";
                        }
                        else
                        {
                        $DatabaseOutputHtml .="                <td class=\"directory_data_center\">" . $DirectoryGroup2 . "</td>\n";
                        }
                     } elseif(!empty($DirectoryGroup2) && $DirectoryGroupComparison != 0) {
                        if(!empty($IdsDatabaseCurrentDirectoryLineExcluded) && preg_match("/^[4]$/", $IdsDatabaseCurrentDirectoryLineExcluded)) {
                           $DatabaseOutputHtml .="                <td class=\"directory_data_center_red\">-</td>\n";
                        }
                        else
                        {
                        $DatabaseOutputHtml .="                <td class=\"directory_data_center_red\">" . $DirectoryGroup2 . "</td>\n";
                        }
                     } elseif(empty($DirectoryGroup2)) {
                        $DatabaseOutputHtml .="                <td class=\"directory_data_center_red\">-</td>\n";
                     }
                     else
                     {
                     // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
                     $DatabaseOutputHtml .="                <td class=\"directory_data_center_red\">" . $DirectoryGroup2 . "</td>\n";
                     }
                     $DirectoryAccessPermission1 = trim($IdsDatabaseLineCurrentArray[10]);
                     $DirectoryAccessPermission2 = trim($IdsDatabaseLineCurrentArray[11]);
                     $DirectoryAccessPermissionComparison = strcmp($DirectoryAccessPermission1, $DirectoryAccessPermission2);
                     if(!empty($DirectoryAccessPermission1)) {
                        $DatabaseOutputHtml .="                <td class=\"directory_data_center\">" . $DirectoryAccessPermission1 . "</td>\n";
                     } elseif(empty($DirectoryAccessPermission1)) {
                        $DatabaseOutputHtml .="                <td class=\"directory_data_center_red\">-</td>\n";
                     }
                     else
                     {
                     // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
                     $DatabaseOutputHtml .="                <td class=\"directory_data_center_red\">" . $DirectoryAccessPermission1 . "</td>\n";
                     }
                     if(!empty($DirectoryAccessPermission2) && $DirectoryAccessPermissionComparison == 0) {
                        if(!empty($IdsDatabaseCurrentDirectoryLineExcluded) && preg_match("/^[4]$/", $IdsDatabaseCurrentDirectoryLineExcluded)) {
                           $DatabaseOutputHtml .="                <td class=\"directory_data_center_red\">-</td>\n";
                        }
                        else
                        {
                        $DatabaseOutputHtml .="                <td class=\"directory_data_center\">" . $DirectoryAccessPermission2 . "</td>\n";
                        }
                     } elseif(!empty($DirectoryAccessPermission2) && $DirectoryAccessPermissionComparison != 0) {
                        if(!empty($IdsDatabaseCurrentDirectoryLineExcluded) && preg_match("/^[4]$/", $IdsDatabaseCurrentDirectoryLineExcluded)) {
                           $DatabaseOutputHtml .="                <td class=\"directory_data_center_red\">-</td>\n";
                        }
                        else
                        {
                        $DatabaseOutputHtml .="                <td class=\"directory_data_center_red\">" . $DirectoryAccessPermission2 . "</td>\n";
                        }
                     } elseif(empty($DirectoryAccessPermission2)) {
                        $DatabaseOutputHtml .="                <td class=\"directory_data_center_red\">-</td>\n";
                     }
                     else
                     {
                     // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
                     $DatabaseOutputHtml .="                <td class=\"directory_data_center_red\">" . $DirectoryAccessPermission2 . "</td>\n";
                     }
                     $IdsDatabaseCreateUnixTime = trim($IdsDatabaseLineCurrentArray[12]);
                     $IdsDatabaseLastCheckUnixTime = trim($IdsDatabaseLineCurrentArray[13]);
                     $DirectoryUnixTimeComparison = strcmp($IdsDatabaseCreateUnixTime, $IdsDatabaseLastCheckUnixTime);
                     if(!empty($IdsDatabaseCreateUnixTime) && preg_match("/^[0-9]{1,}$/", $IdsDatabaseCreateUnixTime)) {
                        $IdsDatabaseCreateDateTime = date("Y-m-d H:i:s", $IdsDatabaseCreateUnixTime);
                        $DatabaseOutputHtml .="                <td class=\"directory_data_left\">" . $IdsDatabaseCreateDateTime . "</td>\n";
                     } elseif(empty($IdsDatabaseCreateUnixTime)) {
                        $DatabaseOutputHtml .="                <td class=\"directory_data_center_red\">-</td>\n";
                     }
                     else
                     { 
                     // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
                     $DatabaseOutputHtml .="                <td class=\"directory_data_center_red\">" . $IdsDatabaseCreateUnixTime . "</td>\n";
                     }
                     if(!empty($IdsDatabaseLastCheckUnixTime) &&
                        $DirectoryUnixTimeComparison == 0 &&
                        preg_match("/^[0-9]{1,}$/", $IdsDatabaseLastCheckUnixTime)) {
                        if(!empty($IdsDatabaseCurrentDirectoryLineExcluded) && preg_match("/^[4]$/", $IdsDatabaseCurrentDirectoryLineExcluded)) {
                           $DatabaseOutputHtml .="                <td class=\"directory_data_center_red\">-</td>\n";
                        }
                        else
                        {
                           $IdsDatabaseLastCheckDateTime = date("Y-m-d H:i:s", $IdsDatabaseLastCheckUnixTime);
                           $DatabaseOutputHtml .="                <td class=\"directory_data_left\">" . $IdsDatabaseLastCheckDateTime . "</td>\n";
                        }
                     } elseif(!empty($IdsDatabaseLastCheckUnixTime) &&
                        $DirectoryUnixTimeComparison != 0 &&
                        preg_match("/^[0-9]{1,}$/", $IdsDatabaseLastCheckUnixTime)) {
                        if(!empty($IdsDatabaseCurrentDirectoryLineExcluded) && preg_match("/^[4]$/", $IdsDatabaseCurrentDirectoryLineExcluded)) {
                           $DatabaseOutputHtml .="                <td class=\"directory_data_center_red\">-</td>\n";
                        }
                        else
                        {
                           $IdsDatabaseLastCheckDateTime = date("Y-m-d H:i:s", $IdsDatabaseLastCheckUnixTime);
                           $DatabaseOutputHtml .="                <td class=\"directory_data_left_red\">" . $IdsDatabaseLastCheckDateTime . "</td>\n";
                        }
                     } elseif(empty($IdsDatabaseLastCheckUnixTime)) {
                        $DatabaseOutputHtml .="                <td class=\"directory_data_center_red\">-</td>\n";
                     }
                     else
                     {
                     // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
                     $DatabaseOutputHtml .="                <td class=\"directory_data_center_red\">" . $IdsDatabaseLastCheckUnixTime . "</td>\n";
                     }
                     $DirectoryNumber1 = trim($IdsDatabaseLineCurrentArray[14]);
                     $DirectoryNumber2 = trim($IdsDatabaseLineCurrentArray[15]);
                     $DirectoryNumberComparison = strcmp($DirectoryNumber1, $DirectoryNumber2);
                     if(!empty($DirectoryNumber1) && preg_match("/^[0-9]{1,}$/", $DirectoryNumber1)) {
                        $DatabaseOutputHtml .="                <td class=\"directory_data_right\">" . $DirectoryNumber1 . "</td>\n";
                     } elseif(empty($DirectoryNumber1)) {
                        $DatabaseOutputHtml .="                <td class=\"directory_data_right\">-</td>\n";
                     }
                     else
                     {
                     // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
                     $DatabaseOutputHtml .="                <td class=\"directory_data_right_red\">" . $DirectoryNumber1 . "</td>\n";
                     }
                     if(!empty($DirectoryNumber2) &&
                        $DirectoryNumberComparison == 0 &&
                        preg_match("/^[0-9]{1,}$/", $DirectoryNumber2)) {
                        $DatabaseOutputHtml .="                <td class=\"directory_data_right\">" . $DirectoryNumber2 . "</td>\n";
                     } elseif(empty($DirectoryNumber2) &&
                        $DirectoryNumberComparison == 0 &&
                        preg_match("/^[0-9]{1,}$/", $DirectoryNumber2)) {
                        $DatabaseOutputHtml .="                <td class=\"directory_data_right\">-</td>\n";
                     } elseif(!empty($DirectoryNumber2) &&
                        $DirectoryNumberComparison != 0 &&
                        preg_match("/^[0-9]{1,}$/", $DirectoryNumber2) &&
                        !empty($IdsDatabaseCurrentDirectoryLineExcluded) &&
                        preg_match("/^[4]$/", $IdsDatabaseCurrentDirectoryLineExcluded)) {
                        $DatabaseOutputHtml .="                <td class=\"directory_data_right\">" . $DirectoryNumber2 . "</td>\n";
                     } elseif(empty($DirectoryNumber2) && $DirectoryNumberComparison != 0) {
                        $DatabaseOutputHtml .="                <td class=\"directory_data_right_red\">-</td>\n";
                     }
                     else
                     {
                     // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
                     $DatabaseOutputHtml .="                <td class=\"directory_data_right_red\">" . $DirectoryNumber2 . "</td>\n";
                     }
                     $FileNumber1 = trim($IdsDatabaseLineCurrentArray[16]);
                     $FileNumber2 = trim($IdsDatabaseLineCurrentArray[17]);
                     $FileNumberComparison = strcmp($FileNumber1, $FileNumber2);
                     if(!empty($FileNumber1) && preg_match("/^[0-9]{1,}$/", $FileNumber1)) {
                        $DatabaseOutputHtml .="                <td class=\"directory_data_right\">" . $FileNumber1 . "</td>\n";
                     } elseif(empty($FileNumber1)) {
                        $DatabaseOutputHtml .="                <td class=\"directory_data_right\">-</td>\n";
                     }
                     else
                     {
                     // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
                     $DatabaseOutputHtml .="                <td class=\"directory_data_right_red\">" . $FileNumber1 . "</td>\n";
                     }
                     if(!empty($FileNumber2) &&
                        $FileNumberComparison == 0 &&
                        preg_match("/^[0-9]{1,}$/", $FileNumber2)) {
                        $DatabaseOutputHtml .="                <td class=\"directory_data_right\">" . $FileNumber2 . "</td>\n";
                     } elseif(empty($FileNumber2) &&
                       $FileNumberComparison == 0 &&
                        preg_match("/^[0-9]{1,}$/", $FileNumber2)) {
                        $DatabaseOutputHtml .="                <td class=\"directory_data_right\">-</td>\n";
                     } elseif(!empty($FileNumber2) &&
                        $FileNumberComparison != 0 &&
                        preg_match("/^[0-9]{1,}$/", $FileNumber2) &&
                        !empty($IdsDatabaseCurrentDirectoryLineExcluded) &&
                        preg_match("/^[4]$/", $IdsDatabaseCurrentDirectoryLineExcluded)) {
                        $DatabaseOutputHtml .="                <td class=\"directory_data_right\">" . $FileNumber2 . "</td>\n";
                     } elseif(empty($FileNumber2) && $FileNumberComparison != 0) {
                        $DatabaseOutputHtml .="                <td class=\"directory_data_right_red\">-</td>\n";
                     }
                     else
                     {
                     // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
                     $DatabaseOutputHtml .="                <td class=\"directory_data_right_red\">" . $FileNumber2 . "</td>\n";
                     }
                     $IdsDatabaseMd5StatusNoteArrayElement = trim($IdsDatabaseLineCurrentArray[20]);
                     if(preg_match("/^[0-4]$/", $IdsDatabaseMd5StatusNoteArrayElement)) {
                        $IdsDatabaseMd5StatusNoteTableEntry = $HostIntrusionDetectionMd5StatusNoteArray[$IdsDatabaseMd5StatusNoteArrayElement];
                     }
                     else
                     {
                     // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
                     $IdsDatabaseMd5StatusNoteTableEntry = $IdsDatabaseMd5StatusNoteArrayElement;
                     }
                     if(preg_match("/^[1]$/", $IdsDatabaseMd5StatusNoteArrayElement)) {
                        $DatabaseOutputHtml .="                <td class=\"directory_data_center\">" . $IdsDatabaseMd5StatusNoteTableEntry . "</td>\n";
                     }
                     else
                     {
                     $DatabaseOutputHtml .="                <td class=\"directory_data_center_red\">" . $IdsDatabaseMd5StatusNoteTableEntry . "</td>\n";
                     }
                     $DatabaseOutputHtml .="                <td class=\"directory_data_left\" colspan=\"2\">" . $IdsDatabaseCurrentDirectory . "/</td>\n";
                     $DatabaseOutputHtml .="                <td class=\"directory_data_center\">" . trim($IdsDatabaseLineCurrentArray[22]) . "</td>\n";
                     $DatabaseOutputHtml .="                <td class=\"directory_data_center\">" . trim($IdsDatabaseLineCurrentArray[23]) . "</td>\n";
                     $DatabaseOutputHtml .="                <td class=\"directory_data_center\">" . trim($IdsDatabaseLineCurrentArray[24]) . "</td>\n";
                     $DatabaseOutputHtml .="                <td class=\"directory_data_center\">" . trim($IdsDatabaseLineCurrentArray[25]) . "</td>\n";
                     $DatabaseOutputHtml .="                <td class=\"directory_data_center\">" . trim($IdsDatabaseLineCurrentArray[26]) . "</td>\n";
                     $DatabaseOutputHtml .="                <td class=\"directory_data_center\">" . trim($IdsDatabaseLineCurrentArray[27]) . "</td>\n";
                     $DatabaseOutputHtml .="                <td class=\"directory_data_left\">" . trim($IdsDatabaseLineCurrentArray[28]) . "</td>\n";
                     $DatabaseOutputHtml .="                <td class=\"directory_data_left\">" . trim($IdsDatabaseLineCurrentArray[29]) . "</td>\n";
                     $DatabaseOutputHtml .="                <td class=\"directory_data_left\">" . trim($IdsDatabaseLineCurrentArray[30]) . "</td>\n";
                     $DatabaseOutputHtml .="                <td class=\"directory_data_left\">" . trim($IdsDatabaseLineCurrentArray[31]) . "</td>\n";
                     $DatabaseOutputHtml .="                <td class=\"directory_data_center\">" . trim($IdsDatabaseLineCurrentArray[34]) . "</td>\n";
                     $DatabaseOutputHtml .="              </tr>\n";
                  }
                  else
                  {
                     $DatabaseOutputHtml .="              <tr>\n";
                     $DatabaseOutputHtml .="                <td class=\"data_ids_right\">" . $LineNumber . "</td>\n";
                     $DatabaseOutputHtml .="                <td class=\"data_ids_left\">" . trim($IdsDatabaseLineCurrentArray[5]) . "</td>\n";
                     $DatabaseOutputHtml .="                <td class=\"data_ids_left\">" . trim($IdsDatabaseLineCurrentArray[6]) . "</td>\n";
                     $DatabaseOutputHtml .="                <td class=\"data_ids_left\">" . trim($IdsDatabaseLineCurrentArray[7]) . "</td>\n";
                     $DatabaseOutputHtml .="                <td class=\"data_ids_left\">" . trim($IdsDatabaseLineCurrentArray[8]) . "</td>\n";
                     $DatabaseOutputHtml .="                <td class=\"data_ids_left\">" . trim($IdsDatabaseLineCurrentArray[9]) . "</td>\n";
                     $DatabaseOutputHtml .="                <td class=\"data_ids_left\">" . trim($IdsDatabaseLineCurrentArray[10]) . "</td>\n";
                     $DatabaseOutputHtml .="                <td class=\"data_ids_left\">" . trim($IdsDatabaseLineCurrentArray[11]) . "</td>\n";
                     $DatabaseOutputHtml .="                <td class=\"data_ids_left\">" . trim($IdsDatabaseLineCurrentArray[12]) . "</td>\n";
                     $DatabaseOutputHtml .="                <td class=\"data_ids_left\">" . trim($IdsDatabaseLineCurrentArray[13]) . "</td>\n";
                     $DatabaseOutputHtml .="                <td class=\"data_ids_left\">" . trim($IdsDatabaseLineCurrentArray[14]) . "</td>\n";
                     $DatabaseOutputHtml .="                <td class=\"data_ids_left\">" . trim($IdsDatabaseLineCurrentArray[15]) . "</td>\n";
                     $DatabaseOutputHtml .="                <td class=\"data_ids_left\">" . trim($IdsDatabaseLineCurrentArray[16]) . "</td>\n";
                     $DatabaseOutputHtml .="                <td class=\"data_ids_left\">" . trim($IdsDatabaseLineCurrentArray[17]) . "</td>\n";
                     $DatabaseOutputHtml .="                <td class=\"data_ids_left\">" . trim($IdsDatabaseLineCurrentArray[20]) . "</td>\n";
                     $DatabaseOutputHtml .="                <td class=\"data_ids_left\">&nbsp;</td>\n";
                     $CurrentFilePathArray = explode("/", $IdsDatabaseLineCurrentArray[21]);
                     $CurrentFileName = end($CurrentFilePathArray);
                     $DatabaseOutputHtml .="                <td class=\"data_ids_left\">" . trim($CurrentFileName) . "</td>\n";
                     $IdsDatabaseCurrentFileLineExcluded = trim($IdsDatabaseLineCurrentArray[34]);
                     $FileOwner1 = trim($IdsDatabaseLineCurrentArray[22]);
                     $FileOwner2 = trim($IdsDatabaseLineCurrentArray[23]);
                     $FileOwnerComparison = strcmp($FileOwner1, $FileOwner2);
                     if(!empty($FileOwner1)) {
                        $DatabaseOutputHtml .="                <td class=\"data_ids_center\">" . $FileOwner1 . "</td>\n";
                     } elseif(empty($FileOwner1)) {
                        $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">-</td>\n";
                     }
                     else
                     {
                     // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
                     $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">" . $FileOwner1 . "</td>\n";
                     }
                     if(!empty($FileOwner2) && $FileOwnerComparison == 0) {
                        if(!empty($IdsDatabaseCurrentFileLineExcluded) && preg_match("/^[4]$/", $IdsDatabaseCurrentFileLineExcluded)) {
                           $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">-</td>\n";
                        }
                        else
                        {
                        $DatabaseOutputHtml .="                <td class=\"data_ids_center\">" . $FileOwner2 . "</td>\n";
                        }
                     } elseif(!empty($FileOwner2) && $FileOwnerComparison != 0) {
                        if(!empty($IdsDatabaseCurrentFileLineExcluded) && preg_match("/^[4]$/", $IdsDatabaseCurrentFileLineExcluded)) {
                           $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">-</td>\n";
                        }
                        else
                        {
                        $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">" . $FileOwner2 . "</td>\n";
                        }
                     } elseif(empty($FileOwner2)) {
                        $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">-</td>\n";
                     }
                     else
                     {
                     // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
                     $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">" . $FileOwner2 . "</td>\n";
                     }
                     $FileGroup1 = trim($IdsDatabaseLineCurrentArray[24]);
                     $FileGroup2 = trim($IdsDatabaseLineCurrentArray[25]);
                     $FileGroupComparison = strcmp($FileGroup1, $FileGroup2);
                     if(!empty($FileGroup1)) {
                        $DatabaseOutputHtml .="                <td class=\"data_ids_center\">" . $FileGroup1 . "</td>\n";
                     } elseif(empty($FileGroup1)) {
                        $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">-</td>\n";
                     }
                     else
                     {
                     // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
                     $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">" . $FileGroup1 . "</td>\n";
                     }
                     if(!empty($FileGroup2) && $FileGroupComparison == 0) {
                        if(!empty($IdsDatabaseCurrentFileLineExcluded) && preg_match("/^[4]$/", $IdsDatabaseCurrentFileLineExcluded)) {
                           $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">-</td>\n";
                        }
                        else
                        {
                        $DatabaseOutputHtml .="                <td class=\"data_ids_center\">" . $FileGroup2 . "</td>\n";
                        }
                     } elseif(!empty($FileGroup2) && $FileGroupComparison != 0) {
                        if(!empty($IdsDatabaseCurrentFileLineExcluded) && preg_match("/^[4]$/", $IdsDatabaseCurrentFileLineExcluded)) {
                           $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">-</td>\n";
                        }
                        else
                        {
                        $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">" . $FileGroup2 . "</td>\n";
                        }
                     } elseif(empty($FileGroup2)) {
                        $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">-</td>\n";
                     }
                     else
                     {
                     // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
                     $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">" . $FileGroup2 . "</td>\n";
                     }
                     $FileAccessPermission1 = trim($IdsDatabaseLineCurrentArray[26]);
                     $FileAccessPermission2 = trim($IdsDatabaseLineCurrentArray[27]);
                     $FileAccessPermissionComparison = strcmp($FileAccessPermission1, $FileAccessPermission2);
                     if(!empty($FileAccessPermission1)) {
                        $DatabaseOutputHtml .="                <td class=\"data_ids_center\">" . $FileAccessPermission1 . "</td>\n";
                     } elseif(empty($FileAccessPermission1)) {
                        $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">-</td>\n";
                     }
                     else
                     {
                     // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
                     $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">" . $FileAccessPermission1 . "</td>\n";
                     }
                     if(!empty($FileAccessPermission2) && $FileAccessPermissionComparison == 0) {
                        if(!empty($IdsDatabaseCurrentFileLineExcluded) && preg_match("/^[4]$/", $IdsDatabaseCurrentFileLineExcluded)) {
                           $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">-</td>\n";
                        }
                        else
                        {
                        $DatabaseOutputHtml .="                <td class=\"data_ids_center\">" . $FileAccessPermission2 . "</td>\n";
                        }
                     } elseif(!empty($FileAccessPermission2) && $FileAccessPermissionComparison != 0) {
                        if(!empty($IdsDatabaseCurrentFileLineExcluded) && preg_match("/^[4]$/", $IdsDatabaseCurrentFileLineExcluded)) {
                           $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">-</td>\n";
                        }
                        else
                        {
                        $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">" . $FileAccessPermission2 . "</td>\n";
                        }
                     } elseif(empty($FileAccessPermission2)) {
                        $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">-</td>\n";
                     }
                     else
                     {
                     // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
                     $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">" . $FileAccessPermission2 . "</td>\n";
                     }
                     $IdsDatabaseFirstModificationUnixTime = trim($IdsDatabaseLineCurrentArray[28]);
                     $IdsDatabaseLastCheckModificationUnixTime = trim($IdsDatabaseLineCurrentArray[29]);
                     $FileUnixTimeComparison = strcmp($IdsDatabaseFirstModificationUnixTime, $IdsDatabaseLastCheckModificationUnixTime);
                     if(!empty($IdsDatabaseFirstModificationUnixTime) && preg_match("/^[0-9]{1,}$/", $IdsDatabaseFirstModificationUnixTime)) {
                        $IdsDatabaseFirstModificationDateTime = date("Y-m-d H:i:s", $IdsDatabaseFirstModificationUnixTime);
                        $DatabaseOutputHtml .="                <td class=\"data_ids_left\">" . $IdsDatabaseFirstModificationDateTime . "</td>\n";
                     } elseif(empty($IdsDatabaseFirstModificationUnixTime)) {
                        $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">-</td>\n";
                     }
                     else
                     {
                     // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
                     $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">" . $IdsDatabaseFirstModificationUnixTime . "</td>\n";
                     }
                     if(!empty($IdsDatabaseLastCheckModificationUnixTime) &&
                        $FileUnixTimeComparison == 0 &&
                        preg_match("/^[0-9]{1,}$/", $IdsDatabaseLastCheckModificationUnixTime)) {
                        if(!empty($IdsDatabaseCurrentFileLineExcluded) && preg_match("/^[4]$/", $IdsDatabaseCurrentFileLineExcluded)) {
                           $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">-</td>\n";
                        }
                        else
                        {
                           $IdsDatabaseLastCheckModificationDateTime = date("Y-m-d H:i:s", $IdsDatabaseLastCheckModificationUnixTime);
                           $DatabaseOutputHtml .="                <td class=\"data_ids_left\">" . $IdsDatabaseLastCheckModificationDateTime . "</td>\n";
                        }
                     } elseif(!empty($IdsDatabaseLastCheckModificationUnixTime) &&
                        $FileUnixTimeComparison != 0 &&
                        preg_match("/^[0-9]{1,}$/", $IdsDatabaseLastCheckModificationUnixTime)) {
                        if(!empty($IdsDatabaseCurrentFileLineExcluded) && preg_match("/^[4]$/", $IdsDatabaseCurrentFileLineExcluded)) {
                           $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">-</td>\n";
                        }
                        else
                        {
                           $IdsDatabaseLastCheckModificationDateTime = date("Y-m-d H:i:s", $IdsDatabaseLastCheckModificationUnixTime);
                           $DatabaseOutputHtml .="                <td class=\"data_ids_left_red\">" . $IdsDatabaseLastCheckModificationDateTime . "</td>\n";
                        }
                     } elseif(empty($IdsDatabaseLastCheckModificationUnixTime)) {
                        $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">-</td>\n";
                     }
                     else
                     {
                     // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
                     $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">" . $IdsDatabaseLastCheckModificationUnixTime . "</td>\n";
                     }
                     $IdsDatabaseFileSizeByte1 = trim($IdsDatabaseLineCurrentArray[30]);
                     if(isset($IdsDatabaseFileSizeByte1) &&
                        $IdsDatabaseFileSizeByte1 != "" &&
                        preg_match("/^[0-9]{1,}$/", $IdsDatabaseFileSizeByte1)) {
                        if($IdsDatabaseFileSizeByte1 > $GigaByte) {
                           $FileSizeValue1 = $IdsDatabaseFileSizeByte1 / $GigaByte;
                           $FileSizeTableEntry1 = round($FileSizeValue1, 3) . " " . $HostIntrusionDetectionReadDatabaseDetailsArray[0];
                        } elseif($IdsDatabaseFileSizeByte1 > $MegaByte) {
                           $FileSizeValue1 = $IdsDatabaseFileSizeByte1 / $MegaByte;
                           $FileSizeTableEntry1 = round($FileSizeValue1, 3) . " " . $HostIntrusionDetectionReadDatabaseDetailsArray[1];
                        } elseif($IdsDatabaseFileSizeByte1 > $KiloByte) {
                           $FileSizeValue1 = $IdsDatabaseFileSizeByte1 / $KiloByte;
                           $FileSizeTableEntry1 = round($FileSizeValue1, 3) . " " . $HostIntrusionDetectionReadDatabaseDetailsArray[2];
                        }
                        else
                        {
                        $FileSizeTableEntry1 = $IdsDatabaseFileSizeByte1 . " " . $HostIntrusionDetectionReadDatabaseDetailsArray[3];
                        }
                        $DatabaseOutputHtml .="                <td class=\"data_ids_right\">" . $FileSizeTableEntry1 . "</td>\n";
                     } elseif(empty($IdsDatabaseFileSizeByte1)) {
                        $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">-</td>\n";
                     }
                     else
                     {
                     // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
                     $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">" . $IdsDatabaseFileSizeByte1 . "</td>\n";
                     }
                     $IdsDatabaseFileSizeByte2 = trim($IdsDatabaseLineCurrentArray[31]);
                     if(isset($IdsDatabaseFileSizeByte2) && preg_match("/^[0-9]{1,}$/", $IdsDatabaseFileSizeByte2)) {
                        if($IdsDatabaseFileSizeByte2 > $GigaByte) {
                           $FileSizeValue2 = $IdsDatabaseFileSizeByte2 / $GigaByte;
                           $FileSizeTableEntry2 = round($FileSizeValue2, 3) . " " . $HostIntrusionDetectionReadDatabaseDetailsArray[0];
                        } elseif($IdsDatabaseFileSizeByte2 > $MegaByte) {
                           $FileSizeValue2 = $IdsDatabaseFileSizeByte2 / $MegaByte;
                           $FileSizeTableEntry2 = round($FileSizeValue2, 3) . " " . $HostIntrusionDetectionReadDatabaseDetailsArray[1];
                        } elseif($IdsDatabaseFileSizeByte2 > $KiloByte) {
                           $FileSizeValue2 = $IdsDatabaseFileSizeByte2 / $KiloByte;
                           $FileSizeTableEntry2 = round($FileSizeValue2, 3) . " " . $HostIntrusionDetectionReadDatabaseDetailsArray[2];
                        }
                        else
                        {
                        $FileSizeTableEntry2 = $IdsDatabaseFileSizeByte2 . " " . $HostIntrusionDetectionReadDatabaseDetailsArray[3];
                        }
                     } elseif(empty($IdsDatabaseFileSizeByte2)) {
                        $FileSizeTableEntry2="-";
                     }
                     else
                     {
                     // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
                     $FileSizeTableEntry2 = $IdsDatabaseFileSizeByte2;
                     }
                     $FileSizeComparison = strcmp($IdsDatabaseFileSizeByte1, $IdsDatabaseFileSizeByte2);
                     if(isset($IdsDatabaseFileSizeByte2) &&
                        $IdsDatabaseFileSizeByte2 != "" &&
                        $FileSizeComparison == 0 &&
                        preg_match("/^[0-9]{1,}$/", $IdsDatabaseFileSizeByte2)) {
                        if(!empty($IdsDatabaseCurrentFileLineExcluded) && preg_match("/^[4]$/", $IdsDatabaseCurrentFileLineExcluded)) {
                           $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">-</td>\n";
                        }
                        else
                        {
                        $DatabaseOutputHtml .="                <td class=\"data_ids_right\">" . $FileSizeTableEntry2 . "</td>\n";
                        }
                     } elseif(isset($IdsDatabaseFileSizeByte2) &&
                        $IdsDatabaseFileSizeByte2 != "" &&
                        $FileSizeComparison != 0 &&
                        preg_match("/^[0-9]{1,}$/", $IdsDatabaseFileSizeByte2)) {
                        if(!empty($IdsDatabaseCurrentFileLineExcluded) && preg_match("/^[4]$/", $IdsDatabaseCurrentFileLineExcluded)) {
                           $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">-</td>\n";
                        }
                        else
                        {
                        $DatabaseOutputHtml .="                <td class=\"data_ids_right_red\">" . $FileSizeTableEntry2 . "</td>\n";
                        }
                     }
                     else
                     {
                     $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">" . $FileSizeTableEntry2 . "</td>\n";
                     }
                     $IdsDatabaseMd5StatusNoteArrayElement = trim($IdsDatabaseLineCurrentArray[34]);
                     if(preg_match("/^[0-4]$/", $IdsDatabaseMd5StatusNoteArrayElement)) {
                        $IdsDatabaseMd5StatusNoteTableEntry = $HostIntrusionDetectionMd5StatusNoteArray[$IdsDatabaseMd5StatusNoteArrayElement];
                     }
                     else
                     {
                     // im Fehlerfall werden die fehlerbehafteten Rohdaten aus der Datenbank durchgereicht
                     $IdsDatabaseMd5StatusNoteTableEntry = $IdsDatabaseMd5StatusNoteArrayElement;
                     }
                     if(preg_match("/^[1]$/", $IdsDatabaseMd5StatusNoteArrayElement)) {
                        $DatabaseOutputHtml .="                <td class=\"data_ids_center\">" . $IdsDatabaseMd5StatusNoteTableEntry . "</td>\n";
                     }
                     else
                     {
                     $DatabaseOutputHtml .="                <td class=\"data_ids_center_red\">" . $IdsDatabaseMd5StatusNoteTableEntry . "</td>\n";
                     }
                     $DatabaseOutputHtml .="              </tr>\n";
                  }
                  unset($IdsDatabaseLineCurrentArray);
               }
               $DatabaseOutputHtml .="              <tr>\n";
               $HostIntrusionDetectionResultTableTitlesArrayCount = count($HostIntrusionDetectionResultTableTitlesArray) + 1;
               if(isset($CurrentIdsDatabaseArrayCount) && $CurrentIdsDatabaseArrayCount < 3) {
                  $DatabaseOutputHtml .="                <td class=\"data_ids_left_red\" colspan=\"" . $HostIntrusionDetectionResultTableTitlesArrayCount . "\">" . $HostIntrusionDetectionReadDatabaseMessagesArray[2] . "</td>\n";
               }
               else
               {
                  for($z=0; $z<$HostIntrusionDetectionResultTableTitlesArrayCount; $z++) {
                     $DatabaseOutputHtml .="                <td class=\"data_ids_left\">&nbsp;</td>\n";
                  }
               }
               $DatabaseOutputHtml .="              </tr>\n";
               $DatabaseOutputHtml .="              <tr>\n";
               $DatabaseOutputHtml .="                <td class=\"footer_ids\" colspan=\"" . $HostIntrusionDetectionResultTableTitlesArrayCount . "\">&nbsp;</td>\n";
               $DatabaseOutputHtml .="              </tr>\n";
               $DatabaseOutputHtml .="            </table>\n";
               $DatabaseOutputHtml .="          <td>\n";
               $DatabaseOutputHtml .="        </tr>\n";
               $DatabaseOutputHtml .="      </table>\n";
               $DatabaseOutputHtml .="    </result>\n";
               if(empty($ReturnCode)) $ReturnCode=1;
            }
         } elseif(file_exists($HostIntrusionDetectionCurrentDatabaseFilepath) && !is_readable($HostIntrusionDetectionCurrentDatabaseFilepath)) {
            $ReturnCode=5;
         } elseif(file_exists($HostIntrusionDetectionCurrentReportDatabaseFilepath) && !is_readable($HostIntrusionDetectionCurrentReportDatabaseFilepath)) {
            $ReportReturnCode=4;
         }
         else
         {
         $ReturnCode=2;
         }
         $ReturnCodeDatabaseOutputArray[] = $ReportReturnCode;
         $ReturnCodeDatabaseOutputArray[] = $ReturnCode;
         $ReturnCodeDatabaseOutputArray[] = $DatabaseOutputHtml;
         return $ReturnCodeDatabaseOutputArray;
      } elseif(!isset($HostIntrusionDetectionArray) ||
         !is_array($HostIntrusionDetectionArray) ||
         $HostIntrusionDetectionArrayDefaultCount != $HostIntrusionDetectionArrayCurrentCount) {
         print 'NOTE: SYSTEM-ARRAY HostIntrusionDetectionArray (ARRAY-COUNT) - function <strong>host_intrusion_detection_read_database</strong> - IS DAMAGED!';
         exit;
      } elseif(!isset($HostIntrusionDetectionGeneralSurveyTitlesArray) ||
         !is_array($HostIntrusionDetectionGeneralSurveyTitlesArray) ||
         $HostIntrusionDetectionGeneralSurveyTitlesArrayDefaultCount != $HostIntrusionDetectionGeneralSurveyTitlesArrayCurrentCount) {
         print 'NOTE: SYSTEM-ARRAY HostIntrusionDetectionGeneralSurveyTitlesArray (ARRAY-COUNT) - function <strong>host_intrusion_detection_read_database</strong> - IS DAMAGED!';
         exit;
      } elseif(!isset($HostIntrusionDetectionResultTableTitlesArray) ||
         !is_array($HostIntrusionDetectionResultTableTitlesArray) ||
         $HostIntrusionDetectionResultTableTitlesArrayDefaultCount != $HostIntrusionDetectionResultTableTitlesArrayCurrentCount) {
         print 'NOTE: SYSTEM-ARRAY HostIntrusionDetectionResultTableTitlesArray (ARRAY-COUNT) - function <strong>host_intrusion_detection_read_database</strong> - IS DAMAGED!';
         exit;
      } elseif(!isset($HostIntrusionDetectionMd5StatusNoteArray) ||
         !is_array($HostIntrusionDetectionMd5StatusNoteArray) ||
         $HostIntrusionDetectionMd5StatusNoteArrayDefaultCount != $HostIntrusionDetectionMd5StatusNoteArrayCurrentCount) {
         print 'NOTE: SYSTEM-ARRAY HostIntrusionDetectionMd5StatusNoteArray (ARRAY-COUNT) - function <strong>host_intrusion_detection_read_database</strong> - IS DAMAGED!';
         exit;
      } elseif(!isset($HostIntrusionDetectionReadDatabaseDetailsArray) ||
         !is_array($HostIntrusionDetectionReadDatabaseDetailsArray) ||
         $HostIntrusionDetectionReadDatabaseMessagesArrayDefaultCount != $HostIntrusionDetectionReadDatabaseMessagesArrayCurrentCount) {
         print 'NOTE: SYSTEM-ARRAY HostIntrusionDetectionReadDatabaseDetailsArray (ARRAY-COUNT) - function <strong>host_intrusion_detection_read_database</strong> - IS DAMAGED!';
         exit;
      }
      else
      {
         print 'NOTE: SYSTEM-ARRAY HostIntrusionDetectionReadDatabaseMessagesArray (ARRAY-COUNT) - function <strong>host_intrusion_detection_read_database</strong> - IS DAMAGED!';
         exit;
      }
   }

   $IdsDatabaseInputRadioChecked='';
   $DirectoryFileExistsCheckbox='';
   $ObelixFileNameArrayDefaultCount=15; // Vorgabe: Anzahl der Array-Elemente
   $ObelixFileNameArrayCurrentCount=count($ObelixFileNameArray);
   $HostIntrusionDetectionArrayDefaultCount=11; // Vorgabe: Anzahl der Array-Elemente
   $HostIntrusionDetectionArrayCurrentCount=count($HostIntrusionDetectionArray);
   $HostIntrusionDetectionDetailsArrayDefaultCount=30; // Vorgabe: Anzahl der Array-Elemente
   $HostIntrusionDetectionDetailsArrayCurrentCount=count($HostIntrusionDetectionDetailsArray);
   $HostIntrusionDetectionMessagesArrayDefaultCount=27; // Vorgabe: Anzahl der Array-Elemente
   $HostIntrusionDetectionMessagesArrayCurrentCount=count($HostIntrusionDetectionMessagesArray);
   $HostIntrusionDetectionCreateDatabaseReturncodeMessagesArrayDefaultCount=3; // Vorgabe: Anzahl der Array-Elemente
   $HostIntrusionDetectionCreateDatabaseReturncodeMessagesArrayCurrentCount=count($HostIntrusionDetectionCreateDatabaseReturncodeMessagesArray);
   $HostIntrusionDetectionConfigurationDatabaseReturncodeMessagesArrayDefaultCount=5; // Vorgabe: Anzahl der Array-Elemente
   $HostIntrusionDetectionConfigurationDatabaseReturncodeMessagesArrayCurrentCount=count($HostIntrusionDetectionConfigurationDatabaseReturncodeMessagesArray);
   $HostIntrusionDetectionReportDatabaseReturncodeMessagesArrayDefaultCount=5; // Vorgabe: Anzahl der Array-Elemente
   $HostIntrusionDetectionReportDatabaseReturncodeMessagesArrayCurrentCount=count($HostIntrusionDetectionReportDatabaseReturncodeMessagesArray);
   $HostIntrusionDetectionIdsDatabaseReturncodeMessagesArrayDefaultCount=6; // Vorgabe: Anzahl der Array-Elemente
   $HostIntrusionDetectionIdsDatabaseReturncodeMessagesArrayCurrentCount=count($HostIntrusionDetectionIdsDatabaseReturncodeMessagesArray);
   $HostIntrusionDetectionExclusionDirectoryReturncodeMessagesArrayDefaultCount=5; // Vorgabe: Anzahl der Array-Elemente
   $HostIntrusionDetectionExclusionDirectoryReturncodeMessagesArrayCurrentCount=count($HostIntrusionDetectionExclusionDirectoryReturncodeMessagesArray);
   $HostIntrusionDetectionExclusionFileReturncodeMessagesArrayDefaultCount=5; // Vorgabe: Anzahl der Array-Elemente
   $HostIntrusionDetectionExclusionFileReturncodeMessagesArrayCurrentCount=count($HostIntrusionDetectionExclusionFileReturncodeMessagesArray);
   $HostIntrusionDetectionDatabaseCheckReturncodeMessagesArrayDefaultCount=7; // Vorgabe: Anzahl der Array-Elemente
   $HostIntrusionDetectionDatabaseCheckReturncodeMessagesArrayCurrentCount=count($HostIntrusionDetectionDatabaseCheckReturncodeMessagesArray);
   if(isset($ObelixFileNameArray) &&
      is_array($ObelixFileNameArray) &&
      $ObelixFileNameArrayDefaultCount == $ObelixFileNameArrayCurrentCount &&
      isset($HostIntrusionDetectionArray) &&
      is_array($HostIntrusionDetectionArray) &&
      $HostIntrusionDetectionArrayDefaultCount == $HostIntrusionDetectionArrayCurrentCount &&
      isset($HostIntrusionDetectionDetailsArray) &&
      is_array($HostIntrusionDetectionDetailsArray) &&
      $HostIntrusionDetectionDetailsArrayDefaultCount == $HostIntrusionDetectionDetailsArrayCurrentCount &&
      isset($HostIntrusionDetectionMessagesArray) &&
      is_array($HostIntrusionDetectionMessagesArray) &&
      $HostIntrusionDetectionMessagesArrayDefaultCount == $HostIntrusionDetectionMessagesArrayCurrentCount &&
      isset($HostIntrusionDetectionCreateDatabaseReturncodeMessagesArray) &&
      is_array($HostIntrusionDetectionCreateDatabaseReturncodeMessagesArray) &&
      $HostIntrusionDetectionCreateDatabaseReturncodeMessagesArrayDefaultCount == $HostIntrusionDetectionCreateDatabaseReturncodeMessagesArrayCurrentCount &&
      isset($HostIntrusionDetectionConfigurationDatabaseReturncodeMessagesArray) &&
      is_array($HostIntrusionDetectionConfigurationDatabaseReturncodeMessagesArray) &&
      $HostIntrusionDetectionConfigurationDatabaseReturncodeMessagesArrayDefaultCount == $HostIntrusionDetectionConfigurationDatabaseReturncodeMessagesArrayCurrentCount &&
      isset($HostIntrusionDetectionReportDatabaseReturncodeMessagesArray) &&
      is_array($HostIntrusionDetectionReportDatabaseReturncodeMessagesArray) &&
      $HostIntrusionDetectionReportDatabaseReturncodeMessagesArrayDefaultCount == $HostIntrusionDetectionReportDatabaseReturncodeMessagesArrayCurrentCount &&
      isset($HostIntrusionDetectionIdsDatabaseReturncodeMessagesArray) &&
      is_array($HostIntrusionDetectionIdsDatabaseReturncodeMessagesArray) &&
      $HostIntrusionDetectionIdsDatabaseReturncodeMessagesArrayDefaultCount == $HostIntrusionDetectionIdsDatabaseReturncodeMessagesArrayCurrentCount &&
      isset($HostIntrusionDetectionExclusionDirectoryReturncodeMessagesArray) &&
      is_array($HostIntrusionDetectionExclusionDirectoryReturncodeMessagesArray) &&
      $HostIntrusionDetectionExclusionDirectoryReturncodeMessagesArrayDefaultCount == $HostIntrusionDetectionExclusionDirectoryReturncodeMessagesArrayCurrentCount &&
      isset($HostIntrusionDetectionExclusionFileReturncodeMessagesArray) &&
      is_array($HostIntrusionDetectionExclusionFileReturncodeMessagesArray) &&
      $HostIntrusionDetectionExclusionFileReturncodeMessagesArrayDefaultCount == $HostIntrusionDetectionExclusionFileReturncodeMessagesArrayCurrentCount &&
      isset($HostIntrusionDetectionDatabaseCheckReturncodeMessagesArray) &&
      is_array($HostIntrusionDetectionDatabaseCheckReturncodeMessagesArray) &&
      $HostIntrusionDetectionDatabaseCheckReturncodeMessagesArrayDefaultCount == $HostIntrusionDetectionDatabaseCheckReturncodeMessagesArrayCurrentCount) {
      $HostIntrusionDetectionReadDatabaseDetailsArray=array();
      array_push($HostIntrusionDetectionReadDatabaseDetailsArray, $HostIntrusionDetectionDetailsArray[26], $HostIntrusionDetectionDetailsArray[27], $HostIntrusionDetectionDetailsArray[28], $HostIntrusionDetectionDetailsArray[29]);
      $HostIntrusionDetectionReadDatabaseMessagesArray=array();
      array_push($HostIntrusionDetectionReadDatabaseMessagesArray, $HostIntrusionDetectionMessagesArray[0], $HostIntrusionDetectionMessagesArray[1], $HostIntrusionDetectionMessagesArray[21]);
      if(!empty($HostIntrusionDetectionArray[1]) &&
         isset($HostIntrusionDetectionArray[5]) &&
         preg_match("/^[0-9]$/", $HostIntrusionDetectionArray[5])) {
         // IDS-Datenbank einlesen und ausgeben
         if(!empty($ObelixFileNameArray[13]) &&  is_dir($ObelixFileNameArray[13])) {
            if(isset($HostIntrusionDetectionDatabaseFilenameArray) &&
               is_array($HostIntrusionDetectionDatabaseFilenameArray) &&
               isset($HostIntrusionDetectionDatabaseDirectoryFileReportFilenameArray) &&
               is_array($HostIntrusionDetectionDatabaseDirectoryFileReportFilenameArray)) {
               $HostIntrusionDetectionCurrentReportDatabaseFilepath = $ObelixFileNameArray[13] . "/" . $HostIntrusionDetectionDatabaseDirectoryFileReportFilenameArray[$HostIntrusionDetectionArray[5]];
               $HostIntrusionDetectionCurrentDatabaseFilepath = $ObelixFileNameArray[13] . "/" . $HostIntrusionDetectionDatabaseFilenameArray[$HostIntrusionDetectionArray[5]];
               if(file_exists($HostIntrusionDetectionCurrentDatabaseFilepath) &&
                  is_readable($HostIntrusionDetectionCurrentDatabaseFilepath) &&
                  file_exists($HostIntrusionDetectionCurrentReportDatabaseFilepath) &&
                  is_readable($HostIntrusionDetectionCurrentReportDatabaseFilepath)) {
                  $ReturnCodeDatabaseReadArray = host_intrusion_detection_read_database($HostIntrusionDetectionCurrentDatabaseFilepath, $HostIntrusionDetectionCurrentReportDatabaseFilepath, $HostIntrusionDetectionArray, $HostIntrusionDetectionGeneralSurveyTitlesArray, $HostIntrusionDetectionResultTableTitlesArray, $HostIntrusionDetectionMd5StatusNoteArray, $HostIntrusionDetectionReadDatabaseDetailsArray, $HostIntrusionDetectionReadDatabaseMessagesArray);
                  if(is_array($ReturnCodeDatabaseReadArray) &&
                     !empty($ReturnCodeDatabaseReadArray[1]) &&
                     $ReturnCodeDatabaseReadArray[1] == 1 &&
                     !empty($ReturnCodeDatabaseReadArray[2])) {
                     $HostIntrusionDetectionDatabaseOutputHtml .= $ReturnCodeDatabaseReadArray[2];
                     if(isset($ReturnCodeDatabaseReadArray[0]) &&
                        preg_match("/^[0-9]$/", $ReturnCodeDatabaseReadArray[0]) &&
                        $ReturnCodeDatabaseReadArray[0] != 1 &&
                        is_array($HostIntrusionDetectionReportDatabaseReturncodeMessagesArray) &&
                        isset($HostIntrusionDetectionReportDatabaseReturncodeMessagesArray[$ReturnCodeDatabaseReadArray[0]])) {
                        $HostIntrusionDetectionMessagesHtml .="        <tr>\n";
                        $HostIntrusionDetectionMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $HostIntrusionDetectionReportDatabaseReturncodeMessagesArray[$ReturnCodeDatabaseReadArray[0]] . "</td>\n";
                        $HostIntrusionDetectionMessagesHtml .="        </tr>\n";
                        $OutputMessagesHtml=1;
                     }
                  }
                  else
                  {
                     $HostIntrusionDetectionMessagesHtml .="        <tr>\n";
                     $HostIntrusionDetectionMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $HostIntrusionDetectionMessagesArray[26] . "</td>\n";
                     $HostIntrusionDetectionMessagesHtml .="        </tr>\n";
                     if(isset($ReturnCodeDatabaseReadArray[0]) &&
                        preg_match("/^[0-9]$/", $ReturnCodeDatabaseReadArray[0]) &&
                        $ReturnCodeDatabaseReadArray[0] != 1 &&
                        is_array($HostIntrusionDetectionReportDatabaseReturncodeMessagesArray) &&
                        isset($HostIntrusionDetectionReportDatabaseReturncodeMessagesArray[$ReturnCodeDatabaseReadArray[0]])) {
                        $HostIntrusionDetectionMessagesHtml .="        <tr>\n";
                        $HostIntrusionDetectionMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $HostIntrusionDetectionReportDatabaseReturncodeMessagesArray[$ReturnCodeDatabaseReadArray[0]] . "</td>\n";
                        $HostIntrusionDetectionMessagesHtml .="        </tr>\n";
                     }
                     if(is_array($ReturnCodeDatabaseReadArray) &&
                        isset($ReturnCodeDatabaseReadArray[1]) &&
                        preg_match("/^[0-9]$/", $ReturnCodeDatabaseReadArray[1]) &&
                        $ReturnCodeDatabaseReadArray[1] != 1 &&
                        is_array($HostIntrusionDetectionIdsDatabaseReturncodeMessagesArray) &&
                        isset($HostIntrusionDetectionIdsDatabaseReturncodeMessagesArray[$ReturnCodeDatabaseReadArray[1]])) {
                        $HostIntrusionDetectionMessagesHtml .="        <tr>\n";
                        $HostIntrusionDetectionMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $HostIntrusionDetectionIdsDatabaseReturncodeMessagesArray[$ReturnCodeDatabaseReadArray[1]] . "</td>\n";
                        $HostIntrusionDetectionMessagesHtml .="        </tr>\n";
                     }
                     $OutputMessagesHtml=1;
                  }
                  if(!empty($HostIntrusionDetectionArray[7]) && preg_match("/^[1-2]$/", $HostIntrusionDetectionArray[7])) {
                     if($HostIntrusionDetectionArray[7] == 1) {
                        $HostIntrusionDetectionOptionUpdateChecked='';
                        $HostIntrusionDetectionOptionUpgradeChecked=" checked";
                     } elseif($HostIntrusionDetectionArray[7] == 2) {
                        $HostIntrusionDetectionOptionUpdateChecked='';
                        $HostIntrusionDetectionOptionDeleteChecked=" checked";
                     }
                     else
                     {
                     $HostIntrusionDetectionOptionUpdateChecked=" checked";
                     }
                  }
               } elseif(file_exists($HostIntrusionDetectionCurrentDatabaseFilepath) && !is_readable($HostIntrusionDetectionCurrentDatabaseFilepath)) {
                  $HostIntrusionDetectionMessagesHtml .="        <tr>\n";
                  $HostIntrusionDetectionMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $HostIntrusionDetectionMessagesArray[12] . "</td>\n";
                  $HostIntrusionDetectionMessagesHtml .="        </tr>\n";
                  $OutputMessagesHtml=1;
               } elseif(file_exists($HostIntrusionDetectionCurrentReportDatabaseFilepath) && !is_readable($HostIntrusionDetectionCurrentReportDatabaseFilepath)) {
                  $HostIntrusionDetectionMessagesHtml .="        <tr>\n";
                  $HostIntrusionDetectionMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $HostIntrusionDetectionMessagesArray[12] . "</td>\n";
                  $HostIntrusionDetectionMessagesHtml .="        </tr>\n";
                  $OutputMessagesHtml=1;
               }
               else
               {
                  $HostIntrusionDetectionMessagesHtml .="        <tr>\n";
                  $HostIntrusionDetectionMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $HostIntrusionDetectionMessagesArray[14] . "</td>\n";
                  $HostIntrusionDetectionMessagesHtml .="        </tr>\n";
                  $OutputMessagesHtml=1;
               }
            } elseif(!isset($HostIntrusionDetectionDatabaseFilenameArray) || !is_array($HostIntrusionDetectionDatabaseFilenameArray)) {
               print 'NOTE: SYSTEM-ARRAY HostIntrusionDetectionDatabaseFilenameArray - function <strong>create_host_intrusion_detection</strong> - IS DAMAGED!';
               exit;
            }
            else
            {
               print 'NOTE: SYSTEM-ARRAY HostIntrusionDetectionDatabaseDirectoryFileReportFilenameArray - function <strong>create_host_intrusion_detection</strong> - IS DAMAGED!';
               exit;
            }
         }
         else
         {
            $HostIntrusionDetectionMessagesHtml .="        <tr>\n";
            $HostIntrusionDetectionMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $HostIntrusionDetectionMessagesArray[11] . "</td>\n";
            $HostIntrusionDetectionMessagesHtml .="        </tr>\n";
            $OutputMessagesHtml=1;
         }
         if(!empty($OutputMessagesHtml)) {
            $HostIntrusionDetectionMessagesHtml .="        <tr>\n";
            $HostIntrusionDetectionMessagesHtml .="          <td colspan=\"3\"><hr></td>\n";
            $HostIntrusionDetectionMessagesHtml .="        </tr>\n";
         }
      } elseif(!empty($HostIntrusionDetectionArray[2]) &&
         isset($HostIntrusionDetectionArray[3]) &&
         preg_match("@^(\./|\.\./).+@", $HostIntrusionDetectionArray[3]) &&
         is_dir($HostIntrusionDetectionArray[3]) &&
         is_readable($HostIntrusionDetectionArray[3]) &&
         !empty($HostIntrusionDetectionArray[4]) &&
         preg_match("/^([1-9]|[1][0-2])$/", $HostIntrusionDetectionArray[4]) &&
         isset($HostIntrusionDetectionArray[5]) &&
         preg_match("/^[0-9]$/", $HostIntrusionDetectionArray[5]) &&
         isset($HostIntrusionDetectionArray[6]) &&
         isset($HostIntrusionDetectionArray[8]) &&
         isset($HostIntrusionDetectionArray[9])) {
         // IDS-Datenbank aktualisieren und ausgeben
         $CurrentIdsDatabaseNumber = $HostIntrusionDetectionArray[5] + 1;
         if(!empty($ObelixFileNameArray[13]) &&
            is_dir($ObelixFileNameArray[13]) &&
            is_writeable($ObelixFileNameArray[13])) {
            if(isset($HostIntrusionDetectionDatabaseFilenameArray) &&
               is_array($HostIntrusionDetectionDatabaseFilenameArray) &&
               isset($HostIntrusionDetectionDatabaseFilenameArray[$HostIntrusionDetectionArray[5]]) &&
               isset($HostIntrusionDetectionDatabaseFieldnameArray) &&
               is_array($HostIntrusionDetectionDatabaseFieldnameArray) &&
               isset($HostIntrusionDetectionDatabaseCharCountArray) &&
               is_array($HostIntrusionDetectionDatabaseCharCountArray) &&
               isset($HostIntrusionDetectionDatabaseConfigurationFilenameArray) &&
               is_array($HostIntrusionDetectionDatabaseConfigurationFilenameArray) &&
               isset($HostIntrusionDetectionDatabaseConfigurationFilenameArray[$HostIntrusionDetectionArray[5]]) &&
               isset($DatabaseFieldnameConfigurationArray) &&
               is_array($DatabaseFieldnameConfigurationArray) &&
               isset($DatabaseCharCountConfigurationArray) &&
               is_array($DatabaseCharCountConfigurationArray) &&
               isset($HostIntrusionDetectionDatabaseDirectoryFileReportFilenameArray) &&
               is_array($HostIntrusionDetectionDatabaseDirectoryFileReportFilenameArray) &&
               isset($HostIntrusionDetectionDatabaseDirectoryFileReportFilenameArray[$HostIntrusionDetectionArray[5]]) &&
               isset($DatabaseFieldnameDirectoryFileReportArray) &&
               is_array($DatabaseFieldnameDirectoryFileReportArray) &&
               isset($DatabaseCharCountDirectoryFileReportArray) &&
               is_array($DatabaseCharCountDirectoryFileReportArray) &&
               isset($HostIntrusionDetectionDatabaseDirectoryExclusionArray) &&
               is_array($HostIntrusionDetectionDatabaseDirectoryExclusionArray) &&
               isset($HostIntrusionDetectionDatabaseDirectoryExclusionArray[$HostIntrusionDetectionArray[5]]) &&
               isset($DatabaseFieldnameDirectoryExclusionArray) &&
               is_array($DatabaseFieldnameDirectoryExclusionArray) &&
               isset($DatabaseCharCountDirectoryExclusionArray) &&
               is_array($DatabaseCharCountDirectoryExclusionArray) &&
               isset($HostIntrusionDetectionDatabaseFileExclusionArray) &&
               is_array($HostIntrusionDetectionDatabaseFileExclusionArray) &&
               isset($HostIntrusionDetectionDatabaseFileExclusionArray[$HostIntrusionDetectionArray[5]]) &&
               isset($DatabaseFieldnameFileExclusionArray) &&
               is_array($DatabaseFieldnameFileExclusionArray) &&
               isset($DatabaseCharCountFileExclusionArray) &&
               is_array($DatabaseCharCountFileExclusionArray)) {
               $HostIntrusionDetectionCurrentDatabaseDeleteArray=array();
               $HostIntrusionDetectionCurrentDatabaseFilepath = $ObelixFileNameArray[13] . "/" . $HostIntrusionDetectionDatabaseFilenameArray[$HostIntrusionDetectionArray[5]];
               $HostIntrusionDetectionCurrentConfigurationDatabaseFilepath = $ObelixFileNameArray[13] . "/" . $HostIntrusionDetectionDatabaseConfigurationFilenameArray[$HostIntrusionDetectionArray[5]];
               $HostIntrusionDetectionCurrentReportDatabaseFilepath = $ObelixFileNameArray[13] . "/" . $HostIntrusionDetectionDatabaseDirectoryFileReportFilenameArray[$HostIntrusionDetectionArray[5]];
               $HostIntrusionDetectionCurrentDirectoryExclusionFilepath = $ObelixFileNameArray[13] . "/" . $HostIntrusionDetectionDatabaseDirectoryExclusionArray[$HostIntrusionDetectionArray[5]];
               $HostIntrusionDetectionCurrentFileExclusionFilepath = $ObelixFileNameArray[13] . "/" . $HostIntrusionDetectionDatabaseFileExclusionArray[$HostIntrusionDetectionArray[5]];
               array_push($HostIntrusionDetectionCurrentDatabaseDeleteArray, $HostIntrusionDetectionCurrentDatabaseFilepath, $HostIntrusionDetectionCurrentConfigurationDatabaseFilepath, $HostIntrusionDetectionCurrentReportDatabaseFilepath, $HostIntrusionDetectionCurrentDirectoryExclusionFilepath, $HostIntrusionDetectionCurrentFileExclusionFilepath);
               if(file_exists($HostIntrusionDetectionCurrentDatabaseFilepath) && is_writeable($HostIntrusionDetectionCurrentDatabaseFilepath)) {
                  if(isset($HostIntrusionDetectionArray[7]) && $HostIntrusionDetectionArray[7] == '') $HostIntrusionDetectionArray[7]=0;
                  if(isset($HostIntrusionDetectionArray[7]) &&
                     preg_match("/^[0]$/", $HostIntrusionDetectionArray[7]) &&
                     isset($HostIntrusionDetectionCurrentDatabaseDeleteArray) &&
                     is_array($HostIntrusionDetectionCurrentDatabaseDeleteArray) &&
                     !empty($HostIntrusionDetectionDetailsArray[25])) {
                     // Aktualisierung der IDS-Datenbank
                     if(!file_exists($HostIntrusionDetectionCurrentDirectoryExclusionFilepath)) {
                        // Erstellung der Datei fuer die Datenbank mit den auszuschlieszenden Verzeichnissen
                        if(!empty($HostIntrusionDetectionArray[8]) && is_array($HostIntrusionDetectionArray[8])) {
                           $HostIntrusionDetectionDirectoryExclusionCount = count($HostIntrusionDetectionArray[8]);
                           for($y=0; $y<$HostIntrusionDetectionDirectoryExclusionCount; $y++) {
                              $CurrentDirectoryExclusion = trim($HostIntrusionDetectionArray[8][$y]);
                              if(!empty($CurrentDirectoryExclusion)) {
                                 if(!empty($HostIntrusionDetectionDetailsArray[25])) {
                                    $CreateDirectoryExclusionDatabaseReturnCode = host_intrusion_detection_create_database($HostIntrusionDetectionCurrentDirectoryExclusionFilepath, $HostIntrusionDetectionDetailsArray[25], $DatabaseFieldnameDirectoryExclusionArray, $DatabaseCharCountDirectoryExclusionArray);
                                    if(preg_match("/^[0-9]$/", $CreateDirectoryExclusionDatabaseReturnCode) && $CreateDirectoryExclusionDatabaseReturnCode != 1) {
                                       $HostIntrusionDetectionMessagesHtml .="        <tr>\n";
                                       $HostIntrusionDetectionMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $HostIntrusionDetectionMessagesArray[9] . "</td>\n";
                                       $HostIntrusionDetectionMessagesHtml .="        </tr>\n";
                                       if(is_array($HostIntrusionDetectionCreateDatabaseReturncodeMessagesArray) && isset($HostIntrusionDetectionCreateDatabaseReturncodeMessagesArray[$CreateDirectoryExclusionDatabaseReturnCode])) {
                                          $HostIntrusionDetectionMessagesHtml .="        <tr>\n";
                                          $HostIntrusionDetectionMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $HostIntrusionDetectionCreateDatabaseReturncodeMessagesArray[$CreateDirectoryExclusionDatabaseReturnCode] . "</td>\n";
                                          $HostIntrusionDetectionMessagesHtml .="        </tr>\n";
                                       }
                                       $CreateNotSuccessful=1;
                                       $OutputMessagesHtml=1;
                                       break;
                                    }
                                    break;
                                 }
                                 else
                                 {
                                    print 'NOTE 1: SYSTEM-VARIABLE HostIntrusionDetectionFileAccess - function <strong>create_host_intrusion_detection</strong> - IS DAMAGED!';
                                    exit;
                                 }
                              }
                           }
                        }
                     } elseif(file_exists($HostIntrusionDetectionCurrentDirectoryExclusionFilepath)) {
                        // Loeschung der Datei fuer die Datenbank mit den auszuschlieszenden Verzeichnissen
                        if(!empty($HostIntrusionDetectionArray[8]) && is_array($HostIntrusionDetectionArray[8])) {
                           $HostIntrusionDetectionDirectoryExclusionCount = count($HostIntrusionDetectionArray[8]);
                           for($y=0; $y<$HostIntrusionDetectionDirectoryExclusionCount; $y++) {
                              $CurrentDirectoryExclusion = trim($HostIntrusionDetectionArray[8][$y]);
                              if(!empty($CurrentDirectoryExclusion)) {
                                 $CurrentDirectoryExclusionFileDeletePermission=0;
                                 break;
                              }
                              else
                              {
                              $CurrentDirectoryExclusionFileDeletePermission=1;
                              }
                           }
                           if(!empty($CurrentDirectoryExclusionFileDeletePermission)) {
                              @unlink($HostIntrusionDetectionCurrentDirectoryExclusionFilepath);
                              if(file_exists($HostIntrusionDetectionCurrentDirectoryExclusionFilepath)) {
                                 $HostIntrusionDetectionMessagesHtml .="        <tr>\n";
                                 $HostIntrusionDetectionMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $HostIntrusionDetectionMessagesArray[24] . "</td>\n";
                                 $HostIntrusionDetectionMessagesHtml .="        </tr>\n";
                                 $CreateNotSuccessful=1;
                                 $OutputMessagesHtml=1;
                              }
                           }
                        }
                     }
                     if(!file_exists($HostIntrusionDetectionCurrentFileExclusionFilepath)) {
                        // Erstellung der Datei fuer die Datenbank mit den auszuschlieszenden Dateien
                        if(!empty($HostIntrusionDetectionArray[9]) && is_array($HostIntrusionDetectionArray[9])) {
                           $HostIntrusionDetectionFileExclusionCount = count($HostIntrusionDetectionArray[9]);
                           for($y=0; $y<$HostIntrusionDetectionFileExclusionCount; $y++) {
                              $CurrentFileExclusion = trim($HostIntrusionDetectionArray[9][$y]);
                              if(!empty($CurrentFileExclusion)) {
                                 if(!empty($HostIntrusionDetectionDetailsArray[25])) {
                                    $CreateFileExclusionDatabaseReturnCode = host_intrusion_detection_create_database($HostIntrusionDetectionCurrentFileExclusionFilepath, $HostIntrusionDetectionDetailsArray[25], $DatabaseFieldnameFileExclusionArray, $DatabaseCharCountFileExclusionArray);
                                    if(preg_match("/^[0-9]$/", $CreateFileExclusionDatabaseReturnCode) && $CreateFileExclusionDatabaseReturnCode != 1) {
                                       $HostIntrusionDetectionMessagesHtml .="        <tr>\n";
                                       $HostIntrusionDetectionMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $HostIntrusionDetectionMessagesArray[9] . "</td>\n";
                                       $HostIntrusionDetectionMessagesHtml .="        </tr>\n";
                                       if(is_array($HostIntrusionDetectionCreateDatabaseReturncodeMessagesArray) && isset($HostIntrusionDetectionCreateDatabaseReturncodeMessagesArray[$CreateFileExclusionDatabaseReturnCode])) {
                                          $HostIntrusionDetectionMessagesHtml .="        <tr>\n";
                                          $HostIntrusionDetectionMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $HostIntrusionDetectionCreateDatabaseReturncodeMessagesArray[$CreateFileExclusionDatabaseReturnCode] . "</td>\n";
                                          $HostIntrusionDetectionMessagesHtml .="        </tr>\n";
                                       }
                                       $CreateNotSuccessful=1;
                                       $OutputMessagesHtml=1;
                                       break;
                                    }
                                    break;
                                  }
                                  else
                                  {
                                     print 'NOTE 2: SYSTEM-VARIABLE HostIntrusionDetectionFileAccess - function <strong>create_host_intrusion_detection</strong> - IS DAMAGED!';
                                     exit;
                                  }
                              }
                           }
                        }
                     } elseif(file_exists($HostIntrusionDetectionCurrentFileExclusionFilepath)) {
                        // Loeschung der Datei fuer die Datenbank mit den auszuschlieszenden Dateien
                        if(!empty($HostIntrusionDetectionArray[9]) && is_array($HostIntrusionDetectionArray[9])) {
                           $HostIntrusionDetectionFileExclusionCount = count($HostIntrusionDetectionArray[9]);
                           for($y=0; $y<$HostIntrusionDetectionFileExclusionCount; $y++) {
                              $CurrentFileExclusion = trim($HostIntrusionDetectionArray[9][$y]);
                              if(!empty($CurrentFileExclusion)) {
                                 $CurrentFileExclusionFileDeletePermission=0;
                                 break;
                              }
                              else
                              {
                              $CurrentFileExclusionFileDeletePermission=1;
                              }
                           }
                           if(!empty($CurrentFileExclusionFileDeletePermission)) {
                              @unlink($HostIntrusionDetectionCurrentFileExclusionFilepath);
                              if(file_exists($HostIntrusionDetectionCurrentFileExclusionFilepath)) {
                                 $HostIntrusionDetectionMessagesHtml .="        <tr>\n";
                                 $HostIntrusionDetectionMessagesHtml .="          <td colspan=\"3\" class=\"red\">" . $HostIntrusionDetectionMessagesArray[25] . "</td>\n";
                                 $HostIntrusionDetectionMessagesHtml .="        </tr>\n";
                                 $CreateNotSuccessful=1;
                                 $OutputMessagesHtml=1;
                              }
                           }
                        }
                     }
                     if(empty($CreateNotSuccessful)) {
                        // Aktualsierung der IDS-Datenbank
                        $ReturnCodeDatabaseUpdatingArray = host_intrusion_detection_updating_database($HostIntrusionDetectionCurrentDatabaseFilepath, $HostIntrusionDetectionCurrentConfigurationDatabaseFilepath, $HostIntrusionDetectionCurrentReportDatabaseFilepath, $HostIntrusionDetectionCurrentDirectoryExclusionFilepath, $HostIntrusionDetectionCurrentFileExclusionFilepath, $HostIntrusionDetectionArray, $CurrentIdsDatabaseNumber);
                        $HostIntrusionDetectionArray[5] = $CurrentIdsDatabaseNumber - 1;
                        if(is_array($ReturnCodeDatabaseUpdatingArray) &&
                           !empty($ReturnCodeDatabaseUpdatingArray[2]) &&
                           $ReturnCodeDatabaseUpdatingArray[2] == 1) {
                           if(file_exists($HostIntrusionDetectionCurrentDatabaseFilepath) && is_readable($HostIntrusionDetectionCurrentDatabaseFilepath)) {
                              if(file_exists($HostIntrusionDetectionCurrentConfigurationDatabaseFilepath)) {
                                 if(isset($ReturnCodeDatabaseUpdatingArray[0]) &&
                                    preg_match("/^[0-9]$/", $ReturnCodeDatabaseUpdatingArray[0]) &&
                                    $ReturnCodeDatabaseUpdatingArray[0] != 1) {
                                    if(is_array($HostIntrusionDetectionConfigurationDatabaseReturncodeMessagesArray) && isset($HostIntrusionDetectionConfigurationDatabaseReturncodeMessagesArray[$ReturnCodeDatabaseUpdatingArray[0]])) {
                                       $HostIntrusionDetectionMessagesHtml .="        <tr>\n";
                                       $HostIntrusionDetectionMessagesHtml .="          <td colspan=\"3\" class=\"red\">" .  $HostIntrusionDetectionConfigurationDatabaseReturncodeMessagesArray[$ReturnCodeDatabaseUpdatingArray[0]] . "</td>\n";
                                       $HostIntrusionDetectionMessagesHtml .="        </tr>\n";
                                       $OutputMessagesHtml=1;
                                    }
                                    else
                                    {
                                       print 'NOTE 2: SYSTEM-ARRAY HostIntrusionDetectionConfigurationDatabaseReturncodeMessagesArray - function <strong>create_host_intrusion_detection</strong> - IS DAMAGED!';
                                       exit;
                                    }
                                 }
                              }
                              else
                              {
                                  print 'NOTE 2: SYSTEM-FILE ' .  $HostIntrusionDetectionCurrentConfigurationDatabaseFilepath . ' - function <strong>create_host_intrusion_detection</strong> - NOT FOUND!';
                                  exit;
                              }
                              if(file_exists($HostIntrusionDetectionCurrentReportDatabaseFilepath)) {
                                 if(isset($ReturnCodeDatabaseUpdatingArray[1]) &&
                                    preg_match("/^[0-9]$/", $ReturnCodeDatabaseUpdatingArray[1]) &&
                                    $ReturnCodeDatabaseUpdatingArray[1] != 1) {
                                    if(is_array($HostIntrusionDetectionReportDatabaseReturncodeMessagesArray) && isset($HostIntrusionDetectionReportDatabaseReturncodeMessagesArray[$ReturnCodeDatabaseUpdatingArray[1]])) {
                                       $HostIntrusionDetectionMessagesHtml .="        <tr>\n";
                                       $HostIntrusionDetectionMessagesHtml .="          <td colspan=\"3\" class=\"red\">" .  $HostIntrusionDetectionReportDatabaseReturncodeMessagesArray[$ReturnCodeDatabaseUpdatingArray[1]] . "</td>\n";
                                       $HostIntrusionDetectionMessagesHtml .="        </tr>\n";
                                       $OutputMessagesHtml=1;
                                    }
                                    else
                                    {
                                       print 'NOTE 3: SYSTEM-ARRAY HostIntrusionDetectionReportDatabaseReturncodeMessagesArray - function <strong>create_host_intrusion_detection</strong> - IS DAMAGED!';
                                       exit;
                                    }
                                 }
                              }
                              else
                              {
                                  print 'NOTE 3: SYSTEM-FILE ' .  $HostIntrusionDetectionCurrentReportDatabaseFilepath . ' - function <strong>create_host_intrusion_detection</strong> - NOT FOUND!';
                                  exit;
                              }
                              if(file_exists($HostIntrusionDetectionCurrentDirectoryExclusionFilepath)) {
                                 if(isset($ReturnCodeDatabaseUpdatingArray[3]) &&
                                    preg_match("/^[0-9]$/"